//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Projection/ProjectionsEditorCanvas.h
//! @brief     Defines class ProjectionsEditorCanvas
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PROJECTION_PROJECTIONSEDITORCANVAS_H
#define BORNAGAIN_GUI_VIEW_PROJECTION_PROJECTIONSEDITORCANVAS_H

#include "GUI/View/Mask/MaskEditorFlags.h"
#include <QItemSelectionModel>
#include <QModelIndex>
#include <QWidget>

class MaskGraphicsScene;
class MaskGraphicsView;
class IntensityDataItem;
class ColorMap;
class PlotStatusLabel;
class MaskItem;
class MaskItemObject;

//! Holds a graphics scene to draw projections on top of ColorMap. Being a part
//! of ProjectionEditor, provides interaction logic between graphics scene and ProjectionsWidget.

//! Particularly, it creates temporary ProjectionItem in projection container, when mouse
//! is inside ColorMap viewport.

class ProjectionsEditorCanvas : public QWidget {
    Q_OBJECT

public:
    ProjectionsEditorCanvas(QWidget* parent = nullptr);

    void setContext(IntensityDataItem* intensityItem);
    void resetContext();

signals:
    void changeProjectionsTabRequest(MaskEditorFlags::Activity);
    void changeActivityRequest(MaskEditorFlags::Activity);
    void deleteSelectedRequest();
    void marginsChanged(double left, double right);

public slots:
    void onEnteringColorMap();
    void onLeavingColorMap();
    void onPositionChanged(double x, double y);
    void onResetViewRequest();
    void onActivityModeChanged(MaskEditorFlags::Activity value);

private:
    void onLineItemMoved(MaskItemObject* sender);
    void setColorMap(ColorMap* colorMap);
    void setConnected(bool isConnected);

    MaskGraphicsScene* m_scene;
    MaskGraphicsView* m_view;
    ColorMap* m_colorMap;
    PlotStatusLabel* m_statusLabel;

    std::unique_ptr<MaskItem> m_liveProjection; //!< temporary projection item matching mouse move
    IntensityDataItem* m_intensityDataItem;

    MaskEditorFlags::Activity m_currentActivity;
    bool m_block_update = false;
};

#endif // BORNAGAIN_GUI_VIEW_PROJECTION_PROJECTIONSEDITORCANVAS_H
