//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Util/Path.h
//! @brief     Defines class Helpers functions
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_SUPPORT_UTIL_PATH_H
#define BORNAGAIN_GUI_SUPPORT_UTIL_PATH_H

#include <QString>

class QModelIndex;

namespace GUI::Base::Path {

QString withTildeHomePath(const QString& path);

QString getBornAgainVersionString();

QString getValidFileName(const QString& proposed_name);

QString fileDir(const QString& fileName);
QString baseName(const QString& fileName);

bool parseVersion(const QString& version, int& major_num, int& minor_num);

int versionCode(const QString& version);

bool isVersionMatchMinimal(const QString& version, const QString& minimal_version);

//! The folder where persistent application data shall be stored.
//! Under Windows this is the AppData/Roaming location.
//! Used e.g. for storing the instrument library.
QString appDataFolder();

QString getPathFromIndex(const QModelIndex& index);

} // namespace GUI::Base::Path

#endif // BORNAGAIN_GUI_SUPPORT_UTIL_PATH_H
