//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Device/IO/ParseUtil.h
//! @brief     Defines class DatafieldIOFactory.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_DEVICE_IO_PARSEUTIL_H
#define BORNAGAIN_DEVICE_IO_PARSEUTIL_H

#include <string>
#include <vector>

class Scale;
class Datafield;

//! Utility functions for data input and output.

namespace Util::Parse {

Scale* parseScale(std::istream& input_stream);

void fillDatafield(Datafield* data, std::istream& input_stream);

std::vector<double> parse_doubles(const std::string& str);

double ignoreDenormalized(double value);

} // namespace Util::Parse

#endif // BORNAGAIN_DEVICE_IO_PARSEUTIL_H
