import builtins
import typing

from gi.repository import GLib
from gi.repository import GObject


class Action(GObject.GInterface):

    def activate(self, parameter: typing.Optional[GLib.Variant]) -> None: ...

    def change_state(self, value: GLib.Variant) -> None: ...

    def get_enabled(self) -> builtins.bool: ...

    def get_name(self) -> builtins.str: ...

    def get_parameter_type(self) -> typing.Optional[GLib.VariantType]: ...

    def get_state(self) -> GLib.Variant: ...

    def get_state_hint(self) -> typing.Optional[GLib.Variant]: ...

    def get_state_type(self) -> typing.Optional[GLib.VariantType]: ...

    @staticmethod
    def name_is_valid(action_name: builtins.str) -> builtins.bool: ...

    @staticmethod
    def parse_detailed_name(detailed_name: builtins.str) -> typing.Tuple[builtins.bool, builtins.str, GLib.Variant]: ...

    @staticmethod
    def print_detailed_name(action_name: builtins.str, target_value: typing.Optional[GLib.Variant]) -> builtins.str: ...

    def do_activate(self, parameter: typing.Optional[GLib.Variant]) -> None: ...

    def do_change_state(self, value: GLib.Variant) -> None: ...

    def do_get_enabled(self) -> builtins.bool: ...

    def do_get_name(self) -> builtins.str: ...

    def do_get_parameter_type(self) -> typing.Optional[GLib.VariantType]: ...

    def do_get_state(self) -> GLib.Variant: ...

    def do_get_state_hint(self) -> typing.Optional[GLib.Variant]: ...

    def do_get_state_type(self) -> typing.Optional[GLib.VariantType]: ...


class ActionGroup(GObject.GInterface):

    def action_added(self, action_name: builtins.str) -> None: ...

    def action_enabled_changed(self, action_name: builtins.str, enabled: builtins.bool) -> None: ...

    def action_removed(self, action_name: builtins.str) -> None: ...

    def action_state_changed(self, action_name: builtins.str, state: GLib.Variant) -> None: ...

    def activate_action(self, action_name: builtins.str, parameter: typing.Optional[GLib.Variant]) -> None: ...

    def change_action_state(self, action_name: builtins.str, value: GLib.Variant) -> None: ...

    def get_action_enabled(self, action_name: builtins.str) -> builtins.bool: ...

    def get_action_parameter_type(self, action_name: builtins.str) -> typing.Optional[GLib.VariantType]: ...

    def get_action_state(self, action_name: builtins.str) -> typing.Optional[GLib.Variant]: ...

    def get_action_state_hint(self, action_name: builtins.str) -> typing.Optional[GLib.Variant]: ...

    def get_action_state_type(self, action_name: builtins.str) -> typing.Optional[GLib.VariantType]: ...

    def has_action(self, action_name: builtins.str) -> builtins.bool: ...

    def list_actions(self) -> typing.Sequence[builtins.str]: ...

    def query_action(self, action_name: builtins.str) -> typing.Tuple[builtins.bool, builtins.bool, GLib.VariantType, GLib.VariantType, GLib.Variant, GLib.Variant]: ...

    def do_action_added(self, action_name: builtins.str) -> None: ...

    def do_action_enabled_changed(self, action_name: builtins.str, enabled: builtins.bool) -> None: ...

    def do_action_removed(self, action_name: builtins.str) -> None: ...

    def do_action_state_changed(self, action_name: builtins.str, state: GLib.Variant) -> None: ...

    def do_activate_action(self, action_name: builtins.str, parameter: typing.Optional[GLib.Variant]) -> None: ...

    def do_change_action_state(self, action_name: builtins.str, value: GLib.Variant) -> None: ...

    def do_get_action_enabled(self, action_name: builtins.str) -> builtins.bool: ...

    def do_get_action_parameter_type(self, action_name: builtins.str) -> typing.Optional[GLib.VariantType]: ...

    def do_get_action_state(self, action_name: builtins.str) -> typing.Optional[GLib.Variant]: ...

    def do_get_action_state_hint(self, action_name: builtins.str) -> typing.Optional[GLib.Variant]: ...

    def do_get_action_state_type(self, action_name: builtins.str) -> typing.Optional[GLib.VariantType]: ...

    def do_has_action(self, action_name: builtins.str) -> builtins.bool: ...

    def do_list_actions(self) -> typing.Sequence[builtins.str]: ...

    def do_query_action(self, action_name: builtins.str) -> typing.Tuple[builtins.bool, builtins.bool, GLib.VariantType, GLib.VariantType, GLib.Variant, GLib.Variant]: ...


class ActionMap(GObject.GInterface):

    def add_action(self, action: Action) -> None: ...

    def add_action_entries(self, entries: typing.Sequence[ActionEntry], user_data: typing.Optional[builtins.object]) -> None: ...

    def lookup_action(self, action_name: builtins.str) -> Action: ...

    def remove_action(self, action_name: builtins.str) -> None: ...

    def do_add_action(self, action: Action) -> None: ...

    def do_lookup_action(self, action_name: builtins.str) -> Action: ...

    def do_remove_action(self, action_name: builtins.str) -> None: ...


class AppInfo(GObject.GInterface):

    def add_supports_type(self, content_type: builtins.str) -> builtins.bool: ...

    def can_delete(self) -> builtins.bool: ...

    def can_remove_supports_type(self) -> builtins.bool: ...

    @staticmethod
    def create_from_commandline(commandline: builtins.str, application_name: typing.Optional[builtins.str], flags: AppInfoCreateFlags) -> AppInfo: ...

    def delete(self) -> builtins.bool: ...

    def dup(self) -> AppInfo: ...

    def equal(self, appinfo2: AppInfo) -> builtins.bool: ...

    @staticmethod
    def get_all() -> typing.Sequence[AppInfo]: ...

    @staticmethod
    def get_all_for_type(content_type: builtins.str) -> typing.Sequence[AppInfo]: ...

    def get_commandline(self) -> builtins.str: ...

    @staticmethod
    def get_default_for_type(content_type: builtins.str, must_support_uris: builtins.bool) -> AppInfo: ...

    @staticmethod
    def get_default_for_uri_scheme(uri_scheme: builtins.str) -> AppInfo: ...

    def get_description(self) -> builtins.str: ...

    def get_display_name(self) -> builtins.str: ...

    def get_executable(self) -> builtins.str: ...

    @staticmethod
    def get_fallback_for_type(content_type: builtins.str) -> typing.Sequence[AppInfo]: ...

    def get_icon(self) -> Icon: ...

    def get_id(self) -> builtins.str: ...

    def get_name(self) -> builtins.str: ...

    @staticmethod
    def get_recommended_for_type(content_type: builtins.str) -> typing.Sequence[AppInfo]: ...

    def get_supported_types(self) -> typing.Sequence[builtins.str]: ...

    def launch(self, files: typing.Optional[typing.Sequence[File]], context: typing.Optional[AppLaunchContext]) -> builtins.bool: ...

    @staticmethod
    def launch_default_for_uri(uri: builtins.str, context: typing.Optional[AppLaunchContext]) -> builtins.bool: ...

    @staticmethod
    def launch_default_for_uri_async(uri: builtins.str, context: typing.Optional[AppLaunchContext], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    @staticmethod
    def launch_default_for_uri_finish(result: AsyncResult) -> builtins.bool: ...

    def launch_uris(self, uris: typing.Optional[typing.Sequence[builtins.str]], context: typing.Optional[AppLaunchContext]) -> builtins.bool: ...

    def launch_uris_async(self, uris: typing.Optional[typing.Sequence[builtins.str]], context: typing.Optional[AppLaunchContext], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def launch_uris_finish(self, result: AsyncResult) -> builtins.bool: ...

    def remove_supports_type(self, content_type: builtins.str) -> builtins.bool: ...

    @staticmethod
    def reset_type_associations(content_type: builtins.str) -> None: ...

    def set_as_default_for_extension(self, extension: builtins.str) -> builtins.bool: ...

    def set_as_default_for_type(self, content_type: builtins.str) -> builtins.bool: ...

    def set_as_last_used_for_type(self, content_type: builtins.str) -> builtins.bool: ...

    def should_show(self) -> builtins.bool: ...

    def supports_files(self) -> builtins.bool: ...

    def supports_uris(self) -> builtins.bool: ...

    def do_add_supports_type(self, content_type: builtins.str) -> builtins.bool: ...

    def do_can_delete(self) -> builtins.bool: ...

    def do_can_remove_supports_type(self) -> builtins.bool: ...

    def do_do_delete(self) -> builtins.bool: ...

    def do_dup(self) -> AppInfo: ...

    def do_equal(self, appinfo2: AppInfo) -> builtins.bool: ...

    def do_get_commandline(self) -> builtins.str: ...

    def do_get_description(self) -> builtins.str: ...

    def do_get_display_name(self) -> builtins.str: ...

    def do_get_executable(self) -> builtins.str: ...

    def do_get_icon(self) -> Icon: ...

    def do_get_id(self) -> builtins.str: ...

    def do_get_name(self) -> builtins.str: ...

    def do_get_supported_types(self) -> typing.Sequence[builtins.str]: ...

    def do_launch(self, files: typing.Optional[typing.Sequence[File]], context: typing.Optional[AppLaunchContext]) -> builtins.bool: ...

    def do_launch_uris(self, uris: typing.Optional[typing.Sequence[builtins.str]], context: typing.Optional[AppLaunchContext]) -> builtins.bool: ...

    def do_launch_uris_async(self, uris: typing.Optional[typing.Sequence[builtins.str]], context: typing.Optional[AppLaunchContext], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_launch_uris_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_remove_supports_type(self, content_type: builtins.str) -> builtins.bool: ...

    def do_set_as_default_for_extension(self, extension: builtins.str) -> builtins.bool: ...

    def do_set_as_default_for_type(self, content_type: builtins.str) -> builtins.bool: ...

    def do_set_as_last_used_for_type(self, content_type: builtins.str) -> builtins.bool: ...

    def do_should_show(self) -> builtins.bool: ...

    def do_supports_files(self) -> builtins.bool: ...

    def do_supports_uris(self) -> builtins.bool: ...


class AppInfoMonitor(GObject.Object):

    @staticmethod
    def get() -> AppInfoMonitor: ...


class AppLaunchContext(GObject.Object):
    parent_instance: GObject.Object

    def get_display(self, info: AppInfo, files: typing.Sequence[File]) -> builtins.str: ...

    def get_environment(self) -> typing.Sequence[builtins.str]: ...

    def get_startup_notify_id(self, info: AppInfo, files: typing.Sequence[File]) -> builtins.str: ...

    def launch_failed(self, startup_notify_id: builtins.str) -> None: ...

    @staticmethod
    def new(**kwargs) -> AppLaunchContext: ...  # type: ignore

    def setenv(self, variable: builtins.str, value: builtins.str) -> None: ...

    def unsetenv(self, variable: builtins.str) -> None: ...

    def do_get_display(self, info: AppInfo, files: typing.Sequence[File]) -> builtins.str: ...

    def do_get_startup_notify_id(self, info: AppInfo, files: typing.Sequence[File]) -> builtins.str: ...

    def do_launch_failed(self, startup_notify_id: builtins.str) -> None: ...

    def do_launched(self, info: AppInfo, platform_data: GLib.Variant) -> None: ...


class ApplicationCommandLine(GObject.Object):
    parent_instance: GObject.Object

    def create_file_for_arg(self, arg: builtins.str) -> File: ...

    def get_arguments(self) -> typing.Sequence[builtins.str]: ...

    def get_cwd(self) -> typing.Optional[builtins.str]: ...

    def get_environ(self) -> typing.Sequence[builtins.str]: ...

    def get_exit_status(self) -> builtins.int: ...

    def get_is_remote(self) -> builtins.bool: ...

    def get_options_dict(self) -> GLib.VariantDict: ...

    def get_platform_data(self) -> typing.Optional[GLib.Variant]: ...

    def get_stdin(self) -> InputStream: ...

    def getenv(self, name: builtins.str) -> builtins.str: ...

    def set_exit_status(self, exit_status: builtins.int) -> None: ...

    def do_get_stdin(self) -> InputStream: ...

    def do_print_literal(self, message: builtins.str) -> None: ...

    def do_printerr_literal(self, message: builtins.str) -> None: ...


class AsyncInitable(GObject.GInterface):

    def init_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def init_finish(self, res: AsyncResult) -> builtins.bool: ...

    def new_finish(self, res: AsyncResult) -> GObject.Object: ...

    @staticmethod
    def newv_async(object_type: GObject.GType, n_parameters: builtins.int, parameters: GObject.Parameter, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_init_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_init_finish(self, res: AsyncResult) -> builtins.bool: ...


class AsyncResult(GObject.GInterface):

    def get_source_object(self) -> typing.Optional[GObject.Object]: ...

    def get_user_data(self) -> typing.Optional[builtins.object]: ...

    def is_tagged(self, source_tag: typing.Optional[builtins.object]) -> builtins.bool: ...

    def legacy_propagate_error(self) -> builtins.bool: ...

    def do_get_source_object(self) -> typing.Optional[GObject.Object]: ...

    def do_get_user_data(self) -> typing.Optional[builtins.object]: ...

    def do_is_tagged(self, source_tag: typing.Optional[builtins.object]) -> builtins.bool: ...


class Cancellable(GObject.Object):
    parent_instance: GObject.Object

    def cancel(self) -> None: ...

    def connect(self, callback: GObject.Callback, *data: typing.Optional[builtins.object]) -> builtins.int: ...  # type: ignore

    def disconnect(self, handler_id: builtins.int) -> None: ...

    @staticmethod
    def get_current() -> typing.Optional[Cancellable]: ...

    def get_fd(self) -> builtins.int: ...

    def is_cancelled(self) -> builtins.bool: ...

    def make_pollfd(self, pollfd: GLib.PollFD) -> builtins.bool: ...

    @staticmethod
    def new(**kwargs) -> Cancellable: ...  # type: ignore

    def pop_current(self) -> None: ...

    def push_current(self) -> None: ...

    def release_fd(self) -> None: ...

    def reset(self) -> None: ...

    def set_error_if_cancelled(self) -> builtins.bool: ...

    def source_new(self) -> GLib.Source: ...

    def do_cancelled(self) -> None: ...


class Converter(GObject.GInterface):

    def convert(self, inbuf: builtins.bytes, outbuf: builtins.bytes, flags: ConverterFlags) -> typing.Tuple[ConverterResult, builtins.int, builtins.int]: ...

    def reset(self) -> None: ...

    def do_convert(self, inbuf: typing.Optional[builtins.bytes], outbuf: typing.Optional[builtins.bytes], flags: ConverterFlags) -> typing.Tuple[ConverterResult, builtins.int, builtins.int]: ...

    def do_reset(self) -> None: ...


class Credentials(GObject.Object):

    def get_unix_pid(self) -> builtins.int: ...

    def get_unix_user(self) -> builtins.int: ...

    def is_same_user(self, other_credentials: Credentials) -> builtins.bool: ...

    @staticmethod
    def new(**kwargs) -> Credentials: ...  # type: ignore

    def set_native(self, native_type: CredentialsType, native: builtins.object) -> None: ...

    def set_unix_user(self, uid: builtins.int) -> builtins.bool: ...

    def to_string(self) -> builtins.str: ...


class DBusAuthObserver(GObject.Object):

    def allow_mechanism(self, mechanism: builtins.str) -> builtins.bool: ...

    def authorize_authenticated_peer(self, stream: IOStream, credentials: typing.Optional[Credentials]) -> builtins.bool: ...

    @staticmethod
    def new(**kwargs) -> DBusAuthObserver: ...  # type: ignore


class DBusInterface(GObject.GInterface):

    def get_info(self) -> DBusInterfaceInfo: ...

    def get_object(self) -> DBusObject: ...

    def set_object(self, object: typing.Optional[DBusObject]) -> None: ...

    def do_dup_object(self) -> DBusObject: ...

    def do_get_info(self) -> DBusInterfaceInfo: ...

    def do_set_object(self, object: typing.Optional[DBusObject]) -> None: ...


class DBusMessage(GObject.Object):

    @staticmethod
    def bytes_needed(blob: builtins.bytes) -> builtins.int: ...

    def copy(self) -> DBusMessage: ...

    def get_arg0(self) -> builtins.str: ...

    def get_body(self) -> GLib.Variant: ...

    def get_byte_order(self) -> DBusMessageByteOrder: ...

    def get_destination(self) -> builtins.str: ...

    def get_error_name(self) -> builtins.str: ...

    def get_flags(self) -> DBusMessageFlags: ...

    def get_header(self, header_field: DBusMessageHeaderField) -> typing.Optional[GLib.Variant]: ...

    def get_header_fields(self) -> builtins.bytes: ...

    def get_interface(self) -> builtins.str: ...

    def get_locked(self) -> builtins.bool: ...

    def get_member(self) -> builtins.str: ...

    def get_message_type(self) -> DBusMessageType: ...

    def get_num_unix_fds(self) -> builtins.int: ...

    def get_path(self) -> builtins.str: ...

    def get_reply_serial(self) -> builtins.int: ...

    def get_sender(self) -> builtins.str: ...

    def get_serial(self) -> builtins.int: ...

    def get_signature(self) -> builtins.str: ...

    def get_unix_fd_list(self) -> UnixFDList: ...

    def lock(self) -> None: ...

    @staticmethod
    def new(**kwargs) -> DBusMessage: ...  # type: ignore

    @staticmethod
    def new_from_blob(blob: builtins.bytes, capabilities: DBusCapabilityFlags) -> DBusMessage: ...

    @staticmethod
    def new_method_call(name: typing.Optional[builtins.str], path: builtins.str, interface_: typing.Optional[builtins.str], method: builtins.str) -> DBusMessage: ...

    def new_method_error_literal(self, error_name: builtins.str, error_message: builtins.str) -> DBusMessage: ...

    def new_method_reply(self) -> DBusMessage: ...

    @staticmethod
    def new_signal(path: builtins.str, interface_: builtins.str, signal: builtins.str) -> DBusMessage: ...

    def print_(self, indent: builtins.int) -> builtins.str: ...

    def set_body(self, body: GLib.Variant) -> None: ...

    def set_byte_order(self, byte_order: DBusMessageByteOrder) -> None: ...

    def set_destination(self, value: builtins.str) -> None: ...

    def set_error_name(self, value: builtins.str) -> None: ...

    def set_flags(self, flags: DBusMessageFlags) -> None: ...

    def set_header(self, header_field: DBusMessageHeaderField, value: typing.Optional[GLib.Variant]) -> None: ...

    def set_interface(self, value: builtins.str) -> None: ...

    def set_member(self, value: builtins.str) -> None: ...

    def set_message_type(self, type: DBusMessageType) -> None: ...

    def set_num_unix_fds(self, value: builtins.int) -> None: ...

    def set_path(self, value: builtins.str) -> None: ...

    def set_reply_serial(self, value: builtins.int) -> None: ...

    def set_sender(self, value: builtins.str) -> None: ...

    def set_serial(self, serial: builtins.int) -> None: ...

    def set_signature(self, value: builtins.str) -> None: ...

    def set_unix_fd_list(self, fd_list: typing.Optional[UnixFDList]) -> None: ...

    def to_blob(self, capabilities: DBusCapabilityFlags) -> builtins.bytes: ...

    def to_gerror(self) -> builtins.bool: ...


class DBusMethodInvocation(GObject.Object):

    def get_connection(self) -> DBusConnection: ...

    def get_interface_name(self) -> builtins.str: ...

    def get_message(self) -> DBusMessage: ...

    def get_method_info(self) -> DBusMethodInfo: ...

    def get_method_name(self) -> builtins.str: ...

    def get_object_path(self) -> builtins.str: ...

    def get_parameters(self) -> GLib.Variant: ...

    def get_property_info(self) -> DBusPropertyInfo: ...

    def get_sender(self) -> builtins.str: ...

    def return_dbus_error(self, error_name: builtins.str, error_message: builtins.str) -> None: ...

    def return_error_literal(self, domain: builtins.int, code: builtins.int, message: builtins.str) -> None: ...

    def return_gerror(self, error: GLib.Error) -> None: ...

    def return_value(self, parameters: typing.Optional[GLib.Variant]) -> None: ...

    def return_value_with_unix_fd_list(self, parameters: typing.Optional[GLib.Variant], fd_list: typing.Optional[UnixFDList]) -> None: ...


class DBusObject(GObject.GInterface):

    def get_interface(self, interface_name: builtins.str) -> DBusInterface: ...

    def get_interfaces(self) -> typing.Sequence[DBusInterface]: ...

    def get_object_path(self) -> builtins.str: ...

    def do_get_interface(self, interface_name: builtins.str) -> DBusInterface: ...

    def do_get_interfaces(self) -> typing.Sequence[DBusInterface]: ...

    def do_get_object_path(self) -> builtins.str: ...

    def do_interface_added(self, interface_: DBusInterface) -> None: ...

    def do_interface_removed(self, interface_: DBusInterface) -> None: ...


class DBusObjectManager(GObject.GInterface):

    def get_interface(self, object_path: builtins.str, interface_name: builtins.str) -> DBusInterface: ...

    def get_object(self, object_path: builtins.str) -> DBusObject: ...

    def get_object_path(self) -> builtins.str: ...

    def get_objects(self) -> typing.Sequence[DBusObject]: ...

    def do_get_interface(self, object_path: builtins.str, interface_name: builtins.str) -> DBusInterface: ...

    def do_get_object(self, object_path: builtins.str) -> DBusObject: ...

    def do_get_object_path(self) -> builtins.str: ...

    def do_get_objects(self) -> typing.Sequence[DBusObject]: ...

    def do_interface_added(self, object: DBusObject, interface_: DBusInterface) -> None: ...

    def do_interface_removed(self, object: DBusObject, interface_: DBusInterface) -> None: ...

    def do_object_added(self, object: DBusObject) -> None: ...

    def do_object_removed(self, object: DBusObject) -> None: ...


class DatagramBased(GObject.GInterface):

    def condition_check(self, condition: GLib.IOCondition) -> GLib.IOCondition: ...

    def condition_wait(self, condition: GLib.IOCondition, timeout: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def create_source(self, condition: GLib.IOCondition, cancellable: typing.Optional[Cancellable]) -> GLib.Source: ...

    def receive_messages(self, messages: typing.Sequence[InputMessage], flags: builtins.int, timeout: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def send_messages(self, messages: typing.Sequence[OutputMessage], flags: builtins.int, timeout: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def do_condition_check(self, condition: GLib.IOCondition) -> GLib.IOCondition: ...

    def do_condition_wait(self, condition: GLib.IOCondition, timeout: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_create_source(self, condition: GLib.IOCondition, cancellable: typing.Optional[Cancellable]) -> GLib.Source: ...

    def do_receive_messages(self, messages: typing.Sequence[InputMessage], flags: builtins.int, timeout: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def do_send_messages(self, messages: typing.Sequence[OutputMessage], flags: builtins.int, timeout: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...


class DesktopAppInfoLookup(GObject.GInterface):

    def get_default_for_uri_scheme(self, uri_scheme: builtins.str) -> AppInfo: ...

    def do_get_default_for_uri_scheme(self, uri_scheme: builtins.str) -> AppInfo: ...


class Drive(GObject.GInterface):

    def can_eject(self) -> builtins.bool: ...

    def can_poll_for_media(self) -> builtins.bool: ...

    def can_start(self) -> builtins.bool: ...

    def can_start_degraded(self) -> builtins.bool: ...

    def can_stop(self) -> builtins.bool: ...

    def eject(self, flags: MountUnmountFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def eject_finish(self, result: AsyncResult) -> builtins.bool: ...

    def eject_with_operation(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def eject_with_operation_finish(self, result: AsyncResult) -> builtins.bool: ...

    def enumerate_identifiers(self) -> typing.Sequence[builtins.str]: ...

    def get_icon(self) -> Icon: ...

    def get_identifier(self, kind: builtins.str) -> typing.Optional[builtins.str]: ...

    def get_name(self) -> builtins.str: ...

    def get_sort_key(self) -> typing.Optional[builtins.str]: ...

    def get_start_stop_type(self) -> DriveStartStopType: ...

    def get_symbolic_icon(self) -> Icon: ...

    def get_volumes(self) -> typing.Sequence[Volume]: ...

    def has_media(self) -> builtins.bool: ...

    def has_volumes(self) -> builtins.bool: ...

    def is_media_check_automatic(self) -> builtins.bool: ...

    def is_media_removable(self) -> builtins.bool: ...

    def is_removable(self) -> builtins.bool: ...

    def poll_for_media(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def poll_for_media_finish(self, result: AsyncResult) -> builtins.bool: ...

    def start(self, flags: DriveStartFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def start_finish(self, result: AsyncResult) -> builtins.bool: ...

    def stop(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def stop_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_can_eject(self) -> builtins.bool: ...

    def do_can_poll_for_media(self) -> builtins.bool: ...

    def do_can_start(self) -> builtins.bool: ...

    def do_can_start_degraded(self) -> builtins.bool: ...

    def do_can_stop(self) -> builtins.bool: ...

    def do_changed(self) -> None: ...

    def do_disconnected(self) -> None: ...

    def do_eject(self, flags: MountUnmountFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_eject_button(self) -> None: ...

    def do_eject_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_eject_with_operation(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_eject_with_operation_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_enumerate_identifiers(self) -> typing.Sequence[builtins.str]: ...

    def do_get_icon(self) -> Icon: ...

    def do_get_identifier(self, kind: builtins.str) -> typing.Optional[builtins.str]: ...

    def do_get_name(self) -> builtins.str: ...

    def do_get_sort_key(self) -> typing.Optional[builtins.str]: ...

    def do_get_start_stop_type(self) -> DriveStartStopType: ...

    def do_get_symbolic_icon(self) -> Icon: ...

    def do_get_volumes(self) -> typing.Sequence[Volume]: ...

    def do_has_media(self) -> builtins.bool: ...

    def do_has_volumes(self) -> builtins.bool: ...

    def do_is_media_check_automatic(self) -> builtins.bool: ...

    def do_is_media_removable(self) -> builtins.bool: ...

    def do_is_removable(self) -> builtins.bool: ...

    def do_poll_for_media(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_poll_for_media_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_start(self, flags: DriveStartFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_start_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_stop(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_stop_button(self) -> None: ...

    def do_stop_finish(self, result: AsyncResult) -> builtins.bool: ...


class DtlsClientConnection(GObject.GInterface):

    def get_accepted_cas(self) -> typing.Sequence[builtins.bytes]: ...

    def get_server_identity(self) -> SocketConnectable: ...

    def get_validation_flags(self) -> TlsCertificateFlags: ...

    @staticmethod
    def new(base_socket: DatagramBased, server_identity: typing.Optional[SocketConnectable]) -> DtlsClientConnection: ...

    def set_server_identity(self, identity: SocketConnectable) -> None: ...

    def set_validation_flags(self, flags: TlsCertificateFlags) -> None: ...


class DtlsConnection(GObject.GInterface):

    def close(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def close_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def close_finish(self, result: AsyncResult) -> builtins.bool: ...

    def emit_accept_certificate(self, peer_cert: TlsCertificate, errors: TlsCertificateFlags) -> builtins.bool: ...

    def get_certificate(self) -> TlsCertificate: ...

    def get_database(self) -> TlsDatabase: ...

    def get_interaction(self) -> TlsInteraction: ...

    def get_negotiated_protocol(self) -> typing.Optional[builtins.str]: ...

    def get_peer_certificate(self) -> TlsCertificate: ...

    def get_peer_certificate_errors(self) -> TlsCertificateFlags: ...

    def get_rehandshake_mode(self) -> TlsRehandshakeMode: ...

    def get_require_close_notify(self) -> builtins.bool: ...

    def handshake(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def handshake_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def handshake_finish(self, result: AsyncResult) -> builtins.bool: ...

    def set_advertised_protocols(self, protocols: typing.Optional[typing.Sequence[builtins.str]]) -> None: ...

    def set_certificate(self, certificate: TlsCertificate) -> None: ...

    def set_database(self, database: TlsDatabase) -> None: ...

    def set_interaction(self, interaction: typing.Optional[TlsInteraction]) -> None: ...

    def set_rehandshake_mode(self, mode: TlsRehandshakeMode) -> None: ...

    def set_require_close_notify(self, require_close_notify: builtins.bool) -> None: ...

    def shutdown(self, shutdown_read: builtins.bool, shutdown_write: builtins.bool, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def shutdown_async(self, shutdown_read: builtins.bool, shutdown_write: builtins.bool, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def shutdown_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_accept_certificate(self, peer_cert: TlsCertificate, errors: TlsCertificateFlags) -> builtins.bool: ...

    def do_get_negotiated_protocol(self) -> typing.Optional[builtins.str]: ...

    def do_handshake(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_handshake_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_handshake_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_set_advertised_protocols(self, protocols: typing.Optional[typing.Sequence[builtins.str]]) -> None: ...

    def do_shutdown(self, shutdown_read: builtins.bool, shutdown_write: builtins.bool, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_shutdown_async(self, shutdown_read: builtins.bool, shutdown_write: builtins.bool, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_shutdown_finish(self, result: AsyncResult) -> builtins.bool: ...


class DtlsServerConnection(GObject.GInterface):

    @staticmethod
    def new(base_socket: DatagramBased, certificate: typing.Optional[TlsCertificate]) -> DtlsServerConnection: ...


class File(GObject.GInterface):

    def append_to(self, flags: FileCreateFlags, cancellable: typing.Optional[Cancellable]) -> FileOutputStream: ...

    def append_to_async(self, flags: FileCreateFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def append_to_finish(self, res: AsyncResult) -> FileOutputStream: ...

    def copy(self, destination: File, flags: FileCopyFlags, cancellable: typing.Optional[Cancellable], progress_callback: typing.Optional[FileProgressCallback], *progress_callback_data: typing.Optional[builtins.object]) -> builtins.bool: ...

    def copy_async(self, destination: File, flags: FileCopyFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], progress_callback: typing.Optional[FileProgressCallback], progress_callback_data: typing.Optional[builtins.object], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def copy_attributes(self, destination: File, flags: FileCopyFlags, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def copy_finish(self, res: AsyncResult) -> builtins.bool: ...

    def create(self, flags: FileCreateFlags, cancellable: typing.Optional[Cancellable]) -> FileOutputStream: ...

    def create_async(self, flags: FileCreateFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def create_finish(self, res: AsyncResult) -> FileOutputStream: ...

    def create_readwrite(self, flags: FileCreateFlags, cancellable: typing.Optional[Cancellable]) -> FileIOStream: ...

    def create_readwrite_async(self, flags: FileCreateFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def create_readwrite_finish(self, res: AsyncResult) -> FileIOStream: ...

    def delete(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def delete_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def delete_finish(self, result: AsyncResult) -> builtins.bool: ...

    def dup(self) -> File: ...

    def eject_mountable(self, flags: MountUnmountFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def eject_mountable_finish(self, result: AsyncResult) -> builtins.bool: ...

    def eject_mountable_with_operation(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def eject_mountable_with_operation_finish(self, result: AsyncResult) -> builtins.bool: ...

    def enumerate_children(self, attributes: builtins.str, flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> FileEnumerator: ...

    def enumerate_children_async(self, attributes: builtins.str, flags: FileQueryInfoFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def enumerate_children_finish(self, res: AsyncResult) -> FileEnumerator: ...

    def equal(self, file2: File) -> builtins.bool: ...

    def find_enclosing_mount(self, cancellable: typing.Optional[Cancellable]) -> Mount: ...

    def find_enclosing_mount_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def find_enclosing_mount_finish(self, res: AsyncResult) -> Mount: ...

    def get_basename(self) -> typing.Optional[builtins.str]: ...

    def get_child(self, name: builtins.str) -> File: ...

    def get_child_for_display_name(self, display_name: builtins.str) -> File: ...

    def get_parent(self) -> typing.Optional[File]: ...

    def get_parse_name(self) -> builtins.str: ...

    def get_path(self) -> typing.Optional[builtins.str]: ...

    def get_relative_path(self, descendant: File) -> typing.Optional[builtins.str]: ...

    def get_uri(self) -> builtins.str: ...

    def get_uri_scheme(self) -> builtins.str: ...

    def has_parent(self, parent: typing.Optional[File]) -> builtins.bool: ...

    def has_prefix(self, prefix: File) -> builtins.bool: ...

    def has_uri_scheme(self, uri_scheme: builtins.str) -> builtins.bool: ...

    def hash(self) -> builtins.int: ...

    def is_native(self) -> builtins.bool: ...

    def load_bytes(self, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[GLib.Bytes, typing.Optional[builtins.str]]: ...

    def load_bytes_async(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def load_bytes_finish(self, result: AsyncResult) -> typing.Tuple[GLib.Bytes, typing.Optional[builtins.str]]: ...

    def load_contents(self, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.bool, builtins.bytes, builtins.str]: ...

    def load_contents_async(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def load_contents_finish(self, res: AsyncResult) -> typing.Tuple[builtins.bool, builtins.bytes, builtins.str]: ...

    def load_partial_contents_finish(self, res: AsyncResult) -> typing.Tuple[builtins.bool, builtins.bytes, builtins.str]: ...

    def make_directory(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def make_directory_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def make_directory_finish(self, result: AsyncResult) -> builtins.bool: ...

    def make_directory_with_parents(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def make_symbolic_link(self, symlink_value: builtins.str, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def measure_disk_usage_finish(self, result: AsyncResult) -> typing.Tuple[builtins.bool, builtins.int, builtins.int, builtins.int]: ...

    def monitor(self, flags: FileMonitorFlags, cancellable: typing.Optional[Cancellable]) -> FileMonitor: ...

    def monitor_directory(self, flags: FileMonitorFlags, cancellable: typing.Optional[Cancellable]) -> FileMonitor: ...

    def monitor_file(self, flags: FileMonitorFlags, cancellable: typing.Optional[Cancellable] = None) -> FileMonitor: ...

    def mount_enclosing_volume(self, flags: MountMountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def mount_enclosing_volume_finish(self, result: AsyncResult) -> builtins.bool: ...

    def mount_mountable(self, flags: MountMountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def mount_mountable_finish(self, result: AsyncResult) -> File: ...

    def move(self, destination: File, flags: FileCopyFlags, cancellable: typing.Optional[Cancellable], progress_callback: typing.Optional[FileProgressCallback], *progress_callback_data: typing.Optional[builtins.object]) -> builtins.bool: ...

    @staticmethod
    def new_for_commandline_arg(arg: builtins.str) -> File: ...

    @staticmethod
    def new_for_commandline_arg_and_cwd(arg: builtins.str, cwd: builtins.str) -> File: ...

    @staticmethod
    def new_for_path(path: builtins.str) -> File: ...

    @staticmethod
    def new_for_uri(uri: builtins.str) -> File: ...

    @staticmethod
    def new_tmp(tmpl: typing.Optional[builtins.str]) -> typing.Tuple[File, FileIOStream]: ...

    def open_readwrite(self, cancellable: typing.Optional[Cancellable]) -> FileIOStream: ...

    def open_readwrite_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def open_readwrite_finish(self, res: AsyncResult) -> FileIOStream: ...

    @staticmethod
    def parse_name(parse_name: builtins.str) -> File: ...

    def peek_path(self) -> typing.Optional[builtins.str]: ...

    def poll_mountable(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def poll_mountable_finish(self, result: AsyncResult) -> builtins.bool: ...

    def query_default_handler(self, cancellable: typing.Optional[Cancellable]) -> AppInfo: ...

    def query_default_handler_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def query_default_handler_finish(self, result: AsyncResult) -> AppInfo: ...

    def query_exists(self, cancellable: typing.Optional[Cancellable] = None) -> builtins.bool: ...

    def query_file_type(self, flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> FileType: ...

    def query_filesystem_info(self, attributes: builtins.str, cancellable: typing.Optional[Cancellable]) -> FileInfo: ...

    def query_filesystem_info_async(self, attributes: builtins.str, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def query_filesystem_info_finish(self, res: AsyncResult) -> FileInfo: ...

    def query_info(self, attributes: builtins.str, flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable] = None) -> FileInfo: ...

    def query_info_async(self, attributes: builtins.str, flags: FileQueryInfoFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def query_info_finish(self, res: AsyncResult) -> FileInfo: ...

    def query_settable_attributes(self, cancellable: typing.Optional[Cancellable]) -> FileAttributeInfoList: ...

    def query_writable_namespaces(self, cancellable: typing.Optional[Cancellable]) -> FileAttributeInfoList: ...

    def read(self, cancellable: typing.Optional[Cancellable]) -> FileInputStream: ...

    def read_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def read_finish(self, res: AsyncResult) -> FileInputStream: ...

    def replace(self, etag: typing.Optional[builtins.str], make_backup: builtins.bool, flags: FileCreateFlags, cancellable: typing.Optional[Cancellable]) -> FileOutputStream: ...

    def replace_async(self, etag: typing.Optional[builtins.str], make_backup: builtins.bool, flags: FileCreateFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def replace_contents(self, contents: builtins.bytes, etag: typing.Optional[builtins.str], make_backup: builtins.bool, flags: FileCreateFlags, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.bool, builtins.str]: ...

    def replace_contents_async(self, contents: builtins.bytes, etag: typing.Optional[builtins.str], make_backup: builtins.bool, flags: FileCreateFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def replace_contents_bytes_async(self, contents: GLib.Bytes, etag: typing.Optional[builtins.str], make_backup: builtins.bool, flags: FileCreateFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def replace_contents_finish(self, res: AsyncResult) -> typing.Tuple[builtins.bool, builtins.str]: ...

    def replace_finish(self, res: AsyncResult) -> FileOutputStream: ...

    def replace_readwrite(self, etag: typing.Optional[builtins.str], make_backup: builtins.bool, flags: FileCreateFlags, cancellable: typing.Optional[Cancellable]) -> FileIOStream: ...

    def replace_readwrite_async(self, etag: typing.Optional[builtins.str], make_backup: builtins.bool, flags: FileCreateFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def replace_readwrite_finish(self, res: AsyncResult) -> FileIOStream: ...

    def resolve_relative_path(self, relative_path: builtins.str) -> File: ...

    def set_attribute(self, attribute: builtins.str, type: FileAttributeType, value_p: typing.Optional[builtins.object], flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def set_attribute_byte_string(self, attribute: builtins.str, value: builtins.str, flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def set_attribute_int32(self, attribute: builtins.str, value: builtins.int, flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def set_attribute_int64(self, attribute: builtins.str, value: builtins.int, flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def set_attribute_string(self, attribute: builtins.str, value: builtins.str, flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def set_attribute_uint32(self, attribute: builtins.str, value: builtins.int, flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def set_attribute_uint64(self, attribute: builtins.str, value: builtins.int, flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def set_attributes_async(self, info: FileInfo, flags: FileQueryInfoFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def set_attributes_finish(self, result: AsyncResult) -> typing.Tuple[builtins.bool, FileInfo]: ...

    def set_attributes_from_info(self, info: FileInfo, flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def set_display_name(self, display_name: builtins.str, cancellable: typing.Optional[Cancellable]) -> File: ...

    def set_display_name_async(self, display_name: builtins.str, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def set_display_name_finish(self, res: AsyncResult) -> File: ...

    def start_mountable(self, flags: DriveStartFlags, start_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def start_mountable_finish(self, result: AsyncResult) -> builtins.bool: ...

    def stop_mountable(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def stop_mountable_finish(self, result: AsyncResult) -> builtins.bool: ...

    def supports_thread_contexts(self) -> builtins.bool: ...

    def trash(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def trash_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def trash_finish(self, result: AsyncResult) -> builtins.bool: ...

    def unmount_mountable(self, flags: MountUnmountFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def unmount_mountable_finish(self, result: AsyncResult) -> builtins.bool: ...

    def unmount_mountable_with_operation(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def unmount_mountable_with_operation_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_append_to(self, flags: FileCreateFlags, cancellable: typing.Optional[Cancellable]) -> FileOutputStream: ...

    def do_append_to_async(self, flags: FileCreateFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_append_to_finish(self, res: AsyncResult) -> FileOutputStream: ...

    def do_copy(self, destination: File, flags: FileCopyFlags, cancellable: typing.Optional[Cancellable], progress_callback: typing.Optional[FileProgressCallback], progress_callback_data: typing.Optional[builtins.object]) -> builtins.bool: ...

    def do_copy_async(self, destination: File, flags: FileCopyFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], progress_callback: typing.Optional[FileProgressCallback], progress_callback_data: typing.Optional[builtins.object], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_copy_finish(self, res: AsyncResult) -> builtins.bool: ...

    def do_create(self, flags: FileCreateFlags, cancellable: typing.Optional[Cancellable]) -> FileOutputStream: ...

    def do_create_async(self, flags: FileCreateFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_create_finish(self, res: AsyncResult) -> FileOutputStream: ...

    def do_create_readwrite(self, flags: FileCreateFlags, cancellable: typing.Optional[Cancellable]) -> FileIOStream: ...

    def do_create_readwrite_async(self, flags: FileCreateFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_create_readwrite_finish(self, res: AsyncResult) -> FileIOStream: ...

    def do_delete_file(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_delete_file_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_delete_file_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_dup(self) -> File: ...

    def do_eject_mountable(self, flags: MountUnmountFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_eject_mountable_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_eject_mountable_with_operation(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_eject_mountable_with_operation_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_enumerate_children(self, attributes: builtins.str, flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> FileEnumerator: ...

    def do_enumerate_children_async(self, attributes: builtins.str, flags: FileQueryInfoFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_enumerate_children_finish(self, res: AsyncResult) -> FileEnumerator: ...

    def do_equal(self, file2: File) -> builtins.bool: ...

    def do_find_enclosing_mount(self, cancellable: typing.Optional[Cancellable]) -> Mount: ...

    def do_find_enclosing_mount_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_find_enclosing_mount_finish(self, res: AsyncResult) -> Mount: ...

    def do_get_basename(self) -> builtins.str: ...

    def do_get_child_for_display_name(self, display_name: builtins.str) -> File: ...

    def do_get_parent(self) -> typing.Optional[File]: ...

    def do_get_parse_name(self) -> builtins.str: ...

    def do_get_path(self) -> builtins.str: ...

    def do_get_relative_path(self, descendant: File) -> builtins.str: ...

    def do_get_uri(self) -> builtins.str: ...

    def do_get_uri_scheme(self) -> builtins.str: ...

    def do_has_uri_scheme(self, uri_scheme: builtins.str) -> builtins.bool: ...

    def do_hash(self) -> builtins.int: ...

    def do_is_native(self) -> builtins.bool: ...

    def do_make_directory(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_make_directory_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_make_directory_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_make_symbolic_link(self, symlink_value: builtins.str, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_measure_disk_usage_finish(self, result: AsyncResult) -> typing.Tuple[builtins.bool, builtins.int, builtins.int, builtins.int]: ...

    def do_monitor_dir(self, flags: FileMonitorFlags, cancellable: typing.Optional[Cancellable]) -> FileMonitor: ...

    def do_monitor_file(self, flags: FileMonitorFlags, cancellable: typing.Optional[Cancellable]) -> FileMonitor: ...

    def do_mount_enclosing_volume(self, flags: MountMountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_mount_enclosing_volume_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_mount_mountable(self, flags: MountMountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_mount_mountable_finish(self, result: AsyncResult) -> File: ...

    def do_move(self, destination: File, flags: FileCopyFlags, cancellable: typing.Optional[Cancellable], progress_callback: typing.Optional[FileProgressCallback], progress_callback_data: typing.Optional[builtins.object]) -> builtins.bool: ...

    def do_open_readwrite(self, cancellable: typing.Optional[Cancellable]) -> FileIOStream: ...

    def do_open_readwrite_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_open_readwrite_finish(self, res: AsyncResult) -> FileIOStream: ...

    def do_poll_mountable(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_poll_mountable_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_prefix_matches(self, file: File) -> builtins.bool: ...

    def do_query_filesystem_info(self, attributes: builtins.str, cancellable: typing.Optional[Cancellable]) -> FileInfo: ...

    def do_query_filesystem_info_async(self, attributes: builtins.str, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_query_filesystem_info_finish(self, res: AsyncResult) -> FileInfo: ...

    def do_query_info(self, attributes: builtins.str, flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> FileInfo: ...

    def do_query_info_async(self, attributes: builtins.str, flags: FileQueryInfoFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_query_info_finish(self, res: AsyncResult) -> FileInfo: ...

    def do_query_settable_attributes(self, cancellable: typing.Optional[Cancellable]) -> FileAttributeInfoList: ...

    def do_query_writable_namespaces(self, cancellable: typing.Optional[Cancellable]) -> FileAttributeInfoList: ...

    def do_read_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_read_finish(self, res: AsyncResult) -> FileInputStream: ...

    def do_read_fn(self, cancellable: typing.Optional[Cancellable]) -> FileInputStream: ...

    def do_replace(self, etag: typing.Optional[builtins.str], make_backup: builtins.bool, flags: FileCreateFlags, cancellable: typing.Optional[Cancellable]) -> FileOutputStream: ...

    def do_replace_async(self, etag: typing.Optional[builtins.str], make_backup: builtins.bool, flags: FileCreateFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_replace_finish(self, res: AsyncResult) -> FileOutputStream: ...

    def do_replace_readwrite(self, etag: typing.Optional[builtins.str], make_backup: builtins.bool, flags: FileCreateFlags, cancellable: typing.Optional[Cancellable]) -> FileIOStream: ...

    def do_replace_readwrite_async(self, etag: typing.Optional[builtins.str], make_backup: builtins.bool, flags: FileCreateFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_replace_readwrite_finish(self, res: AsyncResult) -> FileIOStream: ...

    def do_resolve_relative_path(self, relative_path: builtins.str) -> File: ...

    def do_set_attribute(self, attribute: builtins.str, type: FileAttributeType, value_p: typing.Optional[builtins.object], flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_set_attributes_async(self, info: FileInfo, flags: FileQueryInfoFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_set_attributes_finish(self, result: AsyncResult) -> typing.Tuple[builtins.bool, FileInfo]: ...

    def do_set_attributes_from_info(self, info: FileInfo, flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_set_display_name(self, display_name: builtins.str, cancellable: typing.Optional[Cancellable]) -> File: ...

    def do_set_display_name_async(self, display_name: builtins.str, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_set_display_name_finish(self, res: AsyncResult) -> File: ...

    def do_start_mountable(self, flags: DriveStartFlags, start_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_start_mountable_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_stop_mountable(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_stop_mountable_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_trash(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_trash_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_trash_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_unmount_mountable(self, flags: MountUnmountFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_unmount_mountable_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_unmount_mountable_with_operation(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_unmount_mountable_with_operation_finish(self, result: AsyncResult) -> builtins.bool: ...


class FileDescriptorBased(GObject.GInterface):

    def get_fd(self) -> builtins.int: ...

    def do_get_fd(self) -> builtins.int: ...


class FileEnumerator(GObject.Object):
    parent_instance: GObject.Object

    def close(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def close_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def close_finish(self, result: AsyncResult) -> builtins.bool: ...

    def get_child(self, info: FileInfo) -> File: ...

    def get_container(self) -> File: ...

    def has_pending(self) -> builtins.bool: ...

    def is_closed(self) -> builtins.bool: ...

    def iterate(self, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.bool, FileInfo, File]: ...

    def next_file(self, cancellable: typing.Optional[Cancellable]) -> typing.Optional[FileInfo]: ...

    def next_files_async(self, num_files: builtins.int, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def next_files_finish(self, result: AsyncResult) -> typing.Sequence[FileInfo]: ...

    def set_pending(self, pending: builtins.bool) -> None: ...

    def do_close_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_close_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_close_fn(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_next_file(self, cancellable: typing.Optional[Cancellable]) -> typing.Optional[FileInfo]: ...

    def do_next_files_async(self, num_files: builtins.int, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_next_files_finish(self, result: AsyncResult) -> typing.Sequence[FileInfo]: ...


class FileInfo(GObject.Object):

    def clear_status(self) -> None: ...

    def copy_into(self, dest_info: FileInfo) -> None: ...

    def dup(self) -> FileInfo: ...

    def get_attribute_as_string(self, attribute: builtins.str) -> typing.Optional[builtins.str]: ...

    def get_attribute_boolean(self, attribute: builtins.str) -> builtins.bool: ...

    def get_attribute_byte_string(self, attribute: builtins.str) -> builtins.str: ...

    def get_attribute_data(self, attribute: builtins.str) -> typing.Tuple[builtins.bool, FileAttributeType, builtins.object, FileAttributeStatus]: ...

    def get_attribute_int32(self, attribute: builtins.str) -> builtins.int: ...

    def get_attribute_int64(self, attribute: builtins.str) -> builtins.int: ...

    def get_attribute_object(self, attribute: builtins.str) -> GObject.Object: ...

    def get_attribute_status(self, attribute: builtins.str) -> FileAttributeStatus: ...

    def get_attribute_string(self, attribute: builtins.str) -> builtins.str: ...

    def get_attribute_stringv(self, attribute: builtins.str) -> typing.Sequence[builtins.str]: ...

    def get_attribute_type(self, attribute: builtins.str) -> FileAttributeType: ...

    def get_attribute_uint32(self, attribute: builtins.str) -> builtins.int: ...

    def get_attribute_uint64(self, attribute: builtins.str) -> builtins.int: ...

    def get_content_type(self) -> builtins.str: ...

    def get_deletion_date(self) -> GLib.DateTime: ...

    def get_display_name(self) -> builtins.str: ...

    def get_edit_name(self) -> builtins.str: ...

    def get_etag(self) -> builtins.str: ...

    def get_file_type(self) -> FileType: ...

    def get_icon(self) -> Icon: ...

    def get_is_backup(self) -> builtins.bool: ...

    def get_is_hidden(self) -> builtins.bool: ...

    def get_is_symlink(self) -> builtins.bool: ...

    def get_modification_date_time(self) -> typing.Optional[GLib.DateTime]: ...

    def get_modification_time(self) -> GLib.TimeVal: ...

    def get_name(self) -> builtins.str: ...

    def get_size(self) -> builtins.int: ...

    def get_sort_order(self) -> builtins.int: ...

    def get_symbolic_icon(self) -> Icon: ...

    def get_symlink_target(self) -> builtins.str: ...

    def has_attribute(self, attribute: builtins.str) -> builtins.bool: ...

    def has_namespace(self, name_space: builtins.str) -> builtins.bool: ...

    def list_attributes(self, name_space: typing.Optional[builtins.str]) -> typing.Optional[typing.Sequence[builtins.str]]: ...

    @staticmethod
    def new(**kwargs) -> FileInfo: ...  # type: ignore

    def remove_attribute(self, attribute: builtins.str) -> None: ...

    def set_attribute(self, attribute: builtins.str, type: FileAttributeType, value_p: builtins.object) -> None: ...

    def set_attribute_boolean(self, attribute: builtins.str, attr_value: builtins.bool) -> None: ...

    def set_attribute_byte_string(self, attribute: builtins.str, attr_value: builtins.str) -> None: ...

    def set_attribute_int32(self, attribute: builtins.str, attr_value: builtins.int) -> None: ...

    def set_attribute_int64(self, attribute: builtins.str, attr_value: builtins.int) -> None: ...

    def set_attribute_mask(self, mask: FileAttributeMatcher) -> None: ...

    def set_attribute_object(self, attribute: builtins.str, attr_value: GObject.Object) -> None: ...

    def set_attribute_status(self, attribute: builtins.str, status: FileAttributeStatus) -> builtins.bool: ...

    def set_attribute_string(self, attribute: builtins.str, attr_value: builtins.str) -> None: ...

    def set_attribute_stringv(self, attribute: builtins.str, attr_value: typing.Sequence[builtins.str]) -> None: ...

    def set_attribute_uint32(self, attribute: builtins.str, attr_value: builtins.int) -> None: ...

    def set_attribute_uint64(self, attribute: builtins.str, attr_value: builtins.int) -> None: ...

    def set_content_type(self, content_type: builtins.str) -> None: ...

    def set_display_name(self, display_name: builtins.str) -> None: ...

    def set_edit_name(self, edit_name: builtins.str) -> None: ...

    def set_file_type(self, type: FileType) -> None: ...

    def set_icon(self, icon: Icon) -> None: ...

    def set_is_hidden(self, is_hidden: builtins.bool) -> None: ...

    def set_is_symlink(self, is_symlink: builtins.bool) -> None: ...

    def set_modification_date_time(self, mtime: GLib.DateTime) -> None: ...

    def set_modification_time(self, mtime: GLib.TimeVal) -> None: ...

    def set_name(self, name: builtins.str) -> None: ...

    def set_size(self, size: builtins.int) -> None: ...

    def set_sort_order(self, sort_order: builtins.int) -> None: ...

    def set_symbolic_icon(self, icon: Icon) -> None: ...

    def set_symlink_target(self, symlink_target: builtins.str) -> None: ...

    def unset_attribute_mask(self) -> None: ...


class FileMonitor(GObject.Object):
    parent_instance: GObject.Object

    def cancel(self) -> builtins.bool: ...

    def emit_event(self, child: File, other_file: File, event_type: FileMonitorEvent) -> None: ...

    def is_cancelled(self) -> builtins.bool: ...

    def set_rate_limit(self, limit_msecs: builtins.int) -> None: ...

    def do_cancel(self) -> builtins.bool: ...

    def do_changed(self, file: File, other_file: File, event_type: FileMonitorEvent) -> None: ...


class FilenameCompleter(GObject.Object):

    def get_completion_suffix(self, initial_text: builtins.str) -> builtins.str: ...

    def get_completions(self, initial_text: builtins.str) -> typing.Sequence[builtins.str]: ...

    @staticmethod
    def new(**kwargs) -> FilenameCompleter: ...  # type: ignore

    def set_dirs_only(self, dirs_only: builtins.bool) -> None: ...

    def do_got_completion_data(self) -> None: ...


class IOModule(GObject.TypeModule):

    def load(self) -> None: ...

    @staticmethod
    def new(filename: builtins.str) -> IOModule: ...

    @staticmethod
    def query() -> typing.Sequence[builtins.str]: ...

    def unload(self) -> None: ...


class IOStream(GObject.Object):
    parent_instance: GObject.Object

    def clear_pending(self) -> None: ...

    def close(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def close_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def close_finish(self, result: AsyncResult) -> builtins.bool: ...

    def get_input_stream(self) -> InputStream: ...

    def get_output_stream(self) -> OutputStream: ...

    def has_pending(self) -> builtins.bool: ...

    def is_closed(self) -> builtins.bool: ...

    def set_pending(self) -> builtins.bool: ...

    def splice_async(self, stream2: IOStream, flags: IOStreamSpliceFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    @staticmethod
    def splice_finish(result: AsyncResult) -> builtins.bool: ...

    def do_close_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_close_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_close_fn(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_get_input_stream(self) -> InputStream: ...

    def do_get_output_stream(self) -> OutputStream: ...


class Icon(GObject.GInterface):

    @staticmethod
    def deserialize(value: GLib.Variant) -> Icon: ...

    def equal(self, icon2: typing.Optional[Icon]) -> builtins.bool: ...

    @staticmethod
    def hash(icon: builtins.object) -> builtins.int: ...

    @staticmethod
    def new_for_string(str: builtins.str) -> Icon: ...

    def serialize(self) -> GLib.Variant: ...

    def to_string(self) -> typing.Optional[builtins.str]: ...

    def do_equal(self, icon2: typing.Optional[Icon]) -> builtins.bool: ...

    def do_hash(self) -> builtins.int: ...

    def do_serialize(self) -> GLib.Variant: ...


class InetAddress(GObject.Object):
    parent_instance: GObject.Object

    def equal(self, other_address: InetAddress) -> builtins.bool: ...

    def get_family(self) -> SocketFamily: ...

    def get_is_any(self) -> builtins.bool: ...

    def get_is_link_local(self) -> builtins.bool: ...

    def get_is_loopback(self) -> builtins.bool: ...

    def get_is_mc_global(self) -> builtins.bool: ...

    def get_is_mc_link_local(self) -> builtins.bool: ...

    def get_is_mc_node_local(self) -> builtins.bool: ...

    def get_is_mc_org_local(self) -> builtins.bool: ...

    def get_is_mc_site_local(self) -> builtins.bool: ...

    def get_is_multicast(self) -> builtins.bool: ...

    def get_is_site_local(self) -> builtins.bool: ...

    def get_native_size(self) -> builtins.int: ...

    @staticmethod
    def new_any(family: SocketFamily) -> InetAddress: ...

    @staticmethod
    def new_from_bytes(bytes: builtins.bytes, family: SocketFamily) -> InetAddress: ...

    @staticmethod
    def new_from_string(string: builtins.str) -> InetAddress: ...

    @staticmethod
    def new_loopback(family: SocketFamily) -> InetAddress: ...

    def to_string(self) -> builtins.str: ...

    def do_to_string(self) -> builtins.str: ...


class Initable(GObject.GInterface):

    def init(self, cancellable: typing.Optional[Cancellable] = None) -> builtins.bool: ...

    def do_init(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...


class InputStream(GObject.Object):
    parent_instance: GObject.Object

    def clear_pending(self) -> None: ...

    def close(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def close_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def close_finish(self, result: AsyncResult) -> builtins.bool: ...

    def has_pending(self) -> builtins.bool: ...

    def is_closed(self) -> builtins.bool: ...

    def read(self, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.int, builtins.bytes]: ...

    def read_all(self, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.bool, builtins.bytes, builtins.int]: ...

    def read_all_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> builtins.bytes: ...

    def read_all_finish(self, result: AsyncResult) -> typing.Tuple[builtins.bool, builtins.int]: ...

    def read_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> builtins.bytes: ...

    def read_bytes(self, count: builtins.int, cancellable: typing.Optional[Cancellable]) -> GLib.Bytes: ...

    def read_bytes_async(self, count: builtins.int, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def read_bytes_finish(self, result: AsyncResult) -> GLib.Bytes: ...

    def read_finish(self, result: AsyncResult) -> builtins.int: ...

    def set_pending(self) -> builtins.bool: ...

    def skip(self, count: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def skip_async(self, count: builtins.int, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def skip_finish(self, result: AsyncResult) -> builtins.int: ...

    def do_close_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_close_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_close_fn(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_read_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> builtins.bytes: ...

    def do_read_finish(self, result: AsyncResult) -> builtins.int: ...

    def do_read_fn(self, buffer: typing.Optional[builtins.object], count: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def do_skip(self, count: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def do_skip_async(self, count: builtins.int, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_skip_finish(self, result: AsyncResult) -> builtins.int: ...


class ListModel(GObject.GInterface):

    def get_item(self, position: builtins.int) -> typing.Optional[GObject.Object]: ...

    def get_item_type(self) -> GObject.GType: ...

    def get_n_items(self) -> builtins.int: ...

    def items_changed(self, position: builtins.int, removed: builtins.int, added: builtins.int) -> None: ...

    def do_get_item(self, position: builtins.int) -> typing.Optional[GObject.Object]: ...

    def do_get_item_type(self) -> GObject.GType: ...

    def do_get_n_items(self) -> builtins.int: ...


class LoadableIcon(GObject.GInterface):

    def load(self, size: builtins.int, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[InputStream, builtins.str]: ...

    def load_async(self, size: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def load_finish(self, res: AsyncResult) -> typing.Tuple[InputStream, builtins.str]: ...

    def do_load(self, size: builtins.int, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[InputStream, builtins.str]: ...

    def do_load_async(self, size: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_load_finish(self, res: AsyncResult) -> typing.Tuple[InputStream, builtins.str]: ...


class MemoryMonitor(GObject.GInterface):

    @staticmethod
    def dup_default() -> MemoryMonitor: ...

    def do_low_memory_warning(self, level: MemoryMonitorWarningLevel) -> None: ...


class MenuAttributeIter(GObject.Object):
    parent_instance: GObject.Object

    def get_name(self) -> builtins.str: ...

    def get_next(self) -> typing.Tuple[builtins.bool, builtins.str, GLib.Variant]: ...

    def get_value(self) -> GLib.Variant: ...

    def next(self) -> builtins.bool: ...

    def do_get_next(self) -> typing.Tuple[builtins.bool, builtins.str, GLib.Variant]: ...


class MenuItem(GObject.Object):

    def get_attribute_value(self, attribute: builtins.str, expected_type: typing.Optional[GLib.VariantType]) -> GLib.Variant: ...

    def get_link(self, link: builtins.str) -> MenuModel: ...

    @staticmethod
    def new(label: typing.Optional[builtins.str], detailed_action: typing.Optional[builtins.str], **kwargs) -> MenuItem: ...  # type: ignore

    @staticmethod
    def new_from_model(model: MenuModel, item_index: builtins.int) -> MenuItem: ...

    @staticmethod
    def new_section(label: typing.Optional[builtins.str], section: MenuModel) -> MenuItem: ...

    @staticmethod
    def new_submenu(label: typing.Optional[builtins.str], submenu: MenuModel) -> MenuItem: ...

    def set_action_and_target_value(self, action: typing.Optional[builtins.str], target_value: typing.Optional[GLib.Variant]) -> None: ...

    def set_attribute_value(self, attribute: builtins.str, value: typing.Optional[GLib.Variant]) -> None: ...

    def set_detailed_action(self, detailed_action: builtins.str) -> None: ...

    def set_icon(self, icon: Icon) -> None: ...

    def set_label(self, label: typing.Optional[builtins.str]) -> None: ...

    def set_link(self, link: builtins.str, model: typing.Optional[MenuModel]) -> None: ...

    def set_section(self, section: typing.Optional[MenuModel]) -> None: ...

    def set_submenu(self, submenu: typing.Optional[MenuModel]) -> None: ...


class MenuLinkIter(GObject.Object):
    parent_instance: GObject.Object

    def get_name(self) -> builtins.str: ...

    def get_next(self) -> typing.Tuple[builtins.bool, builtins.str, MenuModel]: ...

    def get_value(self) -> MenuModel: ...

    def next(self) -> builtins.bool: ...

    def do_get_next(self) -> typing.Tuple[builtins.bool, builtins.str, MenuModel]: ...


class MenuModel(GObject.Object):
    parent_instance: GObject.Object

    def get_item_attribute_value(self, item_index: builtins.int, attribute: builtins.str, expected_type: typing.Optional[GLib.VariantType]) -> GLib.Variant: ...

    def get_item_link(self, item_index: builtins.int, link: builtins.str) -> MenuModel: ...

    def get_n_items(self) -> builtins.int: ...

    def is_mutable(self) -> builtins.bool: ...

    def items_changed(self, position: builtins.int, removed: builtins.int, added: builtins.int) -> None: ...

    def iterate_item_attributes(self, item_index: builtins.int) -> MenuAttributeIter: ...

    def iterate_item_links(self, item_index: builtins.int) -> MenuLinkIter: ...

    def do_get_item_attribute_value(self, item_index: builtins.int, attribute: builtins.str, expected_type: typing.Optional[GLib.VariantType]) -> GLib.Variant: ...

    def do_get_item_attributes(self, item_index: builtins.int) -> typing.Mapping[builtins.str, GLib.Variant]: ...

    def do_get_item_link(self, item_index: builtins.int, link: builtins.str) -> MenuModel: ...

    def do_get_item_links(self, item_index: builtins.int) -> typing.Mapping[builtins.str, MenuModel]: ...

    def do_get_n_items(self) -> builtins.int: ...

    def do_is_mutable(self) -> builtins.bool: ...

    def do_iterate_item_attributes(self, item_index: builtins.int) -> MenuAttributeIter: ...

    def do_iterate_item_links(self, item_index: builtins.int) -> MenuLinkIter: ...


class Mount(GObject.GInterface):

    def can_eject(self) -> builtins.bool: ...

    def can_unmount(self) -> builtins.bool: ...

    def eject(self, flags: MountUnmountFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def eject_finish(self, result: AsyncResult) -> builtins.bool: ...

    def eject_with_operation(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def eject_with_operation_finish(self, result: AsyncResult) -> builtins.bool: ...

    def get_default_location(self) -> File: ...

    def get_drive(self) -> typing.Optional[Drive]: ...

    def get_icon(self) -> Icon: ...

    def get_name(self) -> builtins.str: ...

    def get_root(self) -> File: ...

    def get_sort_key(self) -> typing.Optional[builtins.str]: ...

    def get_symbolic_icon(self) -> Icon: ...

    def get_uuid(self) -> typing.Optional[builtins.str]: ...

    def get_volume(self) -> typing.Optional[Volume]: ...

    def guess_content_type(self, force_rescan: builtins.bool, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def guess_content_type_finish(self, result: AsyncResult) -> typing.Sequence[builtins.str]: ...

    def guess_content_type_sync(self, force_rescan: builtins.bool, cancellable: typing.Optional[Cancellable]) -> typing.Sequence[builtins.str]: ...

    def is_shadowed(self) -> builtins.bool: ...

    def remount(self, flags: MountMountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def remount_finish(self, result: AsyncResult) -> builtins.bool: ...

    def shadow(self) -> None: ...

    def unmount(self, flags: MountUnmountFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def unmount_finish(self, result: AsyncResult) -> builtins.bool: ...

    def unmount_with_operation(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def unmount_with_operation_finish(self, result: AsyncResult) -> builtins.bool: ...

    def unshadow(self) -> None: ...

    def do_can_eject(self) -> builtins.bool: ...

    def do_can_unmount(self) -> builtins.bool: ...

    def do_changed(self) -> None: ...

    def do_eject(self, flags: MountUnmountFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_eject_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_eject_with_operation(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_eject_with_operation_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_get_default_location(self) -> File: ...

    def do_get_drive(self) -> typing.Optional[Drive]: ...

    def do_get_icon(self) -> Icon: ...

    def do_get_name(self) -> builtins.str: ...

    def do_get_root(self) -> File: ...

    def do_get_sort_key(self) -> typing.Optional[builtins.str]: ...

    def do_get_symbolic_icon(self) -> Icon: ...

    def do_get_uuid(self) -> typing.Optional[builtins.str]: ...

    def do_get_volume(self) -> typing.Optional[Volume]: ...

    def do_guess_content_type(self, force_rescan: builtins.bool, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_guess_content_type_finish(self, result: AsyncResult) -> typing.Sequence[builtins.str]: ...

    def do_guess_content_type_sync(self, force_rescan: builtins.bool, cancellable: typing.Optional[Cancellable]) -> typing.Sequence[builtins.str]: ...

    def do_pre_unmount(self) -> None: ...

    def do_remount(self, flags: MountMountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_remount_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_unmount(self, flags: MountUnmountFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_unmount_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_unmount_with_operation(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_unmount_with_operation_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_unmounted(self) -> None: ...


class MountOperation(GObject.Object):
    parent_instance: GObject.Object

    def get_anonymous(self) -> builtins.bool: ...

    def get_choice(self) -> builtins.int: ...

    def get_domain(self) -> builtins.str: ...

    def get_is_tcrypt_hidden_volume(self) -> builtins.bool: ...

    def get_is_tcrypt_system_volume(self) -> builtins.bool: ...

    def get_password(self) -> builtins.str: ...

    def get_password_save(self) -> PasswordSave: ...

    def get_pim(self) -> builtins.int: ...

    def get_username(self) -> builtins.str: ...

    @staticmethod
    def new(**kwargs) -> MountOperation: ...  # type: ignore

    def reply(self, result: MountOperationResult) -> None: ...

    def set_anonymous(self, anonymous: builtins.bool) -> None: ...

    def set_choice(self, choice: builtins.int) -> None: ...

    def set_domain(self, domain: builtins.str) -> None: ...

    def set_is_tcrypt_hidden_volume(self, hidden_volume: builtins.bool) -> None: ...

    def set_is_tcrypt_system_volume(self, system_volume: builtins.bool) -> None: ...

    def set_password(self, password: builtins.str) -> None: ...

    def set_password_save(self, save: PasswordSave) -> None: ...

    def set_pim(self, pim: builtins.int) -> None: ...

    def set_username(self, username: builtins.str) -> None: ...

    def do_aborted(self) -> None: ...

    def do_ask_password(self, message: builtins.str, default_user: builtins.str, default_domain: builtins.str, flags: AskPasswordFlags) -> None: ...

    def do_ask_question(self, message: builtins.str, choices: typing.Sequence[builtins.str]) -> None: ...

    def do_reply(self, result: MountOperationResult) -> None: ...

    def do_show_processes(self, message: builtins.str, processes: typing.Sequence[builtins.int], choices: typing.Sequence[builtins.str]) -> None: ...

    def do_show_unmount_progress(self, message: builtins.str, time_left: builtins.int, bytes_left: builtins.int) -> None: ...


class NetworkMonitor(GObject.GInterface):

    def can_reach(self, connectable: SocketConnectable, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def can_reach_async(self, connectable: SocketConnectable, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def can_reach_finish(self, result: AsyncResult) -> builtins.bool: ...

    def get_connectivity(self) -> NetworkConnectivity: ...

    @staticmethod
    def get_default() -> NetworkMonitor: ...

    def get_network_available(self) -> builtins.bool: ...

    def get_network_metered(self) -> builtins.bool: ...

    def do_can_reach(self, connectable: SocketConnectable, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_can_reach_async(self, connectable: SocketConnectable, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_can_reach_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_network_changed(self, network_available: builtins.bool) -> None: ...


class Notification(GObject.Object):

    def add_button(self, label: builtins.str, detailed_action: builtins.str) -> None: ...

    def add_button_with_target(self, label: builtins.str, action: builtins.str, target: typing.Optional[GLib.Variant]) -> None: ...

    @staticmethod
    def new(title: builtins.str, **kwargs) -> Notification: ...  # type: ignore

    def set_body(self, body: typing.Optional[builtins.str]) -> None: ...

    def set_default_action(self, detailed_action: builtins.str) -> None: ...

    def set_default_action_and_target(self, action: builtins.str, target: typing.Optional[GLib.Variant]) -> None: ...

    def set_icon(self, icon: Icon) -> None: ...

    def set_priority(self, priority: NotificationPriority) -> None: ...

    def set_title(self, title: builtins.str) -> None: ...

    def set_urgent(self, urgent: builtins.bool) -> None: ...


class OutputStream(GObject.Object):
    parent_instance: GObject.Object

    def clear_pending(self) -> None: ...

    def close(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def close_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def close_finish(self, result: AsyncResult) -> builtins.bool: ...

    def flush(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def flush_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def flush_finish(self, result: AsyncResult) -> builtins.bool: ...

    def has_pending(self) -> builtins.bool: ...

    def is_closed(self) -> builtins.bool: ...

    def is_closing(self) -> builtins.bool: ...

    def set_pending(self) -> builtins.bool: ...

    def splice(self, source: InputStream, flags: OutputStreamSpliceFlags, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def splice_async(self, source: InputStream, flags: OutputStreamSpliceFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def splice_finish(self, result: AsyncResult) -> builtins.int: ...

    def write(self, buffer: builtins.bytes, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def write_all(self, buffer: builtins.bytes, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.bool, builtins.int]: ...

    def write_all_async(self, buffer: builtins.bytes, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def write_all_finish(self, result: AsyncResult) -> typing.Tuple[builtins.bool, builtins.int]: ...

    def write_async(self, buffer: builtins.bytes, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def write_bytes(self, bytes: GLib.Bytes, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def write_bytes_async(self, bytes: GLib.Bytes, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def write_bytes_finish(self, result: AsyncResult) -> builtins.int: ...

    def write_finish(self, result: AsyncResult) -> builtins.int: ...

    def writev(self, vectors: typing.Sequence[OutputVector], cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.bool, builtins.int]: ...

    def writev_all(self, vectors: typing.Sequence[OutputVector], cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.bool, builtins.int]: ...

    def writev_all_async(self, vectors: typing.Sequence[OutputVector], io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def writev_all_finish(self, result: AsyncResult) -> typing.Tuple[builtins.bool, builtins.int]: ...

    def writev_async(self, vectors: typing.Sequence[OutputVector], io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def writev_finish(self, result: AsyncResult) -> typing.Tuple[builtins.bool, builtins.int]: ...

    def do_close_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_close_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_close_fn(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_flush(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_flush_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_flush_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_splice(self, source: InputStream, flags: OutputStreamSpliceFlags, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def do_splice_async(self, source: InputStream, flags: OutputStreamSpliceFlags, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_splice_finish(self, result: AsyncResult) -> builtins.int: ...

    def do_write_async(self, buffer: typing.Optional[builtins.bytes], io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_write_finish(self, result: AsyncResult) -> builtins.int: ...

    def do_write_fn(self, buffer: typing.Optional[builtins.bytes], cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def do_writev_async(self, vectors: typing.Sequence[OutputVector], io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_writev_finish(self, result: AsyncResult) -> typing.Tuple[builtins.bool, builtins.int]: ...

    def do_writev_fn(self, vectors: typing.Sequence[OutputVector], cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.bool, builtins.int]: ...


class Permission(GObject.Object):
    parent_instance: GObject.Object

    def acquire(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def acquire_async(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def acquire_finish(self, result: AsyncResult) -> builtins.bool: ...

    def get_allowed(self) -> builtins.bool: ...

    def get_can_acquire(self) -> builtins.bool: ...

    def get_can_release(self) -> builtins.bool: ...

    def impl_update(self, allowed: builtins.bool, can_acquire: builtins.bool, can_release: builtins.bool) -> None: ...

    def release(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def release_async(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def release_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_acquire(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_acquire_async(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_acquire_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_release(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_release_async(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_release_finish(self, result: AsyncResult) -> builtins.bool: ...


class PollableInputStream(GObject.GInterface):

    def can_poll(self) -> builtins.bool: ...

    def create_source(self, cancellable: typing.Optional[Cancellable]) -> GLib.Source: ...

    def is_readable(self) -> builtins.bool: ...

    def read_nonblocking(self, buffer: builtins.bytes, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def do_can_poll(self) -> builtins.bool: ...

    def do_create_source(self, cancellable: typing.Optional[Cancellable]) -> GLib.Source: ...

    def do_is_readable(self) -> builtins.bool: ...

    def do_read_nonblocking(self, buffer: typing.Optional[builtins.bytes]) -> builtins.int: ...


class PollableOutputStream(GObject.GInterface):

    def can_poll(self) -> builtins.bool: ...

    def create_source(self, cancellable: typing.Optional[Cancellable]) -> GLib.Source: ...

    def is_writable(self) -> builtins.bool: ...

    def write_nonblocking(self, buffer: builtins.bytes, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def writev_nonblocking(self, vectors: typing.Sequence[OutputVector], cancellable: typing.Optional[Cancellable]) -> typing.Tuple[PollableReturn, builtins.int]: ...

    def do_can_poll(self) -> builtins.bool: ...

    def do_create_source(self, cancellable: typing.Optional[Cancellable]) -> GLib.Source: ...

    def do_is_writable(self) -> builtins.bool: ...

    def do_write_nonblocking(self, buffer: typing.Optional[builtins.bytes]) -> builtins.int: ...

    def do_writev_nonblocking(self, vectors: typing.Sequence[OutputVector]) -> typing.Tuple[PollableReturn, builtins.int]: ...


class Proxy(GObject.GInterface):

    def connect(self, connection: IOStream, proxy_address: ProxyAddress, cancellable: typing.Optional[Cancellable]) -> IOStream: ...

    def connect_async(self, connection: IOStream, proxy_address: ProxyAddress, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def connect_finish(self, result: AsyncResult) -> IOStream: ...

    @staticmethod
    def get_default_for_protocol(protocol: builtins.str) -> Proxy: ...

    def supports_hostname(self) -> builtins.bool: ...

    def do_connect(self, connection: IOStream, proxy_address: ProxyAddress, cancellable: typing.Optional[Cancellable]) -> IOStream: ...

    def do_connect_async(self, connection: IOStream, proxy_address: ProxyAddress, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_connect_finish(self, result: AsyncResult) -> IOStream: ...

    def do_supports_hostname(self) -> builtins.bool: ...


class ProxyResolver(GObject.GInterface):

    @staticmethod
    def get_default() -> ProxyResolver: ...

    def is_supported(self) -> builtins.bool: ...

    def lookup(self, uri: builtins.str, cancellable: typing.Optional[Cancellable]) -> typing.Sequence[builtins.str]: ...

    def lookup_async(self, uri: builtins.str, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def lookup_finish(self, result: AsyncResult) -> typing.Sequence[builtins.str]: ...

    def do_is_supported(self) -> builtins.bool: ...

    def do_lookup(self, uri: builtins.str, cancellable: typing.Optional[Cancellable]) -> typing.Sequence[builtins.str]: ...

    def do_lookup_async(self, uri: builtins.str, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_lookup_finish(self, result: AsyncResult) -> typing.Sequence[builtins.str]: ...


class RemoteActionGroup(GObject.GInterface):

    def activate_action_full(self, action_name: builtins.str, parameter: typing.Optional[GLib.Variant], platform_data: GLib.Variant) -> None: ...

    def change_action_state_full(self, action_name: builtins.str, value: GLib.Variant, platform_data: GLib.Variant) -> None: ...

    def do_activate_action_full(self, action_name: builtins.str, parameter: typing.Optional[GLib.Variant], platform_data: GLib.Variant) -> None: ...

    def do_change_action_state_full(self, action_name: builtins.str, value: GLib.Variant, platform_data: GLib.Variant) -> None: ...


class Resolver(GObject.Object):
    parent_instance: GObject.Object

    @staticmethod
    def get_default() -> Resolver: ...

    def lookup_by_address(self, address: InetAddress, cancellable: typing.Optional[Cancellable]) -> builtins.str: ...

    def lookup_by_address_async(self, address: InetAddress, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def lookup_by_address_finish(self, result: AsyncResult) -> builtins.str: ...

    def lookup_by_name(self, hostname: builtins.str, cancellable: typing.Optional[Cancellable]) -> typing.Sequence[InetAddress]: ...

    def lookup_by_name_async(self, hostname: builtins.str, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def lookup_by_name_finish(self, result: AsyncResult) -> typing.Sequence[InetAddress]: ...

    def lookup_by_name_with_flags(self, hostname: builtins.str, flags: ResolverNameLookupFlags, cancellable: typing.Optional[Cancellable]) -> typing.Sequence[InetAddress]: ...

    def lookup_by_name_with_flags_async(self, hostname: builtins.str, flags: ResolverNameLookupFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def lookup_by_name_with_flags_finish(self, result: AsyncResult) -> typing.Sequence[InetAddress]: ...

    def lookup_records(self, rrname: builtins.str, record_type: ResolverRecordType, cancellable: typing.Optional[Cancellable]) -> typing.Sequence[GLib.Variant]: ...

    def lookup_records_async(self, rrname: builtins.str, record_type: ResolverRecordType, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def lookup_records_finish(self, result: AsyncResult) -> typing.Sequence[GLib.Variant]: ...

    def lookup_service(self, service: builtins.str, protocol: builtins.str, domain: builtins.str, cancellable: typing.Optional[Cancellable]) -> typing.Sequence[SrvTarget]: ...

    def lookup_service_async(self, service: builtins.str, protocol: builtins.str, domain: builtins.str, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def lookup_service_finish(self, result: AsyncResult) -> typing.Sequence[SrvTarget]: ...

    def set_default(self) -> None: ...

    def do_lookup_by_address(self, address: InetAddress, cancellable: typing.Optional[Cancellable]) -> builtins.str: ...

    def do_lookup_by_address_async(self, address: InetAddress, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_lookup_by_address_finish(self, result: AsyncResult) -> builtins.str: ...

    def do_lookup_by_name(self, hostname: builtins.str, cancellable: typing.Optional[Cancellable]) -> typing.Sequence[InetAddress]: ...

    def do_lookup_by_name_async(self, hostname: builtins.str, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_lookup_by_name_finish(self, result: AsyncResult) -> typing.Sequence[InetAddress]: ...

    def do_lookup_by_name_with_flags(self, hostname: builtins.str, flags: ResolverNameLookupFlags, cancellable: typing.Optional[Cancellable]) -> typing.Sequence[InetAddress]: ...

    def do_lookup_by_name_with_flags_async(self, hostname: builtins.str, flags: ResolverNameLookupFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_lookup_by_name_with_flags_finish(self, result: AsyncResult) -> typing.Sequence[InetAddress]: ...

    def do_lookup_records(self, rrname: builtins.str, record_type: ResolverRecordType, cancellable: typing.Optional[Cancellable]) -> typing.Sequence[GLib.Variant]: ...

    def do_lookup_records_async(self, rrname: builtins.str, record_type: ResolverRecordType, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_lookup_records_finish(self, result: AsyncResult) -> typing.Sequence[GLib.Variant]: ...

    def do_lookup_service_async(self, rrname: builtins.str, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_lookup_service_finish(self, result: AsyncResult) -> typing.Sequence[SrvTarget]: ...

    def do_reload(self) -> None: ...


class Seekable(GObject.GInterface):

    def can_seek(self) -> builtins.bool: ...

    def can_truncate(self) -> builtins.bool: ...

    def seek(self, offset: builtins.int, type: GLib.SeekType, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def tell(self) -> builtins.int: ...

    def truncate(self, offset: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_can_seek(self) -> builtins.bool: ...

    def do_can_truncate(self) -> builtins.bool: ...

    def do_seek(self, offset: builtins.int, type: GLib.SeekType, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_tell(self) -> builtins.int: ...

    def do_truncate_fn(self, offset: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...


class Settings(GObject.Object):
    parent_instance: GObject.Object

    def __init__(self, *, path: typing.Optional[str] = None, schema: typing.Optional[str] = None, schema_id: typing.Optional[str] = None) -> None: ...

    def __getitem__(self, key: str) -> typing.Any: ...

    def __setitem__(self, key: str, value: object) -> None: ...

    def apply(self) -> None: ...

    def bind(self, key: builtins.str, object: GObject.Object, property: builtins.str, flags: SettingsBindFlags) -> None: ...

    def bind_writable(self, key: builtins.str, object: GObject.Object, property: builtins.str, inverted: builtins.bool) -> None: ...

    def create_action(self, key: builtins.str) -> Action: ...

    def delay(self) -> None: ...

    def get_boolean(self, key: builtins.str) -> builtins.bool: ...

    def get_child(self, name: builtins.str) -> Settings: ...

    def get_default_value(self, key: builtins.str) -> typing.Optional[GLib.Variant]: ...

    def get_double(self, key: builtins.str) -> builtins.float: ...

    def get_enum(self, key: builtins.str) -> builtins.int: ...

    def get_flags(self, key: builtins.str) -> builtins.int: ...

    def get_has_unapplied(self) -> builtins.bool: ...

    def get_int(self, key: builtins.str) -> builtins.int: ...

    def get_int64(self, key: builtins.str) -> builtins.int: ...

    def get_mapped(self, key: builtins.str, mapping: SettingsGetMapping, *user_data: typing.Optional[builtins.object]) -> typing.Optional[builtins.object]: ...

    def get_range(self, key: builtins.str) -> GLib.Variant: ...

    def get_string(self, key: builtins.str) -> builtins.str: ...

    def get_strv(self, key: builtins.str) -> typing.Sequence[builtins.str]: ...

    def get_uint(self, key: builtins.str) -> builtins.int: ...

    def get_uint64(self, key: builtins.str) -> builtins.int: ...

    def get_user_value(self, key: builtins.str) -> typing.Optional[GLib.Variant]: ...

    def get_value(self, key: builtins.str) -> GLib.Variant: ...

    def is_writable(self, name: builtins.str) -> builtins.bool: ...

    def list_children(self) -> typing.Sequence[builtins.str]: ...

    def list_keys(self) -> typing.Sequence[builtins.str]: ...

    @staticmethod
    def list_relocatable_schemas() -> typing.Sequence[builtins.str]: ...

    @staticmethod
    def list_schemas() -> typing.Sequence[builtins.str]: ...

    @staticmethod
    def new(schema_id: builtins.str, **kwargs) -> Settings: ...  # type: ignore

    @staticmethod
    def new_full(schema: SettingsSchema, backend: typing.Optional[SettingsBackend], path: typing.Optional[builtins.str]) -> Settings: ...

    @staticmethod
    def new_with_backend(schema_id: builtins.str, backend: SettingsBackend) -> Settings: ...

    @staticmethod
    def new_with_backend_and_path(schema_id: builtins.str, backend: SettingsBackend, path: builtins.str) -> Settings: ...

    @staticmethod
    def new_with_path(schema_id: builtins.str, path: builtins.str) -> Settings: ...

    def range_check(self, key: builtins.str, value: GLib.Variant) -> builtins.bool: ...

    def reset(self, key: builtins.str) -> None: ...

    def revert(self) -> None: ...

    def set_boolean(self, key: builtins.str, value: builtins.bool) -> builtins.bool: ...

    def set_double(self, key: builtins.str, value: builtins.float) -> builtins.bool: ...

    def set_enum(self, key: builtins.str, value: builtins.int) -> builtins.bool: ...

    def set_flags(self, key: builtins.str, value: builtins.int) -> builtins.bool: ...

    def set_int(self, key: builtins.str, value: builtins.int) -> builtins.bool: ...

    def set_int64(self, key: builtins.str, value: builtins.int) -> builtins.bool: ...

    def set_string(self, key: builtins.str, value: builtins.str) -> builtins.bool: ...

    def set_strv(self, key: builtins.str, value: typing.Optional[typing.Sequence[builtins.str]]) -> builtins.bool: ...

    def set_uint(self, key: builtins.str, value: builtins.int) -> builtins.bool: ...

    def set_uint64(self, key: builtins.str, value: builtins.int) -> builtins.bool: ...

    def set_value(self, key: builtins.str, value: GLib.Variant) -> builtins.bool: ...

    @staticmethod
    def sync() -> None: ...

    @staticmethod
    def unbind(object: GObject.Object, property: builtins.str) -> None: ...

    def do_change_event(self, keys: builtins.int, n_keys: builtins.int) -> builtins.bool: ...

    def do_changed(self, key: builtins.str) -> None: ...

    def do_writable_change_event(self, key: builtins.int) -> builtins.bool: ...

    def do_writable_changed(self, key: builtins.str) -> None: ...


class SettingsBackend(GObject.Object):
    parent_instance: GObject.Object

    def changed(self, key: builtins.str, origin_tag: typing.Optional[builtins.object]) -> None: ...

    def changed_tree(self, tree: GLib.Tree, origin_tag: typing.Optional[builtins.object]) -> None: ...

    @staticmethod
    def flatten_tree(tree: GLib.Tree) -> typing.Tuple[builtins.str, typing.Sequence[builtins.str], typing.Sequence[GLib.Variant]]: ...

    @staticmethod
    def get_default() -> SettingsBackend: ...

    def keys_changed(self, path: builtins.str, items: typing.Sequence[builtins.str], origin_tag: typing.Optional[builtins.object]) -> None: ...

    def path_changed(self, path: builtins.str, origin_tag: typing.Optional[builtins.object]) -> None: ...

    def path_writable_changed(self, path: builtins.str) -> None: ...

    def writable_changed(self, key: builtins.str) -> None: ...

    def do_get_writable(self, key: builtins.str) -> builtins.bool: ...

    def do_read(self, key: builtins.str, expected_type: GLib.VariantType, default_value: builtins.bool) -> GLib.Variant: ...

    def do_read_user_value(self, key: builtins.str, expected_type: GLib.VariantType) -> GLib.Variant: ...

    def do_reset(self, key: builtins.str, origin_tag: typing.Optional[builtins.object]) -> None: ...

    def do_subscribe(self, name: builtins.str) -> None: ...

    def do_sync(self) -> None: ...

    def do_unsubscribe(self, name: builtins.str) -> None: ...

    def do_write(self, key: builtins.str, value: GLib.Variant, origin_tag: typing.Optional[builtins.object]) -> builtins.bool: ...

    def do_write_tree(self, tree: GLib.Tree, origin_tag: typing.Optional[builtins.object]) -> builtins.bool: ...


class SocketAddressEnumerator(GObject.Object):
    parent_instance: GObject.Object

    def next(self, cancellable: typing.Optional[Cancellable]) -> SocketAddress: ...

    def next_async(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def next_finish(self, result: AsyncResult) -> SocketAddress: ...

    def do_next(self, cancellable: typing.Optional[Cancellable]) -> SocketAddress: ...

    def do_next_async(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_next_finish(self, result: AsyncResult) -> SocketAddress: ...


class SocketClient(GObject.Object):
    parent_instance: GObject.Object

    def add_application_proxy(self, protocol: builtins.str) -> None: ...

    def connect(self, connectable: SocketConnectable, cancellable: typing.Optional[Cancellable]) -> SocketConnection: ...  # type: ignore

    def connect_async(self, connectable: SocketConnectable, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def connect_finish(self, result: AsyncResult) -> SocketConnection: ...

    def connect_to_host(self, host_and_port: builtins.str, default_port: builtins.int, cancellable: typing.Optional[Cancellable]) -> SocketConnection: ...

    def connect_to_host_async(self, host_and_port: builtins.str, default_port: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def connect_to_host_finish(self, result: AsyncResult) -> SocketConnection: ...

    def connect_to_service(self, domain: builtins.str, service: builtins.str, cancellable: typing.Optional[Cancellable]) -> SocketConnection: ...

    def connect_to_service_async(self, domain: builtins.str, service: builtins.str, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def connect_to_service_finish(self, result: AsyncResult) -> SocketConnection: ...

    def connect_to_uri(self, uri: builtins.str, default_port: builtins.int, cancellable: typing.Optional[Cancellable]) -> SocketConnection: ...

    def connect_to_uri_async(self, uri: builtins.str, default_port: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def connect_to_uri_finish(self, result: AsyncResult) -> SocketConnection: ...

    def get_enable_proxy(self) -> builtins.bool: ...

    def get_family(self) -> SocketFamily: ...

    def get_local_address(self) -> SocketAddress: ...

    def get_protocol(self) -> SocketProtocol: ...

    def get_proxy_resolver(self) -> ProxyResolver: ...

    def get_socket_type(self) -> SocketType: ...

    def get_timeout(self) -> builtins.int: ...

    def get_tls(self) -> builtins.bool: ...

    def get_tls_validation_flags(self) -> TlsCertificateFlags: ...

    @staticmethod
    def new(**kwargs) -> SocketClient: ...  # type: ignore

    def set_enable_proxy(self, enable: builtins.bool) -> None: ...

    def set_family(self, family: SocketFamily) -> None: ...

    def set_local_address(self, address: typing.Optional[SocketAddress]) -> None: ...

    def set_protocol(self, protocol: SocketProtocol) -> None: ...

    def set_proxy_resolver(self, proxy_resolver: typing.Optional[ProxyResolver]) -> None: ...

    def set_socket_type(self, type: SocketType) -> None: ...

    def set_timeout(self, timeout: builtins.int) -> None: ...

    def set_tls(self, tls: builtins.bool) -> None: ...

    def set_tls_validation_flags(self, flags: TlsCertificateFlags) -> None: ...

    def do_event(self, event: SocketClientEvent, connectable: SocketConnectable, connection: IOStream) -> None: ...


class SocketConnectable(GObject.GInterface):

    def enumerate(self) -> SocketAddressEnumerator: ...

    def proxy_enumerate(self) -> SocketAddressEnumerator: ...

    def to_string(self) -> builtins.str: ...

    def do_enumerate(self) -> SocketAddressEnumerator: ...

    def do_proxy_enumerate(self) -> SocketAddressEnumerator: ...

    def do_to_string(self) -> builtins.str: ...


class SocketControlMessage(GObject.Object):
    parent_instance: GObject.Object

    @staticmethod
    def deserialize(level: builtins.int, type: builtins.int, data: builtins.bytes) -> SocketControlMessage: ...

    def get_level(self) -> builtins.int: ...

    def get_msg_type(self) -> builtins.int: ...

    def get_size(self) -> builtins.int: ...

    def serialize(self, data: builtins.object) -> None: ...

    def do_get_level(self) -> builtins.int: ...

    def do_get_size(self) -> builtins.int: ...

    def do_get_type(self) -> builtins.int: ...

    def do_serialize(self, data: builtins.object) -> None: ...


class SocketListener(GObject.Object):
    parent_instance: GObject.Object

    def accept(self, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[SocketConnection, typing.Optional[GObject.Object]]: ...

    def accept_async(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def accept_finish(self, result: AsyncResult) -> typing.Tuple[SocketConnection, typing.Optional[GObject.Object]]: ...

    def accept_socket(self, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[Socket, typing.Optional[GObject.Object]]: ...

    def accept_socket_async(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def accept_socket_finish(self, result: AsyncResult) -> typing.Tuple[Socket, typing.Optional[GObject.Object]]: ...

    def add_address(self, address: SocketAddress, type: SocketType, protocol: SocketProtocol, source_object: typing.Optional[GObject.Object]) -> typing.Tuple[builtins.bool, SocketAddress]: ...

    def add_any_inet_port(self, source_object: typing.Optional[GObject.Object]) -> builtins.int: ...

    def add_inet_port(self, port: builtins.int, source_object: typing.Optional[GObject.Object]) -> builtins.bool: ...

    def add_socket(self, socket: Socket, source_object: typing.Optional[GObject.Object]) -> builtins.bool: ...

    def close(self) -> None: ...

    @staticmethod
    def new(**kwargs) -> SocketListener: ...  # type: ignore

    def set_backlog(self, listen_backlog: builtins.int) -> None: ...

    def do_changed(self) -> None: ...

    def do_event(self, event: SocketListenerEvent, socket: Socket) -> None: ...


class SubprocessLauncher(GObject.Object):

    def getenv(self, variable: builtins.str) -> builtins.str: ...

    @staticmethod
    def new(flags: SubprocessFlags, **kwargs) -> SubprocessLauncher: ...  # type: ignore

    def set_cwd(self, cwd: builtins.str) -> None: ...

    def set_environ(self, env: typing.Sequence[builtins.str]) -> None: ...

    def set_flags(self, flags: SubprocessFlags) -> None: ...

    def set_stderr_file_path(self, path: typing.Optional[builtins.str]) -> None: ...

    def set_stdin_file_path(self, path: builtins.str) -> None: ...

    def set_stdout_file_path(self, path: typing.Optional[builtins.str]) -> None: ...

    def setenv(self, variable: builtins.str, value: builtins.str, overwrite: builtins.bool) -> None: ...

    def spawnv(self, argv: typing.Sequence[builtins.str]) -> Subprocess: ...

    def take_fd(self, source_fd: builtins.int, target_fd: builtins.int) -> None: ...

    def take_stderr_fd(self, fd: builtins.int) -> None: ...

    def take_stdin_fd(self, fd: builtins.int) -> None: ...

    def take_stdout_fd(self, fd: builtins.int) -> None: ...

    def unsetenv(self, variable: builtins.str) -> None: ...


class TestDBus(GObject.Object):

    def add_service_dir(self, path: builtins.str) -> None: ...

    def down(self) -> None: ...

    def get_bus_address(self) -> typing.Optional[builtins.str]: ...

    def get_flags(self) -> TestDBusFlags: ...

    @staticmethod
    def new(flags: TestDBusFlags, **kwargs) -> TestDBus: ...  # type: ignore

    def stop(self) -> None: ...

    @staticmethod
    def unset() -> None: ...

    def up(self) -> None: ...


class TlsBackend(GObject.GInterface):

    def get_certificate_type(self) -> GObject.GType: ...

    def get_client_connection_type(self) -> GObject.GType: ...

    @staticmethod
    def get_default() -> TlsBackend: ...

    def get_default_database(self) -> TlsDatabase: ...

    def get_dtls_client_connection_type(self) -> GObject.GType: ...

    def get_dtls_server_connection_type(self) -> GObject.GType: ...

    def get_file_database_type(self) -> GObject.GType: ...

    def get_server_connection_type(self) -> GObject.GType: ...

    def set_default_database(self, database: typing.Optional[TlsDatabase]) -> None: ...

    def supports_dtls(self) -> builtins.bool: ...

    def supports_tls(self) -> builtins.bool: ...

    def do_get_default_database(self) -> TlsDatabase: ...

    def do_supports_dtls(self) -> builtins.bool: ...

    def do_supports_tls(self) -> builtins.bool: ...


class TlsCertificate(GObject.Object):
    parent_instance: GObject.Object

    def get_issuer(self) -> TlsCertificate: ...

    def is_same(self, cert_two: TlsCertificate) -> builtins.bool: ...

    @staticmethod
    def list_new_from_file(file: builtins.str) -> typing.Sequence[TlsCertificate]: ...

    @staticmethod
    def new_from_file(file: builtins.str) -> TlsCertificate: ...

    @staticmethod
    def new_from_files(cert_file: builtins.str, key_file: builtins.str) -> TlsCertificate: ...

    @staticmethod
    def new_from_pem(data: builtins.str, length: builtins.int) -> TlsCertificate: ...

    def verify(self, identity: typing.Optional[SocketConnectable], trusted_ca: typing.Optional[TlsCertificate]) -> TlsCertificateFlags: ...

    def do_verify(self, identity: typing.Optional[SocketConnectable], trusted_ca: typing.Optional[TlsCertificate]) -> TlsCertificateFlags: ...


class TlsClientConnection(GObject.GInterface):

    def copy_session_state(self, source: TlsClientConnection) -> None: ...

    def get_accepted_cas(self) -> typing.Sequence[builtins.bytes]: ...

    def get_server_identity(self) -> SocketConnectable: ...

    def get_use_ssl3(self) -> builtins.bool: ...

    def get_validation_flags(self) -> TlsCertificateFlags: ...

    @staticmethod
    def new(base_io_stream: IOStream, server_identity: typing.Optional[SocketConnectable]) -> TlsClientConnection: ...

    def set_server_identity(self, identity: SocketConnectable) -> None: ...

    def set_use_ssl3(self, use_ssl3: builtins.bool) -> None: ...

    def set_validation_flags(self, flags: TlsCertificateFlags) -> None: ...

    def do_copy_session_state(self, source: TlsClientConnection) -> None: ...


class TlsDatabase(GObject.Object):
    parent_instance: GObject.Object

    def create_certificate_handle(self, certificate: TlsCertificate) -> typing.Optional[builtins.str]: ...

    def lookup_certificate_for_handle(self, handle: builtins.str, interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseLookupFlags, cancellable: typing.Optional[Cancellable]) -> typing.Optional[TlsCertificate]: ...

    def lookup_certificate_for_handle_async(self, handle: builtins.str, interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseLookupFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def lookup_certificate_for_handle_finish(self, result: AsyncResult) -> TlsCertificate: ...

    def lookup_certificate_issuer(self, certificate: TlsCertificate, interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseLookupFlags, cancellable: typing.Optional[Cancellable]) -> TlsCertificate: ...

    def lookup_certificate_issuer_async(self, certificate: TlsCertificate, interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseLookupFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def lookup_certificate_issuer_finish(self, result: AsyncResult) -> TlsCertificate: ...

    def lookup_certificates_issued_by(self, issuer_raw_dn: builtins.bytes, interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseLookupFlags, cancellable: typing.Optional[Cancellable]) -> typing.Sequence[TlsCertificate]: ...

    def lookup_certificates_issued_by_async(self, issuer_raw_dn: builtins.bytes, interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseLookupFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def lookup_certificates_issued_by_finish(self, result: AsyncResult) -> typing.Sequence[TlsCertificate]: ...

    def verify_chain(self, chain: TlsCertificate, purpose: builtins.str, identity: typing.Optional[SocketConnectable], interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseVerifyFlags, cancellable: typing.Optional[Cancellable]) -> TlsCertificateFlags: ...

    def verify_chain_async(self, chain: TlsCertificate, purpose: builtins.str, identity: typing.Optional[SocketConnectable], interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseVerifyFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def verify_chain_finish(self, result: AsyncResult) -> TlsCertificateFlags: ...

    def do_create_certificate_handle(self, certificate: TlsCertificate) -> typing.Optional[builtins.str]: ...

    def do_lookup_certificate_for_handle(self, handle: builtins.str, interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseLookupFlags, cancellable: typing.Optional[Cancellable]) -> typing.Optional[TlsCertificate]: ...

    def do_lookup_certificate_for_handle_async(self, handle: builtins.str, interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseLookupFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_lookup_certificate_for_handle_finish(self, result: AsyncResult) -> TlsCertificate: ...

    def do_lookup_certificate_issuer(self, certificate: TlsCertificate, interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseLookupFlags, cancellable: typing.Optional[Cancellable]) -> TlsCertificate: ...

    def do_lookup_certificate_issuer_async(self, certificate: TlsCertificate, interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseLookupFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_lookup_certificate_issuer_finish(self, result: AsyncResult) -> TlsCertificate: ...

    def do_lookup_certificates_issued_by(self, issuer_raw_dn: builtins.bytes, interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseLookupFlags, cancellable: typing.Optional[Cancellable]) -> typing.Sequence[TlsCertificate]: ...

    def do_lookup_certificates_issued_by_async(self, issuer_raw_dn: builtins.bytes, interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseLookupFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_lookup_certificates_issued_by_finish(self, result: AsyncResult) -> typing.Sequence[TlsCertificate]: ...

    def do_verify_chain(self, chain: TlsCertificate, purpose: builtins.str, identity: typing.Optional[SocketConnectable], interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseVerifyFlags, cancellable: typing.Optional[Cancellable]) -> TlsCertificateFlags: ...

    def do_verify_chain_async(self, chain: TlsCertificate, purpose: builtins.str, identity: typing.Optional[SocketConnectable], interaction: typing.Optional[TlsInteraction], flags: TlsDatabaseVerifyFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_verify_chain_finish(self, result: AsyncResult) -> TlsCertificateFlags: ...


class TlsFileDatabase(GObject.GInterface):

    @staticmethod
    def new(anchors: builtins.str) -> TlsFileDatabase: ...


class TlsInteraction(GObject.Object):
    parent_instance: GObject.Object

    def ask_password(self, password: TlsPassword, cancellable: typing.Optional[Cancellable]) -> TlsInteractionResult: ...

    def ask_password_async(self, password: TlsPassword, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def ask_password_finish(self, result: AsyncResult) -> TlsInteractionResult: ...

    def invoke_ask_password(self, password: TlsPassword, cancellable: typing.Optional[Cancellable]) -> TlsInteractionResult: ...

    def invoke_request_certificate(self, connection: TlsConnection, flags: TlsCertificateRequestFlags, cancellable: typing.Optional[Cancellable]) -> TlsInteractionResult: ...

    def request_certificate(self, connection: TlsConnection, flags: TlsCertificateRequestFlags, cancellable: typing.Optional[Cancellable]) -> TlsInteractionResult: ...

    def request_certificate_async(self, connection: TlsConnection, flags: TlsCertificateRequestFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def request_certificate_finish(self, result: AsyncResult) -> TlsInteractionResult: ...

    def do_ask_password(self, password: TlsPassword, cancellable: typing.Optional[Cancellable]) -> TlsInteractionResult: ...

    def do_ask_password_async(self, password: TlsPassword, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_ask_password_finish(self, result: AsyncResult) -> TlsInteractionResult: ...

    def do_request_certificate(self, connection: TlsConnection, flags: TlsCertificateRequestFlags, cancellable: typing.Optional[Cancellable]) -> TlsInteractionResult: ...

    def do_request_certificate_async(self, connection: TlsConnection, flags: TlsCertificateRequestFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_request_certificate_finish(self, result: AsyncResult) -> TlsInteractionResult: ...


class TlsPassword(GObject.Object):
    parent_instance: GObject.Object

    def get_description(self) -> builtins.str: ...

    def get_flags(self) -> TlsPasswordFlags: ...

    def get_value(self, length: typing.Optional[builtins.int]) -> builtins.int: ...

    def get_warning(self) -> builtins.str: ...

    @staticmethod
    def new(flags: TlsPasswordFlags, description: builtins.str, **kwargs) -> TlsPassword: ...  # type: ignore

    def set_description(self, description: builtins.str) -> None: ...

    def set_flags(self, flags: TlsPasswordFlags) -> None: ...

    def set_value(self, value: builtins.bytes) -> None: ...

    def set_value_full(self, value: builtins.bytes, destroy: typing.Optional[GLib.DestroyNotify]) -> None: ...

    def set_warning(self, warning: builtins.str) -> None: ...

    def do_get_default_warning(self) -> builtins.str: ...

    def do_get_value(self, length: typing.Optional[builtins.int]) -> builtins.int: ...

    def do_set_value(self, value: builtins.bytes, destroy: typing.Optional[GLib.DestroyNotify]) -> None: ...


class TlsServerConnection(GObject.GInterface):

    @staticmethod
    def new(base_io_stream: IOStream, certificate: typing.Optional[TlsCertificate]) -> TlsServerConnection: ...


class UnixFDList(GObject.Object):
    parent_instance: GObject.Object

    def append(self, fd: builtins.int) -> builtins.int: ...

    def get(self, index_: builtins.int) -> builtins.int: ...

    def get_length(self) -> builtins.int: ...

    @staticmethod
    def new(**kwargs) -> UnixFDList: ...  # type: ignore

    @staticmethod
    def new_from_array(fds: typing.Sequence[builtins.int]) -> UnixFDList: ...

    def peek_fds(self) -> typing.Sequence[builtins.int]: ...

    def steal_fds(self) -> typing.Sequence[builtins.int]: ...


class UnixMountMonitor(GObject.Object):

    @staticmethod
    def get() -> UnixMountMonitor: ...

    @staticmethod
    def new(**kwargs) -> UnixMountMonitor: ...  # type: ignore

    def set_rate_limit(self, limit_msec: builtins.int) -> None: ...


class Vfs(GObject.Object):
    parent_instance: GObject.Object

    @staticmethod
    def get_default() -> Vfs: ...

    def get_file_for_path(self, path: builtins.str) -> File: ...

    def get_file_for_uri(self, uri: builtins.str) -> File: ...

    @staticmethod
    def get_local() -> Vfs: ...

    def get_supported_uri_schemes(self) -> typing.Sequence[builtins.str]: ...

    def is_active(self) -> builtins.bool: ...

    def parse_name(self, parse_name: builtins.str) -> File: ...

    def register_uri_scheme(self, scheme: builtins.str, uri_func: typing.Optional[VfsFileLookupFunc], uri_data: typing.Optional[builtins.object], parse_name_func: typing.Optional[VfsFileLookupFunc], *parse_name_data: typing.Optional[builtins.object]) -> builtins.bool: ...

    def unregister_uri_scheme(self, scheme: builtins.str) -> builtins.bool: ...

    def do_add_writable_namespaces(self, list: FileAttributeInfoList) -> None: ...

    def do_get_file_for_path(self, path: builtins.str) -> File: ...

    def do_get_file_for_uri(self, uri: builtins.str) -> File: ...

    def do_get_supported_uri_schemes(self) -> typing.Sequence[builtins.str]: ...

    def do_is_active(self) -> builtins.bool: ...

    def do_local_file_add_info(self, filename: builtins.str, device: builtins.int, attribute_matcher: FileAttributeMatcher, info: FileInfo, cancellable: typing.Optional[Cancellable], extra_data: typing.Optional[builtins.object], free_extra_data: GLib.DestroyNotify) -> None: ...

    def do_local_file_moved(self, source: builtins.str, dest: builtins.str) -> None: ...

    def do_local_file_removed(self, filename: builtins.str) -> None: ...

    def do_local_file_set_attributes(self, filename: builtins.str, info: FileInfo, flags: FileQueryInfoFlags, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_parse_name(self, parse_name: builtins.str) -> File: ...


class Volume(GObject.GInterface):

    def can_eject(self) -> builtins.bool: ...

    def can_mount(self) -> builtins.bool: ...

    def eject(self, flags: MountUnmountFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def eject_finish(self, result: AsyncResult) -> builtins.bool: ...

    def eject_with_operation(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def eject_with_operation_finish(self, result: AsyncResult) -> builtins.bool: ...

    def enumerate_identifiers(self) -> typing.Sequence[builtins.str]: ...

    def get_activation_root(self) -> typing.Optional[File]: ...

    def get_drive(self) -> typing.Optional[Drive]: ...

    def get_icon(self) -> Icon: ...

    def get_identifier(self, kind: builtins.str) -> typing.Optional[builtins.str]: ...

    def get_mount(self) -> typing.Optional[Mount]: ...

    def get_name(self) -> builtins.str: ...

    def get_sort_key(self) -> typing.Optional[builtins.str]: ...

    def get_symbolic_icon(self) -> Icon: ...

    def get_uuid(self) -> typing.Optional[builtins.str]: ...

    def mount(self, flags: MountMountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def mount_finish(self, result: AsyncResult) -> builtins.bool: ...

    def should_automount(self) -> builtins.bool: ...

    def do_can_eject(self) -> builtins.bool: ...

    def do_can_mount(self) -> builtins.bool: ...

    def do_changed(self) -> None: ...

    def do_eject(self, flags: MountUnmountFlags, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_eject_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_eject_with_operation(self, flags: MountUnmountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_eject_with_operation_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_enumerate_identifiers(self) -> typing.Sequence[builtins.str]: ...

    def do_get_activation_root(self) -> typing.Optional[File]: ...

    def do_get_drive(self) -> typing.Optional[Drive]: ...

    def do_get_icon(self) -> Icon: ...

    def do_get_identifier(self, kind: builtins.str) -> typing.Optional[builtins.str]: ...

    def do_get_mount(self) -> typing.Optional[Mount]: ...

    def do_get_name(self) -> builtins.str: ...

    def do_get_sort_key(self) -> typing.Optional[builtins.str]: ...

    def do_get_symbolic_icon(self) -> Icon: ...

    def do_get_uuid(self) -> typing.Optional[builtins.str]: ...

    def do_mount_finish(self, result: AsyncResult) -> builtins.bool: ...

    def do_mount_fn(self, flags: MountMountFlags, mount_operation: typing.Optional[MountOperation], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_removed(self) -> None: ...

    def do_should_automount(self) -> builtins.bool: ...


class VolumeMonitor(GObject.Object):
    parent_instance: GObject.Object
    priv: builtins.object

    @staticmethod
    def adopt_orphan_mount(mount: Mount) -> Volume: ...

    @staticmethod
    def get() -> VolumeMonitor: ...

    def get_connected_drives(self) -> typing.Sequence[Drive]: ...

    def get_mount_for_uuid(self, uuid: builtins.str) -> Mount: ...

    def get_mounts(self) -> typing.Sequence[Mount]: ...

    def get_volume_for_uuid(self, uuid: builtins.str) -> Volume: ...

    def get_volumes(self) -> typing.Sequence[Volume]: ...

    def do_drive_changed(self, drive: Drive) -> None: ...

    def do_drive_connected(self, drive: Drive) -> None: ...

    def do_drive_disconnected(self, drive: Drive) -> None: ...

    def do_drive_eject_button(self, drive: Drive) -> None: ...

    def do_drive_stop_button(self, drive: Drive) -> None: ...

    def do_get_connected_drives(self) -> typing.Sequence[Drive]: ...

    def do_get_mount_for_uuid(self, uuid: builtins.str) -> Mount: ...

    def do_get_mounts(self) -> typing.Sequence[Mount]: ...

    def do_get_volume_for_uuid(self, uuid: builtins.str) -> Volume: ...

    def do_get_volumes(self) -> typing.Sequence[Volume]: ...

    def do_mount_added(self, mount: Mount) -> None: ...

    def do_mount_changed(self, mount: Mount) -> None: ...

    def do_mount_pre_unmount(self, mount: Mount) -> None: ...

    def do_mount_removed(self, mount: Mount) -> None: ...

    def do_volume_added(self, volume: Volume) -> None: ...

    def do_volume_changed(self, volume: Volume) -> None: ...

    def do_volume_removed(self, volume: Volume) -> None: ...


class PropertyAction(GObject.Object, Action):

    @staticmethod
    def new(name: builtins.str, object: GObject.Object, property_name: builtins.str, **kwargs) -> PropertyAction: ...  # type: ignore


class SimpleAction(GObject.Object, Action):

    @staticmethod
    def new(name: builtins.str, parameter_type: typing.Optional[GLib.VariantType], **kwargs) -> SimpleAction: ...  # type: ignore

    @staticmethod
    def new_stateful(name: builtins.str, parameter_type: typing.Optional[GLib.VariantType], state: GLib.Variant) -> SimpleAction: ...

    def set_enabled(self, enabled: builtins.bool) -> None: ...

    def set_state(self, value: GLib.Variant) -> None: ...

    def set_state_hint(self, state_hint: typing.Optional[GLib.Variant]) -> None: ...


class Application(GObject.Object, ActionGroup, ActionMap):
    parent_instance: GObject.Object

    def __init__(self, *, application_id: typing.Optional[str] = None, flags: ApplicationFlags = ApplicationFlags.FLAGS_NONE) -> None: ...

    def activate(self) -> None: ...

    def add_main_option(self, long_name: builtins.str, short_name: builtins.int, flags: GLib.OptionFlags, arg: GLib.OptionArg, description: builtins.str, arg_description: typing.Optional[builtins.str]) -> None: ...

    def add_main_option_entries(self, entries: typing.Sequence[GLib.OptionEntry]) -> None: ...

    def add_option_group(self, group: GLib.OptionGroup) -> None: ...

    def bind_busy_property(self, object: GObject.Object, property: builtins.str) -> None: ...

    def get_application_id(self) -> builtins.str: ...

    def get_dbus_connection(self) -> DBusConnection: ...

    def get_dbus_object_path(self) -> builtins.str: ...

    @staticmethod
    def get_default() -> Application: ...

    def get_flags(self) -> ApplicationFlags: ...

    def get_inactivity_timeout(self) -> builtins.int: ...

    def get_is_busy(self) -> builtins.bool: ...

    def get_is_registered(self) -> builtins.bool: ...

    def get_is_remote(self) -> builtins.bool: ...

    def get_resource_base_path(self) -> typing.Optional[builtins.str]: ...

    def hold(self) -> None: ...

    @staticmethod
    def id_is_valid(application_id: builtins.str) -> builtins.bool: ...

    def mark_busy(self) -> None: ...

    @staticmethod
    def new(application_id: typing.Optional[builtins.str], flags: ApplicationFlags, **kwargs) -> Application: ...  # type: ignore

    def open(self, files: typing.Sequence[File], hint: builtins.str) -> None: ...

    def quit(self) -> None: ...

    def register(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def release(self) -> None: ...

    def run(self, argv: typing.Optional[typing.Sequence[builtins.str]]) -> builtins.int: ...

    def send_notification(self, id: typing.Optional[builtins.str], notification: Notification) -> None: ...

    def set_action_group(self, action_group: typing.Optional[ActionGroup]) -> None: ...

    def set_application_id(self, application_id: typing.Optional[builtins.str]) -> None: ...

    def set_default(self) -> None: ...

    def set_flags(self, flags: ApplicationFlags) -> None: ...

    def set_inactivity_timeout(self, inactivity_timeout: builtins.int) -> None: ...

    def set_option_context_description(self, description: typing.Optional[builtins.str]) -> None: ...

    def set_option_context_parameter_string(self, parameter_string: typing.Optional[builtins.str]) -> None: ...

    def set_option_context_summary(self, summary: typing.Optional[builtins.str]) -> None: ...

    def set_resource_base_path(self, resource_path: typing.Optional[builtins.str]) -> None: ...

    def unbind_busy_property(self, object: GObject.Object, property: builtins.str) -> None: ...

    def unmark_busy(self) -> None: ...

    def withdraw_notification(self, id: builtins.str) -> None: ...

    def do_activate(self) -> None: ...

    def do_add_platform_data(self, builder: GLib.VariantBuilder) -> None: ...

    def do_after_emit(self, platform_data: GLib.Variant) -> None: ...

    def do_before_emit(self, platform_data: GLib.Variant) -> None: ...

    def do_command_line(self, command_line: ApplicationCommandLine) -> builtins.int: ...

    def do_dbus_register(self, connection: DBusConnection, object_path: builtins.str) -> builtins.bool: ...

    def do_dbus_unregister(self, connection: DBusConnection, object_path: builtins.str) -> None: ...

    def do_handle_local_options(self, options: GLib.VariantDict) -> builtins.int: ...

    def do_local_command_line(self, arguments: typing.Sequence[builtins.str]) -> typing.Tuple[builtins.bool, typing.Sequence[builtins.str], builtins.int]: ...

    def do_name_lost(self) -> builtins.bool: ...

    def do_open(self, files: typing.Sequence[File], hint: builtins.str) -> None: ...

    def do_quit_mainloop(self) -> None: ...

    def do_run_mainloop(self) -> None: ...

    def do_shutdown(self) -> None: ...

    def do_startup(self) -> None: ...


class SimpleActionGroup(GObject.Object, ActionGroup, ActionMap):
    parent_instance: GObject.Object

    def add_entries(self, entries: typing.Sequence[ActionEntry], user_data: typing.Optional[builtins.object]) -> None: ...

    def insert(self, action: Action) -> None: ...

    def lookup(self, action_name: builtins.str) -> Action: ...

    @staticmethod
    def new(**kwargs) -> SimpleActionGroup: ...  # type: ignore

    def remove(self, action_name: builtins.str) -> None: ...


class DesktopAppInfo(GObject.Object, AppInfo):

    def get_action_name(self, action_name: builtins.str) -> builtins.str: ...

    def get_boolean(self, key: builtins.str) -> builtins.bool: ...

    def get_categories(self) -> builtins.str: ...

    def get_filename(self) -> builtins.str: ...

    def get_generic_name(self) -> builtins.str: ...

    @staticmethod
    def get_implementations(interface: builtins.str) -> typing.Sequence[DesktopAppInfo]: ...

    def get_is_hidden(self) -> builtins.bool: ...

    def get_keywords(self) -> typing.Sequence[builtins.str]: ...

    def get_locale_string(self, key: builtins.str) -> typing.Optional[builtins.str]: ...

    def get_nodisplay(self) -> builtins.bool: ...

    def get_show_in(self, desktop_env: typing.Optional[builtins.str]) -> builtins.bool: ...

    def get_startup_wm_class(self) -> builtins.str: ...

    def get_string(self, key: builtins.str) -> builtins.str: ...

    def get_string_list(self, key: builtins.str) -> typing.Sequence[builtins.str]: ...

    def has_key(self, key: builtins.str) -> builtins.bool: ...

    def launch_action(self, action_name: builtins.str, launch_context: typing.Optional[AppLaunchContext]) -> None: ...

    def launch_uris_as_manager(self, uris: typing.Sequence[builtins.str], launch_context: typing.Optional[AppLaunchContext], spawn_flags: GLib.SpawnFlags, user_setup: typing.Optional[GLib.SpawnChildSetupFunc], user_setup_data: typing.Optional[builtins.object], pid_callback: typing.Optional[DesktopAppLaunchCallback], *pid_callback_data: typing.Optional[builtins.object]) -> builtins.bool: ...

    def launch_uris_as_manager_with_fds(self, uris: typing.Sequence[builtins.str], launch_context: typing.Optional[AppLaunchContext], spawn_flags: GLib.SpawnFlags, user_setup: typing.Optional[GLib.SpawnChildSetupFunc], user_setup_data: typing.Optional[builtins.object], pid_callback: typing.Optional[DesktopAppLaunchCallback], pid_callback_data: typing.Optional[builtins.object], stdin_fd: builtins.int, stdout_fd: builtins.int, stderr_fd: builtins.int) -> builtins.bool: ...

    def list_actions(self) -> typing.Sequence[builtins.str]: ...

    @staticmethod
    def new(desktop_id: builtins.str, **kwargs) -> typing.Optional[DesktopAppInfo]: ...  # type: ignore

    @staticmethod
    def new_from_filename(filename: builtins.str) -> typing.Optional[DesktopAppInfo]: ...

    @staticmethod
    def new_from_keyfile(key_file: GLib.KeyFile) -> typing.Optional[DesktopAppInfo]: ...

    @staticmethod
    def search(search_string: builtins.str) -> typing.Sequence[typing.Sequence[builtins.str]]: ...

    @staticmethod
    def set_desktop_env(desktop_env: builtins.str) -> None: ...


class SimpleAsyncResult(GObject.Object, AsyncResult):

    def complete(self) -> None: ...

    def complete_in_idle(self) -> None: ...

    def get_op_res_gboolean(self) -> builtins.bool: ...

    def get_op_res_gssize(self) -> builtins.int: ...

    @staticmethod
    def is_valid(result: AsyncResult, source: typing.Optional[GObject.Object], source_tag: typing.Optional[builtins.object]) -> builtins.bool: ...

    @staticmethod
    def new(source_object: typing.Optional[GObject.Object], callback: typing.Optional[AsyncReadyCallback], user_data: typing.Optional[builtins.object], source_tag: typing.Optional[builtins.object], **kwargs) -> SimpleAsyncResult: ...  # type: ignore

    @staticmethod
    def new_from_error(source_object: typing.Optional[GObject.Object], callback: typing.Optional[AsyncReadyCallback], user_data: typing.Optional[builtins.object], error: GLib.Error) -> SimpleAsyncResult: ...

    def propagate_error(self) -> builtins.bool: ...

    def set_check_cancellable(self, check_cancellable: typing.Optional[Cancellable]) -> None: ...

    def set_from_error(self, error: GLib.Error) -> None: ...

    def set_handle_cancellation(self, handle_cancellation: builtins.bool) -> None: ...

    def set_op_res_gboolean(self, op_res: builtins.bool) -> None: ...

    def set_op_res_gssize(self, op_res: builtins.int) -> None: ...


class Task(GObject.Object, AsyncResult):

    def get_cancellable(self) -> Cancellable: ...

    def get_check_cancellable(self) -> builtins.bool: ...

    def get_completed(self) -> builtins.bool: ...

    def get_context(self) -> GLib.MainContext: ...

    def get_name(self) -> typing.Optional[builtins.str]: ...

    def get_priority(self) -> builtins.int: ...

    def get_return_on_cancel(self) -> builtins.bool: ...

    def get_source_object(self) -> typing.Optional[GObject.Object]: ...

    def get_source_tag(self) -> typing.Optional[builtins.object]: ...

    def get_task_data(self) -> typing.Optional[builtins.object]: ...

    def had_error(self) -> builtins.bool: ...

    @staticmethod
    def is_valid(result: AsyncResult, source_object: typing.Optional[GObject.Object]) -> builtins.bool: ...

    @staticmethod
    def new(source_object: typing.Optional[GObject.Object], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *callback_data: typing.Optional[builtins.object], **kwargs) -> Task: ...  # type: ignore

    def propagate_boolean(self) -> builtins.bool: ...

    def propagate_int(self) -> builtins.int: ...

    def propagate_pointer(self) -> typing.Optional[builtins.object]: ...

    def propagate_value(self) -> typing.Tuple[builtins.bool, GObject.Value]: ...

    @staticmethod
    def report_error(source_object: typing.Optional[GObject.Object], callback: typing.Optional[AsyncReadyCallback], callback_data: typing.Optional[builtins.object], source_tag: typing.Optional[builtins.object], error: GLib.Error) -> None: ...

    def return_boolean(self, result: builtins.bool) -> None: ...

    def return_error(self, error: GLib.Error) -> None: ...

    def return_error_if_cancelled(self) -> builtins.bool: ...

    def return_int(self, result: builtins.int) -> None: ...

    def return_pointer(self, result: typing.Optional[builtins.object], result_destroy: typing.Optional[GLib.DestroyNotify]) -> None: ...

    def return_value(self, result: typing.Optional[GObject.Value]) -> None: ...

    def run_in_thread(self, task_func: TaskThreadFunc) -> None: ...

    def run_in_thread_sync(self, task_func: TaskThreadFunc) -> None: ...

    def set_check_cancellable(self, check_cancellable: builtins.bool) -> None: ...

    def set_name(self, name: typing.Optional[builtins.str]) -> None: ...

    def set_priority(self, priority: builtins.int) -> None: ...

    def set_return_on_cancel(self, return_on_cancel: builtins.bool) -> builtins.bool: ...

    def set_source_tag(self, source_tag: typing.Optional[builtins.object]) -> None: ...

    def set_task_data(self, task_data: typing.Optional[builtins.object], task_data_destroy: typing.Optional[GLib.DestroyNotify]) -> None: ...


class ZlibCompressor(GObject.Object, Converter):

    def get_file_info(self) -> FileInfo: ...

    @staticmethod
    def new(format: ZlibCompressorFormat, level: builtins.int, **kwargs) -> ZlibCompressor: ...  # type: ignore

    def set_file_info(self, file_info: typing.Optional[FileInfo]) -> None: ...


class ZlibDecompressor(GObject.Object, Converter):

    def get_file_info(self) -> FileInfo: ...

    @staticmethod
    def new(format: ZlibCompressorFormat, **kwargs) -> ZlibDecompressor: ...  # type: ignore


class DBusInterfaceSkeleton(GObject.Object, DBusInterface):
    parent_instance: GObject.Object

    def export(self, connection: DBusConnection, object_path: builtins.str) -> builtins.bool: ...

    def flush(self) -> None: ...

    def get_connection(self) -> DBusConnection: ...

    def get_connections(self) -> typing.Sequence[DBusConnection]: ...

    def get_flags(self) -> DBusInterfaceSkeletonFlags: ...

    def get_info(self) -> DBusInterfaceInfo: ...

    def get_object_path(self) -> builtins.str: ...

    def get_properties(self) -> GLib.Variant: ...

    def has_connection(self, connection: DBusConnection) -> builtins.bool: ...

    def set_flags(self, flags: DBusInterfaceSkeletonFlags) -> None: ...

    def unexport(self) -> None: ...

    def unexport_from_connection(self, connection: DBusConnection) -> None: ...

    def do_flush(self) -> None: ...

    def do_g_authorize_method(self, invocation: DBusMethodInvocation) -> builtins.bool: ...

    def do_get_info(self) -> DBusInterfaceInfo: ...

    def do_get_properties(self) -> GLib.Variant: ...


class DBusObjectProxy(GObject.Object, DBusObject):
    parent_instance: GObject.Object

    def get_connection(self) -> DBusConnection: ...

    @staticmethod
    def new(connection: DBusConnection, object_path: builtins.str, **kwargs) -> DBusObjectProxy: ...  # type: ignore


class DBusObjectSkeleton(GObject.Object, DBusObject):
    parent_instance: GObject.Object

    def add_interface(self, interface_: DBusInterfaceSkeleton) -> None: ...

    def flush(self) -> None: ...

    @staticmethod
    def new(object_path: builtins.str, **kwargs) -> DBusObjectSkeleton: ...  # type: ignore

    def remove_interface(self, interface_: DBusInterfaceSkeleton) -> None: ...

    def remove_interface_by_name(self, interface_name: builtins.str) -> None: ...

    def set_object_path(self, object_path: builtins.str) -> None: ...

    def do_authorize_method(self, interface_: DBusInterfaceSkeleton, invocation: DBusMethodInvocation) -> builtins.bool: ...


class DBusObjectManagerServer(GObject.Object, DBusObjectManager):
    parent_instance: GObject.Object

    def export(self, object: DBusObjectSkeleton) -> None: ...

    def export_uniquely(self, object: DBusObjectSkeleton) -> None: ...

    def get_connection(self) -> DBusConnection: ...

    def is_exported(self, object: DBusObjectSkeleton) -> builtins.bool: ...

    @staticmethod
    def new(object_path: builtins.str, **kwargs) -> DBusObjectManagerServer: ...  # type: ignore

    def set_connection(self, connection: typing.Optional[DBusConnection]) -> None: ...

    def unexport(self, object_path: builtins.str) -> builtins.bool: ...


class SimpleIOStream(IOStream):

    @staticmethod
    def new(input_stream: InputStream, output_stream: OutputStream) -> IOStream: ...


class SocketConnection(IOStream):
    parent_instance: IOStream

    def connect(self, address: SocketAddress, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...  # type: ignore

    def connect_async(self, address: SocketAddress, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def connect_finish(self, result: AsyncResult) -> builtins.bool: ...

    @staticmethod
    def factory_lookup_type(family: SocketFamily, type: SocketType, protocol_id: builtins.int) -> GObject.GType: ...

    @staticmethod
    def factory_register_type(g_type: GObject.GType, family: SocketFamily, type: SocketType, protocol: builtins.int) -> None: ...

    def get_local_address(self) -> SocketAddress: ...

    def get_remote_address(self) -> SocketAddress: ...

    def get_socket(self) -> Socket: ...

    def is_connected(self) -> builtins.bool: ...


class TlsConnection(IOStream):
    parent_instance: IOStream

    def emit_accept_certificate(self, peer_cert: TlsCertificate, errors: TlsCertificateFlags) -> builtins.bool: ...

    def get_certificate(self) -> TlsCertificate: ...

    def get_database(self) -> TlsDatabase: ...

    def get_interaction(self) -> TlsInteraction: ...

    def get_negotiated_protocol(self) -> typing.Optional[builtins.str]: ...

    def get_peer_certificate(self) -> TlsCertificate: ...

    def get_peer_certificate_errors(self) -> TlsCertificateFlags: ...

    def get_rehandshake_mode(self) -> TlsRehandshakeMode: ...

    def get_require_close_notify(self) -> builtins.bool: ...

    def get_use_system_certdb(self) -> builtins.bool: ...

    def handshake(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def handshake_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def handshake_finish(self, result: AsyncResult) -> builtins.bool: ...

    def set_advertised_protocols(self, protocols: typing.Optional[typing.Sequence[builtins.str]]) -> None: ...

    def set_certificate(self, certificate: TlsCertificate) -> None: ...

    def set_database(self, database: TlsDatabase) -> None: ...

    def set_interaction(self, interaction: typing.Optional[TlsInteraction]) -> None: ...

    def set_rehandshake_mode(self, mode: TlsRehandshakeMode) -> None: ...

    def set_require_close_notify(self, require_close_notify: builtins.bool) -> None: ...

    def set_use_system_certdb(self, use_system_certdb: builtins.bool) -> None: ...

    def do_accept_certificate(self, peer_cert: TlsCertificate, errors: TlsCertificateFlags) -> builtins.bool: ...

    def do_handshake(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_handshake_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_handshake_finish(self, result: AsyncResult) -> builtins.bool: ...


class Emblem(GObject.Object, Icon):

    def get_icon(self) -> Icon: ...

    def get_origin(self) -> EmblemOrigin: ...

    @staticmethod
    def new(icon: Icon, **kwargs) -> Emblem: ...  # type: ignore

    @staticmethod
    def new_with_origin(icon: Icon, origin: EmblemOrigin) -> Emblem: ...


class EmblemedIcon(GObject.Object, Icon):
    parent_instance: GObject.Object

    def add_emblem(self, emblem: Emblem) -> None: ...

    def clear_emblems(self) -> None: ...

    def get_emblems(self) -> typing.Sequence[Emblem]: ...

    def get_icon(self) -> Icon: ...

    @staticmethod
    def new(icon: Icon, emblem: typing.Optional[Emblem], **kwargs) -> EmblemedIcon: ...  # type: ignore


class ThemedIcon(GObject.Object, Icon):

    def append_name(self, iconname: builtins.str) -> None: ...

    def get_names(self) -> typing.Sequence[builtins.str]: ...

    @staticmethod
    def new(iconname: builtins.str, **kwargs) -> ThemedIcon: ...  # type: ignore

    @staticmethod
    def new_from_names(iconnames: typing.Sequence[builtins.str]) -> ThemedIcon: ...

    @staticmethod
    def new_with_default_fallbacks(iconname: builtins.str) -> ThemedIcon: ...

    def prepend_name(self, iconname: builtins.str) -> None: ...


class CharsetConverter(GObject.Object, Converter, Initable):

    def get_num_fallbacks(self) -> builtins.int: ...

    def get_use_fallback(self) -> builtins.bool: ...

    @staticmethod
    def new(to_charset: builtins.str, from_charset: builtins.str, **kwargs) -> CharsetConverter: ...  # type: ignore

    def set_use_fallback(self, use_fallback: builtins.bool) -> None: ...


class DBusConnection(GObject.Object, AsyncInitable, Initable):

    def add_filter(self, filter_function: DBusMessageFilterFunction, *user_data: typing.Optional[builtins.object]) -> builtins.int: ...

    def call(self, bus_name: typing.Optional[builtins.str], object_path: builtins.str, interface_name: builtins.str, method_name: builtins.str, parameters: typing.Optional[GLib.Variant], reply_type: typing.Optional[GLib.VariantType], flags: DBusCallFlags, timeout_msec: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def call_finish(self, res: AsyncResult) -> GLib.Variant: ...

    def call_sync(self, bus_name: typing.Optional[builtins.str], object_path: builtins.str, interface_name: builtins.str, method_name: builtins.str, parameters: typing.Optional[GLib.Variant], reply_type: typing.Optional[GLib.VariantType], flags: DBusCallFlags, timeout_msec: builtins.int, cancellable: typing.Optional[Cancellable]) -> GLib.Variant: ...

    def call_with_unix_fd_list(self, bus_name: typing.Optional[builtins.str], object_path: builtins.str, interface_name: builtins.str, method_name: builtins.str, parameters: typing.Optional[GLib.Variant], reply_type: typing.Optional[GLib.VariantType], flags: DBusCallFlags, timeout_msec: builtins.int, fd_list: typing.Optional[UnixFDList], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def call_with_unix_fd_list_finish(self, res: AsyncResult) -> typing.Tuple[GLib.Variant, UnixFDList]: ...

    def call_with_unix_fd_list_sync(self, bus_name: typing.Optional[builtins.str], object_path: builtins.str, interface_name: builtins.str, method_name: builtins.str, parameters: typing.Optional[GLib.Variant], reply_type: typing.Optional[GLib.VariantType], flags: DBusCallFlags, timeout_msec: builtins.int, fd_list: typing.Optional[UnixFDList], cancellable: typing.Optional[Cancellable]) -> typing.Tuple[GLib.Variant, UnixFDList]: ...

    def close(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def close_finish(self, res: AsyncResult) -> builtins.bool: ...

    def close_sync(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def emit_signal(self, destination_bus_name: typing.Optional[builtins.str], object_path: builtins.str, interface_name: builtins.str, signal_name: builtins.str, parameters: typing.Optional[GLib.Variant]) -> builtins.bool: ...

    def export_action_group(self, object_path: builtins.str, action_group: ActionGroup) -> builtins.int: ...

    def export_menu_model(self, object_path: builtins.str, menu: MenuModel) -> builtins.int: ...

    def flush(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def flush_finish(self, res: AsyncResult) -> builtins.bool: ...

    def flush_sync(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def get_capabilities(self) -> DBusCapabilityFlags: ...

    def get_exit_on_close(self) -> builtins.bool: ...

    def get_flags(self) -> DBusConnectionFlags: ...

    def get_guid(self) -> builtins.str: ...

    def get_last_serial(self) -> builtins.int: ...

    def get_peer_credentials(self) -> typing.Optional[Credentials]: ...

    def get_stream(self) -> IOStream: ...

    def get_unique_name(self) -> typing.Optional[builtins.str]: ...

    def is_closed(self) -> builtins.bool: ...

    @staticmethod
    def new(stream: IOStream, guid: typing.Optional[builtins.str], flags: DBusConnectionFlags, observer: typing.Optional[DBusAuthObserver], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object], **kwargs) -> None: ...  # type: ignore

    @staticmethod
    def new_finish(res: AsyncResult) -> DBusConnection: ...

    @staticmethod
    def new_for_address(address: builtins.str, flags: DBusConnectionFlags, observer: typing.Optional[DBusAuthObserver], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    @staticmethod
    def new_for_address_finish(res: AsyncResult) -> DBusConnection: ...

    @staticmethod
    def new_for_address_sync(address: builtins.str, flags: DBusConnectionFlags, observer: typing.Optional[DBusAuthObserver], cancellable: typing.Optional[Cancellable]) -> DBusConnection: ...

    @staticmethod
    def new_sync(stream: IOStream, guid: typing.Optional[builtins.str], flags: DBusConnectionFlags, observer: typing.Optional[DBusAuthObserver], cancellable: typing.Optional[Cancellable]) -> DBusConnection: ...

    def register_object(self, object_path: builtins.str, interface_info: DBusInterfaceInfo, method_call_closure: typing.Optional[DBusInterfaceMethodCallFunc], get_property_closure: typing.Optional[DBusInterfaceGetPropertyFunc], set_property_closure: typing.Optional[DBusInterfaceSetPropertyFunc]) -> builtins.int: ...

    def register_subtree(self, object_path: builtins.str, vtable: DBusSubtreeVTable, flags: DBusSubtreeFlags, user_data: typing.Optional[builtins.object], user_data_free_func: GLib.DestroyNotify) -> builtins.int: ...

    def remove_filter(self, filter_id: builtins.int) -> None: ...

    def send_message(self, message: DBusMessage, flags: DBusSendMessageFlags) -> typing.Tuple[builtins.bool, builtins.int]: ...

    def send_message_with_reply(self, message: DBusMessage, flags: DBusSendMessageFlags, timeout_msec: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> builtins.int: ...

    def send_message_with_reply_finish(self, res: AsyncResult) -> DBusMessage: ...

    def send_message_with_reply_sync(self, message: DBusMessage, flags: DBusSendMessageFlags, timeout_msec: builtins.int, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[DBusMessage, builtins.int]: ...

    def set_exit_on_close(self, exit_on_close: builtins.bool) -> None: ...

    def signal_subscribe(self, sender: typing.Optional[builtins.str], interface_name: typing.Optional[builtins.str], member: typing.Optional[builtins.str], object_path: typing.Optional[builtins.str], arg0: typing.Optional[builtins.str], flags: DBusSignalFlags, callback: typing.Callable[[DBusConnection, builtins.str, builtins.str, builtins.str, builtins.str, GLib.Variant], None]) -> builtins.int: ...

    def signal_unsubscribe(self, subscription_id: builtins.int) -> None: ...

    def start_message_processing(self) -> None: ...

    def unexport_action_group(self, export_id: builtins.int) -> None: ...

    def unexport_menu_model(self, export_id: builtins.int) -> None: ...

    def unregister_object(self, registration_id: builtins.int) -> builtins.bool: ...

    def unregister_subtree(self, registration_id: builtins.int) -> builtins.bool: ...


class DBusObjectManagerClient(GObject.Object, AsyncInitable, DBusObjectManager, Initable):
    parent_instance: GObject.Object

    def get_connection(self) -> DBusConnection: ...

    def get_flags(self) -> DBusObjectManagerClientFlags: ...

    def get_name(self) -> builtins.str: ...

    def get_name_owner(self) -> typing.Optional[builtins.str]: ...

    @staticmethod
    def new(connection: DBusConnection, flags: DBusObjectManagerClientFlags, name: builtins.str, object_path: builtins.str, get_proxy_type_func: typing.Optional[DBusProxyTypeFunc], get_proxy_type_user_data: typing.Optional[builtins.object], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object], **kwargs) -> None: ...  # type: ignore

    @staticmethod
    def new_finish(res: AsyncResult) -> DBusObjectManagerClient: ...

    @staticmethod
    def new_for_bus(bus_type: BusType, flags: DBusObjectManagerClientFlags, name: builtins.str, object_path: builtins.str, get_proxy_type_func: typing.Optional[DBusProxyTypeFunc], get_proxy_type_user_data: typing.Optional[builtins.object], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    @staticmethod
    def new_for_bus_finish(res: AsyncResult) -> DBusObjectManagerClient: ...

    @staticmethod
    def new_for_bus_sync(bus_type: BusType, flags: DBusObjectManagerClientFlags, name: builtins.str, object_path: builtins.str, get_proxy_type_func: typing.Optional[DBusProxyTypeFunc], get_proxy_type_user_data: typing.Optional[builtins.object], cancellable: typing.Optional[Cancellable]) -> DBusObjectManagerClient: ...

    @staticmethod
    def new_sync(connection: DBusConnection, flags: DBusObjectManagerClientFlags, name: typing.Optional[builtins.str], object_path: builtins.str, get_proxy_type_func: typing.Optional[DBusProxyTypeFunc], get_proxy_type_user_data: typing.Optional[builtins.object], cancellable: typing.Optional[Cancellable]) -> DBusObjectManagerClient: ...

    def do_interface_proxy_properties_changed(self, object_proxy: DBusObjectProxy, interface_proxy: DBusProxy, changed_properties: GLib.Variant, invalidated_properties: builtins.str) -> None: ...

    def do_interface_proxy_signal(self, object_proxy: DBusObjectProxy, interface_proxy: DBusProxy, sender_name: builtins.str, signal_name: builtins.str, parameters: GLib.Variant) -> None: ...


class DBusProxy(GObject.Object, AsyncInitable, DBusInterface, Initable):
    parent_instance: GObject.Object

    def __init__(self, *, g_bus_type: BusType = BusType.NONE, g_connection: typing.Optional[DBusConnection] = None, g_default_timeout: int = -1, g_flags: DBusProxyFlags, g_interface_name: typing.Optional[str] = None, g_name: str, g_object_path: typing.Optional[str] = None) -> None: ...

    def __getattr__(self, name: str) -> typing.Callable[..., typing.Any]: ...

    T = typing.TypeVar("T")
    T1 = typing.TypeVar("T1")
    T2 = typing.TypeVar("T2")

    @typing.overload
    def call(self: T, method_name: builtins.str, parameters: typing.Optional[GLib.Variant], flags: DBusCallFlags, timeout_msec: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[typing.Callable[[T, AsyncResult], None]] = None) -> None: ...
    @typing.overload
    def call(self: T, method_name: builtins.str, parameters: typing.Optional[GLib.Variant], flags: DBusCallFlags, timeout_msec: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[typing.Callable[[T, AsyncResult, T1], None]], user_data1: T1) -> None: ...
    @typing.overload
    def call(self: T, method_name: builtins.str, parameters: typing.Optional[GLib.Variant], flags: DBusCallFlags, timeout_msec: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[typing.Callable[[T, AsyncResult, T1, T2], None]], user_data1: T1, user_data2: T2) -> None: ...

    def call_finish(self, res: AsyncResult) -> GLib.Variant: ...

    def call_sync(self, method_name: builtins.str, parameters: typing.Optional[GLib.Variant], flags: DBusCallFlags, timeout_msec: builtins.int, cancellable: typing.Optional[Cancellable]) -> GLib.Variant: ...

    def call_with_unix_fd_list(self, method_name: builtins.str, parameters: typing.Optional[GLib.Variant], flags: DBusCallFlags, timeout_msec: builtins.int, fd_list: typing.Optional[UnixFDList], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def call_with_unix_fd_list_finish(self, res: AsyncResult) -> typing.Tuple[GLib.Variant, UnixFDList]: ...

    def call_with_unix_fd_list_sync(self, method_name: builtins.str, parameters: typing.Optional[GLib.Variant], flags: DBusCallFlags, timeout_msec: builtins.int, fd_list: typing.Optional[UnixFDList], cancellable: typing.Optional[Cancellable]) -> typing.Tuple[GLib.Variant, UnixFDList]: ...

    def get_cached_property(self, property_name: builtins.str) -> typing.Optional[GLib.Variant]: ...

    def get_cached_property_names(self) -> typing.Optional[typing.Sequence[builtins.str]]: ...

    def get_connection(self) -> DBusConnection: ...

    def get_default_timeout(self) -> builtins.int: ...

    def get_flags(self) -> DBusProxyFlags: ...

    def get_interface_info(self) -> typing.Optional[DBusInterfaceInfo]: ...

    def get_interface_name(self) -> builtins.str: ...

    def get_name(self) -> builtins.str: ...

    def get_name_owner(self) -> typing.Optional[builtins.str]: ...

    def get_object_path(self) -> builtins.str: ...

    @staticmethod
    def new(connection: DBusConnection, flags: DBusProxyFlags, info: typing.Optional[DBusInterfaceInfo], name: typing.Optional[builtins.str], object_path: builtins.str, interface_name: builtins.str, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object], **kwargs) -> None: ...  # type: ignore

    @staticmethod
    def new_finish(res: AsyncResult) -> DBusProxy: ...

    @staticmethod
    def new_for_bus(bus_type: BusType, flags: DBusProxyFlags, info: typing.Optional[DBusInterfaceInfo], name: builtins.str, object_path: builtins.str, interface_name: builtins.str, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    @staticmethod
    def new_for_bus_finish(res: AsyncResult) -> DBusProxy: ...

    @staticmethod
    def new_for_bus_sync(bus_type: BusType, flags: DBusProxyFlags, info: typing.Optional[DBusInterfaceInfo], name: builtins.str, object_path: builtins.str, interface_name: builtins.str, cancellable: typing.Optional[Cancellable] = None) -> DBusProxy: ...

    @staticmethod
    def new_sync(connection: DBusConnection, flags: DBusProxyFlags, info: typing.Optional[DBusInterfaceInfo], name: typing.Optional[builtins.str], object_path: builtins.str, interface_name: builtins.str, cancellable: typing.Optional[Cancellable]) -> DBusProxy: ...

    def set_cached_property(self, property_name: builtins.str, value: typing.Optional[GLib.Variant]) -> None: ...

    def set_default_timeout(self, timeout_msec: builtins.int) -> None: ...

    def set_interface_info(self, info: typing.Optional[DBusInterfaceInfo]) -> None: ...

    def do_g_properties_changed(self, changed_properties: GLib.Variant, invalidated_properties: typing.List[str]) -> None: ...

    def do_g_signal(self, sender_name: builtins.str, signal_name: builtins.str, parameters: GLib.Variant) -> None: ...


class DBusServer(GObject.Object, Initable):

    def get_client_address(self) -> builtins.str: ...

    def get_flags(self) -> DBusServerFlags: ...

    def get_guid(self) -> builtins.str: ...

    def is_active(self) -> builtins.bool: ...

    @staticmethod
    def new_sync(address: builtins.str, flags: DBusServerFlags, guid: builtins.str, observer: typing.Optional[DBusAuthObserver], cancellable: typing.Optional[Cancellable]) -> DBusServer: ...

    def start(self) -> None: ...

    def stop(self) -> None: ...


class InetAddressMask(GObject.Object, Initable):
    parent_instance: GObject.Object

    def equal(self, mask2: InetAddressMask) -> builtins.bool: ...

    def get_address(self) -> InetAddress: ...

    def get_family(self) -> SocketFamily: ...

    def get_length(self) -> builtins.int: ...

    def matches(self, address: InetAddress) -> builtins.bool: ...

    @staticmethod
    def new(addr: InetAddress, length: builtins.int, **kwargs) -> InetAddressMask: ...  # type: ignore

    @staticmethod
    def new_from_string(mask_string: builtins.str) -> InetAddressMask: ...

    def to_string(self) -> builtins.str: ...


class Socket(GObject.Object, DatagramBased, Initable):
    parent_instance: GObject.Object

    def accept(self, cancellable: typing.Optional[Cancellable]) -> Socket: ...

    def bind(self, address: SocketAddress, allow_reuse: builtins.bool) -> builtins.bool: ...

    def check_connect_result(self) -> builtins.bool: ...

    def close(self) -> builtins.bool: ...

    def condition_check(self, condition: GLib.IOCondition) -> GLib.IOCondition: ...

    def condition_timed_wait(self, condition: GLib.IOCondition, timeout_us: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def condition_wait(self, condition: GLib.IOCondition, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...  # type: ignore

    def connect(self, address: SocketAddress, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...  # type: ignore

    def connection_factory_create_connection(self) -> SocketConnection: ...

    def get_available_bytes(self) -> builtins.int: ...

    def get_blocking(self) -> builtins.bool: ...

    def get_broadcast(self) -> builtins.bool: ...

    def get_credentials(self) -> Credentials: ...

    def get_family(self) -> SocketFamily: ...

    def get_fd(self) -> builtins.int: ...

    def get_keepalive(self) -> builtins.bool: ...

    def get_listen_backlog(self) -> builtins.int: ...

    def get_local_address(self) -> SocketAddress: ...

    def get_multicast_loopback(self) -> builtins.bool: ...

    def get_multicast_ttl(self) -> builtins.int: ...

    def get_option(self, level: builtins.int, optname: builtins.int) -> typing.Tuple[builtins.bool, builtins.int]: ...

    def get_protocol(self) -> SocketProtocol: ...

    def get_remote_address(self) -> SocketAddress: ...

    def get_socket_type(self) -> SocketType: ...

    def get_timeout(self) -> builtins.int: ...

    def get_ttl(self) -> builtins.int: ...

    def is_closed(self) -> builtins.bool: ...

    def is_connected(self) -> builtins.bool: ...

    def join_multicast_group(self, group: InetAddress, source_specific: builtins.bool, iface: typing.Optional[builtins.str]) -> builtins.bool: ...

    def join_multicast_group_ssm(self, group: InetAddress, source_specific: typing.Optional[InetAddress], iface: typing.Optional[builtins.str]) -> builtins.bool: ...

    def leave_multicast_group(self, group: InetAddress, source_specific: builtins.bool, iface: typing.Optional[builtins.str]) -> builtins.bool: ...

    def leave_multicast_group_ssm(self, group: InetAddress, source_specific: typing.Optional[InetAddress], iface: typing.Optional[builtins.str]) -> builtins.bool: ...

    def listen(self) -> builtins.bool: ...

    @staticmethod
    def new(family: SocketFamily, type: SocketType, protocol: SocketProtocol, **kwargs) -> Socket: ...  # type: ignore

    @staticmethod
    def new_from_fd(fd: builtins.int) -> Socket: ...

    def receive(self, buffer: builtins.bytes, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def receive_from(self, buffer: builtins.bytes, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.int, SocketAddress]: ...

    def receive_message(self, vectors: typing.Sequence[InputVector], flags: builtins.int, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.int, SocketAddress, typing.Sequence[SocketControlMessage], builtins.int]: ...

    def receive_messages(self, messages: typing.Sequence[InputMessage], flags: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...  # type: ignore

    def receive_with_blocking(self, buffer: builtins.bytes, blocking: builtins.bool, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def send(self, buffer: builtins.bytes, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def send_message(self, address: typing.Optional[SocketAddress], vectors: typing.Sequence[OutputVector], messages: typing.Optional[typing.Sequence[SocketControlMessage]], flags: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def send_message_with_timeout(self, address: typing.Optional[SocketAddress], vectors: typing.Sequence[OutputVector], messages: typing.Optional[typing.Sequence[SocketControlMessage]], flags: builtins.int, timeout_us: builtins.int, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[PollableReturn, builtins.int]: ...

    def send_messages(self, messages: typing.Sequence[OutputMessage], flags: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...  # type: ignore

    def send_to(self, address: typing.Optional[SocketAddress], buffer: builtins.bytes, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def send_with_blocking(self, buffer: builtins.bytes, blocking: builtins.bool, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def set_blocking(self, blocking: builtins.bool) -> None: ...

    def set_broadcast(self, broadcast: builtins.bool) -> None: ...

    def set_keepalive(self, keepalive: builtins.bool) -> None: ...

    def set_listen_backlog(self, backlog: builtins.int) -> None: ...

    def set_multicast_loopback(self, loopback: builtins.bool) -> None: ...

    def set_multicast_ttl(self, ttl: builtins.int) -> None: ...

    def set_option(self, level: builtins.int, optname: builtins.int, value: builtins.int) -> builtins.bool: ...

    def set_timeout(self, timeout: builtins.int) -> None: ...

    def set_ttl(self, ttl: builtins.int) -> None: ...

    def shutdown(self, shutdown_read: builtins.bool, shutdown_write: builtins.bool) -> builtins.bool: ...

    def speaks_ipv4(self) -> builtins.bool: ...


class Subprocess(GObject.Object, Initable):

    def communicate(self, stdin_buf: typing.Optional[GLib.Bytes], cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.bool, typing.Optional[GLib.Bytes], typing.Optional[GLib.Bytes]]: ...

    def communicate_async(self, stdin_buf: typing.Optional[GLib.Bytes], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def communicate_finish(self, result: AsyncResult) -> typing.Tuple[builtins.bool, typing.Optional[GLib.Bytes], typing.Optional[GLib.Bytes]]: ...

    def communicate_utf8(self, stdin_buf: typing.Optional[builtins.str], cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.bool, typing.Optional[builtins.str], typing.Optional[builtins.str]]: ...

    def communicate_utf8_async(self, stdin_buf: typing.Optional[builtins.str], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def communicate_utf8_finish(self, result: AsyncResult) -> typing.Tuple[builtins.bool, typing.Optional[builtins.str], typing.Optional[builtins.str]]: ...

    def force_exit(self) -> None: ...

    def get_exit_status(self) -> builtins.int: ...

    def get_identifier(self) -> typing.Optional[builtins.str]: ...

    def get_if_exited(self) -> builtins.bool: ...

    def get_if_signaled(self) -> builtins.bool: ...

    def get_status(self) -> builtins.int: ...

    def get_stderr_pipe(self) -> InputStream: ...

    def get_stdin_pipe(self) -> OutputStream: ...

    def get_stdout_pipe(self) -> InputStream: ...

    def get_successful(self) -> builtins.bool: ...

    def get_term_sig(self) -> builtins.int: ...

    @staticmethod
    def new(argv: typing.Sequence[builtins.str], flags: SubprocessFlags, **kwargs) -> Subprocess: ...  # type: ignore

    def send_signal(self, signal_num: builtins.int) -> None: ...

    def wait(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def wait_async(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def wait_check(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def wait_check_async(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def wait_check_finish(self, result: AsyncResult) -> builtins.bool: ...

    def wait_finish(self, result: AsyncResult) -> builtins.bool: ...


class FilterInputStream(InputStream):
    base_stream: InputStream
    parent_instance: InputStream

    def get_base_stream(self) -> InputStream: ...

    def get_close_base_stream(self) -> builtins.bool: ...

    def set_close_base_stream(self, close_base: builtins.bool) -> None: ...


class ListStore(GObject.Object, ListModel):

    def append(self, item: GObject.Object) -> None: ...

    def find(self, item: GObject.Object) -> typing.Tuple[builtins.bool, builtins.int]: ...

    def find_with_equal_func(self, item: GObject.Object, equal_func: GLib.EqualFunc) -> typing.Tuple[builtins.bool, builtins.int]: ...

    def insert(self, position: builtins.int, item: GObject.Object) -> None: ...

    def insert_sorted(self, item: GObject.Object, compare_func: GLib.CompareDataFunc, *user_data: typing.Optional[builtins.object]) -> builtins.int: ...

    @staticmethod
    def new(item_type: GObject.GType, **kwargs) -> ListStore: ...  # type: ignore

    def remove(self, position: builtins.int) -> None: ...

    def remove_all(self) -> None: ...

    def sort(self, compare_func: GLib.CompareDataFunc, *user_data: typing.Optional[builtins.object]) -> None: ...

    def splice(self, position: builtins.int, n_removals: builtins.int, additions: typing.Sequence[GObject.Object]) -> None: ...


class BytesIcon(GObject.Object, Icon, LoadableIcon):

    def get_bytes(self) -> GLib.Bytes: ...

    @staticmethod
    def new(bytes: GLib.Bytes, **kwargs) -> BytesIcon: ...  # type: ignore


class FileIcon(GObject.Object, Icon, LoadableIcon):

    def get_file(self) -> File: ...

    @staticmethod
    def new(file: File, **kwargs) -> FileIcon: ...  # type: ignore


class DBusMenuModel(MenuModel):

    @staticmethod
    def get(connection: DBusConnection, bus_name: typing.Optional[builtins.str], object_path: builtins.str) -> DBusMenuModel: ...


class Menu(MenuModel):

    def append(self, label: typing.Optional[builtins.str], detailed_action: typing.Optional[builtins.str]) -> None: ...

    def append_item(self, item: MenuItem) -> None: ...

    def append_section(self, label: typing.Optional[builtins.str], section: MenuModel) -> None: ...

    def append_submenu(self, label: typing.Optional[builtins.str], submenu: MenuModel) -> None: ...

    def freeze(self) -> None: ...

    def insert(self, position: builtins.int, label: typing.Optional[builtins.str], detailed_action: typing.Optional[builtins.str]) -> None: ...

    def insert_item(self, position: builtins.int, item: MenuItem) -> None: ...

    def insert_section(self, position: builtins.int, label: typing.Optional[builtins.str], section: MenuModel) -> None: ...

    def insert_submenu(self, position: builtins.int, label: typing.Optional[builtins.str], submenu: MenuModel) -> None: ...

    @staticmethod
    def new() -> Menu: ...

    def prepend(self, label: typing.Optional[builtins.str], detailed_action: typing.Optional[builtins.str]) -> None: ...

    def prepend_item(self, item: MenuItem) -> None: ...

    def prepend_section(self, label: typing.Optional[builtins.str], section: MenuModel) -> None: ...

    def prepend_submenu(self, label: typing.Optional[builtins.str], submenu: MenuModel) -> None: ...

    def remove(self, position: builtins.int) -> None: ...

    def remove_all(self) -> None: ...


class FilterOutputStream(OutputStream):
    base_stream: OutputStream
    parent_instance: OutputStream

    def get_base_stream(self) -> OutputStream: ...

    def get_close_base_stream(self) -> builtins.bool: ...

    def set_close_base_stream(self, close_base: builtins.bool) -> None: ...


class SimplePermission(Permission):

    @staticmethod
    def new(allowed: builtins.bool) -> Permission: ...


class UnixInputStream(InputStream, FileDescriptorBased, PollableInputStream):
    parent_instance: InputStream

    def get_close_fd(self) -> builtins.bool: ...

    def get_fd(self) -> builtins.int: ...

    @staticmethod
    def new(fd: builtins.int, close_fd: builtins.bool) -> InputStream: ...

    def set_close_fd(self, close_fd: builtins.bool) -> None: ...


class UnixOutputStream(OutputStream, FileDescriptorBased, PollableOutputStream):
    parent_instance: OutputStream

    def get_close_fd(self) -> builtins.bool: ...

    def get_fd(self) -> builtins.int: ...

    @staticmethod
    def new(fd: builtins.int, close_fd: builtins.bool) -> OutputStream: ...

    def set_close_fd(self, close_fd: builtins.bool) -> None: ...


class SimpleProxyResolver(GObject.Object, ProxyResolver):
    parent_instance: GObject.Object

    @staticmethod
    def new(default_proxy: typing.Optional[builtins.str], ignore_hosts: typing.Optional[builtins.str], **kwargs) -> ProxyResolver: ...  # type: ignore

    def set_default_proxy(self, default_proxy: builtins.str) -> None: ...

    def set_ignore_hosts(self, ignore_hosts: builtins.str) -> None: ...

    def set_uri_proxy(self, uri_scheme: builtins.str, proxy: builtins.str) -> None: ...


class DBusActionGroup(GObject.Object, ActionGroup, RemoteActionGroup):

    @staticmethod
    def get(connection: DBusConnection, bus_name: typing.Optional[builtins.str], object_path: builtins.str) -> DBusActionGroup: ...


class FileIOStream(IOStream, Seekable):
    parent_instance: IOStream

    def get_etag(self) -> builtins.str: ...

    def query_info(self, attributes: builtins.str, cancellable: typing.Optional[Cancellable]) -> FileInfo: ...

    def query_info_async(self, attributes: builtins.str, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def query_info_finish(self, result: AsyncResult) -> FileInfo: ...

    def do_can_seek(self) -> builtins.bool: ...

    def do_can_truncate(self) -> builtins.bool: ...

    def do_get_etag(self) -> builtins.str: ...

    def do_query_info(self, attributes: builtins.str, cancellable: typing.Optional[Cancellable]) -> FileInfo: ...

    def do_query_info_async(self, attributes: builtins.str, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_query_info_finish(self, result: AsyncResult) -> FileInfo: ...

    def do_seek(self, offset: builtins.int, type: GLib.SeekType, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_tell(self) -> builtins.int: ...

    def do_truncate_fn(self, size: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...


class FileInputStream(InputStream, Seekable):
    parent_instance: InputStream

    def query_info(self, attributes: builtins.str, cancellable: typing.Optional[Cancellable]) -> FileInfo: ...

    def query_info_async(self, attributes: builtins.str, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def query_info_finish(self, result: AsyncResult) -> FileInfo: ...

    def do_can_seek(self) -> builtins.bool: ...

    def do_query_info(self, attributes: builtins.str, cancellable: typing.Optional[Cancellable]) -> FileInfo: ...

    def do_query_info_async(self, attributes: builtins.str, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_query_info_finish(self, result: AsyncResult) -> FileInfo: ...

    def do_seek(self, offset: builtins.int, type: GLib.SeekType, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_tell(self) -> builtins.int: ...


class FileOutputStream(OutputStream, Seekable):
    parent_instance: OutputStream

    def get_etag(self) -> builtins.str: ...

    def query_info(self, attributes: builtins.str, cancellable: typing.Optional[Cancellable]) -> FileInfo: ...

    def query_info_async(self, attributes: builtins.str, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def query_info_finish(self, result: AsyncResult) -> FileInfo: ...

    def do_can_seek(self) -> builtins.bool: ...

    def do_can_truncate(self) -> builtins.bool: ...

    def do_get_etag(self) -> builtins.str: ...

    def do_query_info(self, attributes: builtins.str, cancellable: typing.Optional[Cancellable]) -> FileInfo: ...

    def do_query_info_async(self, attributes: builtins.str, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_query_info_finish(self, result: AsyncResult) -> FileInfo: ...

    def do_seek(self, offset: builtins.int, type: GLib.SeekType, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def do_tell(self) -> builtins.int: ...

    def do_truncate_fn(self, size: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...


class MemoryInputStream(InputStream, PollableInputStream, Seekable):
    parent_instance: InputStream

    def add_bytes(self, bytes: GLib.Bytes) -> None: ...

    def add_data(self, data: builtins.bytes, destroy: typing.Optional[GLib.DestroyNotify]) -> None: ...

    @staticmethod
    def new() -> InputStream: ...

    @staticmethod
    def new_from_bytes(bytes: GLib.Bytes) -> InputStream: ...

    @staticmethod
    def new_from_data(data: builtins.bytes, destroy: typing.Optional[GLib.DestroyNotify]) -> InputStream: ...


class MemoryOutputStream(OutputStream, PollableOutputStream, Seekable):
    parent_instance: OutputStream

    def get_data(self) -> typing.Optional[builtins.object]: ...  # type: ignore

    def get_data_size(self) -> builtins.int: ...

    def get_size(self) -> builtins.int: ...

    @staticmethod
    def new_resizable() -> OutputStream: ...

    def steal_as_bytes(self) -> GLib.Bytes: ...

    def steal_data(self) -> typing.Optional[builtins.object]: ...  # type: ignore


class ProxyAddressEnumerator(SocketAddressEnumerator):
    parent_instance: SocketAddressEnumerator


class NetworkAddress(GObject.Object, SocketConnectable):
    parent_instance: GObject.Object

    def get_hostname(self) -> builtins.str: ...

    def get_port(self) -> builtins.int: ...

    def get_scheme(self) -> builtins.str: ...

    @staticmethod
    def new(hostname: builtins.str, port: builtins.int, **kwargs) -> NetworkAddress: ...  # type: ignore

    @staticmethod
    def new_loopback(port: builtins.int) -> NetworkAddress: ...

    @staticmethod
    def parse(host_and_port: builtins.str, default_port: builtins.int) -> NetworkAddress: ...

    @staticmethod
    def parse_uri(uri: builtins.str, default_port: builtins.int) -> NetworkAddress: ...


class NetworkService(GObject.Object, SocketConnectable):
    parent_instance: GObject.Object

    def get_domain(self) -> builtins.str: ...

    def get_protocol(self) -> builtins.str: ...

    def get_scheme(self) -> builtins.str: ...

    def get_service(self) -> builtins.str: ...

    @staticmethod
    def new(service: builtins.str, protocol: builtins.str, domain: builtins.str, **kwargs) -> NetworkService: ...  # type: ignore

    def set_scheme(self, scheme: builtins.str) -> None: ...


class SocketAddress(GObject.Object, SocketConnectable):
    parent_instance: GObject.Object

    def get_family(self) -> SocketFamily: ...

    def get_native_size(self) -> builtins.int: ...

    @staticmethod
    def new_from_native(native: builtins.object, len: builtins.int) -> SocketAddress: ...

    def to_native(self, dest: typing.Optional[builtins.object], destlen: builtins.int) -> builtins.bool: ...

    def do_get_family(self) -> SocketFamily: ...

    def do_get_native_size(self) -> builtins.int: ...

    def do_to_native(self, dest: typing.Optional[builtins.object], destlen: builtins.int) -> builtins.bool: ...


class UnixCredentialsMessage(SocketControlMessage):
    parent_instance: SocketControlMessage

    def get_credentials(self) -> Credentials: ...

    @staticmethod
    def is_supported() -> builtins.bool: ...

    @staticmethod
    def new() -> SocketControlMessage: ...

    @staticmethod
    def new_with_credentials(credentials: Credentials) -> SocketControlMessage: ...


class UnixFDMessage(SocketControlMessage):
    parent_instance: SocketControlMessage

    def append_fd(self, fd: builtins.int) -> builtins.bool: ...

    def get_fd_list(self) -> UnixFDList: ...

    @staticmethod
    def new() -> SocketControlMessage: ...

    @staticmethod
    def new_with_fd_list(fd_list: UnixFDList) -> SocketControlMessage: ...

    def steal_fds(self) -> typing.Sequence[builtins.int]: ...


class SocketService(SocketListener):
    parent_instance: SocketListener

    def is_active(self) -> builtins.bool: ...

    @staticmethod
    def new() -> SocketService: ...  # type: ignore

    def start(self) -> None: ...

    def stop(self) -> None: ...

    def do_incoming(self, connection: SocketConnection, source_object: GObject.Object) -> builtins.bool: ...


class NativeVolumeMonitor(VolumeMonitor):
    parent_instance: VolumeMonitor


class TcpConnection(SocketConnection):
    parent_instance: SocketConnection

    def get_graceful_disconnect(self) -> builtins.bool: ...

    def set_graceful_disconnect(self, graceful_disconnect: builtins.bool) -> None: ...


class UnixConnection(SocketConnection):
    parent_instance: SocketConnection

    def receive_credentials(self, cancellable: typing.Optional[Cancellable]) -> Credentials: ...

    def receive_credentials_async(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def receive_credentials_finish(self, result: AsyncResult) -> Credentials: ...

    def receive_fd(self, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def send_credentials(self, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def send_credentials_async(self, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def send_credentials_finish(self, result: AsyncResult) -> builtins.bool: ...

    def send_fd(self, fd: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...


class BufferedInputStream(FilterInputStream, Seekable):
    parent_instance: FilterInputStream

    def fill(self, count: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def fill_async(self, count: builtins.int, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def fill_finish(self, result: AsyncResult) -> builtins.int: ...

    def get_available(self) -> builtins.int: ...

    def get_buffer_size(self) -> builtins.int: ...

    @staticmethod
    def new(base_stream: InputStream) -> InputStream: ...

    @staticmethod
    def new_sized(base_stream: InputStream, size: builtins.int) -> InputStream: ...

    def peek(self, buffer: builtins.bytes, offset: builtins.int) -> builtins.int: ...

    def peek_buffer(self) -> builtins.bytes: ...

    def read_byte(self, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def set_buffer_size(self, size: builtins.int) -> None: ...

    def do_fill(self, count: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def do_fill_async(self, count: builtins.int, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def do_fill_finish(self, result: AsyncResult) -> builtins.int: ...


class ConverterInputStream(FilterInputStream, PollableInputStream):
    parent_instance: FilterInputStream

    def get_converter(self) -> Converter: ...

    @staticmethod
    def new(base_stream: InputStream, converter: Converter) -> InputStream: ...


class BufferedOutputStream(FilterOutputStream, Seekable):
    parent_instance: FilterOutputStream

    def get_auto_grow(self) -> builtins.bool: ...

    def get_buffer_size(self) -> builtins.int: ...

    @staticmethod
    def new(base_stream: OutputStream) -> OutputStream: ...

    @staticmethod
    def new_sized(base_stream: OutputStream, size: builtins.int) -> OutputStream: ...

    def set_auto_grow(self, auto_grow: builtins.bool) -> None: ...

    def set_buffer_size(self, size: builtins.int) -> None: ...


class ConverterOutputStream(FilterOutputStream, PollableOutputStream):
    parent_instance: FilterOutputStream

    def get_converter(self) -> Converter: ...

    @staticmethod
    def new(base_stream: OutputStream, converter: Converter) -> OutputStream: ...


class DataOutputStream(FilterOutputStream, Seekable):
    parent_instance: FilterOutputStream

    def get_byte_order(self) -> DataStreamByteOrder: ...

    @staticmethod
    def new(base_stream: OutputStream) -> DataOutputStream: ...

    def put_byte(self, data: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def put_int16(self, data: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def put_int32(self, data: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def put_int64(self, data: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def put_string(self, str: builtins.str, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def put_uint16(self, data: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def put_uint32(self, data: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def put_uint64(self, data: builtins.int, cancellable: typing.Optional[Cancellable]) -> builtins.bool: ...

    def set_byte_order(self, order: DataStreamByteOrder) -> None: ...


class InetSocketAddress(SocketAddress):
    parent_instance: SocketAddress

    def get_address(self) -> InetAddress: ...

    def get_flowinfo(self) -> builtins.int: ...

    def get_port(self) -> builtins.int: ...

    def get_scope_id(self) -> builtins.int: ...

    @staticmethod
    def new(address: InetAddress, port: builtins.int) -> SocketAddress: ...

    @staticmethod
    def new_from_string(address: builtins.str, port: builtins.int) -> SocketAddress: ...


class NativeSocketAddress(SocketAddress):
    parent_instance: SocketAddress

    @staticmethod
    def new(native: typing.Optional[builtins.object], len: builtins.int) -> SocketAddress: ...


class UnixSocketAddress(SocketAddress):
    parent_instance: SocketAddress

    @staticmethod
    def abstract_names_supported() -> builtins.bool: ...

    def get_address_type(self) -> UnixSocketAddressType: ...

    def get_is_abstract(self) -> builtins.bool: ...

    def get_path(self) -> builtins.str: ...

    def get_path_len(self) -> builtins.int: ...

    @staticmethod
    def new(path: builtins.str) -> SocketAddress: ...

    @staticmethod
    def new_abstract(path: typing.Sequence[builtins.int]) -> SocketAddress: ...

    @staticmethod
    def new_with_type(path: typing.Sequence[builtins.int], type: UnixSocketAddressType) -> SocketAddress: ...


class ThreadedSocketService(SocketService):
    parent_instance: SocketService

    @staticmethod
    def new(max_threads: builtins.int) -> SocketService: ...  # type: ignore

    def do_run(self, connection: SocketConnection, source_object: GObject.Object) -> builtins.bool: ...


class TcpWrapperConnection(TcpConnection):
    parent_instance: TcpConnection

    def get_base_io_stream(self) -> IOStream: ...

    @staticmethod
    def new(base_io_stream: IOStream, socket: Socket) -> SocketConnection: ...


class DataInputStream(BufferedInputStream):
    parent_instance: BufferedInputStream

    def get_byte_order(self) -> DataStreamByteOrder: ...

    def get_newline_type(self) -> DataStreamNewlineType: ...

    @staticmethod
    def new(base_stream: InputStream) -> DataInputStream: ...

    def read_byte(self, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def read_int16(self, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def read_int32(self, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def read_int64(self, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def read_line(self, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[typing.Optional[builtins.bytes], builtins.int]: ...

    def read_line_async(self, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def read_line_finish(self, result: AsyncResult) -> typing.Tuple[typing.Optional[builtins.bytes], builtins.int]: ...

    def read_line_finish_utf8(self, result: AsyncResult) -> typing.Tuple[typing.Optional[builtins.str], builtins.int]: ...

    def read_line_utf8(self, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[typing.Optional[builtins.str], builtins.int]: ...

    def read_uint16(self, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def read_uint32(self, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def read_uint64(self, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...

    def read_until(self, stop_chars: builtins.str, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.str, builtins.int]: ...

    def read_until_async(self, stop_chars: builtins.str, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def read_until_finish(self, result: AsyncResult) -> typing.Tuple[builtins.str, builtins.int]: ...

    def read_upto(self, stop_chars: builtins.str, stop_chars_len: builtins.int, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.str, builtins.int]: ...

    def read_upto_async(self, stop_chars: builtins.str, stop_chars_len: builtins.int, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...

    def read_upto_finish(self, result: AsyncResult) -> typing.Tuple[builtins.str, builtins.int]: ...

    def set_byte_order(self, order: DataStreamByteOrder) -> None: ...

    def set_newline_type(self, type: DataStreamNewlineType) -> None: ...


class ProxyAddress(InetSocketAddress):
    parent_instance: InetSocketAddress

    def get_destination_hostname(self) -> builtins.str: ...

    def get_destination_port(self) -> builtins.int: ...

    def get_destination_protocol(self) -> builtins.str: ...

    def get_password(self) -> builtins.str: ...

    def get_protocol(self) -> builtins.str: ...

    def get_uri(self) -> builtins.str: ...

    def get_username(self) -> builtins.str: ...

    @staticmethod
    def new(inetaddr: InetAddress, port: builtins.int, protocol: builtins.str, dest_hostname: builtins.str, dest_port: builtins.int, username: typing.Optional[builtins.str], password: typing.Optional[builtins.str]) -> SocketAddress: ...  # type: ignore


class ActionEntry():
    activate: builtins.object
    change_state: builtins.object
    name: builtins.str
    padding: typing.Sequence[builtins.int]
    parameter_type: builtins.str
    state: builtins.str


class DBusAnnotationInfo():
    annotations: typing.Sequence[DBusAnnotationInfo]
    key: builtins.str
    ref_count: builtins.int
    value: builtins.str

    @staticmethod
    def lookup(annotations: typing.Optional[typing.Sequence[DBusAnnotationInfo]], name: builtins.str) -> builtins.str: ...

    def ref(self) -> DBusAnnotationInfo: ...

    def unref(self) -> None: ...


class DBusArgInfo():
    annotations: typing.Sequence[DBusAnnotationInfo]
    name: builtins.str
    ref_count: builtins.int
    signature: builtins.str

    def ref(self) -> DBusArgInfo: ...

    def unref(self) -> None: ...


class DBusErrorEntry():
    dbus_error_name: builtins.str
    error_code: builtins.int


class DBusInterfaceInfo():
    annotations: typing.Sequence[DBusAnnotationInfo]
    methods: typing.Sequence[DBusMethodInfo]
    name: builtins.str
    properties: typing.Sequence[DBusPropertyInfo]
    ref_count: builtins.int
    signals: typing.Sequence[DBusSignalInfo]

    def cache_build(self) -> None: ...

    def cache_release(self) -> None: ...

    def generate_xml(self, indent: builtins.int, string_builder: GLib.String) -> None: ...

    def lookup_method(self, name: builtins.str) -> DBusMethodInfo: ...

    def lookup_property(self, name: builtins.str) -> DBusPropertyInfo: ...

    def lookup_signal(self, name: builtins.str) -> DBusSignalInfo: ...

    def ref(self) -> DBusInterfaceInfo: ...

    def unref(self) -> None: ...


class DBusInterfaceVTable():
    get_property: DBusInterfaceGetPropertyFunc
    method_call: DBusInterfaceMethodCallFunc
    padding: typing.Sequence[builtins.object]
    set_property: DBusInterfaceSetPropertyFunc


class DBusMethodInfo():
    annotations: typing.Sequence[DBusAnnotationInfo]
    in_args: typing.Sequence[DBusArgInfo]
    name: builtins.str
    out_args: typing.Sequence[DBusArgInfo]
    ref_count: builtins.int

    def ref(self) -> DBusMethodInfo: ...

    def unref(self) -> None: ...


class DBusNodeInfo():
    annotations: typing.Sequence[DBusAnnotationInfo]
    interfaces: typing.Sequence[DBusInterfaceInfo]
    nodes: typing.Sequence[DBusNodeInfo]
    path: builtins.str
    ref_count: builtins.int

    def generate_xml(self, indent: builtins.int, string_builder: GLib.String) -> None: ...

    def lookup_interface(self, name: builtins.str) -> DBusInterfaceInfo: ...

    @staticmethod
    def new_for_xml(xml_data: builtins.str) -> DBusNodeInfo: ...

    def ref(self) -> DBusNodeInfo: ...

    def unref(self) -> None: ...


class DBusPropertyInfo():
    annotations: typing.Sequence[DBusAnnotationInfo]
    flags: DBusPropertyInfoFlags
    name: builtins.str
    ref_count: builtins.int
    signature: builtins.str

    def ref(self) -> DBusPropertyInfo: ...

    def unref(self) -> None: ...


class DBusSignalInfo():
    annotations: typing.Sequence[DBusAnnotationInfo]
    args: typing.Sequence[DBusArgInfo]
    name: builtins.str
    ref_count: builtins.int

    def ref(self) -> DBusSignalInfo: ...

    def unref(self) -> None: ...


class DBusSubtreeVTable():
    dispatch: DBusSubtreeDispatchFunc
    enumerate: builtins.object
    introspect: DBusSubtreeIntrospectFunc
    padding: typing.Sequence[builtins.object]


class FileAttributeInfo():
    flags: FileAttributeInfoFlags
    name: builtins.str
    type: FileAttributeType


class FileAttributeInfoList():
    infos: FileAttributeInfo
    n_infos: builtins.int

    def add(self, name: builtins.str, type: FileAttributeType, flags: FileAttributeInfoFlags) -> None: ...

    def dup(self) -> FileAttributeInfoList: ...

    def lookup(self, name: builtins.str) -> FileAttributeInfo: ...

    @staticmethod
    def new() -> FileAttributeInfoList: ...

    def ref(self) -> FileAttributeInfoList: ...

    def unref(self) -> None: ...


class FileAttributeMatcher():

    def enumerate_namespace(self, ns: builtins.str) -> builtins.bool: ...

    def enumerate_next(self) -> builtins.str: ...

    def matches(self, attribute: builtins.str) -> builtins.bool: ...

    def matches_only(self, attribute: builtins.str) -> builtins.bool: ...

    @staticmethod
    def new(attributes: builtins.str) -> FileAttributeMatcher: ...

    def ref(self) -> FileAttributeMatcher: ...

    def subtract(self, subtract: FileAttributeMatcher) -> FileAttributeMatcher: ...

    def to_string(self) -> builtins.str: ...

    def unref(self) -> None: ...


class IOExtension():

    def get_name(self) -> builtins.str: ...

    def get_priority(self) -> builtins.int: ...

    def get_type(self) -> GObject.GType: ...


class IOExtensionPoint():

    def get_extension_by_name(self, name: builtins.str) -> IOExtension: ...

    def get_extensions(self) -> typing.Sequence[IOExtension]: ...

    def get_required_type(self) -> GObject.GType: ...

    @staticmethod
    def implement(extension_point_name: builtins.str, type: GObject.GType, extension_name: builtins.str, priority: builtins.int) -> IOExtension: ...

    @staticmethod
    def lookup(name: builtins.str) -> IOExtensionPoint: ...

    @staticmethod
    def register(name: builtins.str) -> IOExtensionPoint: ...

    def set_required_type(self, type: GObject.GType) -> None: ...


class IOModuleScope():

    def block(self, basename: builtins.str) -> None: ...

    def free(self) -> None: ...


class IOSchedulerJob():

    def send_to_mainloop(self, func: GLib.SourceFunc, *user_data: typing.Optional[builtins.object]) -> builtins.bool: ...

    def send_to_mainloop_async(self, func: GLib.SourceFunc, *user_data: typing.Optional[builtins.object]) -> None: ...


class IOStreamAdapter():
    ...


class InputMessage():
    address: SocketAddress
    bytes_received: builtins.int
    control_messages: typing.Sequence[SocketControlMessage]
    flags: builtins.int
    num_control_messages: builtins.int
    num_vectors: builtins.int
    vectors: typing.Sequence[InputVector]


class InputVector():
    buffer: builtins.object
    size: builtins.int


class OutputMessage():
    address: SocketAddress
    bytes_sent: builtins.int
    control_messages: typing.Sequence[SocketControlMessage]
    num_control_messages: builtins.int
    num_vectors: builtins.int
    vectors: OutputVector


class OutputVector():
    buffer: builtins.object
    size: builtins.int


class Resource():

    def enumerate_children(self, path: builtins.str, lookup_flags: ResourceLookupFlags) -> typing.Sequence[builtins.str]: ...

    def get_info(self, path: builtins.str, lookup_flags: ResourceLookupFlags) -> typing.Tuple[builtins.bool, builtins.int, builtins.int]: ...

    @staticmethod
    def load(filename: builtins.str) -> Resource: ...

    def lookup_data(self, path: builtins.str, lookup_flags: ResourceLookupFlags) -> GLib.Bytes: ...

    @staticmethod
    def new_from_data(data: GLib.Bytes) -> Resource: ...

    def open_stream(self, path: builtins.str, lookup_flags: ResourceLookupFlags) -> InputStream: ...

    def ref(self) -> Resource: ...

    def unref(self) -> None: ...


class SettingsSchema():

    def get_id(self) -> builtins.str: ...

    def get_key(self, name: builtins.str) -> SettingsSchemaKey: ...

    def get_path(self) -> builtins.str: ...

    def has_key(self, name: builtins.str) -> builtins.bool: ...

    def list_children(self) -> typing.Sequence[builtins.str]: ...

    def list_keys(self) -> typing.Sequence[builtins.str]: ...

    def ref(self) -> SettingsSchema: ...

    def unref(self) -> None: ...


class SettingsSchemaKey():

    def get_default_value(self) -> GLib.Variant: ...

    def get_description(self) -> builtins.str: ...

    def get_name(self) -> builtins.str: ...

    def get_range(self) -> GLib.Variant: ...

    def get_summary(self) -> builtins.str: ...

    def get_value_type(self) -> GLib.VariantType: ...

    def range_check(self, value: GLib.Variant) -> builtins.bool: ...

    def ref(self) -> SettingsSchemaKey: ...

    def unref(self) -> None: ...


class SettingsSchemaSource():

    @staticmethod
    def get_default() -> typing.Optional[SettingsSchemaSource]: ...

    def list_schemas(self, recursive: builtins.bool) -> typing.Tuple[typing.Sequence[builtins.str], typing.Sequence[builtins.str]]: ...

    def lookup(self, schema_id: builtins.str, recursive: builtins.bool) -> typing.Optional[SettingsSchema]: ...

    @staticmethod
    def new_from_directory(directory: builtins.str, parent: typing.Optional[SettingsSchemaSource], trusted: builtins.bool) -> SettingsSchemaSource: ...

    def ref(self) -> SettingsSchemaSource: ...

    def unref(self) -> None: ...


class SrvTarget():

    def copy(self) -> SrvTarget: ...

    def free(self) -> None: ...

    def get_hostname(self) -> builtins.str: ...

    def get_port(self) -> builtins.int: ...

    def get_priority(self) -> builtins.int: ...

    def get_weight(self) -> builtins.int: ...

    @staticmethod
    def new(hostname: builtins.str, port: builtins.int, priority: builtins.int, weight: builtins.int) -> SrvTarget: ...


class StaticResource():
    data: builtins.int
    data_len: builtins.int
    next: StaticResource
    padding: builtins.object
    resource: Resource

    def fini(self) -> None: ...

    def get_resource(self) -> Resource: ...

    def init(self) -> None: ...


class UnixMountEntry():
    ...


class UnixMountPoint():

    def compare(self, mount2: UnixMountPoint) -> builtins.int: ...

    def copy(self) -> UnixMountPoint: ...

    def free(self) -> None: ...

    def get_device_path(self) -> builtins.str: ...

    def get_fs_type(self) -> builtins.str: ...

    def get_mount_path(self) -> builtins.str: ...

    def get_options(self) -> builtins.str: ...

    def guess_can_eject(self) -> builtins.bool: ...

    def guess_icon(self) -> Icon: ...

    def guess_name(self) -> builtins.str: ...

    def guess_symbolic_icon(self) -> Icon: ...

    def is_loopback(self) -> builtins.bool: ...

    def is_readonly(self) -> builtins.bool: ...

    def is_user_mountable(self) -> builtins.bool: ...


class AppInfoCreateFlags(GObject.GFlags, builtins.int):
    NEEDS_TERMINAL = ...  # type: AppInfoCreateFlags
    NONE = ...  # type: AppInfoCreateFlags
    SUPPORTS_STARTUP_NOTIFICATION = ...  # type: AppInfoCreateFlags
    SUPPORTS_URIS = ...  # type: AppInfoCreateFlags


class ApplicationFlags(GObject.GFlags, builtins.int):
    ALLOW_REPLACEMENT = ...  # type: ApplicationFlags
    CAN_OVERRIDE_APP_ID = ...  # type: ApplicationFlags
    FLAGS_NONE = ...  # type: ApplicationFlags
    HANDLES_COMMAND_LINE = ...  # type: ApplicationFlags
    HANDLES_OPEN = ...  # type: ApplicationFlags
    IS_LAUNCHER = ...  # type: ApplicationFlags
    IS_SERVICE = ...  # type: ApplicationFlags
    NON_UNIQUE = ...  # type: ApplicationFlags
    REPLACE = ...  # type: ApplicationFlags
    SEND_ENVIRONMENT = ...  # type: ApplicationFlags


class AskPasswordFlags(GObject.GFlags, builtins.int):
    ANONYMOUS_SUPPORTED = ...  # type: AskPasswordFlags
    NEED_DOMAIN = ...  # type: AskPasswordFlags
    NEED_PASSWORD = ...  # type: AskPasswordFlags
    NEED_USERNAME = ...  # type: AskPasswordFlags
    SAVING_SUPPORTED = ...  # type: AskPasswordFlags
    TCRYPT = ...  # type: AskPasswordFlags


class BusNameOwnerFlags(GObject.GFlags, builtins.int):
    ALLOW_REPLACEMENT = ...  # type: BusNameOwnerFlags
    DO_NOT_QUEUE = ...  # type: BusNameOwnerFlags
    NONE = ...  # type: BusNameOwnerFlags
    REPLACE = ...  # type: BusNameOwnerFlags


class BusNameWatcherFlags(GObject.GFlags, builtins.int):
    AUTO_START = ...  # type: BusNameWatcherFlags
    NONE = ...  # type: BusNameWatcherFlags


class ConverterFlags(GObject.GFlags, builtins.int):
    FLUSH = ...  # type: ConverterFlags
    INPUT_AT_END = ...  # type: ConverterFlags
    NONE = ...  # type: ConverterFlags


class DBusCallFlags(GObject.GFlags, builtins.int):
    ALLOW_INTERACTIVE_AUTHORIZATION = ...  # type: DBusCallFlags
    NONE = ...  # type: DBusCallFlags
    NO_AUTO_START = ...  # type: DBusCallFlags


class DBusCapabilityFlags(GObject.GFlags, builtins.int):
    NONE = ...  # type: DBusCapabilityFlags
    UNIX_FD_PASSING = ...  # type: DBusCapabilityFlags


class DBusConnectionFlags(GObject.GFlags, builtins.int):
    AUTHENTICATION_ALLOW_ANONYMOUS = ...  # type: DBusConnectionFlags
    AUTHENTICATION_CLIENT = ...  # type: DBusConnectionFlags
    AUTHENTICATION_SERVER = ...  # type: DBusConnectionFlags
    DELAY_MESSAGE_PROCESSING = ...  # type: DBusConnectionFlags
    MESSAGE_BUS_CONNECTION = ...  # type: DBusConnectionFlags
    NONE = ...  # type: DBusConnectionFlags


class DBusInterfaceSkeletonFlags(GObject.GFlags, builtins.int):
    HANDLE_METHOD_INVOCATIONS_IN_THREAD = ...  # type: DBusInterfaceSkeletonFlags
    NONE = ...  # type: DBusInterfaceSkeletonFlags


class DBusMessageFlags(GObject.GFlags, builtins.int):
    ALLOW_INTERACTIVE_AUTHORIZATION = ...  # type: DBusMessageFlags
    NONE = ...  # type: DBusMessageFlags
    NO_AUTO_START = ...  # type: DBusMessageFlags
    NO_REPLY_EXPECTED = ...  # type: DBusMessageFlags


class DBusObjectManagerClientFlags(GObject.GFlags, builtins.int):
    DO_NOT_AUTO_START = ...  # type: DBusObjectManagerClientFlags
    NONE = ...  # type: DBusObjectManagerClientFlags


class DBusPropertyInfoFlags(GObject.GFlags, builtins.int):
    NONE = ...  # type: DBusPropertyInfoFlags
    READABLE = ...  # type: DBusPropertyInfoFlags
    WRITABLE = ...  # type: DBusPropertyInfoFlags


class DBusProxyFlags(GObject.GFlags, builtins.int):
    DO_NOT_AUTO_START = ...  # type: DBusProxyFlags
    DO_NOT_AUTO_START_AT_CONSTRUCTION = ...  # type: DBusProxyFlags
    DO_NOT_CONNECT_SIGNALS = ...  # type: DBusProxyFlags
    DO_NOT_LOAD_PROPERTIES = ...  # type: DBusProxyFlags
    GET_INVALIDATED_PROPERTIES = ...  # type: DBusProxyFlags
    NONE = ...  # type: DBusProxyFlags


class DBusSendMessageFlags(GObject.GFlags, builtins.int):
    NONE = ...  # type: DBusSendMessageFlags
    PRESERVE_SERIAL = ...  # type: DBusSendMessageFlags


class DBusServerFlags(GObject.GFlags, builtins.int):
    AUTHENTICATION_ALLOW_ANONYMOUS = ...  # type: DBusServerFlags
    NONE = ...  # type: DBusServerFlags
    RUN_IN_THREAD = ...  # type: DBusServerFlags


class DBusSignalFlags(GObject.GFlags, builtins.int):
    MATCH_ARG0_NAMESPACE = ...  # type: DBusSignalFlags
    MATCH_ARG0_PATH = ...  # type: DBusSignalFlags
    NONE = ...  # type: DBusSignalFlags
    NO_MATCH_RULE = ...  # type: DBusSignalFlags


class DBusSubtreeFlags(GObject.GFlags, builtins.int):
    DISPATCH_TO_UNENUMERATED_NODES = ...  # type: DBusSubtreeFlags
    NONE = ...  # type: DBusSubtreeFlags


class DriveStartFlags(GObject.GFlags, builtins.int):
    NONE = ...  # type: DriveStartFlags


class FileAttributeInfoFlags(GObject.GFlags, builtins.int):
    COPY_WHEN_MOVED = ...  # type: FileAttributeInfoFlags
    COPY_WITH_FILE = ...  # type: FileAttributeInfoFlags
    NONE = ...  # type: FileAttributeInfoFlags


class FileCopyFlags(GObject.GFlags, builtins.int):
    ALL_METADATA = ...  # type: FileCopyFlags
    BACKUP = ...  # type: FileCopyFlags
    NOFOLLOW_SYMLINKS = ...  # type: FileCopyFlags
    NONE = ...  # type: FileCopyFlags
    NO_FALLBACK_FOR_MOVE = ...  # type: FileCopyFlags
    OVERWRITE = ...  # type: FileCopyFlags
    TARGET_DEFAULT_PERMS = ...  # type: FileCopyFlags


class FileCreateFlags(GObject.GFlags, builtins.int):
    NONE = ...  # type: FileCreateFlags
    PRIVATE = ...  # type: FileCreateFlags
    REPLACE_DESTINATION = ...  # type: FileCreateFlags


class FileMeasureFlags(GObject.GFlags, builtins.int):
    APPARENT_SIZE = ...  # type: FileMeasureFlags
    NONE = ...  # type: FileMeasureFlags
    NO_XDEV = ...  # type: FileMeasureFlags
    REPORT_ANY_ERROR = ...  # type: FileMeasureFlags


class FileMonitorFlags(GObject.GFlags, builtins.int):
    NONE = ...  # type: FileMonitorFlags
    SEND_MOVED = ...  # type: FileMonitorFlags
    WATCH_HARD_LINKS = ...  # type: FileMonitorFlags
    WATCH_MOUNTS = ...  # type: FileMonitorFlags
    WATCH_MOVES = ...  # type: FileMonitorFlags


class FileQueryInfoFlags(GObject.GFlags, builtins.int):
    NOFOLLOW_SYMLINKS = ...  # type: FileQueryInfoFlags
    NONE = ...  # type: FileQueryInfoFlags


class IOStreamSpliceFlags(GObject.GFlags, builtins.int):
    CLOSE_STREAM1 = ...  # type: IOStreamSpliceFlags
    CLOSE_STREAM2 = ...  # type: IOStreamSpliceFlags
    NONE = ...  # type: IOStreamSpliceFlags
    WAIT_FOR_BOTH = ...  # type: IOStreamSpliceFlags


class MountMountFlags(GObject.GFlags, builtins.int):
    NONE = ...  # type: MountMountFlags


class MountUnmountFlags(GObject.GFlags, builtins.int):
    FORCE = ...  # type: MountUnmountFlags
    NONE = ...  # type: MountUnmountFlags


class OutputStreamSpliceFlags(GObject.GFlags, builtins.int):
    CLOSE_SOURCE = ...  # type: OutputStreamSpliceFlags
    CLOSE_TARGET = ...  # type: OutputStreamSpliceFlags
    NONE = ...  # type: OutputStreamSpliceFlags


class ResolverNameLookupFlags(GObject.GFlags, builtins.int):
    DEFAULT = ...  # type: ResolverNameLookupFlags
    IPV4_ONLY = ...  # type: ResolverNameLookupFlags
    IPV6_ONLY = ...  # type: ResolverNameLookupFlags


class ResourceFlags(GObject.GFlags, builtins.int):
    COMPRESSED = ...  # type: ResourceFlags
    NONE = ...  # type: ResourceFlags


class ResourceLookupFlags(GObject.GFlags, builtins.int):
    NONE = ...  # type: ResourceLookupFlags


class SettingsBindFlags(GObject.GFlags, builtins.int):
    DEFAULT = ...  # type: SettingsBindFlags
    GET = ...  # type: SettingsBindFlags
    GET_NO_CHANGES = ...  # type: SettingsBindFlags
    INVERT_BOOLEAN = ...  # type: SettingsBindFlags
    NO_SENSITIVITY = ...  # type: SettingsBindFlags
    SET = ...  # type: SettingsBindFlags


class SocketMsgFlags(GObject.GFlags, builtins.int):
    DONTROUTE = ...  # type: SocketMsgFlags
    NONE = ...  # type: SocketMsgFlags
    OOB = ...  # type: SocketMsgFlags
    PEEK = ...  # type: SocketMsgFlags


class SubprocessFlags(GObject.GFlags, builtins.int):
    INHERIT_FDS = ...  # type: SubprocessFlags
    NONE = ...  # type: SubprocessFlags
    STDERR_MERGE = ...  # type: SubprocessFlags
    STDERR_PIPE = ...  # type: SubprocessFlags
    STDERR_SILENCE = ...  # type: SubprocessFlags
    STDIN_INHERIT = ...  # type: SubprocessFlags
    STDIN_PIPE = ...  # type: SubprocessFlags
    STDOUT_PIPE = ...  # type: SubprocessFlags
    STDOUT_SILENCE = ...  # type: SubprocessFlags


class TestDBusFlags(GObject.GFlags, builtins.int):
    NONE = ...  # type: TestDBusFlags


class TlsCertificateFlags(GObject.GFlags, builtins.int):
    BAD_IDENTITY = ...  # type: TlsCertificateFlags
    EXPIRED = ...  # type: TlsCertificateFlags
    GENERIC_ERROR = ...  # type: TlsCertificateFlags
    INSECURE = ...  # type: TlsCertificateFlags
    NOT_ACTIVATED = ...  # type: TlsCertificateFlags
    REVOKED = ...  # type: TlsCertificateFlags
    UNKNOWN_CA = ...  # type: TlsCertificateFlags
    VALIDATE_ALL = ...  # type: TlsCertificateFlags


class TlsDatabaseVerifyFlags(GObject.GFlags, builtins.int):
    NONE = ...  # type: TlsDatabaseVerifyFlags


class TlsPasswordFlags(GObject.GFlags, builtins.int):
    FINAL_TRY = ...  # type: TlsPasswordFlags
    MANY_TRIES = ...  # type: TlsPasswordFlags
    NONE = ...  # type: TlsPasswordFlags
    RETRY = ...  # type: TlsPasswordFlags


class BusType(GObject.GEnum, builtins.int):
    NONE = ...  # type: BusType
    SESSION = ...  # type: BusType
    STARTER = ...  # type: BusType
    SYSTEM = ...  # type: BusType


class ConverterResult(GObject.GEnum, builtins.int):
    CONVERTED = ...  # type: ConverterResult
    ERROR = ...  # type: ConverterResult
    FINISHED = ...  # type: ConverterResult
    FLUSHED = ...  # type: ConverterResult


class CredentialsType(GObject.GEnum, builtins.int):
    FREEBSD_CMSGCRED = ...  # type: CredentialsType
    INVALID = ...  # type: CredentialsType
    LINUX_UCRED = ...  # type: CredentialsType
    NETBSD_UNPCBID = ...  # type: CredentialsType
    OPENBSD_SOCKPEERCRED = ...  # type: CredentialsType
    SOLARIS_UCRED = ...  # type: CredentialsType


class DBusError(GObject.GEnum, builtins.int):
    ACCESS_DENIED = ...  # type: DBusError
    ADDRESS_IN_USE = ...  # type: DBusError
    ADT_AUDIT_DATA_UNKNOWN = ...  # type: DBusError
    AUTH_FAILED = ...  # type: DBusError
    BAD_ADDRESS = ...  # type: DBusError
    DISCONNECTED = ...  # type: DBusError
    FAILED = ...  # type: DBusError
    FILE_EXISTS = ...  # type: DBusError
    FILE_NOT_FOUND = ...  # type: DBusError
    INVALID_ARGS = ...  # type: DBusError
    INVALID_FILE_CONTENT = ...  # type: DBusError
    INVALID_SIGNATURE = ...  # type: DBusError
    IO_ERROR = ...  # type: DBusError
    LIMITS_EXCEEDED = ...  # type: DBusError
    MATCH_RULE_INVALID = ...  # type: DBusError
    MATCH_RULE_NOT_FOUND = ...  # type: DBusError
    NAME_HAS_NO_OWNER = ...  # type: DBusError
    NOT_SUPPORTED = ...  # type: DBusError
    NO_MEMORY = ...  # type: DBusError
    NO_NETWORK = ...  # type: DBusError
    NO_REPLY = ...  # type: DBusError
    NO_SERVER = ...  # type: DBusError
    OBJECT_PATH_IN_USE = ...  # type: DBusError
    PROPERTY_READ_ONLY = ...  # type: DBusError
    SELINUX_SECURITY_CONTEXT_UNKNOWN = ...  # type: DBusError
    SERVICE_UNKNOWN = ...  # type: DBusError
    SPAWN_CHILD_EXITED = ...  # type: DBusError
    SPAWN_CHILD_SIGNALED = ...  # type: DBusError
    SPAWN_CONFIG_INVALID = ...  # type: DBusError
    SPAWN_EXEC_FAILED = ...  # type: DBusError
    SPAWN_FAILED = ...  # type: DBusError
    SPAWN_FILE_INVALID = ...  # type: DBusError
    SPAWN_FORK_FAILED = ...  # type: DBusError
    SPAWN_NO_MEMORY = ...  # type: DBusError
    SPAWN_PERMISSIONS_INVALID = ...  # type: DBusError
    SPAWN_SERVICE_INVALID = ...  # type: DBusError
    SPAWN_SERVICE_NOT_FOUND = ...  # type: DBusError
    SPAWN_SETUP_FAILED = ...  # type: DBusError
    TIMED_OUT = ...  # type: DBusError
    TIMEOUT = ...  # type: DBusError
    UNIX_PROCESS_ID_UNKNOWN = ...  # type: DBusError
    UNKNOWN_INTERFACE = ...  # type: DBusError
    UNKNOWN_METHOD = ...  # type: DBusError
    UNKNOWN_OBJECT = ...  # type: DBusError
    UNKNOWN_PROPERTY = ...  # type: DBusError

    @staticmethod
    def encode_gerror(error: GLib.Error) -> builtins.str: ...

    @staticmethod
    def get_remote_error(error: GLib.Error) -> builtins.str: ...

    @staticmethod
    def is_remote_error(error: GLib.Error) -> builtins.bool: ...

    @staticmethod
    def new_for_dbus_error(dbus_error_name: builtins.str, dbus_error_message: builtins.str) -> GLib.Error: ...

    @staticmethod
    def quark() -> builtins.int: ...

    @staticmethod
    def register_error(error_domain: builtins.int, error_code: builtins.int, dbus_error_name: builtins.str) -> builtins.bool: ...

    @staticmethod
    def register_error_domain(error_domain_quark_name: builtins.str, quark_volatile: builtins.int, entries: typing.Sequence[DBusErrorEntry]) -> None: ...

    @staticmethod
    def strip_remote_error(error: GLib.Error) -> builtins.bool: ...

    @staticmethod
    def unregister_error(error_domain: builtins.int, error_code: builtins.int, dbus_error_name: builtins.str) -> builtins.bool: ...


class DBusMessageByteOrder(GObject.GEnum, builtins.int):
    BIG_ENDIAN = ...  # type: DBusMessageByteOrder
    LITTLE_ENDIAN = ...  # type: DBusMessageByteOrder


class DBusMessageHeaderField(GObject.GEnum, builtins.int):
    DESTINATION = ...  # type: DBusMessageHeaderField
    ERROR_NAME = ...  # type: DBusMessageHeaderField
    INTERFACE = ...  # type: DBusMessageHeaderField
    INVALID = ...  # type: DBusMessageHeaderField
    MEMBER = ...  # type: DBusMessageHeaderField
    NUM_UNIX_FDS = ...  # type: DBusMessageHeaderField
    PATH = ...  # type: DBusMessageHeaderField
    REPLY_SERIAL = ...  # type: DBusMessageHeaderField
    SENDER = ...  # type: DBusMessageHeaderField
    SIGNATURE = ...  # type: DBusMessageHeaderField


class DBusMessageType(GObject.GEnum, builtins.int):
    ERROR = ...  # type: DBusMessageType
    INVALID = ...  # type: DBusMessageType
    METHOD_CALL = ...  # type: DBusMessageType
    METHOD_RETURN = ...  # type: DBusMessageType
    SIGNAL = ...  # type: DBusMessageType


class DataStreamByteOrder(GObject.GEnum, builtins.int):
    BIG_ENDIAN = ...  # type: DataStreamByteOrder
    HOST_ENDIAN = ...  # type: DataStreamByteOrder
    LITTLE_ENDIAN = ...  # type: DataStreamByteOrder


class DataStreamNewlineType(GObject.GEnum, builtins.int):
    ANY = ...  # type: DataStreamNewlineType
    CR = ...  # type: DataStreamNewlineType
    CR_LF = ...  # type: DataStreamNewlineType
    LF = ...  # type: DataStreamNewlineType


class DriveStartStopType(GObject.GEnum, builtins.int):
    MULTIDISK = ...  # type: DriveStartStopType
    NETWORK = ...  # type: DriveStartStopType
    PASSWORD = ...  # type: DriveStartStopType
    SHUTDOWN = ...  # type: DriveStartStopType
    UNKNOWN = ...  # type: DriveStartStopType


class EmblemOrigin(GObject.GEnum, builtins.int):
    DEVICE = ...  # type: EmblemOrigin
    LIVEMETADATA = ...  # type: EmblemOrigin
    TAG = ...  # type: EmblemOrigin
    UNKNOWN = ...  # type: EmblemOrigin


class FileAttributeStatus(GObject.GEnum, builtins.int):
    ERROR_SETTING = ...  # type: FileAttributeStatus
    SET = ...  # type: FileAttributeStatus
    UNSET = ...  # type: FileAttributeStatus


class FileAttributeType(GObject.GEnum, builtins.int):
    BOOLEAN = ...  # type: FileAttributeType
    BYTE_STRING = ...  # type: FileAttributeType
    INT32 = ...  # type: FileAttributeType
    INT64 = ...  # type: FileAttributeType
    INVALID = ...  # type: FileAttributeType
    OBJECT = ...  # type: FileAttributeType
    STRING = ...  # type: FileAttributeType
    STRINGV = ...  # type: FileAttributeType
    UINT32 = ...  # type: FileAttributeType
    UINT64 = ...  # type: FileAttributeType


class FileMonitorEvent(GObject.GEnum, builtins.int):
    ATTRIBUTE_CHANGED = ...  # type: FileMonitorEvent
    CHANGED = ...  # type: FileMonitorEvent
    CHANGES_DONE_HINT = ...  # type: FileMonitorEvent
    CREATED = ...  # type: FileMonitorEvent
    DELETED = ...  # type: FileMonitorEvent
    MOVED = ...  # type: FileMonitorEvent
    MOVED_IN = ...  # type: FileMonitorEvent
    MOVED_OUT = ...  # type: FileMonitorEvent
    PRE_UNMOUNT = ...  # type: FileMonitorEvent
    RENAMED = ...  # type: FileMonitorEvent
    UNMOUNTED = ...  # type: FileMonitorEvent


class FileType(GObject.GEnum, builtins.int):
    DIRECTORY = ...  # type: FileType
    MOUNTABLE = ...  # type: FileType
    REGULAR = ...  # type: FileType
    SHORTCUT = ...  # type: FileType
    SPECIAL = ...  # type: FileType
    SYMBOLIC_LINK = ...  # type: FileType
    UNKNOWN = ...  # type: FileType


class FilesystemPreviewType(GObject.GEnum, builtins.int):
    IF_ALWAYS = ...  # type: FilesystemPreviewType
    IF_LOCAL = ...  # type: FilesystemPreviewType
    NEVER = ...  # type: FilesystemPreviewType


class IOErrorEnum(GObject.GEnum, builtins.int):
    ADDRESS_IN_USE = ...  # type: IOErrorEnum
    ALREADY_MOUNTED = ...  # type: IOErrorEnum
    BROKEN_PIPE = ...  # type: IOErrorEnum
    BUSY = ...  # type: IOErrorEnum
    CANCELLED = ...  # type: IOErrorEnum
    CANT_CREATE_BACKUP = ...  # type: IOErrorEnum
    CLOSED = ...  # type: IOErrorEnum
    CONNECTION_CLOSED = ...  # type: IOErrorEnum
    CONNECTION_REFUSED = ...  # type: IOErrorEnum
    DBUS_ERROR = ...  # type: IOErrorEnum
    EXISTS = ...  # type: IOErrorEnum
    FAILED = ...  # type: IOErrorEnum
    FAILED_HANDLED = ...  # type: IOErrorEnum
    FILENAME_TOO_LONG = ...  # type: IOErrorEnum
    HOST_NOT_FOUND = ...  # type: IOErrorEnum
    HOST_UNREACHABLE = ...  # type: IOErrorEnum
    INVALID_ARGUMENT = ...  # type: IOErrorEnum
    INVALID_DATA = ...  # type: IOErrorEnum
    INVALID_FILENAME = ...  # type: IOErrorEnum
    IS_DIRECTORY = ...  # type: IOErrorEnum
    MESSAGE_TOO_LARGE = ...  # type: IOErrorEnum
    NETWORK_UNREACHABLE = ...  # type: IOErrorEnum
    NOT_CONNECTED = ...  # type: IOErrorEnum
    NOT_DIRECTORY = ...  # type: IOErrorEnum
    NOT_EMPTY = ...  # type: IOErrorEnum
    NOT_FOUND = ...  # type: IOErrorEnum
    NOT_INITIALIZED = ...  # type: IOErrorEnum
    NOT_MOUNTABLE_FILE = ...  # type: IOErrorEnum
    NOT_MOUNTED = ...  # type: IOErrorEnum
    NOT_REGULAR_FILE = ...  # type: IOErrorEnum
    NOT_SUPPORTED = ...  # type: IOErrorEnum
    NOT_SYMBOLIC_LINK = ...  # type: IOErrorEnum
    NO_SPACE = ...  # type: IOErrorEnum
    PARTIAL_INPUT = ...  # type: IOErrorEnum
    PENDING = ...  # type: IOErrorEnum
    PERMISSION_DENIED = ...  # type: IOErrorEnum
    PROXY_AUTH_FAILED = ...  # type: IOErrorEnum
    PROXY_FAILED = ...  # type: IOErrorEnum
    PROXY_NEED_AUTH = ...  # type: IOErrorEnum
    PROXY_NOT_ALLOWED = ...  # type: IOErrorEnum
    READ_ONLY = ...  # type: IOErrorEnum
    TIMED_OUT = ...  # type: IOErrorEnum
    TOO_MANY_LINKS = ...  # type: IOErrorEnum
    TOO_MANY_OPEN_FILES = ...  # type: IOErrorEnum
    WOULD_BLOCK = ...  # type: IOErrorEnum
    WOULD_MERGE = ...  # type: IOErrorEnum
    WOULD_RECURSE = ...  # type: IOErrorEnum
    WRONG_ETAG = ...  # type: IOErrorEnum


class IOModuleScopeFlags(GObject.GEnum, builtins.int):
    BLOCK_DUPLICATES = ...  # type: IOModuleScopeFlags
    NONE = ...  # type: IOModuleScopeFlags


class MemoryMonitorWarningLevel(GObject.GEnum, builtins.int):
    CRITICAL = ...  # type: MemoryMonitorWarningLevel
    LOW = ...  # type: MemoryMonitorWarningLevel
    MEDIUM = ...  # type: MemoryMonitorWarningLevel


class MountOperationResult(GObject.GEnum, builtins.int):
    ABORTED = ...  # type: MountOperationResult
    HANDLED = ...  # type: MountOperationResult
    UNHANDLED = ...  # type: MountOperationResult


class NetworkConnectivity(GObject.GEnum, builtins.int):
    FULL = ...  # type: NetworkConnectivity
    LIMITED = ...  # type: NetworkConnectivity
    LOCAL = ...  # type: NetworkConnectivity
    PORTAL = ...  # type: NetworkConnectivity


class NotificationPriority(GObject.GEnum, builtins.int):
    HIGH = ...  # type: NotificationPriority
    LOW = ...  # type: NotificationPriority
    NORMAL = ...  # type: NotificationPriority
    URGENT = ...  # type: NotificationPriority


class PasswordSave(GObject.GEnum, builtins.int):
    FOR_SESSION = ...  # type: PasswordSave
    NEVER = ...  # type: PasswordSave
    PERMANENTLY = ...  # type: PasswordSave


class PollableReturn(GObject.GEnum, builtins.int):
    FAILED = ...  # type: PollableReturn
    OK = ...  # type: PollableReturn
    WOULD_BLOCK = ...  # type: PollableReturn


class ResolverError(GObject.GEnum, builtins.int):
    INTERNAL = ...  # type: ResolverError
    NOT_FOUND = ...  # type: ResolverError
    TEMPORARY_FAILURE = ...  # type: ResolverError

    @staticmethod
    def quark() -> builtins.int: ...


class ResolverRecordType(GObject.GEnum, builtins.int):
    MX = ...  # type: ResolverRecordType
    NS = ...  # type: ResolverRecordType
    SOA = ...  # type: ResolverRecordType
    SRV = ...  # type: ResolverRecordType
    TXT = ...  # type: ResolverRecordType


class ResourceError(GObject.GEnum, builtins.int):
    INTERNAL = ...  # type: ResourceError
    NOT_FOUND = ...  # type: ResourceError

    @staticmethod
    def quark() -> builtins.int: ...


class SocketClientEvent(GObject.GEnum, builtins.int):
    COMPLETE = ...  # type: SocketClientEvent
    CONNECTED = ...  # type: SocketClientEvent
    CONNECTING = ...  # type: SocketClientEvent
    PROXY_NEGOTIATED = ...  # type: SocketClientEvent
    PROXY_NEGOTIATING = ...  # type: SocketClientEvent
    RESOLVED = ...  # type: SocketClientEvent
    RESOLVING = ...  # type: SocketClientEvent
    TLS_HANDSHAKED = ...  # type: SocketClientEvent
    TLS_HANDSHAKING = ...  # type: SocketClientEvent


class SocketFamily(GObject.GEnum, builtins.int):
    INVALID = ...  # type: SocketFamily
    IPV4 = ...  # type: SocketFamily
    IPV6 = ...  # type: SocketFamily
    UNIX = ...  # type: SocketFamily


class SocketListenerEvent(GObject.GEnum, builtins.int):
    BINDING = ...  # type: SocketListenerEvent
    BOUND = ...  # type: SocketListenerEvent
    LISTENED = ...  # type: SocketListenerEvent
    LISTENING = ...  # type: SocketListenerEvent


class SocketProtocol(GObject.GEnum, builtins.int):
    DEFAULT = ...  # type: SocketProtocol
    SCTP = ...  # type: SocketProtocol
    TCP = ...  # type: SocketProtocol
    UDP = ...  # type: SocketProtocol
    UNKNOWN = ...  # type: SocketProtocol


class SocketType(GObject.GEnum, builtins.int):
    DATAGRAM = ...  # type: SocketType
    INVALID = ...  # type: SocketType
    SEQPACKET = ...  # type: SocketType
    STREAM = ...  # type: SocketType


class TlsAuthenticationMode(GObject.GEnum, builtins.int):
    NONE = ...  # type: TlsAuthenticationMode
    REQUESTED = ...  # type: TlsAuthenticationMode
    REQUIRED = ...  # type: TlsAuthenticationMode


class TlsCertificateRequestFlags(GObject.GEnum, builtins.int):
    NONE = ...  # type: TlsCertificateRequestFlags


class TlsDatabaseLookupFlags(GObject.GEnum, builtins.int):
    KEYPAIR = ...  # type: TlsDatabaseLookupFlags
    NONE = ...  # type: TlsDatabaseLookupFlags


class TlsError(GObject.GEnum, builtins.int):
    BAD_CERTIFICATE = ...  # type: TlsError
    CERTIFICATE_REQUIRED = ...  # type: TlsError
    EOF = ...  # type: TlsError
    HANDSHAKE = ...  # type: TlsError
    INAPPROPRIATE_FALLBACK = ...  # type: TlsError
    MISC = ...  # type: TlsError
    NOT_TLS = ...  # type: TlsError
    UNAVAILABLE = ...  # type: TlsError

    @staticmethod
    def quark() -> builtins.int: ...


class TlsInteractionResult(GObject.GEnum, builtins.int):
    FAILED = ...  # type: TlsInteractionResult
    HANDLED = ...  # type: TlsInteractionResult
    UNHANDLED = ...  # type: TlsInteractionResult


class TlsRehandshakeMode(GObject.GEnum, builtins.int):
    NEVER = ...  # type: TlsRehandshakeMode
    SAFELY = ...  # type: TlsRehandshakeMode
    UNSAFELY = ...  # type: TlsRehandshakeMode


class UnixSocketAddressType(GObject.GEnum, builtins.int):
    ABSTRACT = ...  # type: UnixSocketAddressType
    ABSTRACT_PADDED = ...  # type: UnixSocketAddressType
    ANONYMOUS = ...  # type: UnixSocketAddressType
    INVALID = ...  # type: UnixSocketAddressType
    PATH = ...  # type: UnixSocketAddressType


class ZlibCompressorFormat(GObject.GEnum, builtins.int):
    GZIP = ...  # type: ZlibCompressorFormat
    RAW = ...  # type: ZlibCompressorFormat
    ZLIB = ...  # type: ZlibCompressorFormat


AsyncReadyCallback = typing.Callable[[typing.Optional[GObject.Object], AsyncResult, typing.Optional[builtins.object]], None]
BusAcquiredCallback = typing.Callable[[DBusConnection, builtins.str, typing.Optional[builtins.object]], None]
BusNameAcquiredCallback = typing.Callable[[DBusConnection, builtins.str, typing.Optional[builtins.object]], None]
BusNameAppearedCallback = typing.Callable[[DBusConnection, builtins.str, builtins.str, typing.Optional[builtins.object]], None]
BusNameLostCallback = typing.Callable[[DBusConnection, builtins.str, typing.Optional[builtins.object]], None]
BusNameVanishedCallback = typing.Callable[[DBusConnection, builtins.str, typing.Optional[builtins.object]], None]
CancellableSourceFunc = typing.Callable[[typing.Optional[Cancellable], typing.Optional[builtins.object]], builtins.bool]
DBusInterfaceGetPropertyFunc = typing.Callable[[DBusConnection, builtins.str, builtins.str, builtins.str, builtins.str, GLib.Error, typing.Optional[builtins.object]], GLib.Variant]
DBusInterfaceMethodCallFunc = typing.Callable[[DBusConnection, builtins.str, builtins.str, builtins.str, builtins.str, GLib.Variant, DBusMethodInvocation], None]
DBusInterfaceSetPropertyFunc = typing.Callable[[DBusConnection, builtins.str, builtins.str, builtins.str, builtins.str, GLib.Variant, GLib.Error, typing.Optional[builtins.object]], builtins.bool]
DBusMessageFilterFunction = typing.Callable[[DBusConnection, DBusMessage, builtins.bool, typing.Optional[builtins.object]], typing.Optional[DBusMessage]]
DBusProxyTypeFunc = typing.Callable[[DBusObjectManagerClient, builtins.str, typing.Optional[builtins.str], typing.Optional[builtins.object]], GObject.GType]
DBusSignalCallback = typing.Callable[[DBusConnection, builtins.str, builtins.str, builtins.str, builtins.str, GLib.Variant, typing.Optional[builtins.object]], None]
DBusSubtreeDispatchFunc = typing.Callable[[DBusConnection, builtins.str, builtins.str, builtins.str, builtins.str, builtins.object, typing.Optional[builtins.object]], DBusInterfaceVTable]
DBusSubtreeIntrospectFunc = typing.Callable[[DBusConnection, builtins.str, builtins.str, builtins.str, typing.Optional[builtins.object]], DBusInterfaceInfo]
DatagramBasedSourceFunc = typing.Callable[[DatagramBased, GLib.IOCondition, typing.Optional[builtins.object]], builtins.bool]
DesktopAppLaunchCallback = typing.Callable[[DesktopAppInfo, builtins.int, typing.Optional[builtins.object]], None]
FileMeasureProgressCallback = typing.Callable[[builtins.bool, builtins.int, builtins.int, builtins.int, typing.Optional[builtins.object]], None]
FileProgressCallback = typing.Callable[[builtins.int, builtins.int, typing.Optional[builtins.object]], None]
FileReadMoreCallback = typing.Callable[[builtins.str, builtins.int, typing.Optional[builtins.object]], builtins.bool]
IOSchedulerJobFunc = typing.Callable[[IOSchedulerJob, typing.Optional[Cancellable], typing.Optional[builtins.object]], builtins.bool]
PollableSourceFunc = typing.Callable[[GObject.Object, typing.Optional[builtins.object]], builtins.bool]
ReallocFunc = typing.Callable[[typing.Optional[builtins.object], builtins.int], typing.Optional[builtins.object]]
SettingsBindGetMapping = typing.Callable[[GObject.Value, GLib.Variant, typing.Optional[builtins.object]], builtins.bool]
SettingsBindSetMapping = typing.Callable[[GObject.Value, GLib.VariantType, typing.Optional[builtins.object]], GLib.Variant]
SettingsGetMapping = typing.Callable[[GLib.Variant, typing.Optional[builtins.object]], typing.Tuple[builtins.bool, builtins.object]]
SimpleAsyncThreadFunc = typing.Callable[[SimpleAsyncResult, GObject.Object, typing.Optional[Cancellable]], None]
SocketSourceFunc = typing.Callable[[Socket, GLib.IOCondition, typing.Optional[builtins.object]], builtins.bool]
TaskThreadFunc = typing.Callable[[Task, GObject.Object, typing.Optional[builtins.object], typing.Optional[Cancellable]], None]
VfsFileLookupFunc = typing.Callable[[Vfs, builtins.str, typing.Optional[builtins.object]], File]


def action_name_is_valid(action_name: builtins.str) -> builtins.bool: ...


def action_parse_detailed_name(detailed_name: builtins.str) -> typing.Tuple[builtins.bool, builtins.str, GLib.Variant]: ...


def action_print_detailed_name(action_name: builtins.str, target_value: typing.Optional[GLib.Variant]) -> builtins.str: ...


def app_info_create_from_commandline(commandline: builtins.str, application_name: typing.Optional[builtins.str], flags: AppInfoCreateFlags) -> AppInfo: ...


def app_info_get_all() -> typing.Sequence[AppInfo]: ...


def app_info_get_all_for_type(content_type: builtins.str) -> typing.Sequence[AppInfo]: ...


def app_info_get_default_for_type(content_type: builtins.str, must_support_uris: builtins.bool) -> AppInfo: ...


def app_info_get_default_for_uri_scheme(uri_scheme: builtins.str) -> AppInfo: ...


def app_info_get_fallback_for_type(content_type: builtins.str) -> typing.Sequence[AppInfo]: ...


def app_info_get_recommended_for_type(content_type: builtins.str) -> typing.Sequence[AppInfo]: ...


def app_info_launch_default_for_uri(uri: builtins.str, context: typing.Optional[AppLaunchContext]) -> builtins.bool: ...


def app_info_launch_default_for_uri_async(uri: builtins.str, context: typing.Optional[AppLaunchContext], cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...


def app_info_launch_default_for_uri_finish(result: AsyncResult) -> builtins.bool: ...


def app_info_reset_type_associations(content_type: builtins.str) -> None: ...


def async_initable_newv_async(object_type: GObject.GType, n_parameters: builtins.int, parameters: GObject.Parameter, io_priority: builtins.int, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...


def bus_get(bus_type: BusType, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...


def bus_get_finish(res: AsyncResult) -> DBusConnection: ...


def bus_get_sync(bus_type: BusType, cancellable: typing.Optional[Cancellable] = None) -> DBusConnection: ...


def bus_own_name(bus_type: BusType, name: builtins.str, flags: BusNameOwnerFlags, bus_acquired_closure: typing.Optional[GObject.Closure], name_acquired_closure: typing.Optional[GObject.Closure], name_lost_closure: typing.Optional[GObject.Closure]) -> builtins.int: ...


def bus_own_name_on_connection(connection: DBusConnection, name: builtins.str, flags: BusNameOwnerFlags, name_acquired_closure: typing.Optional[GObject.Closure], name_lost_closure: typing.Optional[GObject.Closure]) -> builtins.int: ...


def bus_unown_name(owner_id: builtins.int) -> None: ...


def bus_unwatch_name(watcher_id: builtins.int) -> None: ...


def bus_watch_name(bus_type: BusType, name: builtins.str, flags: BusNameWatcherFlags, name_appeared_closure: typing.Optional[typing.Callable[[DBusConnection, str, str], None]], name_vanished_closure: typing.Optional[typing.Callable[[DBusConnection, str], None]]) -> builtins.int: ...


def bus_watch_name_on_connection(connection: DBusConnection, name: builtins.str, flags: BusNameWatcherFlags, name_appeared_closure: typing.Optional[GObject.Closure], name_vanished_closure: typing.Optional[GObject.Closure]) -> builtins.int: ...


def content_type_can_be_executable(type: builtins.str) -> builtins.bool: ...


def content_type_equals(type1: builtins.str, type2: builtins.str) -> builtins.bool: ...


def content_type_from_mime_type(mime_type: builtins.str) -> typing.Optional[builtins.str]: ...


def content_type_get_description(type: builtins.str) -> builtins.str: ...


def content_type_get_generic_icon_name(type: builtins.str) -> typing.Optional[builtins.str]: ...


def content_type_get_icon(type: builtins.str) -> Icon: ...


def content_type_get_mime_dirs() -> typing.Sequence[builtins.str]: ...


def content_type_get_mime_type(type: builtins.str) -> typing.Optional[builtins.str]: ...


def content_type_get_symbolic_icon(type: builtins.str) -> Icon: ...


def content_type_guess(filename: typing.Optional[builtins.str], data: typing.Optional[builtins.bytes]) -> typing.Tuple[builtins.str, builtins.bool]: ...


def content_type_guess_for_tree(root: File) -> typing.Sequence[builtins.str]: ...


def content_type_is_a(type: builtins.str, supertype: builtins.str) -> builtins.bool: ...


def content_type_is_mime_type(type: builtins.str, mime_type: builtins.str) -> builtins.bool: ...


def content_type_is_unknown(type: builtins.str) -> builtins.bool: ...


def content_type_set_mime_dirs(dirs: typing.Optional[typing.Sequence[builtins.str]]) -> None: ...


def content_types_get_registered() -> typing.Sequence[builtins.str]: ...


def dbus_address_escape_value(string: builtins.str) -> builtins.str: ...


def dbus_address_get_for_bus_sync(bus_type: BusType, cancellable: typing.Optional[Cancellable]) -> builtins.str: ...


def dbus_address_get_stream(address: builtins.str, cancellable: typing.Optional[Cancellable], callback: typing.Optional[AsyncReadyCallback], *user_data: typing.Optional[builtins.object]) -> None: ...


def dbus_address_get_stream_finish(res: AsyncResult) -> typing.Tuple[IOStream, builtins.str]: ...


def dbus_address_get_stream_sync(address: builtins.str, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[IOStream, builtins.str]: ...


def dbus_annotation_info_lookup(annotations: typing.Optional[typing.Sequence[DBusAnnotationInfo]], name: builtins.str) -> builtins.str: ...


def dbus_error_encode_gerror(error: GLib.Error) -> builtins.str: ...


def dbus_error_get_remote_error(error: GLib.Error) -> builtins.str: ...


def dbus_error_is_remote_error(error: GLib.Error) -> builtins.bool: ...


def dbus_error_new_for_dbus_error(dbus_error_name: builtins.str, dbus_error_message: builtins.str) -> GLib.Error: ...


def dbus_error_quark() -> builtins.int: ...


def dbus_error_register_error(error_domain: builtins.int, error_code: builtins.int, dbus_error_name: builtins.str) -> builtins.bool: ...


def dbus_error_register_error_domain(error_domain_quark_name: builtins.str, quark_volatile: builtins.int, entries: typing.Sequence[DBusErrorEntry]) -> None: ...


def dbus_error_strip_remote_error(error: GLib.Error) -> builtins.bool: ...


def dbus_error_unregister_error(error_domain: builtins.int, error_code: builtins.int, dbus_error_name: builtins.str) -> builtins.bool: ...


def dbus_generate_guid() -> builtins.str: ...


def dbus_gvalue_to_gvariant(gvalue: GObject.Value, type: GLib.VariantType) -> GLib.Variant: ...


def dbus_gvariant_to_gvalue(value: GLib.Variant) -> GObject.Value: ...


def dbus_is_address(string: builtins.str) -> builtins.bool: ...


def dbus_is_guid(string: builtins.str) -> builtins.bool: ...


def dbus_is_interface_name(string: builtins.str) -> builtins.bool: ...


def dbus_is_member_name(string: builtins.str) -> builtins.bool: ...


def dbus_is_name(string: builtins.str) -> builtins.bool: ...


def dbus_is_supported_address(string: builtins.str) -> builtins.bool: ...


def dbus_is_unique_name(string: builtins.str) -> builtins.bool: ...


def dtls_client_connection_new(base_socket: DatagramBased, server_identity: typing.Optional[SocketConnectable]) -> DtlsClientConnection: ...


def dtls_server_connection_new(base_socket: DatagramBased, certificate: typing.Optional[TlsCertificate]) -> DtlsServerConnection: ...


def file_new_for_commandline_arg(arg: builtins.str) -> File: ...


def file_new_for_commandline_arg_and_cwd(arg: builtins.str, cwd: builtins.str) -> File: ...


def file_new_for_path(path: builtins.str) -> File: ...


def file_new_for_uri(uri: builtins.str) -> File: ...


def file_new_tmp(tmpl: typing.Optional[builtins.str]) -> typing.Tuple[File, FileIOStream]: ...


def file_parse_name(parse_name: builtins.str) -> File: ...


def icon_deserialize(value: GLib.Variant) -> Icon: ...


def icon_hash(icon: builtins.object) -> builtins.int: ...


def icon_new_for_string(str: builtins.str) -> Icon: ...


def initable_newv(object_type: GObject.GType, parameters: typing.Sequence[GObject.Parameter], cancellable: typing.Optional[Cancellable]) -> GObject.Object: ...


def io_error_from_errno(err_no: builtins.int) -> IOErrorEnum: ...


def io_error_quark() -> builtins.int: ...


def io_extension_point_implement(extension_point_name: builtins.str, type: GObject.GType, extension_name: builtins.str, priority: builtins.int) -> IOExtension: ...


def io_extension_point_lookup(name: builtins.str) -> IOExtensionPoint: ...


def io_extension_point_register(name: builtins.str) -> IOExtensionPoint: ...


def io_modules_load_all_in_directory(dirname: builtins.str) -> typing.Sequence[IOModule]: ...


def io_modules_load_all_in_directory_with_scope(dirname: builtins.str, scope: IOModuleScope) -> typing.Sequence[IOModule]: ...


def io_modules_scan_all_in_directory(dirname: builtins.str) -> None: ...


def io_modules_scan_all_in_directory_with_scope(dirname: builtins.str, scope: IOModuleScope) -> None: ...


def io_scheduler_cancel_all_jobs() -> None: ...


def io_scheduler_push_job(job_func: IOSchedulerJobFunc, user_data: typing.Optional[builtins.object], io_priority: builtins.int, cancellable: typing.Optional[Cancellable]) -> None: ...


def keyfile_settings_backend_new(filename: builtins.str, root_path: builtins.str, root_group: typing.Optional[builtins.str]) -> SettingsBackend: ...


def memory_monitor_dup_default() -> MemoryMonitor: ...


def memory_settings_backend_new() -> SettingsBackend: ...


def network_monitor_get_default() -> NetworkMonitor: ...


def networking_init() -> None: ...


def null_settings_backend_new() -> SettingsBackend: ...


def pollable_source_new(pollable_stream: GObject.Object) -> GLib.Source: ...


def pollable_source_new_full(pollable_stream: GObject.Object, child_source: typing.Optional[GLib.Source], cancellable: typing.Optional[Cancellable]) -> GLib.Source: ...


def pollable_stream_read(stream: InputStream, buffer: builtins.bytes, blocking: builtins.bool, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...


def pollable_stream_write(stream: OutputStream, buffer: builtins.bytes, blocking: builtins.bool, cancellable: typing.Optional[Cancellable]) -> builtins.int: ...


def pollable_stream_write_all(stream: OutputStream, buffer: builtins.bytes, blocking: builtins.bool, cancellable: typing.Optional[Cancellable]) -> typing.Tuple[builtins.bool, builtins.int]: ...


def proxy_get_default_for_protocol(protocol: builtins.str) -> Proxy: ...


def proxy_resolver_get_default() -> ProxyResolver: ...


def resolver_error_quark() -> builtins.int: ...


def resource_error_quark() -> builtins.int: ...


def resource_load(filename: builtins.str) -> Resource: ...


def resources_enumerate_children(path: builtins.str, lookup_flags: ResourceLookupFlags) -> typing.Sequence[builtins.str]: ...


def resources_get_info(path: builtins.str, lookup_flags: ResourceLookupFlags) -> typing.Tuple[builtins.bool, builtins.int, builtins.int]: ...


def resources_lookup_data(path: builtins.str, lookup_flags: ResourceLookupFlags) -> GLib.Bytes: ...


def resources_open_stream(path: builtins.str, lookup_flags: ResourceLookupFlags) -> InputStream: ...


def resources_register(resource: Resource) -> None: ...


def resources_unregister(resource: Resource) -> None: ...


def settings_schema_source_get_default() -> typing.Optional[SettingsSchemaSource]: ...


def simple_async_report_gerror_in_idle(object: typing.Optional[GObject.Object], callback: typing.Optional[AsyncReadyCallback], user_data: typing.Optional[builtins.object], error: GLib.Error) -> None: ...


def tls_backend_get_default() -> TlsBackend: ...


def tls_client_connection_new(base_io_stream: IOStream, server_identity: typing.Optional[SocketConnectable]) -> TlsClientConnection: ...


def tls_error_quark() -> builtins.int: ...


def tls_file_database_new(anchors: builtins.str) -> TlsFileDatabase: ...


def tls_server_connection_new(base_io_stream: IOStream, certificate: typing.Optional[TlsCertificate]) -> TlsServerConnection: ...


def unix_is_mount_path_system_internal(mount_path: builtins.str) -> builtins.bool: ...


def unix_is_system_device_path(device_path: builtins.str) -> builtins.bool: ...


def unix_is_system_fs_type(fs_type: builtins.str) -> builtins.bool: ...


def unix_mount_at(mount_path: builtins.str) -> typing.Tuple[UnixMountEntry, builtins.int]: ...


def unix_mount_compare(mount1: UnixMountEntry, mount2: UnixMountEntry) -> builtins.int: ...


def unix_mount_copy(mount_entry: UnixMountEntry) -> UnixMountEntry: ...


def unix_mount_for(file_path: builtins.str) -> typing.Tuple[UnixMountEntry, builtins.int]: ...


def unix_mount_free(mount_entry: UnixMountEntry) -> None: ...


def unix_mount_get_device_path(mount_entry: UnixMountEntry) -> builtins.str: ...


def unix_mount_get_fs_type(mount_entry: UnixMountEntry) -> builtins.str: ...


def unix_mount_get_mount_path(mount_entry: UnixMountEntry) -> builtins.str: ...


def unix_mount_get_options(mount_entry: UnixMountEntry) -> typing.Optional[builtins.str]: ...


def unix_mount_get_root_path(mount_entry: UnixMountEntry) -> typing.Optional[builtins.str]: ...


def unix_mount_guess_can_eject(mount_entry: UnixMountEntry) -> builtins.bool: ...


def unix_mount_guess_icon(mount_entry: UnixMountEntry) -> Icon: ...


def unix_mount_guess_name(mount_entry: UnixMountEntry) -> builtins.str: ...


def unix_mount_guess_should_display(mount_entry: UnixMountEntry) -> builtins.bool: ...


def unix_mount_guess_symbolic_icon(mount_entry: UnixMountEntry) -> Icon: ...


def unix_mount_is_readonly(mount_entry: UnixMountEntry) -> builtins.bool: ...


def unix_mount_is_system_internal(mount_entry: UnixMountEntry) -> builtins.bool: ...


def unix_mount_points_changed_since(time: builtins.int) -> builtins.bool: ...


def unix_mount_points_get() -> typing.Tuple[typing.Sequence[UnixMountPoint], builtins.int]: ...


def unix_mounts_changed_since(time: builtins.int) -> builtins.bool: ...


def unix_mounts_get() -> typing.Tuple[typing.Sequence[UnixMountEntry], builtins.int]: ...


DESKTOP_APP_INFO_LOOKUP_EXTENSION_POINT_NAME: builtins.str
DRIVE_IDENTIFIER_KIND_UNIX_DEVICE: builtins.str
FILE_ATTRIBUTE_ACCESS_CAN_DELETE: builtins.str
FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE: builtins.str
FILE_ATTRIBUTE_ACCESS_CAN_READ: builtins.str
FILE_ATTRIBUTE_ACCESS_CAN_RENAME: builtins.str
FILE_ATTRIBUTE_ACCESS_CAN_TRASH: builtins.str
FILE_ATTRIBUTE_ACCESS_CAN_WRITE: builtins.str
FILE_ATTRIBUTE_DOS_IS_ARCHIVE: builtins.str
FILE_ATTRIBUTE_DOS_IS_MOUNTPOINT: builtins.str
FILE_ATTRIBUTE_DOS_IS_SYSTEM: builtins.str
FILE_ATTRIBUTE_DOS_REPARSE_POINT_TAG: builtins.str
FILE_ATTRIBUTE_ETAG_VALUE: builtins.str
FILE_ATTRIBUTE_FILESYSTEM_FREE: builtins.str
FILE_ATTRIBUTE_FILESYSTEM_READONLY: builtins.str
FILE_ATTRIBUTE_FILESYSTEM_REMOTE: builtins.str
FILE_ATTRIBUTE_FILESYSTEM_SIZE: builtins.str
FILE_ATTRIBUTE_FILESYSTEM_TYPE: builtins.str
FILE_ATTRIBUTE_FILESYSTEM_USED: builtins.str
FILE_ATTRIBUTE_FILESYSTEM_USE_PREVIEW: builtins.str
FILE_ATTRIBUTE_GVFS_BACKEND: builtins.str
FILE_ATTRIBUTE_ID_FILE: builtins.str
FILE_ATTRIBUTE_ID_FILESYSTEM: builtins.str
FILE_ATTRIBUTE_MOUNTABLE_CAN_EJECT: builtins.str
FILE_ATTRIBUTE_MOUNTABLE_CAN_MOUNT: builtins.str
FILE_ATTRIBUTE_MOUNTABLE_CAN_POLL: builtins.str
FILE_ATTRIBUTE_MOUNTABLE_CAN_START: builtins.str
FILE_ATTRIBUTE_MOUNTABLE_CAN_START_DEGRADED: builtins.str
FILE_ATTRIBUTE_MOUNTABLE_CAN_STOP: builtins.str
FILE_ATTRIBUTE_MOUNTABLE_CAN_UNMOUNT: builtins.str
FILE_ATTRIBUTE_MOUNTABLE_HAL_UDI: builtins.str
FILE_ATTRIBUTE_MOUNTABLE_IS_MEDIA_CHECK_AUTOMATIC: builtins.str
FILE_ATTRIBUTE_MOUNTABLE_START_STOP_TYPE: builtins.str
FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE: builtins.str
FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE_FILE: builtins.str
FILE_ATTRIBUTE_OWNER_GROUP: builtins.str
FILE_ATTRIBUTE_OWNER_USER: builtins.str
FILE_ATTRIBUTE_OWNER_USER_REAL: builtins.str
FILE_ATTRIBUTE_PREVIEW_ICON: builtins.str
FILE_ATTRIBUTE_RECENT_MODIFIED: builtins.str
FILE_ATTRIBUTE_SELINUX_CONTEXT: builtins.str
FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE: builtins.str
FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE: builtins.str
FILE_ATTRIBUTE_STANDARD_COPY_NAME: builtins.str
FILE_ATTRIBUTE_STANDARD_DESCRIPTION: builtins.str
FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME: builtins.str
FILE_ATTRIBUTE_STANDARD_EDIT_NAME: builtins.str
FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE: builtins.str
FILE_ATTRIBUTE_STANDARD_ICON: builtins.str
FILE_ATTRIBUTE_STANDARD_IS_BACKUP: builtins.str
FILE_ATTRIBUTE_STANDARD_IS_HIDDEN: builtins.str
FILE_ATTRIBUTE_STANDARD_IS_SYMLINK: builtins.str
FILE_ATTRIBUTE_STANDARD_IS_VIRTUAL: builtins.str
FILE_ATTRIBUTE_STANDARD_IS_VOLATILE: builtins.str
FILE_ATTRIBUTE_STANDARD_NAME: builtins.str
FILE_ATTRIBUTE_STANDARD_SIZE: builtins.str
FILE_ATTRIBUTE_STANDARD_SORT_ORDER: builtins.str
FILE_ATTRIBUTE_STANDARD_SYMBOLIC_ICON: builtins.str
FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET: builtins.str
FILE_ATTRIBUTE_STANDARD_TARGET_URI: builtins.str
FILE_ATTRIBUTE_STANDARD_TYPE: builtins.str
FILE_ATTRIBUTE_THUMBNAILING_FAILED: builtins.str
FILE_ATTRIBUTE_THUMBNAIL_IS_VALID: builtins.str
FILE_ATTRIBUTE_THUMBNAIL_PATH: builtins.str
FILE_ATTRIBUTE_TIME_ACCESS: builtins.str
FILE_ATTRIBUTE_TIME_ACCESS_USEC: builtins.str
FILE_ATTRIBUTE_TIME_CHANGED: builtins.str
FILE_ATTRIBUTE_TIME_CHANGED_USEC: builtins.str
FILE_ATTRIBUTE_TIME_CREATED: builtins.str
FILE_ATTRIBUTE_TIME_CREATED_USEC: builtins.str
FILE_ATTRIBUTE_TIME_MODIFIED: builtins.str
FILE_ATTRIBUTE_TIME_MODIFIED_USEC: builtins.str
FILE_ATTRIBUTE_TRASH_DELETION_DATE: builtins.str
FILE_ATTRIBUTE_TRASH_ITEM_COUNT: builtins.str
FILE_ATTRIBUTE_TRASH_ORIG_PATH: builtins.str
FILE_ATTRIBUTE_UNIX_BLOCKS: builtins.str
FILE_ATTRIBUTE_UNIX_BLOCK_SIZE: builtins.str
FILE_ATTRIBUTE_UNIX_DEVICE: builtins.str
FILE_ATTRIBUTE_UNIX_GID: builtins.str
FILE_ATTRIBUTE_UNIX_INODE: builtins.str
FILE_ATTRIBUTE_UNIX_IS_MOUNTPOINT: builtins.str
FILE_ATTRIBUTE_UNIX_MODE: builtins.str
FILE_ATTRIBUTE_UNIX_NLINK: builtins.str
FILE_ATTRIBUTE_UNIX_RDEV: builtins.str
FILE_ATTRIBUTE_UNIX_UID: builtins.str
MEMORY_MONITOR_EXTENSION_POINT_NAME: builtins.str
MENU_ATTRIBUTE_ACTION: builtins.str
MENU_ATTRIBUTE_ACTION_NAMESPACE: builtins.str
MENU_ATTRIBUTE_ICON: builtins.str
MENU_ATTRIBUTE_LABEL: builtins.str
MENU_ATTRIBUTE_TARGET: builtins.str
MENU_LINK_SECTION: builtins.str
MENU_LINK_SUBMENU: builtins.str
NATIVE_VOLUME_MONITOR_EXTENSION_POINT_NAME: builtins.str
NETWORK_MONITOR_EXTENSION_POINT_NAME: builtins.str
PROXY_EXTENSION_POINT_NAME: builtins.str
PROXY_RESOLVER_EXTENSION_POINT_NAME: builtins.str
SETTINGS_BACKEND_EXTENSION_POINT_NAME: builtins.str
TLS_BACKEND_EXTENSION_POINT_NAME: builtins.str
TLS_DATABASE_PURPOSE_AUTHENTICATE_CLIENT: builtins.str
TLS_DATABASE_PURPOSE_AUTHENTICATE_SERVER: builtins.str
VFS_EXTENSION_POINT_NAME: builtins.str
VOLUME_IDENTIFIER_KIND_CLASS: builtins.str
VOLUME_IDENTIFIER_KIND_HAL_UDI: builtins.str
VOLUME_IDENTIFIER_KIND_LABEL: builtins.str
VOLUME_IDENTIFIER_KIND_NFS_MOUNT: builtins.str
VOLUME_IDENTIFIER_KIND_UNIX_DEVICE: builtins.str
VOLUME_IDENTIFIER_KIND_UUID: builtins.str
VOLUME_MONITOR_EXTENSION_POINT_NAME: builtins.str
