
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsecontainer.proc"
// Licensed GNU LGPL v2.1 or later: http://www.gnu.org/licenses/lgpl.html
#include <bse/bseplugin.hh>
#include <bse/bseprocedure.hh>
#include <bse/bsecontainer.hh>
#include "bsecxxplugin.hh"
/* --- list-children --- */
static void
list_children_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 8 "bsecontainer.proc"
 {
#line 10 "bsecontainer.proc"
  *(in_pspecs++) = bse_param_spec_object ("container", NULL, NULL, BSE_TYPE_CONTAINER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = bse_param_spec_boxed ("item_list", NULL, NULL, BSE_TYPE_ITEM_SEQ, SFI_PARAM_STANDARD);
#line 12 "bsecontainer.proc"
}  }
static BseErrorType
#line 12 "bsecontainer.proc"
list_children_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 15 "bsecontainer.proc"
{
#line 16 "bsecontainer.proc"
  
  BseContainer *container = (BseContainer*) bse_value_get_object (in_values++);
#line 18 "bsecontainer.proc"
  
  if (!BSE_IS_CONTAINER (container))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 21 "bsecontainer.proc"
  
  bse_value_take_boxed (out_values++, bse_container_list_children (container));
  return BSE_ERROR_NONE;
}
/* --- lookup-item --- */
static void
lookup_item_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 25 "bsecontainer.proc"
 {
#line 28 "bsecontainer.proc"
  *(in_pspecs++) = bse_param_spec_object ("container", "Container", "The Container", BSE_TYPE_CONTAINER, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("uname", "UName", "Unique item name", NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("item", "Item", "The item named by uname", BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
#line 31 "bsecontainer.proc"
}  }
static BseErrorType
#line 31 "bsecontainer.proc"
lookup_item_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 34 "bsecontainer.proc"
{
#line 35 "bsecontainer.proc"
  
  BseContainer *container = (BseContainer*) bse_value_get_object (in_values++);
  const char *uname       = sfi_value_get_string (in_values++);
#line 38 "bsecontainer.proc"
  
  if (!BSE_IS_CONTAINER (container) || !uname)
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 41 "bsecontainer.proc"
  
  bse_value_set_object (out_values++, bse_container_lookup_item (container, uname));
  return BSE_ERROR_NONE;
}
/* --- get-item --- */
static void
get_item_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 45 "bsecontainer.proc"
 {
#line 47 "bsecontainer.proc"
  *(in_pspecs++) = bse_param_spec_object ("container", NULL, NULL, BSE_TYPE_CONTAINER, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("item_type", NULL, "Type of the item to retrieve",
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("seq_id", NULL, "Sequential ID",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("item", NULL, "The item with seqid as requested", BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
#line 53 "bsecontainer.proc"
}  }
static BseErrorType
#line 53 "bsecontainer.proc"
get_item_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 56 "bsecontainer.proc"
{
#line 57 "bsecontainer.proc"
  
  BseContainer *container = (BseContainer*) bse_value_get_object (in_values++);
  const char *type_name   = sfi_value_get_string (in_values++);
  guint seqid             = sfi_value_get_int (in_values++);
  GType type = type_name ? g_type_from_name (type_name) : 0;
#line 62 "bsecontainer.proc"
  
  if (!BSE_IS_CONTAINER (container) || !g_type_is_a (type, BSE_TYPE_ITEM))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 65 "bsecontainer.proc"
  
  bse_value_set_object (out_values++, bse_container_get_item (container, type, seqid));
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_list_children__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Retrieve all immediate children of a container");
  es->file = "/opt/src/beast/bse/bsecontainer.proc";
  es->line = 9;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_list_children = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseContainer+list-children", 
    NULL,
    "/Methods/BseContainer/General/List Children",
    NULL,
    __enode_list_children__fill_strings,
  },
  0, list_children_setup, list_children_exec, 
};
static void
__enode_lookup_item__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Find an immediate child of a container from its uname (the uname "
	   "is the name of the item, unique between all immediate children of a container).");
  es->file = "/opt/src/beast/bse/bsecontainer.proc";
  es->line = 26;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_lookup_item = {
  { (BseExportNode*) &__enode_list_children, BSE_EXPORT_NODE_PROC,
    "BseContainer+lookup-item", 
    NULL,
    "/Methods/BseContainer/General/Lookup Item",
    NULL,
    __enode_lookup_item__fill_strings,
  },
  0, lookup_item_setup, lookup_item_exec, 
};
static void
__enode_get_item__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a containers immediate child from it's sequential id.";
  es->file = "/opt/src/beast/bse/bsecontainer.proc";
  es->line = 46;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_item = {
  { (BseExportNode*) &__enode_lookup_item, BSE_EXPORT_NODE_PROC,
    "BseContainer+get-item", 
    NULL,
    "/Methods/BseContainer/General/Get Item",
    NULL,
    __enode_get_item__fill_strings,
  },
  0, get_item_setup, get_item_exec, 
};
extern "C" BseExportNode* bse__builtin_init_bsecontainer_genprc_cc (void)
{
  return (BseExportNode*) &__enode_get_item;
}

/*
 * Generated data ends here
 */
