/*
 * (C) Copyright 2013 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation
 * nor does it submit to any jurisdiction.
 */

// TL3999

#include "atlas/grid/detail/spacing/gaussian/N.h"

namespace atlas {
namespace grid {
namespace spacing {
namespace gaussian {

DEFINE_GAUSSIAN_LATITUDES(
    2000,
    LIST(89.965557716640, 89.920940588056, 89.876059971209, 89.831119821127, 89.786157088682, 89.741183428577,
         89.696203661469, 89.651220138535, 89.606234142158, 89.561246430917, 89.516257482116, 89.471267611042,
         89.426277034302, 89.381285905620, 89.336294337107, 89.291302412440, 89.246310195345, 89.201317735199,
         89.156325070860, 89.111332233323, 89.066339247611, 89.021346134150, 88.976352909776, 88.931359588494,
         88.886366182044, 88.841372700344, 88.796379151831, 88.751385543725, 88.706391882242, 88.661398172763,
         88.616404419970, 88.571410627953, 88.526416800305, 88.481422940193, 88.436429050418, 88.391435133469,
         88.346441191564, 88.301447226685, 88.256453240612, 88.211459234943, 88.166465211121, 88.121471170450,
         88.076477114112, 88.031483043182, 87.986488958637, 87.941494861370, 87.896500752197, 87.851506631867,
         87.806512501066, 87.761518360424, 87.716524210525, 87.671530051904, 87.626535885058, 87.581541710445,
         87.536547528491, 87.491553339591, 87.446559144112, 87.401564942396, 87.356570734762, 87.311576521506,
         87.266582302906, 87.221588079222, 87.176593850696, 87.131599617557, 87.086605380019, 87.041611138281,
         86.996616892534, 86.951622642953, 86.906628389707, 86.861634132954, 86.816639872841, 86.771645609509,
         86.726651343092, 86.681657073714, 86.636662801495, 86.591668526547, 86.546674248976, 86.501679968884,
         86.456685686367, 86.411691401516, 86.366697114417, 86.321702825154, 86.276708533805, 86.231714240444,
         86.186719945143, 86.141725647969, 86.096731348988, 86.051737048260, 86.006742745846, 85.961748441801,
         85.916754136180, 85.871759829034, 85.826765520411, 85.781771210361, 85.736776898926, 85.691782586152,
         85.646788272080, 85.601793956749, 85.556799640198, 85.511805322463, 85.466811003580, 85.421816683582,
         85.376822362502, 85.331828040372, 85.286833717221, 85.241839393078, 85.196845067971, 85.151850741928,
         85.106856414973, 85.061862087133, 85.016867758430, 84.971873428888, 84.926879098529, 84.881884767375,
         84.836890435447, 84.791896102764, 84.746901769347, 84.701907435213, 84.656913100381, 84.611918764868,
         84.566924428692, 84.521930091868, 84.476935754413, 84.431941416342, 84.386947077669, 84.341952738409,
         84.296958398576, 84.251964058183, 84.206969717244, 84.161975375770, 84.116981033775, 84.071986691270,
         84.026992348266, 83.981998004775, 83.937003660808, 83.892009316375, 83.847014971487, 83.802020626152,
         83.757026280382, 83.712031934185, 83.667037587570, 83.622043240547, 83.577048893124, 83.532054545308,
         83.487060197109, 83.442065848534, 83.397071499592, 83.352077150288, 83.307082800631, 83.262088450628,
         83.217094100285, 83.172099749610, 83.127105398609, 83.082111047287, 83.037116695653, 82.992122343710,
         82.947127991466, 82.902133638926, 82.857139286096, 82.812144932981, 82.767150579586, 82.722156225917,
         82.677161871979, 82.632167517776, 82.587173163314, 82.542178808596, 82.497184453629, 82.452190098415,
         82.407195742961, 82.362201387269, 82.317207031344, 82.272212675190, 82.227218318811, 82.182223962211,
         82.137229605394, 82.092235248363, 82.047240891122, 82.002246533675, 81.957252176025, 81.912257818176,
         81.867263460130, 81.822269101891, 81.777274743462, 81.732280384847, 81.687286026048, 81.642291667068,
         81.597297307910, 81.552302948577, 81.507308589073, 81.462314229398, 81.417319869557, 81.372325509552,
         81.327331149384, 81.282336789058, 81.237342428575, 81.192348067938, 81.147353707149, 81.102359346210,
         81.057364985124, 81.012370623893, 80.967376262518, 80.922381901003, 80.877387539349, 80.832393177558,
         80.787398815633, 80.742404453575, 80.697410091386, 80.652415729068, 80.607421366622, 80.562427004052,
         80.517432641358, 80.472438278542, 80.427443915607, 80.382449552553, 80.337455189382, 80.292460826096,
         80.247466462697, 80.202472099185, 80.157477735564, 80.112483371833, 80.067489007995, 80.022494644051,
         79.977500280003, 79.932505915852, 79.887511551598, 79.842517187245, 79.797522822792, 79.752528458242,
         79.707534093595, 79.662539728853, 79.617545364016, 79.572550999088, 79.527556634067, 79.482562268956,
         79.437567903756, 79.392573538468, 79.347579173093, 79.302584807632, 79.257590442086, 79.212596076457,
         79.167601710745, 79.122607344951, 79.077612979076, 79.032618613122, 78.987624247089, 78.942629880979,
         78.897635514791, 78.852641148528, 78.807646782190, 78.762652415777, 78.717658049292, 78.672663682734,
         78.627669316105, 78.582674949405, 78.537680582636, 78.492686215798, 78.447691848891, 78.402697481917,
         78.357703114877, 78.312708747771, 78.267714380599, 78.222720013364, 78.177725646065, 78.132731278703,
         78.087736911279, 78.042742543794, 77.997748176248, 77.952753808642, 77.907759440976, 77.862765073252,
         77.817770705470, 77.772776337630, 77.727781969733, 77.682787601781, 77.637793233773, 77.592798865709,
         77.547804497592, 77.502810129421, 77.457815761196, 77.412821392919, 77.367827024590, 77.322832656210,
         77.277838287778, 77.232843919296, 77.187849550764, 77.142855182183, 77.097860813553, 77.052866444875,
         77.007872076149, 76.962877707375, 76.917883338555, 76.872888969688, 76.827894600776, 76.782900231818,
         76.737905862815, 76.692911493767, 76.647917124676, 76.602922755540, 76.557928386362, 76.512934017141,
         76.467939647878, 76.422945278573, 76.377950909226, 76.332956539838, 76.287962170410, 76.242967800941,
         76.197973431433, 76.152979061885, 76.107984692297, 76.062990322672, 76.017995953007, 75.973001583305,
         75.928007213566, 75.883012843789, 75.838018473975, 75.793024104124, 75.748029734238, 75.703035364315,
         75.658040994357, 75.613046624364, 75.568052254336, 75.523057884273, 75.478063514177, 75.433069144046,
         75.388074773882, 75.343080403684, 75.298086033454, 75.253091663191, 75.208097292895, 75.163102922567,
         75.118108552208, 75.073114181817, 75.028119811395, 74.983125440942, 74.938131070459, 74.893136699945,
         74.848142329401, 74.803147958827, 74.758153588223, 74.713159217590, 74.668164846929, 74.623170476238,
         74.578176105519, 74.533181734771, 74.488187363996, 74.443192993192, 74.398198622361, 74.353204251503,
         74.308209880618, 74.263215509706, 74.218221138767, 74.173226767802, 74.128232396810, 74.083238025793,
         74.038243654750, 73.993249283681, 73.948254912587, 73.903260541468, 73.858266170324, 73.813271799156,
         73.768277427963, 73.723283056746, 73.678288685504, 73.633294314239, 73.588299942950, 73.543305571638,
         73.498311200302, 73.453316828943, 73.408322457562, 73.363328086157, 73.318333714730, 73.273339343281,
         73.228344971810, 73.183350600316, 73.138356228801, 73.093361857264, 73.048367485706, 73.003373114126,
         72.958378742525, 72.913384370904, 72.868389999261, 72.823395627598, 72.778401255914, 72.733406884210,
         72.688412512486, 72.643418140742, 72.598423768978, 72.553429397194, 72.508435025391, 72.463440653568,
         72.418446281727, 72.373451909866, 72.328457537986, 72.283463166087, 72.238468794170, 72.193474422234,
         72.148480050280, 72.103485678307, 72.058491306317, 72.013496934308, 71.968502562282, 71.923508190238,
         71.878513818176, 71.833519446097, 71.788525074001, 71.743530701887, 71.698536329757, 71.653541957609,
         71.608547585445, 71.563553213264, 71.518558841066, 71.473564468852, 71.428570096622, 71.383575724376,
         71.338581352113, 71.293586979834, 71.248592607540, 71.203598235230, 71.158603862904, 71.113609490563,
         71.068615118206, 71.023620745834, 70.978626373447, 70.933632001045, 70.888637628628, 70.843643256196,
         70.798648883749, 70.753654511288, 70.708660138812, 70.663665766321, 70.618671393817, 70.573677021298,
         70.528682648765, 70.483688276217, 70.438693903656, 70.393699531081, 70.348705158492, 70.303710785890,
         70.258716413274, 70.213722040644, 70.168727668002, 70.123733295345, 70.078738922676, 70.033744549993,
         69.988750177298, 69.943755804589, 69.898761431868, 69.853767059134, 69.808772686387, 69.763778313628,
         69.718783940856, 69.673789568072, 69.628795195275, 69.583800822466, 69.538806449645, 69.493812076812,
         69.448817703966, 69.403823331109, 69.358828958240, 69.313834585359, 69.268840212466, 69.223845839562,
         69.178851466646, 69.133857093719, 69.088862720780, 69.043868347830, 68.998873974869, 68.953879601897,
         68.908885228913, 68.863890855918, 68.818896482913, 68.773902109896, 68.728907736869, 68.683913363831,
         68.638918990782, 68.593924617722, 68.548930244652, 68.503935871572, 68.458941498480, 68.413947125379,
         68.368952752267, 68.323958379145, 68.278964006013, 68.233969632871, 68.188975259719, 68.143980886557,
         68.098986513384, 68.053992140202, 68.008997767010, 67.964003393809, 67.919009020597, 67.874014647376,
         67.829020274146, 67.784025900906, 67.739031527656, 67.694037154397, 67.649042781129, 67.604048407852,
         67.559054034565, 67.514059661269, 67.469065287964, 67.424070914650, 67.379076541327, 67.334082167995,
         67.289087794654, 67.244093421304, 67.199099047946, 67.154104674578, 67.109110301202, 67.064115927817,
         67.019121554424, 66.974127181022, 66.929132807612, 66.884138434193, 66.839144060766, 66.794149687331,
         66.749155313887, 66.704160940435, 66.659166566975, 66.614172193507, 66.569177820030, 66.524183446546,
         66.479189073053, 66.434194699553, 66.389200326044, 66.344205952528, 66.299211579004, 66.254217205472,
         66.209222831933, 66.164228458385, 66.119234084830, 66.074239711268, 66.029245337698, 65.984250964120,
         65.939256590535, 65.894262216943, 65.849267843343, 65.804273469735, 65.759279096121, 65.714284722499,
         65.669290348870, 65.624295975233, 65.579301601590, 65.534307227939, 65.489312854282, 65.444318480617,
         65.399324106945, 65.354329733267, 65.309335359581, 65.264340985889, 65.219346612190, 65.174352238484,
         65.129357864771, 65.084363491051, 65.039369117325, 64.994374743592, 64.949380369852, 64.904385996106,
         64.859391622354, 64.814397248594, 64.769402874829, 64.724408501057, 64.679414127278, 64.634419753493,
         64.589425379702, 64.544431005904, 64.499436632100, 64.454442258290, 64.409447884474, 64.364453510652,
         64.319459136823, 64.274464762988, 64.229470389147, 64.184476015301, 64.139481641448, 64.094487267589,
         64.049492893724, 64.004498519853, 63.959504145977, 63.914509772094, 63.869515398206, 63.824521024312,
         63.779526650412, 63.734532276506, 63.689537902595, 63.644543528678, 63.599549154755, 63.554554780827,
         63.509560406893, 63.464566032953, 63.419571659008, 63.374577285058, 63.329582911102, 63.284588537140,
         63.239594163174, 63.194599789201, 63.149605415224, 63.104611041241, 63.059616667252, 63.014622293259,
         62.969627919260, 62.924633545256, 62.879639171246, 62.834644797232, 62.789650423212, 62.744656049187,
         62.699661675157, 62.654667301123, 62.609672927082, 62.564678553037, 62.519684178987, 62.474689804932,
         62.429695430872, 62.384701056807, 62.339706682737, 62.294712308663, 62.249717934583, 62.204723560498,
         62.159729186409, 62.114734812315, 62.069740438216, 62.024746064113, 61.979751690004, 61.934757315891,
         61.889762941774, 61.844768567651, 61.799774193524, 61.754779819393, 61.709785445257, 61.664791071116,
         61.619796696970, 61.574802322821, 61.529807948666, 61.484813574508, 61.439819200344, 61.394824826177,
         61.349830452005, 61.304836077828, 61.259841703647, 61.214847329462, 61.169852955272, 61.124858581079,
         61.079864206880, 61.034869832678, 60.989875458471, 60.944881084260, 60.899886710045, 60.854892335826,
         60.809897961603, 60.764903587375, 60.719909213143, 60.674914838907, 60.629920464667, 60.584926090423,
         60.539931716175, 60.494937341923, 60.449942967667, 60.404948593406, 60.359954219142, 60.314959844874,
         60.269965470602, 60.224971096326, 60.179976722046, 60.134982347762, 60.089987973475, 60.044993599183,
         59.999999224888, 59.955004850588, 59.910010476285, 59.865016101979, 59.820021727668, 59.775027353354,
         59.730032979036, 59.685038604714, 59.640044230388, 59.595049856059, 59.550055481726, 59.505061107390,
         59.460066733049, 59.415072358706, 59.370077984358, 59.325083610007, 59.280089235653, 59.235094861295,
         59.190100486933, 59.145106112568, 59.100111738199, 59.055117363827, 59.010122989451, 58.965128615072,
         58.920134240689, 58.875139866303, 58.830145491914, 58.785151117521, 58.740156743125, 58.695162368725,
         58.650167994322, 58.605173619916, 58.560179245506, 58.515184871093, 58.470190496677, 58.425196122257,
         58.380201747834, 58.335207373408, 58.290212998979, 58.245218624546, 58.200224250110, 58.155229875671,
         58.110235501229, 58.065241126784, 58.020246752335, 57.975252377883, 57.930258003428, 57.885263628970,
         57.840269254509, 57.795274880045, 57.750280505578, 57.705286131108, 57.660291756634, 57.615297382158,
         57.570303007678, 57.525308633196, 57.480314258710, 57.435319884222, 57.390325509730, 57.345331135236,
         57.300336760738, 57.255342386238, 57.210348011735, 57.165353637228, 57.120359262719, 57.075364888207,
         57.030370513692, 56.985376139174, 56.940381764654, 56.895387390130, 56.850393015604, 56.805398641075,
         56.760404266543, 56.715409892008, 56.670415517470, 56.625421142930, 56.580426768387, 56.535432393841,
         56.490438019292, 56.445443644741, 56.400449270187, 56.355454895630, 56.310460521071, 56.265466146508,
         56.220471771943, 56.175477397376, 56.130483022806, 56.085488648233, 56.040494273657, 55.995499899079,
         55.950505524499, 55.905511149915, 55.860516775329, 55.815522400741, 55.770528026150, 55.725533651556,
         55.680539276960, 55.635544902361, 55.590550527760, 55.545556153156, 55.500561778550, 55.455567403941,
         55.410573029329, 55.365578654716, 55.320584280099, 55.275589905481, 55.230595530859, 55.185601156236,
         55.140606781610, 55.095612406981, 55.050618032350, 55.005623657717, 54.960629283081, 54.915634908443,
         54.870640533803, 54.825646159160, 54.780651784515, 54.735657409867, 54.690663035217, 54.645668660565,
         54.600674285910, 54.555679911253, 54.510685536594, 54.465691161933, 54.420696787269, 54.375702412603,
         54.330708037935, 54.285713663264, 54.240719288591, 54.195724913916, 54.150730539239, 54.105736164559,
         54.060741789877, 54.015747415193, 53.970753040507, 53.925758665819, 53.880764291128, 53.835769916436,
         53.790775541741, 53.745781167044, 53.700786792344, 53.655792417643, 53.610798042940, 53.565803668234,
         53.520809293526, 53.475814918816, 53.430820544104, 53.385826169390, 53.340831794674, 53.295837419956,
         53.250843045236, 53.205848670513, 53.160854295789, 53.115859921062, 53.070865546334, 53.025871171603,
         52.980876796871, 52.935882422136, 52.890888047400, 52.845893672661, 52.800899297920, 52.755904923178,
         52.710910548433, 52.665916173687, 52.620921798938, 52.575927424188, 52.530933049435, 52.485938674681,
         52.440944299925, 52.395949925166, 52.350955550406, 52.305961175644, 52.260966800880, 52.215972426114,
         52.170978051346, 52.125983676577, 52.080989301805, 52.035994927032, 51.991000552256, 51.946006177479,
         51.901011802700, 51.856017427919, 51.811023053137, 51.766028678352, 51.721034303566, 51.676039928777,
         51.631045553987, 51.586051179196, 51.541056804402, 51.496062429606, 51.451068054809, 51.406073680010,
         51.361079305209, 51.316084930407, 51.271090555603, 51.226096180796, 51.181101805989, 51.136107431179,
         51.091113056368, 51.046118681555, 51.001124306740, 50.956129931923, 50.911135557105, 50.866141182285,
         50.821146807464, 50.776152432640, 50.731158057815, 50.686163682989, 50.641169308160, 50.596174933330,
         50.551180558498, 50.506186183665, 50.461191808830, 50.416197433993, 50.371203059155, 50.326208684315,
         50.281214309473, 50.236219934630, 50.191225559785, 50.146231184939, 50.101236810091, 50.056242435241,
         50.011248060390, 49.966253685537, 49.921259310682, 49.876264935826, 49.831270560969, 49.786276186110,
         49.741281811249, 49.696287436387, 49.651293061523, 49.606298686657, 49.561304311790, 49.516309936922,
         49.471315562052, 49.426321187180, 49.381326812307, 49.336332437432, 49.291338062556, 49.246343687679,
         49.201349312800, 49.156354937919, 49.111360563037, 49.066366188153, 49.021371813268, 48.976377438381,
         48.931383063493, 48.886388688604, 48.841394313713, 48.796399938820, 48.751405563927, 48.706411189031,
         48.661416814134, 48.616422439236, 48.571428064337, 48.526433689435, 48.481439314533, 48.436444939629,
         48.391450564724, 48.346456189817, 48.301461814909, 48.256467439999, 48.211473065088, 48.166478690176,
         48.121484315262, 48.076489940347, 48.031495565431, 47.986501190513, 47.941506815594, 47.896512440673,
         47.851518065751, 47.806523690828, 47.761529315903, 47.716534940977, 47.671540566050, 47.626546191121,
         47.581551816191, 47.536557441260, 47.491563066327, 47.446568691393, 47.401574316458, 47.356579941521,
         47.311585566583, 47.266591191644, 47.221596816704, 47.176602441762, 47.131608066819, 47.086613691874,
         47.041619316929, 46.996624941982, 46.951630567034, 46.906636192084, 46.861641817133, 46.816647442181,
         46.771653067228, 46.726658692274, 46.681664317318, 46.636669942361, 46.591675567403, 46.546681192443,
         46.501686817482, 46.456692442521, 46.411698067557, 46.366703692593, 46.321709317627, 46.276714942661,
         46.231720567693, 46.186726192723, 46.141731817753, 46.096737442781, 46.051743067809, 46.006748692835,
         45.961754317859, 45.916759942883, 45.871765567906, 45.826771192927, 45.781776817947, 45.736782442966,
         45.691788067984, 45.646793693000, 45.601799318016, 45.556804943030, 45.511810568043, 45.466816193055,
         45.421821818066, 45.376827443076, 45.331833068085, 45.286838693092, 45.241844318099, 45.196849943104,
         45.151855568108, 45.106861193111, 45.061866818113, 45.016872443114, 44.971878068113, 44.926883693112,
         44.881889318109, 44.836894943106, 44.791900568101, 44.746906193095, 44.701911818088, 44.656917443080,
         44.611923068071, 44.566928693061, 44.521934318050, 44.476939943038, 44.431945568025, 44.386951193010,
         44.341956817995, 44.296962442978, 44.251968067961, 44.206973692942, 44.161979317923, 44.116984942902,
         44.071990567880, 44.026996192857, 43.982001817834, 43.937007442809, 43.892013067783, 43.847018692756,
         43.802024317728, 43.757029942699, 43.712035567670, 43.667041192639, 43.622046817607, 43.577052442574,
         43.532058067540, 43.487063692505, 43.442069317469, 43.397074942432, 43.352080567394, 43.307086192355,
         43.262091817315, 43.217097442275, 43.172103067233, 43.127108692190, 43.082114317146, 43.037119942102,
         42.992125567056, 42.947131192009, 42.902136816962, 42.857142441913, 42.812148066863, 42.767153691813,
         42.722159316762, 42.677164941709, 42.632170566656, 42.587176191602, 42.542181816546, 42.497187441490,
         42.452193066433, 42.407198691375, 42.362204316316, 42.317209941257, 42.272215566196, 42.227221191134,
         42.182226816072, 42.137232441008, 42.092238065944, 42.047243690878, 42.002249315812, 41.957254940745,
         41.912260565677, 41.867266190608, 41.822271815539, 41.777277440468, 41.732283065396, 41.687288690324,
         41.642294315251, 41.597299940176, 41.552305565101, 41.507311190025, 41.462316814949, 41.417322439871,
         41.372328064792, 41.327333689713, 41.282339314633, 41.237344939551, 41.192350564469, 41.147356189387,
         41.102361814303, 41.057367439218, 41.012373064133, 40.967378689047, 40.922384313960, 40.877389938872,
         40.832395563783, 40.787401188693, 40.742406813603, 40.697412438512, 40.652418063420, 40.607423688327,
         40.562429313233, 40.517434938139, 40.472440563043, 40.427446187947, 40.382451812850, 40.337457437752,
         40.292463062654, 40.247468687554, 40.202474312454, 40.157479937353, 40.112485562251, 40.067491187149,
         40.022496812045, 39.977502436941, 39.932508061836, 39.887513686731, 39.842519311624, 39.797524936517,
         39.752530561409, 39.707536186300, 39.662541811190, 39.617547436080, 39.572553060968, 39.527558685857,
         39.482564310744, 39.437569935630, 39.392575560516, 39.347581185401, 39.302586810285, 39.257592435169,
         39.212598060052, 39.167603684934, 39.122609309815, 39.077614934695, 39.032620559575, 38.987626184454,
         38.942631809332, 38.897637434210, 38.852643059087, 38.807648683963, 38.762654308838, 38.717659933713,
         38.672665558587, 38.627671183460, 38.582676808332, 38.537682433204, 38.492688058075, 38.447693682945,
         38.402699307815, 38.357704932684, 38.312710557552, 38.267716182419, 38.222721807286, 38.177727432152,
         38.132733057017, 38.087738681882, 38.042744306746, 37.997749931609, 37.952755556471, 37.907761181333,
         37.862766806194, 37.817772431055, 37.772778055915, 37.727783680774, 37.682789305632, 37.637794930490,
         37.592800555347, 37.547806180203, 37.502811805059, 37.457817429914, 37.412823054768, 37.367828679622,
         37.322834304475, 37.277839929327, 37.232845554179, 37.187851179030, 37.142856803880, 37.097862428730,
         37.052868053579, 37.007873678428, 36.962879303275, 36.917884928122, 36.872890552969, 36.827896177815,
         36.782901802660, 36.737907427504, 36.692913052348, 36.647918677191, 36.602924302034, 36.557929926876,
         36.512935551717, 36.467941176558, 36.422946801398, 36.377952426237, 36.332958051076, 36.287963675914,
         36.242969300752, 36.197974925589, 36.152980550425, 36.107986175261, 36.062991800096, 36.017997424930,
         35.973003049764, 35.928008674597, 35.883014299430, 35.838019924262, 35.793025549093, 35.748031173924,
         35.703036798754, 35.658042423584, 35.613048048413, 35.568053673241, 35.523059298069, 35.478064922896,
         35.433070547723, 35.388076172549, 35.343081797374, 35.298087422199, 35.253093047024, 35.208098671847,
         35.163104296670, 35.118109921493, 35.073115546315, 35.028121171136, 34.983126795957, 34.938132420777,
         34.893138045597, 34.848143670416, 34.803149295234, 34.758154920052, 34.713160544869, 34.668166169686,
         34.623171794502, 34.578177419318, 34.533183044133, 34.488188668948, 34.443194293762, 34.398199918575,
         34.353205543388, 34.308211168200, 34.263216793012, 34.218222417823, 34.173228042634, 34.128233667444,
         34.083239292254, 34.038244917063, 33.993250541871, 33.948256166679, 33.903261791486, 33.858267416293,
         33.813273041099, 33.768278665905, 33.723284290711, 33.678289915515, 33.633295540319, 33.588301165123,
         33.543306789926, 33.498312414729, 33.453318039531, 33.408323664332, 33.363329289133, 33.318334913934,
         33.273340538734, 33.228346163533, 33.183351788332, 33.138357413131, 33.093363037929, 33.048368662726,
         33.003374287523, 32.958379912319, 32.913385537115, 32.868391161911, 32.823396786705, 32.778402411500,
         32.733408036294, 32.688413661087, 32.643419285880, 32.598424910672, 32.553430535464, 32.508436160255,
         32.463441785046, 32.418447409837, 32.373453034627, 32.328458659416, 32.283464284205, 32.238469908993,
         32.193475533781, 32.148481158569, 32.103486783356, 32.058492408142, 32.013498032928, 31.968503657714,
         31.923509282499, 31.878514907283, 31.833520532067, 31.788526156851, 31.743531781634, 31.698537406417,
         31.653543031199, 31.608548655981, 31.563554280762, 31.518559905543, 31.473565530323, 31.428571155103,
         31.383576779882, 31.338582404661, 31.293588029440, 31.248593654218, 31.203599278995, 31.158604903772,
         31.113610528549, 31.068616153325, 31.023621778101, 30.978627402876, 30.933633027651, 30.888638652425,
         30.843644277199, 30.798649901973, 30.753655526746, 30.708661151519, 30.663666776291, 30.618672401062,
         30.573678025834, 30.528683650604, 30.483689275375, 30.438694900145, 30.393700524914, 30.348706149683,
         30.303711774452, 30.258717399220, 30.213723023988, 30.168728648755, 30.123734273522, 30.078739898289,
         30.033745523055, 29.988751147821, 29.943756772586, 29.898762397351, 29.853768022115, 29.808773646879,
         29.763779271642, 29.718784896406, 29.673790521168, 29.628796145931, 29.583801770692, 29.538807395454,
         29.493813020215, 29.448818644975, 29.403824269736, 29.358829894496, 29.313835519255, 29.268841144014,
         29.223846768772, 29.178852393531, 29.133858018288, 29.088863643046, 29.043869267803, 28.998874892559,
         28.953880517315, 28.908886142071, 28.863891766827, 28.818897391582, 28.773903016336, 28.728908641090,
         28.683914265844, 28.638919890598, 28.593925515351, 28.548931140103, 28.503936764855, 28.458942389607,
         28.413948014359, 28.368953639110, 28.323959263860, 28.278964888611, 28.233970513361, 28.188976138110,
         28.143981762859, 28.098987387608, 28.053993012356, 28.008998637104, 27.964004261852, 27.919009886599,
         27.874015511346, 27.829021136093, 27.784026760839, 27.739032385585, 27.694038010330, 27.649043635075,
         27.604049259820, 27.559054884564, 27.514060509308, 27.469066134051, 27.424071758795, 27.379077383538,
         27.334083008280, 27.289088633022, 27.244094257764, 27.199099882505, 27.154105507246, 27.109111131987,
         27.064116756727, 27.019122381467, 26.974128006207, 26.929133630946, 26.884139255685, 26.839144880423,
         26.794150505162, 26.749156129900, 26.704161754637, 26.659167379374, 26.614173004111, 26.569178628847,
         26.524184253584, 26.479189878319, 26.434195503055, 26.389201127790, 26.344206752525, 26.299212377259,
         26.254218001993, 26.209223626727, 26.164229251460, 26.119234876193, 26.074240500926, 26.029246125658,
         25.984251750390, 25.939257375122, 25.894262999853, 25.849268624584, 25.804274249315, 25.759279874046,
         25.714285498776, 25.669291123505, 25.624296748235, 25.579302372964, 25.534307997693, 25.489313622421,
         25.444319247149, 25.399324871877, 25.354330496604, 25.309336121332, 25.264341746058, 25.219347370785,
         25.174352995511, 25.129358620237, 25.084364244962, 25.039369869688, 24.994375494413, 24.949381119137,
         24.904386743862, 24.859392368586, 24.814397993309, 24.769403618033, 24.724409242756, 24.679414867478,
         24.634420492201, 24.589426116923, 24.544431741645, 24.499437366366, 24.454442991088, 24.409448615808,
         24.364454240529, 24.319459865249, 24.274465489969, 24.229471114689, 24.184476739409, 24.139482364128,
         24.094487988847, 24.049493613565, 24.004499238283, 23.959504863001, 23.914510487719, 23.869516112436,
         23.824521737153, 23.779527361870, 23.734532986587, 23.689538611303, 23.644544236019, 23.599549860734,
         23.554555485450, 23.509561110165, 23.464566734879, 23.419572359594, 23.374577984308, 23.329583609022,
         23.284589233736, 23.239594858449, 23.194600483162, 23.149606107875, 23.104611732587, 23.059617357299,
         23.014622982011, 22.969628606723, 22.924634231434, 22.879639856146, 22.834645480856, 22.789651105567,
         22.744656730277, 22.699662354987, 22.654667979697, 22.609673604406, 22.564679229116, 22.519684853825,
         22.474690478533, 22.429696103242, 22.384701727950, 22.339707352658, 22.294712977365, 22.249718602073,
         22.204724226780, 22.159729851487, 22.114735476193, 22.069741100899, 22.024746725605, 21.979752350311,
         21.934757975017, 21.889763599722, 21.844769224427, 21.799774849132, 21.754780473836, 21.709786098540,
         21.664791723244, 21.619797347948, 21.574802972652, 21.529808597355, 21.484814222058, 21.439819846761,
         21.394825471463, 21.349831096165, 21.304836720867, 21.259842345569, 21.214847970270, 21.169853594972,
         21.124859219673, 21.079864844373, 21.034870469074, 20.989876093774, 20.944881718474, 20.899887343174,
         20.854892967873, 20.809898592573, 20.764904217272, 20.719909841970, 20.674915466669, 20.629921091367,
         20.584926716065, 20.539932340763, 20.494937965461, 20.449943590158, 20.404949214855, 20.359954839552,
         20.314960464249, 20.269966088945, 20.224971713642, 20.179977338338, 20.134982963033, 20.089988587729,
         20.044994212424, 19.999999837119, 19.955005461814, 19.910011086509, 19.865016711203, 19.820022335897,
         19.775027960591, 19.730033585285, 19.685039209978, 19.640044834672, 19.595050459365, 19.550056084057,
         19.505061708750, 19.460067333442, 19.415072958135, 19.370078582826, 19.325084207518, 19.280089832210,
         19.235095456901, 19.190101081592, 19.145106706283, 19.100112330974, 19.055117955664, 19.010123580354,
         18.965129205044, 18.920134829734, 18.875140454424, 18.830146079113, 18.785151703802, 18.740157328491,
         18.695162953180, 18.650168577868, 18.605174202557, 18.560179827245, 18.515185451933, 18.470191076620,
         18.425196701308, 18.380202325995, 18.335207950682, 18.290213575369, 18.245219200056, 18.200224824742,
         18.155230449429, 18.110236074115, 18.065241698801, 18.020247323486, 17.975252948172, 17.930258572857,
         17.885264197542, 17.840269822227, 17.795275446912, 17.750281071596, 17.705286696281, 17.660292320965,
         17.615297945649, 17.570303570332, 17.525309195016, 17.480314819699, 17.435320444382, 17.390326069065,
         17.345331693748, 17.300337318431, 17.255342943113, 17.210348567795, 17.165354192477, 17.120359817159,
         17.075365441841, 17.030371066522, 16.985376691203, 16.940382315885, 16.895387940565, 16.850393565246,
         16.805399189927, 16.760404814607, 16.715410439287, 16.670416063967, 16.625421688647, 16.580427313327,
         16.535432938006, 16.490438562685, 16.445444187365, 16.400449812043, 16.355455436722, 16.310461061401,
         16.265466686079, 16.220472310757, 16.175477935435, 16.130483560113, 16.085489184791, 16.040494809469,
         15.995500434146, 15.950506058823, 15.905511683500, 15.860517308177, 15.815522932854, 15.770528557530,
         15.725534182206, 15.680539806883, 15.635545431559, 15.590551056234, 15.545556680910, 15.500562305586,
         15.455567930261, 15.410573554936, 15.365579179611, 15.320584804286, 15.275590428961, 15.230596053635,
         15.185601678310, 15.140607302984, 15.095612927658, 15.050618552332, 15.005624177005, 14.960629801679,
         14.915635426352, 14.870641051026, 14.825646675699, 14.780652300372, 14.735657925045, 14.690663549717,
         14.645669174390, 14.600674799062, 14.555680423734, 14.510686048406, 14.465691673078, 14.420697297750,
         14.375702922421, 14.330708547093, 14.285714171764, 14.240719796435, 14.195725421106, 14.150731045777,
         14.105736670447, 14.060742295118, 14.015747919788, 13.970753544459, 13.925759169129, 13.880764793799,
         13.835770418468, 13.790776043138, 13.745781667807, 13.700787292477, 13.655792917146, 13.610798541815,
         13.565804166484, 13.520809791153, 13.475815415821, 13.430821040490, 13.385826665158, 13.340832289826,
         13.295837914495, 13.250843539163, 13.205849163830, 13.160854788498, 13.115860413166, 13.070866037833,
         13.025871662500, 12.980877287167, 12.935882911834, 12.890888536501, 12.845894161168, 12.800899785835,
         12.755905410501, 12.710911035167, 12.665916659834, 12.620922284500, 12.575927909166, 12.530933533831,
         12.485939158497, 12.440944783163, 12.395950407828, 12.350956032493, 12.305961657159, 12.260967281824,
         12.215972906489, 12.170978531153, 12.125984155818, 12.080989780483, 12.035995405147, 11.991001029811,
         11.946006654476, 11.901012279140, 11.856017903804, 11.811023528467, 11.766029153131, 11.721034777795,
         11.676040402458, 11.631046027121, 11.586051651785, 11.541057276448, 11.496062901111, 11.451068525774,
         11.406074150436, 11.361079775099, 11.316085399762, 11.271091024424, 11.226096649086, 11.181102273748,
         11.136107898411, 11.091113523072, 11.046119147734, 11.001124772396, 10.956130397058, 10.911136021719,
         10.866141646381, 10.821147271042, 10.776152895703, 10.731158520364, 10.686164145025, 10.641169769686,
         10.596175394347, 10.551181019007, 10.506186643668, 10.461192268328, 10.416197892989, 10.371203517649,
         10.326209142309, 10.281214766969, 10.236220391629, 10.191226016289, 10.146231640948, 10.101237265608,
         10.056242890267, 10.011248514927, 9.966254139586, 9.921259764245, 9.876265388904, 9.831271013563,
         9.786276638222, 9.741282262881, 9.696287887540, 9.651293512198, 9.606299136857, 9.561304761515, 9.516310386174,
         9.471316010832, 9.426321635490, 9.381327260148, 9.336332884806, 9.291338509464, 9.246344134122, 9.201349758779,
         9.156355383437, 9.111361008094, 9.066366632752, 9.021372257409, 8.976377882066, 8.931383506723, 8.886389131380,
         8.841394756037, 8.796400380694, 8.751406005351, 8.706411630008, 8.661417254664, 8.616422879321, 8.571428503977,
         8.526434128633, 8.481439753290, 8.436445377946, 8.391451002602, 8.346456627258, 8.301462251914, 8.256467876570,
         8.211473501225, 8.166479125881, 8.121484750537, 8.076490375192, 8.031495999848, 7.986501624503, 7.941507249158,
         7.896512873813, 7.851518498469, 7.806524123124, 7.761529747779, 7.716535372433, 7.671540997088, 7.626546621743,
         7.581552246398, 7.536557871052, 7.491563495707, 7.446569120361, 7.401574745016, 7.356580369670, 7.311585994324,
         7.266591618978, 7.221597243632, 7.176602868286, 7.131608492940, 7.086614117594, 7.041619742248, 6.996625366902,
         6.951630991555, 6.906636616209, 6.861642240862, 6.816647865516, 6.771653490169, 6.726659114822, 6.681664739476,
         6.636670364129, 6.591675988782, 6.546681613435, 6.501687238088, 6.456692862741, 6.411698487394, 6.366704112047,
         6.321709736699, 6.276715361352, 6.231720986005, 6.186726610657, 6.141732235310, 6.096737859962, 6.051743484615,
         6.006749109267, 5.961754733919, 5.916760358571, 5.871765983223, 5.826771607875, 5.781777232528, 5.736782857179,
         5.691788481831, 5.646794106483, 5.601799731135, 5.556805355787, 5.511810980438, 5.466816605090, 5.421822229742,
         5.376827854393, 5.331833479045, 5.286839103696, 5.241844728348, 5.196850352999, 5.151855977650, 5.106861602301,
         5.061867226953, 5.016872851604, 4.971878476255, 4.926884100906, 4.881889725557, 4.836895350208, 4.791900974859,
         4.746906599509, 4.701912224160, 4.656917848811, 4.611923473462, 4.566929098112, 4.521934722763, 4.476940347414,
         4.431945972064, 4.386951596715, 4.341957221365, 4.296962846015, 4.251968470666, 4.206974095316, 4.161979719966,
         4.116985344617, 4.071990969267, 4.026996593917, 3.982002218567, 3.937007843217, 3.892013467867, 3.847019092517,
         3.802024717167, 3.757030341817, 3.712035966467, 3.667041591117, 3.622047215767, 3.577052840416, 3.532058465066,
         3.487064089716, 3.442069714366, 3.397075339015, 3.352080963665, 3.307086588314, 3.262092212964, 3.217097837613,
         3.172103462263, 3.127109086912, 3.082114711562, 3.037120336211, 2.992125960861, 2.947131585510, 2.902137210159,
         2.857142834808, 2.812148459458, 2.767154084107, 2.722159708756, 2.677165333405, 2.632170958055, 2.587176582704,
         2.542182207353, 2.497187832002, 2.452193456651, 2.407199081300, 2.362204705949, 2.317210330598, 2.272215955247,
         2.227221579896, 2.182227204545, 2.137232829194, 2.092238453842, 2.047244078491, 2.002249703140, 1.957255327789,
         1.912260952438, 1.867266577087, 1.822272201735, 1.777277826384, 1.732283451033, 1.687289075681, 1.642294700330,
         1.597300324979, 1.552305949627, 1.507311574276, 1.462317198925, 1.417322823573, 1.372328448222, 1.327334072871,
         1.282339697519, 1.237345322168, 1.192350946816, 1.147356571465, 1.102362196113, 1.057367820762, 1.012373445410,
         0.967379070059, 0.922384694707, 0.877390319356, 0.832395944004, 0.787401568653, 0.742407193301, 0.697412817950,
         0.652418442598, 0.607424067247, 0.562429691895, 0.517435316543, 0.472440941192, 0.427446565840, 0.382452190489,
         0.337457815137, 0.292463439785, 0.247469064434, 0.202474689082, 0.157480313731, 0.112485938379, 0.067491563027,
         0.022497187676))

}  // namespace gaussian
}  // namespace spacing
}  // namespace grid
}  // namespace atlas
