option(ENABLE_DISCOVERY "Enable device discovery ( zeroconf)" ON)
if(ENABLE_DISCOVERY)
	find_package(DNSSD)
	find_library(AVAHI_COMMON_LIBRARIES avahi-common)
	find_library(AVAHI_CLIENT_LIBRARIES avahi-client)

	if (AVAHI_COMMON_LIBRARIES)
		add_library(libavahi ${PROJECT_SOURCE_DIR}/third_party/avahi-compat-libdns_sd/compat.c)
		target_link_libraries(libavahi PUBLIC ${AVAHI_CLIENT_LIBRARIES} ${AVAHI_COMMON_LIBRARIES})
		target_compile_definitions(libavahi PUBLIC -DDNSSD_AVAHI)
		set(HAS_AVAHI_SUPPORT ON)
	endif()
	if (DNSSD_FOUND)
		set(HAS_ZEROCONF_SUPPORT ON)
		add_library(zeroconf INTERFACE)
		target_include_directories(zeroconf INTERFACE ${DNSSD_INCLUDE_DIRS})
		target_compile_definitions(zeroconf INTERFACE -DZEROCONF_SUPPORT)
		target_link_libraries(zeroconf INTERFACE ${DNSSD_LIBRARIES} ${CMAKE_THREAD_LIBS_INIT})
		if (HAS_AVAHI_SUPPORT)
			target_link_libraries(zeroconf INTERFACE libavahi)
		endif()
		if (WIN32)
			target_link_libraries(zeroconf INTERFACE ws2_32)
		endif(WIN32)
	endif()
endif()

add_feature_info(DISCOVERY HAS_ZEROCONF_SUPPORT "Use AVAHI/DNSSD to discover compatible devices and their status")
