/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 14:08:50 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.awt.datatransfer.Clipboard;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.ExternalProgram;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.LogViewer;
import uk.ac.sanger.artemis.components.filetree.RemoteFileNode;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class ExternalProgram_ESTest extends ExternalProgram_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      String[] stringArray0 = new String[7];
      try { 
        ExternalProgram.startProgram("", stringArray0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Cannot start processes in a unit test
         //
         verifyException("org.evosuite.runtime.mock.java.lang.MockRuntime", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("getFeatureIdBySrcFeatureId", "getFeatureIdBySrcFeatureId", 1138);
      FeatureVector featureVector0 = new FeatureVector();
      LogViewer logViewer0 = new LogViewer();
      // Undeclared exception!
      try { 
        externalProgram0.run(featureVector0, logViewer0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unknown program type
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("#3*-R'&", "", 7);
      MockFile mockFile0 = new MockFile("", "T'^'5Q");
      externalProgram0.setFileNumber(mockFile0, 956L, (RemoteFileNode) null);
      assertEquals("#3*-R'&", externalProgram0.getName());
      assertEquals(7, externalProgram0.getType());
      assertEquals("", externalProgram0.getProgramOptions());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("0H8{`oDo/# duhn`Db", "0H8{`oDo/# duhn`Db", (-288));
      MockFile mockFile0 = new MockFile("0H8{`oDo/# duhn`Db");
      externalProgram0.setFileNumber(mockFile0, (-288), (RemoteFileNode) null);
      assertEquals((-288), externalProgram0.getType());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("$|SyUl`", "", 1);
      int int0 = externalProgram0.getType();
      assertEquals("$|SyUl`", externalProgram0.getName());
      assertEquals(1, int0);
      assertEquals("", externalProgram0.getProgramOptions());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram(".dribble.", (String) null, (-1902));
      int int0 = externalProgram0.getType();
      assertEquals((-1902), int0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram((String) null, (String) null, 0);
      externalProgram0.getName();
      assertEquals(0, externalProgram0.getType());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("26", "26", 0);
      externalProgram0.getName();
      assertEquals(0, externalProgram0.getType());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      String[] stringArray0 = new String[5];
      // Undeclared exception!
      try { 
        ExternalProgram.startProgram((String) null, stringArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram((String) null, (String) null, 0);
      MockFile mockFile0 = new MockFile("GBSeq_entry-version");
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      // Undeclared exception!
      try { 
        externalProgram0.setFileNumber(mockFile0, 0, remoteFileNode0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFile", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("0H8{`oDo/# duhn`Db", "0H8{`oDo/# duhn`Db", (-288));
      MockFile mockFile0 = new MockFile("0H8{`oDo/# duhn`Db", ")or");
      FileSystemHandling.shouldAllThrowIOExceptions();
      try { 
        externalProgram0.setFileNumber(mockFile0, (-288), (RemoteFileNode) null);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Simulated IOException
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("0H8{`oDo/# duhn`Db", "0H8{`oDo/# duhn`Db", (-288));
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/0H8{`oDo");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "P/K$.w]G-HE6=f7.e_^");
      MockFile mockFile0 = new MockFile("0H8{`oDo/# duhn`Db", ")or");
      try { 
        externalProgram0.setFileNumber(mockFile0, (-288), (RemoteFileNode) null);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileOutputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "", 1023);
      // Undeclared exception!
      try { 
        externalProgram0.makeDirectory((File) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", (String) null, 801);
      // Undeclared exception!
      try { 
        externalProgram0.getProgramOptions();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "", 4080);
      externalProgram0.getName();
      assertEquals(4080, externalProgram0.getType());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "", 0);
      int int0 = externalProgram0.getType();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("Gap", "-", 22);
      String string0 = externalProgram0.getProgramOptions();
      assertEquals("", string0);
      assertEquals(22, externalProgram0.getType());
      assertEquals("Gap", externalProgram0.getName());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "", 4080);
      externalProgram0.getProgramOptions();
      assertEquals(4080, externalProgram0.getType());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "", 4080);
      MockFile mockFile0 = new MockFile("^Jv!Nyj8OQE5G4");
      externalProgram0.makeDirectory(mockFile0);
      mockFile0.setWritable(false, false);
      try { 
        externalProgram0.makeDirectory(mockFile0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Cannot write to: java.lang.System.getProperty("user.dir") + /^Jv!Nyj8OQE5G4
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("first ", "first ", (-48));
      MockFile mockFile0 = new MockFile("first ");
      mockFile0.createNewFile();
      try { 
        externalProgram0.makeDirectory(mockFile0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // java.lang.System.getProperty("user.dir") + /first  is not a directory
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "", 4080);
      MockFile mockFile0 = new MockFile("");
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      // Undeclared exception!
      try { 
        externalProgram0.setFileNumber(mockFile0, 300L, remoteFileNode0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("<UW~<?F 2GuFlbp99", "", (-1628));
      MockFile mockFile0 = new MockFile("");
      externalProgram0.setFileNumber(mockFile0, 0L, (RemoteFileNode) null);
      assertEquals("<UW~<?F 2GuFlbp99", externalProgram0.getName());
      assertEquals("", externalProgram0.getProgramOptions());
      assertEquals((-1628), externalProgram0.getType());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      try { 
        ExternalProgram.startProgram("b", (String[]) null);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Cannot start processes in a unit test
         //
         verifyException("org.evosuite.runtime.mock.java.lang.MockRuntime", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      String[] stringArray0 = new String[2];
      try { 
        ExternalProgram.startProgram("p9y", stringArray0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Cannot start processes in a unit test
         //
         verifyException("org.evosuite.runtime.mock.java.lang.MockRuntime", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      try { 
        ExternalProgram.startProgram("", (String[]) null);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Cannot start processes in a unit test
         //
         verifyException("org.evosuite.runtime.mock.java.lang.MockRuntime", e);
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram((String) null, (String) null, 2);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      FeatureVector featureVector0 = entry0.checkFeatureStopCodons();
      LogViewer logViewer0 = new LogViewer();
      // Undeclared exception!
      try { 
        externalProgram0.run(featureVector0, logViewer0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("$|SyUl`", "", 1);
      Clipboard clipboard0 = new Clipboard("server.public");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getAllFeatures();
      LogViewer logViewer0 = new LogViewer();
      // Undeclared exception!
      try { 
        externalProgram0.run(featureVector0, logViewer0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      FeatureVector featureVector0 = entry0.getAllFeatures();
      LogViewer logViewer0 = new LogViewer();
      ExternalProgram externalProgram0 = new ExternalProgram("", (String) null, 0);
      // Undeclared exception!
      try { 
        externalProgram0.run(featureVector0, logViewer0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.ExternalProgram", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      ExternalProgram externalProgram0 = new ExternalProgram("", "", 4080);
      externalProgram0.setProgramOptions("oR}6Hp,g0");
      externalProgram0.getProgramOptions();
      assertEquals("oR}6Hp,g0", externalProgram0.getProgramOptions());
  }
}
