Indonesian and Malaysian: `apertium-ind-zlm`
===============================================================================

This is an Apertium language pair for translating between Indonesian and
Malaysian. What you can use this language package for:

* Translating between Indonesian and Malaysian
* Morphological analysis of Indonesian and Malaysian
* Part-of-speech tagging of Indonesian and Malaysian

For information on the latter two points, see subheading "For more
information" below.

Requirements
-------------------------------------------------------------------------------

You will need the following software installed:

* lttoolbox (>= 3.3.0)
* apertium (>= 3.3.0)
* vislcg3 (>= 0.9.9.10297)
* apertium-ind
* apertium-zlm

If this does not make any sense, we recommend you look at: www.apertium.org.

Compiling
-------------------------------------------------------------------------------

Given the requirements being installed, you should be able to just run:

    $ ./configure
    $ make
    # make install

You can use `./autogen.sh` instead of `./configure` you're compiling from
source. If you installed any prerequisite language packages using a `--prefix`
to `./configure`, make sure to give the same `--prefix` to `./configure` here.

Testing
-------------------------------------------------------------------------------

If you are in the source directory after running make, the following
commands should work:

    $  echo "TODO test sentence 1" | apertium -d . ind-zlm
    TODO test translated sentence 1

    $ echo "TODO test sentence 2" | apertium -d . zlm-ind
    TODO test translated sentence 2

After installing somewhere in `$PATH`, you should be able to do e.g.

    $  echo "TODO test sentence 1" | apertium ind-zlm
    TODO test translated sentence 1

Files and data
-------------------------------------------------------------------------------

* `apertium-ind-zlm.ind-zlm.dix`  - Bilingual dictionary
* `apertium-ind-zlm.ind-zlm.t1x`  - Transfer rules for translating into Malaysian
* `apertium-ind-zlm.zlm-ind.t1x`  - Transfer rules for translating into Indonesian
* `modes.xml`                     - Translation modes

For more information
-------------------------------------------------------------------------------

* http://wiki.apertium.org/wiki/Installation
* http://wiki.apertium.org/wiki/apertium-ind-zlm
* http://wiki.apertium.org/wiki/Using_an_lttoolbox_dictionary

Help and support
-------------------------------------------------------------------------------

If you need help using this language pair or data, you can contact:

* Mailing list: apertium-stuff@lists.sourceforge.net
* IRC: `#apertium` on `irc.freenode.net`

See also the file AUTHORS included in this distribution.
