!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_ntild
!! NAME
!! calc_ntild 
!! 
!! FUNCTION
!! Compute ntild(r)=pseudo valence density
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ,MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS 
!!  pawps
!!    %tphi(wav_meshsz,basis_size)= atomic pseudo partial waves
!!  pshead
!!    %basis_size= Number of elements for the paw nl basis
!!    %sph_meshsz= Dimension of radial mesh for spheres
!!  pawarray
!!    %occ_(sph_meshsz,basis_size)= Partial waves occupancies deduced
!!                                  from densities considerations
!!
!! OUTPUT
!!  pawarray
!!    %tvaleden4pr2(rho_meshsz)= Pseudo valence density * 4.pi.r2
!!
!! PARENTS
!!      uspp2abinit
!!
!! CHILDREN
!!
!! SOURCE

 subroutine calc_ntild(pawarray,pawps,pshead)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ---------------------------------------------
!These types are defined in defs_pawps
 type(pawarray_type) :: pawarray
 type(pawps_type)    :: pawps
 type(pshead_type)   :: pshead

!Local variables ---------------------------------------
 integer :: ib,ir

!--------------------------------------------------------

!Outside spheres, ntilde(r)=n(r)
!-------------------------------
 pawarray%tvaleden4pr2(pshead%sph_meshsz+1:pshead%rho_meshsz)=&
&  pawarray%valeden4pr2(pshead%sph_meshsz+1:pshead%rho_meshsz)

!Inside spheres, ntilde(r)/=n(r)
!--------------------------------
 do ib=1,pshead%basis_size
  do ir=1,pshead%sph_meshsz
   pawarray%tvaleden4pr2(ir)=pawarray%tvaleden4pr2(ir) &
&                           +pawarray%occ_(ir,ib)*pawps%tphi(ir,ib)**2
  enddo
 enddo

 end subroutine
!!***
