# coding=utf-8
#####################################################
# THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT #
#####################################################
# noqa: E128,E201
from ..client import BaseClient
from ..client import createApiClient
from ..client import config
from ..client import createTemporaryCredentials
from ..client import createSession
_defaultConfig = config


class PurgeCache(BaseClient):
    """
    The purge-cache service is responsible for tracking cache-purge requests.

    User create purge requests for specific caches on specific workers, and
    these requests are timestamped.  Workers consult the service before
    starting a new task, and purge any caches older than the timestamp.
    """

    classOptions = {
    }
    serviceName = 'purge-cache'
    apiVersion = 'v1'

    def ping(self, *args, **kwargs):
        """
        Ping Server

        Respond without doing anything.
        This endpoint is used to check that the service is up.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["ping"], *args, **kwargs)

    def purgeCache(self, *args, **kwargs):
        """
        Purge Worker Cache

        Publish a request to purge caches named `cacheName` with
        on `workerPoolId` workers.

        If such a request already exists, its `before` timestamp is updated to
        the current time.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["purgeCache"], *args, **kwargs)

    def allPurgeRequests(self, *args, **kwargs):
        """
        All Open Purge Requests

        View all active purge requests.

        This is useful mostly for administors to view
        the set of open purge requests. It should not
        be used by workers. They should use the purgeRequests
        endpoint that is specific to their workerType and
        provisionerId.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["allPurgeRequests"], *args, **kwargs)

    def purgeRequests(self, *args, **kwargs):
        """
        Open Purge Requests for a worker pool

        List the caches for this `workerPoolId` that should to be
        purged if they are from before the time given in the response.

        This is intended to be used by workers to determine which caches to purge.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["purgeRequests"], *args, **kwargs)

    funcinfo = {
        "allPurgeRequests": {
            'args': [],
            'method': 'get',
            'name': 'allPurgeRequests',
            'output': 'v1/all-purge-cache-request-list.json#',
            'query': ['continuationToken', 'limit'],
            'route': '/purge-cache/list',
            'stability': 'stable',
        },
        "ping": {
            'args': [],
            'method': 'get',
            'name': 'ping',
            'route': '/ping',
            'stability': 'stable',
        },
        "purgeCache": {
            'args': ['workerPoolId'],
            'input': 'v1/purge-cache-request.json#',
            'method': 'post',
            'name': 'purgeCache',
            'route': '/purge-cache/<workerPoolId>',
            'stability': 'stable',
        },
        "purgeRequests": {
            'args': ['workerPoolId'],
            'method': 'get',
            'name': 'purgeRequests',
            'output': 'v1/purge-cache-request-list.json#',
            'query': ['since'],
            'route': '/purge-cache/<workerPoolId>',
            'stability': 'stable',
        },
    }


__all__ = ['createTemporaryCredentials', 'config', '_defaultConfig', 'createApiClient', 'createSession', 'PurgeCache']
