# Copyright (c) 2005-2008 Nokia Corporation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License. 

import os.path

def IF(condition, value, default=None):
    if default is None:
        default=()
    if condition:
        return value
    else:
        return default

DEVICE_RELEASE_FROM='/epoc32/release/'+IF(S60_VERSION>=30, 'armv5/lib', DEVICE_PLATFORM+'/'+DEVICE_BUILD)
DEVICE_RELEASE_TO='epoc32/release/'+IF(S60_VERSION>=30, 'armv5/lib', DEVICE_PLATFORM+'/'+DEVICE_BUILD)

EMU_RELEASE_FROM='/epoc32/release/'+EMU_PLATFORM+'/'+EMU_BUILD
EMU_RELEASE_TO='epoc32/release/'+EMU_PLATFORM+'/'+EMU_BUILD

INCLUDES_TO='epoc32/include/python'

RESOURCE_INCLUDES_FROM='/epoc32/include'
RESOURCE_INCLUDES_TO='epoc32/include'

PYTHON_RESOURCE_IN_EMU=IF(S60_VERSION>=30, '/z/resource/apps', '/z/system/data')

CALENDAR_SRC_PATH=IF(S60_VERSION>=30,'ext/calendar/eka2/','ext/calendar/old/')
CONTACTS_SRC_PATH=IF(S60_VERSION>=30,'ext/contacts/eka2/','ext/contacts/old/')

PY2SIS_TO='epoc32/tools/py2sis'

TEST_PATH_EMU='epoc32/winscw/c/resource/test'

SDK_FILES=[]
for entry in (
    {'from': DEVICE_RELEASE_FROM,
     'to': DEVICE_RELEASE_TO,
     'files': ('python222.dll', 
               IF(S60_VERSION>=30 and DEVICE_PLATFORM=='gcce', 'python222.dso', 'python222.lib'),
               'python_appui.dll',
               IF(S60_VERSION>=30 and DEVICE_PLATFORM=='gcce', 'python_appui.dso','python_appui.lib'),)+
               IF(S60_VERSION>=30, ('python_appui{000a0000}.dso','python222{000a0000}.dso'))},
              
    {'from': EMU_RELEASE_FROM,
     'to': EMU_RELEASE_TO,
     'files': ('python222.dll',
               'python222.lib',
               'python_appui.dll',
               'python_appui.lib',)+
     IF(S60_VERSION>=30, ('python.exe',))},
    {'from': EMU_RELEASE_FROM+'/z/system/apps/python',
     'to': EMU_RELEASE_TO+'/z/system/apps/python',
     'files': ('python.app','python.rsc',)+
     IF(S60_VERSION>=28, ('python_aif.mif',), ('python.aif',))},
    {'from': EMU_RELEASE_FROM+'/z/private/10003A3F/apps',
     'to': EMU_RELEASE_TO+'/z/private/10003A3F/apps',
     'files': IF(S60_VERSION>=28,('python_reg.rsc',))},
    {'from': EMU_RELEASE_FROM+PYTHON_RESOURCE_IN_EMU,
     'to': EMU_RELEASE_TO+PYTHON_RESOURCE_IN_EMU,
     'files': ('appuifwmodule.rsc',)},
    {'from': '/epoc32/data/z/resource/apps',
     'to': EMU_RELEASE_TO+PYTHON_RESOURCE_IN_EMU,
     'files': ('python.rsc',)},
    {'from': EMU_RELEASE_FROM+PYTHON_RESOURCE_IN_EMU,
     'to': EMU_RELEASE_TO+PYTHON_RESOURCE_IN_EMU,
     'files': ('python_aif.mif',)},
    {'from': IF(S60_VERSION>=30, EMU_RELEASE_FROM, EMU_RELEASE_FROM+'/z/system/libs'),
     'to': IF(S60_VERSION>=30, 'epoc32/winscw/c/sys/bin', EMU_RELEASE_TO+'/z/system/libs'),
     'files': (   'e32db.pyd',
                  'e32socket.pyd')+
     IF(WITH_LOCATION_MODULE,('_location.pyd',))+
     IF(WITH_MESSAGING_MODULE,('_messaging.pyd',))+
     #IF(WITH_SENSOR_MODULE,('_sensor.pyd',))+    # No .lib for winscw target
     #               '_testcapi.pyd',
     ('_contacts.pyd',
     '_sysinfo.pyd',
     'zlib.pyd',
     '_logs.pyd')+
    IF(S60_VERSION>=26,('glcanvas.pyd',
                        'gles.pyd',
					    '_locationacq.pyd',))+
    IF(S60_VERSION>12,('_camera.pyd',))+('_telephone.pyd',
									     '_recorder.pyd',
                                         '_graphics.pyd',
                                         '_calendar.pyd',
                                         'inbox.pyd',
                                         'globalui.pyd',
                                         '_topwindow.pyd',
                                         '_keycapture.pyd'
                                         )},
{'from': IF(S60_VERSION>=30, EMU_RELEASE_FROM, EMU_RELEASE_FROM+'/z/system/programs'),
 'to': IF(S60_VERSION>=30, EMU_RELEASE_TO, EMU_RELEASE_TO+'/z/system/programs'),
     'files': (IF(S60_VERSION>=30, 'python_launcher.exe', 'python_launcher.dll'),)},
    {'from': SRC_DIR,
     'to': IF(S60_VERSION>=30, 'epoc32/winscw/c/python', EMU_RELEASE_TO+'/z/system/apps/python'),
     'files': ('app/filebrowser.py',
               'extras/snake.py',
               'extras/ball.py',
               'extras/imgviewer.py',
               'extras/keyviewer.py',
               
               ) +
               IF(S60_VERSION>=26,('extras/gles_demo.py',
                                   'extras/simplecube.py',))
               },
    {'from': SRC_DIR,
     'to': IF(S60_VERSION>=30, 'epoc32/winscw/c/private/'+PYS60_UID_SCRIPTSHELL[2:], EMU_RELEASE_TO+'/z/system/apps/python'),
     'files': ('app/default.py',
               )},
    {'from': SRC_DIR,
     'to': IF(S60_VERSION>=30, 'epoc32/winscw/c/resource', EMU_RELEASE_TO+'/z/system/libs'),
     'files': ('core/Lib/anydbm.py',
               'core/Lib/atexit.py',
               'core/Lib/base64.py',
               'core/Lib/btconsole.py',
               'core/Lib/code.py',
               'core/Lib/codecs.py',
               'core/Lib/codeop.py',
               'core/Lib/copy.py',
               'core/Lib/copy_reg.py',
               'app/dir_iter.py',
               'app/series60_console.py',
               'app/interactive_console.py',
               'core/Lib/e32dbm.py',
               'core/Lib/httplib.py',
               'core/Lib/keyword.py',
               'core/Lib/key_codes.py',
               'core/Lib/linecache.py',
               'core/Lib/mimetools.py',
               'core/Lib/ntpath.py',
               'core/Lib/os.py',
               'core/Lib/pack.py',
               'core/Lib/quopri.py',
               'core/Lib/random.py',
               'core/Lib/re.py',
               'core/Lib/repr.py',
               'core/Lib/rfc822.py',
               'core/Lib/shutil.py',
               'core/Lib/site.py',
               'core/Lib/sre.py',
               'core/Lib/sre_compile.py',
               'core/Lib/sre_constants.py',
               'core/Lib/sre_parse.py',
               'core/Lib/stat.py',
               'core/Lib/string.py',
               'core/Lib/StringIO.py',
               'core/Lib/traceback.py',
               'core/Lib/types.py',
               'core/Lib/UserDict.py',
               'core/Lib/urllib.py',
               'core/Lib/urlparse.py',
               'core/Lib/uu.py',
               'core/Lib/warnings.py',
               'core/Lib/weakref.py',
               'core/Lib/whichdb.py',
               'core/Lib/whrandom.py',
               'core/Lib/__future__.py',
               'core/Lib/zipfile.py',
               CONTACTS_SRC_PATH+'contacts.py',
               'ext/telephone/telephone.py',
               'ext/recorder/audio.py',
               'ext/graphics/graphics.py',
               'ext/sysinfo/sysinfo.py',
               CALENDAR_SRC_PATH+'calendar.py',
               'ext/camera/camera.py',
               'ext/keycapture/keycapture.py',
               'ext/topwindow/topwindow.py',
               'ext/location/location.py',
               'ext/messaging/messaging.py',
               'ext/sensor/sensor.py',
               'ext/socket/socket.py',
               'ext/socket/select.py',
               'ext/logs/logs.py',
               'appui/appuifw/appuifw.py') +
               IF(S60_VERSION>=26,('ext/gles/gles_utils.py',
                    			   'ext/gps/locationacq.py',
                                   'ext/gps/positioning.py',))
               },
    {'from': SRC_DIR,
     'to': IF(S60_VERSION>=30, 'epoc32/winscw/c/resource/encodings' , EMU_RELEASE_TO+'/z/system/libs/encodings'),
     'files': ('core/Lib/encodings/aliases.py',
               'core/Lib/encodings/ascii.py',
               'core/Lib/encodings/base64_codec.py',
               'core/Lib/encodings/charmap.py',
               'core/Lib/encodings/hex_codec.py',
               'core/Lib/encodings/latin_1.py',
               'core/Lib/encodings/raw_unicode_escape.py',
               'core/Lib/encodings/unicode_escape.py',
               'core/Lib/encodings/unicode_internal.py',
               'core/Lib/encodings/utf_16.py',
               'core/Lib/encodings/utf_16_be.py',
               'core/Lib/encodings/utf_16_le.py',
               'core/Lib/encodings/utf_7.py',
               'core/Lib/encodings/utf_8.py',
               'core/Lib/encodings/uu_codec.py',
               'core/Lib/encodings/__init__.py',
               'core/Lib/encodings/zlib_codec.py')},
    {'from': SRC_DIR,
     'to': INCLUDES_TO,
     'files': ('appui/Python_appui.h',
               'core/include/abstract.h',
               'core/include/bitset.h',
               'core/include/bufferobject.h',
               'core/include/cellobject.h',
               'core/include/ceval.h',
               'core/include/classobject.h',
               'core/include/cobject.h',
               'core/include/codecs.h',
               'core/include/compile.h',
               'core/include/complexobject.h',
               'core/include/cStringIO.h',
               'core/include/descrobject.h',
               'core/include/dictobject.h',
               'core/include/errcode.h',
               'core/include/eval.h',
               'core/include/fileobject.h',
               'core/include/floatobject.h',
               'core/include/frameobject.h',
               'core/include/funcobject.h',
               'core/include/graminit.h',
               'core/include/grammar.h',
               'core/include/import.h',
               'core/include/intobject.h',
               'core/include/intrcheck.h',
               'core/include/iterobject.h',
               'core/include/listobject.h',
               'core/include/longintrepr.h',
               'core/include/longobject.h',
               'core/include/marshal.h',
               'core/include/metagrammar.h',
               'core/include/methodobject.h',
               'core/include/modsupport.h',
               'core/include/moduleobject.h',
               'core/include/node.h',
               'core/include/object.h',
               'core/include/objimpl.h',
               'core/include/opcode.h',
               'core/include/osdefs.h',
               'core/include/parsetok.h',
               'core/include/patchlevel.h',
               'core/include/pgenheaders.h',
               'core/include/pydebug.h',
               'core/include/pyerrors.h',
               'core/include/pyfpe.h',
               'core/include/pygetopt.h',
               'core/include/pymactoolbox.h',
               'core/include/pymem.h',
               'core/include/pyport.h',
               'core/include/pystate.h',
               'core/include/Python.h',
               'core/include/pythonrun.h',
               'core/include/pythread.h',
               'core/include/py_curses.h',
               'core/include/rangeobject.h',
               'core/include/sliceobject.h',
               'core/include/stringobject.h',
               'core/include/structmember.h',
               'core/include/structseq.h',
               'core/include/symtable.h',
               'core/include/sysmodule.h',
               'core/include/token.h',
               'core/include/traceback.h',
               'core/include/tupleobject.h',
               'core/include/ucnhash.h',
               'core/include/unicodeobject.h',
               'core/include/weakrefobject.h',
               'core/objects/unicodetype_db.h',
               'core/parser/parser.h',
               'core/parser/pgen.h',
               'core/parser/tokenizer.h',
               'core/python/importdl.h',
               'core/symbian/CSPyInterpreter.h',
               'core/symbian/pyconfig.h',
               'core/symbian/python_globals.h',
               'core/symbian/symbian_python_ext_util.h',
               'core/symbian/buildconfig.h',
               'core/symbian/python_aif.mbg')},
    {'from': RESOURCE_INCLUDES_FROM,
     'to': RESOURCE_INCLUDES_TO,
     'files': IF(S60_VERSION>=30,('Python.rsg',))},
    {'from': SRC_DIR+'/py2sis/',
     'to': PY2SIS_TO,
     'files': ('build_all.cmd',
               'py2sis.py',
               'Py2SIS_3rdED_v0_1_README.txt',
               'py2sis_gui.py',
               'setup.py',
               'setup_nogui.py')},
    {'from': SRC_DIR+'/py2sis/',
     'to': PY2SIS_TO+'/sismaker',
     'files': ('sismaker/__init__.py',
               'sismaker/cmdui.py',
               'sismaker/fileutil.py',
               'sismaker/template_engine.py',
               'sismaker/tkgui.py',
               'sismaker/utils.py')},
    {'from': SRC_DIR+'/py2sis/',
     'to': PY2SIS_TO+'/templates',
     'files': ('templates/pyapp_template.tmp',
               'templates/pyapp_template_pre_SDK20.tmp',
               'templates/pypkg_template.tmp',
               'templates/pypkg_template_pre_SDK20.tmp',
               'templates/pyrsc_template.tmp',
               'templates/pyrsc_template_pre_SDK20.tmp')},
    {'from': SRC_DIR+'/py2sis/',
     'to': PY2SIS_TO+'/templates_eka2',
     'files': ('templates_eka2/app.mmp.template',
               'templates_eka2/bld.inf',
               'templates_eka2/Icons_aif.mk.template',
               'templates_eka2/pypkg_template_SDK30.tmp',
               'templates_eka2/PyTest.cpp.template',
               'templates_eka2/PyTest.hrh',
               'templates_eka2/PyTest.rss.template',
               'templates_eka2/PyTest_app.h',
               'templates_eka2/PyTest_reg.rss.template',
               'templates_eka2/00000000.rss.template',               
               'templates_eka2/python_star.svg')},
    {'from': TEST_DIR+'/modules/',
     'to': RESOURCE_INCLUDES_TO,
     'files': IF(TEST_FLAG=='ON',('ifc.py',
                                  'asynchat.py',
                                  'asyncore.py',
                                  'badsyntax_future3.py',
                                  'badsyntax_future4.py',
                                  'badsyntax_future5.py',
                                  'badsyntax_future6.py',
                                  'badsyntax_future7.py',
                                  'badsyntax_nocaret.py',
                                  'bisect.py',
                                  'cgi.py',
                                  'chunk.py',
                                  'commands.py',
                                  'ConfigParser.py',
                                  'Cookie.py',
                                  'copy_reg.py',
                                  'descr1.py',
                                  'descr2.py',
                                  'descr3.py',
                                  'descr4.py',
                                  'descr5.py',
                                  'descr6.py',
                                  'difflib.py',
                                  'doctest.py',
                                  'ftplib.py',
                                  'getopt.py',
                                  'gopherlib.py',
                                  'inspect.py',
                                  'locale.py',
                                  'mhlib.py',
                                  'mimetypes.py',
                                  'multifile.py',
                                  'pickle.py',
                                  'pickletester.py',
                                  'pkg_maker.py',
                                  'posixpath.py',
                                  'pprint.py',
                                  'pyclbr.py',
                                  'Queue.py',
                                  'random.py',
                                  're_tests.py',
                                  'statvfs.py',
                                  'string_tests.py',
                                  'tempfile.py',
                                  'testcodec.py',
                                  'test_support.py',
                                  'token.py',
                                  'tokenize.py',
                                  'tokenize_tests.py',
                                  'unittest.py',
                                  'urllib2.py',
                                  'UserString.py',
                                  'xmllib.py',))
     },
     {'from': TEST_DIR,
      'to': TEST_PATH_EMU,
      'files': IF(TEST_FLAG=='ON',('test_augassign.py',
                                   'test_b1.py',
                                   'test_b2.py',
                                   'test_base64.py',
                                   'test_binascii.py',
                                   'test_binop.py',
                                   'test_bisect.py',
                                   'test_call.py',
                                   'test_charmapcodec.py',
                                   'test_class.py',
                                   'test_codecs.py',
                                   'test_codeop.py',
                                   'test_coercion.py',
                                   'test_compare.py',                
                                   'test_complex.py',
                                   'test_contains.py',
                                   'test_copy_reg.py',
                                   'test_errno.py',
                                   'test_frozen.py',
                                   'test_funcattrs.py',
                                   'test_future.py',
                                   'test_future1.py',
                                   'test_future2.py',
                                   'test_future3.py',
                                   'test_global.py',
                                   'test_grammar.py',
                                   'test_hash.py',
                                   'test_httplib.py',
                                   'test_iter.py',
                                   'test_marshal.py',
                                   'test_math.py',
                                   'test_md5.py',
                                   'test_mimetools.py',
                                   'test_mimetypes.py',
                                   'test_mutants.py',
                                   'test_ntpath.py',
                                   'test_opcodes.py',
                                   'test_operations.py',
                                   'test_operator.py',
                                   'test_pickle.py',
                                   'test_pkg.py',
                                   'test_pkgimport.py',
                                   'test_pow.py',
                                   'test_quopri.py',
                                   'test_random.py',
                                   'test_repr.py',
                                   'test_rfc822.py',
                                   'test_scope.py',
                                   'test_sre.py',
                                   'test_StringIO.py',
                                   'test_struct.py',
                                   'test_structseq.py',
                                   'test_tempfile.py',
                                   'test_thread.py',
                                   'test_threaded_import.py',
                                   'test_time.py',
                                   'test_traceback.py',
                                   'test_types.py',
                                   'test_unary.py',
                                   'test_unicode.py',
                                   'test_unpack.py',
                                   'test_urllib.py',
                                   'test_userdict.py',
                                   'test_uu.py',
                                   'test___future__.py',
                                   '__init__.py',))},
    {'from': TEST_DIR+'/output/',
     'to': TEST_PATH_EMU+'/output',
     'files': IF(TEST_FLAG=='ON',('test_asynchat',
                                  'test_augassign',
                                  'test_bastion',
                                  'test_binascii',
                                  'test_builtin',
                                  'test_cfgparser',
                                  'test_cgi',
                                  'test_charmapcodec',
                                  'test_class',
                                  'test_coercion',
                                  'test_compare',
                                  'test_compile',
                                  'test_cookie',
                                  'test_exceptions',
                                  'test_extcall',
                                  'test_frozen',
                                  'test_future',
                                  'test_gettext',
                                  'test_global',
                                  'test_grammar',
                                  'test_httplib',
                                  'test_linuxaudiodev',
                                  'test_longexp',
                                  'test_math',
                                  'test_md5',
                                  'test_mimetools',
                                  'test_MimeWriter',
                                  'test_mmap',
                                  'test_new',
                                  'test_nis',
                                  'test_opcodes',
                                  'test_openpty',
                                  'test_operations',
                                  'test_pkg',
                                  'test_poll',
                                  'test_popen2',
                                  'test_posixpath',
                                  'test_pow',
                                  'test_profile',
                                  'test_pty',
                                  'test_pwd',
                                  'test_pyexpat',
                                  'test_re',
                                  'test_regex',
                                  'test_rgbimg',
                                  'test_richcmp',
                                  'test_rotor',
                                  'test_sax',
                                  'test_scope',
                                  'test_signal',
                                  'test_socket',
                                  'test_string',
                                  'test_thread',
                                  'test_threadedtempfile',
                                  'test_tokenize',
                                  'test_types',
                                  'test_ucn',
                                  'test_unicode',
                                  'test_unicodedata',
                                  'test_unicode_file',
                                  'test_urlparse',
                                  'test_winreg',
                                  'test_winsound',
                                  'test_xreadline',
                                  'test_zlib',))}
    ):
    for f in entry['files']:
        SDK_FILES.append((os.path.normpath(entry['from']+'/'+f),
                          os.path.normpath(entry['to']+'/'+os.path.basename(f))))
