#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Long Live the Queen
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250521.3

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='long-live-the-queen'
GAME_NAME='Long Live the Queen'

ARCHIVE_BASE_0_NAME='gog_long_live_the_queen_2.4.0.11.sh'
ARCHIVE_BASE_0_MD5='654ccbbdde2071c4f13b5f80378582c2'
ARCHIVE_BASE_0_SIZE='63000'
ARCHIVE_BASE_0_VERSION='1.3.23.4-gog2.4.0.11'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/long_live_the_queen'

CONTENT_PATH_DEFAULT='data/noarch/game'
## TODO: Check if all these libraries are actually used.
CONTENT_LIBS_BIN_SHIPPED_RELATIVE_PATH='lib/linux-x86/lib'
CONTENT_LIBS_BIN_SHIPPED_FILES='
libavcodec.so.52
libavformat.so.52
libavutil.so.50
libGLEW.so.1.5
libpython2.6.so.1.0
libswscale.so.0'
## TODO: The system-provided font should be used instead.
CONTENT_FONTS_MAIN_RELATIVE_PATH='game'
CONTENT_FONTS_MAIN_FILES='
DejaVuSans-Oblique.ttf'
CONTENT_GAME_MAIN_FILES='
game/achievements
game/bonus
game/Crypto
game/endings
game/heads
game/map
game/music
game/princess
game/sidebar
game/stars
game/tutorial
game/ui
game/game_version
game/llq.rpa
game/bytecode.rpyb
game/*.png
game/*.py
game/*.rpyc'
CONTENT_GAME_BIN_SHIPPED_FILES='
common
renpy
LongLiveTheQueen.py
lib/linux-x86/lib/python2.6
lib/linux-x86/python.real'
CONTENT_DOC_MAIN_FILES='
LICENSE.txt'

APP_MAIN_TYPE_BIN_RENPY='renpy'
## Support for the shipped builds of Ren'Py and Python 2.6 is included,
## because current day Ren'Py fails to run the game, with the following error:
## Full traceback:
##   File "/usr/share/games/renpy/renpy/bootstrap.py", line 359, in bootstrap
##     renpy.main.main()
##   File "/usr/share/games/renpy/renpy/main.py", line 474, in main
##     renpy.game.script.load_script() # sets renpy.game.script.
##   File "/usr/share/games/renpy/renpy/script.py", line 359, in load_script
##     self.load_appropriate_file(".rpyc", [ "_ren.py", ".rpy" ], dir, fn, initcode)
##   File "/usr/share/games/renpy/renpy/script.py", line 934, in load_appropriate_file
##     raise Exception("Could not load file %s." % lastfn) # type: ignore
## Exception: Could not load file /usr/share/games/long-live-the-queen/dossiers.rpyc.
APP_MAIN_EXE_BIN_SHIPPED='lib/linux-x86/python.real'
APP_MAIN_OPTIONS_BIN_SHIPPED='-OO LongLiveTheQueen.py'
APP_MAIN_ICON='game/achievements/coronation_64x64.png'

PACKAGES_LIST='
PKG_MAIN
PKG_BIN_RENPY
PKG_BIN_SHIPPED'

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_BIN'
## Ensure easy upgrades from pre-20250513.1 packages.
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
long-live-the-queen-data"

PKG_BIN_ID="${GAME_ID}-bin"
PKG_BIN_PROVIDES="
$PKG_BIN_ID"

PKG_BIN_RENPY_ID="${PKG_BIN_ID}-renpy"
PKG_BIN_RENPY_PROVIDES="$PKG_BIN_PROVIDES"
PKG_BIN_RENPY_DESCRIPTION="System-provided Ren'Py"

PKG_BIN_SHIPPED_ID="${PKG_BIN_ID}-shipped"
PKG_BIN_SHIPPED_PROVIDES="$PKG_BIN_PROVIDES"
PKG_BIN_SHIPPED_ARCH='32'
PKG_BIN_SHIPPED_DESCRIPTION="Shipped Ren'Py and Python 2.6"
PKG_BIN_SHIPPED_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libfreetype.so.6
libfribidi.so.0
libm.so.6
libpthread.so.0
libSDL-1.2.so.0
libSDL_ttf-2.0.so.0
libutil.so.1'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

## Link fonts to the game directory, or the engine fails to find them.
fonts_source=$(path_fonts_ttf)
fonts_destination="$(package_path 'PKG_MAIN')$(path_game_data)/game"
ln --symbolic "${fonts_source}/DejaVuSans-Oblique.ttf" "$fonts_destination"

# Write launchers

## The game data is installed in an unusual path.
renpy_exec_line() {
	cat <<- 'EOF'
	renpy game
	EOF
}

launchers_generation 'PKG_BIN_RENPY'
launchers_generation 'PKG_BIN_SHIPPED'

# Build packages

packages_generation
case "$(messages_language)" in
	('fr')
		message='Utilisation des binaires fournis par %s :'
		bin_system='le système'
		bin_shipped='les développeurs'
	;;
	('en'|*)
		message='Using binaries provided by %s:'
		bin_system='the system'
		bin_shipped='the developers'
	;;
esac
printf '\n'
printf "$message" "$bin_system"
print_instructions 'PKG_MAIN' 'PKG_BIN_RENPY'
printf "$message" "$bin_shipped"
print_instructions 'PKG_MAIN' 'PKG_BIN_SHIPPED'

# Clean up

working_directory_cleanup

exit 0
