#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# I Have No Mouth And I Must Scream
# send your bug reports to contact@dotslashplay.it
###

script_version=20240823.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='i-have-no-mouth-and-i-must-scream'
GAME_NAME='I Have No Mouth And I Must Scream'

ARCHIVE_BASE_EN_0_NAME='i_have_no_mouth_and_i_must_scream_en_1_0_17913.sh'
ARCHIVE_BASE_EN_0_MD5='93640c6a4dc73f4ed2d40b210b95ba4c'
ARCHIVE_BASE_EN_0_SIZE='750000'
ARCHIVE_BASE_EN_0_VERSION='1.0-gog17913'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/i_have_no_mouth_and_i_must_scream'

ARCHIVE_BASE_FR_0_NAME='i_have_no_mouth_and_i_must_scream_fr_1_0_17913.sh'
ARCHIVE_BASE_FR_0_MD5='9124d7ccef36d4bb01dfae4d97cfbdea'
ARCHIVE_BASE_FR_0_SIZE='570000'
ARCHIVE_BASE_FR_0_VERSION='1.0-gog17913'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/i_have_no_mouth_and_i_must_scream'

ARCHIVE_BASE_INNERARCHIVE_EN_0_NAME='gog_i_have_no_mouth_and_i_must_scream_2.0.0.4.sh'
ARCHIVE_BASE_INNERARCHIVE_EN_0_MD5='be690cfa08a87b350c26cbfdde5de401'
ARCHIVE_BASE_INNERARCHIVE_EN_0_SIZE='780000'
ARCHIVE_BASE_INNERARCHIVE_EN_0_VERSION='1.0-gog2.0.0.4'

ARCHIVE_BASE_INNERARCHIVE_FR_0_NAME='gog_i_have_no_mouth_and_i_must_scream_french_2.0.0.4.sh'
ARCHIVE_BASE_INNERARCHIVE_FR_0_MD5='e59029d2736ffa2859d73d56899055ee'
ARCHIVE_BASE_INNERARCHIVE_FR_0_SIZE='500000'
ARCHIVE_BASE_INNERARCHIVE_FR_0_VERSION='1.0-gog2.0.0.4'

CONTENT_PATH_DEFAULT='data/noarch/data'
CONTENT_GAME_L10N_FILES='
scream.res
scripts.res
voices?.res'
CONTENT_GAME_MAIN_FILES='
musicfm.res
musicgm.res
sfx.res
patch.re_'
CONTENT_DOC_MAIN_PATH='data/noarch/docs'
CONTENT_DOC_MAIN_FILES='
*.pdf'

APP_MAIN_SCUMMID='saga:ihnm'
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='
PKG_MAIN
PKG_L10N'

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE'

PKG_L10N_BASE_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_BASE_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_BASE_ID}-fr"
PKG_L10N_ID_INNERARCHIVE_EN="$PKG_L10N_ID_EN"
PKG_L10N_ID_INNERARCHIVE_FR="$PKG_L10N_ID_FR"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'
PKG_L10N_DESCRIPTION_INNERARCHIVE_EN="$PKG_L10N_DESCRIPTION_EN"
PKG_L10N_DESCRIPTION_INNERARCHIVE_FR="$PKG_L10N_DESCRIPTION_FR"

# Older gog.com archives require to get files from an inner archive

SCRIPT_DEPS_INNERARCHIVE="${SCRIPT_DEPS:-} unar"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Older gog.com archives require to get files from an inner archive

## SCRIPT_DEPS has no support for contextual values.
SCRIPT_DEPS=$(context_value 'SCRIPT_DEPS')
check_deps

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## Older gog.com archives require to get files from an inner archive.
	case "$(current_archive)" in
		('ARCHIVE_BASE_INNERARCHIVE_'*)
			ARCHIVE_INNER_PATH="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/NoMouth.dat"
			ARCHIVE_INNER_EXTRACTOR='unar'
			archive_extraction 'ARCHIVE_INNER'
			rm "$ARCHIVE_INNER_PATH"
		;;
	esac

	## Convert all file names to lower case.
	tolower .
)
## Older gog.com archives require to get files from an inner archive
CONTENT_PATH_DEFAULT_INNERARCHIVE='.'

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
