/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_INSTALLEDSOFTWAREIDENTITYACCESS_H_
#define OPENDRIM_INSTALLEDSOFTWAREIDENTITYACCESS_H_

#include "SoftwareInventory_Common.h"

#include "OpenDRIM_InstalledSoftwareIdentity.h"
#include "assocOpenDRIM_InstalledSoftwareIdentity.h"

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_load(const CMPIBroker* broker, string& errorMessage);

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_unload(string& errorMessage);

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_InstalledSoftwareIdentity>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_InstalledSoftwareIdentity& instance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_InstalledSoftwareIdentity& newInstance, const OpenDRIM_InstalledSoftwareIdentity& oldInstance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_InstalledSoftwareIdentity& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_InstalledSoftwareIdentity& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_associatorSystemToInstalledSoftware(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& System_instance, const char** properties, vector<Instance>& InstalledSoftware_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_associatorInstalledSoftwareToSystem(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& InstalledSoftware_instance, const char** properties, vector<Instance>& System_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_referenceSystemToInstalledSoftware(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& System_instance, const vector<Instance>& InstalledSoftware_instances, vector<OpenDRIM_InstalledSoftwareIdentity>& OpenDRIM_InstalledSoftwareIdentity_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_referenceInstalledSoftwareToSystem(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& InstalledSoftware_instance, const vector<Instance>& System_instances, vector<OpenDRIM_InstalledSoftwareIdentity>& OpenDRIM_InstalledSoftwareIdentity_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_populate(OpenDRIM_InstalledSoftwareIdentity& instance, string& errorMessage);

#endif /*OPENDRIM_INSTALLEDSOFTWAREIDENTITYACCESS_H_*/
