/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#ifndef OPENDRIM_ACCOUNT_H_
#define OPENDRIM_ACCOUNT_H_

#include <Instance.h>

const static char* OpenDRIM_Account_classnames[] = {"OpenDRIM_Account"};
static string OpenDRIM_Account_NAMESPACE = _NAMESPACE;

class OpenDRIM_Account {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string InstallDate;
	bool InstallDate_isNULL;
	
	vector<unsigned short> OperationalStatus;
	bool OperationalStatus_isNULL;
	
	vector<string> StatusDescriptions;
	bool StatusDescriptions_isNULL;
	
	string Status;
	bool Status_isNULL;
	
	unsigned short HealthState;
	bool HealthState_isNULL;
	
	unsigned short PrimaryStatus;
	bool PrimaryStatus_isNULL;
	
	unsigned short DetailedStatus;
	bool DetailedStatus_isNULL;
	
	unsigned short OperatingStatus;
	bool OperatingStatus_isNULL;
	
	unsigned short CommunicationStatus;
	bool CommunicationStatus_isNULL;
	
	unsigned short EnabledState;
	bool EnabledState_isNULL;
	
	string OtherEnabledState;
	bool OtherEnabledState_isNULL;
	
	unsigned short RequestedState;
	bool RequestedState_isNULL;
	
	unsigned short EnabledDefault;
	bool EnabledDefault_isNULL;
	
	string TimeOfLastStateChange;
	bool TimeOfLastStateChange_isNULL;
	
	vector<unsigned short> AvailableRequestedStates;
	bool AvailableRequestedStates_isNULL;
	
	unsigned short TransitioningToState;
	bool TransitioningToState_isNULL;
	
	string SystemCreationClassName;
	bool SystemCreationClassName_isNULL;
	
	string SystemName;
	bool SystemName_isNULL;
	
	string CreationClassName;
	bool CreationClassName_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	string UserID;
	bool UserID_isNULL;
	
	vector<string> ObjectClass;
	bool ObjectClass_isNULL;
	
	vector<string> Descriptions;
	bool Descriptions_isNULL;
	
	vector<string> Host;
	bool Host_isNULL;
	
	vector<string> LocalityName;
	bool LocalityName_isNULL;
	
	vector<string> OrganizationName;
	bool OrganizationName_isNULL;
	
	vector<string> OU;
	bool OU_isNULL;
	
	vector<string> SeeAlso;
	bool SeeAlso_isNULL;
	
	vector<string> UserCertificate;
	bool UserCertificate_isNULL;
	
	vector<string> UserPassword;
	bool UserPassword_isNULL;
	
	unsigned short PasswordHistoryDepth;
	bool PasswordHistoryDepth_isNULL;
	
	string PasswordExpiration;
	bool PasswordExpiration_isNULL;
	
	vector<unsigned short> ComplexPasswordRulesEnforced;
	bool ComplexPasswordRulesEnforced_isNULL;
	
	string InactivityTimeout;
	bool InactivityTimeout_isNULL;
	
	unsigned short MaximumSuccessiveLoginFailures;
	bool MaximumSuccessiveLoginFailures_isNULL;
	
	string LastLogin;
	bool LastLogin_isNULL;
	
	string PasswordLastChange;
	bool PasswordLastChange_isNULL;
	
	string AccountExpiration;
	bool AccountExpiration_isNULL;
	
	string PrimaryGroup;
	bool PrimaryGroup_isNULL;
	
	string LoginShell;
	bool LoginShell_isNULL;
	
	string HomeDirectory;
	bool HomeDirectory_isNULL;
	
	OpenDRIM_Account() {
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		InstallDate_isNULL = true;
		OperationalStatus_isNULL = true;
		StatusDescriptions_isNULL = true;
		Status_isNULL = true;
		HealthState_isNULL = true;
		PrimaryStatus_isNULL = true;
		DetailedStatus_isNULL = true;
		OperatingStatus_isNULL = true;
		CommunicationStatus_isNULL = true;
		EnabledState_isNULL = true;
		OtherEnabledState_isNULL = true;
		RequestedState_isNULL = true;
		EnabledDefault_isNULL = true;
		TimeOfLastStateChange_isNULL = true;
		AvailableRequestedStates_isNULL = true;
		TransitioningToState_isNULL = true;
		SystemCreationClassName_isNULL = true;
		SystemName_isNULL = true;
		CreationClassName_isNULL = true;
		Name_isNULL = true;
		UserID_isNULL = true;
		ObjectClass_isNULL = true;
		Descriptions_isNULL = true;
		Host_isNULL = true;
		LocalityName_isNULL = true;
		OrganizationName_isNULL = true;
		OU_isNULL = true;
		SeeAlso_isNULL = true;
		UserCertificate_isNULL = true;
		UserPassword_isNULL = true;
		PasswordHistoryDepth_isNULL = true;
		PasswordExpiration_isNULL = true;
		ComplexPasswordRulesEnforced_isNULL = true;
		InactivityTimeout_isNULL = true;
		MaximumSuccessiveLoginFailures_isNULL = true;
		LastLogin_isNULL = true;
		PasswordLastChange_isNULL = true;
		AccountExpiration_isNULL = true;
		PrimaryGroup_isNULL = true;
		LoginShell_isNULL = true;
		HomeDirectory_isNULL = true;
	}
	
	~OpenDRIM_Account() {}
	
	string getKeys() const {
		return CF_toLowCase(".SystemCreationClassName=\"" + CF_quoteString(SystemCreationClassName) + "\""".SystemName=\"" + CF_quoteString(SystemName) + "\""".CreationClassName=\"" + CF_quoteString(CreationClassName) + "\""".Name=\"" + CF_quoteString(Name) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getInstallDate(string& value) const {
		if (InstallDate_isNULL==true)
			return NOT_FOUND;
		value = InstallDate;
		return OK;
	}
	
	int setInstallDate(const string& newValue) {
		InstallDate = newValue;
		InstallDate_isNULL = false;
		return OK;
	}

	int getOperationalStatus(vector<unsigned short>& value) const {
		if (OperationalStatus_isNULL==true)
			return NOT_FOUND;
		value = OperationalStatus;
		return OK;
	}
	
	int setOperationalStatus(const vector<unsigned short>& newValue) {
		OperationalStatus = newValue;
		OperationalStatus_isNULL = false;
		return OK;
	}

	int getStatusDescriptions(vector<string>& value) const {
		if (StatusDescriptions_isNULL==true)
			return NOT_FOUND;
		value = StatusDescriptions;
		return OK;
	}
	
	int setStatusDescriptions(const vector<string>& newValue) {
		StatusDescriptions = newValue;
		StatusDescriptions_isNULL = false;
		return OK;
	}

	int getStatus(string& value) const {
		if (Status_isNULL==true)
			return NOT_FOUND;
		value = Status;
		return OK;
	}
	
	int setStatus(const string& newValue) {
		Status = newValue;
		Status_isNULL = false;
		return OK;
	}

	int getHealthState(unsigned short& value) const {
		if (HealthState_isNULL==true)
			return NOT_FOUND;
		value = HealthState;
		return OK;
	}
	
	int setHealthState(const unsigned short& newValue) {
		HealthState = newValue;
		HealthState_isNULL = false;
		return OK;
	}

	int getPrimaryStatus(unsigned short& value) const {
		if (PrimaryStatus_isNULL==true)
			return NOT_FOUND;
		value = PrimaryStatus;
		return OK;
	}
	
	int setPrimaryStatus(const unsigned short& newValue) {
		PrimaryStatus = newValue;
		PrimaryStatus_isNULL = false;
		return OK;
	}

	int getDetailedStatus(unsigned short& value) const {
		if (DetailedStatus_isNULL==true)
			return NOT_FOUND;
		value = DetailedStatus;
		return OK;
	}
	
	int setDetailedStatus(const unsigned short& newValue) {
		DetailedStatus = newValue;
		DetailedStatus_isNULL = false;
		return OK;
	}

	int getOperatingStatus(unsigned short& value) const {
		if (OperatingStatus_isNULL==true)
			return NOT_FOUND;
		value = OperatingStatus;
		return OK;
	}
	
	int setOperatingStatus(const unsigned short& newValue) {
		OperatingStatus = newValue;
		OperatingStatus_isNULL = false;
		return OK;
	}

	int getCommunicationStatus(unsigned short& value) const {
		if (CommunicationStatus_isNULL==true)
			return NOT_FOUND;
		value = CommunicationStatus;
		return OK;
	}
	
	int setCommunicationStatus(const unsigned short& newValue) {
		CommunicationStatus = newValue;
		CommunicationStatus_isNULL = false;
		return OK;
	}

	int getEnabledState(unsigned short& value) const {
		if (EnabledState_isNULL==true)
			return NOT_FOUND;
		value = EnabledState;
		return OK;
	}
	
	int setEnabledState(const unsigned short& newValue) {
		EnabledState = newValue;
		EnabledState_isNULL = false;
		return OK;
	}

	int getOtherEnabledState(string& value) const {
		if (OtherEnabledState_isNULL==true)
			return NOT_FOUND;
		value = OtherEnabledState;
		return OK;
	}
	
	int setOtherEnabledState(const string& newValue) {
		OtherEnabledState = newValue;
		OtherEnabledState_isNULL = false;
		return OK;
	}

	int getRequestedState(unsigned short& value) const {
		if (RequestedState_isNULL==true)
			return NOT_FOUND;
		value = RequestedState;
		return OK;
	}
	
	int setRequestedState(const unsigned short& newValue) {
		RequestedState = newValue;
		RequestedState_isNULL = false;
		return OK;
	}

	int getEnabledDefault(unsigned short& value) const {
		if (EnabledDefault_isNULL==true)
			return NOT_FOUND;
		value = EnabledDefault;
		return OK;
	}
	
	int setEnabledDefault(const unsigned short& newValue) {
		EnabledDefault = newValue;
		EnabledDefault_isNULL = false;
		return OK;
	}

	int getTimeOfLastStateChange(string& value) const {
		if (TimeOfLastStateChange_isNULL==true)
			return NOT_FOUND;
		value = TimeOfLastStateChange;
		return OK;
	}
	
	int setTimeOfLastStateChange(const string& newValue) {
		TimeOfLastStateChange = newValue;
		TimeOfLastStateChange_isNULL = false;
		return OK;
	}

	int getAvailableRequestedStates(vector<unsigned short>& value) const {
		if (AvailableRequestedStates_isNULL==true)
			return NOT_FOUND;
		value = AvailableRequestedStates;
		return OK;
	}
	
	int setAvailableRequestedStates(const vector<unsigned short>& newValue) {
		AvailableRequestedStates = newValue;
		AvailableRequestedStates_isNULL = false;
		return OK;
	}

	int getTransitioningToState(unsigned short& value) const {
		if (TransitioningToState_isNULL==true)
			return NOT_FOUND;
		value = TransitioningToState;
		return OK;
	}
	
	int setTransitioningToState(const unsigned short& newValue) {
		TransitioningToState = newValue;
		TransitioningToState_isNULL = false;
		return OK;
	}

	int getSystemCreationClassName(string& value) const {
		if (SystemCreationClassName_isNULL==true)
			return NOT_FOUND;
		value = SystemCreationClassName;
		return OK;
	}
	
	int setSystemCreationClassName(const string& newValue) {
		SystemCreationClassName = newValue;
		SystemCreationClassName_isNULL = false;
		return OK;
	}

	int getSystemName(string& value) const {
		if (SystemName_isNULL==true)
			return NOT_FOUND;
		value = SystemName;
		return OK;
	}
	
	int setSystemName(const string& newValue) {
		SystemName = newValue;
		SystemName_isNULL = false;
		return OK;
	}

	int getCreationClassName(string& value) const {
		if (CreationClassName_isNULL==true)
			return NOT_FOUND;
		value = CreationClassName;
		return OK;
	}
	
	int setCreationClassName(const string& newValue) {
		CreationClassName = newValue;
		CreationClassName_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getUserID(string& value) const {
		if (UserID_isNULL==true)
			return NOT_FOUND;
		value = UserID;
		return OK;
	}
	
	int setUserID(const string& newValue) {
		UserID = newValue;
		UserID_isNULL = false;
		return OK;
	}

	int getObjectClass(vector<string>& value) const {
		if (ObjectClass_isNULL==true)
			return NOT_FOUND;
		value = ObjectClass;
		return OK;
	}
	
	int setObjectClass(const vector<string>& newValue) {
		ObjectClass = newValue;
		ObjectClass_isNULL = false;
		return OK;
	}

	int getDescriptions(vector<string>& value) const {
		if (Descriptions_isNULL==true)
			return NOT_FOUND;
		value = Descriptions;
		return OK;
	}
	
	int setDescriptions(const vector<string>& newValue) {
		Descriptions = newValue;
		Descriptions_isNULL = false;
		return OK;
	}

	int getHost(vector<string>& value) const {
		if (Host_isNULL==true)
			return NOT_FOUND;
		value = Host;
		return OK;
	}
	
	int setHost(const vector<string>& newValue) {
		Host = newValue;
		Host_isNULL = false;
		return OK;
	}

	int getLocalityName(vector<string>& value) const {
		if (LocalityName_isNULL==true)
			return NOT_FOUND;
		value = LocalityName;
		return OK;
	}
	
	int setLocalityName(const vector<string>& newValue) {
		LocalityName = newValue;
		LocalityName_isNULL = false;
		return OK;
	}

	int getOrganizationName(vector<string>& value) const {
		if (OrganizationName_isNULL==true)
			return NOT_FOUND;
		value = OrganizationName;
		return OK;
	}
	
	int setOrganizationName(const vector<string>& newValue) {
		OrganizationName = newValue;
		OrganizationName_isNULL = false;
		return OK;
	}

	int getOU(vector<string>& value) const {
		if (OU_isNULL==true)
			return NOT_FOUND;
		value = OU;
		return OK;
	}
	
	int setOU(const vector<string>& newValue) {
		OU = newValue;
		OU_isNULL = false;
		return OK;
	}

	int getSeeAlso(vector<string>& value) const {
		if (SeeAlso_isNULL==true)
			return NOT_FOUND;
		value = SeeAlso;
		return OK;
	}
	
	int setSeeAlso(const vector<string>& newValue) {
		SeeAlso = newValue;
		SeeAlso_isNULL = false;
		return OK;
	}

	int getUserCertificate(vector<string>& value) const {
		if (UserCertificate_isNULL==true)
			return NOT_FOUND;
		value = UserCertificate;
		return OK;
	}
	
	int setUserCertificate(const vector<string>& newValue) {
		UserCertificate = newValue;
		UserCertificate_isNULL = false;
		return OK;
	}

	int getUserPassword(vector<string>& value) const {
		if (UserPassword_isNULL==true)
			return NOT_FOUND;
		value = UserPassword;
		return OK;
	}
	
	int setUserPassword(const vector<string>& newValue) {
		UserPassword = newValue;
		UserPassword_isNULL = false;
		return OK;
	}

	int getPasswordHistoryDepth(unsigned short& value) const {
		if (PasswordHistoryDepth_isNULL==true)
			return NOT_FOUND;
		value = PasswordHistoryDepth;
		return OK;
	}
	
	int setPasswordHistoryDepth(const unsigned short& newValue) {
		PasswordHistoryDepth = newValue;
		PasswordHistoryDepth_isNULL = false;
		return OK;
	}

	int getPasswordExpiration(string& value) const {
		if (PasswordExpiration_isNULL==true)
			return NOT_FOUND;
		value = PasswordExpiration;
		return OK;
	}
	
	int setPasswordExpiration(const string& newValue) {
		PasswordExpiration = newValue;
		PasswordExpiration_isNULL = false;
		return OK;
	}

	int getComplexPasswordRulesEnforced(vector<unsigned short>& value) const {
		if (ComplexPasswordRulesEnforced_isNULL==true)
			return NOT_FOUND;
		value = ComplexPasswordRulesEnforced;
		return OK;
	}
	
	int setComplexPasswordRulesEnforced(const vector<unsigned short>& newValue) {
		ComplexPasswordRulesEnforced = newValue;
		ComplexPasswordRulesEnforced_isNULL = false;
		return OK;
	}

	int getInactivityTimeout(string& value) const {
		if (InactivityTimeout_isNULL==true)
			return NOT_FOUND;
		value = InactivityTimeout;
		return OK;
	}
	
	int setInactivityTimeout(const string& newValue) {
		InactivityTimeout = newValue;
		InactivityTimeout_isNULL = false;
		return OK;
	}

	int getMaximumSuccessiveLoginFailures(unsigned short& value) const {
		if (MaximumSuccessiveLoginFailures_isNULL==true)
			return NOT_FOUND;
		value = MaximumSuccessiveLoginFailures;
		return OK;
	}
	
	int setMaximumSuccessiveLoginFailures(const unsigned short& newValue) {
		MaximumSuccessiveLoginFailures = newValue;
		MaximumSuccessiveLoginFailures_isNULL = false;
		return OK;
	}

	int getLastLogin(string& value) const {
		if (LastLogin_isNULL==true)
			return NOT_FOUND;
		value = LastLogin;
		return OK;
	}
	
	int setLastLogin(const string& newValue) {
		LastLogin = newValue;
		LastLogin_isNULL = false;
		return OK;
	}

	int getPasswordLastChange(string& value) const {
		if (PasswordLastChange_isNULL==true)
			return NOT_FOUND;
		value = PasswordLastChange;
		return OK;
	}
	
	int setPasswordLastChange(const string& newValue) {
		PasswordLastChange = newValue;
		PasswordLastChange_isNULL = false;
		return OK;
	}

	int getAccountExpiration(string& value) const {
		if (AccountExpiration_isNULL==true)
			return NOT_FOUND;
		value = AccountExpiration;
		return OK;
	}
	
	int setAccountExpiration(const string& newValue) {
		AccountExpiration = newValue;
		AccountExpiration_isNULL = false;
		return OK;
	}

	int getPrimaryGroup(string& value) const {
		if (PrimaryGroup_isNULL==true)
			return NOT_FOUND;
		value = PrimaryGroup;
		return OK;
	}
	
	int setPrimaryGroup(const string& newValue) {
		PrimaryGroup = newValue;
		PrimaryGroup_isNULL = false;
		return OK;
	}

	int getLoginShell(string& value) const {
		if (LoginShell_isNULL==true)
			return NOT_FOUND;
		value = LoginShell;
		return OK;
	}
	
	int setLoginShell(const string& newValue) {
		LoginShell = newValue;
		LoginShell_isNULL = false;
		return OK;
	}

	int getHomeDirectory(string& value) const {
		if (HomeDirectory_isNULL==true)
			return NOT_FOUND;
		value = HomeDirectory;
		return OK;
	}
	
	int setHomeDirectory(const string& newValue) {
		HomeDirectory = newValue;
		HomeDirectory_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Account_RequestStateChange_In {

public:

	unsigned short RequestedState;
	bool RequestedState_isNULL;

	Objectpath Job;
	bool Job_isNULL;

	string TimeoutPeriod;
	bool TimeoutPeriod_isNULL;

	OpenDRIM_Account_RequestStateChange_In() {
		RequestedState_isNULL = true;
		Job_isNULL = true;
		TimeoutPeriod_isNULL = true;
	}

	~OpenDRIM_Account_RequestStateChange_In() {}

	int getRequestedState(unsigned short& value) const {
		if (RequestedState_isNULL == true)
			return NOT_FOUND;
		value = RequestedState;
		return OK;
	}
	int setRequestedState(const unsigned short&  newValue) {
		RequestedState = newValue;
		RequestedState_isNULL = false;
		return OK;
	}

	int getJob(Objectpath& value) const {
		if (Job_isNULL == true)
			return NOT_FOUND;
		value = Job;
		return OK;
	}
	int setJob(const Objectpath&  newValue) {
		Job = newValue;
		Job_isNULL = false;
		return OK;
	}

	int getTimeoutPeriod(string& value) const {
		if (TimeoutPeriod_isNULL == true)
			return NOT_FOUND;
		value = TimeoutPeriod;
		return OK;
	}
	int setTimeoutPeriod(const string&  newValue) {
		TimeoutPeriod = newValue;
		TimeoutPeriod_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Account_RequestStateChange_Out {

public:

	Objectpath Job;
	bool Job_isNULL;

	OpenDRIM_Account_RequestStateChange_Out() {
		Job_isNULL = true;
	}

	~OpenDRIM_Account_RequestStateChange_Out() {}

	int getJob(Objectpath& value) const {
		if (Job_isNULL == true)
			return NOT_FOUND;
		value = Job;
		return OK;
	}
	int setJob(const Objectpath&  newValue) {
		Job = newValue;
		Job_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_ACCOUNT_H_*/
