/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "Common.h"
#include "OpenDRIM_RecordLogPackage_Common.h"

struct monst {
	char name[4];
	int num;
};

static struct monst months[12] = {{"Jan",1},{"Feb",2},{"Mar",3},
                           {"Apr",4},{"May",5},{"Jun",6},
                           {"Jul",7},{"Aug",8},{"Sep",9},
                           {"Oct",10},{"Nov",11},{"Dec",12}};

static bool before(int time_arr[5], struct tm* tp) {
	if (time_arr[0] > tp->tm_mon) {
		return true;
	} 
	else if (time_arr[0] == tp->tm_mon && 
				time_arr[1] > tp->tm_mday)
		return true;
	else if (time_arr[0] == tp->tm_mon && 
				time_arr[1] == tp->tm_mday &&
				time_arr[2] > tp->tm_hour)
		return true;
	else if (time_arr[0] == tp->tm_mon && 
				time_arr[1] == tp->tm_mday &&
				time_arr[2] == tp->tm_hour &&
				time_arr[3] > tp->tm_min)
		return true;
	//Because of the execution time, it can be miscalculated.
/*	else if (time_arr[0] == tp->tm_mon && 
				time_arr[1] == tp->tm_mday &&
				time_arr[2] == tp->tm_hour &&
				time_arr[3] == tp->tm_min &&
				time_arr[5] > tp->tm_sec)
		return true;*/
	
	return false;
}

string CF_logTimeFormat(const string& ptime, struct tm* tp) {
	_E_;
	int year = tp->tm_year + 1900;
	
	vector<string> token;
	CF_splitTextBySpace(token, ptime);
	
	int month;	
	for( unsigned int i=0; i<12; i++ ) {
		if( strcmp(months[i].name, token[0].c_str()) == 0 ) {			
			month = months[i].num;
			break;
		}
	}	
	
	int day = atoi(token[1].c_str());
	
	//hour:min:sec
	int hour, min, sec;
	vector<string> timetoken;
	CF_splitText(timetoken, token[2], ':');
	if (timetoken.size() != 3) {
		//TODO
		//Wrong format
	}
	hour = atoi(timetoken[0].c_str());
	min = atoi(timetoken[1].c_str());
	sec = atoi(timetoken[2].c_str());
		
	//In log message, there is no year of log.
	//To determine the year, it gets the local time.
	//And if the local time's date is smaller than the input time,	
	//The year of input time is regarded as the last year.
	//In the oppoisite case, the current year will be used. 
	int time_arr[] = {month-1, day, hour, min, sec};
	if (before(time_arr, tp))
		--year;
	
	const int DT_LENGTH = 26;
	char resultDateTime[DT_LENGTH];
	short timezone = CF_getCurrentTimeZone();
	snprintf(resultDateTime, DT_LENGTH, 
			"%04d%02d%02d%02d%02d%02d.000000%s%03d", 
			year, month, day, hour, min, sec, 
			(timezone >= 0 ? "+":"-"),
			timezone);

	string result(resultDateTime);
	_L_;
	return result;
}
