/* OGMRipDirac - A plugin for OGMRip adding support for Dirac
 * Copyright (C) 2004-2009 Olivier Rolland <billl@users.sourceforge.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>

#include <ogmrip.h>
#include <ogmjob.h>

#include <ogmrip-lavc.h>

typedef struct _OGMRipDirac OGMRipDirac;
typedef struct _OGMRipDiracClass OGMRipDiracClass;

struct _OGMRipDirac
{
  OGMRipLavc parent_instance;
};

struct _OGMRipDiracClass
{
  OGMRipLavcClass parent_class;
};

static gboolean have_dirac = FALSE;
static gboolean have_schro = FALSE;

G_CONST_RETURN gchar *
ogmrip_dirac_get_codec (void)
{
  if (have_dirac)
    return "libdirac";

  return "libschroedinger";
}

static void
ogmrip_dirac_class_init (OGMRipDiracClass *klass)
{
  OGMRipLavcClass *lavc_class;

  lavc_class = (OGMRipLavcClass *) klass;
  lavc_class->get_codec = ogmrip_dirac_get_codec;
}

static void
ogmrip_dirac_init (OGMRipDirac *nouveau)
{
}

G_DEFINE_TYPE (OGMRipDirac, ogmrip_dirac, OGMRIP_TYPE_LAVC)

static OGMRipVideoPlugin dirac_plugin =
{
  NULL,
  G_TYPE_NONE,
  "dirac",
  N_("Dirac"),
  OGMRIP_FORMAT_DIRAC,
  1,
  1
};

OGMRipVideoPlugin *
ogmrip_init_plugin (GError **error)
{
  gchar *output, *str;

  g_return_val_if_fail (error == NULL || *error == NULL, NULL);

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif /* ENABLE_NLS */

  if (!ogmrip_check_mencoder ())
  {
    g_set_error (error, OGMRIP_PLUGIN_ERROR, OGMRIP_PLUGIN_ERROR_REQ, _("MEncoder is missing"));
    return NULL;
  }

  if (!g_spawn_command_line_sync (MPLAYER_CHECK_VERSION (1,0,3,0) ?
        "mplayer -noconfig all -vc help" : "mplayer -vc help", &output, &str, NULL, NULL))
  {
    g_set_error (error, OGMRIP_PLUGIN_ERROR, OGMRIP_PLUGIN_ERROR_REQ, _("MPlayer is missing"));
    return NULL;
  }

  if (str)
    g_free (str);

  have_dirac = g_regex_match_simple ("^fflibdirac", output, G_REGEX_MULTILINE, 0);
  if (!have_dirac)
    have_schro = g_regex_match_simple ("^fflibschroedinger", output, G_REGEX_MULTILINE, 0);

  g_free (output);

  if (!have_dirac && !have_schro)
    return NULL;

  dirac_plugin.type = ogmrip_dirac_get_type ();

  return &dirac_plugin;
}

