#ifndef __MIXSPINLOCK_H
#define __MIXSPINLOCK_H

#ifdef KERNEL
#  error "This module for user mode apps. Kernel module use synonym header" 
#endif

typedef struct _mspinlock {
	volatile __s32 lock;
} mspinlock_t;

static inline void mspin_lock (mspinlock_t *lock) {
	__asm__ __volatile__(
		"1:\n"
		"\tlock; decl %0\n"
		"\tjns 3f\n\n"
		"2:\n"
		/*"\t\trep; nop\n"*/
		"\t\tpause\n"
		"\tcmpl $0,%0\n"
		"\tjle 2b\n"
		"jmp 1b\n"
		"3:"
		:"=m" (lock->lock) : : "memory"
	);
}

static inline void mspin_unlock (mspinlock_t *lock) {
	__asm__ __volatile__(
		"movl $0x1, %0"
		:"=m" (lock->lock) : : "memory"
	);
}

#endif
