/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class PropertyPath {
    private List pathInfo = new LinkedList();

    public PropertyPath() {
    }

    public PropertyPath(PropertyPath propertyPath) {
        this.pathInfo.addAll(propertyPath.pathInfo);
    }

    public PropertyPath(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.pathInfo.add(stringArray[i]);
        }
    }

    public void addPropertyName(String string) {
        this.pathInfo.add(string);
    }

    public void addPropertyKey(Object object) {
        this.pathInfo.add(new PropertyKey(object));
    }

    public void addPropertyIndex(int n) {
        this.pathInfo.add(new Integer(n));
    }

    public Property locateProperty(RepInfo repInfo) {
        return this.locateProperty(repInfo, false);
    }

    public Property locateProperty(RepInfo repInfo, boolean bl) {
        Property property;
        if (this.pathInfo.isEmpty()) {
            if (bl) {
                System.out.println("Empty property path");
            }
            return null;
        }
        Object e = this.pathInfo.get(0);
        if (!(e instanceof String)) {
            if (bl) {
                System.out.println("Not a property name");
            }
            return null;
        }
        String string = (String)e;
        if (bl) {
            System.out.println("Getting proprerty " + string);
        }
        if ((property = repInfo.getProperty(string)) == null) {
            if (bl) {
                System.out.println("Property is null");
            }
            return null;
        }
        int n = this.pathInfo.size();
        return this.locateSubProperty(property, this.pathInfo.subList(1, n), bl);
    }

    private Property locateSubProperty(Property property, List list, boolean bl) {
        if (list.isEmpty()) {
            return property;
        }
        List list2 = list.subList(1, list.size());
        PropertyArity propertyArity = property.getArity();
        PropertyType propertyType = property.getType();
        Object object = property.getValue();
        if (bl) {
            System.out.println("Property arity = " + propertyArity + ", type = " + propertyType);
        }
        if (propertyType != PropertyType.PROPERTY) {
            if (bl) {
                System.out.println("Not a property, type is " + propertyType.toString());
            }
            return null;
        }
        Object e = list.get(0);
        if (e instanceof String) {
            String string = (String)e;
            if (bl) {
                System.out.println("Looking for subproperty " + string + " arity= " + propertyArity.toString());
            }
            if (propertyArity.equals(PropertyArity.SCALAR)) {
                Property property2 = (Property)property.getValue();
                if (property2.getName().equals(string)) {
                    return this.locateSubProperty(property2, list2, bl);
                }
                return null;
            }
            if (propertyArity.equals(PropertyArity.ARRAY)) {
                Property[] propertyArray = (Property[])object;
                for (int i = 0; i < propertyArray.length; ++i) {
                    Property property3 = propertyArray[i];
                    if (!property3.getName().equals(string)) continue;
                    return this.locateSubProperty(property3, list2, bl);
                }
                return null;
            }
            if (propertyArity.equals(PropertyArity.LIST)) {
                ListIterator listIterator = ((List)object).listIterator();
                return this.getIteratedSubProperty(listIterator, string, list2, bl);
            }
            if (propertyArity.equals(PropertyArity.SET)) {
                Iterator iterator = ((Set)object).iterator();
                return this.getIteratedSubProperty(iterator, string, list2, bl);
            }
            if (propertyArity.equals(PropertyArity.MAP)) {
                Iterator iterator = ((Map)object).values().iterator();
                return this.getIteratedSubProperty(iterator, string, list2, bl);
            }
            return null;
        }
        if (e instanceof Integer) {
            int n = (Integer)e;
            if (propertyArity.equals(PropertyArity.LIST)) {
                List list3 = (List)object;
                return this.locateSubProperty((Property)list3.get(n), list2, bl);
            }
            if (propertyArity.equals(PropertyArity.ARRAY)) {
                Property[] propertyArray = (Property[])object;
                return this.locateSubProperty(propertyArray[n], list2, bl);
            }
            return null;
        }
        if (e instanceof PropertyKey) {
            if (propertyArity != PropertyArity.MAP) {
                return null;
            }
            return null;
        }
        return null;
    }

    private Property getIteratedSubProperty(Iterator iterator, String string, List list, boolean bl) {
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.getName().equals(string)) continue;
            return this.locateSubProperty(property, list, bl);
        }
        return null;
    }

    private class PropertyKey {
        public Object key;

        public PropertyKey(Object object) {
            this.key = object;
        }
    }
}

