/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JTable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.data.TableCell;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Strings;

final class JTableMatchingCellQuery {
    @RunsInEDT
    static TableCell cellWithValue(final JTable table, final TextMatcher matcher, final JTableCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<TableCell>(){

            @Override
            protected TableCell executeInEDT() {
                return JTableMatchingCellQuery.findMatchingCell(table, matcher, cellReader);
            }
        });
    }

    @RunsInCurrentThread
    private static TableCell findMatchingCell(JTable table, TextMatcher matcher, JTableCellReader cellReader) {
        int rCount = table.getRowCount();
        int cCount = table.getColumnCount();
        for (int r = 0; r < rCount; ++r) {
            for (int c = 0; c < cCount; ++c) {
                if (!JTableMatchingCellQuery.cellHasValue(table, r, c, matcher, cellReader)) continue;
                return TableCell.row(r).column(c);
            }
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to find cell matching ", matcher.description(), " ", matcher.formattedValues()}));
    }

    @RunsInCurrentThread
    private static boolean cellHasValue(JTable table, int row, int column, TextMatcher matcher, JTableCellReader cellReader) {
        return matcher.isMatching(cellReader.valueAt(table, row, column));
    }

    private JTableMatchingCellQuery() {
    }
}

