/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.metal.MetalUtils;
import com.jidesoft.swing.TristateButtonModel;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class MetalIconFactory
implements Serializable {
    private static Icon checkBoxIcon;

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        private void paintOceanIcon(Component component, Graphics graphics, int n, int n2) {
            ButtonModel buttonModel = ((JCheckBox)component).getModel();
            graphics.translate(n, n2);
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    graphics.setColor(MetalLookAndFeel.getControlShadow());
                    graphics.fillRect(0, 0, n3, n4);
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.fillRect(0, 0, n3, 2);
                    graphics.fillRect(0, 2, 2, n4 - 2);
                    graphics.fillRect(n3 - 1, 1, 1, n4 - 1);
                    graphics.fillRect(1, n4 - 1, n3 - 2, 1);
                } else if (buttonModel.isRollover()) {
                    MetalUtils.drawGradient(component, graphics, "CheckBox.gradient", 0, 0, n3, n4, true);
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawRect(1, 1, n3 - 3, n4 - 3);
                    graphics.drawRect(2, 2, n3 - 5, n4 - 5);
                } else {
                    MetalUtils.drawGradient(component, graphics, "CheckBox.gradient", 0, 0, n3, n4, true);
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                }
                graphics.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            }
            graphics.translate(-n, -n2);
            if (buttonModel instanceof TristateButtonModel && ((TristateButtonModel)buttonModel).isMixed()) {
                this.drawSquare(component, graphics, n, n2);
            } else if (buttonModel.isSelected()) {
                this.drawCheck(component, graphics, n, n2);
            }
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                this.paintOceanIcon(component, graphics, n, n2);
                return;
            }
            ButtonModel buttonModel = ((JCheckBox)component).getModel();
            int n3 = this.getControlSize();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    graphics.setColor(MetalLookAndFeel.getControlShadow());
                    graphics.fillRect(n, n2, n3 - 1, n3 - 1);
                    MetalUtils.drawPressed3DBorder(graphics, n, n2, n3, n3);
                } else {
                    MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n3);
                }
                graphics.setColor(component.getForeground());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(n, n2, n3 - 2, n3 - 2);
            }
            if (buttonModel instanceof TristateButtonModel && ((TristateButtonModel)buttonModel).isMixed()) {
                this.drawSquare(component, graphics, n, n2);
            } else if (buttonModel.isSelected()) {
                this.drawCheck(component, graphics, n, n2);
            }
        }

        protected void drawCheck(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getControlSize();
            graphics.fillRect(n + 3, n2 + 5, 2, n3 - 8);
            graphics.drawLine(n + (n3 - 4), n2 + 3, n + 5, n2 + (n3 - 6));
            graphics.drawLine(n + (n3 - 4), n2 + 4, n + 5, n2 + (n3 - 5));
        }

        protected void drawSquare(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getControlSize();
            graphics.fillRect(n + 3, n2 + 3, n3 - 6, n3 - 6);
        }

        @Override
        public int getIconWidth() {
            return this.getControlSize();
        }

        @Override
        public int getIconHeight() {
            return this.getControlSize();
        }
    }
}

