/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.io;

import java.io.DataOutput;
import java.io.IOException;

final class RuntimeDataOutput {
    private final DataOutput dataOutput;

    public RuntimeDataOutput(DataOutput dataOutput) {
        this.dataOutput = dataOutput;
    }

    public void write(byte[] byArray) {
        try {
            this.dataOutput.write(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        try {
            this.dataOutput.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void write(int n) {
        try {
            this.dataOutput.write(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void writeBoolean(boolean bl) {
        try {
            this.dataOutput.writeBoolean(bl);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void writeByte(int n) {
        try {
            this.dataOutput.writeByte(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void writeBytes(String string) {
        try {
            this.dataOutput.writeBytes(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void writeChar(int n) {
        try {
            this.dataOutput.writeChar(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void writeChars(String string) {
        try {
            this.dataOutput.writeChars(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void writeDouble(double d) {
        try {
            this.dataOutput.writeDouble(d);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void writeFloat(float f) {
        try {
            this.dataOutput.writeFloat(f);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void writeInt(int n) {
        try {
            this.dataOutput.writeInt(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void writeLong(long l) {
        try {
            this.dataOutput.writeLong(l);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void writeUnsignedShort(int n) {
        if ((n & 0xFFFF) != n) {
            throw new IllegalArgumentException("Overflow of unsigned short value [" + n + "]");
        }
        this.writeShort(n);
    }

    public void writeSignedShort(int n) {
        if ((short)n != n) {
            throw new IllegalArgumentException("Overflow of signed short value [" + n + "]");
        }
        this.writeShort(n);
    }

    public void writeShort(int n) {
        try {
            this.dataOutput.writeShort(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void writeUTF(String string) {
        try {
            this.dataOutput.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }
}

