/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.CollationURIResolver;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;

public class StandardCollationURIResolver
implements CollationURIResolver {
    private static final StandardCollationURIResolver theInstance = new StandardCollationURIResolver();

    public static StandardCollationURIResolver getInstance() {
        return theInstance;
    }

    public StringCollator resolve(String uri, String base, Configuration config) {
        try {
            if (uri.equals("http://saxon.sf.net/collation")) {
                return Configuration.getPlatform().makeCollation(config, new Properties(), uri);
            }
            if (uri.startsWith("http://saxon.sf.net/collation?")) {
                URI uuri;
                try {
                    uuri = new URI(uri);
                }
                catch (URISyntaxException err) {
                    throw new XPathException(err);
                }
                Properties props = new Properties();
                String query = uuri.getRawQuery();
                StringTokenizer queryTokenizer = new StringTokenizer(query, ";&");
                while (queryTokenizer.hasMoreElements()) {
                    String param = queryTokenizer.nextToken();
                    int eq = param.indexOf(61);
                    if (eq <= 0 || eq >= param.length() - 1) continue;
                    String kw = param.substring(0, eq);
                    String val = StandardCollationURIResolver.decode(param.substring(eq + 1));
                    props.setProperty(kw, val);
                }
                return Configuration.getPlatform().makeCollation(config, props, uri);
            }
            return null;
        }
        catch (XPathException e) {
            try {
                config.getErrorListener().warning(e);
            }
            catch (TransformerException e1) {
                // empty catch block
            }
            return null;
        }
    }

    public static String decode(String s) {
        if (s == null) {
            return s;
        }
        int n = s.length();
        if (n == 0) {
            return s;
        }
        if (s.indexOf(37) < 0) {
            return s;
        }
        FastStringBuffer sb = new FastStringBuffer(n);
        ByteBuffer bb = ByteBuffer.allocate(n);
        Charset utf8 = Charset.forName("UTF-8");
        char c = s.charAt(0);
        boolean betweenBrackets = false;
        int i = 0;
        while (i < n) {
            assert (c == s.charAt(i));
            if (c == '[') {
                betweenBrackets = true;
            } else if (betweenBrackets && c == ']') {
                betweenBrackets = false;
            }
            if (c != '%' || betweenBrackets) {
                sb.append(c);
                if (++i >= n) break;
                c = s.charAt(i);
                continue;
            }
            bb.clear();
            do {
                assert (n - i >= 2);
                bb.put(StandardCollationURIResolver.hex(s.charAt(++i), s.charAt(++i)));
            } while (++i < n && (c = s.charAt(i)) == '%');
            bb.flip();
            sb.append(utf8.decode(bb));
        }
        return sb.toString();
    }

    private static byte hex(char high, char low) {
        return (byte)(StandardCollationURIResolver.hexToDec(high) << 4 | StandardCollationURIResolver.hexToDec(low));
    }

    private static int hexToDec(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 0;
    }
}

