/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_WCL.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgi_wrClose(int rv);

	Close writeble user INI, leave write state.

	The passed "rv" return value specifies, if the written contents
	shall replace (== CFG_ERR_NONE) the current usr INI file, or
	if the temporary file is to be ignored (all other cases). If
	the user INI file is replaced, NO cfgReset() is performed.

	If rv == CFG_ERR_ALREADY open --> this call is ignored completely.

	Return: cfg error code (based upon the passed rv)

ob: cfgi_wrClose
ty: L
su: inifile/2
sh: Close the INI file opened for writing
lo: Leaves the pending write state.\par
	The specified error number instructs this function, whether the INI file
	should be successfully close or not. On success, the newly generated
	INI file replaces the user INI file; otherwise the changes are lost.\par
	If \para{rv} == CFG_ERR_ALREADY {multiple calls to cfgInitINI()}, this
	function performs no action at all.
re: cfgi_wrOpen
va: a newly generated cfg error number
	\item: else: \para{rv}
fi: cfgi_wcl.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"
#include "dynstr.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_WCL.C 1.4 2001/02/27 01:27:58 ska Exp ska $";
#endif

int cfgi_wrClose(int rv)
{
	DBG_ENTER("cfgi_wrClose", Suppl_inifile2)
	DBG_ARGUMENTS( ("rv=%d", rv) )

redo:
	chkHeap
	if(rv != CFG_ERR_ALREADY) {		/* already open --> ignore */
		if(rv == CFG_ERR_NONE) {		/* all OK --> use the new INI file */
			chkHeap
			if(I(writeOpen) == CFG_WSECTION) {		/* append the remaining
						sections, behind the opened one */
				CFGI_NXTLINE
				putc('\n', cfgi_ini);

				if((rv = cfgi_copyallfrom(aS(I(writePos)))) != CFG_ERR_NONE)
					goto redo;
			}

			chkHeap
			++I(modifications);			/* indicate that this INI file was
											modified */
			chkHeap
			cfgCreateCloseINI();
			I(writeOpen) = CFG_WNONE;	/* prevent from recursive enter */
			chkHeap
			cfgReset();
			chkHeap
			cfgDynOpenSection(I(wrSection));
			chkHeap
			I(wrSection) = 0;
			chkHeap
		} else {						/* throw away the changes */
			chkHeap
			cfgCreateIgnoreINI();
			chkHeap
			I(writeOpen) = CFG_WNONE;	/* prevent from recursive enter */
			StrFree(I(wrSection));
		}
	}

	chkHeap
	DBG_RETURN_I( rv)
}
