/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_CFS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void cfgi_clFileStru(inifstru *f);

	Closes an INI file structure.

	May contain an unopened file.

	Any values are overwritten with zero.

ob: cfgi_clfileStru
ty: LH
su: inifile/2
sh: Close an INI file structure
lo: Closes (frees / deallocates) and invalidates the all members of a single INI file structure
	\tok{inifstru}. If the structure does not contain an \em{opened} INI
	file, all members must be initialized by \tok{NULL}.
re: 
fi: cfgi_cfs.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdlib.h>
#endif
#include "inifile.loc"
#include "supplio.h"
#include "str.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_CFS.C 1.3 1999/12/13 02:22:10 ska Exp ska $";
#endif

void cfgi_clFileStru(inifstru *f)
{	DBG_ENTER("cfgi_clFileStru", Suppl_inifile2)

	assert(f);

	chkHeap
	free(f->cfgi_fnam);
	chkHeap
	Fyclose(f->cfgi_fp);
	chkHeap
	memzero(f, sizeof(inifstru));
	chkHeap

	DBG_EXIT
}
