/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFormatUtils {
    private static TemplateChunk appendString(ArrayList<TemplateChunk> chunks, TemplateChunk curChunk, String string) {
        if (curChunk != null && !curChunk.isLiteral()) {
            chunks.add(curChunk);
            curChunk = null;
        }
        if (curChunk == null) {
            curChunk = new StringChunk(string);
        } else {
            ((StringChunk)curChunk).append(string);
        }
        return curChunk;
    }

    private static String parseFormatArgs(String format, Map<String, String> formatArgs) {
        int colon = format.indexOf(58);
        if (colon >= 0) {
            for (String tagValue : format.substring(colon + 1).split(":")) {
                int equals = tagValue.indexOf(61);
                String value = "";
                if (equals >= 0) {
                    value = tagValue.substring(equals + 1).trim();
                    tagValue = tagValue.substring(0, equals);
                }
                formatArgs.put(tagValue.trim(), value);
            }
            format = format.substring(0, colon);
        }
        return format;
    }

    public static class VisitorAbortException
    extends Exception {
        public VisitorAbortException(String reason) {
            super(reason);
        }

        public VisitorAbortException(String reason, Throwable cause) {
            super(reason, cause);
        }

        public VisitorAbortException(Throwable cause) {
            super(cause.getMessage(), cause);
        }
    }

    public static interface TemplateChunkVisitor {
        public void visit(ArgumentChunk var1) throws VisitorAbortException;

        public void visit(StaticArgChunk var1) throws VisitorAbortException;

        public void visit(StringChunk var1) throws VisitorAbortException;
    }

    public static abstract class TemplateChunk {
        protected static String quoteMessageFormatChars(String str) {
            str = str.replace("'", "''");
            str = str.replace("{", "'{'");
            str = str.replace("}", "'}'");
            return str;
        }

        protected static String quoteMessageFormatChars(String str, boolean quote) {
            return quote ? TemplateChunk.quoteMessageFormatChars(str) : str;
        }

        public abstract void accept(TemplateChunkVisitor var1) throws VisitorAbortException;

        public String getAsMessageFormatString() {
            return this.getStringValue(true);
        }

        public String getString() {
            return this.getStringValue(false);
        }

        public boolean isLiteral() {
            return false;
        }

        protected abstract String getStringValue(boolean var1);
    }

    public static class StringChunk
    extends TemplateChunk {
        private StringBuilder buf = new StringBuilder();

        public StringChunk() {
        }

        public StringChunk(String str) {
            this.buf.append(str);
        }

        public void accept(TemplateChunkVisitor visitor) throws VisitorAbortException {
            visitor.visit(this);
        }

        public void append(String str) {
            this.buf.append(str);
        }

        public boolean isLiteral() {
            return true;
        }

        public String toString() {
            return "StringLiteral: \"" + this.buf.toString() + "\"";
        }

        protected String getStringValue(boolean quote) {
            String str = this.buf.toString();
            return StringChunk.quoteMessageFormatChars(str, quote);
        }
    }

    public static class StaticArgChunk
    extends TemplateChunk {
        private final String argName;
        private final String replacement;

        public StaticArgChunk(String argName, String replacement) {
            this.argName = argName;
            this.replacement = replacement;
        }

        public void accept(TemplateChunkVisitor visitor) throws VisitorAbortException {
            visitor.visit(this);
        }

        public String getArgName() {
            return this.argName;
        }

        public String getReplacement() {
            return this.replacement;
        }

        protected String getStringValue(boolean quoted) {
            StringBuilder buf = new StringBuilder();
            buf.append('{').append(this.argName).append(',');
            buf.append(StaticArgChunk.quoteMessageFormatChars(this.replacement, quoted));
            buf.append('}');
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageStyle {
        PLAIN{

            @Override
            public String assemble(List<TemplateChunk> message) throws VisitorAbortException {
                final StringBuilder buf = new StringBuilder();
                DefaultTemplateChunkVisitor visitor = new DefaultTemplateChunkVisitor(){

                    public void visit(ArgumentChunk argChunk) throws VisitorAbortException {
                        throw new VisitorAbortException("Argument in Plain message");
                    }

                    public void visit(StaticArgChunk argChunk) throws VisitorAbortException {
                        buf.append(argChunk.getString());
                    }

                    public void visit(StringChunk stringChunk) throws VisitorAbortException {
                        buf.append(stringChunk.getString());
                    }
                };
                for (TemplateChunk chunk : message) {
                    chunk.accept(visitor);
                }
                return buf.toString();
            }

            @Override
            public List<TemplateChunk> parse(String template) throws ParseException {
                return Arrays.asList(new StringChunk(template));
            }
        }
        ,
        MESSAGE_FORMAT{

            @Override
            public String assemble(List<TemplateChunk> message) {
                StringBuilder buf = new StringBuilder();
                for (TemplateChunk part : message) {
                    buf.append(part.getAsMessageFormatString());
                }
                return buf.toString();
            }

            @Override
            public List<TemplateChunk> parse(String template) throws ParseException {
                int curPos = 0;
                boolean inQuote = false;
                int templateLen = template.length();
                ArrayList<TemplateChunk> chunks = new ArrayList<TemplateChunk>();
                TemplateChunk curChunk = null;
                block8: while (curPos < templateLen) {
                    char ch = template.charAt(curPos++);
                    switch (ch) {
                        case '\'': {
                            if (curPos < templateLen && template.charAt(curPos) == '\'') {
                                curChunk = MessageFormatUtils.appendString(chunks, curChunk, "'");
                                ++curPos;
                                continue block8;
                            }
                            inQuote = !inQuote;
                            continue block8;
                        }
                        case '{': {
                            if (inQuote) {
                                curChunk = MessageFormatUtils.appendString(chunks, curChunk, "{");
                                continue block8;
                            }
                            StringBuilder argBuf = new StringBuilder();
                            boolean argQuote = false;
                            while (curPos < templateLen) {
                                if ((ch = template.charAt(curPos++)) == '\'') {
                                    if (curPos < templateLen && template.charAt(curPos) == '\'') {
                                        argBuf.append(ch);
                                        ++curPos;
                                        continue;
                                    }
                                    argQuote = !argQuote;
                                    continue;
                                }
                                if (!argQuote && ch == '}') break;
                                argBuf.append(ch);
                            }
                            if (ch != '}') {
                                throw new ParseException("Invalid message format - { not start of valid argument" + template, curPos);
                            }
                            if (curChunk != null) {
                                chunks.add(curChunk);
                            }
                            String arg = argBuf.toString();
                            int firstComma = arg.indexOf(44);
                            String format = null;
                            if (firstComma > 0) {
                                format = arg.substring(firstComma + 1);
                                arg = arg.substring(0, firstComma);
                            }
                            if (!Character.isDigit(arg.charAt(0))) {
                                chunks.add(new StaticArgChunk(arg, format));
                            } else {
                                int argNumber = Integer.valueOf(arg);
                                HashMap<String, String> formatArgs = new HashMap<String, String>();
                                HashMap<String, String> listArgs = null;
                                String subFormat = null;
                                if (format != null) {
                                    int comma = format.indexOf(44);
                                    if (comma >= 0) {
                                        subFormat = format.substring(comma + 1);
                                        format = format.substring(0, comma);
                                    }
                                    if ("list".equals(format = MessageFormatUtils.parseFormatArgs(format, formatArgs))) {
                                        listArgs = formatArgs;
                                        formatArgs = new HashMap();
                                        format = subFormat;
                                        subFormat = null;
                                        if (format != null) {
                                            comma = format.indexOf(44);
                                            if (comma >= 0) {
                                                subFormat = format.substring(comma + 1);
                                                format = format.substring(0, comma);
                                            }
                                            format = MessageFormatUtils.parseFormatArgs(format, formatArgs);
                                        }
                                    }
                                }
                                chunks.add(new ArgumentChunk(argNumber, listArgs, format, formatArgs, subFormat));
                            }
                            curChunk = null;
                            continue block8;
                        }
                        case '\n': {
                            curChunk = MessageFormatUtils.appendString(chunks, curChunk, "\\n");
                            continue block8;
                        }
                        case '\r': {
                            curChunk = MessageFormatUtils.appendString(chunks, curChunk, "\\r");
                            continue block8;
                        }
                        case '\\': {
                            curChunk = MessageFormatUtils.appendString(chunks, curChunk, "\\\\");
                            continue block8;
                        }
                        case '\"': {
                            curChunk = MessageFormatUtils.appendString(chunks, curChunk, "\\\"");
                            continue block8;
                        }
                    }
                    curChunk = MessageFormatUtils.appendString(chunks, curChunk, String.valueOf(ch));
                }
                if (inQuote) {
                    throw new ParseException("Unterminated single quote: " + template, template.length());
                }
                if (curChunk != null) {
                    chunks.add(curChunk);
                }
                return chunks;
            }
        };


        public abstract String assemble(List<TemplateChunk> var1) throws VisitorAbortException;

        public abstract List<TemplateChunk> parse(String var1) throws ParseException;

        public void parseAccept(String template, TemplateChunkVisitor visitor) throws ParseException, VisitorAbortException {
            for (TemplateChunk chunk : this.parse(template)) {
                chunk.accept(visitor);
            }
        }
    }

    public static class DefaultTemplateChunkVisitor
    implements TemplateChunkVisitor {
        public void visit(ArgumentChunk argChunk) throws VisitorAbortException {
        }

        public void visit(StaticArgChunk staticArgChunk) throws VisitorAbortException {
        }

        public void visit(StringChunk stringChunk) throws VisitorAbortException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArgumentChunk
    extends TemplateChunk {
        private final int argNumber;
        private final String format;
        private final Map<String, String> formatArgs;
        private final String subFormat;
        private final Map<String, String> listArgs;

        public ArgumentChunk(int argNumber, Map<String, String> listArgs, String format, Map<String, String> formatArgs, String subformat) {
            this.argNumber = argNumber;
            this.format = format;
            this.subFormat = subformat;
            this.listArgs = listArgs;
            this.formatArgs = formatArgs;
        }

        @Override
        public void accept(TemplateChunkVisitor visitor) throws VisitorAbortException {
            visitor.visit(this);
        }

        public int getArgumentNumber() {
            return this.argNumber;
        }

        public String getFormat() {
            return this.format;
        }

        public Map<String, String> getFormatArgs() {
            return this.formatArgs;
        }

        public Map<String, String> getListArgs() {
            return this.listArgs;
        }

        public String getSubFormat() {
            return this.subFormat;
        }

        public boolean isList() {
            return this.listArgs != null;
        }

        public String toString() {
            return "Argument: #=" + this.argNumber + ", format=" + this.format + ", subformat=" + this.subFormat;
        }

        @Override
        protected String getStringValue(boolean quote) {
            StringBuilder buf = new StringBuilder();
            buf.append('{');
            buf.append(this.argNumber);
            Map<String, String> map = this.listArgs;
            if (map != null) {
                buf.append(",list");
                this.appendArgs(buf, map, quote);
            }
            if (this.format != null || this.subFormat != null) {
                buf.append(',');
            }
            if (this.format != null) {
                buf.append(ArgumentChunk.quoteMessageFormatChars(this.format, quote));
                this.appendArgs(buf, this.formatArgs, quote);
            }
            if (this.subFormat != null) {
                buf.append(',');
                buf.append(this.subFormat);
            }
            buf.append('}');
            return buf.toString();
        }

        private void appendArgs(StringBuilder buf, Map<String, String> map, boolean quote) {
            int prefix = 58;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                if (quote) {
                    key = ArgumentChunk.quoteMessageFormatChars(key);
                }
                buf.append((char)prefix).append(key);
                String value = entry.getValue();
                if (value != null) {
                    if (quote) {
                        value = ArgumentChunk.quoteMessageFormatChars(value);
                    }
                    buf.append('=').append(value);
                }
                prefix = 44;
            }
        }
    }
}

