/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "byn" locale.
 */
public class LocalizedNamesImpl_byn extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "AG",
        "AI",
        "AO",
        "AQ",
        "AS",
        "AW",
        "AX",
        "BD",
        "BF",
        "BI",
        "BJ",
        "BL",
        "BN",
        "BS",
        "BV",
        "BW",
        "CA",
        "CC",
        "CG",
        "CI",
        "CK",
        "CP",
        "CR",
        "CU",
        "CX",
        "DG",
        "DJ",
        "EA",
        "EU",
        "FK",
        "FO",
        "GA",
        "GD",
        "GG",
        "GH",
        "GI",
        "GL",
        "GP",
        "GS",
        "GT",
        "GU",
        "HM",
        "HN",
        "IC",
        "IM",
        "IO",
        "IR",
        "JE",
        "KE",
        "KG",
        "KI",
        "KN",
        "KY",
        "KZ",
        "LA",
        "LC",
        "LI",
        "LK",
        "LR",
        "LS",
        "LU",
        "MC",
        "ME",
        "MF",
        "MG",
        "MH",
        "ML",
        "MM",
        "MP",
        "MQ",
        "MS",
        "MV",
        "MW",
        "MZ",
        "NE",
        "NF",
        "NI",
        "NR",
        "NU",
        "OM",
        "PA",
        "PH",
        "PK",
        "PM",
        "PN",
        "PS",
        "PT",
        "PW",
        "PY",
        "QA",
        "QO",
        "RE",
        "RS",
        "RW",
        "SB",
        "SC",
        "SH",
        "SJ",
        "SL",
        "SM",
        "SR",
        "ST",
        "SV",
        "SZ",
        "TA",
        "TC",
        "TG",
        "TK",
        "TM",
        "TO",
        "TV",
        "TW",
        "UA",
        "UM",
        "UY",
        "VA",
        "VC",
        "VN",
        "VU",
        "WF",
        "WS",
        "YT",
        "ZW",
        "HU",
        "HT",
        "IN",
        "HK",
        "LY",
        "LB",
        "LT",
        "LV",
        "FM",
        "MY",
        "MT",
        "MU",
        "MK",
        "MO",
        "MX",
        "TL",
        "EH",
        "MD",
        "MR",
        "MA",
        "MN",
        "RU",
        "RO",
        "KR",
        "CS",
        "SO",
        "SD",
        "SY",
        "SG",
        "SA",
        "CY",
        "SN",
        "SK",
        "SI",
        "CH",
        "SE",
        "ES",
        "BT",
        "BG",
        "GW",
        "BH",
        "BB",
        "BZ",
        "BY",
        "BE",
        "BM",
        "BR",
        "BO",
        "BA",
        "VE",
        "TR",
        "TN",
        "TZ",
        "TH",
        "TJ",
        "TT",
        "CL",
        "CN",
        "TD",
        "CZ",
        "NC",
        "NZ",
        "NA",
        "NG",
        "NL",
        "AN",
        "NP",
        "NO",
        "AL",
        "DZ",
        "US",
        "AM",
        "AR",
        "AD",
        "AU",
        "AZ",
        "IE",
        "IS",
        "IQ",
        "ET",
        "ID",
        "GQ",
        "EC",
        "ER",
        "EE",
        "IL",
        "GB",
        "AT",
        "CM",
        "KH",
        "CV",
        "HR",
        "KW",
        "CO",
        "KM",
        "CD",
        "ZM",
        "YE",
        "CF",
        "AE",
        "VI",
        "VG",
        "TF",
        "GF",
        "PF",
        "UZ",
        "UG",
        "ZA",
        "KP",
        "DK",
        "DM",
        "DO",
        "DE",
        "JM",
        "JP",
        "JO",
        "GE",
        "GY",
        "GN",
        "GM",
        "GR",
        "EG",
        "IT",
        "FR",
        "FI",
        "FJ",
        "PG",
        "PE",
        "PL",
        "PR",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "አንዶራ");
    namesMap.put("AE", "የተባበሩት አረብ ኤምሬትስ");
    namesMap.put("AL", "አልባኒያ");
    namesMap.put("AM", "አርሜኒያ");
    namesMap.put("AN", "ኔዘርላንድስ አንቲልስ");
    namesMap.put("AR", "አርጀንቲና");
    namesMap.put("AT", "ኦስትሪያ");
    namesMap.put("AU", "አውስትሬሊያ");
    namesMap.put("AZ", "አዘርባጃን");
    namesMap.put("BA", "ቦስኒያ እና ሄርዞጎቪኒያ");
    namesMap.put("BB", "ባርቤዶስ");
    namesMap.put("BE", "ቤልጄም");
    namesMap.put("BG", "ቡልጌሪያ");
    namesMap.put("BH", "ባህሬን");
    namesMap.put("BM", "ቤርሙዳ");
    namesMap.put("BO", "ቦሊቪያ");
    namesMap.put("BR", "ብራዚል");
    namesMap.put("BT", "ቡህታን");
    namesMap.put("BY", "ቤላሩስ");
    namesMap.put("BZ", "ቤሊዘ");
    namesMap.put("CD", "ኮንጎ");
    namesMap.put("CF", "የመካከለኛው አፍሪካ ሪፐብሊክ");
    namesMap.put("CH", "ስዊዘርላንድ");
    namesMap.put("CL", "ቺሊ");
    namesMap.put("CM", "ካሜሩን");
    namesMap.put("CN", "ቻይና");
    namesMap.put("CO", "ኮሎምቢያ");
    namesMap.put("CS", "ሰርቢያ");
    namesMap.put("CV", "ኬፕ ቬርዴ");
    namesMap.put("CY", "ሳይፕረስ");
    namesMap.put("CZ", "ቼክ ሪፑብሊክ");
    namesMap.put("DE", "ጀርመን");
    namesMap.put("DK", "ዴንማርክ");
    namesMap.put("DM", "ዶሚኒካ");
    namesMap.put("DO", "ዶሚኒክ ሪፑብሊክ");
    namesMap.put("DZ", "አልጄሪያ");
    namesMap.put("EC", "ኢኳዶር");
    namesMap.put("EE", "ኤስቶኒያ");
    namesMap.put("EG", "ግብጽ");
    namesMap.put("EH", "ምዕራባዊ ሳህራ");
    namesMap.put("ER", "ኤርትራ");
    namesMap.put("ES", "ስፔን");
    namesMap.put("ET", "ኢትዮጵያ");
    namesMap.put("FI", "ፊንላንድ");
    namesMap.put("FJ", "ፊጂ");
    namesMap.put("FM", "ሚክሮኔዢያ");
    namesMap.put("FR", "ፈረንሳይ");
    namesMap.put("GB", "እንግሊዝ");
    namesMap.put("GE", "ጆርጂያ");
    namesMap.put("GF", "የፈረንሳይ ጉዊአና");
    namesMap.put("GM", "ጋምቢያ");
    namesMap.put("GN", "ጊኒ");
    namesMap.put("GQ", "ኢኳቶሪያል ጊኒ");
    namesMap.put("GR", "ግሪክ");
    namesMap.put("GW", "ቢሳዎ");
    namesMap.put("GY", "ጉያና");
    namesMap.put("HK", "ሆንግ ኮንግ");
    namesMap.put("HR", "ክሮኤሽያ");
    namesMap.put("HT", "ሀይቲ");
    namesMap.put("HU", "ሀንጋሪ");
    namesMap.put("ID", "ኢንዶኔዢያ");
    namesMap.put("IE", "አየርላንድ");
    namesMap.put("IL", "እስራኤል");
    namesMap.put("IN", "ህንድ");
    namesMap.put("IQ", "ኢራቅ");
    namesMap.put("IS", "አይስላንድ");
    namesMap.put("IT", "ጣሊያን");
    namesMap.put("JM", "ጃማይካ");
    namesMap.put("JO", "ጆርዳን");
    namesMap.put("JP", "ጃፓን");
    namesMap.put("KH", "ካምቦዲያ");
    namesMap.put("KM", "ኮሞሮስ");
    namesMap.put("KP", "ደቡብ ኮሪያ");
    namesMap.put("KR", "ሰሜን ኮሪያ");
    namesMap.put("KW", "ክዌት");
    namesMap.put("LB", "ሊባኖስ");
    namesMap.put("LT", "ሊቱዌኒያ");
    namesMap.put("LV", "ላትቪያ");
    namesMap.put("LY", "ሊቢያ");
    namesMap.put("MA", "ሞሮኮ");
    namesMap.put("MD", "ሞልዶቫ");
    namesMap.put("MK", "ማከዶኒያ");
    namesMap.put("MN", "ሞንጎሊያ");
    namesMap.put("MO", "ማካዎ");
    namesMap.put("MR", "ሞሪቴኒያ");
    namesMap.put("MT", "ማልታ");
    namesMap.put("MU", "ማሩሸስ");
    namesMap.put("MX", "ሜክሲኮ");
    namesMap.put("MY", "ማሌዢያ");
    namesMap.put("NA", "ናሚቢያ");
    namesMap.put("NC", "ኒው ካሌዶኒያ");
    namesMap.put("NG", "ናይጄሪያ");
    namesMap.put("NL", "ኔዘርላንድ");
    namesMap.put("NO", "ኖርዌ");
    namesMap.put("NP", "ኔፓል");
    namesMap.put("NZ", "ኒው ዚላንድ");
    namesMap.put("PE", "ፔሩ");
    namesMap.put("PF", "የፈረንሳይ ፖሊኔዢያ");
    namesMap.put("PG", "ፓፑዋ ኒው ጊኒ");
    namesMap.put("PL", "ፖላንድ");
    namesMap.put("PR", "ፖርታ ሪኮ");
    namesMap.put("RO", "ሮሜኒያ");
    namesMap.put("RU", "ራሺያ");
    namesMap.put("SA", "ሳውድአረቢያ");
    namesMap.put("SD", "ሱዳን");
    namesMap.put("SE", "ስዊድን");
    namesMap.put("SG", "ሲንጋፖር");
    namesMap.put("SI", "ስሎቬኒያ");
    namesMap.put("SK", "ስሎቫኪያ");
    namesMap.put("SN", "ሴኔጋል");
    namesMap.put("SO", "ሱማሌ");
    namesMap.put("SY", "ሲሪያ");
    namesMap.put("TD", "ቻድ");
    namesMap.put("TF", "የፈረንሳይ ደቡባዊ ግዛቶች");
    namesMap.put("TH", "ታይላንድ");
    namesMap.put("TJ", "ታጃኪስታን");
    namesMap.put("TL", "ምስራቅ ቲሞር");
    namesMap.put("TN", "ቱኒዚያ");
    namesMap.put("TR", "ቱርክ");
    namesMap.put("TT", "ትሪኒዳድ እና ቶባጎ");
    namesMap.put("TZ", "ታንዛኒያ");
    namesMap.put("UG", "ዩጋንዳ");
    namesMap.put("US", "አሜሪካ");
    namesMap.put("UZ", "ዩዝበኪስታን");
    namesMap.put("VE", "ቬንዙዌላ");
    namesMap.put("VG", "የእንግሊዝ ድንግል ደሴቶች");
    namesMap.put("VI", "የአሜሪካ ቨርጂን ደሴቶች");
    namesMap.put("YE", "የመን");
    namesMap.put("ZA", "ደቡብ አፍሪካ");
    namesMap.put("ZM", "ዛምቢያ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "አንዶራ",
        "AE": "የተባበሩት አረብ ኤምሬትስ",
        "AL": "አልባኒያ",
        "AM": "አርሜኒያ",
        "AN": "ኔዘርላንድስ አንቲልስ",
        "AR": "አርጀንቲና",
        "AT": "ኦስትሪያ",
        "AU": "አውስትሬሊያ",
        "AZ": "አዘርባጃን",
        "BA": "ቦስኒያ እና ሄርዞጎቪኒያ",
        "BB": "ባርቤዶስ",
        "BE": "ቤልጄም",
        "BG": "ቡልጌሪያ",
        "BH": "ባህሬን",
        "BM": "ቤርሙዳ",
        "BO": "ቦሊቪያ",
        "BR": "ብራዚል",
        "BT": "ቡህታን",
        "BY": "ቤላሩስ",
        "BZ": "ቤሊዘ",
        "CD": "ኮንጎ",
        "CF": "የመካከለኛው አፍሪካ ሪፐብሊክ",
        "CH": "ስዊዘርላንድ",
        "CL": "ቺሊ",
        "CM": "ካሜሩን",
        "CN": "ቻይና",
        "CO": "ኮሎምቢያ",
        "CS": "ሰርቢያ",
        "CV": "ኬፕ ቬርዴ",
        "CY": "ሳይፕረስ",
        "CZ": "ቼክ ሪፑብሊክ",
        "DE": "ጀርመን",
        "DK": "ዴንማርክ",
        "DM": "ዶሚኒካ",
        "DO": "ዶሚኒክ ሪፑብሊክ",
        "DZ": "አልጄሪያ",
        "EC": "ኢኳዶር",
        "EE": "ኤስቶኒያ",
        "EG": "ግብጽ",
        "EH": "ምዕራባዊ ሳህራ",
        "ER": "ኤርትራ",
        "ES": "ስፔን",
        "ET": "ኢትዮጵያ",
        "FI": "ፊንላንድ",
        "FJ": "ፊጂ",
        "FM": "ሚክሮኔዢያ",
        "FR": "ፈረንሳይ",
        "GB": "እንግሊዝ",
        "GE": "ጆርጂያ",
        "GF": "የፈረንሳይ ጉዊአና",
        "GM": "ጋምቢያ",
        "GN": "ጊኒ",
        "GQ": "ኢኳቶሪያል ጊኒ",
        "GR": "ግሪክ",
        "GW": "ቢሳዎ",
        "GY": "ጉያና",
        "HK": "ሆንግ ኮንግ",
        "HR": "ክሮኤሽያ",
        "HT": "ሀይቲ",
        "HU": "ሀንጋሪ",
        "ID": "ኢንዶኔዢያ",
        "IE": "አየርላንድ",
        "IL": "እስራኤል",
        "IN": "ህንድ",
        "IQ": "ኢራቅ",
        "IS": "አይስላንድ",
        "IT": "ጣሊያን",
        "JM": "ጃማይካ",
        "JO": "ጆርዳን",
        "JP": "ጃፓን",
        "KH": "ካምቦዲያ",
        "KM": "ኮሞሮስ",
        "KP": "ደቡብ ኮሪያ",
        "KR": "ሰሜን ኮሪያ",
        "KW": "ክዌት",
        "LB": "ሊባኖስ",
        "LT": "ሊቱዌኒያ",
        "LV": "ላትቪያ",
        "LY": "ሊቢያ",
        "MA": "ሞሮኮ",
        "MD": "ሞልዶቫ",
        "MK": "ማከዶኒያ",
        "MN": "ሞንጎሊያ",
        "MO": "ማካዎ",
        "MR": "ሞሪቴኒያ",
        "MT": "ማልታ",
        "MU": "ማሩሸስ",
        "MX": "ሜክሲኮ",
        "MY": "ማሌዢያ",
        "NA": "ናሚቢያ",
        "NC": "ኒው ካሌዶኒያ",
        "NG": "ናይጄሪያ",
        "NL": "ኔዘርላንድ",
        "NO": "ኖርዌ",
        "NP": "ኔፓል",
        "NZ": "ኒው ዚላንድ",
        "PE": "ፔሩ",
        "PF": "የፈረንሳይ ፖሊኔዢያ",
        "PG": "ፓፑዋ ኒው ጊኒ",
        "PL": "ፖላንድ",
        "PR": "ፖርታ ሪኮ",
        "RO": "ሮሜኒያ",
        "RU": "ራሺያ",
        "SA": "ሳውድአረቢያ",
        "SD": "ሱዳን",
        "SE": "ስዊድን",
        "SG": "ሲንጋፖር",
        "SI": "ስሎቬኒያ",
        "SK": "ስሎቫኪያ",
        "SN": "ሴኔጋል",
        "SO": "ሱማሌ",
        "SY": "ሲሪያ",
        "TD": "ቻድ",
        "TF": "የፈረንሳይ ደቡባዊ ግዛቶች",
        "TH": "ታይላንድ",
        "TJ": "ታጃኪስታን",
        "TL": "ምስራቅ ቲሞር",
        "TN": "ቱኒዚያ",
        "TR": "ቱርክ",
        "TT": "ትሪኒዳድ እና ቶባጎ",
        "TZ": "ታንዛኒያ",
        "UG": "ዩጋንዳ",
        "US": "አሜሪካ",
        "UZ": "ዩዝበኪስታን",
        "VE": "ቬንዙዌላ",
        "VG": "የእንግሊዝ ድንግል ደሴቶች",
        "VI": "የአሜሪካ ቨርጂን ደሴቶች",
        "YE": "የመን",
        "ZA": "ደቡብ አፍሪካ",
        "ZM": "ዛምቢያ"
    };
  }-*/;
}
