/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.testing;

import com.google.gwt.editor.client.EditorContext;
import com.google.gwt.editor.client.EditorDriver;
import com.google.gwt.editor.client.EditorVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorHierarchyPrinter
extends EditorVisitor {
    private static final String INDENT = "  ";
    private static final String SPACE = " ";
    private int level = 0;
    private final StringBuilder sb;

    public static String toString(EditorDriver<?> driver) {
        StringBuilder sb = new StringBuilder();
        driver.accept(new EditorHierarchyPrinter(sb));
        return sb.toString();
    }

    private EditorHierarchyPrinter(StringBuilder out) {
        this.sb = out;
    }

    @Override
    public <T> void endVisit(EditorContext<T> ctx) {
        --this.level;
    }

    @Override
    public <T> boolean visit(EditorContext<T> ctx) {
        this.println(ctx.getAbsolutePath());
        this.data(ctx.getEditedType().getName());
        this.data(ctx.getEditor().getClass().getName());
        this.data("Implements: " + ctx.asCompositeEditor() == null ? "" : ("CompositeEditor " + ctx.asHasEditorDelegate() == null ? "" : ("HasEditorDelegate " + ctx.asHasEditorErrors() == null ? "" : ("HasEditorErrors " + ctx.asLeafValueEditor() == null ? "" : ("LeafValueEditor " + ctx.asValueAwareEditor() == null ? "" : "ValueAwareEditor ")))));
        ++this.level;
        return true;
    }

    private void data(String msg) {
        this.println(SPACE + msg);
    }

    private void println(String msg) {
        for (int i = 0; i < this.level; ++i) {
            this.sb.append(INDENT);
        }
        this.sb.append(msg);
        this.sb.append("\n");
    }
}

