.TH sane\-escl 5 "14 Dec 2019" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-escl
.SH NAME
sane\-escl \- SANE backend for eSCL scanners
.SH DESCRIPTION
The
.B sane\-escl
library implements a SANE (Scanner Access Now Easy) backend that provides access to
eSCL protocol scanners.
.PP
Currently, the following models work with this backend (This list is not exhaustive):
.PP
.RS
BROTHER DCP-J772DW, DCP-L2530DW
.br
BROTHER HL-L2590DW
.br
BROTHER MFC-J4540DW, MFC-J985DW, MFC-J1300DW
.br
CANON IR C3520
.br
CANON PIXMA MG5765
.br
CANON PIXMA G4511, G7050
.br
CANON PIXMA TR4520, TR4540, TR4550, TR4551, TR7500, TR8500
.br
CANON PIXMA TR8520
.br
CANON PIXMA TS3100, TS3150, TS3151, TS3152, TS3300, TS3350
.br
CANON PIXMA TS3351, TS3352, TS3450, TS3451, TS3452, TS5350
.br
CANON PIXMA TS5351, TS5150, TS6150, TS8050, TS8350, TS9100
.br
EPSON ET-2750, ET-3750, ET-4750
.br
EPSON EcoTank L3160
.br
EPSON XP-4200, XP-6100
.br
HP DESKJET 2710, DESKJET 2723, DESKJET 3760
.br
HP LASERJET ENTREPRISE FLOW MFP M578,
.br
HP LASERJET MFP M28W, LASERJET MFP M630
.br
HP OFFICEJET 4630, OFFICEJET PRO 8610
.br
RICOH SP3710S
.br
XEROX VERSALINK C7220
.RE
.PP
The.
.B sane\-escl
backend for SANE supports AirScan/eSCL devices that announce
themselves on mDNS as _uscan._utcp or _uscans._utcp.
If the device is available, the
.B sane\-escl
backend recovers these capacities.
The user configures and starts scanning.
A list of devices that use the eSCL protocol can be found at
.IR https://support.apple.com/en-us/HT201311 .
While these devices are expected to work, your mileage may vary.

.SH FILES
.TP
.I @CONFIGDIR@/escl.conf
The backend configuration file.
.TP
.I @LIBDIR@/libsane\-escl.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-escl.so
The shared library implementing this backend (present on systems that
support dynamic loading).

.SH ENVIRONMENT
.TP
.B SANE_DEBUG_ESCL
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.

.SH "SEE ALSO"
.BR sane (7)
.BR scanimage (1)
.BR xscanimage (1)
.BR xsane (1)

.SH AUTHORS
Touboul Nathane, Thierry HUCHARD
