# Copyright 2012-2015 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

"""Model export and helpers for maasserver."""

from __future__ import (
    absolute_import,
    print_function,
    unicode_literals,
    )

str = None

__metaclass__ = type
__all__ = [
    'BlockDevice',
    'BootResource',
    'BootResourceFile',
    'BootResourceSet',
    'BootSource',
    'BootSourceCache',
    'BootSourceSelection',
    'CacheSet',
    'ComponentError',
    'Config',
    'DownloadProgress',
    'Event',
    'Fabric',
    'FanNetwork',
    'FileStorage',
    'Filesystem',
    'FilesystemGroup',
    'Interface',
    'LargeFile',
    'LicenseKey',
    'Node',
    'NodeGroup',
    'NodeGroupInterface',
    'Partition',
    'PartitionTable',
    'PhysicalBlockDevice',
    'PhysicalInterface',
    'Space',
    'SSHKey',
    'SSLKey',
    'Subnet',
    'Tag',
    'UserProfile',
    'VirtualBlockDevice',
    'VLAN',
    'Zone',
    ]

from django.contrib.auth.models import User
from maasserver.models.blockdevice import BlockDevice
from maasserver.models.bootresource import BootResource
from maasserver.models.bootresourcefile import BootResourceFile
from maasserver.models.bootresourceset import BootResourceSet
from maasserver.models.bootsource import BootSource
from maasserver.models.bootsourcecache import BootSourceCache
from maasserver.models.bootsourceselection import BootSourceSelection
from maasserver.models.cacheset import CacheSet
from maasserver.models.component_error import ComponentError
from maasserver.models.config import Config
from maasserver.models.downloadprogress import DownloadProgress
from maasserver.models.event import Event
from maasserver.models.eventtype import EventType
from maasserver.models.fabric import Fabric
from maasserver.models.fannetwork import FanNetwork
from maasserver.models.filestorage import FileStorage
from maasserver.models.filesystem import Filesystem
from maasserver.models.filesystemgroup import FilesystemGroup
from maasserver.models.interface import Interface
from maasserver.models.largefile import LargeFile
from maasserver.models.licensekey import LicenseKey
from maasserver.models.node import Node
from maasserver.models.nodegroup import NodeGroup
from maasserver.models.nodegroupinterface import NodeGroupInterface
from maasserver.models.partition import Partition
from maasserver.models.partitiontable import PartitionTable
from maasserver.models.physicalblockdevice import PhysicalBlockDevice
from maasserver.models.space import Space
from maasserver.models.sshkey import SSHKey
from maasserver.models.sslkey import SSLKey
from maasserver.models.staticipaddress import StaticIPAddress
from maasserver.models.subnet import Subnet
from maasserver.models.tag import Tag
from maasserver.models.user import create_user
from maasserver.models.userprofile import UserProfile
from maasserver.models.virtualblockdevice import VirtualBlockDevice
from maasserver.models.vlan import VLAN
from maasserver.models.zone import Zone
from maasserver.utils import ignore_unused

# Suppress warning about symbols being imported, but only used for
# export in __all__.
ignore_unused(
    BootResource,
    BootResourceFile,
    BootResourceSet,
    CacheSet,
    ComponentError,
    Config,
    DownloadProgress,
    Event,
    EventType,
    Fabric,
    FileStorage,
    Filesystem,
    FilesystemGroup,
    Interface,
    LargeFile,
    LicenseKey,
    NodeGroup,
    NodeGroupInterface,
    Partition,
    PartitionTable,
    SSHKey,
    StaticIPAddress,
    Tag,
    UserProfile,
    VirtualBlockDevice,
    VLAN,
    Zone,
)

# Monkey patch django.contrib.auth.models.User to force email to be unique.
User._meta.get_field('email')._unique = True
