.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XcmsStoreColor __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XcmsStoreColor, XcmsStoreColors \- set colors
.SH SYNTAX
.HP
Status XcmsStoreColor\^(\^Display *\fIdisplay\fP\^, Colormap \fIcolormap\fP\^,
XcmsColor *\fIcolor\fP\^);
.HP
Status XcmsStoreColors\^(\^Display *\fIdisplay\fP\^, Colormap
\fIcolormap\fP\^, XcmsColor \fIcolors\fP\^[\^]\^, int \fIncolors\fP\^, Bool
\fIcompression_flags_return\fP\^[\^]\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIcolor\fP 1i
Specifies the color cell and the color to store.
Values specified in this
.B XcmsColor
structure remain unchanged on return.
.IP \fIcolors\fP 1i
Specifies the color specification array of
.B XcmsColor
structures, each specifying a color cell and the color to store in that
cell.
Values specified in the array remain unchanged upon return.
.IP \fIcolormap\fP 1i
Specifies the colormap.
.IP \fIcompression_flags_return\fP 1i
Returns an array of Boolean values indicating compression status.
If a non-NULL pointer is supplied,
each element of the array is set to
.B True
if the corresponding color was compressed and
.B False
otherwise.
Pass NULL if the compression status is not useful.
.IP \fIncolors\fP 1i
Specifies the number of
.B XcmsColor
structures in the color-specification array.
.SH DESCRIPTION
The
.B XcmsStoreColor
function converts the color specified in the
.B XcmsColor
structure into RGB values.
It then uses this RGB specification in an
.B XColor
structure, whose three flags
.Pn ( DoRed ,
.BR DoGreen ,
and
.BR DoBlue )
are set, in a call to
.B XStoreColor
to change the color cell specified by the pixel member of the
.B XcmsColor
structure.
This pixel value must be a valid index for the specified colormap,
and the color cell specified by the pixel value must be a read/write cell.
If the pixel value is not a valid index, a
.B BadValue
error results.
If the color cell is unallocated or is allocated read-only, a
.B BadAccess
error results.
If the colormap is an installed map for its screen,
the changes are visible immediately.
.LP
Note that
.B XStoreColor
has no return value; therefore, an
.B XcmsSuccess
return value from this function indicates that the conversion
to RGB succeeded and the call to
.B XStoreColor
was made.
To obtain the actual color stored, use
.BR XcmsQueryColor .
Because of the screen's hardware limitations or gamut compression,
the color stored in the colormap may not be identical
to the color specified.
.LP
.B XcmsStoreColor
can generate
.BR BadAccess ,
.BR BadColor ,
and
.B BadValue
errors.
.LP
The
.B XcmsStoreColors
function converts the colors specified in the array of
.B XcmsColor
structures into RGB values and then uses these RGB specifications in
.B XColor
structures, whose three flags
.Pn ( DoRed ,
.BR DoGreen ,
and
.BR DoBlue )
are set, in a call to
.B XStoreColors
to change the color cells specified by the pixel member of the corresponding
.B XcmsColor
structure.
Each pixel value must be a valid index for the specified colormap,
and the color cell specified by each pixel value must be a read/write cell.
If a pixel value is not a valid index, a
.B BadValue
error results.
If a color cell is unallocated or is allocated read-only, a
.B BadAccess
error results.
If more than one pixel is in error,
the one that gets reported is arbitrary.
If the colormap is an installed map for its screen,
the changes are visible immediately.
.LP
Note that
.B XStoreColors
has no return value; therefore, an
.B XcmsSuccess
return value from this function indicates that conversions
to RGB succeeded and the call to
.B XStoreColors
was made.
To obtain the actual colors stored, use
.BR XcmsQueryColors .
Because of the screen's hardware limitations or gamut compression,
the colors stored in the colormap may not be identical
to the colors specified.
.LP
.LP
.B XcmsStoreColors
can generate
.BR BadAccess ,
.BR BadColor ,
and
.B BadValue
errors.
.SH DIAGNOSTICS
.TP 1i
.B BadAccess
A client attempted
to free a color map entry that it did not already allocate.
.TP 1i
.B BadAccess
A client attempted
to store into a read-only color map entry.
.TP 1i
.B BadColor
A value for a Colormap argument does not name a defined Colormap.
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XcmsAllocColor(__libmansuffix__),
XcmsQueryColor(__libmansuffix__)
.br
\fI\*(xL\fP
