//! # Example: Custom Types (Derive API)
//!
//! **This requires enabling the [`derive` feature flag][crate::_features].**
//!
//! ## Implicit [`Arg::value_parser`][crate::Arg::value_parser]
//!
//! ```rust
#![doc = include_str!("../../examples/typed-derive/implicit.rs")]
//! ```
//!
#![doc = include_str!("../../examples/typed-derive/implicit.md")]
//!
//! ## Built-in [`TypedValueParser`][crate::builder::TypedValueParser]
//!
//! ```rust
#![doc = include_str!("../../examples/typed-derive/builtin.rs")]
//! ```
//!
#![doc = include_str!("../../examples/typed-derive/builtin.md")]
//!
//! ## Custom parser function
//!
//! ```rust
#![doc = include_str!("../../examples/typed-derive/fn_parser.rs")]
//! ```
//!
#![doc = include_str!("../../examples/typed-derive/fn_parser.md")]
//!
//! ## Custom [`TypedValueParser`][crate::builder::TypedValueParser]
//!
//! ```rust
#![doc = include_str!("../../examples/typed-derive/custom.rs")]
//! ```
//!
#![doc = include_str!("../../examples/typed-derive/custom.md")]
