static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <gdk-pixbuf/gdk-pixbuf.h>                                            \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_object (pixbuf, _(\"Pixbuf\"), GDK_TYPE_PIXBUF)                      \n"
"    description(_(\"GdkPixbuf to use\"))                                      \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE pixbuf.c                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <gdk-pixbuf/gdk-pixdata.h>                                           \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  GeglRectangle result = {0,0,0,0};                                           \n"
"                                                                              \n"
"  if (!o->pixbuf)                                                             \n"
"    {                                                                         \n"
"      return result;                                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  result.x = 0;                                                               \n"
"  result.y = 0;                                                               \n"
"  result.width  = gdk_pixbuf_get_width (GDK_PIXBUF (o->pixbuf));              \n"
"  result.height = gdk_pixbuf_get_height (GDK_PIXBUF (o->pixbuf));             \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"      babl_format(gdk_pixbuf_get_has_alpha(GDK_PIXBUF(o->pixbuf))?\"R'G'B'A u8\":\"R'G'B' u8\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (o->pixbuf)                                                              \n"
"    {                                                                         \n"
"      GeglRectangle extent;                                                   \n"
"                                                                              \n"
"      extent.x = 0;                                                           \n"
"      extent.y = 0;                                                           \n"
"      extent.width = gdk_pixbuf_get_width (GDK_PIXBUF (o->pixbuf));           \n"
"      extent.height = gdk_pixbuf_get_height (GDK_PIXBUF (o->pixbuf));         \n"
"                                                                              \n"
"      gegl_buffer_set (output, &extent, 0, NULL, gdk_pixbuf_get_pixels (GDK_PIXBUF (o->pixbuf)),\n"
"                       GEGL_AUTO_ROWSTRIDE);                                  \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = process;                                            \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare = prepare;                                         \n"
"  /*operation_class->no_cache = TRUE;*/                                       \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:pixbuf\",                                        \n"
"    \"title\",        _(\"GdkPixbuf Source\"),                                \n"
"    \"categories\"  , \"programming:input\",                                  \n"
"    \"description\" ,                                                         \n"
"       _(\"Uses the GdkPixbuf located at the memory location in <em>pixbuf</em>.\"),\n"
"       NULL);                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
