/*
 *  Coercion tests.
 */

/* Custom because there are a few numconv rounding issues in the
 * expect string.
 */

/*@include util-base.js@*/
/*@include util-buffer.js@*/
/*@include util-string.js@*/

/*---
{
    "custom": true,
    "endianness": "little"
}
---*/

/*===
coercion test
[object ArrayBuffer]
- skipped
[object DataView]
- skipped
[object Int8Array]
0 -Infinity -> 0
1 -1e+100 -> 0
2 -1125899906842627 -> -3
3 -4294967297.9 -> -1
4 -4294967297.5 -> -1
5 -4294967297.1 -> -1
6 -4294967297 -> -1
7 -4294967296.9 -> 0
8 -4294967296.5 -> 0
9 -4294967296.1 -> 0
10 -4294967296 -> 0
11 -4294967295.9 -> 1
12 -4294967295.5 -> 1
13 -4294967295.1 -> 1
14 -4294967295 -> 1
15 -2147483649.9 -> -1
16 -2147483649.5 -> -1
17 -2147483649.1 -> -1
18 -2147483649 -> -1
19 -2147483648.9 -> 0
20 -2147483648.5 -> 0
21 -2147483648.1 -> 0
22 -2147483648 -> 0
23 -2147483647.9 -> 1
24 -2147483647.5 -> 1
25 -2147483647.1 -> 1
26 -2147483647 -> 1
27 -65537.9 -> -1
28 -65537.5 -> -1
29 -65537.1 -> -1
30 -65537 -> -1
31 -65536.9 -> 0
32 -65536.5 -> 0
33 -65536.1 -> 0
34 -65536 -> 0
35 -65535.9 -> 1
36 -65535.5 -> 1
37 -65535.1 -> 1
38 -65535 -> 1
39 -32769.9 -> -1
40 -32769.5 -> -1
41 -32769.1 -> -1
42 -32769 -> -1
43 -32768.9 -> 0
44 -32768.5 -> 0
45 -32768.1 -> 0
46 -32768 -> 0
47 -32767.9 -> 1
48 -32767.5 -> 1
49 -32767.1 -> 1
50 -32767 -> 1
51 -274.9 -> -18
52 -274.5 -> -18
53 -274.1 -> -18
54 -274 -> -18
55 -273.9 -> -17
56 -273.5 -> -17
57 -273.1 -> -17
58 -273 -> -17
59 -272.9 -> -16
60 -272.5 -> -16
61 -272.1 -> -16
62 -272 -> -16
63 -257.9 -> -1
64 -257.5 -> -1
65 -257.1 -> -1
66 -257 -> -1
67 -256.9 -> 0
68 -256.5 -> 0
69 -256.1 -> 0
70 -256 -> 0
71 -255.9 -> 1
72 -255.5 -> 1
73 -255.1 -> 1
74 -255 -> 1
75 -254.9 -> 2
76 -254.5 -> 2
77 -254.1 -> 2
78 -254 -> 2
79 -129.9 -> 127
80 -129.5 -> 127
81 -129.1 -> 127
82 -129 -> 127
83 -128.9 -> -128
84 -128.5 -> -128
85 -128.1 -> -128
86 -128 -> -128
87 -127.9 -> -127
88 -127.5 -> -127
89 -127.1 -> -127
90 -127 -> -127
91 -126.9 -> -126
92 -126.5 -> -126
93 -126.1 -> -126
94 -126 -> -126
95 -1.9 -> -1
96 -1.5 -> -1
97 -1.1 -> -1
98 -1 -> -1
99 -0.9 -> 0
100 -0.5 -> 0
101 -0.1 -> 0
102 0 -> 0
103 0 -> 0
104 0.1 -> 0
105 0.5 -> 0
106 0.9 -> 0
107 1 -> 1
108 1.1 -> 1
109 1.5 -> 1
110 1.9 -> 1
111 126 -> 126
112 126.1 -> 126
113 126.5 -> 126
114 126.9 -> 126
115 127 -> 127
116 127.1 -> 127
117 127.5 -> 127
118 127.9 -> 127
119 128 -> -128
120 128.1 -> -128
121 128.5 -> -128
122 128.9 -> -128
123 129 -> -127
124 129.1 -> -127
125 129.5 -> -127
126 129.9 -> -127
127 254 -> -2
128 254.1 -> -2
129 254.5 -> -2
130 254.9 -> -2
131 255 -> -1
132 255.1 -> -1
133 255.5 -> -1
134 255.9 -> -1
135 256 -> 0
136 256.1 -> 0
137 256.5 -> 0
138 256.9 -> 0
139 257 -> 1
140 257.1 -> 1
141 257.5 -> 1
142 257.9 -> 1
143 272 -> 16
144 272.1 -> 16
145 272.5 -> 16
146 272.9 -> 16
147 273 -> 17
148 273.1 -> 17
149 273.5 -> 17
150 273.9 -> 17
151 274 -> 18
152 274.1 -> 18
153 274.5 -> 18
154 274.9 -> 18
155 32767 -> -1
156 32767.1 -> -1
157 32767.5 -> -1
158 32767.9 -> -1
159 32768 -> 0
160 32768.1 -> 0
161 32768.5 -> 0
162 32768.9 -> 0
163 32769 -> 1
164 32769.1 -> 1
165 32769.5 -> 1
166 32769.9 -> 1
167 65535 -> -1
168 65535.1 -> -1
169 65535.5 -> -1
170 65535.9 -> -1
171 65536 -> 0
172 65536.1 -> 0
173 65536.5 -> 0
174 65536.9 -> 0
175 65537 -> 1
176 65537.1 -> 1
177 65537.5 -> 1
178 65537.9 -> 1
179 2147483647 -> -1
180 2147483647.1 -> -1
181 2147483647.5 -> -1
182 2147483647.9 -> -1
183 2147483648 -> 0
184 2147483648.1 -> 0
185 2147483648.5 -> 0
186 2147483648.9 -> 0
187 2147483649 -> 1
188 2147483649.1 -> 1
189 2147483649.5 -> 1
190 2147483649.9 -> 1
191 4294967295 -> -1
192 4294967295.1 -> -1
193 4294967295.5 -> -1
194 4294967295.9 -> -1
195 4294967296 -> 0
196 4294967296.1 -> 0
197 4294967296.5 -> 0
198 4294967296.9 -> 0
199 4294967297 -> 1
200 4294967297.1 -> 1
201 4294967297.5 -> 1
202 4294967297.9 -> 1
203 1125899906842627 -> 3
204 Infinity -> 0
205 1e+100 -> 0
206 NaN -> 0
[object Uint8Array]
0 -Infinity -> 0
1 -1e+100 -> 0
2 -1125899906842627 -> 253
3 -4294967297.9 -> 255
4 -4294967297.5 -> 255
5 -4294967297.1 -> 255
6 -4294967297 -> 255
7 -4294967296.9 -> 0
8 -4294967296.5 -> 0
9 -4294967296.1 -> 0
10 -4294967296 -> 0
11 -4294967295.9 -> 1
12 -4294967295.5 -> 1
13 -4294967295.1 -> 1
14 -4294967295 -> 1
15 -2147483649.9 -> 255
16 -2147483649.5 -> 255
17 -2147483649.1 -> 255
18 -2147483649 -> 255
19 -2147483648.9 -> 0
20 -2147483648.5 -> 0
21 -2147483648.1 -> 0
22 -2147483648 -> 0
23 -2147483647.9 -> 1
24 -2147483647.5 -> 1
25 -2147483647.1 -> 1
26 -2147483647 -> 1
27 -65537.9 -> 255
28 -65537.5 -> 255
29 -65537.1 -> 255
30 -65537 -> 255
31 -65536.9 -> 0
32 -65536.5 -> 0
33 -65536.1 -> 0
34 -65536 -> 0
35 -65535.9 -> 1
36 -65535.5 -> 1
37 -65535.1 -> 1
38 -65535 -> 1
39 -32769.9 -> 255
40 -32769.5 -> 255
41 -32769.1 -> 255
42 -32769 -> 255
43 -32768.9 -> 0
44 -32768.5 -> 0
45 -32768.1 -> 0
46 -32768 -> 0
47 -32767.9 -> 1
48 -32767.5 -> 1
49 -32767.1 -> 1
50 -32767 -> 1
51 -274.9 -> 238
52 -274.5 -> 238
53 -274.1 -> 238
54 -274 -> 238
55 -273.9 -> 239
56 -273.5 -> 239
57 -273.1 -> 239
58 -273 -> 239
59 -272.9 -> 240
60 -272.5 -> 240
61 -272.1 -> 240
62 -272 -> 240
63 -257.9 -> 255
64 -257.5 -> 255
65 -257.1 -> 255
66 -257 -> 255
67 -256.9 -> 0
68 -256.5 -> 0
69 -256.1 -> 0
70 -256 -> 0
71 -255.9 -> 1
72 -255.5 -> 1
73 -255.1 -> 1
74 -255 -> 1
75 -254.9 -> 2
76 -254.5 -> 2
77 -254.1 -> 2
78 -254 -> 2
79 -129.9 -> 127
80 -129.5 -> 127
81 -129.1 -> 127
82 -129 -> 127
83 -128.9 -> 128
84 -128.5 -> 128
85 -128.1 -> 128
86 -128 -> 128
87 -127.9 -> 129
88 -127.5 -> 129
89 -127.1 -> 129
90 -127 -> 129
91 -126.9 -> 130
92 -126.5 -> 130
93 -126.1 -> 130
94 -126 -> 130
95 -1.9 -> 255
96 -1.5 -> 255
97 -1.1 -> 255
98 -1 -> 255
99 -0.9 -> 0
100 -0.5 -> 0
101 -0.1 -> 0
102 0 -> 0
103 0 -> 0
104 0.1 -> 0
105 0.5 -> 0
106 0.9 -> 0
107 1 -> 1
108 1.1 -> 1
109 1.5 -> 1
110 1.9 -> 1
111 126 -> 126
112 126.1 -> 126
113 126.5 -> 126
114 126.9 -> 126
115 127 -> 127
116 127.1 -> 127
117 127.5 -> 127
118 127.9 -> 127
119 128 -> 128
120 128.1 -> 128
121 128.5 -> 128
122 128.9 -> 128
123 129 -> 129
124 129.1 -> 129
125 129.5 -> 129
126 129.9 -> 129
127 254 -> 254
128 254.1 -> 254
129 254.5 -> 254
130 254.9 -> 254
131 255 -> 255
132 255.1 -> 255
133 255.5 -> 255
134 255.9 -> 255
135 256 -> 0
136 256.1 -> 0
137 256.5 -> 0
138 256.9 -> 0
139 257 -> 1
140 257.1 -> 1
141 257.5 -> 1
142 257.9 -> 1
143 272 -> 16
144 272.1 -> 16
145 272.5 -> 16
146 272.9 -> 16
147 273 -> 17
148 273.1 -> 17
149 273.5 -> 17
150 273.9 -> 17
151 274 -> 18
152 274.1 -> 18
153 274.5 -> 18
154 274.9 -> 18
155 32767 -> 255
156 32767.1 -> 255
157 32767.5 -> 255
158 32767.9 -> 255
159 32768 -> 0
160 32768.1 -> 0
161 32768.5 -> 0
162 32768.9 -> 0
163 32769 -> 1
164 32769.1 -> 1
165 32769.5 -> 1
166 32769.9 -> 1
167 65535 -> 255
168 65535.1 -> 255
169 65535.5 -> 255
170 65535.9 -> 255
171 65536 -> 0
172 65536.1 -> 0
173 65536.5 -> 0
174 65536.9 -> 0
175 65537 -> 1
176 65537.1 -> 1
177 65537.5 -> 1
178 65537.9 -> 1
179 2147483647 -> 255
180 2147483647.1 -> 255
181 2147483647.5 -> 255
182 2147483647.9 -> 255
183 2147483648 -> 0
184 2147483648.1 -> 0
185 2147483648.5 -> 0
186 2147483648.9 -> 0
187 2147483649 -> 1
188 2147483649.1 -> 1
189 2147483649.5 -> 1
190 2147483649.9 -> 1
191 4294967295 -> 255
192 4294967295.1 -> 255
193 4294967295.5 -> 255
194 4294967295.9 -> 255
195 4294967296 -> 0
196 4294967296.1 -> 0
197 4294967296.5 -> 0
198 4294967296.9 -> 0
199 4294967297 -> 1
200 4294967297.1 -> 1
201 4294967297.5 -> 1
202 4294967297.9 -> 1
203 1125899906842627 -> 3
204 Infinity -> 0
205 1e+100 -> 0
206 NaN -> 0
[object Uint8ClampedArray]
0 -Infinity -> 0
1 -1e+100 -> 0
2 -1125899906842627 -> 0
3 -4294967297.9 -> 0
4 -4294967297.5 -> 0
5 -4294967297.1 -> 0
6 -4294967297 -> 0
7 -4294967296.9 -> 0
8 -4294967296.5 -> 0
9 -4294967296.1 -> 0
10 -4294967296 -> 0
11 -4294967295.9 -> 0
12 -4294967295.5 -> 0
13 -4294967295.1 -> 0
14 -4294967295 -> 0
15 -2147483649.9 -> 0
16 -2147483649.5 -> 0
17 -2147483649.1 -> 0
18 -2147483649 -> 0
19 -2147483648.9 -> 0
20 -2147483648.5 -> 0
21 -2147483648.1 -> 0
22 -2147483648 -> 0
23 -2147483647.9 -> 0
24 -2147483647.5 -> 0
25 -2147483647.1 -> 0
26 -2147483647 -> 0
27 -65537.9 -> 0
28 -65537.5 -> 0
29 -65537.1 -> 0
30 -65537 -> 0
31 -65536.9 -> 0
32 -65536.5 -> 0
33 -65536.1 -> 0
34 -65536 -> 0
35 -65535.9 -> 0
36 -65535.5 -> 0
37 -65535.1 -> 0
38 -65535 -> 0
39 -32769.9 -> 0
40 -32769.5 -> 0
41 -32769.1 -> 0
42 -32769 -> 0
43 -32768.9 -> 0
44 -32768.5 -> 0
45 -32768.1 -> 0
46 -32768 -> 0
47 -32767.9 -> 0
48 -32767.5 -> 0
49 -32767.1 -> 0
50 -32767 -> 0
51 -274.9 -> 0
52 -274.5 -> 0
53 -274.1 -> 0
54 -274 -> 0
55 -273.9 -> 0
56 -273.5 -> 0
57 -273.1 -> 0
58 -273 -> 0
59 -272.9 -> 0
60 -272.5 -> 0
61 -272.1 -> 0
62 -272 -> 0
63 -257.9 -> 0
64 -257.5 -> 0
65 -257.1 -> 0
66 -257 -> 0
67 -256.9 -> 0
68 -256.5 -> 0
69 -256.1 -> 0
70 -256 -> 0
71 -255.9 -> 0
72 -255.5 -> 0
73 -255.1 -> 0
74 -255 -> 0
75 -254.9 -> 0
76 -254.5 -> 0
77 -254.1 -> 0
78 -254 -> 0
79 -129.9 -> 0
80 -129.5 -> 0
81 -129.1 -> 0
82 -129 -> 0
83 -128.9 -> 0
84 -128.5 -> 0
85 -128.1 -> 0
86 -128 -> 0
87 -127.9 -> 0
88 -127.5 -> 0
89 -127.1 -> 0
90 -127 -> 0
91 -126.9 -> 0
92 -126.5 -> 0
93 -126.1 -> 0
94 -126 -> 0
95 -1.9 -> 0
96 -1.5 -> 0
97 -1.1 -> 0
98 -1 -> 0
99 -0.9 -> 0
100 -0.5 -> 0
101 -0.1 -> 0
102 0 -> 0
103 0 -> 0
104 0.1 -> 0
105 0.5 -> 0
106 0.9 -> 1
107 1 -> 1
108 1.1 -> 1
109 1.5 -> 2
110 1.9 -> 2
111 126 -> 126
112 126.1 -> 126
113 126.5 -> 126
114 126.9 -> 127
115 127 -> 127
116 127.1 -> 127
117 127.5 -> 128
118 127.9 -> 128
119 128 -> 128
120 128.1 -> 128
121 128.5 -> 128
122 128.9 -> 129
123 129 -> 129
124 129.1 -> 129
125 129.5 -> 130
126 129.9 -> 130
127 254 -> 254
128 254.1 -> 254
129 254.5 -> 254
130 254.9 -> 255
131 255 -> 255
132 255.1 -> 255
133 255.5 -> 255
134 255.9 -> 255
135 256 -> 255
136 256.1 -> 255
137 256.5 -> 255
138 256.9 -> 255
139 257 -> 255
140 257.1 -> 255
141 257.5 -> 255
142 257.9 -> 255
143 272 -> 255
144 272.1 -> 255
145 272.5 -> 255
146 272.9 -> 255
147 273 -> 255
148 273.1 -> 255
149 273.5 -> 255
150 273.9 -> 255
151 274 -> 255
152 274.1 -> 255
153 274.5 -> 255
154 274.9 -> 255
155 32767 -> 255
156 32767.1 -> 255
157 32767.5 -> 255
158 32767.9 -> 255
159 32768 -> 255
160 32768.1 -> 255
161 32768.5 -> 255
162 32768.9 -> 255
163 32769 -> 255
164 32769.1 -> 255
165 32769.5 -> 255
166 32769.9 -> 255
167 65535 -> 255
168 65535.1 -> 255
169 65535.5 -> 255
170 65535.9 -> 255
171 65536 -> 255
172 65536.1 -> 255
173 65536.5 -> 255
174 65536.9 -> 255
175 65537 -> 255
176 65537.1 -> 255
177 65537.5 -> 255
178 65537.9 -> 255
179 2147483647 -> 255
180 2147483647.1 -> 255
181 2147483647.5 -> 255
182 2147483647.9 -> 255
183 2147483648 -> 255
184 2147483648.1 -> 255
185 2147483648.5 -> 255
186 2147483648.9 -> 255
187 2147483649 -> 255
188 2147483649.1 -> 255
189 2147483649.5 -> 255
190 2147483649.9 -> 255
191 4294967295 -> 255
192 4294967295.1 -> 255
193 4294967295.5 -> 255
194 4294967295.9 -> 255
195 4294967296 -> 255
196 4294967296.1 -> 255
197 4294967296.5 -> 255
198 4294967296.9 -> 255
199 4294967297 -> 255
200 4294967297.1 -> 255
201 4294967297.5 -> 255
202 4294967297.9 -> 255
203 1125899906842627 -> 255
204 Infinity -> 255
205 1e+100 -> 255
206 NaN -> 0
[object Int16Array]
0 -Infinity -> 0
1 -1e+100 -> 0
2 -1125899906842627 -> -3
3 -4294967297.9 -> -1
4 -4294967297.5 -> -1
5 -4294967297.1 -> -1
6 -4294967297 -> -1
7 -4294967296.9 -> 0
8 -4294967296.5 -> 0
9 -4294967296.1 -> 0
10 -4294967296 -> 0
11 -4294967295.9 -> 1
12 -4294967295.5 -> 1
13 -4294967295.1 -> 1
14 -4294967295 -> 1
15 -2147483649.9 -> -1
16 -2147483649.5 -> -1
17 -2147483649.1 -> -1
18 -2147483649 -> -1
19 -2147483648.9 -> 0
20 -2147483648.5 -> 0
21 -2147483648.1 -> 0
22 -2147483648 -> 0
23 -2147483647.9 -> 1
24 -2147483647.5 -> 1
25 -2147483647.1 -> 1
26 -2147483647 -> 1
27 -65537.9 -> -1
28 -65537.5 -> -1
29 -65537.1 -> -1
30 -65537 -> -1
31 -65536.9 -> 0
32 -65536.5 -> 0
33 -65536.1 -> 0
34 -65536 -> 0
35 -65535.9 -> 1
36 -65535.5 -> 1
37 -65535.1 -> 1
38 -65535 -> 1
39 -32769.9 -> 32767
40 -32769.5 -> 32767
41 -32769.1 -> 32767
42 -32769 -> 32767
43 -32768.9 -> -32768
44 -32768.5 -> -32768
45 -32768.1 -> -32768
46 -32768 -> -32768
47 -32767.9 -> -32767
48 -32767.5 -> -32767
49 -32767.1 -> -32767
50 -32767 -> -32767
51 -274.9 -> -274
52 -274.5 -> -274
53 -274.1 -> -274
54 -274 -> -274
55 -273.9 -> -273
56 -273.5 -> -273
57 -273.1 -> -273
58 -273 -> -273
59 -272.9 -> -272
60 -272.5 -> -272
61 -272.1 -> -272
62 -272 -> -272
63 -257.9 -> -257
64 -257.5 -> -257
65 -257.1 -> -257
66 -257 -> -257
67 -256.9 -> -256
68 -256.5 -> -256
69 -256.1 -> -256
70 -256 -> -256
71 -255.9 -> -255
72 -255.5 -> -255
73 -255.1 -> -255
74 -255 -> -255
75 -254.9 -> -254
76 -254.5 -> -254
77 -254.1 -> -254
78 -254 -> -254
79 -129.9 -> -129
80 -129.5 -> -129
81 -129.1 -> -129
82 -129 -> -129
83 -128.9 -> -128
84 -128.5 -> -128
85 -128.1 -> -128
86 -128 -> -128
87 -127.9 -> -127
88 -127.5 -> -127
89 -127.1 -> -127
90 -127 -> -127
91 -126.9 -> -126
92 -126.5 -> -126
93 -126.1 -> -126
94 -126 -> -126
95 -1.9 -> -1
96 -1.5 -> -1
97 -1.1 -> -1
98 -1 -> -1
99 -0.9 -> 0
100 -0.5 -> 0
101 -0.1 -> 0
102 0 -> 0
103 0 -> 0
104 0.1 -> 0
105 0.5 -> 0
106 0.9 -> 0
107 1 -> 1
108 1.1 -> 1
109 1.5 -> 1
110 1.9 -> 1
111 126 -> 126
112 126.1 -> 126
113 126.5 -> 126
114 126.9 -> 126
115 127 -> 127
116 127.1 -> 127
117 127.5 -> 127
118 127.9 -> 127
119 128 -> 128
120 128.1 -> 128
121 128.5 -> 128
122 128.9 -> 128
123 129 -> 129
124 129.1 -> 129
125 129.5 -> 129
126 129.9 -> 129
127 254 -> 254
128 254.1 -> 254
129 254.5 -> 254
130 254.9 -> 254
131 255 -> 255
132 255.1 -> 255
133 255.5 -> 255
134 255.9 -> 255
135 256 -> 256
136 256.1 -> 256
137 256.5 -> 256
138 256.9 -> 256
139 257 -> 257
140 257.1 -> 257
141 257.5 -> 257
142 257.9 -> 257
143 272 -> 272
144 272.1 -> 272
145 272.5 -> 272
146 272.9 -> 272
147 273 -> 273
148 273.1 -> 273
149 273.5 -> 273
150 273.9 -> 273
151 274 -> 274
152 274.1 -> 274
153 274.5 -> 274
154 274.9 -> 274
155 32767 -> 32767
156 32767.1 -> 32767
157 32767.5 -> 32767
158 32767.9 -> 32767
159 32768 -> -32768
160 32768.1 -> -32768
161 32768.5 -> -32768
162 32768.9 -> -32768
163 32769 -> -32767
164 32769.1 -> -32767
165 32769.5 -> -32767
166 32769.9 -> -32767
167 65535 -> -1
168 65535.1 -> -1
169 65535.5 -> -1
170 65535.9 -> -1
171 65536 -> 0
172 65536.1 -> 0
173 65536.5 -> 0
174 65536.9 -> 0
175 65537 -> 1
176 65537.1 -> 1
177 65537.5 -> 1
178 65537.9 -> 1
179 2147483647 -> -1
180 2147483647.1 -> -1
181 2147483647.5 -> -1
182 2147483647.9 -> -1
183 2147483648 -> 0
184 2147483648.1 -> 0
185 2147483648.5 -> 0
186 2147483648.9 -> 0
187 2147483649 -> 1
188 2147483649.1 -> 1
189 2147483649.5 -> 1
190 2147483649.9 -> 1
191 4294967295 -> -1
192 4294967295.1 -> -1
193 4294967295.5 -> -1
194 4294967295.9 -> -1
195 4294967296 -> 0
196 4294967296.1 -> 0
197 4294967296.5 -> 0
198 4294967296.9 -> 0
199 4294967297 -> 1
200 4294967297.1 -> 1
201 4294967297.5 -> 1
202 4294967297.9 -> 1
203 1125899906842627 -> 3
204 Infinity -> 0
205 1e+100 -> 0
206 NaN -> 0
[object Uint16Array]
0 -Infinity -> 0
1 -1e+100 -> 0
2 -1125899906842627 -> 65533
3 -4294967297.9 -> 65535
4 -4294967297.5 -> 65535
5 -4294967297.1 -> 65535
6 -4294967297 -> 65535
7 -4294967296.9 -> 0
8 -4294967296.5 -> 0
9 -4294967296.1 -> 0
10 -4294967296 -> 0
11 -4294967295.9 -> 1
12 -4294967295.5 -> 1
13 -4294967295.1 -> 1
14 -4294967295 -> 1
15 -2147483649.9 -> 65535
16 -2147483649.5 -> 65535
17 -2147483649.1 -> 65535
18 -2147483649 -> 65535
19 -2147483648.9 -> 0
20 -2147483648.5 -> 0
21 -2147483648.1 -> 0
22 -2147483648 -> 0
23 -2147483647.9 -> 1
24 -2147483647.5 -> 1
25 -2147483647.1 -> 1
26 -2147483647 -> 1
27 -65537.9 -> 65535
28 -65537.5 -> 65535
29 -65537.1 -> 65535
30 -65537 -> 65535
31 -65536.9 -> 0
32 -65536.5 -> 0
33 -65536.1 -> 0
34 -65536 -> 0
35 -65535.9 -> 1
36 -65535.5 -> 1
37 -65535.1 -> 1
38 -65535 -> 1
39 -32769.9 -> 32767
40 -32769.5 -> 32767
41 -32769.1 -> 32767
42 -32769 -> 32767
43 -32768.9 -> 32768
44 -32768.5 -> 32768
45 -32768.1 -> 32768
46 -32768 -> 32768
47 -32767.9 -> 32769
48 -32767.5 -> 32769
49 -32767.1 -> 32769
50 -32767 -> 32769
51 -274.9 -> 65262
52 -274.5 -> 65262
53 -274.1 -> 65262
54 -274 -> 65262
55 -273.9 -> 65263
56 -273.5 -> 65263
57 -273.1 -> 65263
58 -273 -> 65263
59 -272.9 -> 65264
60 -272.5 -> 65264
61 -272.1 -> 65264
62 -272 -> 65264
63 -257.9 -> 65279
64 -257.5 -> 65279
65 -257.1 -> 65279
66 -257 -> 65279
67 -256.9 -> 65280
68 -256.5 -> 65280
69 -256.1 -> 65280
70 -256 -> 65280
71 -255.9 -> 65281
72 -255.5 -> 65281
73 -255.1 -> 65281
74 -255 -> 65281
75 -254.9 -> 65282
76 -254.5 -> 65282
77 -254.1 -> 65282
78 -254 -> 65282
79 -129.9 -> 65407
80 -129.5 -> 65407
81 -129.1 -> 65407
82 -129 -> 65407
83 -128.9 -> 65408
84 -128.5 -> 65408
85 -128.1 -> 65408
86 -128 -> 65408
87 -127.9 -> 65409
88 -127.5 -> 65409
89 -127.1 -> 65409
90 -127 -> 65409
91 -126.9 -> 65410
92 -126.5 -> 65410
93 -126.1 -> 65410
94 -126 -> 65410
95 -1.9 -> 65535
96 -1.5 -> 65535
97 -1.1 -> 65535
98 -1 -> 65535
99 -0.9 -> 0
100 -0.5 -> 0
101 -0.1 -> 0
102 0 -> 0
103 0 -> 0
104 0.1 -> 0
105 0.5 -> 0
106 0.9 -> 0
107 1 -> 1
108 1.1 -> 1
109 1.5 -> 1
110 1.9 -> 1
111 126 -> 126
112 126.1 -> 126
113 126.5 -> 126
114 126.9 -> 126
115 127 -> 127
116 127.1 -> 127
117 127.5 -> 127
118 127.9 -> 127
119 128 -> 128
120 128.1 -> 128
121 128.5 -> 128
122 128.9 -> 128
123 129 -> 129
124 129.1 -> 129
125 129.5 -> 129
126 129.9 -> 129
127 254 -> 254
128 254.1 -> 254
129 254.5 -> 254
130 254.9 -> 254
131 255 -> 255
132 255.1 -> 255
133 255.5 -> 255
134 255.9 -> 255
135 256 -> 256
136 256.1 -> 256
137 256.5 -> 256
138 256.9 -> 256
139 257 -> 257
140 257.1 -> 257
141 257.5 -> 257
142 257.9 -> 257
143 272 -> 272
144 272.1 -> 272
145 272.5 -> 272
146 272.9 -> 272
147 273 -> 273
148 273.1 -> 273
149 273.5 -> 273
150 273.9 -> 273
151 274 -> 274
152 274.1 -> 274
153 274.5 -> 274
154 274.9 -> 274
155 32767 -> 32767
156 32767.1 -> 32767
157 32767.5 -> 32767
158 32767.9 -> 32767
159 32768 -> 32768
160 32768.1 -> 32768
161 32768.5 -> 32768
162 32768.9 -> 32768
163 32769 -> 32769
164 32769.1 -> 32769
165 32769.5 -> 32769
166 32769.9 -> 32769
167 65535 -> 65535
168 65535.1 -> 65535
169 65535.5 -> 65535
170 65535.9 -> 65535
171 65536 -> 0
172 65536.1 -> 0
173 65536.5 -> 0
174 65536.9 -> 0
175 65537 -> 1
176 65537.1 -> 1
177 65537.5 -> 1
178 65537.9 -> 1
179 2147483647 -> 65535
180 2147483647.1 -> 65535
181 2147483647.5 -> 65535
182 2147483647.9 -> 65535
183 2147483648 -> 0
184 2147483648.1 -> 0
185 2147483648.5 -> 0
186 2147483648.9 -> 0
187 2147483649 -> 1
188 2147483649.1 -> 1
189 2147483649.5 -> 1
190 2147483649.9 -> 1
191 4294967295 -> 65535
192 4294967295.1 -> 65535
193 4294967295.5 -> 65535
194 4294967295.9 -> 65535
195 4294967296 -> 0
196 4294967296.1 -> 0
197 4294967296.5 -> 0
198 4294967296.9 -> 0
199 4294967297 -> 1
200 4294967297.1 -> 1
201 4294967297.5 -> 1
202 4294967297.9 -> 1
203 1125899906842627 -> 3
204 Infinity -> 0
205 1e+100 -> 0
206 NaN -> 0
[object Int32Array]
0 -Infinity -> 0
1 -1e+100 -> 0
2 -1125899906842627 -> -3
3 -4294967297.9 -> -1
4 -4294967297.5 -> -1
5 -4294967297.1 -> -1
6 -4294967297 -> -1
7 -4294967296.9 -> 0
8 -4294967296.5 -> 0
9 -4294967296.1 -> 0
10 -4294967296 -> 0
11 -4294967295.9 -> 1
12 -4294967295.5 -> 1
13 -4294967295.1 -> 1
14 -4294967295 -> 1
15 -2147483649.9 -> 2147483647
16 -2147483649.5 -> 2147483647
17 -2147483649.1 -> 2147483647
18 -2147483649 -> 2147483647
19 -2147483648.9 -> -2147483648
20 -2147483648.5 -> -2147483648
21 -2147483648.1 -> -2147483648
22 -2147483648 -> -2147483648
23 -2147483647.9 -> -2147483647
24 -2147483647.5 -> -2147483647
25 -2147483647.1 -> -2147483647
26 -2147483647 -> -2147483647
27 -65537.9 -> -65537
28 -65537.5 -> -65537
29 -65537.1 -> -65537
30 -65537 -> -65537
31 -65536.9 -> -65536
32 -65536.5 -> -65536
33 -65536.1 -> -65536
34 -65536 -> -65536
35 -65535.9 -> -65535
36 -65535.5 -> -65535
37 -65535.1 -> -65535
38 -65535 -> -65535
39 -32769.9 -> -32769
40 -32769.5 -> -32769
41 -32769.1 -> -32769
42 -32769 -> -32769
43 -32768.9 -> -32768
44 -32768.5 -> -32768
45 -32768.1 -> -32768
46 -32768 -> -32768
47 -32767.9 -> -32767
48 -32767.5 -> -32767
49 -32767.1 -> -32767
50 -32767 -> -32767
51 -274.9 -> -274
52 -274.5 -> -274
53 -274.1 -> -274
54 -274 -> -274
55 -273.9 -> -273
56 -273.5 -> -273
57 -273.1 -> -273
58 -273 -> -273
59 -272.9 -> -272
60 -272.5 -> -272
61 -272.1 -> -272
62 -272 -> -272
63 -257.9 -> -257
64 -257.5 -> -257
65 -257.1 -> -257
66 -257 -> -257
67 -256.9 -> -256
68 -256.5 -> -256
69 -256.1 -> -256
70 -256 -> -256
71 -255.9 -> -255
72 -255.5 -> -255
73 -255.1 -> -255
74 -255 -> -255
75 -254.9 -> -254
76 -254.5 -> -254
77 -254.1 -> -254
78 -254 -> -254
79 -129.9 -> -129
80 -129.5 -> -129
81 -129.1 -> -129
82 -129 -> -129
83 -128.9 -> -128
84 -128.5 -> -128
85 -128.1 -> -128
86 -128 -> -128
87 -127.9 -> -127
88 -127.5 -> -127
89 -127.1 -> -127
90 -127 -> -127
91 -126.9 -> -126
92 -126.5 -> -126
93 -126.1 -> -126
94 -126 -> -126
95 -1.9 -> -1
96 -1.5 -> -1
97 -1.1 -> -1
98 -1 -> -1
99 -0.9 -> 0
100 -0.5 -> 0
101 -0.1 -> 0
102 0 -> 0
103 0 -> 0
104 0.1 -> 0
105 0.5 -> 0
106 0.9 -> 0
107 1 -> 1
108 1.1 -> 1
109 1.5 -> 1
110 1.9 -> 1
111 126 -> 126
112 126.1 -> 126
113 126.5 -> 126
114 126.9 -> 126
115 127 -> 127
116 127.1 -> 127
117 127.5 -> 127
118 127.9 -> 127
119 128 -> 128
120 128.1 -> 128
121 128.5 -> 128
122 128.9 -> 128
123 129 -> 129
124 129.1 -> 129
125 129.5 -> 129
126 129.9 -> 129
127 254 -> 254
128 254.1 -> 254
129 254.5 -> 254
130 254.9 -> 254
131 255 -> 255
132 255.1 -> 255
133 255.5 -> 255
134 255.9 -> 255
135 256 -> 256
136 256.1 -> 256
137 256.5 -> 256
138 256.9 -> 256
139 257 -> 257
140 257.1 -> 257
141 257.5 -> 257
142 257.9 -> 257
143 272 -> 272
144 272.1 -> 272
145 272.5 -> 272
146 272.9 -> 272
147 273 -> 273
148 273.1 -> 273
149 273.5 -> 273
150 273.9 -> 273
151 274 -> 274
152 274.1 -> 274
153 274.5 -> 274
154 274.9 -> 274
155 32767 -> 32767
156 32767.1 -> 32767
157 32767.5 -> 32767
158 32767.9 -> 32767
159 32768 -> 32768
160 32768.1 -> 32768
161 32768.5 -> 32768
162 32768.9 -> 32768
163 32769 -> 32769
164 32769.1 -> 32769
165 32769.5 -> 32769
166 32769.9 -> 32769
167 65535 -> 65535
168 65535.1 -> 65535
169 65535.5 -> 65535
170 65535.9 -> 65535
171 65536 -> 65536
172 65536.1 -> 65536
173 65536.5 -> 65536
174 65536.9 -> 65536
175 65537 -> 65537
176 65537.1 -> 65537
177 65537.5 -> 65537
178 65537.9 -> 65537
179 2147483647 -> 2147483647
180 2147483647.1 -> 2147483647
181 2147483647.5 -> 2147483647
182 2147483647.9 -> 2147483647
183 2147483648 -> -2147483648
184 2147483648.1 -> -2147483648
185 2147483648.5 -> -2147483648
186 2147483648.9 -> -2147483648
187 2147483649 -> -2147483647
188 2147483649.1 -> -2147483647
189 2147483649.5 -> -2147483647
190 2147483649.9 -> -2147483647
191 4294967295 -> -1
192 4294967295.1 -> -1
193 4294967295.5 -> -1
194 4294967295.9 -> -1
195 4294967296 -> 0
196 4294967296.1 -> 0
197 4294967296.5 -> 0
198 4294967296.9 -> 0
199 4294967297 -> 1
200 4294967297.1 -> 1
201 4294967297.5 -> 1
202 4294967297.9 -> 1
203 1125899906842627 -> 3
204 Infinity -> 0
205 1e+100 -> 0
206 NaN -> 0
[object Uint32Array]
0 -Infinity -> 0
1 -1e+100 -> 0
2 -1125899906842627 -> 4294967293
3 -4294967297.9 -> 4294967295
4 -4294967297.5 -> 4294967295
5 -4294967297.1 -> 4294967295
6 -4294967297 -> 4294967295
7 -4294967296.9 -> 0
8 -4294967296.5 -> 0
9 -4294967296.1 -> 0
10 -4294967296 -> 0
11 -4294967295.9 -> 1
12 -4294967295.5 -> 1
13 -4294967295.1 -> 1
14 -4294967295 -> 1
15 -2147483649.9 -> 2147483647
16 -2147483649.5 -> 2147483647
17 -2147483649.1 -> 2147483647
18 -2147483649 -> 2147483647
19 -2147483648.9 -> 2147483648
20 -2147483648.5 -> 2147483648
21 -2147483648.1 -> 2147483648
22 -2147483648 -> 2147483648
23 -2147483647.9 -> 2147483649
24 -2147483647.5 -> 2147483649
25 -2147483647.1 -> 2147483649
26 -2147483647 -> 2147483649
27 -65537.9 -> 4294901759
28 -65537.5 -> 4294901759
29 -65537.1 -> 4294901759
30 -65537 -> 4294901759
31 -65536.9 -> 4294901760
32 -65536.5 -> 4294901760
33 -65536.1 -> 4294901760
34 -65536 -> 4294901760
35 -65535.9 -> 4294901761
36 -65535.5 -> 4294901761
37 -65535.1 -> 4294901761
38 -65535 -> 4294901761
39 -32769.9 -> 4294934527
40 -32769.5 -> 4294934527
41 -32769.1 -> 4294934527
42 -32769 -> 4294934527
43 -32768.9 -> 4294934528
44 -32768.5 -> 4294934528
45 -32768.1 -> 4294934528
46 -32768 -> 4294934528
47 -32767.9 -> 4294934529
48 -32767.5 -> 4294934529
49 -32767.1 -> 4294934529
50 -32767 -> 4294934529
51 -274.9 -> 4294967022
52 -274.5 -> 4294967022
53 -274.1 -> 4294967022
54 -274 -> 4294967022
55 -273.9 -> 4294967023
56 -273.5 -> 4294967023
57 -273.1 -> 4294967023
58 -273 -> 4294967023
59 -272.9 -> 4294967024
60 -272.5 -> 4294967024
61 -272.1 -> 4294967024
62 -272 -> 4294967024
63 -257.9 -> 4294967039
64 -257.5 -> 4294967039
65 -257.1 -> 4294967039
66 -257 -> 4294967039
67 -256.9 -> 4294967040
68 -256.5 -> 4294967040
69 -256.1 -> 4294967040
70 -256 -> 4294967040
71 -255.9 -> 4294967041
72 -255.5 -> 4294967041
73 -255.1 -> 4294967041
74 -255 -> 4294967041
75 -254.9 -> 4294967042
76 -254.5 -> 4294967042
77 -254.1 -> 4294967042
78 -254 -> 4294967042
79 -129.9 -> 4294967167
80 -129.5 -> 4294967167
81 -129.1 -> 4294967167
82 -129 -> 4294967167
83 -128.9 -> 4294967168
84 -128.5 -> 4294967168
85 -128.1 -> 4294967168
86 -128 -> 4294967168
87 -127.9 -> 4294967169
88 -127.5 -> 4294967169
89 -127.1 -> 4294967169
90 -127 -> 4294967169
91 -126.9 -> 4294967170
92 -126.5 -> 4294967170
93 -126.1 -> 4294967170
94 -126 -> 4294967170
95 -1.9 -> 4294967295
96 -1.5 -> 4294967295
97 -1.1 -> 4294967295
98 -1 -> 4294967295
99 -0.9 -> 0
100 -0.5 -> 0
101 -0.1 -> 0
102 0 -> 0
103 0 -> 0
104 0.1 -> 0
105 0.5 -> 0
106 0.9 -> 0
107 1 -> 1
108 1.1 -> 1
109 1.5 -> 1
110 1.9 -> 1
111 126 -> 126
112 126.1 -> 126
113 126.5 -> 126
114 126.9 -> 126
115 127 -> 127
116 127.1 -> 127
117 127.5 -> 127
118 127.9 -> 127
119 128 -> 128
120 128.1 -> 128
121 128.5 -> 128
122 128.9 -> 128
123 129 -> 129
124 129.1 -> 129
125 129.5 -> 129
126 129.9 -> 129
127 254 -> 254
128 254.1 -> 254
129 254.5 -> 254
130 254.9 -> 254
131 255 -> 255
132 255.1 -> 255
133 255.5 -> 255
134 255.9 -> 255
135 256 -> 256
136 256.1 -> 256
137 256.5 -> 256
138 256.9 -> 256
139 257 -> 257
140 257.1 -> 257
141 257.5 -> 257
142 257.9 -> 257
143 272 -> 272
144 272.1 -> 272
145 272.5 -> 272
146 272.9 -> 272
147 273 -> 273
148 273.1 -> 273
149 273.5 -> 273
150 273.9 -> 273
151 274 -> 274
152 274.1 -> 274
153 274.5 -> 274
154 274.9 -> 274
155 32767 -> 32767
156 32767.1 -> 32767
157 32767.5 -> 32767
158 32767.9 -> 32767
159 32768 -> 32768
160 32768.1 -> 32768
161 32768.5 -> 32768
162 32768.9 -> 32768
163 32769 -> 32769
164 32769.1 -> 32769
165 32769.5 -> 32769
166 32769.9 -> 32769
167 65535 -> 65535
168 65535.1 -> 65535
169 65535.5 -> 65535
170 65535.9 -> 65535
171 65536 -> 65536
172 65536.1 -> 65536
173 65536.5 -> 65536
174 65536.9 -> 65536
175 65537 -> 65537
176 65537.1 -> 65537
177 65537.5 -> 65537
178 65537.9 -> 65537
179 2147483647 -> 2147483647
180 2147483647.1 -> 2147483647
181 2147483647.5 -> 2147483647
182 2147483647.9 -> 2147483647
183 2147483648 -> 2147483648
184 2147483648.1 -> 2147483648
185 2147483648.5 -> 2147483648
186 2147483648.9 -> 2147483648
187 2147483649 -> 2147483649
188 2147483649.1 -> 2147483649
189 2147483649.5 -> 2147483649
190 2147483649.9 -> 2147483649
191 4294967295 -> 4294967295
192 4294967295.1 -> 4294967295
193 4294967295.5 -> 4294967295
194 4294967295.9 -> 4294967295
195 4294967296 -> 0
196 4294967296.1 -> 0
197 4294967296.5 -> 0
198 4294967296.9 -> 0
199 4294967297 -> 1
200 4294967297.1 -> 1
201 4294967297.5 -> 1
202 4294967297.9 -> 1
203 1125899906842627 -> 3
204 Infinity -> 0
205 1e+100 -> 0
206 NaN -> 0
[object Float32Array]
0 -Infinity -> -Infinity
1 -1e+100 -> -Infinity
2 -1125899906842627 -> -1125899906842624
3 -4294967297.9 -> -4294967296
4 -4294967297.5 -> -4294967296
5 -4294967297.1 -> -4294967296
6 -4294967297 -> -4294967296
7 -4294967296.9 -> -4294967296
8 -4294967296.5 -> -4294967296
9 -4294967296.1 -> -4294967296
10 -4294967296 -> -4294967296
11 -4294967295.9 -> -4294967296
12 -4294967295.5 -> -4294967296
13 -4294967295.1 -> -4294967296
14 -4294967295 -> -4294967296
15 -2147483649.9 -> -2147483648
16 -2147483649.5 -> -2147483648
17 -2147483649.1 -> -2147483648
18 -2147483649 -> -2147483648
19 -2147483648.9 -> -2147483648
20 -2147483648.5 -> -2147483648
21 -2147483648.1 -> -2147483648
22 -2147483648 -> -2147483648
23 -2147483647.9 -> -2147483648
24 -2147483647.5 -> -2147483648
25 -2147483647.1 -> -2147483648
26 -2147483647 -> -2147483648
27 -65537.9 -> -65537.8984375
28 -65537.5 -> -65537.5
29 -65537.1 -> -65537.1015625
30 -65537 -> -65537
31 -65536.9 -> -65536.8984375
32 -65536.5 -> -65536.5
33 -65536.1 -> -65536.1015625
34 -65536 -> -65536
35 -65535.9 -> -65535.8984375
36 -65535.5 -> -65535.5
37 -65535.1 -> -65535.1015625
38 -65535 -> -65535
39 -32769.9 -> -32769.8984375
40 -32769.5 -> -32769.5
41 -32769.1 -> -32769.1015625
42 -32769 -> -32769
43 -32768.9 -> -32768.8984375
44 -32768.5 -> -32768.5
45 -32768.1 -> -32768.1015625
46 -32768 -> -32768
47 -32767.9 -> -32767.900390625
48 -32767.5 -> -32767.5
49 -32767.1 -> -32767.099609375
50 -32767 -> -32767
51 -274.9 -> -274.8999938964844
52 -274.5 -> -274.5
53 -274.1 -> -274.1000061035156
54 -274 -> -274
55 -273.9 -> -273.8999938964844
56 -273.5 -> -273.5
57 -273.1 -> -273.1000061035156
58 -273 -> -273
59 -272.9 -> -272.8999938964844
60 -272.5 -> -272.5
61 -272.1 -> -272.1000061035156
62 -272 -> -272
63 -257.9 -> -257.8999938964844
64 -257.5 -> -257.5
65 -257.1 -> -257.1000061035156
66 -257 -> -257
67 -256.9 -> -256.8999938964844
68 -256.5 -> -256.5
69 -256.1 -> -256.1000061035156
70 -256 -> -256
71 -255.9 -> -255.89999389648438
72 -255.5 -> -255.5
73 -255.1 -> -255.10000610351563
74 -255 -> -255
75 -254.9 -> -254.89999389648438
76 -254.5 -> -254.5
77 -254.1 -> -254.10000610351563
78 -254 -> -254
79 -129.9 -> -129.89999389648438
80 -129.5 -> -129.5
81 -129.1 -> -129.10000610351563
82 -129 -> -129
83 -128.9 -> -128.89999389648438
84 -128.5 -> -128.5
85 -128.1 -> -128.10000610351563
86 -128 -> -128
87 -127.9 -> -127.9000015258789
88 -127.5 -> -127.5
89 -127.1 -> -127.0999984741211
90 -127 -> -127
91 -126.9 -> -126.9000015258789
92 -126.5 -> -126.5
93 -126.1 -> -126.0999984741211
94 -126 -> -126
95 -1.9 -> -1.899999976158142
96 -1.5 -> -1.5
97 -1.1 -> -1.100000023841858
98 -1 -> -1
99 -0.9 -> -0.8999999761581421
100 -0.5 -> -0.5
101 -0.1 -> -0.10000000149011612
102 0 -> -0
103 0 -> 0
104 0.1 -> 0.10000000149011612
105 0.5 -> 0.5
106 0.9 -> 0.8999999761581421
107 1 -> 1
108 1.1 -> 1.100000023841858
109 1.5 -> 1.5
110 1.9 -> 1.899999976158142
111 126 -> 126
112 126.1 -> 126.0999984741211
113 126.5 -> 126.5
114 126.9 -> 126.9000015258789
115 127 -> 127
116 127.1 -> 127.0999984741211
117 127.5 -> 127.5
118 127.9 -> 127.9000015258789
119 128 -> 128
120 128.1 -> 128.10000610351563
121 128.5 -> 128.5
122 128.9 -> 128.89999389648438
123 129 -> 129
124 129.1 -> 129.10000610351563
125 129.5 -> 129.5
126 129.9 -> 129.89999389648438
127 254 -> 254
128 254.1 -> 254.10000610351563
129 254.5 -> 254.5
130 254.9 -> 254.89999389648438
131 255 -> 255
132 255.1 -> 255.10000610351563
133 255.5 -> 255.5
134 255.9 -> 255.89999389648438
135 256 -> 256
136 256.1 -> 256.1000061035156
137 256.5 -> 256.5
138 256.9 -> 256.8999938964844
139 257 -> 257
140 257.1 -> 257.1000061035156
141 257.5 -> 257.5
142 257.9 -> 257.8999938964844
143 272 -> 272
144 272.1 -> 272.1000061035156
145 272.5 -> 272.5
146 272.9 -> 272.8999938964844
147 273 -> 273
148 273.1 -> 273.1000061035156
149 273.5 -> 273.5
150 273.9 -> 273.8999938964844
151 274 -> 274
152 274.1 -> 274.1000061035156
153 274.5 -> 274.5
154 274.9 -> 274.8999938964844
155 32767 -> 32767
156 32767.1 -> 32767.099609375
157 32767.5 -> 32767.5
158 32767.9 -> 32767.900390625
159 32768 -> 32768
160 32768.1 -> 32768.1015625
161 32768.5 -> 32768.5
162 32768.9 -> 32768.8984375
163 32769 -> 32769
164 32769.1 -> 32769.1015625
165 32769.5 -> 32769.5
166 32769.9 -> 32769.8984375
167 65535 -> 65535
168 65535.1 -> 65535.1015625
169 65535.5 -> 65535.5
170 65535.9 -> 65535.8984375
171 65536 -> 65536
172 65536.1 -> 65536.1015625
173 65536.5 -> 65536.5
174 65536.9 -> 65536.8984375
175 65537 -> 65537
176 65537.1 -> 65537.1015625
177 65537.5 -> 65537.5
178 65537.9 -> 65537.8984375
179 2147483647 -> 2147483648
180 2147483647.1 -> 2147483648
181 2147483647.5 -> 2147483648
182 2147483647.9 -> 2147483648
183 2147483648 -> 2147483648
184 2147483648.1 -> 2147483648
185 2147483648.5 -> 2147483648
186 2147483648.9 -> 2147483648
187 2147483649 -> 2147483648
188 2147483649.1 -> 2147483648
189 2147483649.5 -> 2147483648
190 2147483649.9 -> 2147483648
191 4294967295 -> 4294967296
192 4294967295.1 -> 4294967296
193 4294967295.5 -> 4294967296
194 4294967295.9 -> 4294967296
195 4294967296 -> 4294967296
196 4294967296.1 -> 4294967296
197 4294967296.5 -> 4294967296
198 4294967296.9 -> 4294967296
199 4294967297 -> 4294967296
200 4294967297.1 -> 4294967296
201 4294967297.5 -> 4294967296
202 4294967297.9 -> 4294967296
203 1125899906842627 -> 1125899906842624
204 Infinity -> Infinity
205 1e+100 -> Infinity
206 NaN -> NaN
[object Float64Array]
0 -Infinity -> -Infinity
1 -1e+100 -> -1e+100
2 -1125899906842627 -> -1125899906842627
3 -4294967297.9 -> -4294967297.9
4 -4294967297.5 -> -4294967297.5
5 -4294967297.1 -> -4294967297.1
6 -4294967297 -> -4294967297
7 -4294967296.9 -> -4294967296.9
8 -4294967296.5 -> -4294967296.5
9 -4294967296.1 -> -4294967296.1
10 -4294967296 -> -4294967296
11 -4294967295.9 -> -4294967295.9
12 -4294967295.5 -> -4294967295.5
13 -4294967295.1 -> -4294967295.1
14 -4294967295 -> -4294967295
15 -2147483649.9 -> -2147483649.9
16 -2147483649.5 -> -2147483649.5
17 -2147483649.1 -> -2147483649.1
18 -2147483649 -> -2147483649
19 -2147483648.9 -> -2147483648.9
20 -2147483648.5 -> -2147483648.5
21 -2147483648.1 -> -2147483648.1
22 -2147483648 -> -2147483648
23 -2147483647.9 -> -2147483647.9
24 -2147483647.5 -> -2147483647.5
25 -2147483647.1 -> -2147483647.1
26 -2147483647 -> -2147483647
27 -65537.9 -> -65537.9
28 -65537.5 -> -65537.5
29 -65537.1 -> -65537.1
30 -65537 -> -65537
31 -65536.9 -> -65536.9
32 -65536.5 -> -65536.5
33 -65536.1 -> -65536.1
34 -65536 -> -65536
35 -65535.9 -> -65535.9
36 -65535.5 -> -65535.5
37 -65535.1 -> -65535.1
38 -65535 -> -65535
39 -32769.9 -> -32769.9
40 -32769.5 -> -32769.5
41 -32769.1 -> -32769.1
42 -32769 -> -32769
43 -32768.9 -> -32768.9
44 -32768.5 -> -32768.5
45 -32768.1 -> -32768.1
46 -32768 -> -32768
47 -32767.9 -> -32767.9
48 -32767.5 -> -32767.5
49 -32767.1 -> -32767.1
50 -32767 -> -32767
51 -274.9 -> -274.9
52 -274.5 -> -274.5
53 -274.1 -> -274.1
54 -274 -> -274
55 -273.9 -> -273.9
56 -273.5 -> -273.5
57 -273.1 -> -273.1
58 -273 -> -273
59 -272.9 -> -272.9
60 -272.5 -> -272.5
61 -272.1 -> -272.1
62 -272 -> -272
63 -257.9 -> -257.9
64 -257.5 -> -257.5
65 -257.1 -> -257.1
66 -257 -> -257
67 -256.9 -> -256.9
68 -256.5 -> -256.5
69 -256.1 -> -256.1
70 -256 -> -256
71 -255.9 -> -255.9
72 -255.5 -> -255.5
73 -255.1 -> -255.1
74 -255 -> -255
75 -254.9 -> -254.9
76 -254.5 -> -254.5
77 -254.1 -> -254.1
78 -254 -> -254
79 -129.9 -> -129.9
80 -129.5 -> -129.5
81 -129.1 -> -129.1
82 -129 -> -129
83 -128.9 -> -128.9
84 -128.5 -> -128.5
85 -128.1 -> -128.1
86 -128 -> -128
87 -127.9 -> -127.9
88 -127.5 -> -127.5
89 -127.1 -> -127.1
90 -127 -> -127
91 -126.9 -> -126.9
92 -126.5 -> -126.5
93 -126.1 -> -126.1
94 -126 -> -126
95 -1.9 -> -1.9
96 -1.5 -> -1.5
97 -1.1 -> -1.1
98 -1 -> -1
99 -0.9 -> -0.9
100 -0.5 -> -0.5
101 -0.1 -> -0.1
102 0 -> -0
103 0 -> 0
104 0.1 -> 0.1
105 0.5 -> 0.5
106 0.9 -> 0.9
107 1 -> 1
108 1.1 -> 1.1
109 1.5 -> 1.5
110 1.9 -> 1.9
111 126 -> 126
112 126.1 -> 126.1
113 126.5 -> 126.5
114 126.9 -> 126.9
115 127 -> 127
116 127.1 -> 127.1
117 127.5 -> 127.5
118 127.9 -> 127.9
119 128 -> 128
120 128.1 -> 128.1
121 128.5 -> 128.5
122 128.9 -> 128.9
123 129 -> 129
124 129.1 -> 129.1
125 129.5 -> 129.5
126 129.9 -> 129.9
127 254 -> 254
128 254.1 -> 254.1
129 254.5 -> 254.5
130 254.9 -> 254.9
131 255 -> 255
132 255.1 -> 255.1
133 255.5 -> 255.5
134 255.9 -> 255.9
135 256 -> 256
136 256.1 -> 256.1
137 256.5 -> 256.5
138 256.9 -> 256.9
139 257 -> 257
140 257.1 -> 257.1
141 257.5 -> 257.5
142 257.9 -> 257.9
143 272 -> 272
144 272.1 -> 272.1
145 272.5 -> 272.5
146 272.9 -> 272.9
147 273 -> 273
148 273.1 -> 273.1
149 273.5 -> 273.5
150 273.9 -> 273.9
151 274 -> 274
152 274.1 -> 274.1
153 274.5 -> 274.5
154 274.9 -> 274.9
155 32767 -> 32767
156 32767.1 -> 32767.1
157 32767.5 -> 32767.5
158 32767.9 -> 32767.9
159 32768 -> 32768
160 32768.1 -> 32768.1
161 32768.5 -> 32768.5
162 32768.9 -> 32768.9
163 32769 -> 32769
164 32769.1 -> 32769.1
165 32769.5 -> 32769.5
166 32769.9 -> 32769.9
167 65535 -> 65535
168 65535.1 -> 65535.1
169 65535.5 -> 65535.5
170 65535.9 -> 65535.9
171 65536 -> 65536
172 65536.1 -> 65536.1
173 65536.5 -> 65536.5
174 65536.9 -> 65536.9
175 65537 -> 65537
176 65537.1 -> 65537.1
177 65537.5 -> 65537.5
178 65537.9 -> 65537.9
179 2147483647 -> 2147483647
180 2147483647.1 -> 2147483647.1
181 2147483647.5 -> 2147483647.5
182 2147483647.9 -> 2147483647.9
183 2147483648 -> 2147483648
184 2147483648.1 -> 2147483648.1
185 2147483648.5 -> 2147483648.5
186 2147483648.9 -> 2147483648.9
187 2147483649 -> 2147483649
188 2147483649.1 -> 2147483649.1
189 2147483649.5 -> 2147483649.5
190 2147483649.9 -> 2147483649.9
191 4294967295 -> 4294967295
192 4294967295.1 -> 4294967295.1
193 4294967295.5 -> 4294967295.5
194 4294967295.9 -> 4294967295.9
195 4294967296 -> 4294967296
196 4294967296.1 -> 4294967296.1
197 4294967296.5 -> 4294967296.5
198 4294967296.9 -> 4294967296.9
199 4294967297 -> 4294967297
200 4294967297.1 -> 4294967297.1
201 4294967297.5 -> 4294967297.5
202 4294967297.9 -> 4294967297.9
203 1125899906842627 -> 1125899906842627
204 Infinity -> Infinity
205 1e+100 -> 1e+100
206 NaN -> NaN
===*/

function coercionTest() {
    var objs = getBufferTestObjectList();
    var vals = [
        Number.NEGATIVE_INFINITY,
        -1e100,
        -1125899906842627,  // -(2^50 + 3)

        -0x100000001 - 0.9, -0x100000001 - 0.5, -0x100000001 - 0.1, -0x100000001,
        -0x100000000 - 0.9, -0x100000000 - 0.5, -0x100000000 - 0.1, -0x100000000,
        -0xffffffff - 0.9,  -0xffffffff - 0.5,  -0xffffffff - 0.1,  -0xffffffff,
        -0x80000001 - 0.9,  -0x80000001 - 0.5,  -0x80000001 - 0.1,  -0x80000001,
        -0x80000000 - 0.9,  -0x80000000 - 0.5,  -0x80000000 - 0.1,  -0x80000000,
        -0x7fffffff - 0.9,  -0x7fffffff - 0.5,  -0x7fffffff - 0.1,  -0x7fffffff,
        -0x10001 - 0.9,     -0x10001 - 0.5,     -0x10001 - 0.1,     -0x10001,
        -0x10000 - 0.9,     -0x10000 - 0.5,     -0x10000 - 0.1,     -0x10000,
        -0xffff - 0.9,      -0xffff - 0.5,      -0xffff - 0.1,      -0xffff,
        -0x8001 - 0.9,      -0x8001 - 0.5,      -0x8001 - 0.1,      -0x8001,
        -0x8000 - 0.9,      -0x8000 - 0.5,      -0x8000 - 0.1,      -0x8000,
        -0x7fff - 0.9,      -0x7fff - 0.5,      -0x7fff - 0.1,      -0x7fff,
        -0x112 - 0.9,       -0x112 - 0.5,       -0x112 - 0.1,       -0x112,
        -0x111 - 0.9,       -0x111 - 0.5,       -0x111 - 0.1,       -0x111,
        -0x110 - 0.9,       -0x110 - 0.5,       -0x110 - 0.1,       -0x110,
        -0x101 - 0.9,       -0x101 - 0.5,       -0x101 - 0.1,       -0x101,
        -0x100 - 0.9,       -0x100 - 0.5,       -0x100 - 0.1,       -0x100,
        -0xff - 0.9,        -0xff - 0.5,        -0xff - 0.1,        -0xff,
        -0xfe - 0.9,        -0xfe - 0.5,        -0xfe - 0.1,        -0xfe,
        -0x81 - 0.9,        -0x81 - 0.5,        -0x81 - 0.1,        -0x81,
        -0x80 - 0.9,        -0x80 - 0.5,        -0x80 - 0.1,        -0x80,
        -0x7f - 0.9,        -0x7f - 0.5,        -0x7f - 0.1,        -0x7f,
        -0x7e - 0.9,        -0x7e - 0.5,        -0x7e - 0.1,        -0x7e,
        -1.9,               -1.5,               -1.1,               -1.0,
        -0.9,               -0.5,               -0.1,               -0,

        0,                  0.1,                0.5,                0.9,
        1,                  1.1,                1.5,                1.9,
        0x7e,               0x7e + 0.1,         0x7e + 0.5,         0x7e + 0.9,
        0x7f,               0x7f + 0.1,         0x7f + 0.5,         0x7f + 0.9,
        0x80,               0x80 + 0.1,         0x80 + 0.5,         0x80 + 0.9,
        0x81,               0x81 + 0.1,         0x81 + 0.5,         0x81 + 0.9,
        0xfe,               0xfe + 0.1,         0xfe + 0.5,         0xfe + 0.9,
        0xff,               0xff + 0.1,         0xff + 0.5,         0xff + 0.9,
        0x100,              0x100 + 0.1,        0x100 + 0.5,        0x100 + 0.9,
        0x101,              0x101 + 0.1,        0x101 + 0.5,        0x101 + 0.9,
        0x110,              0x110 + 0.1,        0x110 + 0.5,        0x110 + 0.9,
        0x111,              0x111 + 0.1,        0x111 + 0.5,        0x111 + 0.9,
        0x112,              0x112 + 0.1,        0x112 + 0.5,        0x112 + 0.9,
        0x7fff,             0x7fff + 0.1,       0x7fff + 0.5,       0x7fff + 0.9,
        0x8000,             0x8000 + 0.1,       0x8000 + 0.5,       0x8000 + 0.9,
        0x8001,             0x8001 + 0.1,       0x8001 + 0.5,       0x8001 + 0.9,
        0xffff,             0xffff + 0.1,       0xffff + 0.5,       0xffff + 0.9,
        0x10000,            0x10000 + 0.1,      0x10000 + 0.5,      0x10000 + 0.9,
        0x10001,            0x10001 + 0.1,      0x10001 + 0.5,      0x10001 + 0.9,
        0x7fffffff,         0x7fffffff + 0.1,   0x7fffffff + 0.5,   0x7fffffff + 0.9,
        0x80000000,         0x80000000 + 0.1,   0x80000000 + 0.5,   0x80000000 + 0.9,
        0x80000001,         0x80000001 + 0.1,   0x80000001 + 0.5,   0x80000001 + 0.9,
        0xffffffff,         0xffffffff + 0.1,   0xffffffff + 0.5,   0xffffffff + 0.9,
        0x100000000,        0x100000000 + 0.1,  0x100000000 + 0.5,  0x100000000 + 0.9,
        0x100000001,        0x100000001 + 0.1,  0x100000001 + 0.5,  0x100000001 + 0.9,

        1125899906842627,  // -(2^50 + 3)
        Number.POSITIVE_INFINITY,
        1e100,

        0.0 / 0.0   // NaN
    ];

    // ES2015 coercion:
    //    - http://www.ecma-international.org/ecma-262/6.0/index.html#table-49
    //    - http://www.ecma-international.org/ecma-262/6.0/index.html#sec-touint8clamp (Uint8ClampedArray)

    objs.forEach(function (b, i) {
        print(Object.prototype.toString.call(b));
        if ({ '[object DataView]': true, '[object ArrayBuffer]': true }[Object.prototype.toString.call(b)]) {
            print('- skipped');  // no virtual indices
            return;
        }
        vals.forEach(function (v, j) {
            b[0] = v;
            print(j, v, '->', Test.valueToString(b[0]));
        });
    });
}

try {
    print('coercion test');
    coercionTest();
} catch (e) {
    print(e.stack || e);
}
