.\" dpkg manual page - dpkg-split(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2011 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-split 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
dpkg\-split \- Debian package archive split/join tool
.
.SH SYNOPSIS
.B dpkg\-split
.RI [ option "...] " command
.
.SH DESCRIPTION
.B dpkg\-split
splits Debian binary package files into smaller parts and reassembles
them again, to support the storage of large package files on small
media such as floppy disks.

It can be operated manually using the
.BR \-\-split ", " \-\-join " and " \-\-info
options.

It also has an automatic mode, invoked using the
.B \-\-auto
option, where it maintains a queue of parts seen but not yet
reassembled and reassembles a package file when it has seen all of its
parts. The
.BR \-\-listq " and " \-\-discard
options allow the management of the queue.

All splitting, joining and queueing operations produce informative
messages on standard output; these may safely be ignored.
.
.SH COMMANDS
.TP
.BR \-s ", " \-\-split " \fIcomplete-archive\fP [\fIprefix\fP]"
Splits a single Debian binary package into several parts.

The parts are named
.IB prefix . N of M .deb
where
.I N
is the part number, starting at 1, and
.I M
is the total number of parts (both in decimal).

If no
.I prefix
is supplied then the
.I complete-archive
filename is taken, including directory, with any trailing
.B .deb
removed.
.TP
.BR \-j ", " \-\-join " \fIpart\fP..."
Joins the parts of a package file together, reassembling the original
file as it was before it was split.

The part files given as arguments must be all the parts of exactly the
same original binary file. Each part must occur exactly once in the
argument list, though the parts to not need to be listed in order.

The parts must of course all have been generated with the same part
size specified at split time, which means that they must usually have
been generated by the same invocation of
.BR "dpkg\-split \-\-split" .

The parts' filenames are not significant for the reassembly process.

By default the output file is called
.IB package _ version _ arch .deb\fR.

.TP
.BR \-I ", " \-\-info " \fIpart\fP..."
Prints information, in a human-readable format, about the part file(s)
specified. Arguments which are not binary package parts produce a
message saying so instead (but still on standard output).
.TP
.BR \-a ", " "\-\-auto \-o" " \fIcomplete-output part\fP"
Automatically queue parts and reassemble a package if possible.

The
.I part
specified is examined, and compared with other parts of the same
package (if any) in the queue of packages file parts.

If all parts of the package file of which
.I part
is a part are available then the package is reassembled and written to
.I complete-output
(which should not usually already exist, though this is not an
error).

If not then the
.I part
is copied into the queue and
.I complete-output
is not created.

If
.I part
is not a split binary package part then
.B dpkg\-split
will exit with status \fB1\fP; if some other trouble occurs then it will
exit with status \fB2\fP.

The
.BR \-\-output " or " \-o
option must be supplied when using
.BR \-\-auto .
(If this were not mandatory the calling program would not know what
output file to expect.)
.TP
.BR \-l ", " \-\-listq
Lists the contents of the queue of packages to be reassembled.

For each package file of which parts are in the queue the output gives
the name of the package, the parts in the queue, and the total number
of bytes stored in the queue.
.TP
.BR \-d ", " \-\-discard " [\fIpackage\fP...]"
This discards parts from the queue of those waiting for the remaining
parts of their packages.

If no
.I package
is specified then the queue is cleared completely; if any are
specified then only parts of the relevant package(s) are deleted.
.TP
.BR \-? ", " \-\-help
Show the usage message and exit.
.TP
.BR \-\-version
Show the version and exit.
.
.SH OPTIONS
.TP
.BI \-\-depotdir " directory"
Specifies an alternative directory for the queue of parts awaiting
automatic reassembly. The default is
.BR %ADMINDIR% .
.TP
.BR \-S ", " \-\-partsize " \fIkibibytes\fP"
Specifies the maximum part size when splitting, in kibibytes (1024
bytes). The default is 450 KiB.
.TP
.BR \-o ", " \-\-output " \fIcomplete-output\fP"
Specifies the output file name for a reassembly.

This overrides the default for a manual reassembly
.RB ( \-\-join )
and is mandatory for an automatic queue-or-reassemble
.RB ( \-\-auto ).
.TP
.BR \-Q ", " \-\-npquiet
When doing automatic queue-or-reassembly
.B dpkg\-split
usually prints a message if it is given a
.I part
that is not a binary package part. This option suppresses this
message, to allow programs such as
.B dpkg
to cope with both split and unsplit packages without producing
spurious messages.
.TP
.BR \-\-msdos
Forces the output filenames generated by
.B \-\-split
to be msdos-compatible.

This mangles the prefix - either the default derived from the input
filename or the one supplied as an argument: alphanumerics are
lowercased, plus signs are replaced by
.BR x 's
and all other characters are discarded.

The result is then truncated as much as is necessary, and filenames of
the form
.IB "prefixN" of M .deb
are generated.
.
.SH EXIT STATUS
.TP
.B 0
The requested split, merge, or other command succeeded.
.B \-\-info
commands count as successful even if the files are not binary package
parts.
.TP
.B 1
Only occurs with
.B \-\-auto
and indicates that the
.I part
file was not a binary package part.
.TP
.B 2
Fatal or unrecoverable error due to invalid command-line usage,
a file that looked like a package part file but was corrupted, or
interactions with the system, such as accesses to the database,
memory allocations, etc.
.
.SH ENVIRONMENT
.TP
.B SOURCE_DATE_EPOCH
If set, it will be used as the timestamp (as seconds since the epoch) in
the \fBdeb\-split\fP(5)'s \fBar\fP(5) container.
.
.SH FILES
.TP
.I %ADMINDIR%/parts
The default queue directory for part files awaiting automatic
reassembly.

The filenames used in this directory are in a format internal to
.B dpkg\-split
and are unlikely to be useful to other programs, and in any case the
filename format should not be relied upon.
.
.SH BUGS
Full details of the packages in the queue are impossible to get
without digging into the queue directory yourself.

There is no easy way to test whether a file that may be a binary
package part is one.
.
.SH SEE ALSO
.BR deb (5),
.BR deb\-control (5),
.BR dpkg\-deb (1),
.BR dpkg (1).
