/* dconf-update.c generated by valac 0.23.3, the Vala compiler
 * generated from dconf-update.vala, do not modify */

/*
 * Copyright © 2010 Codethink Limited
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Ryan Lortie <desrt@desrt.ca>
 */

#include <glib.h>
#include <glib-object.h>
#include "../gvdb/gvdb-builder.h"
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);



GvdbItem* get_parent (GHashTable* table, const gchar* name);
GSList* list_directory (const gchar* dirname, mode_t mode, GError** error);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
GHashTable* read_locks_directory (const gchar* dirname, GError** error);
GHashTable* read_directory (const gchar* dirname, GError** error);
void maybe_update_from_directory (const gchar* dirname, GError** error);
void update_all (const gchar* dirname, GError** error);
void dconf_compile (gchar** args, int args_length1, GError** error);
void dconf_update (gchar** args, int args_length1, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


GvdbItem* get_parent (GHashTable* table, const gchar* name) {
	GvdbItem* result = NULL;
	GvdbItem* parent = NULL;
	gint end = 0;
	gint _tmp9_ = 0;
	gchar* parent_name = NULL;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	GHashTable* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gconstpointer _tmp15_ = NULL;
	GvdbItem* _tmp16_ = NULL;
	GvdbItem* _tmp24_ = NULL;
	g_return_val_if_fail (table != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	end = 0;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_ = NULL;
				gint _tmp3_ = 0;
				gchar _tmp4_ = '\0';
				const gchar* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gchar _tmp7_ = '\0';
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = name;
				_tmp3_ = i;
				_tmp4_ = string_get (_tmp2_, (glong) _tmp3_);
				if (!(_tmp4_ != '\0')) {
					break;
				}
				_tmp5_ = name;
				_tmp6_ = i;
				_tmp7_ = string_get (_tmp5_, (glong) (_tmp6_ - 1));
				if (_tmp7_ == '/') {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					end = _tmp8_;
				}
			}
		}
	}
	_tmp9_ = end;
	_vala_assert (_tmp9_ != 0, "end != 0");
	_tmp10_ = name;
	_tmp11_ = end;
	_tmp12_ = string_substring (_tmp10_, (glong) 0, (glong) _tmp11_);
	parent_name = _tmp12_;
	_tmp13_ = table;
	_tmp14_ = parent_name;
	_tmp15_ = g_hash_table_lookup (_tmp13_, _tmp14_);
	parent = (GvdbItem*) _tmp15_;
	_tmp16_ = parent;
	if (_tmp16_ == NULL) {
		GHashTable* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		GvdbItem* _tmp19_ = NULL;
		GvdbItem* _tmp20_ = NULL;
		GHashTable* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		GvdbItem* _tmp23_ = NULL;
		_tmp17_ = table;
		_tmp18_ = parent_name;
		_tmp19_ = gvdb_hash_table_insert (_tmp17_, _tmp18_);
		parent = _tmp19_;
		_tmp20_ = parent;
		_tmp21_ = table;
		_tmp22_ = parent_name;
		_tmp23_ = get_parent (_tmp21_, _tmp22_);
		gvdb_item_set_parent (_tmp20_, _tmp23_);
	}
	_tmp24_ = parent;
	result = _tmp24_;
	_g_free0 (parent_name);
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


GSList* list_directory (const gchar* dirname, mode_t mode, GError** error) {
	GSList* result = NULL;
	GSList* list = NULL;
	GDir* dir = NULL;
	const gchar* _tmp0_ = NULL;
	GDir* _tmp1_ = NULL;
	const gchar* name = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	list = NULL;
	_tmp0_ = dirname;
	_tmp1_ = g_dir_open (_tmp0_, (guint) 0, &_inner_error_);
	dir = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_slist_free__g_free0_0 (list);
		return NULL;
	}
	while (TRUE) {
		GDir* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gchar* filename = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		struct stat buf = {0};
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_ = NULL;
		struct stat _tmp12_ = {0};
		gint _tmp13_ = 0;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp2_ = dir;
		_tmp3_ = g_dir_read_name (_tmp2_);
		name = _tmp3_;
		_tmp4_ = name;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = name;
		_tmp6_ = g_str_has_prefix (_tmp5_, ".");
		if (_tmp6_) {
			continue;
		}
		_tmp7_ = dirname;
		_tmp8_ = name;
		_tmp9_ = g_build_filename (_tmp7_, _tmp8_, NULL);
		filename = _tmp9_;
		_tmp11_ = filename;
		_tmp13_ = stat (_tmp11_, &_tmp12_);
		buf = _tmp12_;
		if (_tmp13_ < 0) {
			_tmp10_ = TRUE;
		} else {
			struct stat _tmp14_ = {0};
			mode_t _tmp15_ = {0};
			mode_t _tmp16_ = {0};
			_tmp14_ = buf;
			_tmp15_ = _tmp14_.st_mode;
			_tmp16_ = mode;
			_tmp10_ = (_tmp15_ & S_IFMT) != _tmp16_;
		}
		if (_tmp10_) {
			_g_free0 (filename);
			continue;
		}
		_tmp17_ = filename;
		_tmp18_ = g_strdup (_tmp17_);
		list = g_slist_prepend (list, _tmp18_);
		_g_free0 (filename);
	}
	result = list;
	_g_dir_close0 (dir);
	return result;
}


GHashTable* read_locks_directory (const gchar* dirname, GError** error) {
	GHashTable* result = NULL;
	GSList* files = NULL;
	GHashTable* table = NULL;
	GHashTable* _tmp4_ = NULL;
	GSList* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	{
		GSList* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		GSList* _tmp2_ = NULL;
		GSList* _tmp3_ = NULL;
		_tmp1_ = dirname;
		_tmp2_ = list_directory (_tmp1_, S_IFREG, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
				goto __catch0_g_file_error_noent;
			}
			goto __finally0;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__g_slist_free__g_free0_0 (files);
		files = _tmp3_;
		__g_slist_free__g_free0_0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_file_error_noent:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		__g_slist_free__g_free0_0 (files);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_slist_free__g_free0_0 (files);
		return NULL;
	}
	_tmp4_ = gvdb_hash_table_new (NULL, NULL);
	table = _tmp4_;
	_tmp5_ = files;
	{
		GSList* filename_collection = NULL;
		GSList* filename_it = NULL;
		filename_collection = _tmp5_;
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
			gchar* _tmp6_ = NULL;
			gchar* filename = NULL;
			_tmp6_ = g_strdup ((const gchar*) filename_it->data);
			filename = _tmp6_;
			{
				gchar* contents = NULL;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gchar** _tmp10_ = NULL;
				gchar** _tmp11_ = NULL;
				_tmp7_ = filename;
				g_file_get_contents (_tmp7_, &_tmp8_, NULL, &_inner_error_);
				_g_free0 (contents);
				contents = _tmp8_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (contents);
					_g_free0 (filename);
					_g_hash_table_unref0 (table);
					__g_slist_free__g_free0_0 (files);
					return NULL;
				}
				_tmp9_ = contents;
				_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "\n", 0);
				{
					gchar** line_collection = NULL;
					gint line_collection_length1 = 0;
					gint _line_collection_size_ = 0;
					gint line_it = 0;
					line_collection = _tmp11_;
					line_collection_length1 = _vala_array_length (_tmp10_);
					for (line_it = 0; line_it < _vala_array_length (_tmp10_); line_it = line_it + 1) {
						gchar* _tmp12_ = NULL;
						gchar* line = NULL;
						_tmp12_ = g_strdup (line_collection[line_it]);
						line = _tmp12_;
						{
							const gchar* _tmp13_ = NULL;
							gboolean _tmp14_ = FALSE;
							_tmp13_ = line;
							_tmp14_ = g_str_has_prefix (_tmp13_, "/");
							if (_tmp14_) {
								GHashTable* _tmp15_ = NULL;
								const gchar* _tmp16_ = NULL;
								_tmp15_ = table;
								_tmp16_ = line;
								gvdb_hash_table_insert_string (_tmp15_, _tmp16_, "");
							}
							_g_free0 (line);
						}
					}
					line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (contents);
				_g_free0 (filename);
			}
		}
	}
	result = table;
	__g_slist_free__g_free0_0 (files);
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


GHashTable* read_directory (const gchar* dirname, GError** error) {
	GHashTable* result = NULL;
	GHashTable* table = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GSList* files = NULL;
	const gchar* _tmp2_ = NULL;
	GSList* _tmp3_ = NULL;
	GCompareFunc _tmp4_ = NULL;
	GSList* _tmp5_ = NULL;
	GHashTable* locks = NULL;
	const gchar* _tmp82_ = NULL;
	gchar* _tmp83_ = NULL;
	gchar* _tmp84_ = NULL;
	GHashTable* _tmp85_ = NULL;
	GHashTable* _tmp86_ = NULL;
	GHashTable* _tmp87_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	_tmp0_ = gvdb_hash_table_new (NULL, NULL);
	table = _tmp0_;
	_tmp1_ = table;
	gvdb_hash_table_insert (_tmp1_, "/");
	_tmp2_ = dirname;
	_tmp3_ = list_directory (_tmp2_, S_IFREG, &_inner_error_);
	files = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_hash_table_unref0 (table);
		return NULL;
	}
	_tmp4_ = g_strcmp0;
	files = g_slist_sort (files, _tmp4_);
	files = g_slist_reverse (files);
	_tmp5_ = files;
	{
		GSList* filename_collection = NULL;
		GSList* filename_it = NULL;
		filename_collection = _tmp5_;
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
			gchar* _tmp6_ = NULL;
			gchar* filename = NULL;
			_tmp6_ = g_strdup ((const gchar*) filename_it->data);
			filename = _tmp6_;
			{
				GKeyFile* kf = NULL;
				GKeyFile* _tmp7_ = NULL;
				_tmp7_ = g_key_file_new ();
				kf = _tmp7_;
				{
					GKeyFile* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					_tmp8_ = kf;
					_tmp9_ = filename;
					g_key_file_load_from_file (_tmp8_, _tmp9_, G_KEY_FILE_NONE, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					GError* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					GError* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					GError* _tmp15_ = NULL;
					GError* _tmp16_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp10_ = e;
					_tmp11_ = filename;
					_tmp12_ = e;
					_tmp13_ = _tmp12_->message;
					_tmp14_ = g_strdup_printf ("warning: Failed to read keyfile '%s': %s", _tmp11_, _tmp13_);
					_g_free0 (_tmp10_->message);
					_tmp10_->message = _tmp14_;
					_tmp15_ = e;
					_tmp16_ = _g_error_copy0 (_tmp15_);
					_inner_error_ = _tmp16_;
					_g_error_free0 (e);
					goto __finally1;
				}
				__finally1:
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_key_file_free0 (kf);
					_g_free0 (filename);
					__g_slist_free__g_free0_0 (files);
					_g_hash_table_unref0 (table);
					return NULL;
				}
				{
					GKeyFile* _tmp17_ = NULL;
					gsize _tmp18_;
					gchar** _tmp19_ = NULL;
					_tmp17_ = kf;
					_tmp19_ = g_key_file_get_groups (_tmp17_, &_tmp18_);
					{
						gchar** group_collection = NULL;
						gint group_collection_length1 = 0;
						gint _group_collection_size_ = 0;
						gint group_it = 0;
						group_collection = _tmp19_;
						group_collection_length1 = _tmp18_;
						for (group_it = 0; group_it < _tmp18_; group_it = group_it + 1) {
							gchar* _tmp20_ = NULL;
							gchar* group = NULL;
							_tmp20_ = g_strdup (group_collection[group_it]);
							group = _tmp20_;
							{
								gboolean _tmp21_ = FALSE;
								gboolean _tmp22_ = FALSE;
								const gchar* _tmp23_ = NULL;
								gboolean _tmp24_ = FALSE;
								gchar** _tmp32_ = NULL;
								GKeyFile* _tmp33_ = NULL;
								const gchar* _tmp34_ = NULL;
								gsize _tmp35_;
								gchar** _tmp36_ = NULL;
								gint _tmp32__length1 = 0;
								gint __tmp32__size_ = 0;
								gchar** _tmp37_ = NULL;
								gint _tmp37__length1 = 0;
								_tmp23_ = group;
								_tmp24_ = g_str_has_prefix (_tmp23_, "/");
								if (_tmp24_) {
									_tmp22_ = TRUE;
								} else {
									const gchar* _tmp25_ = NULL;
									gboolean _tmp26_ = FALSE;
									_tmp25_ = group;
									_tmp26_ = g_str_has_suffix (_tmp25_, "/");
									_tmp22_ = _tmp26_;
								}
								if (_tmp22_) {
									_tmp21_ = TRUE;
								} else {
									const gchar* _tmp27_ = NULL;
									gboolean _tmp28_ = FALSE;
									_tmp27_ = group;
									_tmp28_ = string_contains (_tmp27_, "//");
									_tmp21_ = _tmp28_;
								}
								if (_tmp21_) {
									FILE* _tmp29_ = NULL;
									const gchar* _tmp30_ = NULL;
									const gchar* _tmp31_ = NULL;
									_tmp29_ = stderr;
									_tmp30_ = filename;
									_tmp31_ = group;
									fprintf (_tmp29_, "%s: ignoring invalid group name: %s\n", _tmp30_, _tmp31_);
									_g_free0 (group);
									continue;
								}
								_tmp33_ = kf;
								_tmp34_ = group;
								_tmp36_ = g_key_file_get_keys (_tmp33_, _tmp34_, &_tmp35_, &_inner_error_);
								_tmp32_ = _tmp36_;
								_tmp32__length1 = _tmp35_;
								__tmp32__size_ = _tmp32__length1;
								if (_inner_error_ != NULL) {
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										goto __catch2_g_key_file_error;
									}
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_free0 (kf);
									_g_free0 (filename);
									__g_slist_free__g_free0_0 (files);
									_g_hash_table_unref0 (table);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
								_tmp37_ = _tmp32_;
								_tmp37__length1 = _tmp32__length1;
								_tmp32_ = NULL;
								_tmp32__length1 = 0;
								{
									gchar** key_collection = NULL;
									gint key_collection_length1 = 0;
									gint _key_collection_size_ = 0;
									gint key_it = 0;
									key_collection = _tmp37_;
									key_collection_length1 = _tmp37__length1;
									for (key_it = 0; key_it < _tmp37__length1; key_it = key_it + 1) {
										gchar* _tmp38_ = NULL;
										gchar* key = NULL;
										_tmp38_ = g_strdup (key_collection[key_it]);
										key = _tmp38_;
										{
											const gchar* _tmp39_ = NULL;
											gboolean _tmp40_ = FALSE;
											gchar* path = NULL;
											const gchar* _tmp45_ = NULL;
											gchar* _tmp46_ = NULL;
											gchar* _tmp47_ = NULL;
											gchar* _tmp48_ = NULL;
											gchar* _tmp49_ = NULL;
											const gchar* _tmp50_ = NULL;
											gchar* _tmp51_ = NULL;
											gchar* _tmp52_ = NULL;
											GHashTable* _tmp53_ = NULL;
											const gchar* _tmp54_ = NULL;
											gconstpointer _tmp55_ = NULL;
											gchar* text = NULL;
											GKeyFile* _tmp56_ = NULL;
											const gchar* _tmp57_ = NULL;
											const gchar* _tmp58_ = NULL;
											gchar* _tmp59_ = NULL;
											_tmp39_ = key;
											_tmp40_ = string_contains (_tmp39_, "/");
											if (_tmp40_) {
												const gchar* _tmp41_ = NULL;
												const gchar* _tmp42_ = NULL;
												const gchar* _tmp43_ = NULL;
												GError* _tmp44_ = NULL;
												_tmp41_ = filename;
												_tmp42_ = group;
												_tmp43_ = key;
												_tmp44_ = g_error_new (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_INVALID_VALUE, "%s: [%s]: invalid key name: %s", _tmp41_, _tmp42_, _tmp43_);
												_inner_error_ = _tmp44_;
												_g_free0 (key);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												if (_inner_error_->domain == G_KEY_FILE_ERROR) {
													goto __catch2_g_key_file_error;
												}
												_g_free0 (key);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_key_file_free0 (kf);
												_g_free0 (filename);
												__g_slist_free__g_free0_0 (files);
												_g_hash_table_unref0 (table);
												g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return NULL;
											}
											_tmp45_ = group;
											_tmp46_ = g_strconcat ("/", _tmp45_, NULL);
											_tmp47_ = _tmp46_;
											_tmp48_ = g_strconcat (_tmp47_, "/", NULL);
											_tmp49_ = _tmp48_;
											_tmp50_ = key;
											_tmp51_ = g_strconcat (_tmp49_, _tmp50_, NULL);
											_tmp52_ = _tmp51_;
											_g_free0 (_tmp49_);
											_g_free0 (_tmp47_);
											path = _tmp52_;
											_tmp53_ = table;
											_tmp54_ = path;
											_tmp55_ = g_hash_table_lookup (_tmp53_, _tmp54_);
											if (((GvdbItem*) _tmp55_) != NULL) {
												_g_free0 (path);
												_g_free0 (key);
												continue;
											}
											_tmp56_ = kf;
											_tmp57_ = group;
											_tmp58_ = key;
											_tmp59_ = g_key_file_get_value (_tmp56_, _tmp57_, _tmp58_, &_inner_error_);
											text = _tmp59_;
											if (_inner_error_ != NULL) {
												_g_free0 (path);
												_g_free0 (key);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												if (_inner_error_->domain == G_KEY_FILE_ERROR) {
													goto __catch2_g_key_file_error;
												}
												_g_free0 (path);
												_g_free0 (key);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_key_file_free0 (kf);
												_g_free0 (filename);
												__g_slist_free__g_free0_0 (files);
												_g_hash_table_unref0 (table);
												g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return NULL;
											}
											{
												GVariant* value = NULL;
												const gchar* _tmp60_ = NULL;
												GVariant* _tmp61_ = NULL;
												GvdbItem* item = NULL;
												GHashTable* _tmp62_ = NULL;
												const gchar* _tmp63_ = NULL;
												GvdbItem* _tmp64_ = NULL;
												GvdbItem* _tmp65_ = NULL;
												GHashTable* _tmp66_ = NULL;
												const gchar* _tmp67_ = NULL;
												GvdbItem* _tmp68_ = NULL;
												GvdbItem* _tmp69_ = NULL;
												GVariant* _tmp70_ = NULL;
												_tmp60_ = text;
												_tmp61_ = g_variant_parse (NULL, _tmp60_, NULL, NULL, &_inner_error_);
												value = _tmp61_;
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == G_VARIANT_PARSE_ERROR) {
														goto __catch3_g_variant_parse_error;
													}
													_g_free0 (text);
													_g_free0 (path);
													_g_free0 (key);
													key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
													_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
													_g_free0 (group);
													group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
													_g_key_file_free0 (kf);
													_g_free0 (filename);
													__g_slist_free__g_free0_0 (files);
													_g_hash_table_unref0 (table);
													g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return NULL;
												}
												_tmp62_ = table;
												_tmp63_ = path;
												_tmp64_ = gvdb_hash_table_insert (_tmp62_, _tmp63_);
												item = _tmp64_;
												_tmp65_ = item;
												_tmp66_ = table;
												_tmp67_ = path;
												_tmp68_ = get_parent (_tmp66_, _tmp67_);
												gvdb_item_set_parent (_tmp65_, _tmp68_);
												_tmp69_ = item;
												_tmp70_ = value;
												gvdb_item_set_value (_tmp69_, _tmp70_);
												_g_variant_unref0 (value);
											}
											goto __finally3;
											__catch3_g_variant_parse_error:
											{
												GError* e = NULL;
												GError* _tmp71_ = NULL;
												const gchar* _tmp72_ = NULL;
												const gchar* _tmp73_ = NULL;
												const gchar* _tmp74_ = NULL;
												const gchar* _tmp75_ = NULL;
												GError* _tmp76_ = NULL;
												const gchar* _tmp77_ = NULL;
												gchar* _tmp78_ = NULL;
												GError* _tmp79_ = NULL;
												GError* _tmp80_ = NULL;
												e = _inner_error_;
												_inner_error_ = NULL;
												_tmp71_ = e;
												_tmp72_ = filename;
												_tmp73_ = group;
												_tmp74_ = key;
												_tmp75_ = text;
												_tmp76_ = e;
												_tmp77_ = _tmp76_->message;
												_tmp78_ = g_strdup_printf ("%s: [%s]: %s: invalid value: %s (%s)", _tmp72_, _tmp73_, _tmp74_, _tmp75_, _tmp77_);
												_g_free0 (_tmp71_->message);
												_tmp71_->message = _tmp78_;
												_tmp79_ = e;
												_tmp80_ = _g_error_copy0 (_tmp79_);
												_inner_error_ = _tmp80_;
												_g_error_free0 (e);
												goto __finally3;
											}
											__finally3:
											if (_inner_error_ != NULL) {
												_g_free0 (text);
												_g_free0 (path);
												_g_free0 (key);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												if (_inner_error_->domain == G_KEY_FILE_ERROR) {
													goto __catch2_g_key_file_error;
												}
												goto __finally2;
											}
											_g_free0 (text);
											_g_free0 (path);
											_g_free0 (key);
										}
									}
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
								}
								_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (group);
							}
						}
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
					}
				}
				goto __finally2;
				__catch2_g_key_file_error:
				{
					GError* e = NULL;
					const gchar* _tmp81_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp81_ = e->message;
					g_warning ("dconf-update.vala:150: unexpected keyfile error: %s.  Please file a bu" \
"g.", _tmp81_);
					g_assert_not_reached ();
					_g_error_free0 (e);
				}
				__finally2:
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_key_file_free0 (kf);
					_g_free0 (filename);
					__g_slist_free__g_free0_0 (files);
					_g_hash_table_unref0 (table);
					return NULL;
				}
				_g_key_file_free0 (kf);
				_g_free0 (filename);
			}
		}
	}
	_tmp82_ = dirname;
	_tmp83_ = g_strconcat (_tmp82_, "/locks", NULL);
	_tmp84_ = _tmp83_;
	_tmp85_ = read_locks_directory (_tmp84_, &_inner_error_);
	_tmp86_ = _tmp85_;
	_g_free0 (_tmp84_);
	locks = _tmp86_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_slist_free__g_free0_0 (files);
		_g_hash_table_unref0 (table);
		return NULL;
	}
	_tmp87_ = locks;
	if (_tmp87_ != NULL) {
		GvdbItem* item = NULL;
		GHashTable* _tmp88_ = NULL;
		GvdbItem* _tmp89_ = NULL;
		GvdbItem* _tmp90_ = NULL;
		GHashTable* _tmp91_ = NULL;
		_tmp88_ = table;
		_tmp89_ = gvdb_hash_table_insert (_tmp88_, ".locks");
		item = _tmp89_;
		_tmp90_ = item;
		_tmp91_ = locks;
		gvdb_item_set_hash_table (_tmp90_, _tmp91_);
	}
	result = table;
	_g_hash_table_unref0 (locks);
	__g_slist_free__g_free0_0 (files);
	return result;
}


void maybe_update_from_directory (const gchar* dirname, GError** error) {
	struct stat dir_buf = {0};
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	struct stat _tmp2_ = {0};
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dirname != NULL);
	_tmp1_ = dirname;
	_tmp3_ = stat (_tmp1_, &_tmp2_);
	dir_buf = _tmp2_;
	if (_tmp3_ == 0) {
		struct stat _tmp4_ = {0};
		mode_t _tmp5_ = {0};
		gboolean _tmp6_ = FALSE;
		_tmp4_ = dir_buf;
		_tmp5_ = _tmp4_.st_mode;
		_tmp6_ = S_ISDIR (_tmp5_);
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		struct stat lockdir_buf = {0};
		struct stat file_buf = {0};
		gchar* filename = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		struct stat _tmp16_ = {0};
		gint _tmp17_ = 0;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp25_ = FALSE;
		const gchar* _tmp26_ = NULL;
		struct stat _tmp27_ = {0};
		gint _tmp28_ = 0;
		GHashTable* table = NULL;
		const gchar* _tmp33_ = NULL;
		GHashTable* _tmp34_ = NULL;
		gint fd = 0;
		const gchar* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		gboolean _tmp37_ = FALSE;
		gint _tmp38_ = 0;
		_tmp7_ = dirname;
		_tmp8_ = dirname;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = string_substring (_tmp7_, (glong) 0, (glong) (_tmp10_ - 2));
		filename = _tmp11_;
		_tmp13_ = dirname;
		_tmp14_ = g_strconcat (_tmp13_, "/locks", NULL);
		_tmp15_ = _tmp14_;
		_tmp17_ = stat (_tmp15_, &_tmp16_);
		lockdir_buf = _tmp16_;
		_tmp18_ = _tmp17_ == 0;
		_g_free0 (_tmp15_);
		if (_tmp18_) {
			struct stat _tmp19_ = {0};
			time_t _tmp20_ = 0;
			struct stat _tmp21_ = {0};
			time_t _tmp22_ = 0;
			_tmp19_ = lockdir_buf;
			_tmp20_ = _tmp19_.st_mtime;
			_tmp21_ = dir_buf;
			_tmp22_ = _tmp21_.st_mtime;
			_tmp12_ = _tmp20_ > _tmp22_;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			struct stat _tmp23_ = {0};
			time_t _tmp24_ = 0;
			_tmp23_ = lockdir_buf;
			_tmp24_ = _tmp23_.st_mtime;
			dir_buf.st_mtime = _tmp24_;
		}
		_tmp26_ = filename;
		_tmp28_ = stat (_tmp26_, &_tmp27_);
		file_buf = _tmp27_;
		if (_tmp28_ == 0) {
			struct stat _tmp29_ = {0};
			time_t _tmp30_ = 0;
			struct stat _tmp31_ = {0};
			time_t _tmp32_ = 0;
			_tmp29_ = file_buf;
			_tmp30_ = _tmp29_.st_mtime;
			_tmp31_ = dir_buf;
			_tmp32_ = _tmp31_.st_mtime;
			_tmp25_ = _tmp30_ > _tmp32_;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			_g_free0 (filename);
			return;
		}
		_tmp33_ = dirname;
		_tmp34_ = read_directory (_tmp33_, &_inner_error_);
		table = _tmp34_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (filename);
			return;
		}
		_tmp35_ = filename;
		_tmp36_ = open (_tmp35_, O_WRONLY, (mode_t) 0);
		fd = _tmp36_;
		_tmp38_ = fd;
		if (_tmp38_ < 0) {
			gint _tmp39_ = 0;
			_tmp39_ = errno;
			_tmp37_ = _tmp39_ != ENOENT;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			gint saved_error = 0;
			gint _tmp40_ = 0;
			const gchar* _tmp41_ = NULL;
			gint _tmp42_ = 0;
			const gchar* _tmp43_ = NULL;
			_tmp40_ = errno;
			saved_error = _tmp40_;
			_tmp41_ = filename;
			_tmp42_ = saved_error;
			_tmp43_ = g_strerror (_tmp42_);
			g_printerr ("warning: Failed to open '%s' for replacement: %s\n", _tmp41_, _tmp43_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		{
			GHashTable* _tmp44_ = NULL;
			const gchar* _tmp45_ = NULL;
			gint _tmp46_ = 0;
			_tmp44_ = table;
			_tmp45_ = filename;
			gvdb_table_write_contents (_tmp44_, _tmp45_, FALSE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
			_tmp46_ = fd;
			if (_tmp46_ >= 0) {
				gint _tmp47_ = 0;
				_tmp47_ = fd;
				write (_tmp47_, "\0\0\0\0\0\0\0\0", (gsize) 8);
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			GError* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp48_ = e;
			_tmp49_ = _tmp48_->message;
			g_printerr ("warning: %s\n", _tmp49_);
			_g_error_free0 (e);
			{
				gint _tmp50_ = 0;
				_tmp50_ = fd;
				if (_tmp50_ >= 0) {
					gint _tmp51_ = 0;
					_tmp51_ = fd;
					close (_tmp51_);
				}
			}
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		__finally4:
		{
			gint _tmp52_ = 0;
			_tmp52_ = fd;
			if (_tmp52_ >= 0) {
				gint _tmp53_ = 0;
				_tmp53_ = fd;
				close (_tmp53_);
			}
		}
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		{
			GDBusConnection* system_bus = NULL;
			GDBusConnection* _tmp54_ = NULL;
			GDBusConnection* _tmp55_ = NULL;
			const gchar* _tmp56_ = NULL;
			gchar* _tmp57_ = NULL;
			gchar* _tmp58_ = NULL;
			gchar* _tmp59_ = NULL;
			gchar* _tmp60_ = NULL;
			GVariant* _tmp61_ = NULL;
			GVariant* _tmp62_ = NULL;
			GDBusConnection* _tmp63_ = NULL;
			_tmp54_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &_inner_error_);
			system_bus = _tmp54_;
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
			}
			_tmp55_ = system_bus;
			_tmp56_ = filename;
			_tmp57_ = g_path_get_basename (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strconcat ("/ca/desrt/dconf/Writer/", _tmp58_, NULL);
			_tmp60_ = _tmp59_;
			_tmp61_ = g_variant_new ("(s)", "/", NULL);
			g_variant_ref_sink (_tmp61_);
			_tmp62_ = _tmp61_;
			g_dbus_connection_emit_signal (_tmp55_, NULL, _tmp60_, "ca.desrt.dconf.Writer", "WritabilityNotify", _tmp62_, &_inner_error_);
			_g_variant_unref0 (_tmp62_);
			_g_free0 (_tmp60_);
			_g_free0 (_tmp58_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (system_bus);
				goto __catch5_g_error;
			}
			_tmp63_ = system_bus;
			g_dbus_connection_flush_sync (_tmp63_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (system_bus);
				goto __catch5_g_error;
			}
			_g_object_unref0 (system_bus);
		}
		goto __finally5;
		__catch5_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
		}
		__finally5:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		_g_hash_table_unref0 (table);
		_g_free0 (filename);
	}
}


void update_all (const gchar* dirname, GError** error) {
	GSList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GSList* _tmp2_ = NULL;
	GSList* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dirname != NULL);
	_tmp1_ = dirname;
	_tmp2_ = list_directory (_tmp1_, S_IFDIR, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	{
		GSList* name_collection = NULL;
		GSList* name_it = NULL;
		name_collection = _tmp3_;
		for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
			gchar* _tmp4_ = NULL;
			gchar* name = NULL;
			_tmp4_ = g_strdup ((const gchar*) name_it->data);
			name = _tmp4_;
			{
				const gchar* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				_tmp5_ = name;
				_tmp6_ = g_str_has_suffix (_tmp5_, ".d");
				if (_tmp6_) {
					{
						const gchar* _tmp7_ = NULL;
						_tmp7_ = name;
						maybe_update_from_directory (_tmp7_, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch6_g_error;
						}
					}
					goto __finally6;
					__catch6_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp8_ = NULL;
						GError* _tmp9_ = NULL;
						const gchar* _tmp10_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp8_ = name;
						_tmp9_ = e;
						_tmp10_ = _tmp9_->message;
						g_printerr ("unable compile %s: %s\n", _tmp8_, _tmp10_);
						_g_error_free0 (e);
					}
					__finally6:
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (name);
						__g_slist_free__g_free0_0 (name_collection);
						__g_slist_free__g_free0_0 (_tmp0_);
						return;
					}
				}
				_g_free0 (name);
			}
		}
		__g_slist_free__g_free0_0 (name_collection);
	}
	__g_slist_free__g_free0_0 (_tmp0_);
}


void dconf_compile (gchar** args, int args_length1, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	const gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = _tmp2_[2];
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = _tmp4_[3];
		_tmp1_ = _tmp5_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[4];
		_tmp0_ = _tmp7_ != NULL;
	}
	if (_tmp0_) {
		GError* _tmp8_ = NULL;
		_tmp8_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "must give output file and .d dir");
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	{
		GHashTable* table = NULL;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		const gchar* _tmp10_ = NULL;
		GHashTable* _tmp11_ = NULL;
		gboolean should_byteswap = FALSE;
		GHashTable* _tmp12_ = NULL;
		gchar** _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp9_ = args;
		_tmp9__length1 = args_length1;
		_tmp10_ = _tmp9_[3];
		_tmp11_ = read_directory (_tmp10_, &_inner_error_);
		table = _tmp11_;
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		should_byteswap = G_BYTE_ORDER == G_BIG_ENDIAN;
		_tmp12_ = table;
		_tmp13_ = args;
		_tmp13__length1 = args_length1;
		_tmp14_ = _tmp13_[2];
		_tmp15_ = should_byteswap;
		gvdb_table_write_contents (_tmp12_, _tmp14_, _tmp15_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_hash_table_unref0 (table);
			goto __catch7_g_error;
		}
		_g_hash_table_unref0 (table);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e->message;
		g_printerr ("%s\n", _tmp16_);
		exit (1);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void dconf_update (gchar** args, int args_length1, GError** error) {
	GError * _inner_error_ = NULL;
	update_all ("/etc/dconf/db", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



