/*******************************************************************************
 * Copyright (C) 2004-2007 Intel Corp. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *   - Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 * 
 *   - Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 * 
 *   - Neither the name of Intel Corp. nor the names of its
 *     contributors may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL Intel Corp. OR THE CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <string>
#include <map>

#include "Types.h"
#include "StringTableUtils.h"

#define MAX_STRING_TABLE_OFFSET 0x10000L

map<unsigned long,std::string> StringTableUtils::_stringTableMap;
map<unsigned long,std::string> StringTableUtils::_statusStringMap;

DWORD StringTableUtils::GetLastError(void)
{
	return(errno);
}

/* -------------------------------------------------------
* DisplayError
*   Show the last "errno" seen.
* Note: even tests that PASS (they were supposed to cause
*   an error) may want to display the error number.
* --------------------------------------------------------
*/
void StringTableUtils::DisplayError(DWORD LastError)
{
	printf(" *** Last error number: %d (0x%x)\n", (int)LastError, (unsigned int)LastError) ;
}

/* -----------------------------------------------------
* StringTableInit
*   Run this routine to read a resource file and
*   to create a table of strings in memory.
* Returns:  0 - success, <non-zero> - fail
* -----------------------------------------------------
*/

BOOL StringTableUtils::StringTableInit(char *dat_filename,BOOL isStatus)
{
	char buff[1024];
	map<unsigned long,std::string> smap;
	FILE *fptr;
	unsigned long d_indx;
	char *first_qptr, *last_qptr;

	/*
	* read the <name>.dat file to get index and string pairs
	*/
	fptr = fopen(dat_filename, "r");
	if (fptr == NULL) {
		printf("ERROR:StringTableInit unable to open for reading file: %s\n", dat_filename);
		return FALSE;
	}
	while (fgets(buff, 1023, fptr) != NULL) {
		// get string index
		if (sscanf(buff, "%lu ", &d_indx) != 1) {
			continue;
		}
		if (0 == d_indx) {
			sscanf(buff, "%lx ", &d_indx);
		}
		if (d_indx > MAX_STRING_TABLE_OFFSET) {
			printf("ERROR: StringTableInit found string index out of range in this line: %s\n", buff);
			continue;
		}
		// get actual string
		first_qptr = strchr(buff, '"');
		if (first_qptr == NULL) {
			printf("ERROR: StringTableInit unable to find first quote in this line: %s\n", buff);
			continue;
		}
		last_qptr = strrchr(buff, '"');
		if (last_qptr == NULL) {
			printf("ERROR: StringTableInit unable to find last quote in this line: %s\n", buff);
			continue;
		}
		if (last_qptr == first_qptr) {
			printf("ERROR: StringTableInit improper string format in this line: %s\n", buff);
			continue;
		}
		first_qptr++;

		std::string temp(first_qptr,(size_t)((last_qptr) - (first_qptr)));
		smap[d_indx] = temp;

	}
	if(isStatus)
		_statusStringMap = smap;
	else
		_stringTableMap = smap;

	return TRUE;
}



/* --------------------------------------------------------------
* LoadString
*   The Windows version of this function seems to get strings from
*   a resource file, given an reference number.  This Linux version
*   depends on a StringMap being created from that resource file.
* ------------------------------------------------------------------
*/
int StringTableUtils::LoadString(LPVOID Instance, UINT Id, TCHAR *Buffer, UINT BufferMax)
{
	/* For our small number of strings, the performance hit of looping
	*  through the strings is negligible.  Do it this way for simplicity.
	*/
	if (Buffer != NULL)
	{
		memset(Buffer, 0, BufferMax);
		strncpy((char *)Buffer, (char *)_stringTableMap[Id].c_str(), BufferMax - 1);
		return 0;
	}
	return 1;

}

/* --------------------------------------------------------------
* LoadString
*   The Windows version of this function seems to get strings from
*   a resource file, given an reference number.  This Linux version
*   depends on a StringMap being created from that resource file.
* ------------------------------------------------------------------
*/

int StringTableUtils::LoadStatusString(LPVOID Instance, UINT Id, TCHAR *Buffer, UINT BufferMax)
{
	/* For our small number of strings, the performance hit of looping
	*  through the strings is negligible.  Do it this way for simplicity.
	*/
	if (Buffer != NULL)
	{
		memset(Buffer, 0, BufferMax);
		strncpy((char *)Buffer, (char *)_statusStringMap[Id].c_str(), BufferMax - 1);
		return 0;
	}
	return 1;

}
/* ----------------------------------
* GetModuleHandle
* ----------------------------------
*/
LPVOID StringTableUtils::GetModuleHandle(LPSTR Dummy)
{
	return NULL;
}
