// -*- mode: c++ -*-
//
// This file is part of libyacurs.
// Copyright (C) 2013  Rafael Ostertag
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see
// <http://www.gnu.org/licenses/>.
//
//
// $Id: filesavedialog.h 5743 2013-12-08 12:33:35Z rafisol $

#ifndef FILESAVEDIALOG_H
#define FILESAVEDIALOG_H 1

#include <string>

#include <unistd.h>

#include "filedialog.h"
#include "dynlabel.h"
#include "input.h"
#include "listbox.h"
#include "messagebox2.h"

namespace YACURS {
    class FileSaveDialog : public FileDialog {
        private:
            MessageBox2* __confirmdia;
	    MessageBox2* __errmsgbox;

            // Not supported
            FileSaveDialog& operator=(const FileSaveDialog&);

        protected:
	    virtual void window_close_handler(Event& _e);

            virtual void button_press_handler(Event& _e);

        public:
            FileSaveDialog(std::string _path=std::string(),
			   bool _do_chdir=false,
                           DIALOG_TYPE _dt=OKCANCEL);

            virtual ~FileSaveDialog();
    };
}

#endif // FILESAVEDIALOG_H
