/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: xracer-powerup.h,v 1.3 2000/01/18 23:24:21 rich Exp $
 */

#ifndef __xracer_powerup_h__
#define __xracer_powerup_h__

#include "xracer-player.h"

/* Possible powerups. */
#define XR_NO_POWERUP          0

#define XR_POWERUP_FASTER      1
#define XR_POWERUP_ENERGY      2
#define XR_POWERUP_SHIELD      3
#define XR_POWERUP_AUTOPILOT   4
#define XR_POWERUP_CANNON      5
#define XR_POWERUP_MISSILE     6

#define XR_MAX_POWERUP         6

/* Functions. */
extern void xrPowerupInit (void);
extern void xrPowerupStartGame (void);
extern void xrPowerupEndGame (void);
extern void xrPowerupDisplay (const struct xrPlayer *player);

#endif /* __xracer_powerup_h__ */
