#!/bin/sh -ex

xlcbin_path=/usr/lib/dpu.xclbin
firmware_path=/usr/share/xlnx-firmware
current_cfg_p=

if [ -e $xlcbin_path ]; then
    current_cfg_p=$(realpath $xlcbin_path)
    # If it does not point to our configs, leave it - it has been
    # manually configured.
    if [ -n "${current_cfg_p##$firmware_path/*}" ]
    then exit 0
    fi
fi

model=$(cat /proc/device-tree/model)
case "$model" in
    *102*)
        wanted_path=$firmware_path/zcu102/dpu.xclbin
        ;;
    *104*)
        wanted_path=$firmware_path/zcu104/dpu.xclbin
        ;;
    *106*)
        wanted_path=$firmware_path/zcu106/dpu.xclbin
        ;;
    *)
        printf "No ZCU board detected\n"
        exit 0
esac

if [ "$wanted_path" != "$current_cfg_p" ]
then ln -sf $wanted_path $xlcbin_path
fi
