;;; cltl2.el --- Browse CLTL2 online edition

;; Copyright 2001 Utz-Uwe Haus, <haus@uuhaus.de>
;; inspired by Eric Naggum's <erik@naggum.no> hyperspec.el

;; This file is not part of GNU Emacs, but distributed under the same
;; conditions as GNU Emacs, and is useless without GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; The online edition (and LaTeX source, DVI and PS versions) of
;; Guy Steele's "Common Lisp the Language, 2nd Edition" are available
;; courtesy of Digital Press, at
;; http://www.cs.cmu.edu/afs/cs.cmu.edu/project/ai-repository/ai/html/cltl/cltl2.html
;; Since a lot of the mirrors listed there seem to be no longer functioning
;; I keep a copy at http://www.uuhaus.de/cltl2/ which is the default entry
;; point for this code.

;;; Code:

(require 'cl)
(require 'browse-url)			;you need the Emacs 20 version
(require 'thingatpt)

;; maybe this should be a (defcustom cltl2-root-url ...) ?
(defvar cltl2-root-url 
  "http://www.uuhaus.de/cltl2/"
  "*The base URL of the default online edition of CLtL2. If you keep a 
copy of it on your local system, change the URL to something like
\"file:/usr/share/doc/cltl2/\".")

(defvar cltl2-history nil
  "History of symbols looked up in CLtL2.")

(defvar cltl2-symbols (make-vector 127 0)
  "This variable holds the access information for the symbols indexed
in the CLtL2 lookup index.")

(defun cltl2-lookup (symbol-name)
  "View the documentation on SYMBOL-NAME in Guy Steele's \"Common Lisp the Language, 2nd Edition.\".
If SYMBOL-NAME has more than one definition, all of them are displayed with
your favorite browser in sequence.  The browser should have a \"back\"
function to view the separate definitions.

The book is copyright (c) Guy Steele 1989; the electronic version is
made available courtesy of the publisher Universal Press free of
charge.  Visit http://www.uuhaus.de/cltl2/README.from.cltl_ht for more
information and details on obtaining a paper-bound version.

If you keep a local copy of the book, customize the variable 
`cltl2-root-url' to point to the correct location."
  (interactive
   (list (let ((symbol-at-point (thing-at-point 'symbol)))
	   (if (and symbol-at-point
		    (intern-soft (downcase symbol-at-point)
				 cltl2-symbols))
	       symbol-at-point
	     (completing-read
	      "Look up symbol in CLtL2: "
	      cltl2-symbols #'boundp
	      t symbol-at-point
	      'cltl2-history)))))
  (maplist (lambda (entry)
	     (browse-url (concat cltl2-root-url "clm/" (car entry)))
	     (if (cdr entry)
		 (sleep-for 1.5)))
	   (let ((symbol (intern-soft (downcase symbol-name)
				      cltl2-symbols)))
	     (if (and symbol (boundp symbol))
		 (progn
		   (message (format "Showing %d matching entries."
				    (length (symbol-value symbol))))
		   (symbol-value symbol))
	       (error "The symbol `%s' is not indexed in CLtL2"
		      symbol-name)))))

(mapcar (lambda (entry)
	  (let ((symbol (intern (car entry) cltl2-symbols)))
	    (if (boundp symbol)
	      (push (cadr entry) (symbol-value symbol))
	      (set symbol (cdr entry)))))
	'(
	  ;; The index references were generated using the following sed(1)
	  ;; script; some manual additions were made.
	  ;; cat index.html |\
	  ;;  sed -e '/<pre>/,/<\/pre/!d'\
	  ;;      -e '/^<a href="node/!d'\
	  ;;      -e '/^<a href="node/s/^<a href=\("node[0-9]\+.html"\)>\(&[lg]t;\)\?\(<code>\(.*\)<\/code>\)\?.*/("\2\4" \1)/'\
	  ;;      -e 's/&lt;/</'\
	  ;;      -e 's/&gt;/>/'
	  ("*" "node125.html")
	  ("*" "node181.html")
	  ("**" "node181.html")
	  ("***" "node181.html")
	  ("+" "node125.html")
	  ("+" "node181.html")
	  ("++" "node181.html")
	  ("+++" "node181.html")
	  ("-" "node125.html")
	  ("-" "node181.html")
	  ("/" "node125.html")
	  ("/" "node181.html")
	  ("//" "node181.html")
	  ("///" "node181.html")
	  ("1+" "node125.html")
	  ("1-" "node125.html")
	  ("<" "node124.html")
	  ("<=" "node124.html")
	  ("=" "node124.html")
	  (">" "node124.html")
	  (">=" "node124.html")
	  ("abort" "node344.html")
	  ("abs" "node128.html")
	  ("acons" "node153.html")
	  ("acos" "node128.html")
	  ("acosh" "node128.html")
	  ("add-method" "node311.html")
	  ("adjoin" "node152.html")
	  ("adjust-array" "node163.html")
	  ("adjustable-array-p" "node160.html")
	  ("alpha-char-p" "node137.html")
	  ("alphanumericp" "node137.html")
	  ("alter" "node355.html")
	  ("always" "node245.html")
	  ("and" "node75.html")
	  ("append" "node149.html")
	  ("append" "node246.html")
	  ("appending" "node246.html")
	  ("apply" "node81.html")
	  ("applyhook" "node180.html")
	  ("*applyhook*" "node180.html")
	  ("apropos" "node230.html")
	  ("apropos-list" "node230.html")
	  ("aref" "node159.html")
	  ("arithmetic-error" "node346.html")
	  ("arithmetic-error-operands" "node346.html")
	  ("arithmetic-error-operation" "node346.html")
	  ("array-dimension" "node160.html")
	  ("array-dimension-limit" "node158.html")
	  ("array-dimensions" "node160.html")
	  ("array-element-type" "node160.html")
	  ("array-has-fill-pointer-p" "node162.html")
	  ("array-in-bounds-p" "node160.html")
	  ("array-rank" "node160.html")
	  ("array-rank-limit" "node158.html")
	  ("array-row-major-index" "node160.html")
	  ("array-total-size" "node160.html")
	  ("array-total-size-limit" "node158.html")
	  ("arrayp" "node73.html")
	  ("as" "node244.html")
	  ("ash" "node131.html")
	  ("asin" "node128.html")
	  ("asinh" "node128.html")
	  ("assert" "node221.html")
	  ("assert" "node336.html")
	  ("assoc" "node153.html")
	  ("assoc-if" "node153.html")
	  ("assoc-if-not" "node153.html")
	  ("atan" "node128.html")
	  ("atanh" "node128.html")
	  ("atom" "node73.html")
	  ("augment-environment" "node102.html")
	  ("bit" "node161.html")
	  ("bit-and" "node161.html")
	  ("bit-andc1" "node161.html")
	  ("bit-andc2" "node161.html")
	  ("bit-eqv" "node161.html")
	  ("bit-ior" "node161.html")
	  ("bit-nand" "node161.html")
	  ("bit-nor" "node161.html")
	  ("bit-not" "node161.html")
	  ("bit-orc1" "node161.html")
	  ("bit-orc2" "node161.html")
	  ("bit-vector-p" "node73.html")
	  ("bit-xor" "node161.html")
	  ("block" "node85.html")
	  ("boole" "node131.html")
	  ("both-case-p" "node137.html")
	  ("boundp" "node78.html")
	  ("break" "node220.html")
	  ("break" "node345.html")
	  ("*break-on-signals*" "node335.html")
	  ("*break-on-warnings*" "node220.html")
	  ("broadcast-stream-streams" "node185.html")
	  ("butlast" "node149.html")
	  ("byte" "node132.html")
	  ("byte-position" "node132.html")
	  ("byte-size" "node132.html")
	  ("caaaar" "node148.html")
	  ("caaadr" "node148.html")
	  ("caaar" "node148.html")
	  ("caadar" "node148.html")
	  ("caaddr" "node148.html")
	  ("caadr" "node148.html")
	  ("caar" "node148.html")
	  ("cadaar" "node148.html")
	  ("cadadr" "node148.html")
	  ("cadar" "node148.html")
	  ("caddar" "node148.html")
	  ("cadddr" "node148.html")
	  ("caddr" "node148.html")
	  ("cadr" "node148.html")
	  ("call-arguments-limit" "node81.html")
	  ("call-method" "node311.html")
	  ("call-next-method" "node311.html")
	  ("car" "node148.html")
	  ("case" "node84.html")
	  ("catch" "node96.html")
	  ("catenate" "node353.html")
	  ("ccase" "node222.html")
	  ("ccase" "node337.html")
	  ("cdaaar" "node148.html")
	  ("cdaadr" "node148.html")
	  ("cdaar" "node148.html")
	  ("cdadar" "node148.html")
	  ("cdaddr" "node148.html")
	  ("cdadr" "node148.html")
	  ("cdar" "node148.html")
	  ("cddaar" "node148.html")
	  ("cddadr" "node148.html")
	  ("cddar" "node148.html")
	  ("cdddar" "node148.html")
	  ("cddddr" "node148.html")
	  ("cdddr" "node148.html")
	  ("cddr" "node148.html")
	  ("cdr" "node148.html")
	  ("ceiling" "node130.html")
	  ("cell-error" "node346.html")
	  ("cell-error-name" "node346.html")
	  ("cerror" "node220.html")
	  ("cerror" "node335.html")
	  ("change-class" "node311.html")
	  ("char" "node165.html")
	  ("char-bit" "node140.html")
	  ("char-bits" "node138.html")
	  ("char-bits-limit" "node136.html")
	  ("char-code" "node138.html")
	  ("char-code-limit" "node136.html")
	  ("char-control-bit" "node140.html")
	  ("char-downcase" "node139.html")
	  ("char-equal" "node137.html")
	  ("char-font" "node138.html")
	  ("char-font-limit" "node136.html")
	  ("char-greaterp" "node137.html")
	  ("char-hyper-bit" "node140.html")
	  ("char-int" "node139.html")
	  ("char-lessp" "node137.html")
	  ("char-meta-bit" "node140.html")
	  ("char-name" "node139.html")
	  ("char-not-equal" "node137.html")
	  ("char-not-greaterp" "node137.html")
	  ("char-not-lessp" "node137.html")
	  ("char-super-bit" "node140.html")
	  ("char-upcase" "node139.html")
	  ("char/=" "node137.html")
	  ("char" "node137.html")
	  ("char" "node137.html")
	  ("char=" "node137.html")
	  ("char" "node137.html")
	  ("char" "node137.html")
	  ("character" "node139.html")
	  ("characterp" "node73.html")
	  ("check-type" "node221.html")
	  ("check-type" "node336.html")
	  ("choose" "node353.html")
	  ("choose-if" "node353.html")
	  ("chunk" "node353.html")
	  ("cis" "node128.html")
	  ("class-name" "node311.html")
	  ("class-of" "node311.html")
	  ("clear-input" "node195.html")
	  ("close" "node185.html")
	  ("clrhash" "node155.html")
	  ("code-char" "node138.html")
	  ("coerce" "node52.html")
	  ("collect" "node246.html")
	  ("collect" "node354.html")
	  ("collect-alist" "node354.html")
	  ("collect-and" "node354.html")
	  ("collect-append" "node354.html")
	  ("collect-file" "node354.html")
	  ("collect-first" "node354.html")
	  ("collect-fn" "node354.html")
	  ("collect-hash" "node354.html")
	  ("collect-last" "node354.html")
	  ("collect-length" "node354.html")
	  ("collect-max" "node354.html")
	  ("collect-min" "node354.html")
	  ("collect-nconc" "node354.html")
	  ("collect-nth" "node354.html")
	  ("collect-or" "node354.html")
	  ("collect-plist" "node354.html")
	  ("collect-sum" "node354.html")
	  ("collecting" "node246.html")
	  ("collecting-fn" "node352.html")
	  ("commonp" "node73.html")
	  ("compile" "node224.html")
	  ("compile-file" "node224.html")
	  ("compile-file-pathname" "node211.html")
	  ("*compile-file-pathname*" "node224.html")
	  ("*compile-file-truename*" "node224.html")
	  ("*compile-print*" "node224.html")
	  ("*compile-verbose*" "node224.html")
	  ("compiled-function-p" "node73.html")
	  ("compiler-let" "node83.html")
	  ("compiler-let" "node83.html")
	  ("compiler-macro-function" "node101.html")
	  ("compiler-macroexpand" "node101.html")
	  ("compiler-macroexpand-1" "node101.html")
	  ("complement" "node141.html")
	  ("complex" "node130.html")
	  ("complexp" "node73.html")
	  ("compute-applicable-methods" "node311.html")
	  ("compute-restarts" "node342.html")
	  ("concatenate" "node143.html")
	  ("concatenated-stream-streams" "node185.html")
	  ("cond" "node84.html")
	  ("condition" "node346.html")
	  ("conjugate" "node125.html")
	  ("cons" "node148.html")
	  ("consp" "node73.html")
	  ("constantp" "node180.html")
	  ("continue" "node344.html")
	  ("control-error" "node346.html")
	  ("copy-alist" "node149.html")
	  ("copy-list" "node149.html")
	  ("copy-pprint-dispatch" "node259.html")
	  ("copy-readtable" "node192.html")
	  ("copy-seq" "node142.html")
	  ("copy-symbol" "node110.html")
	  ("copy-tree" "node149.html")
	  ("cos" "node128.html")
	  ("cosh" "node128.html")
	  ("cotruncate" "node352.html")
	  ("count" "node145.html")
	  ("count" "node246.html")
	  ("count-if" "node145.html")
	  ("count-if-not" "node145.html")
	  ("counting" "node246.html")
	  ("ctypecase" "node222.html")
	  ("ctypecase" "node337.html")
	  ("*debug-io*" "node183.html")
	  ("*debugger-hook*" "node345.html")
	  ("decf" "node125.html")
	  ("declaim" "node104.html")
	  ("declaration-information" "node102.html")
	  ("declare" "node104.html")
	  ("decode-float" "node130.html")
	  ("decode-universal-time" "node232.html")
	  ("*default-pathname-defaults*" "node214.html")
	  ("defclass" "node311.html")
	  ("defgeneric" "node311.html")
	  ("define-compiler-macro" "node101.html")
	  ("define-condition" "node339.html")
	  ("define-declaration" "node102.html")
	  ("define-method-combination" "node311.html")
	  ("define-modify-macro" "node80.html")
	  ("define-setf-method" "node80.html")
	  ("defmacro" "node98.html")
	  ("defmethod" "node311.html")
	  ("defpackage" "node118.html")
	  ("defstruct" "node170.html")
	  ("deftype" "node51.html")
	  ("defun" "node66.html")
	  ("defvar" "node67.html")
	  ("delete" "node144.html")
	  ("delete-duplicates" "node144.html")
	  ("delete-file" "node216.html")
	  ("delete-if" "node144.html")
	  ("delete-if-not" "node144.html")
	  ("delete-package" "node118.html")
	  ("denominator" "node130.html")
	  ("deposit-field" "node132.html")
	  ("describe" "node230.html")
	  ("describe-object" "node230.html")
	  ("destructuring-bind" "node100.html")
	  ("digit-char" "node139.html")
	  ("digit-char-p" "node137.html")
	  ("directory" "node218.html")
	  ("directory-namestring" "node214.html")
	  ("disassemble" "node224.html")
	  ("division-by-zero" "node346.html")
	  ("do" "node88.html")
	  ("do" "node249.html")
	  ("do*" "node88.html")
	  ("do-all-symbols" "node118.html")
	  ("do-external-symbols" "node118.html")
	  ("do-symbols" "node118.html")
	  ("documentation" "node229.html")
	  ("documentation" "node311.html")
	  ("doing" "node249.html")
	  ("dolist" "node89.html")
	  ("dotimes" "node89.html")
	  ("double-float-epsilon" "node134.html")
	  ("double-float-negative-epsilon" "node134.html")
	  ("dpb" "node132.html")
	  ("dribble" "node230.html")
	  ("ecase" "node222.html")
	  ("ecase" "node337.html")
	  ("echo-stream-input-stream" "node185.html")
	  ("echo-stream-output-stream" "node185.html")
	  ("ed" "node230.html")
	  ("eighth" "node149.html")
	  ("elt" "node142.html")
	  ("encapsulated" "node361.html")
	  ("enclose" "node102.html")
	  ("encode-universal-time" "node232.html")
	  ("end-of-file" "node346.html")
	  ("endp" "node149.html")
	  ("enough-namestring" "node214.html")
	  ("ensure-generic-function" "node311.html")
	  ("eq" "node74.html")
	  ("eql" "node74.html")
	  ("equal" "node74.html")
	  ("equalp" "node74.html")
	  ("error" "node220.html")
	  ("error" "node335.html")
	  ("error" "node346.html")
	  ("*error-output*" "node183.html")
	  ("etypecase" "node222.html")
	  ("etypecase" "node337.html")
	  ("eval" "node180.html")
	  ("eval-when" "node68.html")
	  ("evalhook" "node180.html")
	  ("*evalhook*" "node180.html")
	  ("evenp" "node123.html")
	  ("every" "node143.html")
	  ("exp" "node127.html")
	  ("expand" "node353.html")
	  ("export" "node118.html")
	  ("expt" "node127.html")
	  ("f" "node311.html")
	  ("fboundp" "node78.html")
	  ("fdefinition" "node78.html")
	  ("*features*" "node233.html")
	  ("ffloor" "node130.html")
	  ("fifth" "node149.html")
	  ("file-author" "node216.html")
	  ("file-error" "node346.html")
	  ("file-error-pathname" "node346.html")
	  ("file-length" "node216.html")
	  ("file-namestring" "node214.html")
	  ("file-position" "node216.html")
	  ("file-string-length" "node216.html")
	  ("file-write-date" "node216.html")
	  ("fill" "node144.html")
	  ("fill-pointer" "node162.html")
	  ("finally" "node252.html")
	  ("find" "node145.html")
	  ("find-all-symbols" "node118.html")
	  ("find-class" "node311.html")
	  ("find-if" "node145.html")
	  ("find-if-not" "node145.html")
	  ("find-method" "node311.html")
	  ("find-package" "node118.html")
	  ("find-restart" "node342.html")
	  ("find-symbol" "node118.html")
	  ("finish-output" "node198.html")
	  ("first" "node149.html")
	  ("flet" "node83.html")
	  ("float" "node130.html")
	  ("float-digits" "node130.html")
	  ("float-precision" "node130.html")
	  ("float-radix" "node130.html")
	  ("float-sign" "node130.html")
	  ("floating-point-overflow" "node346.html")
	  ("floating-point-underflow" "node346.html")
	  ("floatp" "node73.html")
	  ("floor" "node130.html")
	  ("for" "node244.html")
	  ("format" "node200.html")
	  ("formatter" "node258.html")
	  ("fourth" "node149.html")
	  ("funcall" "node81.html")
	  ("function" "node78.html")
	  ("function-information" "node102.html")
	  ("function-keywords" "node311.html")
	  ("function-lambda-expression" "node224.html")
	  ("functionp" "node73.html")
	  ("gatherer" "node365.html")
	  ("gathering" "node365.html")
	  ("gcd" "node125.html")
	  ("generator" "node364.html")
	  ("generic-flet" "node311.html")
	  ("generic-function" "node311.html")
	  ("generic-labels" "node311.html")
	  ("gensym" "node110.html")
	  ("*gensym-counter*" "node110.html")
	  ("gentemp" "node110.html")
	  ("get" "node108.html")
	  ("get-decoded-time" "node232.html")
	  ("get-internal-real-time" "node232.html")
	  ("get-internal-run-time" "node232.html")
	  ("get-output-stream-string" "node184.html")
	  ("get-properties" "node108.html")
	  ("get-setf-method" "node80.html")
	  ("get-setf-method-multiple-value" "node80.html")
	  ("get-universal-time" "node232.html")
	  ("getf" "node108.html")
	  ("gethash" "node155.html")
	  ("go" "node91.html")
	  ("graphic-char-p" "node137.html")
	  ("handler-bind" "node338.html")
	  ("handler-case" "node338.html")
	  ("hash-table-count" "node155.html")
	  ("hash-table-p" "node155.html")
	  ("hash-table-rehash-size" "node155.html")
	  ("hash-table-rehash-threshold" "node155.html")
	  ("hash-table-size" "node155.html")
	  ("hash-table-test" "node155.html")
	  ("host-namestring" "node214.html")
	  ("identity" "node234.html")
	  ("if" "node84.html")
	  ("if" "node248.html")
	  ("ignore-errors" "node338.html")
	  ("imagpart" "node130.html")
	  ("import" "node118.html")
	  ("in-package" "node118.html")
	  ("in-package" "node118.html")
	  ("incf" "node125.html")
	  ("initialize-instance" "node311.html")
	  ("initially" "node252.html")
	  ("input-stream-p" "node185.html")
	  ("inspect" "node230.html")
	  ("int-char" "node139.html")
	  ("integer-decode-float" "node130.html")
	  ("integer-length" "node131.html")
	  ("integerp" "node73.html")
	  ("interactive-stream-p" "node185.html")
	  ("intern" "node118.html")
	  ("internal-time-units-per-second" "node232.html")
	  ("intersection" "node152.html")
	  ("invalid-method-error" "node311.html")
	  ("invoke-debugger" "node345.html")
	  ("invoke-restart" "node342.html")
	  ("isqrt" "node127.html")
	  ("iterate" "node351.html")
	  ("keywordp" "node110.html")
	  ("lambda" "node64.html")
	  ("lambda-list-keywords" "node64.html")
	  ("lambda-parameters-limit" "node64.html")
	  ("last" "node149.html")
	  ("latch" "node352.html")
	  ("lcm" "node125.html")
	  ("ldb" "node132.html")
	  ("ldb-test" "node132.html")
	  ("ldiff" "node149.html")
	  ("least-negative-double-float" "node134.html")
	  ("least-negative-long-float" "node134.html")
	  ("least-negative-normalized-double-float" "node134.html")
	  ("least-negative-normalized-long-float" "node134.html")
	  ("least-negative-normalized-short-float" "node134.html")
	  ("least-negative-normalized-single-float" "node134.html")
	  ("least-negative-short-float" "node134.html")
	  ("least-negative-single-float" "node134.html")
	  ("least-positive-double-float" "node134.html")
	  ("least-positive-long-float" "node134.html")
	  ("least-positive-normalized-double-float" "node134.html")
	  ("least-positive-normalized-long-float" "node134.html")
	  ("least-positive-normalized-short-float" "node134.html")
	  ("least-positive-normalized-single-float" "node134.html")
	  ("least-positive-short-float" "node134.html")
	  ("least-positive-single-float" "node134.html")
	  ("length" "node142.html")
	  ("let" "node83.html")
	  ("let*" "node83.html")
	  ("lisp-implementation-type" "node233.html")
	  ("lisp-implementation-version" "node233.html")
	  ("list" "node149.html")
	  ("list*" "node149.html")
	  ("list-all-packages" "node118.html")
	  ("list-length" "node149.html")
	  ("listen" "node195.html")
	  ("listp" "node73.html")
	  ("load" "node217.html")
	  ("load-logical-pathname-translations" "node211.html")
	  ("*load-pathname*" "node217.html")
	  ("*load-print*" "node217.html")
	  ("load-time-value" "node224.html")
	  ("*load-truename*" "node217.html")
	  ("*load-verbose*" "node217.html")
	  ("locally" "node104.html")
	  ("locally" "node104.html")
	  ("log" "node127.html")
	  ("logand" "node131.html")
	  ("logandc1" "node131.html")
	  ("logandc2" "node131.html")
	  ("logbitp" "node131.html")
	  ("logcount" "node131.html")
	  ("logeqv" "node131.html")
	  ("logical-pathname" "node208.html")
	  ("logical-pathname" "node211.html")
	  ("logical-pathname-translations" "node211.html")
	  ("logior" "node131.html")
	  ("lognand" "node131.html")
	  ("lognor" "node131.html")
	  ("lognot" "node131.html")
	  ("logorc1" "node131.html")
	  ("logorc2" "node131.html")
	  ("logtest" "node131.html")
	  ("logxor" "node131.html")
	  ("long-float-epsilon" "node134.html")
	  ("long-float-negative-epsilon" "node134.html")
	  ("long-site-name" "node233.html")
	  ("loop" "node87.html")
	  ("loop-finish" "node245.html")
	  ("lower-case-p" "node137.html")
	  ("machine-instance" "node233.html")
	  ("machine-type" "node233.html")
	  ("machine-version" "node233.html")
	  ("macro-function" "node98.html")
	  ("macroexpand" "node99.html")
	  ("macroexpand-1" "node99.html")
	  ("*macroexpand-hook*" "node99.html")
	  ("make-array" "node158.html")
	  ("make-broadcast-stream" "node184.html")
	  ("make-char" "node138.html")
	  ("make-concatenated-stream" "node184.html")
	  ("make-condition" "node340.html")
	  ("make-dispatch-macro-character" "node192.html")
	  ("make-echo-stream" "node184.html")
	  ("make-hash-table" "node155.html")
	  ("make-instance" "node311.html")
	  ("make-instances-obsolete" "node311.html")
	  ("make-list" "node149.html")
	  ("make-load-form" "node217.html")
	  ("make-load-form-saving-slots" "node217.html")
	  ("make-package" "node118.html")
	  ("make-pathname" "node214.html")
	  ("make-random-state" "node133.html")
	  ("make-sequence" "node142.html")
	  ("make-string" "node167.html")
	  ("make-string-input-stream" "node184.html")
	  ("make-string-output-stream" "node184.html")
	  ("make-symbol" "node110.html")
	  ("make-synonym-stream" "node184.html")
	  ("make-two-way-stream" "node184.html")
	  ("makunbound" "node79.html")
	  ("map" "node143.html")
	  ("map-fn" "node351.html")
	  ("map-into" "node143.html")
	  ("mapc" "node90.html")
	  ("mapcan" "node90.html")
	  ("mapcar" "node90.html")
	  ("mapcon" "node90.html")
	  ("maphash" "node155.html")
	  ("mapl" "node90.html")
	  ("maplist" "node90.html")
	  ("mapping" "node351.html")
	  ("mask" "node353.html")
	  ("mask-field" "node132.html")
	  ("max" "node124.html")
	  ("maximize" "node246.html")
	  ("maximizing" "node246.html")
	  ("member" "node152.html")
	  ("member-if" "node152.html")
	  ("member-if-not" "node152.html")
	  ("merge" "node146.html")
	  ("merge-pathnames" "node214.html")
	  ("method-combination-error" "node311.html")
	  ("method-qualifiers" "node311.html")
	  ("min" "node124.html")
	  ("mingle" "node353.html")
	  ("minimize" "node246.html")
	  ("minimizing" "node246.html")
	  ("minusp" "node123.html")
	  ("mismatch" "node145.html")
	  ("mod" "node130.html")
	  ("*modules*" "node119.html")
	  ("most-negative-double-float" "node134.html")
	  ("most-negative-fixnum" "node134.html")
	  ("most-negative-long-float" "node134.html")
	  ("most-negative-short-float" "node134.html")
	  ("most-negative-single-float" "node134.html")
	  ("most-positive-double-float" "node134.html")
	  ("most-positive-fixnum" "node134.html")
	  ("most-positive-long-float" "node134.html")
	  ("most-positive-short-float" "node134.html")
	  ("most-positive-single-float" "node134.html")
	  ("muffle-warning" "node344.html")
	  ("multiple-value-bind" "node94.html")
	  ("multiple-value-call" "node94.html")
	  ("multiple-value-list" "node94.html")
	  ("multiple-value-prog1" "node94.html")
	  ("multiple-value-setq" "node94.html")
	  ("multiple-values-limit" "node94.html")
	  ("name-char" "node139.html")
	  ("named" "node252.html")
	  ("namestring" "node214.html")
	  ("nbutlast" "node149.html")
	  ("nconc" "node149.html")
	  ("nconc" "node246.html")
	  ("nconcing" "node246.html")
	  ("never" "node245.html")
	  ("next-in" "node364.html")
	  ("next-method-p" "node311.html")
	  ("next-out" "node365.html")
	  ("nil" "node70.html")
	  ("nintersection" "node152.html")
	  ("ninth" "node149.html")
	  ("no-applicable-method" "node311.html")
	  ("no-next-method" "node311.html")
	  ("not" "node75.html")
	  ("notany" "node143.html")
	  ("notevery" "node143.html")
	  ("nreconc" "node149.html")
	  ("nreverse" "node142.html")
	  ("nset-difference" "node152.html")
	  ("nset-exclusive-or" "node152.html")
	  ("nstring-capitalize" "node167.html")
	  ("nstring-downcase" "node167.html")
	  ("nstring-upcase" "node167.html")
	  ("nsublis" "node151.html")
	  ("nsubst" "node151.html")
	  ("nsubst-if" "node151.html")
	  ("nsubst-if-not" "node151.html")
	  ("nsubstitute" "node144.html")
	  ("nsubstitute-if" "node144.html")
	  ("nsubstitute-if-not" "node144.html")
	  ("nth" "node149.html")
	  ("nth-value" "node94.html")
	  ("nthcdr" "node149.html")
	  ("null" "node73.html")
	  ("numberp" "node73.html")
	  ("numerator" "node130.html")
	  ("nunion" "node152.html")
	  ("oddp" "node123.html")
	  ("off-line-port" "node359.html")
	  ("open" "node215.html")
	  ("open-stream-p" "node185.html")
	  ("optimizable-series-function" "node359.html")
	  ("or" "node75.html")
	  ("output-stream-p" "node185.html")
	  ("*package*" "node118.html")
	  ("package-error" "node346.html")
	  ("package-error-package" "node346.html")
	  ("package-name" "node118.html")
	  ("package-nicknames" "node118.html")
	  ("package-shadowing-symbols" "node118.html")
	  ("package-use-list" "node118.html")
	  ("package-used-by-list" "node118.html")
	  ("packagep" "node73.html")
	  ("pairlis" "node153.html")
	  ("parse-integer" "node195.html")
	  ("parse-macro" "node102.html")
	  ("parse-namestring" "node214.html")
	  ("pathname" "node214.html")
	  ("pathname-device" "node214.html")
	  ("pathname-directory" "node214.html")
	  ("pathname-host" "node214.html")
	  ("pathname-match-p" "node207.html")
	  ("pathname-name" "node214.html")
	  ("pathname-type" "node214.html")
	  ("pathname-version" "node214.html")
	  ("pathnamep" "node214.html")
	  ("peek-char" "node195.html")
	  ("phase" "node128.html")
	  ("pi" "node128.html")
	  ("plusp" "node123.html")
	  ("pop" "node149.html")
	  ("position" "node145.html")
	  ("position-if" "node145.html")
	  ("position-if-not" "node145.html")
	  ("positions" "node353.html")
	  ("pprint-dispatch" "node259.html")
	  ("pprint-exit-if-list-exhausted" "node256.html")
	  ("pprint-fill" "node256.html")
	  ("pprint-indent" "node256.html")
	  ("pprint-linear" "node256.html")
	  ("pprint-logical-block" "node256.html")
	  ("pprint-newline" "node256.html")
	  ("pprint-pop" "node256.html")
	  ("pprint-tab" "node256.html")
	  ("pprint-tabular" "node256.html")
	  ("previous" "node352.html")
	  ("prin1" "node198.html")
	  ("*print-array*" "node193.html")
	  ("*print-base*" "node193.html")
	  ("*print-case*" "node193.html")
	  ("*print-circle*" "node193.html")
	  ("*print-escape*" "node193.html")
	  ("*print-gensym*" "node193.html")
	  ("*print-length*" "node193.html")
	  ("*print-level*" "node193.html")
	  ("*print-lines*" "node255.html")
	  ("*print-miser-width*" "node255.html")
	  ("print-object" "node311.html")
	  ("*print-pprint-dispatch*" "node255.html")
	  ("*print-pretty*" "node193.html")
	  ("*print-radix*" "node193.html")
	  ("*print-readably*" "node193.html")
	  ("*print-right-margin*" "node255.html")
	  ("print-unreadable-object" "node198.html")
	  ("probe-file" "node216.html")
	  ("proclaim" "node104.html")
	  ("producing" "node361.html")
	  ("prog" "node91.html")
	  ("prog*" "node91.html")
	  ("prog1" "node82.html")
	  ("prog2" "node82.html")
	  ("progn" "node82.html")
	  ("program-error" "node346.html")
	  ("progv" "node83.html")
	  ("propagate-alterability" "node361.html")
	  ("provide" "node119.html")
	  ("psetf" "node80.html")
	  ("psetq" "node79.html")
	  ("push" "node149.html")
	  ("pushnew" "node149.html")
	  ("*query-io*" "node183.html")
	  ("quote" "node78.html")
	  ("random" "node133.html")
	  ("*random-state*" "node133.html")
	  ("random-state-p" "node133.html")
	  ("rassoc" "node153.html")
	  ("rassoc-if" "node153.html")
	  ("rassoc-if-not" "node153.html")
	  ("rational" "node130.html")
	  ("rationalize" "node130.html")
	  ("rationalp" "node73.html")
	  ("read" "node195.html")
	  ("*read-base*" "node189.html")
	  ("read-byte" "node196.html")
	  ("read-char" "node195.html")
	  ("read-char-no-hang" "node195.html")
	  ("*read-default-float-format*" "node195.html")
	  ("read-delimited-list" "node195.html")
	  ("*read-eval*" "node189.html")
	  ("read-from-string" "node195.html")
	  ("read-line" "node195.html")
	  ("read-preserving-whitespace" "node195.html")
	  ("*read-suppress*" "node189.html")
	  ("*readtable*" "node192.html")
	  ("readtable-case" "node192.html")
	  ("readtablep" "node192.html")
	  ("realp" "node73.html")
	  ("realpart" "node130.html")
	  ("reduce" "node143.html")
	  ("reinitialize-instance" "node311.html")
	  ("rem" "node130.html")
	  ("remf" "node108.html")
	  ("remhash" "node155.html")
	  ("remove" "node144.html")
	  ("remove-duplicates" "node144.html")
	  ("remove-method" "node311.html")
	  ("remprop" "node108.html")
	  ("rename-file" "node216.html")
	  ("rename-package" "node118.html")
	  ("repeat" "node244.html")
	  ("replace" "node144.html")
	  ("require" "node119.html")
	  ("rest" "node149.html")
	  ("restart" "node346.html")
	  ("restart-bind" "node341.html")
	  ("restart-case" "node341.html")
	  ("restart-name" "node342.html")
	  ("result-of" "node365.html")
	  ("return" "node85.html")
	  ("return" "node249.html")
	  ("return-from" "node85.html")
	  ("revappend" "node149.html")
	  ("reverse" "node142.html")
	  ("room" "node230.html")
	  ("rotatef" "node80.html")
	  ("round" "node130.html")
	  ("row-major-aref" "node160.html")
	  ("rplaca" "node150.html")
	  ("rplacd" "node150.html")
	  ("sbit" "node161.html")
	  ("scale-float" "node130.html")
	  ("scan" "node350.html")
	  ("scan-alist" "node350.html")
	  ("scan-file" "node350.html")
	  ("scan-fn" "node350.html")
	  ("scan-fn-inclusive" "node350.html")
	  ("scan-hash" "node350.html")
	  ("scan-lists-of-lists" "node350.html")
	  ("scan-lists-of-lists-fringe" "node350.html")
	  ("scan-multiple" "node350.html")
	  ("scan-plist" "node350.html")
	  ("scan-range" "node350.html")
	  ("scan-sublists" "node350.html")
	  ("scan-symbols" "node350.html")
	  ("schar" "node165.html")
	  ("search" "node145.html")
	  ("second" "node149.html")
	  ("series" "node349.html")
	  ("series" "node349.html")
	  ("series-element-type" "node360.html")
	  ("serious-condition" "node346.html")
	  ("set" "node79.html")
	  ("set-char-bit" "node140.html")
	  ("set-difference" "node152.html")
	  ("set-dispatch-macro-character" "node192.html")
	  ("set-exclusive-or" "node152.html")
	  ("set-macro-character" "node192.html")
	  ("set-pprint-dispatch" "node259.html")
	  ("set-syntax-from-char" "node192.html")
	  ("setf" "node80.html")
	  ("setq" "node79.html")
	  ("seventh" "node149.html")
	  ("shadow" "node118.html")
	  ("shadowing-import" "node118.html")
	  ("shared-initialize" "node311.html")
	  ("shiftf" "node80.html")
	  ("short-float-epsilon" "node134.html")
	  ("short-float-negative-epsilon" "node134.html")
	  ("short-site-name" "node233.html")
	  ("signal" "node335.html")
	  ("signum" "node128.html")
	  ("simple-bit-vector-p" "node73.html")
	  ("simple-condition" "node346.html")
	  ("simple-condition-format-arguments" "node346.html")
	  ("simple-condition-format-string" "node346.html")
	  ("simple-error" "node346.html")
	  ("simple-string-p" "node73.html")
	  ("simple-type-error" "node346.html")
	  ("simple-vector-p" "node73.html")
	  ("simple-warning" "node346.html")
	  ("sin" "node128.html")
	  ("single-float-epsilon" "node134.html")
	  ("single-float-negative-epsilon" "node134.html")
	  ("sinh" "node128.html")
	  ("sixth" "node149.html")
	  ("sleep" "node232.html")
	  ("slot-boundp" "node311.html")
	  ("slot-exists-p" "node311.html")
	  ("slot-makunbound" "node311.html")
	  ("slot-missing" "node311.html")
	  ("slot-unbound" "node311.html")
	  ("slot-value" "node311.html")
	  ("software-type" "node233.html")
	  ("software-version" "node233.html")
	  ("some" "node143.html")
	  ("sort" "node146.html")
	  ("special-form-p" "node78.html")
	  ("split" "node353.html")
	  ("split-if" "node353.html")
	  ("sqrt" "node127.html")
	  ("stable-sort" "node146.html")
	  ("standard-char-p" "node137.html")
	  ("*standard-input*" "node183.html")
	  ("*standard-output*" "node183.html")
	  ("step" "node230.html")
	  ("storage-condition" "node346.html")
	  ("store-value" "node344.html")
	  ("stream-element-type" "node185.html")
	  ("stream-error" "node346.html")
	  ("stream-error-stream" "node346.html")
	  ("stream-external-format" "node185.html")
	  ("streamp" "node185.html")
	  ("string" "node167.html")
	  ("string-capitalize" "node167.html")
	  ("string-char-p" "node137.html")
	  ("string-downcase" "node167.html")
	  ("string-equal" "node166.html")
	  ("string-greaterp" "node166.html")
	  ("string-left-trim" "node167.html")
	  ("string-lessp" "node166.html")
	  ("string-not-equal" "node166.html")
	  ("string-not-greaterp" "node166.html")
	  ("string-not-lessp" "node166.html")
	  ("string-right-trim" "node167.html")
	  ("string-trim" "node167.html")
	  ("string-upcase" "node167.html")
	  ("string/=" "node166.html")
	  ("string" "node166.html")
	  ("string" "node166.html")
	  ("string=" "node166.html")
	  ("string" "node166.html")
	  ("string" "node166.html")
	  ("stringp" "node73.html")
	  ("sublis" "node151.html")
	  ("subseq" "node142.html")
	  ("subseries" "node353.html")
	  ("subsetp" "node152.html")
	  ("subst" "node151.html")
	  ("subst-if" "node151.html")
	  ("subst-if-not" "node151.html")
	  ("substitute" "node144.html")
	  ("substitute-if" "node144.html")
	  ("substitute-if-not" "node144.html")
	  ("subtypep" "node72.html")
	  ("sum" "node246.html")
	  ("summing" "node246.html")
	  ("*suppress-series-warnings*" "node357.html")
	  ("svref" "node159.html")
	  ("sxhash" "node156.html")
	  ("symbol-function" "node78.html")
	  ("symbol-macrolet" "node83.html")
	  ("symbol-name" "node109.html")
	  ("symbol-package" "node110.html")
	  ("symbol-plist" "node108.html")
	  ("symbol-value" "node78.html")
	  ("symbolp" "node73.html")
	  ("synonym-stream-symbol" "node185.html")
	  ("t" "node70.html")
	  ("tagbody" "node91.html")
	  ("tailp" "node152.html")
	  ("tan" "node128.html")
	  ("tanh" "node128.html")
	  ("tenth" "node149.html")
	  ("*terminal-io*" "node183.html")
	  ("terminate-producing" "node361.html")
	  ("terpri" "node198.html")
	  ("the" "node106.html")
	  ("thereis" "node245.html")
	  ("third" "node149.html")
	  ("throw" "node96.html")
	  ("time" "node230.html")
	  ("to-alter" "node355.html")
	  ("trace" "node230.html")
	  ("*trace-output*" "node183.html")
	  ("translate-logical-pathname" "node211.html")
	  ("translate-pathname" "node207.html")
	  ("tree-equal" "node148.html")
	  ("truename" "node214.html")
	  ("truncate" "node130.html")
	  ("two-way-stream-input-stream" "node185.html")
	  ("two-way-stream-output-stream" "node185.html")
	  ("type-error" "node346.html")
	  ("type-error-datum" "node346.html")
	  ("type-error-expected-type" "node346.html")
	  ("type-of" "node53.html")
	  ("typecase" "node84.html")
	  ("typep" "node72.html")
	  ("unbound-variable" "node346.html")
	  ("undefined-function" "node346.html")
	  ("unexport" "node118.html")
	  ("unintern" "node118.html")
	  ("union" "node152.html")
	  ("unless" "node84.html")
	  ("unless" "node248.html")
	  ("unread-char" "node195.html")
	  ("until" "node245.html")
	  ("until" "node352.html")
	  ("until-if" "node352.html")
	  ("untrace" "node230.html")
	  ("unuse-package" "node118.html")
	  ("unwind-protect" "node96.html")
	  ("update-instance-for-different-class" "node311.html")
	  ("update-instance-for-redefined-class" "node311.html")
	  ("upgraded-array-element-type" "node54.html")
	  ("upgraded-complex-part-type" "node54.html")
	  ("upper-case-p" "node137.html")
	  ("use-package" "node118.html")
	  ("use-value" "node344.html")
	  ("user-homedir-pathname" "node214.html")
	  ("values" "node94.html")
	  ("values-list" "node94.html")
	  ("variable-information" "node102.html")
	  ("vector" "node158.html")
	  ("vector-pop" "node162.html")
	  ("vector-push" "node162.html")
	  ("vector-push-extend" "node162.html")
	  ("vectorp" "node73.html")
	  ("warn" "node220.html")
	  ("warn" "node343.html")
	  ("warning" "node346.html")
	  ("when" "node84.html")
	  ("when" "node248.html")
	  ("while" "node245.html")
	  ("wild-pathname-p" "node207.html")
	  ("with" "node247.html")
	  ("with-accessors" "node311.html")
	  ("with-added-methods" "node311.html")
	  ("with-compilation-unit" "node224.html")
	  ("with-condition-restarts" "node341.html")
	  ("with-hash-table-iterator" "node155.html")
	  ("with-input-from-string" "node184.html")
	  ("with-open-file" "node215.html")
	  ("with-open-stream" "node184.html")
	  ("with-output-to-string" "node184.html")
	  ("with-package-iterator" "node118.html")
	  ("with-simple-restart" "node341.html")
	  ("with-slots" "node311.html")
	  ("with-standard-io-syntax" "node193.html")
	  ("write" "node198.html")
	  ("write-byte" "node199.html")
	  ("write-char" "node198.html")
	  ("write-string" "node198.html")
	  ("write-to-string" "node198.html")
	  ("y-or-n-p" "node201.html")
	  ("yes-or-no-p" "node201.html")
	  ("zerop" "node123.html")
	  ))


(provide 'cltl2)

;;; cltl2.el ends here
