/*
 *========================================================================
 * $Id: get_system_time.c 163 2005-09-14 22:54:20Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "xmlsysd.h"

/*
 * This routine gets the system time and returns it as a formatted
 * time string AND as tv_sec/tv_usec.  The former conversion could
 * of course be done at the other end, but it is nice to be able to
 * READ xml output.
 */

void get_system_time(xmlNodePtr system)
{

 int i,numfields;
 struct timeval tv;
 struct tm *realtime;
 time_t realseconds;
 char timebuf[64];
 xmlNodePtr timestring;

 if(verbose==102){
   fprintf(stderr,"Starting get_system_time().\n");
 }

 /* 
  * Get the time and return it as a node/value of system.  For fun
  * we timestamp it so one CAN get tv_sec or tv_usec if desired.
  */
 time(&realseconds);
 realtime = localtime(&realseconds);
 sprintf(timebuf, "%d:%02d:%02d %s",
	realtime->tm_hour%12 ? realtime->tm_hour%12 : 12,
	realtime->tm_min, 
        realtime->tm_sec,
        realtime->tm_hour > 11 ? "pm" : "am");

 timestring = xmlNewChild(system,NULL,(xmlChar*) "time", (xmlChar*) timebuf);
 gettimeofday(&tv,0);
 sprintf(outbuf,"%d",tv.tv_sec);
 xmlSetProp(timestring,(xmlChar*) "tv_sec",(xmlChar*) outbuf);
 sprintf(outbuf,"%d",tv.tv_usec);
 xmlSetProp(timestring,(xmlChar*) "tv_usec",(xmlChar*) outbuf);

}

