#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

PROTOCOL_VERSION = 3		#bump this number whenever making incompatible changes

# simple test messages
PING = "ping"
PINGECHO = "pingecho"
HELP = "help"
VERSION = "version"

# responses
NOK = "NOK"
OK = "OK"

STOP = "stop"

# synchronization request / end
SYNC = "sync"
SYNC_END = "sync_end"

# key exchange:
SET_REMOTE_KEY = "set_remote_key"
SET_SALT = "set_salt"
SET_HOST_INFO = "set_host_info"

# tunnel setup
SET_TUNNEL_PORTS = "set_tunnel_ports"

# send any of the messages encrypted:
SEND_ENCRYPTED = "encrypted_command"

# informational message
SEND_MESSAGE = "send_message"

# users (login, logout, responses)
ADD_USER = "add_user"
LOGOUT = "logout"
SET_XMODMAP = "set_xmodmap"
REMOVE_USER = "remove_user"
AUTHENTICATION_FAILED = "authentication_failed"
AUTHENTICATION_SUCCESS = "authentication_success"
REQUEST_USER_ICON = "request_user_icon"
SET_USER_ICON = "set_user_icon"
ADD_MOUNT_POINT = "add_mount_point"

# sessions:
ADD_SESSION = "add_session"
SET_SESSION_STATUS = "set_session_status"
REQUEST_SESSION_ICON = "request_session_icon"
SET_SESSION_ICON = "set_session_icon"
REMOVE_SESSION = "remove_session"
SEND_SESSION = "send_session"
START_SESSION = "start_session"
OPEN_FILE = "open_file"
SHADOW_SESSION = "shadow_session"
REQUEST_SESSION = "request_session"
KILL_SESSION = "kill_session"
CLOSE_SESSION = "close_session"
DISCONNECT_SESSION = "disconnect_session"
SET_SESSION_COMMAND = "set_session_command"

REQUEST_SESSION_SOUND = "request_session_sound"
RECEIVE_SESSION_SOUND = "receive_session_sound"

# commands (menus)
ADD_SERVER_COMMAND = "add_server_command"
REQUEST_COMMAND_ICON = "request_command_icon"
SET_COMMAND_ICON = "set_icon"

# file transfers:
SEND_FILE_DATA = "send_file_data"
ACK_FILE_DATA = "ack_file_data"
CANCEL_FILE_TRANSFER = "cancel_file_transfer"

XDG_OPEN="xdg_open"