/**
 * FGraphCol.java
 *
 * Created on Jul 3, 2006
 */
package graphe;

import java.awt.Color;

/**
 * Cette classe implemente <CODE>GraphCol</CODE>.
 *
 * @author Nicolae
 */
public class FGraphCol implements GraphCol {

	int min, max;
	private int cls[];
	
	/**
	 * Constructeur standard.
	 * 
	 * L'objet doit etre initialise avec <code>setColors()</code>.
	 */
	public FGraphCol() {
		min = 1;
		max = 0;
	}
	
	/**
	 * Constructeur avec une seule couleur. Le fond du graphe est transparent.
	 * 
	 * @param c la couleur.
	 */
	public FGraphCol(Color c) {
		min = 0;
		max = 1;
		cls = new int[2];
		cls[0] = 0xFFFFFF; // trnasparent white
		cls[1] = getInter(c, c, 1, 0);
	}
	
	public void setColors(Color[] cols, int[] vals) {
		 if(cols == null || vals == null || cols.length != vals.length || cols.length < 2)
			 return;
		 
		 min = vals[0];
		 max = vals[vals.length - 1];
		 if(min >= max)
			 return;
		 
		 cls = new int[max - min + 1];
		 
		 for (int i = 1; i < vals.length; i++) {
			 int st = vals[i - 1];
			 int en = vals[i];
			 
			 for (int j = st; j < en; j++)
				 cls[j] = getInter(cols[i - 1], cols[i], en - st, j - st);
		 }
		 Color last = cols[cols.length - 1];
		 cls[max - min] = getInter(last, last, 1, 0);
	}

	private int getInter(Color cs, Color ce, int len, int k) {
		int r1 = cs.getRed();
		int g1 = cs.getGreen();
		int b1 = cs.getBlue();
		int a1 = cs.getAlpha();
		
		int r2 = ce.getRed();
		int g2 = ce.getGreen();
		int b2 = ce.getBlue();
		int a2 = ce.getAlpha();

		int r = ((r1 * (len - k) + r2 * k) / len) & 0xFF;
		int g = ((g1 * (len - k) + g2 * k) / len) & 0xFF;
		int b = ((b1 * (len - k) + b2 * k) / len) & 0xFF;
		int a = ((a1 * (len - k) + a2 * k) / len) & 0xFF;
		
		return (a << 24) | (r << 16) | (g << 8) | b;
	}

	public int getCol(int val) {
		if(min > max)
			return 0;
		
		if(val <= min)
			return cls[0];
		if(val >= max)
			return cls[max - min];
		
		return cls[val - min];
	}

}
