// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See layer_chassis_generator.py for modifications

/***************************************************************************
 *
 * Copyright (c) 2015-2025 The Khronos Group Inc.
 * Copyright (c) 2015-2025 Valve Corporation
 * Copyright (c) 2015-2025 LunarG, Inc.
 * Copyright (c) 2015-2024 Google Inc.
 * Copyright (c) 2023-2024 RasterGrid Kft.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ****************************************************************************/

// NOLINTBEGIN

#include "chassis/chassis.h"
#include <array>
#include <cstring>

#include "chassis/dispatch_object.h"
#include "chassis/validation_object.h"
#include "generated/dispatch_vector.h"
#include "utils/vk_layer_extension_utils.h"
#include "layer_options.h"

#include "profiling/profiling.h"

// Extension exposed by the validation layer
static constexpr std::array<VkExtensionProperties, 4> kInstanceExtensions = {
    VkExtensionProperties{VK_EXT_DEBUG_REPORT_EXTENSION_NAME, VK_EXT_DEBUG_REPORT_SPEC_VERSION},
    VkExtensionProperties{VK_EXT_DEBUG_UTILS_EXTENSION_NAME, VK_EXT_DEBUG_UTILS_SPEC_VERSION},
    VkExtensionProperties{VK_EXT_VALIDATION_FEATURES_EXTENSION_NAME, VK_EXT_VALIDATION_FEATURES_SPEC_VERSION},
    VkExtensionProperties{VK_EXT_LAYER_SETTINGS_EXTENSION_NAME, VK_EXT_LAYER_SETTINGS_SPEC_VERSION},
};
static constexpr std::array<VkExtensionProperties, 3> kDeviceExtensions = {
    VkExtensionProperties{VK_EXT_VALIDATION_CACHE_EXTENSION_NAME, VK_EXT_VALIDATION_CACHE_SPEC_VERSION},
    VkExtensionProperties{VK_EXT_DEBUG_MARKER_EXTENSION_NAME, VK_EXT_DEBUG_MARKER_SPEC_VERSION},
    VkExtensionProperties{VK_EXT_TOOLING_INFO_EXTENSION_NAME, VK_EXT_TOOLING_INFO_SPEC_VERSION},
};
namespace vulkan_layer_chassis {
static const VkLayerProperties global_layer = {
    OBJECT_LAYER_NAME,
    VK_HEADER_VERSION_COMPLETE,
    1,
    "LunarG validation Layer",
};

// These functions reference generated data so they cannot be part of chassis_main.cpp
VKAPI_ATTR VkResult VKAPI_CALL EnumerateInstanceLayerProperties(uint32_t* pCount, VkLayerProperties* pProperties) {
    return util_GetLayerProperties(1, &global_layer, pCount, pProperties);
}

VKAPI_ATTR VkResult VKAPI_CALL EnumerateDeviceLayerProperties(VkPhysicalDevice physicalDevice, uint32_t* pCount,
                                                              VkLayerProperties* pProperties) {
    return util_GetLayerProperties(1, &global_layer, pCount, pProperties);
}

VKAPI_ATTR VkResult VKAPI_CALL EnumerateInstanceExtensionProperties(const char* pLayerName, uint32_t* pCount,
                                                                    VkExtensionProperties* pProperties) {
    if (pLayerName && !strcmp(pLayerName, global_layer.layerName)) {
        return util_GetExtensionProperties(static_cast<uint32_t>(kInstanceExtensions.size()), kInstanceExtensions.data(), pCount,
                                           pProperties);
    }

    return VK_ERROR_LAYER_NOT_PRESENT;
}

VKAPI_ATTR VkResult VKAPI_CALL EnumerateDeviceExtensionProperties(VkPhysicalDevice physicalDevice, const char* pLayerName,
                                                                  uint32_t* pCount, VkExtensionProperties* pProperties) {
    if (pLayerName && !strcmp(pLayerName, global_layer.layerName)) {
        return util_GetExtensionProperties(static_cast<uint32_t>(kDeviceExtensions.size()), kDeviceExtensions.data(), pCount,
                                           pProperties);
    }

    assert(physicalDevice);
    auto layer_data = vvl::dispatch::GetData(physicalDevice);
    return layer_data->instance_dispatch_table.EnumerateDeviceExtensionProperties(physicalDevice, pLayerName, pCount, pProperties);
}
VKAPI_ATTR VkResult VKAPI_CALL EnumeratePhysicalDevices(VkInstance instance, uint32_t* pPhysicalDeviceCount,
                                                        VkPhysicalDevice* pPhysicalDevices) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkEnumeratePhysicalDevices, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkEnumeratePhysicalDevices");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateEnumeratePhysicalDevices(instance, pPhysicalDeviceCount, pPhysicalDevices, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkEnumeratePhysicalDevices);
    {
        VVL_ZoneScopedN("PreCallRecord_vkEnumeratePhysicalDevices");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordEnumeratePhysicalDevices(instance, pPhysicalDeviceCount, pPhysicalDevices, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkEnumeratePhysicalDevices");
        result = instance_dispatch->EnumeratePhysicalDevices(instance, pPhysicalDeviceCount, pPhysicalDevices);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkEnumeratePhysicalDevices");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordEnumeratePhysicalDevices(instance, pPhysicalDeviceCount, pPhysicalDevices, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceFeatures,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceFeatures");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceFeatures(physicalDevice, pFeatures, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceFeatures);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceFeatures");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceFeatures(physicalDevice, pFeatures, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceFeatures");
        instance_dispatch->GetPhysicalDeviceFeatures(physicalDevice, pFeatures);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceFeatures");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceFeatures(physicalDevice, pFeatures, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format,
                                                             VkFormatProperties* pFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceFormatProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceFormatProperties");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceFormatProperties(physicalDevice, format, pFormatProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceFormatProperties);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceFormatProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceFormatProperties(physicalDevice, format, pFormatProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceFormatProperties");
        instance_dispatch->GetPhysicalDeviceFormatProperties(physicalDevice, format, pFormatProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceFormatProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceFormatProperties(physicalDevice, format, pFormatProperties, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format,
                                                                      VkImageType type, VkImageTiling tiling,
                                                                      VkImageUsageFlags usage, VkImageCreateFlags flags,
                                                                      VkImageFormatProperties* pImageFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceImageFormatProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceImageFormatProperties");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceImageFormatProperties(physicalDevice, format, type, tiling, usage, flags,
                                                                              pImageFormatProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceImageFormatProperties);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceImageFormatProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceImageFormatProperties(physicalDevice, format, type, tiling, usage, flags,
                                                                    pImageFormatProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceImageFormatProperties");
        result = instance_dispatch->GetPhysicalDeviceImageFormatProperties(physicalDevice, format, type, tiling, usage, flags,
                                                                           pImageFormatProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceImageFormatProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceImageFormatProperties(physicalDevice, format, type, tiling, usage, flags,
                                                                     pImageFormatProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceProperties");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceProperties(physicalDevice, pProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceProperties);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceProperties(physicalDevice, pProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceProperties");
        instance_dispatch->GetPhysicalDeviceProperties(physicalDevice, pProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceProperties(physicalDevice, pProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice,
                                                                  uint32_t* pQueueFamilyPropertyCount,
                                                                  VkQueueFamilyProperties* pQueueFamilyProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceQueueFamilyProperties");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceQueueFamilyProperties(physicalDevice, pQueueFamilyPropertyCount,
                                                                              pQueueFamilyProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyProperties);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceQueueFamilyProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceQueueFamilyProperties(physicalDevice, pQueueFamilyPropertyCount,
                                                                    pQueueFamilyProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceQueueFamilyProperties");
        instance_dispatch->GetPhysicalDeviceQueueFamilyProperties(physicalDevice, pQueueFamilyPropertyCount,
                                                                  pQueueFamilyProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceQueueFamilyProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceQueueFamilyProperties(physicalDevice, pQueueFamilyPropertyCount,
                                                                     pQueueFamilyProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice,
                                                             VkPhysicalDeviceMemoryProperties* pMemoryProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceMemoryProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceMemoryProperties");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceMemoryProperties(physicalDevice, pMemoryProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceMemoryProperties);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceMemoryProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceMemoryProperties(physicalDevice, pMemoryProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceMemoryProperties");
        instance_dispatch->GetPhysicalDeviceMemoryProperties(physicalDevice, pMemoryProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceMemoryProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceMemoryProperties(physicalDevice, pMemoryProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceQueue, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceQueue");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceQueue]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceQueue(device, queueFamilyIndex, queueIndex, pQueue, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceQueue);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceQueue");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceQueue]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceQueue(device, queueFamilyIndex, queueIndex, pQueue, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceQueue");
        device_dispatch->GetDeviceQueue(device, queueFamilyIndex, queueIndex, pQueue);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceQueue");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceQueue]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceQueue(device, queueFamilyIndex, queueIndex, pQueue, record_obj);
        }
    }
#if defined(VVL_TRACY_GPU)
    TracyVkCollector::Create(device, *pQueue, queueFamilyIndex);
#endif
}

VKAPI_ATTR VkResult VKAPI_CALL QueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueSubmit, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate_vkQueueSubmit");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueSubmit]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueSubmit(queue, submitCount, pSubmits, fence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueSubmit);
    {
        VVL_ZoneScopedN("PreCallRecord_vkQueueSubmit");
        VVL_TracyVkNamedZoneStart(GetTracyVkCtx(), queue, "gpu_PreCallRecordvkQueueSubmit", pre_call_record_gpu_zone);

        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueSubmit]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueSubmit(queue, submitCount, pSubmits, fence, record_obj);
        }

        VVL_TracyVkNamedZoneEnd(pre_call_record_gpu_zone, queue);
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkQueueSubmit");

        VVL_TracyVkNamedZoneStart(GetTracyVkCtx(), queue, "gpu_vkQueueSubmit", submit_gpu_zone);
        result = device_dispatch->QueueSubmit(queue, submitCount, pSubmits, fence);

        VVL_TracyVkNamedZoneEnd(submit_gpu_zone, queue);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkQueueSubmit");

        VVL_TracyVkNamedZoneStart(GetTracyVkCtx(), queue, "gpu_PostCallRecordvkQueueSubmit", post_call_record_gpu_zone);

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueSubmit]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordQueueSubmit(queue, submitCount, pSubmits, fence, record_obj);
        }

        VVL_TracyVkNamedZoneEnd(post_call_record_gpu_zone, queue);
    }
#if defined(VVL_TRACY_GPU)
    TracyVkCollector::TrySubmitCollectCb(queue);
#endif
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL QueueWaitIdle(VkQueue queue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueWaitIdle, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate_vkQueueWaitIdle");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueWaitIdle]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueWaitIdle(queue, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueWaitIdle);
    {
        VVL_ZoneScopedN("PreCallRecord_vkQueueWaitIdle");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueWaitIdle]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueWaitIdle(queue, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkQueueWaitIdle");
        result = device_dispatch->QueueWaitIdle(queue);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkQueueWaitIdle");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueWaitIdle]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordQueueWaitIdle(queue, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL DeviceWaitIdle(VkDevice device) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDeviceWaitIdle, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDeviceWaitIdle");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDeviceWaitIdle]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDeviceWaitIdle(device, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkDeviceWaitIdle);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDeviceWaitIdle");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDeviceWaitIdle]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDeviceWaitIdle(device, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkDeviceWaitIdle");
        result = device_dispatch->DeviceWaitIdle(device);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkDeviceWaitIdle");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDeviceWaitIdle]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDeviceWaitIdle(device, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL AllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo,
                                              const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAllocateMemory, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkAllocateMemory");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateAllocateMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAllocateMemory(device, pAllocateInfo, pAllocator, pMemory, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAllocateMemory);
    {
        VVL_ZoneScopedN("PreCallRecord_vkAllocateMemory");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordAllocateMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordAllocateMemory(device, pAllocateInfo, pAllocator, pMemory, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkAllocateMemory");
        result = device_dispatch->AllocateMemory(device, pAllocateInfo, pAllocator, pMemory);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkAllocateMemory");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordAllocateMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordAllocateMemory(device, pAllocateInfo, pAllocator, pMemory, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL FreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkFreeMemory, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkFreeMemory");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateFreeMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateFreeMemory(device, memory, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkFreeMemory);
    {
        VVL_ZoneScopedN("PreCallRecord_vkFreeMemory");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordFreeMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordFreeMemory(device, memory, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkFreeMemory");
        device_dispatch->FreeMemory(device, memory, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkFreeMemory");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordFreeMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordFreeMemory(device, memory, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL MapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size,
                                         VkMemoryMapFlags flags, void** ppData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkMapMemory, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkMapMemory");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateMapMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateMapMemory(device, memory, offset, size, flags, ppData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkMapMemory);
    {
        VVL_ZoneScopedN("PreCallRecord_vkMapMemory");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordMapMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordMapMemory(device, memory, offset, size, flags, ppData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkMapMemory");
        result = device_dispatch->MapMemory(device, memory, offset, size, flags, ppData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkMapMemory");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordMapMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordMapMemory(device, memory, offset, size, flags, ppData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL UnmapMemory(VkDevice device, VkDeviceMemory memory) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUnmapMemory, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkUnmapMemory");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUnmapMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUnmapMemory(device, memory, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkUnmapMemory);
    {
        VVL_ZoneScopedN("PreCallRecord_vkUnmapMemory");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUnmapMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordUnmapMemory(device, memory, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkUnmapMemory");
        device_dispatch->UnmapMemory(device, memory);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkUnmapMemory");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUnmapMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordUnmapMemory(device, memory, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL FlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount,
                                                       const VkMappedMemoryRange* pMemoryRanges) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkFlushMappedMemoryRanges, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkFlushMappedMemoryRanges");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateFlushMappedMemoryRanges]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateFlushMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkFlushMappedMemoryRanges);
    {
        VVL_ZoneScopedN("PreCallRecord_vkFlushMappedMemoryRanges");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordFlushMappedMemoryRanges]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordFlushMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkFlushMappedMemoryRanges");
        result = device_dispatch->FlushMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkFlushMappedMemoryRanges");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordFlushMappedMemoryRanges]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordFlushMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL InvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount,
                                                            const VkMappedMemoryRange* pMemoryRanges) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkInvalidateMappedMemoryRanges, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkInvalidateMappedMemoryRanges");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateInvalidateMappedMemoryRanges]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateInvalidateMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkInvalidateMappedMemoryRanges);
    {
        VVL_ZoneScopedN("PreCallRecord_vkInvalidateMappedMemoryRanges");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordInvalidateMappedMemoryRanges]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordInvalidateMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkInvalidateMappedMemoryRanges");
        result = device_dispatch->InvalidateMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkInvalidateMappedMemoryRanges");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordInvalidateMappedMemoryRanges]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordInvalidateMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory,
                                                     VkDeviceSize* pCommittedMemoryInBytes) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceMemoryCommitment, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceMemoryCommitment");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceMemoryCommitment]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceMemoryCommitment(device, memory, pCommittedMemoryInBytes, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceMemoryCommitment);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceMemoryCommitment");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceMemoryCommitment]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceMemoryCommitment(device, memory, pCommittedMemoryInBytes, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceMemoryCommitment");
        device_dispatch->GetDeviceMemoryCommitment(device, memory, pCommittedMemoryInBytes);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceMemoryCommitment");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceMemoryCommitment]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceMemoryCommitment(device, memory, pCommittedMemoryInBytes, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL BindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory,
                                                VkDeviceSize memoryOffset) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindBufferMemory, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkBindBufferMemory");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindBufferMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindBufferMemory(device, buffer, memory, memoryOffset, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindBufferMemory);
    {
        VVL_ZoneScopedN("PreCallRecord_vkBindBufferMemory");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindBufferMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindBufferMemory(device, buffer, memory, memoryOffset, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkBindBufferMemory");
        result = device_dispatch->BindBufferMemory(device, buffer, memory, memoryOffset);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkBindBufferMemory");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindBufferMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindBufferMemory(device, buffer, memory, memoryOffset, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL BindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindImageMemory, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkBindImageMemory");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindImageMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindImageMemory(device, image, memory, memoryOffset, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindImageMemory);
    {
        VVL_ZoneScopedN("PreCallRecord_vkBindImageMemory");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindImageMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindImageMemory(device, image, memory, memoryOffset, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkBindImageMemory");
        result = device_dispatch->BindImageMemory(device, image, memory, memoryOffset);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkBindImageMemory");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindImageMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindImageMemory(device, image, memory, memoryOffset, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetBufferMemoryRequirements(VkDevice device, VkBuffer buffer,
                                                       VkMemoryRequirements* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferMemoryRequirements, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetBufferMemoryRequirements");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferMemoryRequirements(device, buffer, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferMemoryRequirements);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetBufferMemoryRequirements");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferMemoryRequirements(device, buffer, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetBufferMemoryRequirements");
        device_dispatch->GetBufferMemoryRequirements(device, buffer, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetBufferMemoryRequirements");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferMemoryRequirements(device, buffer, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageMemoryRequirements, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetImageMemoryRequirements");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageMemoryRequirements(device, image, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageMemoryRequirements);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetImageMemoryRequirements");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageMemoryRequirements(device, image, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetImageMemoryRequirements");
        device_dispatch->GetImageMemoryRequirements(device, image, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetImageMemoryRequirements");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageMemoryRequirements(device, image, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount,
                                                            VkSparseImageMemoryRequirements* pSparseMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageSparseMemoryRequirements, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetImageSparseMemoryRequirements");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageSparseMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageSparseMemoryRequirements(device, image, pSparseMemoryRequirementCount,
                                                                        pSparseMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageSparseMemoryRequirements);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetImageSparseMemoryRequirements");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageSparseMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageSparseMemoryRequirements(device, image, pSparseMemoryRequirementCount,
                                                              pSparseMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetImageSparseMemoryRequirements");
        device_dispatch->GetImageSparseMemoryRequirements(device, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetImageSparseMemoryRequirements");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageSparseMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageSparseMemoryRequirements(device, image, pSparseMemoryRequirementCount,
                                                               pSparseMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceSparseImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format,
                                                                        VkImageType type, VkSampleCountFlagBits samples,
                                                                        VkImageUsageFlags usage, VkImageTiling tiling,
                                                                        uint32_t* pPropertyCount,
                                                                        VkSparseImageFormatProperties* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSparseImageFormatProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceSparseImageFormatProperties");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceSparseImageFormatProperties(physicalDevice, format, type, samples, usage,
                                                                                    tiling, pPropertyCount, pProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSparseImageFormatProperties);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceSparseImageFormatProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceSparseImageFormatProperties(physicalDevice, format, type, samples, usage, tiling,
                                                                          pPropertyCount, pProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceSparseImageFormatProperties");
        instance_dispatch->GetPhysicalDeviceSparseImageFormatProperties(physicalDevice, format, type, samples, usage, tiling,
                                                                        pPropertyCount, pProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceSparseImageFormatProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceSparseImageFormatProperties(physicalDevice, format, type, samples, usage, tiling,
                                                                           pPropertyCount, pProperties, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL QueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo,
                                               VkFence fence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueBindSparse, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate_vkQueueBindSparse");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueBindSparse]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueBindSparse(queue, bindInfoCount, pBindInfo, fence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueBindSparse);
    {
        VVL_ZoneScopedN("PreCallRecord_vkQueueBindSparse");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueBindSparse]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueBindSparse(queue, bindInfoCount, pBindInfo, fence, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkQueueBindSparse");
        result = device_dispatch->QueueBindSparse(queue, bindInfoCount, pBindInfo, fence);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkQueueBindSparse");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueBindSparse]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordQueueBindSparse(queue, bindInfoCount, pBindInfo, fence, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo,
                                           const VkAllocationCallbacks* pAllocator, VkFence* pFence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateFence, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateFence");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateFence]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateFence(device, pCreateInfo, pAllocator, pFence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateFence);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateFence");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateFence]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateFence(device, pCreateInfo, pAllocator, pFence, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateFence");
        result = device_dispatch->CreateFence(device, pCreateInfo, pAllocator, pFence);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateFence");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateFence]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateFence(device, pCreateInfo, pAllocator, pFence, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyFence, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyFence");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyFence]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyFence(device, fence, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyFence);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyFence");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyFence]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyFence(device, fence, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyFence");
        device_dispatch->DestroyFence(device, fence, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyFence");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyFence]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyFence(device, fence, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL ResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkResetFences, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkResetFences");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateResetFences]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateResetFences(device, fenceCount, pFences, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkResetFences);
    {
        VVL_ZoneScopedN("PreCallRecord_vkResetFences");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordResetFences]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordResetFences(device, fenceCount, pFences, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkResetFences");
        result = device_dispatch->ResetFences(device, fenceCount, pFences);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkResetFences");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordResetFences]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordResetFences(device, fenceCount, pFences, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetFenceStatus(VkDevice device, VkFence fence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetFenceStatus, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetFenceStatus");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetFenceStatus]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetFenceStatus(device, fence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetFenceStatus);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetFenceStatus");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetFenceStatus]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetFenceStatus(device, fence, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetFenceStatus");
        result = device_dispatch->GetFenceStatus(device, fence);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetFenceStatus");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetFenceStatus]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetFenceStatus(device, fence, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL WaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll,
                                             uint64_t timeout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkWaitForFences, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkWaitForFences");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateWaitForFences]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateWaitForFences(device, fenceCount, pFences, waitAll, timeout, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkWaitForFences);
    {
        VVL_ZoneScopedN("PreCallRecord_vkWaitForFences");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordWaitForFences]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordWaitForFences(device, fenceCount, pFences, waitAll, timeout, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkWaitForFences");
        result = device_dispatch->WaitForFences(device, fenceCount, pFences, waitAll, timeout);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkWaitForFences");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordWaitForFences]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordWaitForFences(device, fenceCount, pFences, waitAll, timeout, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo,
                                               const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateSemaphore, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateSemaphore");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateSemaphore]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateSemaphore(device, pCreateInfo, pAllocator, pSemaphore, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateSemaphore);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateSemaphore");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateSemaphore]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateSemaphore(device, pCreateInfo, pAllocator, pSemaphore, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateSemaphore");
        result = device_dispatch->CreateSemaphore(device, pCreateInfo, pAllocator, pSemaphore);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateSemaphore");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateSemaphore]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateSemaphore(device, pCreateInfo, pAllocator, pSemaphore, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroySemaphore, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroySemaphore");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroySemaphore]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroySemaphore(device, semaphore, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroySemaphore);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroySemaphore");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroySemaphore]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroySemaphore(device, semaphore, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroySemaphore");
        device_dispatch->DestroySemaphore(device, semaphore, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroySemaphore");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroySemaphore]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroySemaphore(device, semaphore, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo,
                                           const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateEvent, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateEvent");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateEvent(device, pCreateInfo, pAllocator, pEvent, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateEvent);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateEvent");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateEvent(device, pCreateInfo, pAllocator, pEvent, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateEvent");
        result = device_dispatch->CreateEvent(device, pCreateInfo, pAllocator, pEvent);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateEvent");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateEvent(device, pCreateInfo, pAllocator, pEvent, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyEvent, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyEvent");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyEvent(device, event, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyEvent);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyEvent");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyEvent(device, event, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyEvent");
        device_dispatch->DestroyEvent(device, event, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyEvent");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyEvent(device, event, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetEventStatus(VkDevice device, VkEvent event) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetEventStatus, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetEventStatus");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetEventStatus]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetEventStatus(device, event, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetEventStatus);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetEventStatus");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetEventStatus]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetEventStatus(device, event, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetEventStatus");
        result = device_dispatch->GetEventStatus(device, event);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetEventStatus");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetEventStatus]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetEventStatus(device, event, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL SetEvent(VkDevice device, VkEvent event) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSetEvent, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkSetEvent");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSetEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSetEvent(device, event, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkSetEvent);
    {
        VVL_ZoneScopedN("PreCallRecord_vkSetEvent");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSetEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordSetEvent(device, event, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkSetEvent");
        result = device_dispatch->SetEvent(device, event);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkSetEvent");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSetEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordSetEvent(device, event, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL ResetEvent(VkDevice device, VkEvent event) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkResetEvent, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkResetEvent");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateResetEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateResetEvent(device, event, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkResetEvent);
    {
        VVL_ZoneScopedN("PreCallRecord_vkResetEvent");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordResetEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordResetEvent(device, event, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkResetEvent");
        result = device_dispatch->ResetEvent(device, event);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkResetEvent");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordResetEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordResetEvent(device, event, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo,
                                               const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateQueryPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateQueryPool");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateQueryPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateQueryPool(device, pCreateInfo, pAllocator, pQueryPool, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateQueryPool);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateQueryPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateQueryPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateQueryPool(device, pCreateInfo, pAllocator, pQueryPool, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateQueryPool");
        result = device_dispatch->CreateQueryPool(device, pCreateInfo, pAllocator, pQueryPool);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateQueryPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateQueryPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateQueryPool(device, pCreateInfo, pAllocator, pQueryPool, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyQueryPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyQueryPool");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyQueryPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyQueryPool(device, queryPool, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyQueryPool);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyQueryPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyQueryPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyQueryPool(device, queryPool, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyQueryPool");
        device_dispatch->DestroyQueryPool(device, queryPool, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyQueryPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyQueryPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyQueryPool(device, queryPool, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount,
                                                   size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetQueryPoolResults, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetQueryPoolResults");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetQueryPoolResults]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetQueryPoolResults(device, queryPool, firstQuery, queryCount, dataSize, pData, stride,
                                                           flags, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetQueryPoolResults);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetQueryPoolResults");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetQueryPoolResults]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetQueryPoolResults(device, queryPool, firstQuery, queryCount, dataSize, pData, stride, flags,
                                                 record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetQueryPoolResults");
        result = device_dispatch->GetQueryPoolResults(device, queryPool, firstQuery, queryCount, dataSize, pData, stride, flags);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetQueryPoolResults");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetQueryPoolResults]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetQueryPoolResults(device, queryPool, firstQuery, queryCount, dataSize, pData, stride, flags,
                                                  record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyBuffer, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyBuffer");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyBuffer(device, buffer, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyBuffer(device, buffer, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyBuffer");
        device_dispatch->DestroyBuffer(device, buffer, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyBuffer(device, buffer, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo,
                                                const VkAllocationCallbacks* pAllocator, VkBufferView* pView) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateBufferView, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateBufferView");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateBufferView]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateBufferView(device, pCreateInfo, pAllocator, pView, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateBufferView);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateBufferView");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateBufferView]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateBufferView(device, pCreateInfo, pAllocator, pView, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateBufferView");
        result = device_dispatch->CreateBufferView(device, pCreateInfo, pAllocator, pView);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateBufferView");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateBufferView]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateBufferView(device, pCreateInfo, pAllocator, pView, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyBufferView, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyBufferView");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyBufferView]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyBufferView(device, bufferView, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyBufferView);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyBufferView");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyBufferView]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyBufferView(device, bufferView, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyBufferView");
        device_dispatch->DestroyBufferView(device, bufferView, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyBufferView");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyBufferView]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyBufferView(device, bufferView, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo,
                                           const VkAllocationCallbacks* pAllocator, VkImage* pImage) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateImage, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateImage");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateImage(device, pCreateInfo, pAllocator, pImage, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateImage);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateImage(device, pCreateInfo, pAllocator, pImage, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateImage");
        result = device_dispatch->CreateImage(device, pCreateInfo, pAllocator, pImage);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateImage(device, pCreateInfo, pAllocator, pImage, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyImage, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyImage");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyImage(device, image, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyImage);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyImage(device, image, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyImage");
        device_dispatch->DestroyImage(device, image, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyImage(device, image, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource,
                                                     VkSubresourceLayout* pLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageSubresourceLayout, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetImageSubresourceLayout");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageSubresourceLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageSubresourceLayout(device, image, pSubresource, pLayout, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageSubresourceLayout);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetImageSubresourceLayout");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageSubresourceLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageSubresourceLayout(device, image, pSubresource, pLayout, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetImageSubresourceLayout");
        device_dispatch->GetImageSubresourceLayout(device, image, pSubresource, pLayout);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetImageSubresourceLayout");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageSubresourceLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageSubresourceLayout(device, image, pSubresource, pLayout, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo,
                                               const VkAllocationCallbacks* pAllocator, VkImageView* pView) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateImageView, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateImageView");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateImageView]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateImageView(device, pCreateInfo, pAllocator, pView, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateImageView);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateImageView");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateImageView]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateImageView(device, pCreateInfo, pAllocator, pView, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateImageView");
        result = device_dispatch->CreateImageView(device, pCreateInfo, pAllocator, pView);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateImageView");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateImageView]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateImageView(device, pCreateInfo, pAllocator, pView, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyImageView, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyImageView");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyImageView]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyImageView(device, imageView, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyImageView);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyImageView");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyImageView]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyImageView(device, imageView, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyImageView");
        device_dispatch->DestroyImageView(device, imageView, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyImageView");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyImageView]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyImageView(device, imageView, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL DestroyShaderModule(VkDevice device, VkShaderModule shaderModule,
                                               const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyShaderModule, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyShaderModule");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyShaderModule]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyShaderModule(device, shaderModule, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyShaderModule);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyShaderModule");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyShaderModule]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyShaderModule(device, shaderModule, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyShaderModule");
        device_dispatch->DestroyShaderModule(device, shaderModule, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyShaderModule");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyShaderModule]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyShaderModule(device, shaderModule, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo,
                                                   const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreatePipelineCache, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreatePipelineCache");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreatePipelineCache]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreatePipelineCache(device, pCreateInfo, pAllocator, pPipelineCache, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreatePipelineCache);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreatePipelineCache");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreatePipelineCache]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreatePipelineCache(device, pCreateInfo, pAllocator, pPipelineCache, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreatePipelineCache");
        result = device_dispatch->CreatePipelineCache(device, pCreateInfo, pAllocator, pPipelineCache);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreatePipelineCache");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreatePipelineCache]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreatePipelineCache(device, pCreateInfo, pAllocator, pPipelineCache, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache,
                                                const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyPipelineCache, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyPipelineCache");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyPipelineCache]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyPipelineCache(device, pipelineCache, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyPipelineCache);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyPipelineCache");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyPipelineCache]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyPipelineCache(device, pipelineCache, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyPipelineCache");
        device_dispatch->DestroyPipelineCache(device, pipelineCache, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyPipelineCache");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyPipelineCache]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyPipelineCache(device, pipelineCache, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize,
                                                    void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPipelineCacheData, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPipelineCacheData");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPipelineCacheData]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPipelineCacheData(device, pipelineCache, pDataSize, pData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPipelineCacheData);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPipelineCacheData");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPipelineCacheData]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPipelineCacheData(device, pipelineCache, pDataSize, pData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPipelineCacheData");
        result = device_dispatch->GetPipelineCacheData(device, pipelineCache, pDataSize, pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPipelineCacheData");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPipelineCacheData]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPipelineCacheData(device, pipelineCache, pDataSize, pData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL MergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount,
                                                   const VkPipelineCache* pSrcCaches) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkMergePipelineCaches, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkMergePipelineCaches");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateMergePipelineCaches]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateMergePipelineCaches(device, dstCache, srcCacheCount, pSrcCaches, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkMergePipelineCaches);
    {
        VVL_ZoneScopedN("PreCallRecord_vkMergePipelineCaches");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordMergePipelineCaches]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordMergePipelineCaches(device, dstCache, srcCacheCount, pSrcCaches, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkMergePipelineCaches");
        result = device_dispatch->MergePipelineCaches(device, dstCache, srcCacheCount, pSrcCaches);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkMergePipelineCaches");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordMergePipelineCaches]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordMergePipelineCaches(device, dstCache, srcCacheCount, pSrcCaches, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyPipeline, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyPipeline");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyPipeline]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyPipeline(device, pipeline, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyPipeline);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyPipeline");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyPipeline]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyPipeline(device, pipeline, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyPipeline");
        device_dispatch->DestroyPipeline(device, pipeline, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyPipeline");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyPipeline]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyPipeline(device, pipeline, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL DestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout,
                                                 const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyPipelineLayout, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyPipelineLayout");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyPipelineLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyPipelineLayout(device, pipelineLayout, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyPipelineLayout);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyPipelineLayout");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyPipelineLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyPipelineLayout(device, pipelineLayout, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyPipelineLayout");
        device_dispatch->DestroyPipelineLayout(device, pipelineLayout, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyPipelineLayout");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyPipelineLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyPipelineLayout(device, pipelineLayout, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo,
                                             const VkAllocationCallbacks* pAllocator, VkSampler* pSampler) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateSampler, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateSampler");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateSampler]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateSampler(device, pCreateInfo, pAllocator, pSampler, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateSampler);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateSampler");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateSampler]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateSampler(device, pCreateInfo, pAllocator, pSampler, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateSampler");
        result = device_dispatch->CreateSampler(device, pCreateInfo, pAllocator, pSampler);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateSampler");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateSampler]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateSampler(device, pCreateInfo, pAllocator, pSampler, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroySampler, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroySampler");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroySampler]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroySampler(device, sampler, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroySampler);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroySampler");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroySampler]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroySampler(device, sampler, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroySampler");
        device_dispatch->DestroySampler(device, sampler, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroySampler");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroySampler]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroySampler(device, sampler, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
                                                         const VkAllocationCallbacks* pAllocator,
                                                         VkDescriptorSetLayout* pSetLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDescriptorSetLayout, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateDescriptorSetLayout");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateDescriptorSetLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDescriptorSetLayout(device, pCreateInfo, pAllocator, pSetLayout, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDescriptorSetLayout);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateDescriptorSetLayout");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateDescriptorSetLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDescriptorSetLayout(device, pCreateInfo, pAllocator, pSetLayout, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateDescriptorSetLayout");
        result = device_dispatch->CreateDescriptorSetLayout(device, pCreateInfo, pAllocator, pSetLayout);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateDescriptorSetLayout");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateDescriptorSetLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDescriptorSetLayout(device, pCreateInfo, pAllocator, pSetLayout, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout,
                                                      const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyDescriptorSetLayout, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyDescriptorSetLayout");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyDescriptorSetLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyDescriptorSetLayout(device, descriptorSetLayout, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyDescriptorSetLayout);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyDescriptorSetLayout");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyDescriptorSetLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyDescriptorSetLayout(device, descriptorSetLayout, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyDescriptorSetLayout");
        device_dispatch->DestroyDescriptorSetLayout(device, descriptorSetLayout, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyDescriptorSetLayout");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyDescriptorSetLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyDescriptorSetLayout(device, descriptorSetLayout, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo,
                                                    const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDescriptorPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateDescriptorPool");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateDescriptorPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDescriptorPool(device, pCreateInfo, pAllocator, pDescriptorPool, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDescriptorPool);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateDescriptorPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateDescriptorPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDescriptorPool(device, pCreateInfo, pAllocator, pDescriptorPool, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateDescriptorPool");
        result = device_dispatch->CreateDescriptorPool(device, pCreateInfo, pAllocator, pDescriptorPool);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateDescriptorPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateDescriptorPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDescriptorPool(device, pCreateInfo, pAllocator, pDescriptorPool, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool,
                                                 const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyDescriptorPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyDescriptorPool");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyDescriptorPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyDescriptorPool(device, descriptorPool, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyDescriptorPool);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyDescriptorPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyDescriptorPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyDescriptorPool(device, descriptorPool, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyDescriptorPool");
        device_dispatch->DestroyDescriptorPool(device, descriptorPool, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyDescriptorPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyDescriptorPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyDescriptorPool(device, descriptorPool, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL ResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool,
                                                   VkDescriptorPoolResetFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkResetDescriptorPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkResetDescriptorPool");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateResetDescriptorPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateResetDescriptorPool(device, descriptorPool, flags, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkResetDescriptorPool);
    {
        VVL_ZoneScopedN("PreCallRecord_vkResetDescriptorPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordResetDescriptorPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordResetDescriptorPool(device, descriptorPool, flags, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkResetDescriptorPool");
        result = device_dispatch->ResetDescriptorPool(device, descriptorPool, flags);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkResetDescriptorPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordResetDescriptorPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordResetDescriptorPool(device, descriptorPool, flags, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL FreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount,
                                                  const VkDescriptorSet* pDescriptorSets) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkFreeDescriptorSets, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkFreeDescriptorSets");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateFreeDescriptorSets]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateFreeDescriptorSets(device, descriptorPool, descriptorSetCount, pDescriptorSets, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkFreeDescriptorSets);
    {
        VVL_ZoneScopedN("PreCallRecord_vkFreeDescriptorSets");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordFreeDescriptorSets]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordFreeDescriptorSets(device, descriptorPool, descriptorSetCount, pDescriptorSets, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkFreeDescriptorSets");
        result = device_dispatch->FreeDescriptorSets(device, descriptorPool, descriptorSetCount, pDescriptorSets);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkFreeDescriptorSets");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordFreeDescriptorSets]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordFreeDescriptorSets(device, descriptorPool, descriptorSetCount, pDescriptorSets, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL UpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount,
                                                const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount,
                                                const VkCopyDescriptorSet* pDescriptorCopies) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUpdateDescriptorSets, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkUpdateDescriptorSets");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUpdateDescriptorSets]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUpdateDescriptorSets(device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount,
                                                            pDescriptorCopies, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkUpdateDescriptorSets);
    {
        VVL_ZoneScopedN("PreCallRecord_vkUpdateDescriptorSets");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUpdateDescriptorSets]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordUpdateDescriptorSets(device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount,
                                                  pDescriptorCopies, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkUpdateDescriptorSets");
        device_dispatch->UpdateDescriptorSets(device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount,
                                              pDescriptorCopies);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkUpdateDescriptorSets");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUpdateDescriptorSets]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordUpdateDescriptorSets(device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount,
                                                   pDescriptorCopies, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo,
                                                 const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateFramebuffer, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateFramebuffer");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateFramebuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateFramebuffer(device, pCreateInfo, pAllocator, pFramebuffer, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateFramebuffer);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateFramebuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateFramebuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateFramebuffer(device, pCreateInfo, pAllocator, pFramebuffer, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateFramebuffer");
        result = device_dispatch->CreateFramebuffer(device, pCreateInfo, pAllocator, pFramebuffer);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateFramebuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateFramebuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateFramebuffer(device, pCreateInfo, pAllocator, pFramebuffer, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyFramebuffer, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyFramebuffer");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyFramebuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyFramebuffer(device, framebuffer, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyFramebuffer);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyFramebuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyFramebuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyFramebuffer(device, framebuffer, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyFramebuffer");
        device_dispatch->DestroyFramebuffer(device, framebuffer, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyFramebuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyFramebuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyFramebuffer(device, framebuffer, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo,
                                                const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateRenderPass, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateRenderPass");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateRenderPass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateRenderPass(device, pCreateInfo, pAllocator, pRenderPass, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateRenderPass);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateRenderPass");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateRenderPass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateRenderPass(device, pCreateInfo, pAllocator, pRenderPass, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateRenderPass");
        result = device_dispatch->CreateRenderPass(device, pCreateInfo, pAllocator, pRenderPass);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateRenderPass");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateRenderPass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateRenderPass(device, pCreateInfo, pAllocator, pRenderPass, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyRenderPass, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyRenderPass");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyRenderPass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyRenderPass(device, renderPass, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyRenderPass);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyRenderPass");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyRenderPass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyRenderPass(device, renderPass, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyRenderPass");
        device_dispatch->DestroyRenderPass(device, renderPass, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyRenderPass");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyRenderPass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyRenderPass(device, renderPass, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetRenderAreaGranularity, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetRenderAreaGranularity");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetRenderAreaGranularity]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetRenderAreaGranularity(device, renderPass, pGranularity, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetRenderAreaGranularity);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetRenderAreaGranularity");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetRenderAreaGranularity]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetRenderAreaGranularity(device, renderPass, pGranularity, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetRenderAreaGranularity");
        device_dispatch->GetRenderAreaGranularity(device, renderPass, pGranularity);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetRenderAreaGranularity");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetRenderAreaGranularity]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetRenderAreaGranularity(device, renderPass, pGranularity, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo,
                                                 const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateCommandPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateCommandPool");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateCommandPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateCommandPool(device, pCreateInfo, pAllocator, pCommandPool, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateCommandPool);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateCommandPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateCommandPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateCommandPool(device, pCreateInfo, pAllocator, pCommandPool, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateCommandPool");
        result = device_dispatch->CreateCommandPool(device, pCreateInfo, pAllocator, pCommandPool);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateCommandPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateCommandPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateCommandPool(device, pCreateInfo, pAllocator, pCommandPool, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyCommandPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyCommandPool");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyCommandPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyCommandPool(device, commandPool, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyCommandPool);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyCommandPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyCommandPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyCommandPool(device, commandPool, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyCommandPool");
        device_dispatch->DestroyCommandPool(device, commandPool, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyCommandPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyCommandPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyCommandPool(device, commandPool, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL ResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkResetCommandPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkResetCommandPool");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateResetCommandPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateResetCommandPool(device, commandPool, flags, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkResetCommandPool);
    {
        VVL_ZoneScopedN("PreCallRecord_vkResetCommandPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordResetCommandPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordResetCommandPool(device, commandPool, flags, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkResetCommandPool");
        result = device_dispatch->ResetCommandPool(device, commandPool, flags);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkResetCommandPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordResetCommandPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordResetCommandPool(device, commandPool, flags, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL AllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo,
                                                      VkCommandBuffer* pCommandBuffers) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAllocateCommandBuffers, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkAllocateCommandBuffers");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateAllocateCommandBuffers]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAllocateCommandBuffers(device, pAllocateInfo, pCommandBuffers, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAllocateCommandBuffers);
    {
        VVL_ZoneScopedN("PreCallRecord_vkAllocateCommandBuffers");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordAllocateCommandBuffers]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordAllocateCommandBuffers(device, pAllocateInfo, pCommandBuffers, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkAllocateCommandBuffers");
        result = device_dispatch->AllocateCommandBuffers(device, pAllocateInfo, pCommandBuffers);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkAllocateCommandBuffers");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordAllocateCommandBuffers]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordAllocateCommandBuffers(device, pAllocateInfo, pCommandBuffers, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL FreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount,
                                              const VkCommandBuffer* pCommandBuffers) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkFreeCommandBuffers, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkFreeCommandBuffers");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateFreeCommandBuffers]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateFreeCommandBuffers(device, commandPool, commandBufferCount, pCommandBuffers, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkFreeCommandBuffers);
    {
        VVL_ZoneScopedN("PreCallRecord_vkFreeCommandBuffers");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordFreeCommandBuffers]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordFreeCommandBuffers(device, commandPool, commandBufferCount, pCommandBuffers, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkFreeCommandBuffers");
        device_dispatch->FreeCommandBuffers(device, commandPool, commandBufferCount, pCommandBuffers);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkFreeCommandBuffers");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordFreeCommandBuffers]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordFreeCommandBuffers(device, commandPool, commandBufferCount, pCommandBuffers, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL EndCommandBuffer(VkCommandBuffer commandBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkEndCommandBuffer, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkEndCommandBuffer");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateEndCommandBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateEndCommandBuffer(commandBuffer, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkEndCommandBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord_vkEndCommandBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordEndCommandBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordEndCommandBuffer(commandBuffer, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkEndCommandBuffer");
        result = device_dispatch->EndCommandBuffer(commandBuffer);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkEndCommandBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordEndCommandBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordEndCommandBuffer(commandBuffer, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL ResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkResetCommandBuffer, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkResetCommandBuffer");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateResetCommandBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateResetCommandBuffer(commandBuffer, flags, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkResetCommandBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord_vkResetCommandBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordResetCommandBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordResetCommandBuffer(commandBuffer, flags, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkResetCommandBuffer");
        result = device_dispatch->ResetCommandBuffer(commandBuffer, flags);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkResetCommandBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordResetCommandBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordResetCommandBuffer(commandBuffer, flags, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint,
                                           VkPipeline pipeline) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindPipeline, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBindPipeline");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindPipeline]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindPipeline(commandBuffer, pipelineBindPoint, pipeline, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindPipeline);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBindPipeline");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindPipeline]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindPipeline(commandBuffer, pipelineBindPoint, pipeline, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBindPipeline");
        device_dispatch->CmdBindPipeline(commandBuffer, pipelineBindPoint, pipeline);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBindPipeline");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindPipeline]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindPipeline(commandBuffer, pipelineBindPoint, pipeline, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount,
                                          const VkViewport* pViewports) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetViewport, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetViewport");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetViewport]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetViewport(commandBuffer, firstViewport, viewportCount, pViewports, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetViewport);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetViewport");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetViewport]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetViewport(commandBuffer, firstViewport, viewportCount, pViewports, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetViewport");
        device_dispatch->CmdSetViewport(commandBuffer, firstViewport, viewportCount, pViewports);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetViewport");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetViewport]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetViewport(commandBuffer, firstViewport, viewportCount, pViewports, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount,
                                         const VkRect2D* pScissors) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetScissor, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetScissor");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetScissor]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetScissor(commandBuffer, firstScissor, scissorCount, pScissors, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetScissor);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetScissor");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetScissor]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetScissor(commandBuffer, firstScissor, scissorCount, pScissors, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetScissor");
        device_dispatch->CmdSetScissor(commandBuffer, firstScissor, scissorCount, pScissors);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetScissor");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetScissor]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetScissor(commandBuffer, firstScissor, scissorCount, pScissors, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetLineWidth, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetLineWidth");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetLineWidth]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetLineWidth(commandBuffer, lineWidth, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetLineWidth);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetLineWidth");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetLineWidth]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetLineWidth(commandBuffer, lineWidth, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetLineWidth");
        device_dispatch->CmdSetLineWidth(commandBuffer, lineWidth);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetLineWidth");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetLineWidth]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetLineWidth(commandBuffer, lineWidth, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp,
                                           float depthBiasSlopeFactor) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthBias, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetDepthBias");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthBias]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthBias(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor,
                                                       error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthBias);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetDepthBias");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthBias]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthBias(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor,
                                             record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetDepthBias");
        device_dispatch->CmdSetDepthBias(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetDepthBias");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthBias]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthBias(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor,
                                              record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4]) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetBlendConstants, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetBlendConstants");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetBlendConstants]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetBlendConstants(commandBuffer, blendConstants, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetBlendConstants);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetBlendConstants");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetBlendConstants]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetBlendConstants(commandBuffer, blendConstants, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetBlendConstants");
        device_dispatch->CmdSetBlendConstants(commandBuffer, blendConstants);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetBlendConstants");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetBlendConstants]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetBlendConstants(commandBuffer, blendConstants, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthBounds, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetDepthBounds");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthBounds]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthBounds(commandBuffer, minDepthBounds, maxDepthBounds, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthBounds);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetDepthBounds");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthBounds]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthBounds(commandBuffer, minDepthBounds, maxDepthBounds, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetDepthBounds");
        device_dispatch->CmdSetDepthBounds(commandBuffer, minDepthBounds, maxDepthBounds);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetDepthBounds");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthBounds]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthBounds(commandBuffer, minDepthBounds, maxDepthBounds, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask,
                                                    uint32_t compareMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetStencilCompareMask, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetStencilCompareMask");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetStencilCompareMask]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetStencilCompareMask(commandBuffer, faceMask, compareMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetStencilCompareMask);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetStencilCompareMask");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetStencilCompareMask]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetStencilCompareMask(commandBuffer, faceMask, compareMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetStencilCompareMask");
        device_dispatch->CmdSetStencilCompareMask(commandBuffer, faceMask, compareMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetStencilCompareMask");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetStencilCompareMask]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetStencilCompareMask(commandBuffer, faceMask, compareMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetStencilWriteMask, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetStencilWriteMask");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetStencilWriteMask]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetStencilWriteMask(commandBuffer, faceMask, writeMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetStencilWriteMask);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetStencilWriteMask");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetStencilWriteMask]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetStencilWriteMask(commandBuffer, faceMask, writeMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetStencilWriteMask");
        device_dispatch->CmdSetStencilWriteMask(commandBuffer, faceMask, writeMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetStencilWriteMask");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetStencilWriteMask]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetStencilWriteMask(commandBuffer, faceMask, writeMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetStencilReference, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetStencilReference");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetStencilReference]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetStencilReference(commandBuffer, faceMask, reference, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetStencilReference);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetStencilReference");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetStencilReference]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetStencilReference(commandBuffer, faceMask, reference, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetStencilReference");
        device_dispatch->CmdSetStencilReference(commandBuffer, faceMask, reference);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetStencilReference");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetStencilReference]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetStencilReference(commandBuffer, faceMask, reference, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint,
                                                 VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount,
                                                 const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount,
                                                 const uint32_t* pDynamicOffsets) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindDescriptorSets, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBindDescriptorSets");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindDescriptorSets]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindDescriptorSets(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount,
                                                             pDescriptorSets, dynamicOffsetCount, pDynamicOffsets, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindDescriptorSets);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBindDescriptorSets");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindDescriptorSets]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindDescriptorSets(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount,
                                                   pDescriptorSets, dynamicOffsetCount, pDynamicOffsets, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBindDescriptorSets");
        device_dispatch->CmdBindDescriptorSets(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount,
                                               pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBindDescriptorSets");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindDescriptorSets]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindDescriptorSets(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount,
                                                    pDescriptorSets, dynamicOffsetCount, pDynamicOffsets, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                              VkIndexType indexType) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindIndexBuffer, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBindIndexBuffer");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindIndexBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindIndexBuffer(commandBuffer, buffer, offset, indexType, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindIndexBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBindIndexBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindIndexBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindIndexBuffer(commandBuffer, buffer, offset, indexType, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBindIndexBuffer");
        device_dispatch->CmdBindIndexBuffer(commandBuffer, buffer, offset, indexType);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBindIndexBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindIndexBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindIndexBuffer(commandBuffer, buffer, offset, indexType, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount,
                                                const VkBuffer* pBuffers, const VkDeviceSize* pOffsets) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindVertexBuffers, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBindVertexBuffers");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindVertexBuffers]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdBindVertexBuffers(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindVertexBuffers);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBindVertexBuffers");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindVertexBuffers]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindVertexBuffers(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBindVertexBuffers");
        device_dispatch->CmdBindVertexBuffers(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBindVertexBuffers");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindVertexBuffers]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindVertexBuffers(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount,
                                   uint32_t firstVertex, uint32_t firstInstance) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDraw, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDraw");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDraw]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDraw(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDraw);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDraw");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDraw]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDraw(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDraw");
        device_dispatch->CmdDraw(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDraw");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDraw]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDraw(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount,
                                          uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndexed, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDrawIndexed");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndexed]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndexed(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset,
                                                      firstInstance, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndexed);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDrawIndexed");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndexed]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndexed(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance,
                                            record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDrawIndexed");
        device_dispatch->CmdDrawIndexed(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDrawIndexed");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndexed]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndexed(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance,
                                             record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount,
                                           uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndirect, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDrawIndirect");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndirect]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndirect(commandBuffer, buffer, offset, drawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndirect);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDrawIndirect");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndirect]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndirect(commandBuffer, buffer, offset, drawCount, stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDrawIndirect");
        device_dispatch->CmdDrawIndirect(commandBuffer, buffer, offset, drawCount, stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDrawIndirect");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndirect]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndirect(commandBuffer, buffer, offset, drawCount, stride, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                  uint32_t drawCount, uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndexedIndirect, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDrawIndexedIndirect");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndexedIndirect]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndexedIndirect(commandBuffer, buffer, offset, drawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndexedIndirect);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDrawIndexedIndirect");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndexedIndirect]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndexedIndirect(commandBuffer, buffer, offset, drawCount, stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDrawIndexedIndirect");
        device_dispatch->CmdDrawIndexedIndirect(commandBuffer, buffer, offset, drawCount, stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDrawIndexedIndirect");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndexedIndirect]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndexedIndirect(commandBuffer, buffer, offset, drawCount, stride, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY,
                                       uint32_t groupCountZ) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDispatch, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDispatch");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDispatch]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDispatch(commandBuffer, groupCountX, groupCountY, groupCountZ, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDispatch);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDispatch");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDispatch]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDispatch(commandBuffer, groupCountX, groupCountY, groupCountZ, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDispatch");
        device_dispatch->CmdDispatch(commandBuffer, groupCountX, groupCountY, groupCountZ);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDispatch");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDispatch]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDispatch(commandBuffer, groupCountX, groupCountY, groupCountZ, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDispatchIndirect, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDispatchIndirect");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDispatchIndirect]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDispatchIndirect(commandBuffer, buffer, offset, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDispatchIndirect);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDispatchIndirect");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDispatchIndirect]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDispatchIndirect(commandBuffer, buffer, offset, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDispatchIndirect");
        device_dispatch->CmdDispatchIndirect(commandBuffer, buffer, offset);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDispatchIndirect");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDispatchIndirect]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDispatchIndirect(commandBuffer, buffer, offset, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer,
                                         uint32_t regionCount, const VkBufferCopy* pRegions) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyBuffer, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyBuffer");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyBuffer(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyBuffer(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyBuffer");
        device_dispatch->CmdCopyBuffer(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyBuffer(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout,
                                        VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount,
                                        const VkImageCopy* pRegions) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyImage, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyImage");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount,
                                                    pRegions, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyImage);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions,
                                          record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyImage");
        device_dispatch->CmdCopyImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions,
                                           record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout,
                                        VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount,
                                        const VkImageBlit* pRegions, VkFilter filter) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBlitImage, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBlitImage");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBlitImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBlitImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount,
                                                    pRegions, filter, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBlitImage);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBlitImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBlitImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBlitImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions,
                                          filter, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBlitImage");
        device_dispatch->CmdBlitImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions,
                                      filter);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBlitImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBlitImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBlitImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions,
                                           filter, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage,
                                                VkImageLayout dstImageLayout, uint32_t regionCount,
                                                const VkBufferImageCopy* pRegions) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyBufferToImage, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyBufferToImage");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyBufferToImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyBufferToImage(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount,
                                                            pRegions, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyBufferToImage);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyBufferToImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyBufferToImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyBufferToImage(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions,
                                                  record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyBufferToImage");
        device_dispatch->CmdCopyBufferToImage(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyBufferToImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyBufferToImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyBufferToImage(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions,
                                                   record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout,
                                                VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyImageToBuffer, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyImageToBuffer");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyImageToBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyImageToBuffer(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount,
                                                            pRegions, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyImageToBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyImageToBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyImageToBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyImageToBuffer(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions,
                                                  record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyImageToBuffer");
        device_dispatch->CmdCopyImageToBuffer(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyImageToBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyImageToBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyImageToBuffer(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions,
                                                   record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset,
                                           VkDeviceSize dataSize, const void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdUpdateBuffer, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdUpdateBuffer");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdUpdateBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdUpdateBuffer(commandBuffer, dstBuffer, dstOffset, dataSize, pData, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdUpdateBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdUpdateBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdUpdateBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdUpdateBuffer(commandBuffer, dstBuffer, dstOffset, dataSize, pData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdUpdateBuffer");
        device_dispatch->CmdUpdateBuffer(commandBuffer, dstBuffer, dstOffset, dataSize, pData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdUpdateBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdUpdateBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdUpdateBuffer(commandBuffer, dstBuffer, dstOffset, dataSize, pData, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset,
                                         VkDeviceSize size, uint32_t data) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdFillBuffer, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdFillBuffer");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdFillBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdFillBuffer(commandBuffer, dstBuffer, dstOffset, size, data, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdFillBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdFillBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdFillBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdFillBuffer(commandBuffer, dstBuffer, dstOffset, size, data, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdFillBuffer");
        device_dispatch->CmdFillBuffer(commandBuffer, dstBuffer, dstOffset, size, data);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdFillBuffer");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdFillBuffer]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdFillBuffer(commandBuffer, dstBuffer, dstOffset, size, data, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout,
                                              const VkClearColorValue* pColor, uint32_t rangeCount,
                                              const VkImageSubresourceRange* pRanges) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdClearColorImage, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdClearColorImage");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdClearColorImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdClearColorImage(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdClearColorImage);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdClearColorImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdClearColorImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdClearColorImage(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdClearColorImage");
        device_dispatch->CmdClearColorImage(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdClearColorImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdClearColorImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdClearColorImage(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout,
                                                     const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount,
                                                     const VkImageSubresourceRange* pRanges) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdClearDepthStencilImage, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdClearDepthStencilImage");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdClearDepthStencilImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdClearDepthStencilImage(commandBuffer, image, imageLayout, pDepthStencil, rangeCount,
                                                                 pRanges, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdClearDepthStencilImage);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdClearDepthStencilImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdClearDepthStencilImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdClearDepthStencilImage(commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges,
                                                       record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdClearDepthStencilImage");
        device_dispatch->CmdClearDepthStencilImage(commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdClearDepthStencilImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdClearDepthStencilImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdClearDepthStencilImage(commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges,
                                                        record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount,
                                               const VkClearAttachment* pAttachments, uint32_t rectCount,
                                               const VkClearRect* pRects) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdClearAttachments, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdClearAttachments");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdClearAttachments]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdClearAttachments(commandBuffer, attachmentCount, pAttachments, rectCount, pRects, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdClearAttachments);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdClearAttachments");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdClearAttachments]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdClearAttachments(commandBuffer, attachmentCount, pAttachments, rectCount, pRects, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdClearAttachments");
        device_dispatch->CmdClearAttachments(commandBuffer, attachmentCount, pAttachments, rectCount, pRects);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdClearAttachments");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdClearAttachments]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdClearAttachments(commandBuffer, attachmentCount, pAttachments, rectCount, pRects, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout,
                                           VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount,
                                           const VkImageResolve* pRegions) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdResolveImage, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdResolveImage");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdResolveImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdResolveImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout,
                                                       regionCount, pRegions, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdResolveImage);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdResolveImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdResolveImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdResolveImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount,
                                             pRegions, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdResolveImage");
        device_dispatch->CmdResolveImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdResolveImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdResolveImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdResolveImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount,
                                              pRegions, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetEvent, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetEvent");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetEvent(commandBuffer, event, stageMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetEvent);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetEvent");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetEvent(commandBuffer, event, stageMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetEvent");
        device_dispatch->CmdSetEvent(commandBuffer, event, stageMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetEvent");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetEvent(commandBuffer, event, stageMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdResetEvent, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdResetEvent");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdResetEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdResetEvent(commandBuffer, event, stageMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdResetEvent);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdResetEvent");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdResetEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdResetEvent(commandBuffer, event, stageMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdResetEvent");
        device_dispatch->CmdResetEvent(commandBuffer, event, stageMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdResetEvent");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdResetEvent]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdResetEvent(commandBuffer, event, stageMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents,
                                         VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask,
                                         uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers,
                                         uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers,
                                         uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWaitEvents, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdWaitEvents");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWaitEvents]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWaitEvents(
                commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers,
                bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWaitEvents);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdWaitEvents");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWaitEvents]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWaitEvents(commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount,
                                           pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers,
                                           imageMemoryBarrierCount, pImageMemoryBarriers, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdWaitEvents");
        device_dispatch->CmdWaitEvents(commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount,
                                       pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount,
                                       pImageMemoryBarriers);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdWaitEvents");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWaitEvents]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWaitEvents(commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount,
                                            pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers,
                                            imageMemoryBarrierCount, pImageMemoryBarriers, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask,
                                              VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags,
                                              uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers,
                                              uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers,
                                              uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPipelineBarrier, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdPipelineBarrier");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPipelineBarrier]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPipelineBarrier(
                commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers,
                bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPipelineBarrier);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdPipelineBarrier");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPipelineBarrier]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPipelineBarrier(commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount,
                                                pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers,
                                                imageMemoryBarrierCount, pImageMemoryBarriers, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdPipelineBarrier");
        device_dispatch->CmdPipelineBarrier(commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount,
                                            pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers,
                                            imageMemoryBarrierCount, pImageMemoryBarriers);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdPipelineBarrier");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPipelineBarrier]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPipelineBarrier(commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount,
                                                 pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers,
                                                 imageMemoryBarrierCount, pImageMemoryBarriers, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query,
                                         VkQueryControlFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginQuery, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBeginQuery");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginQuery]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginQuery(commandBuffer, queryPool, query, flags, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginQuery);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBeginQuery");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginQuery]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginQuery(commandBuffer, queryPool, query, flags, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBeginQuery");
        device_dispatch->CmdBeginQuery(commandBuffer, queryPool, query, flags);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBeginQuery");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginQuery]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginQuery(commandBuffer, queryPool, query, flags, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndQuery, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdEndQuery");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndQuery]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndQuery(commandBuffer, queryPool, query, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndQuery);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdEndQuery");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndQuery]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndQuery(commandBuffer, queryPool, query, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdEndQuery");
        device_dispatch->CmdEndQuery(commandBuffer, queryPool, query);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdEndQuery");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndQuery]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndQuery(commandBuffer, queryPool, query, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery,
                                             uint32_t queryCount) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdResetQueryPool, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdResetQueryPool");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdResetQueryPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdResetQueryPool(commandBuffer, queryPool, firstQuery, queryCount, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdResetQueryPool);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdResetQueryPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdResetQueryPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdResetQueryPool(commandBuffer, queryPool, firstQuery, queryCount, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdResetQueryPool");
        device_dispatch->CmdResetQueryPool(commandBuffer, queryPool, firstQuery, queryCount);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdResetQueryPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdResetQueryPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdResetQueryPool(commandBuffer, queryPool, firstQuery, queryCount, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage,
                                             VkQueryPool queryPool, uint32_t query) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWriteTimestamp, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdWriteTimestamp");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWriteTimestamp]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWriteTimestamp(commandBuffer, pipelineStage, queryPool, query, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWriteTimestamp);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdWriteTimestamp");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWriteTimestamp]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWriteTimestamp(commandBuffer, pipelineStage, queryPool, query, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdWriteTimestamp");
        device_dispatch->CmdWriteTimestamp(commandBuffer, pipelineStage, queryPool, query);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdWriteTimestamp");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWriteTimestamp]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWriteTimestamp(commandBuffer, pipelineStage, queryPool, query, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery,
                                                   uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset,
                                                   VkDeviceSize stride, VkQueryResultFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyQueryPoolResults, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyQueryPoolResults");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyQueryPoolResults]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyQueryPoolResults(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer,
                                                               dstOffset, stride, flags, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyQueryPoolResults);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyQueryPoolResults");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyQueryPoolResults]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyQueryPoolResults(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride,
                                                     flags, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyQueryPoolResults");
        device_dispatch->CmdCopyQueryPoolResults(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride,
                                                 flags);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyQueryPoolResults");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyQueryPoolResults]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyQueryPoolResults(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset,
                                                      stride, flags, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags,
                                            uint32_t offset, uint32_t size, const void* pValues) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushConstants, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdPushConstants");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushConstants]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushConstants(commandBuffer, layout, stageFlags, offset, size, pValues, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushConstants);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdPushConstants");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushConstants]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushConstants(commandBuffer, layout, stageFlags, offset, size, pValues, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdPushConstants");
        device_dispatch->CmdPushConstants(commandBuffer, layout, stageFlags, offset, size, pValues);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdPushConstants");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushConstants]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushConstants(commandBuffer, layout, stageFlags, offset, size, pValues, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin,
                                              VkSubpassContents contents) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginRenderPass, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBeginRenderPass");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginRenderPass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginRenderPass(commandBuffer, pRenderPassBegin, contents, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginRenderPass);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBeginRenderPass");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginRenderPass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginRenderPass(commandBuffer, pRenderPassBegin, contents, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBeginRenderPass");
        device_dispatch->CmdBeginRenderPass(commandBuffer, pRenderPassBegin, contents);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBeginRenderPass");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginRenderPass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginRenderPass(commandBuffer, pRenderPassBegin, contents, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdNextSubpass, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdNextSubpass");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdNextSubpass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdNextSubpass(commandBuffer, contents, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdNextSubpass);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdNextSubpass");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdNextSubpass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdNextSubpass(commandBuffer, contents, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdNextSubpass");
        device_dispatch->CmdNextSubpass(commandBuffer, contents);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdNextSubpass");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdNextSubpass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdNextSubpass(commandBuffer, contents, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndRenderPass(VkCommandBuffer commandBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndRenderPass, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdEndRenderPass");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndRenderPass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndRenderPass(commandBuffer, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndRenderPass);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdEndRenderPass");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndRenderPass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndRenderPass(commandBuffer, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdEndRenderPass");
        device_dispatch->CmdEndRenderPass(commandBuffer);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdEndRenderPass");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndRenderPass]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndRenderPass(commandBuffer, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount,
                                              const VkCommandBuffer* pCommandBuffers) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdExecuteCommands, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdExecuteCommands");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdExecuteCommands]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdExecuteCommands(commandBuffer, commandBufferCount, pCommandBuffers, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdExecuteCommands);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdExecuteCommands");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdExecuteCommands]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdExecuteCommands(commandBuffer, commandBufferCount, pCommandBuffers, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdExecuteCommands");
        device_dispatch->CmdExecuteCommands(commandBuffer, commandBufferCount, pCommandBuffers);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdExecuteCommands");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdExecuteCommands]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdExecuteCommands(commandBuffer, commandBufferCount, pCommandBuffers, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL BindBufferMemory2(VkDevice device, uint32_t bindInfoCount,
                                                 const VkBindBufferMemoryInfo* pBindInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindBufferMemory2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkBindBufferMemory2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindBufferMemory2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindBufferMemory2(device, bindInfoCount, pBindInfos, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindBufferMemory2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkBindBufferMemory2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindBufferMemory2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindBufferMemory2(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkBindBufferMemory2");
        result = device_dispatch->BindBufferMemory2(device, bindInfoCount, pBindInfos);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkBindBufferMemory2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindBufferMemory2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindBufferMemory2(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL BindImageMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindImageMemory2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkBindImageMemory2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindImageMemory2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindImageMemory2(device, bindInfoCount, pBindInfos, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindImageMemory2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkBindImageMemory2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindImageMemory2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindImageMemory2(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkBindImageMemory2");
        result = device_dispatch->BindImageMemory2(device, bindInfoCount, pBindInfos);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkBindImageMemory2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindImageMemory2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindImageMemory2(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex,
                                                            uint32_t remoteDeviceIndex,
                                                            VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceGroupPeerMemoryFeatures, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceGroupPeerMemoryFeatures");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceGroupPeerMemoryFeatures]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceGroupPeerMemoryFeatures(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                                        pPeerMemoryFeatures, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceGroupPeerMemoryFeatures);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceGroupPeerMemoryFeatures");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceGroupPeerMemoryFeatures]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceGroupPeerMemoryFeatures(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                              pPeerMemoryFeatures, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceGroupPeerMemoryFeatures");
        device_dispatch->GetDeviceGroupPeerMemoryFeatures(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                          pPeerMemoryFeatures);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceGroupPeerMemoryFeatures");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceGroupPeerMemoryFeatures]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceGroupPeerMemoryFeatures(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                               pPeerMemoryFeatures, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDeviceMask, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetDeviceMask");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDeviceMask]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDeviceMask(commandBuffer, deviceMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDeviceMask);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetDeviceMask");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDeviceMask]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDeviceMask(commandBuffer, deviceMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetDeviceMask");
        device_dispatch->CmdSetDeviceMask(commandBuffer, deviceMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetDeviceMask");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDeviceMask]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDeviceMask(commandBuffer, deviceMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY,
                                           uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDispatchBase, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDispatchBase");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDispatchBase]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDispatchBase(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY,
                                                       groupCountZ, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDispatchBase);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDispatchBase");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDispatchBase]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDispatchBase(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY,
                                             groupCountZ, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDispatchBase");
        device_dispatch->CmdDispatchBase(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDispatchBase");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDispatchBase]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDispatchBase(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY,
                                              groupCountZ, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL EnumeratePhysicalDeviceGroups(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount,
                                                             VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkEnumeratePhysicalDeviceGroups, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkEnumeratePhysicalDeviceGroups");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateEnumeratePhysicalDeviceGroups(instance, pPhysicalDeviceGroupCount,
                                                                     pPhysicalDeviceGroupProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkEnumeratePhysicalDeviceGroups);
    {
        VVL_ZoneScopedN("PreCallRecord_vkEnumeratePhysicalDeviceGroups");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordEnumeratePhysicalDeviceGroups(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties,
                                                           record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkEnumeratePhysicalDeviceGroups");
        result =
            instance_dispatch->EnumeratePhysicalDeviceGroups(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkEnumeratePhysicalDeviceGroups");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordEnumeratePhysicalDeviceGroups(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties,
                                                            record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo,
                                                       VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageMemoryRequirements2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetImageMemoryRequirements2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageMemoryRequirements2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageMemoryRequirements2(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageMemoryRequirements2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetImageMemoryRequirements2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageMemoryRequirements2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageMemoryRequirements2(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetImageMemoryRequirements2");
        device_dispatch->GetImageMemoryRequirements2(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetImageMemoryRequirements2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageMemoryRequirements2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageMemoryRequirements2(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo,
                                                        VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferMemoryRequirements2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetBufferMemoryRequirements2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferMemoryRequirements2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferMemoryRequirements2(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferMemoryRequirements2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetBufferMemoryRequirements2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferMemoryRequirements2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferMemoryRequirements2(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetBufferMemoryRequirements2");
        device_dispatch->GetBufferMemoryRequirements2(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetBufferMemoryRequirements2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferMemoryRequirements2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferMemoryRequirements2(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetImageSparseMemoryRequirements2(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo,
                                                             uint32_t* pSparseMemoryRequirementCount,
                                                             VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageSparseMemoryRequirements2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetImageSparseMemoryRequirements2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageSparseMemoryRequirements2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageSparseMemoryRequirements2(device, pInfo, pSparseMemoryRequirementCount,
                                                                         pSparseMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageSparseMemoryRequirements2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetImageSparseMemoryRequirements2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageSparseMemoryRequirements2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageSparseMemoryRequirements2(device, pInfo, pSparseMemoryRequirementCount,
                                                               pSparseMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetImageSparseMemoryRequirements2");
        device_dispatch->GetImageSparseMemoryRequirements2(device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetImageSparseMemoryRequirements2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageSparseMemoryRequirements2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageSparseMemoryRequirements2(device, pInfo, pSparseMemoryRequirementCount,
                                                                pSparseMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceFeatures2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceFeatures2,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceFeatures2");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceFeatures2(physicalDevice, pFeatures, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceFeatures2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceFeatures2");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceFeatures2(physicalDevice, pFeatures, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceFeatures2");
        instance_dispatch->GetPhysicalDeviceFeatures2(physicalDevice, pFeatures);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceFeatures2");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceFeatures2(physicalDevice, pFeatures, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceProperties2,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceProperties2");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceProperties2(physicalDevice, pProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceProperties2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceProperties2");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceProperties2(physicalDevice, pProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceProperties2");
        instance_dispatch->GetPhysicalDeviceProperties2(physicalDevice, pProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceProperties2");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceProperties2(physicalDevice, pProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceFormatProperties2(VkPhysicalDevice physicalDevice, VkFormat format,
                                                              VkFormatProperties2* pFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceFormatProperties2,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceFormatProperties2");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceFormatProperties2(physicalDevice, format, pFormatProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceFormatProperties2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceFormatProperties2");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceFormatProperties2(physicalDevice, format, pFormatProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceFormatProperties2");
        instance_dispatch->GetPhysicalDeviceFormatProperties2(physicalDevice, format, pFormatProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceFormatProperties2");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceFormatProperties2(physicalDevice, format, pFormatProperties, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceImageFormatProperties2(VkPhysicalDevice physicalDevice,
                                                                       const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo,
                                                                       VkImageFormatProperties2* pImageFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceImageFormatProperties2,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceImageFormatProperties2");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceImageFormatProperties2(physicalDevice, pImageFormatInfo,
                                                                               pImageFormatProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceImageFormatProperties2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceImageFormatProperties2");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceImageFormatProperties2(physicalDevice, pImageFormatInfo, pImageFormatProperties,
                                                                     record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceImageFormatProperties2");
        result =
            instance_dispatch->GetPhysicalDeviceImageFormatProperties2(physicalDevice, pImageFormatInfo, pImageFormatProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceImageFormatProperties2");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceImageFormatProperties2(physicalDevice, pImageFormatInfo, pImageFormatProperties,
                                                                      record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceQueueFamilyProperties2(VkPhysicalDevice physicalDevice,
                                                                   uint32_t* pQueueFamilyPropertyCount,
                                                                   VkQueueFamilyProperties2* pQueueFamilyProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyProperties2,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceQueueFamilyProperties2");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceQueueFamilyProperties2(physicalDevice, pQueueFamilyPropertyCount,
                                                                               pQueueFamilyProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyProperties2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceQueueFamilyProperties2");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceQueueFamilyProperties2(physicalDevice, pQueueFamilyPropertyCount,
                                                                     pQueueFamilyProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceQueueFamilyProperties2");
        instance_dispatch->GetPhysicalDeviceQueueFamilyProperties2(physicalDevice, pQueueFamilyPropertyCount,
                                                                   pQueueFamilyProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceQueueFamilyProperties2");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceQueueFamilyProperties2(physicalDevice, pQueueFamilyPropertyCount,
                                                                      pQueueFamilyProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceMemoryProperties2(VkPhysicalDevice physicalDevice,
                                                              VkPhysicalDeviceMemoryProperties2* pMemoryProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceMemoryProperties2,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceMemoryProperties2");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceMemoryProperties2(physicalDevice, pMemoryProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceMemoryProperties2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceMemoryProperties2");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceMemoryProperties2(physicalDevice, pMemoryProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceMemoryProperties2");
        instance_dispatch->GetPhysicalDeviceMemoryProperties2(physicalDevice, pMemoryProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceMemoryProperties2");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceMemoryProperties2(physicalDevice, pMemoryProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceSparseImageFormatProperties2(VkPhysicalDevice physicalDevice,
                                                                         const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo,
                                                                         uint32_t* pPropertyCount,
                                                                         VkSparseImageFormatProperties2* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSparseImageFormatProperties2,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceSparseImageFormatProperties2");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceSparseImageFormatProperties2(physicalDevice, pFormatInfo, pPropertyCount,
                                                                                     pProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSparseImageFormatProperties2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceSparseImageFormatProperties2");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceSparseImageFormatProperties2(physicalDevice, pFormatInfo, pPropertyCount, pProperties,
                                                                           record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceSparseImageFormatProperties2");
        instance_dispatch->GetPhysicalDeviceSparseImageFormatProperties2(physicalDevice, pFormatInfo, pPropertyCount, pProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceSparseImageFormatProperties2");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceSparseImageFormatProperties2(physicalDevice, pFormatInfo, pPropertyCount,
                                                                            pProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL TrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkTrimCommandPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkTrimCommandPool");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateTrimCommandPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateTrimCommandPool(device, commandPool, flags, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkTrimCommandPool);
    {
        VVL_ZoneScopedN("PreCallRecord_vkTrimCommandPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordTrimCommandPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordTrimCommandPool(device, commandPool, flags, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkTrimCommandPool");
        device_dispatch->TrimCommandPool(device, commandPool, flags);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkTrimCommandPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordTrimCommandPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordTrimCommandPool(device, commandPool, flags, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceQueue2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceQueue2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceQueue2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceQueue2(device, pQueueInfo, pQueue, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceQueue2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceQueue2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceQueue2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceQueue2(device, pQueueInfo, pQueue, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceQueue2");
        device_dispatch->GetDeviceQueue2(device, pQueueInfo, pQueue);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceQueue2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceQueue2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceQueue2(device, pQueueInfo, pQueue, record_obj);
        }
    }
#if defined(VVL_TRACY_GPU)
    TracyVkCollector::Create(device, *pQueue, pQueueInfo->queueFamilyIndex);
#endif
}

VKAPI_ATTR VkResult VKAPI_CALL CreateSamplerYcbcrConversion(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo,
                                                            const VkAllocationCallbacks* pAllocator,
                                                            VkSamplerYcbcrConversion* pYcbcrConversion) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateSamplerYcbcrConversion, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateSamplerYcbcrConversion");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateSamplerYcbcrConversion]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateSamplerYcbcrConversion(device, pCreateInfo, pAllocator, pYcbcrConversion, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateSamplerYcbcrConversion);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateSamplerYcbcrConversion");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateSamplerYcbcrConversion]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateSamplerYcbcrConversion(device, pCreateInfo, pAllocator, pYcbcrConversion, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateSamplerYcbcrConversion");
        result = device_dispatch->CreateSamplerYcbcrConversion(device, pCreateInfo, pAllocator, pYcbcrConversion);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateSamplerYcbcrConversion");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateSamplerYcbcrConversion]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateSamplerYcbcrConversion(device, pCreateInfo, pAllocator, pYcbcrConversion, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion,
                                                         const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroySamplerYcbcrConversion, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroySamplerYcbcrConversion");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroySamplerYcbcrConversion]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroySamplerYcbcrConversion(device, ycbcrConversion, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroySamplerYcbcrConversion);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroySamplerYcbcrConversion");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroySamplerYcbcrConversion]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroySamplerYcbcrConversion(device, ycbcrConversion, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroySamplerYcbcrConversion");
        device_dispatch->DestroySamplerYcbcrConversion(device, ycbcrConversion, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroySamplerYcbcrConversion");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroySamplerYcbcrConversion]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroySamplerYcbcrConversion(device, ycbcrConversion, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDescriptorUpdateTemplate(VkDevice device,
                                                              const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo,
                                                              const VkAllocationCallbacks* pAllocator,
                                                              VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDescriptorUpdateTemplate, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateDescriptorUpdateTemplate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateDescriptorUpdateTemplate]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDescriptorUpdateTemplate(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate,
                                                                      error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDescriptorUpdateTemplate);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateDescriptorUpdateTemplate");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateDescriptorUpdateTemplate]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDescriptorUpdateTemplate(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateDescriptorUpdateTemplate");
        result = device_dispatch->CreateDescriptorUpdateTemplate(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateDescriptorUpdateTemplate");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateDescriptorUpdateTemplate]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDescriptorUpdateTemplate(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate,
                                                             record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyDescriptorUpdateTemplate(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                                           const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyDescriptorUpdateTemplate, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyDescriptorUpdateTemplate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyDescriptorUpdateTemplate]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyDescriptorUpdateTemplate(device, descriptorUpdateTemplate, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyDescriptorUpdateTemplate);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyDescriptorUpdateTemplate");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyDescriptorUpdateTemplate]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyDescriptorUpdateTemplate(device, descriptorUpdateTemplate, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyDescriptorUpdateTemplate");
        device_dispatch->DestroyDescriptorUpdateTemplate(device, descriptorUpdateTemplate, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyDescriptorUpdateTemplate");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyDescriptorUpdateTemplate]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyDescriptorUpdateTemplate(device, descriptorUpdateTemplate, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL UpdateDescriptorSetWithTemplate(VkDevice device, VkDescriptorSet descriptorSet,
                                                           VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUpdateDescriptorSetWithTemplate, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkUpdateDescriptorSetWithTemplate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUpdateDescriptorSetWithTemplate]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUpdateDescriptorSetWithTemplate(device, descriptorSet, descriptorUpdateTemplate, pData,
                                                                       error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkUpdateDescriptorSetWithTemplate);
    {
        VVL_ZoneScopedN("PreCallRecord_vkUpdateDescriptorSetWithTemplate");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUpdateDescriptorSetWithTemplate]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordUpdateDescriptorSetWithTemplate(device, descriptorSet, descriptorUpdateTemplate, pData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkUpdateDescriptorSetWithTemplate");
        device_dispatch->UpdateDescriptorSetWithTemplate(device, descriptorSet, descriptorUpdateTemplate, pData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkUpdateDescriptorSetWithTemplate");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUpdateDescriptorSetWithTemplate]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordUpdateDescriptorSetWithTemplate(device, descriptorSet, descriptorUpdateTemplate, pData, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceExternalBufferProperties(VkPhysicalDevice physicalDevice,
                                                                     const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo,
                                                                     VkExternalBufferProperties* pExternalBufferProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceExternalBufferProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceExternalBufferProperties");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceExternalBufferProperties(physicalDevice, pExternalBufferInfo,
                                                                                 pExternalBufferProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceExternalBufferProperties);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceExternalBufferProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceExternalBufferProperties(physicalDevice, pExternalBufferInfo,
                                                                       pExternalBufferProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceExternalBufferProperties");
        instance_dispatch->GetPhysicalDeviceExternalBufferProperties(physicalDevice, pExternalBufferInfo,
                                                                     pExternalBufferProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceExternalBufferProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceExternalBufferProperties(physicalDevice, pExternalBufferInfo,
                                                                        pExternalBufferProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceExternalFenceProperties(VkPhysicalDevice physicalDevice,
                                                                    const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo,
                                                                    VkExternalFenceProperties* pExternalFenceProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceExternalFenceProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceExternalFenceProperties");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceExternalFenceProperties(physicalDevice, pExternalFenceInfo,
                                                                                pExternalFenceProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceExternalFenceProperties);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceExternalFenceProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceExternalFenceProperties(physicalDevice, pExternalFenceInfo, pExternalFenceProperties,
                                                                      record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceExternalFenceProperties");
        instance_dispatch->GetPhysicalDeviceExternalFenceProperties(physicalDevice, pExternalFenceInfo, pExternalFenceProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceExternalFenceProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceExternalFenceProperties(physicalDevice, pExternalFenceInfo, pExternalFenceProperties,
                                                                       record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceExternalSemaphoreProperties(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo,
    VkExternalSemaphoreProperties* pExternalSemaphoreProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceExternalSemaphoreProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceExternalSemaphoreProperties");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceExternalSemaphoreProperties(physicalDevice, pExternalSemaphoreInfo,
                                                                                    pExternalSemaphoreProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceExternalSemaphoreProperties);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceExternalSemaphoreProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceExternalSemaphoreProperties(physicalDevice, pExternalSemaphoreInfo,
                                                                          pExternalSemaphoreProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceExternalSemaphoreProperties");
        instance_dispatch->GetPhysicalDeviceExternalSemaphoreProperties(physicalDevice, pExternalSemaphoreInfo,
                                                                        pExternalSemaphoreProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceExternalSemaphoreProperties");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceExternalSemaphoreProperties(physicalDevice, pExternalSemaphoreInfo,
                                                                           pExternalSemaphoreProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDescriptorSetLayoutSupport(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
                                                         VkDescriptorSetLayoutSupport* pSupport) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDescriptorSetLayoutSupport, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDescriptorSetLayoutSupport");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDescriptorSetLayoutSupport]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDescriptorSetLayoutSupport(device, pCreateInfo, pSupport, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDescriptorSetLayoutSupport);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDescriptorSetLayoutSupport");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDescriptorSetLayoutSupport]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDescriptorSetLayoutSupport(device, pCreateInfo, pSupport, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDescriptorSetLayoutSupport");
        device_dispatch->GetDescriptorSetLayoutSupport(device, pCreateInfo, pSupport);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDescriptorSetLayoutSupport");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDescriptorSetLayoutSupport]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDescriptorSetLayoutSupport(device, pCreateInfo, pSupport, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount,
                                                uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndirectCount, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDrawIndirectCount");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndirectCount]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                            maxDrawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndirectCount);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDrawIndirectCount");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndirectCount]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                  stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDrawIndirectCount");
        device_dispatch->CmdDrawIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDrawIndirectCount");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndirectCount]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                   stride, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                       VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount,
                                                       uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndexedIndirectCount,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDrawIndexedIndirectCount");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndexedIndirectCount]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndexedIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                                   maxDrawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndexedIndirectCount);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDrawIndexedIndirectCount");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndexedIndirectCount]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndexedIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                         maxDrawCount, stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDrawIndexedIndirectCount");
        device_dispatch->CmdDrawIndexedIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                     stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDrawIndexedIndirectCount");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndexedIndirectCount]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndexedIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                          maxDrawCount, stride, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateRenderPass2(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo,
                                                 const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateRenderPass2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateRenderPass2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateRenderPass2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateRenderPass2(device, pCreateInfo, pAllocator, pRenderPass, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateRenderPass2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateRenderPass2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateRenderPass2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateRenderPass2(device, pCreateInfo, pAllocator, pRenderPass, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateRenderPass2");
        result = device_dispatch->CreateRenderPass2(device, pCreateInfo, pAllocator, pRenderPass);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateRenderPass2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateRenderPass2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateRenderPass2(device, pCreateInfo, pAllocator, pRenderPass, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdBeginRenderPass2(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin,
                                               const VkSubpassBeginInfo* pSubpassBeginInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginRenderPass2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBeginRenderPass2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginRenderPass2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginRenderPass2(commandBuffer, pRenderPassBegin, pSubpassBeginInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginRenderPass2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBeginRenderPass2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginRenderPass2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginRenderPass2(commandBuffer, pRenderPassBegin, pSubpassBeginInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBeginRenderPass2");
        device_dispatch->CmdBeginRenderPass2(commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBeginRenderPass2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginRenderPass2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginRenderPass2(commandBuffer, pRenderPassBegin, pSubpassBeginInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdNextSubpass2(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo,
                                           const VkSubpassEndInfo* pSubpassEndInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdNextSubpass2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdNextSubpass2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdNextSubpass2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdNextSubpass2(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdNextSubpass2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdNextSubpass2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdNextSubpass2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdNextSubpass2(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdNextSubpass2");
        device_dispatch->CmdNextSubpass2(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdNextSubpass2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdNextSubpass2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdNextSubpass2(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndRenderPass2(VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndRenderPass2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdEndRenderPass2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndRenderPass2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndRenderPass2(commandBuffer, pSubpassEndInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndRenderPass2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdEndRenderPass2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndRenderPass2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndRenderPass2(commandBuffer, pSubpassEndInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdEndRenderPass2");
        device_dispatch->CmdEndRenderPass2(commandBuffer, pSubpassEndInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdEndRenderPass2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndRenderPass2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndRenderPass2(commandBuffer, pSubpassEndInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL ResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkResetQueryPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkResetQueryPool");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateResetQueryPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateResetQueryPool(device, queryPool, firstQuery, queryCount, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkResetQueryPool);
    {
        VVL_ZoneScopedN("PreCallRecord_vkResetQueryPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordResetQueryPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordResetQueryPool(device, queryPool, firstQuery, queryCount, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkResetQueryPool");
        device_dispatch->ResetQueryPool(device, queryPool, firstQuery, queryCount);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkResetQueryPool");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordResetQueryPool]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordResetQueryPool(device, queryPool, firstQuery, queryCount, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetSemaphoreCounterValue(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSemaphoreCounterValue, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetSemaphoreCounterValue");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSemaphoreCounterValue]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSemaphoreCounterValue(device, semaphore, pValue, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSemaphoreCounterValue);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetSemaphoreCounterValue");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSemaphoreCounterValue]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSemaphoreCounterValue(device, semaphore, pValue, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetSemaphoreCounterValue");
        result = device_dispatch->GetSemaphoreCounterValue(device, semaphore, pValue);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetSemaphoreCounterValue");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSemaphoreCounterValue]) {
            if (!vo) {
                continue;
            }
            vvl::base::Device::BlockingOperationGuard lock(vo);
            vo->PostCallRecordGetSemaphoreCounterValue(device, semaphore, pValue, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL WaitSemaphores(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkWaitSemaphores, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkWaitSemaphores");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateWaitSemaphores]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateWaitSemaphores(device, pWaitInfo, timeout, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkWaitSemaphores);
    {
        VVL_ZoneScopedN("PreCallRecord_vkWaitSemaphores");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordWaitSemaphores]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordWaitSemaphores(device, pWaitInfo, timeout, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkWaitSemaphores");
        result = device_dispatch->WaitSemaphores(device, pWaitInfo, timeout);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkWaitSemaphores");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordWaitSemaphores]) {
            if (!vo) {
                continue;
            }
            vvl::base::Device::BlockingOperationGuard lock(vo);
            vo->PostCallRecordWaitSemaphores(device, pWaitInfo, timeout, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL SignalSemaphore(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSignalSemaphore, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkSignalSemaphore");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSignalSemaphore]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSignalSemaphore(device, pSignalInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkSignalSemaphore);
    {
        VVL_ZoneScopedN("PreCallRecord_vkSignalSemaphore");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSignalSemaphore]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordSignalSemaphore(device, pSignalInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkSignalSemaphore");
        result = device_dispatch->SignalSemaphore(device, pSignalInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkSignalSemaphore");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSignalSemaphore]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordSignalSemaphore(device, pSignalInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkDeviceAddress VKAPI_CALL GetBufferDeviceAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferDeviceAddress, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetBufferDeviceAddress");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferDeviceAddress]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferDeviceAddress(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferDeviceAddress);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetBufferDeviceAddress");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferDeviceAddress]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferDeviceAddress(device, pInfo, record_obj);
        }
    }
    VkDeviceAddress result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetBufferDeviceAddress");
        result = device_dispatch->GetBufferDeviceAddress(device, pInfo);
    }
    record_obj.device_address = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetBufferDeviceAddress");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferDeviceAddress]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferDeviceAddress(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR uint64_t VKAPI_CALL GetBufferOpaqueCaptureAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferOpaqueCaptureAddress, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetBufferOpaqueCaptureAddress");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferOpaqueCaptureAddress]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferOpaqueCaptureAddress(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferOpaqueCaptureAddress);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetBufferOpaqueCaptureAddress");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferOpaqueCaptureAddress]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferOpaqueCaptureAddress(device, pInfo, record_obj);
        }
    }
    uint64_t result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetBufferOpaqueCaptureAddress");
        result = device_dispatch->GetBufferOpaqueCaptureAddress(device, pInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetBufferOpaqueCaptureAddress");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferOpaqueCaptureAddress]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferOpaqueCaptureAddress(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR uint64_t VKAPI_CALL GetDeviceMemoryOpaqueCaptureAddress(VkDevice device,
                                                                   const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceMemoryOpaqueCaptureAddress, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceMemoryOpaqueCaptureAddress");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceMemoryOpaqueCaptureAddress]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceMemoryOpaqueCaptureAddress(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceMemoryOpaqueCaptureAddress);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceMemoryOpaqueCaptureAddress");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceMemoryOpaqueCaptureAddress]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceMemoryOpaqueCaptureAddress(device, pInfo, record_obj);
        }
    }
    uint64_t result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceMemoryOpaqueCaptureAddress");
        result = device_dispatch->GetDeviceMemoryOpaqueCaptureAddress(device, pInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceMemoryOpaqueCaptureAddress");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceMemoryOpaqueCaptureAddress]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceMemoryOpaqueCaptureAddress(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreatePrivateDataSlot(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo,
                                                     const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreatePrivateDataSlot, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreatePrivateDataSlot");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreatePrivateDataSlot]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreatePrivateDataSlot(device, pCreateInfo, pAllocator, pPrivateDataSlot, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreatePrivateDataSlot);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreatePrivateDataSlot");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreatePrivateDataSlot]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreatePrivateDataSlot(device, pCreateInfo, pAllocator, pPrivateDataSlot, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreatePrivateDataSlot");
        result = device_dispatch->CreatePrivateDataSlot(device, pCreateInfo, pAllocator, pPrivateDataSlot);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreatePrivateDataSlot");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreatePrivateDataSlot]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreatePrivateDataSlot(device, pCreateInfo, pAllocator, pPrivateDataSlot, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyPrivateDataSlot(VkDevice device, VkPrivateDataSlot privateDataSlot,
                                                  const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyPrivateDataSlot, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyPrivateDataSlot");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyPrivateDataSlot]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyPrivateDataSlot(device, privateDataSlot, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyPrivateDataSlot);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyPrivateDataSlot");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyPrivateDataSlot]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyPrivateDataSlot(device, privateDataSlot, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyPrivateDataSlot");
        device_dispatch->DestroyPrivateDataSlot(device, privateDataSlot, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyPrivateDataSlot");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyPrivateDataSlot]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyPrivateDataSlot(device, privateDataSlot, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL SetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle,
                                              VkPrivateDataSlot privateDataSlot, uint64_t data) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSetPrivateData, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkSetPrivateData");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSetPrivateData]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSetPrivateData(device, objectType, objectHandle, privateDataSlot, data, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkSetPrivateData);
    {
        VVL_ZoneScopedN("PreCallRecord_vkSetPrivateData");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSetPrivateData]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordSetPrivateData(device, objectType, objectHandle, privateDataSlot, data, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkSetPrivateData");
        result = device_dispatch->SetPrivateData(device, objectType, objectHandle, privateDataSlot, data);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkSetPrivateData");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSetPrivateData]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordSetPrivateData(device, objectType, objectHandle, privateDataSlot, data, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle,
                                          VkPrivateDataSlot privateDataSlot, uint64_t* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPrivateData, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPrivateData");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPrivateData]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPrivateData(device, objectType, objectHandle, privateDataSlot, pData, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPrivateData);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPrivateData");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPrivateData]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPrivateData(device, objectType, objectHandle, privateDataSlot, pData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPrivateData");
        device_dispatch->GetPrivateData(device, objectType, objectHandle, privateDataSlot, pData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPrivateData");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPrivateData]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPrivateData(device, objectType, objectHandle, privateDataSlot, pData, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetEvent2(VkCommandBuffer commandBuffer, VkEvent event, const VkDependencyInfo* pDependencyInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetEvent2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetEvent2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetEvent2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetEvent2(commandBuffer, event, pDependencyInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetEvent2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetEvent2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetEvent2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetEvent2(commandBuffer, event, pDependencyInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetEvent2");
        device_dispatch->CmdSetEvent2(commandBuffer, event, pDependencyInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetEvent2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetEvent2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetEvent2(commandBuffer, event, pDependencyInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdResetEvent2(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags2 stageMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdResetEvent2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdResetEvent2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdResetEvent2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdResetEvent2(commandBuffer, event, stageMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdResetEvent2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdResetEvent2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdResetEvent2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdResetEvent2(commandBuffer, event, stageMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdResetEvent2");
        device_dispatch->CmdResetEvent2(commandBuffer, event, stageMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdResetEvent2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdResetEvent2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdResetEvent2(commandBuffer, event, stageMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdWaitEvents2(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents,
                                          const VkDependencyInfo* pDependencyInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWaitEvents2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdWaitEvents2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWaitEvents2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWaitEvents2(commandBuffer, eventCount, pEvents, pDependencyInfos, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWaitEvents2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdWaitEvents2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWaitEvents2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWaitEvents2(commandBuffer, eventCount, pEvents, pDependencyInfos, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdWaitEvents2");
        device_dispatch->CmdWaitEvents2(commandBuffer, eventCount, pEvents, pDependencyInfos);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdWaitEvents2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWaitEvents2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWaitEvents2(commandBuffer, eventCount, pEvents, pDependencyInfos, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPipelineBarrier2(VkCommandBuffer commandBuffer, const VkDependencyInfo* pDependencyInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPipelineBarrier2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdPipelineBarrier2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPipelineBarrier2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPipelineBarrier2(commandBuffer, pDependencyInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPipelineBarrier2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdPipelineBarrier2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPipelineBarrier2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPipelineBarrier2(commandBuffer, pDependencyInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdPipelineBarrier2");
        device_dispatch->CmdPipelineBarrier2(commandBuffer, pDependencyInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdPipelineBarrier2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPipelineBarrier2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPipelineBarrier2(commandBuffer, pDependencyInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdWriteTimestamp2(VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkQueryPool queryPool,
                                              uint32_t query) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWriteTimestamp2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdWriteTimestamp2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWriteTimestamp2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWriteTimestamp2(commandBuffer, stage, queryPool, query, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWriteTimestamp2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdWriteTimestamp2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWriteTimestamp2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWriteTimestamp2(commandBuffer, stage, queryPool, query, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdWriteTimestamp2");
        device_dispatch->CmdWriteTimestamp2(commandBuffer, stage, queryPool, query);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdWriteTimestamp2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWriteTimestamp2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWriteTimestamp2(commandBuffer, stage, queryPool, query, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL QueueSubmit2(VkQueue queue, uint32_t submitCount, const VkSubmitInfo2* pSubmits, VkFence fence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueSubmit2, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate_vkQueueSubmit2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueSubmit2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueSubmit2(queue, submitCount, pSubmits, fence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueSubmit2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkQueueSubmit2");
        VVL_TracyVkNamedZoneStart(GetTracyVkCtx(), queue, "gpu_PreCallRecordvkQueueSubmit2", pre_call_record_gpu_zone);

        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueSubmit2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueSubmit2(queue, submitCount, pSubmits, fence, record_obj);
        }

        VVL_TracyVkNamedZoneEnd(pre_call_record_gpu_zone, queue);
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkQueueSubmit2");

        VVL_TracyVkNamedZoneStart(GetTracyVkCtx(), queue, "gpu_vkQueueSubmit2", submit_gpu_zone);
        result = device_dispatch->QueueSubmit2(queue, submitCount, pSubmits, fence);

        VVL_TracyVkNamedZoneEnd(submit_gpu_zone, queue);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkQueueSubmit2");

        VVL_TracyVkNamedZoneStart(GetTracyVkCtx(), queue, "gpu_PostCallRecordvkQueueSubmit2", post_call_record_gpu_zone);

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueSubmit2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordQueueSubmit2(queue, submitCount, pSubmits, fence, record_obj);
        }

        VVL_TracyVkNamedZoneEnd(post_call_record_gpu_zone, queue);
    }
#if defined(VVL_TRACY_GPU)
    TracyVkCollector::TrySubmitCollectCb(queue);
#endif
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdCopyBuffer2(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyBuffer2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyBuffer2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyBuffer2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyBuffer2(commandBuffer, pCopyBufferInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyBuffer2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyBuffer2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyBuffer2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyBuffer2(commandBuffer, pCopyBufferInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyBuffer2");
        device_dispatch->CmdCopyBuffer2(commandBuffer, pCopyBufferInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyBuffer2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyBuffer2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyBuffer2(commandBuffer, pCopyBufferInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyImage2(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyImage2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyImage2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyImage2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyImage2(commandBuffer, pCopyImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyImage2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyImage2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyImage2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyImage2(commandBuffer, pCopyImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyImage2");
        device_dispatch->CmdCopyImage2(commandBuffer, pCopyImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyImage2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyImage2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyImage2(commandBuffer, pCopyImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyBufferToImage2(VkCommandBuffer commandBuffer,
                                                 const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyBufferToImage2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyBufferToImage2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyBufferToImage2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyBufferToImage2(commandBuffer, pCopyBufferToImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyBufferToImage2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyBufferToImage2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyBufferToImage2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyBufferToImage2(commandBuffer, pCopyBufferToImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyBufferToImage2");
        device_dispatch->CmdCopyBufferToImage2(commandBuffer, pCopyBufferToImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyBufferToImage2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyBufferToImage2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyBufferToImage2(commandBuffer, pCopyBufferToImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyImageToBuffer2(VkCommandBuffer commandBuffer,
                                                 const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyImageToBuffer2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyImageToBuffer2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyImageToBuffer2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyImageToBuffer2(commandBuffer, pCopyImageToBufferInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyImageToBuffer2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyImageToBuffer2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyImageToBuffer2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyImageToBuffer2(commandBuffer, pCopyImageToBufferInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyImageToBuffer2");
        device_dispatch->CmdCopyImageToBuffer2(commandBuffer, pCopyImageToBufferInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyImageToBuffer2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyImageToBuffer2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyImageToBuffer2(commandBuffer, pCopyImageToBufferInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBlitImage2(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBlitImage2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBlitImage2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBlitImage2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBlitImage2(commandBuffer, pBlitImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBlitImage2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBlitImage2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBlitImage2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBlitImage2(commandBuffer, pBlitImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBlitImage2");
        device_dispatch->CmdBlitImage2(commandBuffer, pBlitImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBlitImage2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBlitImage2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBlitImage2(commandBuffer, pBlitImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdResolveImage2(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdResolveImage2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdResolveImage2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdResolveImage2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdResolveImage2(commandBuffer, pResolveImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdResolveImage2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdResolveImage2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdResolveImage2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdResolveImage2(commandBuffer, pResolveImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdResolveImage2");
        device_dispatch->CmdResolveImage2(commandBuffer, pResolveImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdResolveImage2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdResolveImage2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdResolveImage2(commandBuffer, pResolveImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginRendering(VkCommandBuffer commandBuffer, const VkRenderingInfo* pRenderingInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginRendering, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBeginRendering");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginRendering]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginRendering(commandBuffer, pRenderingInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginRendering);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBeginRendering");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginRendering]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginRendering(commandBuffer, pRenderingInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBeginRendering");
        device_dispatch->CmdBeginRendering(commandBuffer, pRenderingInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBeginRendering");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginRendering]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginRendering(commandBuffer, pRenderingInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndRendering(VkCommandBuffer commandBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndRendering, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdEndRendering");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndRendering]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndRendering(commandBuffer, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndRendering);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdEndRendering");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndRendering]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndRendering(commandBuffer, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdEndRendering");
        device_dispatch->CmdEndRendering(commandBuffer);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdEndRendering");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndRendering]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndRendering(commandBuffer, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetCullMode(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetCullMode, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetCullMode");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetCullMode]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetCullMode(commandBuffer, cullMode, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetCullMode);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetCullMode");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetCullMode]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetCullMode(commandBuffer, cullMode, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetCullMode");
        device_dispatch->CmdSetCullMode(commandBuffer, cullMode);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetCullMode");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetCullMode]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetCullMode(commandBuffer, cullMode, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetFrontFace(VkCommandBuffer commandBuffer, VkFrontFace frontFace) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetFrontFace, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetFrontFace");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetFrontFace]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetFrontFace(commandBuffer, frontFace, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetFrontFace);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetFrontFace");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetFrontFace]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetFrontFace(commandBuffer, frontFace, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetFrontFace");
        device_dispatch->CmdSetFrontFace(commandBuffer, frontFace);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetFrontFace");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetFrontFace]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetFrontFace(commandBuffer, frontFace, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetPrimitiveTopology(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetPrimitiveTopology, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetPrimitiveTopology");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetPrimitiveTopology]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetPrimitiveTopology(commandBuffer, primitiveTopology, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetPrimitiveTopology);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetPrimitiveTopology");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetPrimitiveTopology]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetPrimitiveTopology(commandBuffer, primitiveTopology, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetPrimitiveTopology");
        device_dispatch->CmdSetPrimitiveTopology(commandBuffer, primitiveTopology);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetPrimitiveTopology");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetPrimitiveTopology]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetPrimitiveTopology(commandBuffer, primitiveTopology, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetViewportWithCount(VkCommandBuffer commandBuffer, uint32_t viewportCount,
                                                   const VkViewport* pViewports) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetViewportWithCount, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetViewportWithCount");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetViewportWithCount]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetViewportWithCount(commandBuffer, viewportCount, pViewports, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetViewportWithCount);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetViewportWithCount");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetViewportWithCount]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetViewportWithCount(commandBuffer, viewportCount, pViewports, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetViewportWithCount");
        device_dispatch->CmdSetViewportWithCount(commandBuffer, viewportCount, pViewports);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetViewportWithCount");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetViewportWithCount]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetViewportWithCount(commandBuffer, viewportCount, pViewports, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetScissorWithCount(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetScissorWithCount, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetScissorWithCount");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetScissorWithCount]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetScissorWithCount(commandBuffer, scissorCount, pScissors, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetScissorWithCount);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetScissorWithCount");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetScissorWithCount]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetScissorWithCount(commandBuffer, scissorCount, pScissors, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetScissorWithCount");
        device_dispatch->CmdSetScissorWithCount(commandBuffer, scissorCount, pScissors);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetScissorWithCount");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetScissorWithCount]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetScissorWithCount(commandBuffer, scissorCount, pScissors, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindVertexBuffers2(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount,
                                                 const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes,
                                                 const VkDeviceSize* pStrides) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindVertexBuffers2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBindVertexBuffers2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindVertexBuffers2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindVertexBuffers2(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes,
                                                             pStrides, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindVertexBuffers2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBindVertexBuffers2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindVertexBuffers2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindVertexBuffers2(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides,
                                                   record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBindVertexBuffers2");
        device_dispatch->CmdBindVertexBuffers2(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBindVertexBuffers2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindVertexBuffers2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindVertexBuffers2(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides,
                                                    record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthTestEnable, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetDepthTestEnable");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthTestEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthTestEnable(commandBuffer, depthTestEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthTestEnable);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetDepthTestEnable");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthTestEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthTestEnable(commandBuffer, depthTestEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetDepthTestEnable");
        device_dispatch->CmdSetDepthTestEnable(commandBuffer, depthTestEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetDepthTestEnable");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthTestEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthTestEnable(commandBuffer, depthTestEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthWriteEnable(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthWriteEnable, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetDepthWriteEnable");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthWriteEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthWriteEnable(commandBuffer, depthWriteEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthWriteEnable);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetDepthWriteEnable");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthWriteEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthWriteEnable(commandBuffer, depthWriteEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetDepthWriteEnable");
        device_dispatch->CmdSetDepthWriteEnable(commandBuffer, depthWriteEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetDepthWriteEnable");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthWriteEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthWriteEnable(commandBuffer, depthWriteEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthCompareOp(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthCompareOp, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetDepthCompareOp");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthCompareOp]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthCompareOp(commandBuffer, depthCompareOp, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthCompareOp);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetDepthCompareOp");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthCompareOp]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthCompareOp(commandBuffer, depthCompareOp, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetDepthCompareOp");
        device_dispatch->CmdSetDepthCompareOp(commandBuffer, depthCompareOp);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetDepthCompareOp");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthCompareOp]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthCompareOp(commandBuffer, depthCompareOp, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthBoundsTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthBoundsTestEnable,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetDepthBoundsTestEnable");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthBoundsTestEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthBoundsTestEnable(commandBuffer, depthBoundsTestEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthBoundsTestEnable);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetDepthBoundsTestEnable");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthBoundsTestEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthBoundsTestEnable(commandBuffer, depthBoundsTestEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetDepthBoundsTestEnable");
        device_dispatch->CmdSetDepthBoundsTestEnable(commandBuffer, depthBoundsTestEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetDepthBoundsTestEnable");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthBoundsTestEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthBoundsTestEnable(commandBuffer, depthBoundsTestEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetStencilTestEnable(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetStencilTestEnable, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetStencilTestEnable");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetStencilTestEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetStencilTestEnable(commandBuffer, stencilTestEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetStencilTestEnable);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetStencilTestEnable");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetStencilTestEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetStencilTestEnable(commandBuffer, stencilTestEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetStencilTestEnable");
        device_dispatch->CmdSetStencilTestEnable(commandBuffer, stencilTestEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetStencilTestEnable");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetStencilTestEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetStencilTestEnable(commandBuffer, stencilTestEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetStencilOp(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp,
                                           VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetStencilOp, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetStencilOp");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetStencilOp]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetStencilOp(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetStencilOp);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetStencilOp");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetStencilOp]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetStencilOp(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetStencilOp");
        device_dispatch->CmdSetStencilOp(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetStencilOp");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetStencilOp]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetStencilOp(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetRasterizerDiscardEnable(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetRasterizerDiscardEnable,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetRasterizerDiscardEnable");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetRasterizerDiscardEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetRasterizerDiscardEnable(commandBuffer, rasterizerDiscardEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetRasterizerDiscardEnable);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetRasterizerDiscardEnable");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetRasterizerDiscardEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetRasterizerDiscardEnable(commandBuffer, rasterizerDiscardEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetRasterizerDiscardEnable");
        device_dispatch->CmdSetRasterizerDiscardEnable(commandBuffer, rasterizerDiscardEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetRasterizerDiscardEnable");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetRasterizerDiscardEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetRasterizerDiscardEnable(commandBuffer, rasterizerDiscardEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthBiasEnable(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthBiasEnable, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetDepthBiasEnable");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthBiasEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthBiasEnable(commandBuffer, depthBiasEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthBiasEnable);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetDepthBiasEnable");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthBiasEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthBiasEnable(commandBuffer, depthBiasEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetDepthBiasEnable");
        device_dispatch->CmdSetDepthBiasEnable(commandBuffer, depthBiasEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetDepthBiasEnable");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthBiasEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthBiasEnable(commandBuffer, depthBiasEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetPrimitiveRestartEnable(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetPrimitiveRestartEnable,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetPrimitiveRestartEnable");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetPrimitiveRestartEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetPrimitiveRestartEnable(commandBuffer, primitiveRestartEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetPrimitiveRestartEnable);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetPrimitiveRestartEnable");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetPrimitiveRestartEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetPrimitiveRestartEnable(commandBuffer, primitiveRestartEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetPrimitiveRestartEnable");
        device_dispatch->CmdSetPrimitiveRestartEnable(commandBuffer, primitiveRestartEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetPrimitiveRestartEnable");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetPrimitiveRestartEnable]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetPrimitiveRestartEnable(commandBuffer, primitiveRestartEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceBufferMemoryRequirements(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo,
                                                             VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceBufferMemoryRequirements, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceBufferMemoryRequirements");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceBufferMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceBufferMemoryRequirements(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceBufferMemoryRequirements);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceBufferMemoryRequirements");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceBufferMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceBufferMemoryRequirements(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceBufferMemoryRequirements");
        device_dispatch->GetDeviceBufferMemoryRequirements(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceBufferMemoryRequirements");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceBufferMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceBufferMemoryRequirements(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceImageMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo,
                                                            VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceImageMemoryRequirements, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceImageMemoryRequirements");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceImageMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceImageMemoryRequirements(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceImageMemoryRequirements);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceImageMemoryRequirements");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceImageMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceImageMemoryRequirements(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceImageMemoryRequirements");
        device_dispatch->GetDeviceImageMemoryRequirements(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceImageMemoryRequirements");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceImageMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceImageMemoryRequirements(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceImageSparseMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo,
                                                                  uint32_t* pSparseMemoryRequirementCount,
                                                                  VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceImageSparseMemoryRequirements, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceImageSparseMemoryRequirements");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceImageSparseMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceImageSparseMemoryRequirements(device, pInfo, pSparseMemoryRequirementCount,
                                                                              pSparseMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceImageSparseMemoryRequirements);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceImageSparseMemoryRequirements");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceImageSparseMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceImageSparseMemoryRequirements(device, pInfo, pSparseMemoryRequirementCount,
                                                                    pSparseMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceImageSparseMemoryRequirements");
        device_dispatch->GetDeviceImageSparseMemoryRequirements(device, pInfo, pSparseMemoryRequirementCount,
                                                                pSparseMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceImageSparseMemoryRequirements");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceImageSparseMemoryRequirements]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceImageSparseMemoryRequirements(device, pInfo, pSparseMemoryRequirementCount,
                                                                     pSparseMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetLineStipple(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor,
                                             uint16_t lineStipplePattern) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetLineStipple, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetLineStipple");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetLineStipple]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetLineStipple(commandBuffer, lineStippleFactor, lineStipplePattern, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetLineStipple);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetLineStipple");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetLineStipple]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetLineStipple(commandBuffer, lineStippleFactor, lineStipplePattern, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetLineStipple");
        device_dispatch->CmdSetLineStipple(commandBuffer, lineStippleFactor, lineStipplePattern);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetLineStipple");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetLineStipple]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetLineStipple(commandBuffer, lineStippleFactor, lineStipplePattern, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL MapMemory2(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkMapMemory2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkMapMemory2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateMapMemory2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateMapMemory2(device, pMemoryMapInfo, ppData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkMapMemory2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkMapMemory2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordMapMemory2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordMapMemory2(device, pMemoryMapInfo, ppData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkMapMemory2");
        result = device_dispatch->MapMemory2(device, pMemoryMapInfo, ppData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkMapMemory2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordMapMemory2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordMapMemory2(device, pMemoryMapInfo, ppData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL UnmapMemory2(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUnmapMemory2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkUnmapMemory2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUnmapMemory2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUnmapMemory2(device, pMemoryUnmapInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkUnmapMemory2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkUnmapMemory2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUnmapMemory2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordUnmapMemory2(device, pMemoryUnmapInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkUnmapMemory2");
        result = device_dispatch->UnmapMemory2(device, pMemoryUnmapInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkUnmapMemory2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUnmapMemory2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordUnmapMemory2(device, pMemoryUnmapInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdBindIndexBuffer2(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                               VkDeviceSize size, VkIndexType indexType) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindIndexBuffer2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBindIndexBuffer2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindIndexBuffer2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindIndexBuffer2(commandBuffer, buffer, offset, size, indexType, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindIndexBuffer2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBindIndexBuffer2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindIndexBuffer2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindIndexBuffer2(commandBuffer, buffer, offset, size, indexType, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBindIndexBuffer2");
        device_dispatch->CmdBindIndexBuffer2(commandBuffer, buffer, offset, size, indexType);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBindIndexBuffer2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindIndexBuffer2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindIndexBuffer2(commandBuffer, buffer, offset, size, indexType, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetRenderingAreaGranularity(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo,
                                                       VkExtent2D* pGranularity) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetRenderingAreaGranularity, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetRenderingAreaGranularity");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetRenderingAreaGranularity]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetRenderingAreaGranularity(device, pRenderingAreaInfo, pGranularity, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetRenderingAreaGranularity);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetRenderingAreaGranularity");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetRenderingAreaGranularity]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetRenderingAreaGranularity(device, pRenderingAreaInfo, pGranularity, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetRenderingAreaGranularity");
        device_dispatch->GetRenderingAreaGranularity(device, pRenderingAreaInfo, pGranularity);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetRenderingAreaGranularity");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetRenderingAreaGranularity]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetRenderingAreaGranularity(device, pRenderingAreaInfo, pGranularity, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceImageSubresourceLayout(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo,
                                                           VkSubresourceLayout2* pLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceImageSubresourceLayout, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceImageSubresourceLayout");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceImageSubresourceLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceImageSubresourceLayout(device, pInfo, pLayout, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceImageSubresourceLayout);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceImageSubresourceLayout");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceImageSubresourceLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceImageSubresourceLayout(device, pInfo, pLayout, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceImageSubresourceLayout");
        device_dispatch->GetDeviceImageSubresourceLayout(device, pInfo, pLayout);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceImageSubresourceLayout");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceImageSubresourceLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceImageSubresourceLayout(device, pInfo, pLayout, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetImageSubresourceLayout2(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource,
                                                      VkSubresourceLayout2* pLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageSubresourceLayout2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetImageSubresourceLayout2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageSubresourceLayout2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageSubresourceLayout2(device, image, pSubresource, pLayout, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageSubresourceLayout2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetImageSubresourceLayout2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageSubresourceLayout2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageSubresourceLayout2(device, image, pSubresource, pLayout, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetImageSubresourceLayout2");
        device_dispatch->GetImageSubresourceLayout2(device, image, pSubresource, pLayout);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetImageSubresourceLayout2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageSubresourceLayout2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageSubresourceLayout2(device, image, pSubresource, pLayout, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSet(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint,
                                                VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount,
                                                const VkWriteDescriptorSet* pDescriptorWrites) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSet, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdPushDescriptorSet");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSet]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushDescriptorSet(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                                            pDescriptorWrites, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSet);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdPushDescriptorSet");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSet]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSet(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                                  pDescriptorWrites, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdPushDescriptorSet");
        device_dispatch->CmdPushDescriptorSet(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                              pDescriptorWrites);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdPushDescriptorSet");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSet]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSet(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                                   pDescriptorWrites, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSetWithTemplate(VkCommandBuffer commandBuffer,
                                                            VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                                            VkPipelineLayout layout, uint32_t set, const void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplate,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdPushDescriptorSetWithTemplate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSetWithTemplate]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushDescriptorSetWithTemplate(commandBuffer, descriptorUpdateTemplate, layout, set, pData,
                                                                        error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplate);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdPushDescriptorSetWithTemplate");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSetWithTemplate]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSetWithTemplate(commandBuffer, descriptorUpdateTemplate, layout, set, pData,
                                                              record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdPushDescriptorSetWithTemplate");
        device_dispatch->CmdPushDescriptorSetWithTemplate(commandBuffer, descriptorUpdateTemplate, layout, set, pData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdPushDescriptorSetWithTemplate");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSetWithTemplate]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSetWithTemplate(commandBuffer, descriptorUpdateTemplate, layout, set, pData,
                                                               record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetRenderingAttachmentLocations(VkCommandBuffer commandBuffer,
                                                              const VkRenderingAttachmentLocationInfo* pLocationInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetRenderingAttachmentLocations,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetRenderingAttachmentLocations");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetRenderingAttachmentLocations]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetRenderingAttachmentLocations(commandBuffer, pLocationInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetRenderingAttachmentLocations);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetRenderingAttachmentLocations");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetRenderingAttachmentLocations]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetRenderingAttachmentLocations(commandBuffer, pLocationInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetRenderingAttachmentLocations");
        device_dispatch->CmdSetRenderingAttachmentLocations(commandBuffer, pLocationInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetRenderingAttachmentLocations");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetRenderingAttachmentLocations]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetRenderingAttachmentLocations(commandBuffer, pLocationInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetRenderingInputAttachmentIndices(
    VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetRenderingInputAttachmentIndices,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetRenderingInputAttachmentIndices");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetRenderingInputAttachmentIndices]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetRenderingInputAttachmentIndices(commandBuffer, pInputAttachmentIndexInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetRenderingInputAttachmentIndices);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetRenderingInputAttachmentIndices");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetRenderingInputAttachmentIndices]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetRenderingInputAttachmentIndices(commandBuffer, pInputAttachmentIndexInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetRenderingInputAttachmentIndices");
        device_dispatch->CmdSetRenderingInputAttachmentIndices(commandBuffer, pInputAttachmentIndexInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetRenderingInputAttachmentIndices");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetRenderingInputAttachmentIndices]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetRenderingInputAttachmentIndices(commandBuffer, pInputAttachmentIndexInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindDescriptorSets2(VkCommandBuffer commandBuffer,
                                                  const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindDescriptorSets2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBindDescriptorSets2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindDescriptorSets2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindDescriptorSets2(commandBuffer, pBindDescriptorSetsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindDescriptorSets2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBindDescriptorSets2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindDescriptorSets2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindDescriptorSets2(commandBuffer, pBindDescriptorSetsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBindDescriptorSets2");
        device_dispatch->CmdBindDescriptorSets2(commandBuffer, pBindDescriptorSetsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBindDescriptorSets2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindDescriptorSets2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindDescriptorSets2(commandBuffer, pBindDescriptorSetsInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushConstants2(VkCommandBuffer commandBuffer, const VkPushConstantsInfo* pPushConstantsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushConstants2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdPushConstants2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushConstants2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushConstants2(commandBuffer, pPushConstantsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushConstants2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdPushConstants2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushConstants2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushConstants2(commandBuffer, pPushConstantsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdPushConstants2");
        device_dispatch->CmdPushConstants2(commandBuffer, pPushConstantsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdPushConstants2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushConstants2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushConstants2(commandBuffer, pPushConstantsInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSet2(VkCommandBuffer commandBuffer,
                                                 const VkPushDescriptorSetInfo* pPushDescriptorSetInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSet2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdPushDescriptorSet2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSet2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushDescriptorSet2(commandBuffer, pPushDescriptorSetInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSet2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdPushDescriptorSet2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSet2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSet2(commandBuffer, pPushDescriptorSetInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdPushDescriptorSet2");
        device_dispatch->CmdPushDescriptorSet2(commandBuffer, pPushDescriptorSetInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdPushDescriptorSet2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSet2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSet2(commandBuffer, pPushDescriptorSetInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSetWithTemplate2(
    VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplate2,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdPushDescriptorSetWithTemplate2");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSetWithTemplate2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdPushDescriptorSetWithTemplate2(commandBuffer, pPushDescriptorSetWithTemplateInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplate2);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdPushDescriptorSetWithTemplate2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSetWithTemplate2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSetWithTemplate2(commandBuffer, pPushDescriptorSetWithTemplateInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdPushDescriptorSetWithTemplate2");
        device_dispatch->CmdPushDescriptorSetWithTemplate2(commandBuffer, pPushDescriptorSetWithTemplateInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdPushDescriptorSetWithTemplate2");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSetWithTemplate2]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSetWithTemplate2(commandBuffer, pPushDescriptorSetWithTemplateInfo, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CopyMemoryToImage(VkDevice device, const VkCopyMemoryToImageInfo* pCopyMemoryToImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCopyMemoryToImage, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCopyMemoryToImage");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCopyMemoryToImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCopyMemoryToImage(device, pCopyMemoryToImageInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCopyMemoryToImage);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCopyMemoryToImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCopyMemoryToImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCopyMemoryToImage(device, pCopyMemoryToImageInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCopyMemoryToImage");
        result = device_dispatch->CopyMemoryToImage(device, pCopyMemoryToImageInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCopyMemoryToImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCopyMemoryToImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCopyMemoryToImage(device, pCopyMemoryToImageInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CopyImageToMemory(VkDevice device, const VkCopyImageToMemoryInfo* pCopyImageToMemoryInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCopyImageToMemory, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCopyImageToMemory");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCopyImageToMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCopyImageToMemory(device, pCopyImageToMemoryInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCopyImageToMemory);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCopyImageToMemory");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCopyImageToMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCopyImageToMemory(device, pCopyImageToMemoryInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCopyImageToMemory");
        result = device_dispatch->CopyImageToMemory(device, pCopyImageToMemoryInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCopyImageToMemory");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCopyImageToMemory]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCopyImageToMemory(device, pCopyImageToMemoryInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CopyImageToImage(VkDevice device, const VkCopyImageToImageInfo* pCopyImageToImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCopyImageToImage, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCopyImageToImage");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCopyImageToImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCopyImageToImage(device, pCopyImageToImageInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCopyImageToImage);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCopyImageToImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCopyImageToImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCopyImageToImage(device, pCopyImageToImageInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCopyImageToImage");
        result = device_dispatch->CopyImageToImage(device, pCopyImageToImageInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCopyImageToImage");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCopyImageToImage]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCopyImageToImage(device, pCopyImageToImageInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL TransitionImageLayout(VkDevice device, uint32_t transitionCount,
                                                     const VkHostImageLayoutTransitionInfo* pTransitions) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkTransitionImageLayout, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkTransitionImageLayout");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateTransitionImageLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateTransitionImageLayout(device, transitionCount, pTransitions, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkTransitionImageLayout);
    {
        VVL_ZoneScopedN("PreCallRecord_vkTransitionImageLayout");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordTransitionImageLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordTransitionImageLayout(device, transitionCount, pTransitions, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkTransitionImageLayout");
        result = device_dispatch->TransitionImageLayout(device, transitionCount, pTransitions);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkTransitionImageLayout");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordTransitionImageLayout]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordTransitionImageLayout(device, transitionCount, pTransitions, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroySurfaceKHR(VkInstance instance, VkSurfaceKHR surface, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroySurfaceKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroySurfaceKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateDestroySurfaceKHR(instance, surface, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroySurfaceKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroySurfaceKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordDestroySurfaceKHR(instance, surface, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroySurfaceKHR");
        instance_dispatch->DestroySurfaceKHR(instance, surface, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroySurfaceKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordDestroySurfaceKHR(instance, surface, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex,
                                                                  VkSurfaceKHR surface, VkBool32* pSupported) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfaceSupportKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceSurfaceSupportKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfaceSupportKHR(physicalDevice, queueFamilyIndex, surface, pSupported,
                                                                          error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfaceSupportKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceSurfaceSupportKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceSurfaceSupportKHR(physicalDevice, queueFamilyIndex, surface, pSupported, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceSurfaceSupportKHR");
        result = instance_dispatch->GetPhysicalDeviceSurfaceSupportKHR(physicalDevice, queueFamilyIndex, surface, pSupported);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceSurfaceSupportKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceSurfaceSupportKHR(physicalDevice, queueFamilyIndex, surface, pSupported, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfaceCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface,
                                                                       VkSurfaceCapabilitiesKHR* pSurfaceCapabilities) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfaceCapabilitiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceSurfaceCapabilitiesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfaceCapabilitiesKHR(physicalDevice, surface, pSurfaceCapabilities,
                                                                               error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfaceCapabilitiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceSurfaceCapabilitiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceSurfaceCapabilitiesKHR(physicalDevice, surface, pSurfaceCapabilities, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceSurfaceCapabilitiesKHR");
        result = instance_dispatch->GetPhysicalDeviceSurfaceCapabilitiesKHR(physicalDevice, surface, pSurfaceCapabilities);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceSurfaceCapabilitiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceSurfaceCapabilitiesKHR(physicalDevice, surface, pSurfaceCapabilities, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface,
                                                                  uint32_t* pSurfaceFormatCount,
                                                                  VkSurfaceFormatKHR* pSurfaceFormats) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfaceFormatsKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceSurfaceFormatsKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfaceFormatsKHR(physicalDevice, surface, pSurfaceFormatCount,
                                                                          pSurfaceFormats, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfaceFormatsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceSurfaceFormatsKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceSurfaceFormatsKHR(physicalDevice, surface, pSurfaceFormatCount, pSurfaceFormats,
                                                                record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceSurfaceFormatsKHR");
        result =
            instance_dispatch->GetPhysicalDeviceSurfaceFormatsKHR(physicalDevice, surface, pSurfaceFormatCount, pSurfaceFormats);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceSurfaceFormatsKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceSurfaceFormatsKHR(physicalDevice, surface, pSurfaceFormatCount, pSurfaceFormats,
                                                                 record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface,
                                                                       uint32_t* pPresentModeCount,
                                                                       VkPresentModeKHR* pPresentModes) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfacePresentModesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceSurfacePresentModesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfacePresentModesKHR(physicalDevice, surface, pPresentModeCount,
                                                                               pPresentModes, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfacePresentModesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceSurfacePresentModesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceSurfacePresentModesKHR(physicalDevice, surface, pPresentModeCount, pPresentModes,
                                                                     record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceSurfacePresentModesKHR");
        result =
            instance_dispatch->GetPhysicalDeviceSurfacePresentModesKHR(physicalDevice, surface, pPresentModeCount, pPresentModes);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceSurfacePresentModesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceSurfacePresentModesKHR(physicalDevice, surface, pPresentModeCount, pPresentModes,
                                                                      record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo,
                                                  const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateSwapchainKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateSwapchainKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateSwapchainKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateSwapchainKHR(device, pCreateInfo, pAllocator, pSwapchain, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateSwapchainKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateSwapchainKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateSwapchainKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateSwapchainKHR(device, pCreateInfo, pAllocator, pSwapchain, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateSwapchainKHR");
        result = device_dispatch->CreateSwapchainKHR(device, pCreateInfo, pAllocator, pSwapchain);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateSwapchainKHR");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateSwapchainKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateSwapchainKHR(device, pCreateInfo, pAllocator, pSwapchain, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroySwapchainKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroySwapchainKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroySwapchainKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroySwapchainKHR(device, swapchain, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroySwapchainKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroySwapchainKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroySwapchainKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroySwapchainKHR(device, swapchain, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroySwapchainKHR");
        device_dispatch->DestroySwapchainKHR(device, swapchain, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroySwapchainKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroySwapchainKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroySwapchainKHR(device, swapchain, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount,
                                                     VkImage* pSwapchainImages) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSwapchainImagesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetSwapchainImagesKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSwapchainImagesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSwapchainImagesKHR(device, swapchain, pSwapchainImageCount, pSwapchainImages, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSwapchainImagesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetSwapchainImagesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSwapchainImagesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSwapchainImagesKHR(device, swapchain, pSwapchainImageCount, pSwapchainImages, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetSwapchainImagesKHR");
        result = device_dispatch->GetSwapchainImagesKHR(device, swapchain, pSwapchainImageCount, pSwapchainImages);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetSwapchainImagesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSwapchainImagesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetSwapchainImagesKHR(device, swapchain, pSwapchainImageCount, pSwapchainImages, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL AcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout,
                                                   VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAcquireNextImageKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkAcquireNextImageKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateAcquireNextImageKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAcquireNextImageKHR(device, swapchain, timeout, semaphore, fence, pImageIndex, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAcquireNextImageKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkAcquireNextImageKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordAcquireNextImageKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordAcquireNextImageKHR(device, swapchain, timeout, semaphore, fence, pImageIndex, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkAcquireNextImageKHR");
        result = device_dispatch->AcquireNextImageKHR(device, swapchain, timeout, semaphore, fence, pImageIndex);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkAcquireNextImageKHR");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordAcquireNextImageKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordAcquireNextImageKHR(device, swapchain, timeout, semaphore, fence, pImageIndex, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL
GetDeviceGroupPresentCapabilitiesKHR(VkDevice device, VkDeviceGroupPresentCapabilitiesKHR* pDeviceGroupPresentCapabilities) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceGroupPresentCapabilitiesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceGroupPresentCapabilitiesKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceGroupPresentCapabilitiesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceGroupPresentCapabilitiesKHR(device, pDeviceGroupPresentCapabilities, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceGroupPresentCapabilitiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceGroupPresentCapabilitiesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceGroupPresentCapabilitiesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceGroupPresentCapabilitiesKHR(device, pDeviceGroupPresentCapabilities, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceGroupPresentCapabilitiesKHR");
        result = device_dispatch->GetDeviceGroupPresentCapabilitiesKHR(device, pDeviceGroupPresentCapabilities);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceGroupPresentCapabilitiesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceGroupPresentCapabilitiesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceGroupPresentCapabilitiesKHR(device, pDeviceGroupPresentCapabilities, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDeviceGroupSurfacePresentModesKHR(VkDevice device, VkSurfaceKHR surface,
                                                                    VkDeviceGroupPresentModeFlagsKHR* pModes) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceGroupSurfacePresentModesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceGroupSurfacePresentModesKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceGroupSurfacePresentModesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceGroupSurfacePresentModesKHR(device, surface, pModes, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceGroupSurfacePresentModesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceGroupSurfacePresentModesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceGroupSurfacePresentModesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceGroupSurfacePresentModesKHR(device, surface, pModes, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceGroupSurfacePresentModesKHR");
        result = device_dispatch->GetDeviceGroupSurfacePresentModesKHR(device, surface, pModes);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceGroupSurfacePresentModesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceGroupSurfacePresentModesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceGroupSurfacePresentModesKHR(device, surface, pModes, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDevicePresentRectanglesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface,
                                                                     uint32_t* pRectCount, VkRect2D* pRects) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDevicePresentRectanglesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDevicePresentRectanglesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |=
                vo->PreCallValidateGetPhysicalDevicePresentRectanglesKHR(physicalDevice, surface, pRectCount, pRects, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDevicePresentRectanglesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDevicePresentRectanglesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDevicePresentRectanglesKHR(physicalDevice, surface, pRectCount, pRects, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDevicePresentRectanglesKHR");
        result = instance_dispatch->GetPhysicalDevicePresentRectanglesKHR(physicalDevice, surface, pRectCount, pRects);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDevicePresentRectanglesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDevicePresentRectanglesKHR(physicalDevice, surface, pRectCount, pRects, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL AcquireNextImage2KHR(VkDevice device, const VkAcquireNextImageInfoKHR* pAcquireInfo,
                                                    uint32_t* pImageIndex) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAcquireNextImage2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkAcquireNextImage2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateAcquireNextImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAcquireNextImage2KHR(device, pAcquireInfo, pImageIndex, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAcquireNextImage2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkAcquireNextImage2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordAcquireNextImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordAcquireNextImage2KHR(device, pAcquireInfo, pImageIndex, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkAcquireNextImage2KHR");
        result = device_dispatch->AcquireNextImage2KHR(device, pAcquireInfo, pImageIndex);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkAcquireNextImage2KHR");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordAcquireNextImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordAcquireNextImage2KHR(device, pAcquireInfo, pImageIndex, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount,
                                                                     VkDisplayPropertiesKHR* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceDisplayPropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceDisplayPropertiesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |=
                vo->PreCallValidateGetPhysicalDeviceDisplayPropertiesKHR(physicalDevice, pPropertyCount, pProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceDisplayPropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceDisplayPropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceDisplayPropertiesKHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceDisplayPropertiesKHR");
        result = instance_dispatch->GetPhysicalDeviceDisplayPropertiesKHR(physicalDevice, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceDisplayPropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceDisplayPropertiesKHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount,
                                                                          VkDisplayPlanePropertiesKHR* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceDisplayPlanePropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceDisplayPlanePropertiesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceDisplayPlanePropertiesKHR(physicalDevice, pPropertyCount, pProperties,
                                                                                  error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceDisplayPlanePropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceDisplayPlanePropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceDisplayPlanePropertiesKHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceDisplayPlanePropertiesKHR");
        result = instance_dispatch->GetPhysicalDeviceDisplayPlanePropertiesKHR(physicalDevice, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceDisplayPlanePropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceDisplayPlanePropertiesKHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, uint32_t planeIndex,
                                                                   uint32_t* pDisplayCount, VkDisplayKHR* pDisplays) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDisplayPlaneSupportedDisplaysKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDisplayPlaneSupportedDisplaysKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetDisplayPlaneSupportedDisplaysKHR(physicalDevice, planeIndex, pDisplayCount, pDisplays,
                                                                           error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDisplayPlaneSupportedDisplaysKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDisplayPlaneSupportedDisplaysKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetDisplayPlaneSupportedDisplaysKHR(physicalDevice, planeIndex, pDisplayCount, pDisplays, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetDisplayPlaneSupportedDisplaysKHR");
        result = instance_dispatch->GetDisplayPlaneSupportedDisplaysKHR(physicalDevice, planeIndex, pDisplayCount, pDisplays);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDisplayPlaneSupportedDisplaysKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetDisplayPlaneSupportedDisplaysKHR(physicalDevice, planeIndex, pDisplayCount, pDisplays, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display,
                                                           uint32_t* pPropertyCount, VkDisplayModePropertiesKHR* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDisplayModePropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDisplayModePropertiesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetDisplayModePropertiesKHR(physicalDevice, display, pPropertyCount, pProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDisplayModePropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDisplayModePropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetDisplayModePropertiesKHR(physicalDevice, display, pPropertyCount, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetDisplayModePropertiesKHR");
        result = instance_dispatch->GetDisplayModePropertiesKHR(physicalDevice, display, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDisplayModePropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetDisplayModePropertiesKHR(physicalDevice, display, pPropertyCount, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDisplayModeKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display,
                                                    const VkDisplayModeCreateInfoKHR* pCreateInfo,
                                                    const VkAllocationCallbacks* pAllocator, VkDisplayModeKHR* pMode) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDisplayModeKHR, VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateDisplayModeKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateCreateDisplayModeKHR(physicalDevice, display, pCreateInfo, pAllocator, pMode, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDisplayModeKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateDisplayModeKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordCreateDisplayModeKHR(physicalDevice, display, pCreateInfo, pAllocator, pMode, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateDisplayModeKHR");
        result = instance_dispatch->CreateDisplayModeKHR(physicalDevice, display, pCreateInfo, pAllocator, pMode);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateDisplayModeKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordCreateDisplayModeKHR(physicalDevice, display, pCreateInfo, pAllocator, pMode, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDisplayPlaneCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkDisplayModeKHR mode,
                                                              uint32_t planeIndex, VkDisplayPlaneCapabilitiesKHR* pCapabilities) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDisplayPlaneCapabilitiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDisplayPlaneCapabilitiesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetDisplayPlaneCapabilitiesKHR(physicalDevice, mode, planeIndex, pCapabilities, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDisplayPlaneCapabilitiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDisplayPlaneCapabilitiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetDisplayPlaneCapabilitiesKHR(physicalDevice, mode, planeIndex, pCapabilities, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetDisplayPlaneCapabilitiesKHR");
        result = instance_dispatch->GetDisplayPlaneCapabilitiesKHR(physicalDevice, mode, planeIndex, pCapabilities);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDisplayPlaneCapabilitiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetDisplayPlaneCapabilitiesKHR(physicalDevice, mode, planeIndex, pCapabilities, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDisplayPlaneSurfaceKHR(VkInstance instance, const VkDisplaySurfaceCreateInfoKHR* pCreateInfo,
                                                            const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDisplayPlaneSurfaceKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateDisplayPlaneSurfaceKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateCreateDisplayPlaneSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDisplayPlaneSurfaceKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateDisplayPlaneSurfaceKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordCreateDisplayPlaneSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateDisplayPlaneSurfaceKHR");
        result = instance_dispatch->CreateDisplayPlaneSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateDisplayPlaneSurfaceKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordCreateDisplayPlaneSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount,
                                                         const VkSwapchainCreateInfoKHR* pCreateInfos,
                                                         const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateSharedSwapchainsKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateSharedSwapchainsKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateSharedSwapchainsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateSharedSwapchainsKHR(device, swapchainCount, pCreateInfos, pAllocator, pSwapchains,
                                                                 error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateSharedSwapchainsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateSharedSwapchainsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateSharedSwapchainsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateSharedSwapchainsKHR(device, swapchainCount, pCreateInfos, pAllocator, pSwapchains, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateSharedSwapchainsKHR");
        result = device_dispatch->CreateSharedSwapchainsKHR(device, swapchainCount, pCreateInfos, pAllocator, pSwapchains);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateSharedSwapchainsKHR");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateSharedSwapchainsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateSharedSwapchainsKHR(device, swapchainCount, pCreateInfos, pAllocator, pSwapchains, record_obj);
        }
    }
    return result;
}

#ifdef VK_USE_PLATFORM_XLIB_KHR
VKAPI_ATTR VkResult VKAPI_CALL CreateXlibSurfaceKHR(VkInstance instance, const VkXlibSurfaceCreateInfoKHR* pCreateInfo,
                                                    const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateXlibSurfaceKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateXlibSurfaceKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateCreateXlibSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateXlibSurfaceKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateXlibSurfaceKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordCreateXlibSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateXlibSurfaceKHR");
        result = instance_dispatch->CreateXlibSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateXlibSurfaceKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordCreateXlibSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkBool32 VKAPI_CALL GetPhysicalDeviceXlibPresentationSupportKHR(VkPhysicalDevice physicalDevice,
                                                                           uint32_t queueFamilyIndex, Display* dpy,
                                                                           VisualID visualID) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceXlibPresentationSupportKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceXlibPresentationSupportKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceXlibPresentationSupportKHR(physicalDevice, queueFamilyIndex, dpy, visualID,
                                                                                   error_obj);
            if (skip) return VK_FALSE;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceXlibPresentationSupportKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceXlibPresentationSupportKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceXlibPresentationSupportKHR(physicalDevice, queueFamilyIndex, dpy, visualID,
                                                                         record_obj);
        }
    }
    VkBool32 result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceXlibPresentationSupportKHR");
        result = instance_dispatch->GetPhysicalDeviceXlibPresentationSupportKHR(physicalDevice, queueFamilyIndex, dpy, visualID);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceXlibPresentationSupportKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceXlibPresentationSupportKHR(physicalDevice, queueFamilyIndex, dpy, visualID,
                                                                          record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
VKAPI_ATTR VkResult VKAPI_CALL CreateXcbSurfaceKHR(VkInstance instance, const VkXcbSurfaceCreateInfoKHR* pCreateInfo,
                                                   const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateXcbSurfaceKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateXcbSurfaceKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateCreateXcbSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateXcbSurfaceKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateXcbSurfaceKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordCreateXcbSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateXcbSurfaceKHR");
        result = instance_dispatch->CreateXcbSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateXcbSurfaceKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordCreateXcbSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkBool32 VKAPI_CALL GetPhysicalDeviceXcbPresentationSupportKHR(VkPhysicalDevice physicalDevice,
                                                                          uint32_t queueFamilyIndex, xcb_connection_t* connection,
                                                                          xcb_visualid_t visual_id) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceXcbPresentationSupportKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceXcbPresentationSupportKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceXcbPresentationSupportKHR(physicalDevice, queueFamilyIndex, connection,
                                                                                  visual_id, error_obj);
            if (skip) return VK_FALSE;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceXcbPresentationSupportKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceXcbPresentationSupportKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceXcbPresentationSupportKHR(physicalDevice, queueFamilyIndex, connection, visual_id,
                                                                        record_obj);
        }
    }
    VkBool32 result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceXcbPresentationSupportKHR");
        result =
            instance_dispatch->GetPhysicalDeviceXcbPresentationSupportKHR(physicalDevice, queueFamilyIndex, connection, visual_id);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceXcbPresentationSupportKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceXcbPresentationSupportKHR(physicalDevice, queueFamilyIndex, connection, visual_id,
                                                                         record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
VKAPI_ATTR VkResult VKAPI_CALL CreateWaylandSurfaceKHR(VkInstance instance, const VkWaylandSurfaceCreateInfoKHR* pCreateInfo,
                                                       const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateWaylandSurfaceKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateWaylandSurfaceKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateCreateWaylandSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateWaylandSurfaceKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateWaylandSurfaceKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordCreateWaylandSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateWaylandSurfaceKHR");
        result = instance_dispatch->CreateWaylandSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateWaylandSurfaceKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordCreateWaylandSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkBool32 VKAPI_CALL GetPhysicalDeviceWaylandPresentationSupportKHR(VkPhysicalDevice physicalDevice,
                                                                              uint32_t queueFamilyIndex,
                                                                              struct wl_display* display) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceWaylandPresentationSupportKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceWaylandPresentationSupportKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceWaylandPresentationSupportKHR(physicalDevice, queueFamilyIndex, display,
                                                                                      error_obj);
            if (skip) return VK_FALSE;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceWaylandPresentationSupportKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceWaylandPresentationSupportKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceWaylandPresentationSupportKHR(physicalDevice, queueFamilyIndex, display, record_obj);
        }
    }
    VkBool32 result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceWaylandPresentationSupportKHR");
        result = instance_dispatch->GetPhysicalDeviceWaylandPresentationSupportKHR(physicalDevice, queueFamilyIndex, display);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceWaylandPresentationSupportKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceWaylandPresentationSupportKHR(physicalDevice, queueFamilyIndex, display, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
VKAPI_ATTR VkResult VKAPI_CALL CreateAndroidSurfaceKHR(VkInstance instance, const VkAndroidSurfaceCreateInfoKHR* pCreateInfo,
                                                       const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateAndroidSurfaceKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateAndroidSurfaceKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateCreateAndroidSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateAndroidSurfaceKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateAndroidSurfaceKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordCreateAndroidSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateAndroidSurfaceKHR");
        result = instance_dispatch->CreateAndroidSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateAndroidSurfaceKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordCreateAndroidSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL CreateWin32SurfaceKHR(VkInstance instance, const VkWin32SurfaceCreateInfoKHR* pCreateInfo,
                                                     const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateWin32SurfaceKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateWin32SurfaceKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateCreateWin32SurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateWin32SurfaceKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateWin32SurfaceKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordCreateWin32SurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateWin32SurfaceKHR");
        result = instance_dispatch->CreateWin32SurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateWin32SurfaceKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordCreateWin32SurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkBool32 VKAPI_CALL GetPhysicalDeviceWin32PresentationSupportKHR(VkPhysicalDevice physicalDevice,
                                                                            uint32_t queueFamilyIndex) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceWin32PresentationSupportKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceWin32PresentationSupportKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceWin32PresentationSupportKHR(physicalDevice, queueFamilyIndex, error_obj);
            if (skip) return VK_FALSE;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceWin32PresentationSupportKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceWin32PresentationSupportKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceWin32PresentationSupportKHR(physicalDevice, queueFamilyIndex, record_obj);
        }
    }
    VkBool32 result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceWin32PresentationSupportKHR");
        result = instance_dispatch->GetPhysicalDeviceWin32PresentationSupportKHR(physicalDevice, queueFamilyIndex);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceWin32PresentationSupportKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceWin32PresentationSupportKHR(physicalDevice, queueFamilyIndex, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceVideoCapabilitiesKHR(VkPhysicalDevice physicalDevice,
                                                                     const VkVideoProfileInfoKHR* pVideoProfile,
                                                                     VkVideoCapabilitiesKHR* pCapabilities) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceVideoCapabilitiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceVideoCapabilitiesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |=
                vo->PreCallValidateGetPhysicalDeviceVideoCapabilitiesKHR(physicalDevice, pVideoProfile, pCapabilities, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceVideoCapabilitiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceVideoCapabilitiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceVideoCapabilitiesKHR(physicalDevice, pVideoProfile, pCapabilities, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceVideoCapabilitiesKHR");
        result = instance_dispatch->GetPhysicalDeviceVideoCapabilitiesKHR(physicalDevice, pVideoProfile, pCapabilities);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceVideoCapabilitiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceVideoCapabilitiesKHR(physicalDevice, pVideoProfile, pCapabilities, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceVideoFormatPropertiesKHR(VkPhysicalDevice physicalDevice,
                                                                         const VkPhysicalDeviceVideoFormatInfoKHR* pVideoFormatInfo,
                                                                         uint32_t* pVideoFormatPropertyCount,
                                                                         VkVideoFormatPropertiesKHR* pVideoFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceVideoFormatPropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceVideoFormatPropertiesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceVideoFormatPropertiesKHR(
                physicalDevice, pVideoFormatInfo, pVideoFormatPropertyCount, pVideoFormatProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceVideoFormatPropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceVideoFormatPropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceVideoFormatPropertiesKHR(physicalDevice, pVideoFormatInfo, pVideoFormatPropertyCount,
                                                                       pVideoFormatProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceVideoFormatPropertiesKHR");
        result = instance_dispatch->GetPhysicalDeviceVideoFormatPropertiesKHR(physicalDevice, pVideoFormatInfo,
                                                                              pVideoFormatPropertyCount, pVideoFormatProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceVideoFormatPropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceVideoFormatPropertiesKHR(physicalDevice, pVideoFormatInfo, pVideoFormatPropertyCount,
                                                                        pVideoFormatProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateVideoSessionKHR(VkDevice device, const VkVideoSessionCreateInfoKHR* pCreateInfo,
                                                     const VkAllocationCallbacks* pAllocator, VkVideoSessionKHR* pVideoSession) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateVideoSessionKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateVideoSessionKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateVideoSessionKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateVideoSessionKHR(device, pCreateInfo, pAllocator, pVideoSession, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateVideoSessionKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateVideoSessionKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateVideoSessionKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateVideoSessionKHR(device, pCreateInfo, pAllocator, pVideoSession, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateVideoSessionKHR");
        result = device_dispatch->CreateVideoSessionKHR(device, pCreateInfo, pAllocator, pVideoSession);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateVideoSessionKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateVideoSessionKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateVideoSessionKHR(device, pCreateInfo, pAllocator, pVideoSession, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyVideoSessionKHR(VkDevice device, VkVideoSessionKHR videoSession,
                                                  const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyVideoSessionKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyVideoSessionKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyVideoSessionKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyVideoSessionKHR(device, videoSession, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyVideoSessionKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyVideoSessionKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyVideoSessionKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyVideoSessionKHR(device, videoSession, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyVideoSessionKHR");
        device_dispatch->DestroyVideoSessionKHR(device, videoSession, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyVideoSessionKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyVideoSessionKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyVideoSessionKHR(device, videoSession, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetVideoSessionMemoryRequirementsKHR(VkDevice device, VkVideoSessionKHR videoSession,
                                                                    uint32_t* pMemoryRequirementsCount,
                                                                    VkVideoSessionMemoryRequirementsKHR* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetVideoSessionMemoryRequirementsKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetVideoSessionMemoryRequirementsKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetVideoSessionMemoryRequirementsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetVideoSessionMemoryRequirementsKHR(device, videoSession, pMemoryRequirementsCount,
                                                                            pMemoryRequirements, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetVideoSessionMemoryRequirementsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetVideoSessionMemoryRequirementsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetVideoSessionMemoryRequirementsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetVideoSessionMemoryRequirementsKHR(device, videoSession, pMemoryRequirementsCount,
                                                                  pMemoryRequirements, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetVideoSessionMemoryRequirementsKHR");
        result = device_dispatch->GetVideoSessionMemoryRequirementsKHR(device, videoSession, pMemoryRequirementsCount,
                                                                       pMemoryRequirements);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetVideoSessionMemoryRequirementsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetVideoSessionMemoryRequirementsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetVideoSessionMemoryRequirementsKHR(device, videoSession, pMemoryRequirementsCount,
                                                                   pMemoryRequirements, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL BindVideoSessionMemoryKHR(VkDevice device, VkVideoSessionKHR videoSession,
                                                         uint32_t bindSessionMemoryInfoCount,
                                                         const VkBindVideoSessionMemoryInfoKHR* pBindSessionMemoryInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindVideoSessionMemoryKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkBindVideoSessionMemoryKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindVideoSessionMemoryKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindVideoSessionMemoryKHR(device, videoSession, bindSessionMemoryInfoCount,
                                                                 pBindSessionMemoryInfos, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindVideoSessionMemoryKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkBindVideoSessionMemoryKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindVideoSessionMemoryKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindVideoSessionMemoryKHR(device, videoSession, bindSessionMemoryInfoCount, pBindSessionMemoryInfos,
                                                       record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkBindVideoSessionMemoryKHR");
        result =
            device_dispatch->BindVideoSessionMemoryKHR(device, videoSession, bindSessionMemoryInfoCount, pBindSessionMemoryInfos);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkBindVideoSessionMemoryKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindVideoSessionMemoryKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindVideoSessionMemoryKHR(device, videoSession, bindSessionMemoryInfoCount, pBindSessionMemoryInfos,
                                                        record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateVideoSessionParametersKHR(VkDevice device,
                                                               const VkVideoSessionParametersCreateInfoKHR* pCreateInfo,
                                                               const VkAllocationCallbacks* pAllocator,
                                                               VkVideoSessionParametersKHR* pVideoSessionParameters) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateVideoSessionParametersKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateVideoSessionParametersKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateVideoSessionParametersKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateVideoSessionParametersKHR(device, pCreateInfo, pAllocator, pVideoSessionParameters,
                                                                       error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateVideoSessionParametersKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateVideoSessionParametersKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateVideoSessionParametersKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateVideoSessionParametersKHR(device, pCreateInfo, pAllocator, pVideoSessionParameters, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateVideoSessionParametersKHR");
        result = device_dispatch->CreateVideoSessionParametersKHR(device, pCreateInfo, pAllocator, pVideoSessionParameters);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateVideoSessionParametersKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateVideoSessionParametersKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateVideoSessionParametersKHR(device, pCreateInfo, pAllocator, pVideoSessionParameters, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL UpdateVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters,
                                                               const VkVideoSessionParametersUpdateInfoKHR* pUpdateInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUpdateVideoSessionParametersKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkUpdateVideoSessionParametersKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUpdateVideoSessionParametersKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUpdateVideoSessionParametersKHR(device, videoSessionParameters, pUpdateInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkUpdateVideoSessionParametersKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkUpdateVideoSessionParametersKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUpdateVideoSessionParametersKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordUpdateVideoSessionParametersKHR(device, videoSessionParameters, pUpdateInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkUpdateVideoSessionParametersKHR");
        result = device_dispatch->UpdateVideoSessionParametersKHR(device, videoSessionParameters, pUpdateInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkUpdateVideoSessionParametersKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUpdateVideoSessionParametersKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordUpdateVideoSessionParametersKHR(device, videoSessionParameters, pUpdateInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters,
                                                            const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyVideoSessionParametersKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyVideoSessionParametersKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyVideoSessionParametersKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyVideoSessionParametersKHR(device, videoSessionParameters, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyVideoSessionParametersKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyVideoSessionParametersKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyVideoSessionParametersKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyVideoSessionParametersKHR(device, videoSessionParameters, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyVideoSessionParametersKHR");
        device_dispatch->DestroyVideoSessionParametersKHR(device, videoSessionParameters, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyVideoSessionParametersKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyVideoSessionParametersKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyVideoSessionParametersKHR(device, videoSessionParameters, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoBeginCodingInfoKHR* pBeginInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginVideoCodingKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBeginVideoCodingKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginVideoCodingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginVideoCodingKHR(commandBuffer, pBeginInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginVideoCodingKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBeginVideoCodingKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginVideoCodingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginVideoCodingKHR(commandBuffer, pBeginInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBeginVideoCodingKHR");
        device_dispatch->CmdBeginVideoCodingKHR(commandBuffer, pBeginInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBeginVideoCodingKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginVideoCodingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginVideoCodingKHR(commandBuffer, pBeginInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoEndCodingInfoKHR* pEndCodingInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndVideoCodingKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdEndVideoCodingKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndVideoCodingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndVideoCodingKHR(commandBuffer, pEndCodingInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndVideoCodingKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdEndVideoCodingKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndVideoCodingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndVideoCodingKHR(commandBuffer, pEndCodingInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdEndVideoCodingKHR");
        device_dispatch->CmdEndVideoCodingKHR(commandBuffer, pEndCodingInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdEndVideoCodingKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndVideoCodingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndVideoCodingKHR(commandBuffer, pEndCodingInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdControlVideoCodingKHR(VkCommandBuffer commandBuffer,
                                                    const VkVideoCodingControlInfoKHR* pCodingControlInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdControlVideoCodingKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdControlVideoCodingKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdControlVideoCodingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdControlVideoCodingKHR(commandBuffer, pCodingControlInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdControlVideoCodingKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdControlVideoCodingKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdControlVideoCodingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdControlVideoCodingKHR(commandBuffer, pCodingControlInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdControlVideoCodingKHR");
        device_dispatch->CmdControlVideoCodingKHR(commandBuffer, pCodingControlInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdControlVideoCodingKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdControlVideoCodingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdControlVideoCodingKHR(commandBuffer, pCodingControlInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDecodeVideoKHR(VkCommandBuffer commandBuffer, const VkVideoDecodeInfoKHR* pDecodeInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDecodeVideoKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDecodeVideoKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDecodeVideoKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDecodeVideoKHR(commandBuffer, pDecodeInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDecodeVideoKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDecodeVideoKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDecodeVideoKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDecodeVideoKHR(commandBuffer, pDecodeInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDecodeVideoKHR");
        device_dispatch->CmdDecodeVideoKHR(commandBuffer, pDecodeInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDecodeVideoKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDecodeVideoKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDecodeVideoKHR(commandBuffer, pDecodeInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginRenderingKHR(VkCommandBuffer commandBuffer, const VkRenderingInfo* pRenderingInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginRenderingKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBeginRenderingKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginRenderingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginRenderingKHR(commandBuffer, pRenderingInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginRenderingKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBeginRenderingKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginRenderingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginRenderingKHR(commandBuffer, pRenderingInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBeginRenderingKHR");
        device_dispatch->CmdBeginRenderingKHR(commandBuffer, pRenderingInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBeginRenderingKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginRenderingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginRenderingKHR(commandBuffer, pRenderingInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndRenderingKHR(VkCommandBuffer commandBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndRenderingKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdEndRenderingKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndRenderingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndRenderingKHR(commandBuffer, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndRenderingKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdEndRenderingKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndRenderingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndRenderingKHR(commandBuffer, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdEndRenderingKHR");
        device_dispatch->CmdEndRenderingKHR(commandBuffer);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdEndRenderingKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndRenderingKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndRenderingKHR(commandBuffer, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceFeatures2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceFeatures2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceFeatures2KHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceFeatures2KHR(physicalDevice, pFeatures, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceFeatures2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceFeatures2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceFeatures2KHR(physicalDevice, pFeatures, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceFeatures2KHR");
        instance_dispatch->GetPhysicalDeviceFeatures2KHR(physicalDevice, pFeatures);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceFeatures2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceFeatures2KHR(physicalDevice, pFeatures, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceProperties2KHR(VkPhysicalDevice physicalDevice,
                                                           VkPhysicalDeviceProperties2* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceProperties2KHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceProperties2KHR(physicalDevice, pProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceProperties2KHR(physicalDevice, pProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceProperties2KHR");
        instance_dispatch->GetPhysicalDeviceProperties2KHR(physicalDevice, pProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceProperties2KHR(physicalDevice, pProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceFormatProperties2KHR(VkPhysicalDevice physicalDevice, VkFormat format,
                                                                 VkFormatProperties2* pFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceFormatProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceFormatProperties2KHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceFormatProperties2KHR(physicalDevice, format, pFormatProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceFormatProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceFormatProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceFormatProperties2KHR(physicalDevice, format, pFormatProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceFormatProperties2KHR");
        instance_dispatch->GetPhysicalDeviceFormatProperties2KHR(physicalDevice, format, pFormatProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceFormatProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceFormatProperties2KHR(physicalDevice, format, pFormatProperties, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceImageFormatProperties2KHR(VkPhysicalDevice physicalDevice,
                                                                          const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo,
                                                                          VkImageFormatProperties2* pImageFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceImageFormatProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceImageFormatProperties2KHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceImageFormatProperties2KHR(physicalDevice, pImageFormatInfo,
                                                                                  pImageFormatProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceImageFormatProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceImageFormatProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceImageFormatProperties2KHR(physicalDevice, pImageFormatInfo, pImageFormatProperties,
                                                                        record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceImageFormatProperties2KHR");
        result =
            instance_dispatch->GetPhysicalDeviceImageFormatProperties2KHR(physicalDevice, pImageFormatInfo, pImageFormatProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceImageFormatProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceImageFormatProperties2KHR(physicalDevice, pImageFormatInfo, pImageFormatProperties,
                                                                         record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceQueueFamilyProperties2KHR(VkPhysicalDevice physicalDevice,
                                                                      uint32_t* pQueueFamilyPropertyCount,
                                                                      VkQueueFamilyProperties2* pQueueFamilyProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceQueueFamilyProperties2KHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceQueueFamilyProperties2KHR(physicalDevice, pQueueFamilyPropertyCount,
                                                                                  pQueueFamilyProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceQueueFamilyProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceQueueFamilyProperties2KHR(physicalDevice, pQueueFamilyPropertyCount,
                                                                        pQueueFamilyProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceQueueFamilyProperties2KHR");
        instance_dispatch->GetPhysicalDeviceQueueFamilyProperties2KHR(physicalDevice, pQueueFamilyPropertyCount,
                                                                      pQueueFamilyProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceQueueFamilyProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceQueueFamilyProperties2KHR(physicalDevice, pQueueFamilyPropertyCount,
                                                                         pQueueFamilyProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceMemoryProperties2KHR(VkPhysicalDevice physicalDevice,
                                                                 VkPhysicalDeviceMemoryProperties2* pMemoryProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceMemoryProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceMemoryProperties2KHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceMemoryProperties2KHR(physicalDevice, pMemoryProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceMemoryProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceMemoryProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceMemoryProperties2KHR(physicalDevice, pMemoryProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceMemoryProperties2KHR");
        instance_dispatch->GetPhysicalDeviceMemoryProperties2KHR(physicalDevice, pMemoryProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceMemoryProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceMemoryProperties2KHR(physicalDevice, pMemoryProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceSparseImageFormatProperties2KHR(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount,
    VkSparseImageFormatProperties2* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSparseImageFormatProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceSparseImageFormatProperties2KHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceSparseImageFormatProperties2KHR(physicalDevice, pFormatInfo, pPropertyCount,
                                                                                        pProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSparseImageFormatProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceSparseImageFormatProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceSparseImageFormatProperties2KHR(physicalDevice, pFormatInfo, pPropertyCount,
                                                                              pProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceSparseImageFormatProperties2KHR");
        instance_dispatch->GetPhysicalDeviceSparseImageFormatProperties2KHR(physicalDevice, pFormatInfo, pPropertyCount,
                                                                            pProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceSparseImageFormatProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceSparseImageFormatProperties2KHR(physicalDevice, pFormatInfo, pPropertyCount,
                                                                               pProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceGroupPeerMemoryFeaturesKHR(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex,
                                                               uint32_t remoteDeviceIndex,
                                                               VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceGroupPeerMemoryFeaturesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceGroupPeerMemoryFeaturesKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceGroupPeerMemoryFeaturesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceGroupPeerMemoryFeaturesKHR(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                                           pPeerMemoryFeatures, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceGroupPeerMemoryFeaturesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceGroupPeerMemoryFeaturesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceGroupPeerMemoryFeaturesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceGroupPeerMemoryFeaturesKHR(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                                 pPeerMemoryFeatures, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceGroupPeerMemoryFeaturesKHR");
        device_dispatch->GetDeviceGroupPeerMemoryFeaturesKHR(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                             pPeerMemoryFeatures);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceGroupPeerMemoryFeaturesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceGroupPeerMemoryFeaturesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceGroupPeerMemoryFeaturesKHR(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                                  pPeerMemoryFeatures, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDeviceMaskKHR(VkCommandBuffer commandBuffer, uint32_t deviceMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDeviceMaskKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetDeviceMaskKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDeviceMaskKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDeviceMaskKHR(commandBuffer, deviceMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDeviceMaskKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetDeviceMaskKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDeviceMaskKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDeviceMaskKHR(commandBuffer, deviceMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetDeviceMaskKHR");
        device_dispatch->CmdSetDeviceMaskKHR(commandBuffer, deviceMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetDeviceMaskKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDeviceMaskKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDeviceMaskKHR(commandBuffer, deviceMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDispatchBaseKHR(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY,
                                              uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY,
                                              uint32_t groupCountZ) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDispatchBaseKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDispatchBaseKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDispatchBaseKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDispatchBaseKHR(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX,
                                                          groupCountY, groupCountZ, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDispatchBaseKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDispatchBaseKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDispatchBaseKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDispatchBaseKHR(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY,
                                                groupCountZ, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDispatchBaseKHR");
        device_dispatch->CmdDispatchBaseKHR(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY,
                                            groupCountZ);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDispatchBaseKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDispatchBaseKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDispatchBaseKHR(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY,
                                                 groupCountZ, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL TrimCommandPoolKHR(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkTrimCommandPoolKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkTrimCommandPoolKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateTrimCommandPoolKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateTrimCommandPoolKHR(device, commandPool, flags, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkTrimCommandPoolKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkTrimCommandPoolKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordTrimCommandPoolKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordTrimCommandPoolKHR(device, commandPool, flags, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkTrimCommandPoolKHR");
        device_dispatch->TrimCommandPoolKHR(device, commandPool, flags);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkTrimCommandPoolKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordTrimCommandPoolKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordTrimCommandPoolKHR(device, commandPool, flags, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL EnumeratePhysicalDeviceGroupsKHR(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount,
                                                                VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkEnumeratePhysicalDeviceGroupsKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkEnumeratePhysicalDeviceGroupsKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateEnumeratePhysicalDeviceGroupsKHR(instance, pPhysicalDeviceGroupCount,
                                                                        pPhysicalDeviceGroupProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkEnumeratePhysicalDeviceGroupsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkEnumeratePhysicalDeviceGroupsKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordEnumeratePhysicalDeviceGroupsKHR(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties,
                                                              record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkEnumeratePhysicalDeviceGroupsKHR");
        result = instance_dispatch->EnumeratePhysicalDeviceGroupsKHR(instance, pPhysicalDeviceGroupCount,
                                                                     pPhysicalDeviceGroupProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkEnumeratePhysicalDeviceGroupsKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordEnumeratePhysicalDeviceGroupsKHR(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties,
                                                               record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceExternalBufferPropertiesKHR(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo,
    VkExternalBufferProperties* pExternalBufferProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceExternalBufferPropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceExternalBufferPropertiesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceExternalBufferPropertiesKHR(physicalDevice, pExternalBufferInfo,
                                                                                    pExternalBufferProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceExternalBufferPropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceExternalBufferPropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceExternalBufferPropertiesKHR(physicalDevice, pExternalBufferInfo,
                                                                          pExternalBufferProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceExternalBufferPropertiesKHR");
        instance_dispatch->GetPhysicalDeviceExternalBufferPropertiesKHR(physicalDevice, pExternalBufferInfo,
                                                                        pExternalBufferProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceExternalBufferPropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceExternalBufferPropertiesKHR(physicalDevice, pExternalBufferInfo,
                                                                           pExternalBufferProperties, record_obj);
        }
    }
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL GetMemoryWin32HandleKHR(VkDevice device, const VkMemoryGetWin32HandleInfoKHR* pGetWin32HandleInfo,
                                                       HANDLE* pHandle) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryWin32HandleKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetMemoryWin32HandleKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryWin32HandleKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetMemoryWin32HandleKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetMemoryWin32HandleKHR");
        result = device_dispatch->GetMemoryWin32HandleKHR(device, pGetWin32HandleInfo, pHandle);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetMemoryWin32HandleKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetMemoryWin32HandlePropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType,
                                                                 HANDLE handle,
                                                                 VkMemoryWin32HandlePropertiesKHR* pMemoryWin32HandleProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryWin32HandlePropertiesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetMemoryWin32HandlePropertiesKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryWin32HandlePropertiesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryWin32HandlePropertiesKHR(device, handleType, handle, pMemoryWin32HandleProperties,
                                                                         error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryWin32HandlePropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetMemoryWin32HandlePropertiesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryWin32HandlePropertiesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryWin32HandlePropertiesKHR(device, handleType, handle, pMemoryWin32HandleProperties,
                                                               record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetMemoryWin32HandlePropertiesKHR");
        result = device_dispatch->GetMemoryWin32HandlePropertiesKHR(device, handleType, handle, pMemoryWin32HandleProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetMemoryWin32HandlePropertiesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryWin32HandlePropertiesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryWin32HandlePropertiesKHR(device, handleType, handle, pMemoryWin32HandleProperties,
                                                                record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL GetMemoryFdKHR(VkDevice device, const VkMemoryGetFdInfoKHR* pGetFdInfo, int* pFd) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryFdKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetMemoryFdKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryFdKHR(device, pGetFdInfo, pFd, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryFdKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetMemoryFdKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryFdKHR(device, pGetFdInfo, pFd, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetMemoryFdKHR");
        result = device_dispatch->GetMemoryFdKHR(device, pGetFdInfo, pFd);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetMemoryFdKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryFdKHR(device, pGetFdInfo, pFd, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetMemoryFdPropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, int fd,
                                                        VkMemoryFdPropertiesKHR* pMemoryFdProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryFdPropertiesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetMemoryFdPropertiesKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryFdPropertiesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryFdPropertiesKHR(device, handleType, fd, pMemoryFdProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryFdPropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetMemoryFdPropertiesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryFdPropertiesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryFdPropertiesKHR(device, handleType, fd, pMemoryFdProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetMemoryFdPropertiesKHR");
        result = device_dispatch->GetMemoryFdPropertiesKHR(device, handleType, fd, pMemoryFdProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetMemoryFdPropertiesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryFdPropertiesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryFdPropertiesKHR(device, handleType, fd, pMemoryFdProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceExternalSemaphorePropertiesKHR(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo,
    VkExternalSemaphoreProperties* pExternalSemaphoreProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceExternalSemaphorePropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceExternalSemaphorePropertiesKHR(physicalDevice, pExternalSemaphoreInfo,
                                                                                       pExternalSemaphoreProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceExternalSemaphorePropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceExternalSemaphorePropertiesKHR(physicalDevice, pExternalSemaphoreInfo,
                                                                             pExternalSemaphoreProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR");
        instance_dispatch->GetPhysicalDeviceExternalSemaphorePropertiesKHR(physicalDevice, pExternalSemaphoreInfo,
                                                                           pExternalSemaphoreProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceExternalSemaphorePropertiesKHR(physicalDevice, pExternalSemaphoreInfo,
                                                                              pExternalSemaphoreProperties, record_obj);
        }
    }
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL
ImportSemaphoreWin32HandleKHR(VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR* pImportSemaphoreWin32HandleInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkImportSemaphoreWin32HandleKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkImportSemaphoreWin32HandleKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateImportSemaphoreWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateImportSemaphoreWin32HandleKHR(device, pImportSemaphoreWin32HandleInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkImportSemaphoreWin32HandleKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkImportSemaphoreWin32HandleKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordImportSemaphoreWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordImportSemaphoreWin32HandleKHR(device, pImportSemaphoreWin32HandleInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkImportSemaphoreWin32HandleKHR");
        result = device_dispatch->ImportSemaphoreWin32HandleKHR(device, pImportSemaphoreWin32HandleInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkImportSemaphoreWin32HandleKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordImportSemaphoreWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordImportSemaphoreWin32HandleKHR(device, pImportSemaphoreWin32HandleInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetSemaphoreWin32HandleKHR(VkDevice device,
                                                          const VkSemaphoreGetWin32HandleInfoKHR* pGetWin32HandleInfo,
                                                          HANDLE* pHandle) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSemaphoreWin32HandleKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetSemaphoreWin32HandleKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSemaphoreWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSemaphoreWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSemaphoreWin32HandleKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetSemaphoreWin32HandleKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSemaphoreWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSemaphoreWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetSemaphoreWin32HandleKHR");
        result = device_dispatch->GetSemaphoreWin32HandleKHR(device, pGetWin32HandleInfo, pHandle);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetSemaphoreWin32HandleKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSemaphoreWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetSemaphoreWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL ImportSemaphoreFdKHR(VkDevice device, const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkImportSemaphoreFdKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkImportSemaphoreFdKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateImportSemaphoreFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateImportSemaphoreFdKHR(device, pImportSemaphoreFdInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkImportSemaphoreFdKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkImportSemaphoreFdKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordImportSemaphoreFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordImportSemaphoreFdKHR(device, pImportSemaphoreFdInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkImportSemaphoreFdKHR");
        result = device_dispatch->ImportSemaphoreFdKHR(device, pImportSemaphoreFdInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkImportSemaphoreFdKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordImportSemaphoreFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordImportSemaphoreFdKHR(device, pImportSemaphoreFdInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetSemaphoreFdKHR(VkDevice device, const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSemaphoreFdKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetSemaphoreFdKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSemaphoreFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSemaphoreFdKHR(device, pGetFdInfo, pFd, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSemaphoreFdKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetSemaphoreFdKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSemaphoreFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSemaphoreFdKHR(device, pGetFdInfo, pFd, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetSemaphoreFdKHR");
        result = device_dispatch->GetSemaphoreFdKHR(device, pGetFdInfo, pFd);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetSemaphoreFdKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSemaphoreFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetSemaphoreFdKHR(device, pGetFdInfo, pFd, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSetKHR(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint,
                                                   VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount,
                                                   const VkWriteDescriptorSet* pDescriptorWrites) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSetKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdPushDescriptorSetKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSetKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushDescriptorSetKHR(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                                               pDescriptorWrites, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSetKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdPushDescriptorSetKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSetKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSetKHR(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                                     pDescriptorWrites, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdPushDescriptorSetKHR");
        device_dispatch->CmdPushDescriptorSetKHR(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                                 pDescriptorWrites);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdPushDescriptorSetKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSetKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSetKHR(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                                      pDescriptorWrites, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSetWithTemplateKHR(VkCommandBuffer commandBuffer,
                                                               VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                                               VkPipelineLayout layout, uint32_t set, const void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplateKHR,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdPushDescriptorSetWithTemplateKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSetWithTemplateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushDescriptorSetWithTemplateKHR(commandBuffer, descriptorUpdateTemplate, layout, set,
                                                                           pData, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplateKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdPushDescriptorSetWithTemplateKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSetWithTemplateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSetWithTemplateKHR(commandBuffer, descriptorUpdateTemplate, layout, set, pData,
                                                                 record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdPushDescriptorSetWithTemplateKHR");
        device_dispatch->CmdPushDescriptorSetWithTemplateKHR(commandBuffer, descriptorUpdateTemplate, layout, set, pData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdPushDescriptorSetWithTemplateKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSetWithTemplateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSetWithTemplateKHR(commandBuffer, descriptorUpdateTemplate, layout, set, pData,
                                                                  record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDescriptorUpdateTemplateKHR(VkDevice device,
                                                                 const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo,
                                                                 const VkAllocationCallbacks* pAllocator,
                                                                 VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDescriptorUpdateTemplateKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateDescriptorUpdateTemplateKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateDescriptorUpdateTemplateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDescriptorUpdateTemplateKHR(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate,
                                                                         error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDescriptorUpdateTemplateKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateDescriptorUpdateTemplateKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateDescriptorUpdateTemplateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDescriptorUpdateTemplateKHR(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate,
                                                               record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateDescriptorUpdateTemplateKHR");
        result = device_dispatch->CreateDescriptorUpdateTemplateKHR(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateDescriptorUpdateTemplateKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateDescriptorUpdateTemplateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDescriptorUpdateTemplateKHR(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate,
                                                                record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyDescriptorUpdateTemplateKHR(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                                              const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyDescriptorUpdateTemplateKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyDescriptorUpdateTemplateKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyDescriptorUpdateTemplateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyDescriptorUpdateTemplateKHR(device, descriptorUpdateTemplate, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyDescriptorUpdateTemplateKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyDescriptorUpdateTemplateKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyDescriptorUpdateTemplateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyDescriptorUpdateTemplateKHR(device, descriptorUpdateTemplate, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyDescriptorUpdateTemplateKHR");
        device_dispatch->DestroyDescriptorUpdateTemplateKHR(device, descriptorUpdateTemplate, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyDescriptorUpdateTemplateKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyDescriptorUpdateTemplateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyDescriptorUpdateTemplateKHR(device, descriptorUpdateTemplate, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL UpdateDescriptorSetWithTemplateKHR(VkDevice device, VkDescriptorSet descriptorSet,
                                                              VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                                              const void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUpdateDescriptorSetWithTemplateKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkUpdateDescriptorSetWithTemplateKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUpdateDescriptorSetWithTemplateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUpdateDescriptorSetWithTemplateKHR(device, descriptorSet, descriptorUpdateTemplate, pData,
                                                                          error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkUpdateDescriptorSetWithTemplateKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkUpdateDescriptorSetWithTemplateKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUpdateDescriptorSetWithTemplateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordUpdateDescriptorSetWithTemplateKHR(device, descriptorSet, descriptorUpdateTemplate, pData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkUpdateDescriptorSetWithTemplateKHR");
        device_dispatch->UpdateDescriptorSetWithTemplateKHR(device, descriptorSet, descriptorUpdateTemplate, pData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkUpdateDescriptorSetWithTemplateKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUpdateDescriptorSetWithTemplateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordUpdateDescriptorSetWithTemplateKHR(device, descriptorSet, descriptorUpdateTemplate, pData,
                                                                 record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateRenderPass2KHR(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo,
                                                    const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateRenderPass2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateRenderPass2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateRenderPass2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateRenderPass2KHR(device, pCreateInfo, pAllocator, pRenderPass, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateRenderPass2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateRenderPass2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateRenderPass2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateRenderPass2KHR(device, pCreateInfo, pAllocator, pRenderPass, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateRenderPass2KHR");
        result = device_dispatch->CreateRenderPass2KHR(device, pCreateInfo, pAllocator, pRenderPass);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateRenderPass2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateRenderPass2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateRenderPass2KHR(device, pCreateInfo, pAllocator, pRenderPass, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdBeginRenderPass2KHR(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin,
                                                  const VkSubpassBeginInfo* pSubpassBeginInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginRenderPass2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBeginRenderPass2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginRenderPass2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginRenderPass2KHR(commandBuffer, pRenderPassBegin, pSubpassBeginInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginRenderPass2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBeginRenderPass2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginRenderPass2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginRenderPass2KHR(commandBuffer, pRenderPassBegin, pSubpassBeginInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBeginRenderPass2KHR");
        device_dispatch->CmdBeginRenderPass2KHR(commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBeginRenderPass2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginRenderPass2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginRenderPass2KHR(commandBuffer, pRenderPassBegin, pSubpassBeginInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdNextSubpass2KHR(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo,
                                              const VkSubpassEndInfo* pSubpassEndInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdNextSubpass2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdNextSubpass2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdNextSubpass2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdNextSubpass2KHR(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdNextSubpass2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdNextSubpass2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdNextSubpass2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdNextSubpass2KHR(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdNextSubpass2KHR");
        device_dispatch->CmdNextSubpass2KHR(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdNextSubpass2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdNextSubpass2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdNextSubpass2KHR(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndRenderPass2KHR(VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndRenderPass2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdEndRenderPass2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndRenderPass2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndRenderPass2KHR(commandBuffer, pSubpassEndInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndRenderPass2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdEndRenderPass2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndRenderPass2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndRenderPass2KHR(commandBuffer, pSubpassEndInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdEndRenderPass2KHR");
        device_dispatch->CmdEndRenderPass2KHR(commandBuffer, pSubpassEndInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdEndRenderPass2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndRenderPass2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndRenderPass2KHR(commandBuffer, pSubpassEndInfo, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetSwapchainStatusKHR(VkDevice device, VkSwapchainKHR swapchain) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSwapchainStatusKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetSwapchainStatusKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSwapchainStatusKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSwapchainStatusKHR(device, swapchain, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSwapchainStatusKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetSwapchainStatusKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSwapchainStatusKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSwapchainStatusKHR(device, swapchain, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetSwapchainStatusKHR");
        result = device_dispatch->GetSwapchainStatusKHR(device, swapchain);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetSwapchainStatusKHR");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSwapchainStatusKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetSwapchainStatusKHR(device, swapchain, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceExternalFencePropertiesKHR(VkPhysicalDevice physicalDevice,
                                                                       const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo,
                                                                       VkExternalFenceProperties* pExternalFenceProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceExternalFencePropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceExternalFencePropertiesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceExternalFencePropertiesKHR(physicalDevice, pExternalFenceInfo,
                                                                                   pExternalFenceProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceExternalFencePropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceExternalFencePropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceExternalFencePropertiesKHR(physicalDevice, pExternalFenceInfo,
                                                                         pExternalFenceProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceExternalFencePropertiesKHR");
        instance_dispatch->GetPhysicalDeviceExternalFencePropertiesKHR(physicalDevice, pExternalFenceInfo,
                                                                       pExternalFenceProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceExternalFencePropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceExternalFencePropertiesKHR(physicalDevice, pExternalFenceInfo,
                                                                          pExternalFenceProperties, record_obj);
        }
    }
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL ImportFenceWin32HandleKHR(VkDevice device,
                                                         const VkImportFenceWin32HandleInfoKHR* pImportFenceWin32HandleInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkImportFenceWin32HandleKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkImportFenceWin32HandleKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateImportFenceWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateImportFenceWin32HandleKHR(device, pImportFenceWin32HandleInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkImportFenceWin32HandleKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkImportFenceWin32HandleKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordImportFenceWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordImportFenceWin32HandleKHR(device, pImportFenceWin32HandleInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkImportFenceWin32HandleKHR");
        result = device_dispatch->ImportFenceWin32HandleKHR(device, pImportFenceWin32HandleInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkImportFenceWin32HandleKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordImportFenceWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordImportFenceWin32HandleKHR(device, pImportFenceWin32HandleInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetFenceWin32HandleKHR(VkDevice device, const VkFenceGetWin32HandleInfoKHR* pGetWin32HandleInfo,
                                                      HANDLE* pHandle) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetFenceWin32HandleKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetFenceWin32HandleKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetFenceWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetFenceWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetFenceWin32HandleKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetFenceWin32HandleKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetFenceWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetFenceWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetFenceWin32HandleKHR");
        result = device_dispatch->GetFenceWin32HandleKHR(device, pGetWin32HandleInfo, pHandle);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetFenceWin32HandleKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetFenceWin32HandleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetFenceWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL ImportFenceFdKHR(VkDevice device, const VkImportFenceFdInfoKHR* pImportFenceFdInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkImportFenceFdKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkImportFenceFdKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateImportFenceFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateImportFenceFdKHR(device, pImportFenceFdInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkImportFenceFdKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkImportFenceFdKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordImportFenceFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordImportFenceFdKHR(device, pImportFenceFdInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkImportFenceFdKHR");
        result = device_dispatch->ImportFenceFdKHR(device, pImportFenceFdInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkImportFenceFdKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordImportFenceFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordImportFenceFdKHR(device, pImportFenceFdInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetFenceFdKHR(VkDevice device, const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetFenceFdKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetFenceFdKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetFenceFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetFenceFdKHR(device, pGetFdInfo, pFd, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetFenceFdKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetFenceFdKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetFenceFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetFenceFdKHR(device, pGetFdInfo, pFd, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetFenceFdKHR");
        result = device_dispatch->GetFenceFdKHR(device, pGetFdInfo, pFd);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetFenceFdKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetFenceFdKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetFenceFdKHR(device, pGetFdInfo, pFd, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(
    VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, uint32_t* pCounterCount, VkPerformanceCounterKHR* pCounters,
    VkPerformanceCounterDescriptionKHR* pCounterDescriptions) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(
                physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(
                physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR");
        result = instance_dispatch->EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(
            physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(
                physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(
    VkPhysicalDevice physicalDevice, const VkQueryPoolPerformanceCreateInfoKHR* pPerformanceQueryCreateInfo, uint32_t* pNumPasses) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(
                physicalDevice, pPerformanceQueryCreateInfo, pNumPasses, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(physicalDevice, pPerformanceQueryCreateInfo,
                                                                                   pNumPasses, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR");
        instance_dispatch->GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(physicalDevice, pPerformanceQueryCreateInfo,
                                                                                 pNumPasses);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(physicalDevice, pPerformanceQueryCreateInfo,
                                                                                    pNumPasses, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL AcquireProfilingLockKHR(VkDevice device, const VkAcquireProfilingLockInfoKHR* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAcquireProfilingLockKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkAcquireProfilingLockKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateAcquireProfilingLockKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAcquireProfilingLockKHR(device, pInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAcquireProfilingLockKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkAcquireProfilingLockKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordAcquireProfilingLockKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordAcquireProfilingLockKHR(device, pInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkAcquireProfilingLockKHR");
        result = device_dispatch->AcquireProfilingLockKHR(device, pInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkAcquireProfilingLockKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordAcquireProfilingLockKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordAcquireProfilingLockKHR(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL ReleaseProfilingLockKHR(VkDevice device) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkReleaseProfilingLockKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkReleaseProfilingLockKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateReleaseProfilingLockKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateReleaseProfilingLockKHR(device, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkReleaseProfilingLockKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkReleaseProfilingLockKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordReleaseProfilingLockKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordReleaseProfilingLockKHR(device, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkReleaseProfilingLockKHR");
        device_dispatch->ReleaseProfilingLockKHR(device);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkReleaseProfilingLockKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordReleaseProfilingLockKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordReleaseProfilingLockKHR(device, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfaceCapabilities2KHR(VkPhysicalDevice physicalDevice,
                                                                        const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo,
                                                                        VkSurfaceCapabilities2KHR* pSurfaceCapabilities) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfaceCapabilities2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceSurfaceCapabilities2KHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfaceCapabilities2KHR(physicalDevice, pSurfaceInfo, pSurfaceCapabilities,
                                                                                error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfaceCapabilities2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceSurfaceCapabilities2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceSurfaceCapabilities2KHR(physicalDevice, pSurfaceInfo, pSurfaceCapabilities,
                                                                      record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceSurfaceCapabilities2KHR");
        result = instance_dispatch->GetPhysicalDeviceSurfaceCapabilities2KHR(physicalDevice, pSurfaceInfo, pSurfaceCapabilities);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceSurfaceCapabilities2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceSurfaceCapabilities2KHR(physicalDevice, pSurfaceInfo, pSurfaceCapabilities,
                                                                       record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfaceFormats2KHR(VkPhysicalDevice physicalDevice,
                                                                   const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo,
                                                                   uint32_t* pSurfaceFormatCount,
                                                                   VkSurfaceFormat2KHR* pSurfaceFormats) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfaceFormats2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceSurfaceFormats2KHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfaceFormats2KHR(physicalDevice, pSurfaceInfo, pSurfaceFormatCount,
                                                                           pSurfaceFormats, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfaceFormats2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceSurfaceFormats2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceSurfaceFormats2KHR(physicalDevice, pSurfaceInfo, pSurfaceFormatCount, pSurfaceFormats,
                                                                 record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceSurfaceFormats2KHR");
        result = instance_dispatch->GetPhysicalDeviceSurfaceFormats2KHR(physicalDevice, pSurfaceInfo, pSurfaceFormatCount,
                                                                        pSurfaceFormats);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceSurfaceFormats2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceSurfaceFormats2KHR(physicalDevice, pSurfaceInfo, pSurfaceFormatCount,
                                                                  pSurfaceFormats, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceDisplayProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount,
                                                                      VkDisplayProperties2KHR* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceDisplayProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceDisplayProperties2KHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |=
                vo->PreCallValidateGetPhysicalDeviceDisplayProperties2KHR(physicalDevice, pPropertyCount, pProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceDisplayProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceDisplayProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceDisplayProperties2KHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceDisplayProperties2KHR");
        result = instance_dispatch->GetPhysicalDeviceDisplayProperties2KHR(physicalDevice, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceDisplayProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceDisplayProperties2KHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceDisplayPlaneProperties2KHR(VkPhysicalDevice physicalDevice,
                                                                           uint32_t* pPropertyCount,
                                                                           VkDisplayPlaneProperties2KHR* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceDisplayPlaneProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceDisplayPlaneProperties2KHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceDisplayPlaneProperties2KHR(physicalDevice, pPropertyCount, pProperties,
                                                                                   error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceDisplayPlaneProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceDisplayPlaneProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceDisplayPlaneProperties2KHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceDisplayPlaneProperties2KHR");
        result = instance_dispatch->GetPhysicalDeviceDisplayPlaneProperties2KHR(physicalDevice, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceDisplayPlaneProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceDisplayPlaneProperties2KHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDisplayModeProperties2KHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display,
                                                            uint32_t* pPropertyCount, VkDisplayModeProperties2KHR* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDisplayModeProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDisplayModeProperties2KHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |=
                vo->PreCallValidateGetDisplayModeProperties2KHR(physicalDevice, display, pPropertyCount, pProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDisplayModeProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDisplayModeProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetDisplayModeProperties2KHR(physicalDevice, display, pPropertyCount, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetDisplayModeProperties2KHR");
        result = instance_dispatch->GetDisplayModeProperties2KHR(physicalDevice, display, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDisplayModeProperties2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetDisplayModeProperties2KHR(physicalDevice, display, pPropertyCount, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDisplayPlaneCapabilities2KHR(VkPhysicalDevice physicalDevice,
                                                               const VkDisplayPlaneInfo2KHR* pDisplayPlaneInfo,
                                                               VkDisplayPlaneCapabilities2KHR* pCapabilities) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDisplayPlaneCapabilities2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDisplayPlaneCapabilities2KHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetDisplayPlaneCapabilities2KHR(physicalDevice, pDisplayPlaneInfo, pCapabilities, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDisplayPlaneCapabilities2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDisplayPlaneCapabilities2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetDisplayPlaneCapabilities2KHR(physicalDevice, pDisplayPlaneInfo, pCapabilities, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetDisplayPlaneCapabilities2KHR");
        result = instance_dispatch->GetDisplayPlaneCapabilities2KHR(physicalDevice, pDisplayPlaneInfo, pCapabilities);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDisplayPlaneCapabilities2KHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetDisplayPlaneCapabilities2KHR(physicalDevice, pDisplayPlaneInfo, pCapabilities, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetImageMemoryRequirements2KHR(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo,
                                                          VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageMemoryRequirements2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetImageMemoryRequirements2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageMemoryRequirements2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageMemoryRequirements2KHR(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageMemoryRequirements2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetImageMemoryRequirements2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageMemoryRequirements2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageMemoryRequirements2KHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetImageMemoryRequirements2KHR");
        device_dispatch->GetImageMemoryRequirements2KHR(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetImageMemoryRequirements2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageMemoryRequirements2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageMemoryRequirements2KHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetBufferMemoryRequirements2KHR(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo,
                                                           VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferMemoryRequirements2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetBufferMemoryRequirements2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferMemoryRequirements2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferMemoryRequirements2KHR(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferMemoryRequirements2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetBufferMemoryRequirements2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferMemoryRequirements2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferMemoryRequirements2KHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetBufferMemoryRequirements2KHR");
        device_dispatch->GetBufferMemoryRequirements2KHR(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetBufferMemoryRequirements2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferMemoryRequirements2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferMemoryRequirements2KHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetImageSparseMemoryRequirements2KHR(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo,
                                                                uint32_t* pSparseMemoryRequirementCount,
                                                                VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageSparseMemoryRequirements2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetImageSparseMemoryRequirements2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageSparseMemoryRequirements2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageSparseMemoryRequirements2KHR(device, pInfo, pSparseMemoryRequirementCount,
                                                                            pSparseMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageSparseMemoryRequirements2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetImageSparseMemoryRequirements2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageSparseMemoryRequirements2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageSparseMemoryRequirements2KHR(device, pInfo, pSparseMemoryRequirementCount,
                                                                  pSparseMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetImageSparseMemoryRequirements2KHR");
        device_dispatch->GetImageSparseMemoryRequirements2KHR(device, pInfo, pSparseMemoryRequirementCount,
                                                              pSparseMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetImageSparseMemoryRequirements2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageSparseMemoryRequirements2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageSparseMemoryRequirements2KHR(device, pInfo, pSparseMemoryRequirementCount,
                                                                   pSparseMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateSamplerYcbcrConversionKHR(VkDevice device,
                                                               const VkSamplerYcbcrConversionCreateInfo* pCreateInfo,
                                                               const VkAllocationCallbacks* pAllocator,
                                                               VkSamplerYcbcrConversion* pYcbcrConversion) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateSamplerYcbcrConversionKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateSamplerYcbcrConversionKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateSamplerYcbcrConversionKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCreateSamplerYcbcrConversionKHR(device, pCreateInfo, pAllocator, pYcbcrConversion, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateSamplerYcbcrConversionKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateSamplerYcbcrConversionKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateSamplerYcbcrConversionKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateSamplerYcbcrConversionKHR(device, pCreateInfo, pAllocator, pYcbcrConversion, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateSamplerYcbcrConversionKHR");
        result = device_dispatch->CreateSamplerYcbcrConversionKHR(device, pCreateInfo, pAllocator, pYcbcrConversion);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateSamplerYcbcrConversionKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateSamplerYcbcrConversionKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateSamplerYcbcrConversionKHR(device, pCreateInfo, pAllocator, pYcbcrConversion, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroySamplerYcbcrConversionKHR(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion,
                                                            const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroySamplerYcbcrConversionKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroySamplerYcbcrConversionKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroySamplerYcbcrConversionKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroySamplerYcbcrConversionKHR(device, ycbcrConversion, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroySamplerYcbcrConversionKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroySamplerYcbcrConversionKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroySamplerYcbcrConversionKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroySamplerYcbcrConversionKHR(device, ycbcrConversion, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroySamplerYcbcrConversionKHR");
        device_dispatch->DestroySamplerYcbcrConversionKHR(device, ycbcrConversion, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroySamplerYcbcrConversionKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroySamplerYcbcrConversionKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroySamplerYcbcrConversionKHR(device, ycbcrConversion, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL BindBufferMemory2KHR(VkDevice device, uint32_t bindInfoCount,
                                                    const VkBindBufferMemoryInfo* pBindInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindBufferMemory2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkBindBufferMemory2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindBufferMemory2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindBufferMemory2KHR(device, bindInfoCount, pBindInfos, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindBufferMemory2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkBindBufferMemory2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindBufferMemory2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindBufferMemory2KHR(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkBindBufferMemory2KHR");
        result = device_dispatch->BindBufferMemory2KHR(device, bindInfoCount, pBindInfos);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkBindBufferMemory2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindBufferMemory2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindBufferMemory2KHR(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL BindImageMemory2KHR(VkDevice device, uint32_t bindInfoCount,
                                                   const VkBindImageMemoryInfo* pBindInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindImageMemory2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkBindImageMemory2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindImageMemory2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindImageMemory2KHR(device, bindInfoCount, pBindInfos, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindImageMemory2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkBindImageMemory2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindImageMemory2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindImageMemory2KHR(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkBindImageMemory2KHR");
        result = device_dispatch->BindImageMemory2KHR(device, bindInfoCount, pBindInfos);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkBindImageMemory2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindImageMemory2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindImageMemory2KHR(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetDescriptorSetLayoutSupportKHR(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
                                                            VkDescriptorSetLayoutSupport* pSupport) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDescriptorSetLayoutSupportKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDescriptorSetLayoutSupportKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDescriptorSetLayoutSupportKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDescriptorSetLayoutSupportKHR(device, pCreateInfo, pSupport, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDescriptorSetLayoutSupportKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDescriptorSetLayoutSupportKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDescriptorSetLayoutSupportKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDescriptorSetLayoutSupportKHR(device, pCreateInfo, pSupport, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDescriptorSetLayoutSupportKHR");
        device_dispatch->GetDescriptorSetLayoutSupportKHR(device, pCreateInfo, pSupport);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDescriptorSetLayoutSupportKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDescriptorSetLayoutSupportKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDescriptorSetLayoutSupportKHR(device, pCreateInfo, pSupport, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                   VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount,
                                                   uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndirectCountKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDrawIndirectCountKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndirectCountKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                               maxDrawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndirectCountKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDrawIndirectCountKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndirectCountKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                     stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDrawIndirectCountKHR");
        device_dispatch->CmdDrawIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                 stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDrawIndirectCountKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndirectCountKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                      stride, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndexedIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                          VkBuffer countBuffer, VkDeviceSize countBufferOffset,
                                                          uint32_t maxDrawCount, uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndexedIndirectCountKHR,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDrawIndexedIndirectCountKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndexedIndirectCountKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndexedIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                                      maxDrawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndexedIndirectCountKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDrawIndexedIndirectCountKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndexedIndirectCountKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndexedIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                            maxDrawCount, stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDrawIndexedIndirectCountKHR");
        device_dispatch->CmdDrawIndexedIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                        stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDrawIndexedIndirectCountKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndexedIndirectCountKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndexedIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                             maxDrawCount, stride, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetSemaphoreCounterValueKHR(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSemaphoreCounterValueKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetSemaphoreCounterValueKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSemaphoreCounterValueKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSemaphoreCounterValueKHR(device, semaphore, pValue, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSemaphoreCounterValueKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetSemaphoreCounterValueKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSemaphoreCounterValueKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSemaphoreCounterValueKHR(device, semaphore, pValue, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetSemaphoreCounterValueKHR");
        result = device_dispatch->GetSemaphoreCounterValueKHR(device, semaphore, pValue);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetSemaphoreCounterValueKHR");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSemaphoreCounterValueKHR]) {
            if (!vo) {
                continue;
            }
            vvl::base::Device::BlockingOperationGuard lock(vo);
            vo->PostCallRecordGetSemaphoreCounterValueKHR(device, semaphore, pValue, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL WaitSemaphoresKHR(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkWaitSemaphoresKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkWaitSemaphoresKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateWaitSemaphoresKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateWaitSemaphoresKHR(device, pWaitInfo, timeout, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkWaitSemaphoresKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkWaitSemaphoresKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordWaitSemaphoresKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordWaitSemaphoresKHR(device, pWaitInfo, timeout, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkWaitSemaphoresKHR");
        result = device_dispatch->WaitSemaphoresKHR(device, pWaitInfo, timeout);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkWaitSemaphoresKHR");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordWaitSemaphoresKHR]) {
            if (!vo) {
                continue;
            }
            vvl::base::Device::BlockingOperationGuard lock(vo);
            vo->PostCallRecordWaitSemaphoresKHR(device, pWaitInfo, timeout, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL SignalSemaphoreKHR(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSignalSemaphoreKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkSignalSemaphoreKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSignalSemaphoreKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSignalSemaphoreKHR(device, pSignalInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkSignalSemaphoreKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkSignalSemaphoreKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSignalSemaphoreKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordSignalSemaphoreKHR(device, pSignalInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkSignalSemaphoreKHR");
        result = device_dispatch->SignalSemaphoreKHR(device, pSignalInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkSignalSemaphoreKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSignalSemaphoreKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordSignalSemaphoreKHR(device, pSignalInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL
GetPhysicalDeviceFragmentShadingRatesKHR(VkPhysicalDevice physicalDevice, uint32_t* pFragmentShadingRateCount,
                                         VkPhysicalDeviceFragmentShadingRateKHR* pFragmentShadingRates) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceFragmentShadingRatesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceFragmentShadingRatesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceFragmentShadingRatesKHR(physicalDevice, pFragmentShadingRateCount,
                                                                                pFragmentShadingRates, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceFragmentShadingRatesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceFragmentShadingRatesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceFragmentShadingRatesKHR(physicalDevice, pFragmentShadingRateCount,
                                                                      pFragmentShadingRates, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceFragmentShadingRatesKHR");
        result = instance_dispatch->GetPhysicalDeviceFragmentShadingRatesKHR(physicalDevice, pFragmentShadingRateCount,
                                                                             pFragmentShadingRates);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceFragmentShadingRatesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceFragmentShadingRatesKHR(physicalDevice, pFragmentShadingRateCount,
                                                                       pFragmentShadingRates, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdSetFragmentShadingRateKHR(VkCommandBuffer commandBuffer, const VkExtent2D* pFragmentSize,
                                                        const VkFragmentShadingRateCombinerOpKHR combinerOps[2]) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetFragmentShadingRateKHR,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetFragmentShadingRateKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetFragmentShadingRateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetFragmentShadingRateKHR(commandBuffer, pFragmentSize, combinerOps, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetFragmentShadingRateKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetFragmentShadingRateKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetFragmentShadingRateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetFragmentShadingRateKHR(commandBuffer, pFragmentSize, combinerOps, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetFragmentShadingRateKHR");
        device_dispatch->CmdSetFragmentShadingRateKHR(commandBuffer, pFragmentSize, combinerOps);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetFragmentShadingRateKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetFragmentShadingRateKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetFragmentShadingRateKHR(commandBuffer, pFragmentSize, combinerOps, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetRenderingAttachmentLocationsKHR(VkCommandBuffer commandBuffer,
                                                                 const VkRenderingAttachmentLocationInfo* pLocationInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetRenderingAttachmentLocationsKHR,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetRenderingAttachmentLocationsKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetRenderingAttachmentLocationsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetRenderingAttachmentLocationsKHR(commandBuffer, pLocationInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetRenderingAttachmentLocationsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetRenderingAttachmentLocationsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetRenderingAttachmentLocationsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetRenderingAttachmentLocationsKHR(commandBuffer, pLocationInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetRenderingAttachmentLocationsKHR");
        device_dispatch->CmdSetRenderingAttachmentLocationsKHR(commandBuffer, pLocationInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetRenderingAttachmentLocationsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetRenderingAttachmentLocationsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetRenderingAttachmentLocationsKHR(commandBuffer, pLocationInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetRenderingInputAttachmentIndicesKHR(
    VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetRenderingInputAttachmentIndicesKHR,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetRenderingInputAttachmentIndicesKHR");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetRenderingInputAttachmentIndicesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdSetRenderingInputAttachmentIndicesKHR(commandBuffer, pInputAttachmentIndexInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetRenderingInputAttachmentIndicesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetRenderingInputAttachmentIndicesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetRenderingInputAttachmentIndicesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetRenderingInputAttachmentIndicesKHR(commandBuffer, pInputAttachmentIndexInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetRenderingInputAttachmentIndicesKHR");
        device_dispatch->CmdSetRenderingInputAttachmentIndicesKHR(commandBuffer, pInputAttachmentIndexInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetRenderingInputAttachmentIndicesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetRenderingInputAttachmentIndicesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetRenderingInputAttachmentIndicesKHR(commandBuffer, pInputAttachmentIndexInfo, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL WaitForPresentKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t presentId, uint64_t timeout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkWaitForPresentKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkWaitForPresentKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateWaitForPresentKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateWaitForPresentKHR(device, swapchain, presentId, timeout, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkWaitForPresentKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkWaitForPresentKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordWaitForPresentKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordWaitForPresentKHR(device, swapchain, presentId, timeout, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkWaitForPresentKHR");
        result = device_dispatch->WaitForPresentKHR(device, swapchain, presentId, timeout);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkWaitForPresentKHR");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordWaitForPresentKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordWaitForPresentKHR(device, swapchain, presentId, timeout, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkDeviceAddress VKAPI_CALL GetBufferDeviceAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferDeviceAddressKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetBufferDeviceAddressKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferDeviceAddressKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferDeviceAddressKHR(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferDeviceAddressKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetBufferDeviceAddressKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferDeviceAddressKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferDeviceAddressKHR(device, pInfo, record_obj);
        }
    }
    VkDeviceAddress result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetBufferDeviceAddressKHR");
        result = device_dispatch->GetBufferDeviceAddressKHR(device, pInfo);
    }
    record_obj.device_address = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetBufferDeviceAddressKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferDeviceAddressKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferDeviceAddressKHR(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR uint64_t VKAPI_CALL GetBufferOpaqueCaptureAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferOpaqueCaptureAddressKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetBufferOpaqueCaptureAddressKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferOpaqueCaptureAddressKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferOpaqueCaptureAddressKHR(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferOpaqueCaptureAddressKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetBufferOpaqueCaptureAddressKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferOpaqueCaptureAddressKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferOpaqueCaptureAddressKHR(device, pInfo, record_obj);
        }
    }
    uint64_t result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetBufferOpaqueCaptureAddressKHR");
        result = device_dispatch->GetBufferOpaqueCaptureAddressKHR(device, pInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetBufferOpaqueCaptureAddressKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferOpaqueCaptureAddressKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferOpaqueCaptureAddressKHR(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR uint64_t VKAPI_CALL GetDeviceMemoryOpaqueCaptureAddressKHR(VkDevice device,
                                                                      const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceMemoryOpaqueCaptureAddressKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceMemoryOpaqueCaptureAddressKHR");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceMemoryOpaqueCaptureAddressKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceMemoryOpaqueCaptureAddressKHR(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceMemoryOpaqueCaptureAddressKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceMemoryOpaqueCaptureAddressKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceMemoryOpaqueCaptureAddressKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceMemoryOpaqueCaptureAddressKHR(device, pInfo, record_obj);
        }
    }
    uint64_t result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceMemoryOpaqueCaptureAddressKHR");
        result = device_dispatch->GetDeviceMemoryOpaqueCaptureAddressKHR(device, pInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceMemoryOpaqueCaptureAddressKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceMemoryOpaqueCaptureAddressKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceMemoryOpaqueCaptureAddressKHR(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDeferredOperationKHR(VkDevice device, const VkAllocationCallbacks* pAllocator,
                                                          VkDeferredOperationKHR* pDeferredOperation) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDeferredOperationKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateDeferredOperationKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateDeferredOperationKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDeferredOperationKHR(device, pAllocator, pDeferredOperation, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDeferredOperationKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateDeferredOperationKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateDeferredOperationKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDeferredOperationKHR(device, pAllocator, pDeferredOperation, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateDeferredOperationKHR");
        result = device_dispatch->CreateDeferredOperationKHR(device, pAllocator, pDeferredOperation);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateDeferredOperationKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateDeferredOperationKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDeferredOperationKHR(device, pAllocator, pDeferredOperation, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyDeferredOperationKHR(VkDevice device, VkDeferredOperationKHR operation,
                                                       const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyDeferredOperationKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyDeferredOperationKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyDeferredOperationKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyDeferredOperationKHR(device, operation, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyDeferredOperationKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyDeferredOperationKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyDeferredOperationKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyDeferredOperationKHR(device, operation, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyDeferredOperationKHR");
        device_dispatch->DestroyDeferredOperationKHR(device, operation, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyDeferredOperationKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyDeferredOperationKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyDeferredOperationKHR(device, operation, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR uint32_t VKAPI_CALL GetDeferredOperationMaxConcurrencyKHR(VkDevice device, VkDeferredOperationKHR operation) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeferredOperationMaxConcurrencyKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeferredOperationMaxConcurrencyKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeferredOperationMaxConcurrencyKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeferredOperationMaxConcurrencyKHR(device, operation, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeferredOperationMaxConcurrencyKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeferredOperationMaxConcurrencyKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeferredOperationMaxConcurrencyKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeferredOperationMaxConcurrencyKHR(device, operation, record_obj);
        }
    }
    uint32_t result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeferredOperationMaxConcurrencyKHR");
        result = device_dispatch->GetDeferredOperationMaxConcurrencyKHR(device, operation);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeferredOperationMaxConcurrencyKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeferredOperationMaxConcurrencyKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeferredOperationMaxConcurrencyKHR(device, operation, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDeferredOperationResultKHR(VkDevice device, VkDeferredOperationKHR operation) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeferredOperationResultKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeferredOperationResultKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeferredOperationResultKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeferredOperationResultKHR(device, operation, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeferredOperationResultKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeferredOperationResultKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeferredOperationResultKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeferredOperationResultKHR(device, operation, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeferredOperationResultKHR");
        result = device_dispatch->GetDeferredOperationResultKHR(device, operation);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeferredOperationResultKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeferredOperationResultKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeferredOperationResultKHR(device, operation, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL DeferredOperationJoinKHR(VkDevice device, VkDeferredOperationKHR operation) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDeferredOperationJoinKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDeferredOperationJoinKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDeferredOperationJoinKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDeferredOperationJoinKHR(device, operation, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkDeferredOperationJoinKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDeferredOperationJoinKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDeferredOperationJoinKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDeferredOperationJoinKHR(device, operation, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkDeferredOperationJoinKHR");
        result = device_dispatch->DeferredOperationJoinKHR(device, operation);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkDeferredOperationJoinKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDeferredOperationJoinKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDeferredOperationJoinKHR(device, operation, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPipelineExecutablePropertiesKHR(VkDevice device, const VkPipelineInfoKHR* pPipelineInfo,
                                                                  uint32_t* pExecutableCount,
                                                                  VkPipelineExecutablePropertiesKHR* pProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPipelineExecutablePropertiesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPipelineExecutablePropertiesKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPipelineExecutablePropertiesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPipelineExecutablePropertiesKHR(device, pPipelineInfo, pExecutableCount, pProperties,
                                                                          error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPipelineExecutablePropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPipelineExecutablePropertiesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPipelineExecutablePropertiesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPipelineExecutablePropertiesKHR(device, pPipelineInfo, pExecutableCount, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPipelineExecutablePropertiesKHR");
        result = device_dispatch->GetPipelineExecutablePropertiesKHR(device, pPipelineInfo, pExecutableCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPipelineExecutablePropertiesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPipelineExecutablePropertiesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPipelineExecutablePropertiesKHR(device, pPipelineInfo, pExecutableCount, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPipelineExecutableStatisticsKHR(VkDevice device,
                                                                  const VkPipelineExecutableInfoKHR* pExecutableInfo,
                                                                  uint32_t* pStatisticCount,
                                                                  VkPipelineExecutableStatisticKHR* pStatistics) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPipelineExecutableStatisticsKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPipelineExecutableStatisticsKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPipelineExecutableStatisticsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPipelineExecutableStatisticsKHR(device, pExecutableInfo, pStatisticCount, pStatistics,
                                                                          error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPipelineExecutableStatisticsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPipelineExecutableStatisticsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPipelineExecutableStatisticsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPipelineExecutableStatisticsKHR(device, pExecutableInfo, pStatisticCount, pStatistics, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPipelineExecutableStatisticsKHR");
        result = device_dispatch->GetPipelineExecutableStatisticsKHR(device, pExecutableInfo, pStatisticCount, pStatistics);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPipelineExecutableStatisticsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPipelineExecutableStatisticsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPipelineExecutableStatisticsKHR(device, pExecutableInfo, pStatisticCount, pStatistics, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPipelineExecutableInternalRepresentationsKHR(
    VkDevice device, const VkPipelineExecutableInfoKHR* pExecutableInfo, uint32_t* pInternalRepresentationCount,
    VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPipelineExecutableInternalRepresentationsKHR,
                          VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPipelineExecutableInternalRepresentationsKHR");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPipelineExecutableInternalRepresentationsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPipelineExecutableInternalRepresentationsKHR(
                device, pExecutableInfo, pInternalRepresentationCount, pInternalRepresentations, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPipelineExecutableInternalRepresentationsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPipelineExecutableInternalRepresentationsKHR");
        for (auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPipelineExecutableInternalRepresentationsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPipelineExecutableInternalRepresentationsKHR(device, pExecutableInfo, pInternalRepresentationCount,
                                                                             pInternalRepresentations, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPipelineExecutableInternalRepresentationsKHR");
        result = device_dispatch->GetPipelineExecutableInternalRepresentationsKHR(
            device, pExecutableInfo, pInternalRepresentationCount, pInternalRepresentations);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPipelineExecutableInternalRepresentationsKHR");
        for (auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPipelineExecutableInternalRepresentationsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPipelineExecutableInternalRepresentationsKHR(device, pExecutableInfo, pInternalRepresentationCount,
                                                                              pInternalRepresentations, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL MapMemory2KHR(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkMapMemory2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkMapMemory2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateMapMemory2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateMapMemory2KHR(device, pMemoryMapInfo, ppData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkMapMemory2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkMapMemory2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordMapMemory2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordMapMemory2KHR(device, pMemoryMapInfo, ppData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkMapMemory2KHR");
        result = device_dispatch->MapMemory2KHR(device, pMemoryMapInfo, ppData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkMapMemory2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordMapMemory2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordMapMemory2KHR(device, pMemoryMapInfo, ppData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL UnmapMemory2KHR(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUnmapMemory2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkUnmapMemory2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUnmapMemory2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUnmapMemory2KHR(device, pMemoryUnmapInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkUnmapMemory2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkUnmapMemory2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUnmapMemory2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordUnmapMemory2KHR(device, pMemoryUnmapInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkUnmapMemory2KHR");
        result = device_dispatch->UnmapMemory2KHR(device, pMemoryUnmapInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkUnmapMemory2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUnmapMemory2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordUnmapMemory2KHR(device, pMemoryUnmapInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR* pQualityLevelInfo,
    VkVideoEncodeQualityLevelPropertiesKHR* pQualityLevelProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(physicalDevice, pQualityLevelInfo,
                                                                                             pQualityLevelProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(physicalDevice, pQualityLevelInfo,
                                                                                   pQualityLevelProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR");
        result = instance_dispatch->GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(physicalDevice, pQualityLevelInfo,
                                                                                          pQualityLevelProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(physicalDevice, pQualityLevelInfo,
                                                                                    pQualityLevelProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL
GetEncodedVideoSessionParametersKHR(VkDevice device, const VkVideoEncodeSessionParametersGetInfoKHR* pVideoSessionParametersInfo,
                                    VkVideoEncodeSessionParametersFeedbackInfoKHR* pFeedbackInfo, size_t* pDataSize, void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetEncodedVideoSessionParametersKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetEncodedVideoSessionParametersKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetEncodedVideoSessionParametersKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetEncodedVideoSessionParametersKHR(device, pVideoSessionParametersInfo, pFeedbackInfo,
                                                                           pDataSize, pData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetEncodedVideoSessionParametersKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetEncodedVideoSessionParametersKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetEncodedVideoSessionParametersKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetEncodedVideoSessionParametersKHR(device, pVideoSessionParametersInfo, pFeedbackInfo, pDataSize,
                                                                 pData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetEncodedVideoSessionParametersKHR");
        result = device_dispatch->GetEncodedVideoSessionParametersKHR(device, pVideoSessionParametersInfo, pFeedbackInfo, pDataSize,
                                                                      pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetEncodedVideoSessionParametersKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetEncodedVideoSessionParametersKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetEncodedVideoSessionParametersKHR(device, pVideoSessionParametersInfo, pFeedbackInfo, pDataSize,
                                                                  pData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdEncodeVideoKHR(VkCommandBuffer commandBuffer, const VkVideoEncodeInfoKHR* pEncodeInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEncodeVideoKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdEncodeVideoKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEncodeVideoKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEncodeVideoKHR(commandBuffer, pEncodeInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEncodeVideoKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdEncodeVideoKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEncodeVideoKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEncodeVideoKHR(commandBuffer, pEncodeInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdEncodeVideoKHR");
        device_dispatch->CmdEncodeVideoKHR(commandBuffer, pEncodeInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdEncodeVideoKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEncodeVideoKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEncodeVideoKHR(commandBuffer, pEncodeInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetEvent2KHR(VkCommandBuffer commandBuffer, VkEvent event, const VkDependencyInfo* pDependencyInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetEvent2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetEvent2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetEvent2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetEvent2KHR(commandBuffer, event, pDependencyInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetEvent2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetEvent2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetEvent2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetEvent2KHR(commandBuffer, event, pDependencyInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetEvent2KHR");
        device_dispatch->CmdSetEvent2KHR(commandBuffer, event, pDependencyInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetEvent2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetEvent2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetEvent2KHR(commandBuffer, event, pDependencyInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdResetEvent2KHR(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags2 stageMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdResetEvent2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdResetEvent2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdResetEvent2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdResetEvent2KHR(commandBuffer, event, stageMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdResetEvent2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdResetEvent2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdResetEvent2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdResetEvent2KHR(commandBuffer, event, stageMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdResetEvent2KHR");
        device_dispatch->CmdResetEvent2KHR(commandBuffer, event, stageMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdResetEvent2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdResetEvent2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdResetEvent2KHR(commandBuffer, event, stageMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdWaitEvents2KHR(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents,
                                             const VkDependencyInfo* pDependencyInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWaitEvents2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdWaitEvents2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWaitEvents2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWaitEvents2KHR(commandBuffer, eventCount, pEvents, pDependencyInfos, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWaitEvents2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdWaitEvents2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWaitEvents2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWaitEvents2KHR(commandBuffer, eventCount, pEvents, pDependencyInfos, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdWaitEvents2KHR");
        device_dispatch->CmdWaitEvents2KHR(commandBuffer, eventCount, pEvents, pDependencyInfos);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdWaitEvents2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWaitEvents2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWaitEvents2KHR(commandBuffer, eventCount, pEvents, pDependencyInfos, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPipelineBarrier2KHR(VkCommandBuffer commandBuffer, const VkDependencyInfo* pDependencyInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPipelineBarrier2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdPipelineBarrier2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPipelineBarrier2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPipelineBarrier2KHR(commandBuffer, pDependencyInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPipelineBarrier2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdPipelineBarrier2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPipelineBarrier2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPipelineBarrier2KHR(commandBuffer, pDependencyInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdPipelineBarrier2KHR");
        device_dispatch->CmdPipelineBarrier2KHR(commandBuffer, pDependencyInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdPipelineBarrier2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPipelineBarrier2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPipelineBarrier2KHR(commandBuffer, pDependencyInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdWriteTimestamp2KHR(VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkQueryPool queryPool,
                                                 uint32_t query) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWriteTimestamp2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdWriteTimestamp2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWriteTimestamp2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWriteTimestamp2KHR(commandBuffer, stage, queryPool, query, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWriteTimestamp2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdWriteTimestamp2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWriteTimestamp2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWriteTimestamp2KHR(commandBuffer, stage, queryPool, query, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdWriteTimestamp2KHR");
        device_dispatch->CmdWriteTimestamp2KHR(commandBuffer, stage, queryPool, query);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdWriteTimestamp2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWriteTimestamp2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWriteTimestamp2KHR(commandBuffer, stage, queryPool, query, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL QueueSubmit2KHR(VkQueue queue, uint32_t submitCount, const VkSubmitInfo2* pSubmits, VkFence fence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueSubmit2KHR, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate_vkQueueSubmit2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueSubmit2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueSubmit2KHR(queue, submitCount, pSubmits, fence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueSubmit2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkQueueSubmit2KHR");
        VVL_TracyVkNamedZoneStart(GetTracyVkCtx(), queue, "gpu_PreCallRecordvkQueueSubmit2KHR", pre_call_record_gpu_zone);

        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueSubmit2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueSubmit2KHR(queue, submitCount, pSubmits, fence, record_obj);
        }

        VVL_TracyVkNamedZoneEnd(pre_call_record_gpu_zone, queue);
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkQueueSubmit2KHR");

        VVL_TracyVkNamedZoneStart(GetTracyVkCtx(), queue, "gpu_vkQueueSubmit2KHR", submit_gpu_zone);
        result = device_dispatch->QueueSubmit2KHR(queue, submitCount, pSubmits, fence);

        VVL_TracyVkNamedZoneEnd(submit_gpu_zone, queue);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkQueueSubmit2KHR");

        VVL_TracyVkNamedZoneStart(GetTracyVkCtx(), queue, "gpu_PostCallRecordvkQueueSubmit2KHR", post_call_record_gpu_zone);

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueSubmit2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordQueueSubmit2KHR(queue, submitCount, pSubmits, fence, record_obj);
        }

        VVL_TracyVkNamedZoneEnd(post_call_record_gpu_zone, queue);
    }
#if defined(VVL_TRACY_GPU)
    TracyVkCollector::TrySubmitCollectCb(queue);
#endif
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdCopyBuffer2KHR(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyBuffer2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyBuffer2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyBuffer2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyBuffer2KHR(commandBuffer, pCopyBufferInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyBuffer2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyBuffer2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyBuffer2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyBuffer2KHR(commandBuffer, pCopyBufferInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyBuffer2KHR");
        device_dispatch->CmdCopyBuffer2KHR(commandBuffer, pCopyBufferInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyBuffer2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyBuffer2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyBuffer2KHR(commandBuffer, pCopyBufferInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyImage2KHR(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyImage2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyImage2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyImage2KHR(commandBuffer, pCopyImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyImage2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyImage2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyImage2KHR(commandBuffer, pCopyImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyImage2KHR");
        device_dispatch->CmdCopyImage2KHR(commandBuffer, pCopyImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyImage2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyImage2KHR(commandBuffer, pCopyImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyBufferToImage2KHR(VkCommandBuffer commandBuffer,
                                                    const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyBufferToImage2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyBufferToImage2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyBufferToImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyBufferToImage2KHR(commandBuffer, pCopyBufferToImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyBufferToImage2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyBufferToImage2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyBufferToImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyBufferToImage2KHR(commandBuffer, pCopyBufferToImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyBufferToImage2KHR");
        device_dispatch->CmdCopyBufferToImage2KHR(commandBuffer, pCopyBufferToImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyBufferToImage2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyBufferToImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyBufferToImage2KHR(commandBuffer, pCopyBufferToImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyImageToBuffer2KHR(VkCommandBuffer commandBuffer,
                                                    const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyImageToBuffer2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyImageToBuffer2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyImageToBuffer2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyImageToBuffer2KHR(commandBuffer, pCopyImageToBufferInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyImageToBuffer2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyImageToBuffer2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyImageToBuffer2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyImageToBuffer2KHR(commandBuffer, pCopyImageToBufferInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyImageToBuffer2KHR");
        device_dispatch->CmdCopyImageToBuffer2KHR(commandBuffer, pCopyImageToBufferInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyImageToBuffer2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyImageToBuffer2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyImageToBuffer2KHR(commandBuffer, pCopyImageToBufferInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBlitImage2KHR(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBlitImage2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBlitImage2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBlitImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBlitImage2KHR(commandBuffer, pBlitImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBlitImage2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBlitImage2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBlitImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBlitImage2KHR(commandBuffer, pBlitImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBlitImage2KHR");
        device_dispatch->CmdBlitImage2KHR(commandBuffer, pBlitImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBlitImage2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBlitImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBlitImage2KHR(commandBuffer, pBlitImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdResolveImage2KHR(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdResolveImage2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdResolveImage2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdResolveImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdResolveImage2KHR(commandBuffer, pResolveImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdResolveImage2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdResolveImage2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdResolveImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdResolveImage2KHR(commandBuffer, pResolveImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdResolveImage2KHR");
        device_dispatch->CmdResolveImage2KHR(commandBuffer, pResolveImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdResolveImage2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdResolveImage2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdResolveImage2KHR(commandBuffer, pResolveImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdTraceRaysIndirect2KHR(VkCommandBuffer commandBuffer, VkDeviceAddress indirectDeviceAddress) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdTraceRaysIndirect2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdTraceRaysIndirect2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdTraceRaysIndirect2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdTraceRaysIndirect2KHR(commandBuffer, indirectDeviceAddress, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdTraceRaysIndirect2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdTraceRaysIndirect2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdTraceRaysIndirect2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdTraceRaysIndirect2KHR(commandBuffer, indirectDeviceAddress, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdTraceRaysIndirect2KHR");
        device_dispatch->CmdTraceRaysIndirect2KHR(commandBuffer, indirectDeviceAddress);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdTraceRaysIndirect2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdTraceRaysIndirect2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdTraceRaysIndirect2KHR(commandBuffer, indirectDeviceAddress, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceBufferMemoryRequirementsKHR(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo,
                                                                VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceBufferMemoryRequirementsKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceBufferMemoryRequirementsKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceBufferMemoryRequirementsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceBufferMemoryRequirementsKHR(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceBufferMemoryRequirementsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceBufferMemoryRequirementsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceBufferMemoryRequirementsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceBufferMemoryRequirementsKHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceBufferMemoryRequirementsKHR");
        device_dispatch->GetDeviceBufferMemoryRequirementsKHR(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceBufferMemoryRequirementsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceBufferMemoryRequirementsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceBufferMemoryRequirementsKHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceImageMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo,
                                                               VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceImageMemoryRequirementsKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceImageMemoryRequirementsKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceImageMemoryRequirementsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceImageMemoryRequirementsKHR(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceImageMemoryRequirementsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceImageMemoryRequirementsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceImageMemoryRequirementsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceImageMemoryRequirementsKHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceImageMemoryRequirementsKHR");
        device_dispatch->GetDeviceImageMemoryRequirementsKHR(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceImageMemoryRequirementsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceImageMemoryRequirementsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceImageMemoryRequirementsKHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceImageSparseMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo,
                                                                     uint32_t* pSparseMemoryRequirementCount,
                                                                     VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceImageSparseMemoryRequirementsKHR,
                          VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceImageSparseMemoryRequirementsKHR");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceImageSparseMemoryRequirementsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceImageSparseMemoryRequirementsKHR(device, pInfo, pSparseMemoryRequirementCount,
                                                                                 pSparseMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceImageSparseMemoryRequirementsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceImageSparseMemoryRequirementsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceImageSparseMemoryRequirementsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceImageSparseMemoryRequirementsKHR(device, pInfo, pSparseMemoryRequirementCount,
                                                                       pSparseMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceImageSparseMemoryRequirementsKHR");
        device_dispatch->GetDeviceImageSparseMemoryRequirementsKHR(device, pInfo, pSparseMemoryRequirementCount,
                                                                   pSparseMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceImageSparseMemoryRequirementsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceImageSparseMemoryRequirementsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceImageSparseMemoryRequirementsKHR(device, pInfo, pSparseMemoryRequirementCount,
                                                                        pSparseMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindIndexBuffer2KHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                  VkDeviceSize size, VkIndexType indexType) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindIndexBuffer2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBindIndexBuffer2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindIndexBuffer2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindIndexBuffer2KHR(commandBuffer, buffer, offset, size, indexType, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindIndexBuffer2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBindIndexBuffer2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindIndexBuffer2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindIndexBuffer2KHR(commandBuffer, buffer, offset, size, indexType, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBindIndexBuffer2KHR");
        device_dispatch->CmdBindIndexBuffer2KHR(commandBuffer, buffer, offset, size, indexType);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBindIndexBuffer2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindIndexBuffer2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindIndexBuffer2KHR(commandBuffer, buffer, offset, size, indexType, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetRenderingAreaGranularityKHR(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo,
                                                          VkExtent2D* pGranularity) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetRenderingAreaGranularityKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetRenderingAreaGranularityKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetRenderingAreaGranularityKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetRenderingAreaGranularityKHR(device, pRenderingAreaInfo, pGranularity, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetRenderingAreaGranularityKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetRenderingAreaGranularityKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetRenderingAreaGranularityKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetRenderingAreaGranularityKHR(device, pRenderingAreaInfo, pGranularity, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetRenderingAreaGranularityKHR");
        device_dispatch->GetRenderingAreaGranularityKHR(device, pRenderingAreaInfo, pGranularity);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetRenderingAreaGranularityKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetRenderingAreaGranularityKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetRenderingAreaGranularityKHR(device, pRenderingAreaInfo, pGranularity, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceImageSubresourceLayoutKHR(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo,
                                                              VkSubresourceLayout2* pLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceImageSubresourceLayoutKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetDeviceImageSubresourceLayoutKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceImageSubresourceLayoutKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceImageSubresourceLayoutKHR(device, pInfo, pLayout, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceImageSubresourceLayoutKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetDeviceImageSubresourceLayoutKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceImageSubresourceLayoutKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceImageSubresourceLayoutKHR(device, pInfo, pLayout, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetDeviceImageSubresourceLayoutKHR");
        device_dispatch->GetDeviceImageSubresourceLayoutKHR(device, pInfo, pLayout);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetDeviceImageSubresourceLayoutKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceImageSubresourceLayoutKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceImageSubresourceLayoutKHR(device, pInfo, pLayout, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetImageSubresourceLayout2KHR(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource,
                                                         VkSubresourceLayout2* pLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageSubresourceLayout2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetImageSubresourceLayout2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageSubresourceLayout2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageSubresourceLayout2KHR(device, image, pSubresource, pLayout, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageSubresourceLayout2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetImageSubresourceLayout2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageSubresourceLayout2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageSubresourceLayout2KHR(device, image, pSubresource, pLayout, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetImageSubresourceLayout2KHR");
        device_dispatch->GetImageSubresourceLayout2KHR(device, image, pSubresource, pLayout);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetImageSubresourceLayout2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageSubresourceLayout2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageSubresourceLayout2KHR(device, image, pSubresource, pLayout, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL WaitForPresent2KHR(VkDevice device, VkSwapchainKHR swapchain,
                                                  const VkPresentWait2InfoKHR* pPresentWait2Info) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkWaitForPresent2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkWaitForPresent2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateWaitForPresent2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateWaitForPresent2KHR(device, swapchain, pPresentWait2Info, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkWaitForPresent2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkWaitForPresent2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordWaitForPresent2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordWaitForPresent2KHR(device, swapchain, pPresentWait2Info, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkWaitForPresent2KHR");
        result = device_dispatch->WaitForPresent2KHR(device, swapchain, pPresentWait2Info);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkWaitForPresent2KHR");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordWaitForPresent2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordWaitForPresent2KHR(device, swapchain, pPresentWait2Info, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreatePipelineBinariesKHR(VkDevice device, const VkPipelineBinaryCreateInfoKHR* pCreateInfo,
                                                         const VkAllocationCallbacks* pAllocator,
                                                         VkPipelineBinaryHandlesInfoKHR* pBinaries) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreatePipelineBinariesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreatePipelineBinariesKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreatePipelineBinariesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreatePipelineBinariesKHR(device, pCreateInfo, pAllocator, pBinaries, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreatePipelineBinariesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreatePipelineBinariesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreatePipelineBinariesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreatePipelineBinariesKHR(device, pCreateInfo, pAllocator, pBinaries, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreatePipelineBinariesKHR");
        result = device_dispatch->CreatePipelineBinariesKHR(device, pCreateInfo, pAllocator, pBinaries);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreatePipelineBinariesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreatePipelineBinariesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreatePipelineBinariesKHR(device, pCreateInfo, pAllocator, pBinaries, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyPipelineBinaryKHR(VkDevice device, VkPipelineBinaryKHR pipelineBinary,
                                                    const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyPipelineBinaryKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyPipelineBinaryKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyPipelineBinaryKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyPipelineBinaryKHR(device, pipelineBinary, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyPipelineBinaryKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyPipelineBinaryKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyPipelineBinaryKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyPipelineBinaryKHR(device, pipelineBinary, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyPipelineBinaryKHR");
        device_dispatch->DestroyPipelineBinaryKHR(device, pipelineBinary, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyPipelineBinaryKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyPipelineBinaryKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyPipelineBinaryKHR(device, pipelineBinary, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPipelineKeyKHR(VkDevice device, const VkPipelineCreateInfoKHR* pPipelineCreateInfo,
                                                 VkPipelineBinaryKeyKHR* pPipelineKey) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPipelineKeyKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPipelineKeyKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPipelineKeyKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPipelineKeyKHR(device, pPipelineCreateInfo, pPipelineKey, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPipelineKeyKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPipelineKeyKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPipelineKeyKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPipelineKeyKHR(device, pPipelineCreateInfo, pPipelineKey, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPipelineKeyKHR");
        result = device_dispatch->GetPipelineKeyKHR(device, pPipelineCreateInfo, pPipelineKey);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPipelineKeyKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPipelineKeyKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPipelineKeyKHR(device, pPipelineCreateInfo, pPipelineKey, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPipelineBinaryDataKHR(VkDevice device, const VkPipelineBinaryDataInfoKHR* pInfo,
                                                        VkPipelineBinaryKeyKHR* pPipelineBinaryKey, size_t* pPipelineBinaryDataSize,
                                                        void* pPipelineBinaryData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPipelineBinaryDataKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPipelineBinaryDataKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPipelineBinaryDataKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPipelineBinaryDataKHR(device, pInfo, pPipelineBinaryKey, pPipelineBinaryDataSize,
                                                                pPipelineBinaryData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPipelineBinaryDataKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPipelineBinaryDataKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPipelineBinaryDataKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPipelineBinaryDataKHR(device, pInfo, pPipelineBinaryKey, pPipelineBinaryDataSize,
                                                      pPipelineBinaryData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPipelineBinaryDataKHR");
        result = device_dispatch->GetPipelineBinaryDataKHR(device, pInfo, pPipelineBinaryKey, pPipelineBinaryDataSize,
                                                           pPipelineBinaryData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPipelineBinaryDataKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPipelineBinaryDataKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPipelineBinaryDataKHR(device, pInfo, pPipelineBinaryKey, pPipelineBinaryDataSize,
                                                       pPipelineBinaryData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL ReleaseCapturedPipelineDataKHR(VkDevice device, const VkReleaseCapturedPipelineDataInfoKHR* pInfo,
                                                              const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkReleaseCapturedPipelineDataKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkReleaseCapturedPipelineDataKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateReleaseCapturedPipelineDataKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateReleaseCapturedPipelineDataKHR(device, pInfo, pAllocator, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkReleaseCapturedPipelineDataKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkReleaseCapturedPipelineDataKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordReleaseCapturedPipelineDataKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordReleaseCapturedPipelineDataKHR(device, pInfo, pAllocator, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkReleaseCapturedPipelineDataKHR");
        result = device_dispatch->ReleaseCapturedPipelineDataKHR(device, pInfo, pAllocator);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkReleaseCapturedPipelineDataKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordReleaseCapturedPipelineDataKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordReleaseCapturedPipelineDataKHR(device, pInfo, pAllocator, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL ReleaseSwapchainImagesKHR(VkDevice device, const VkReleaseSwapchainImagesInfoKHR* pReleaseInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkReleaseSwapchainImagesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkReleaseSwapchainImagesKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateReleaseSwapchainImagesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateReleaseSwapchainImagesKHR(device, pReleaseInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkReleaseSwapchainImagesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkReleaseSwapchainImagesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordReleaseSwapchainImagesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordReleaseSwapchainImagesKHR(device, pReleaseInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkReleaseSwapchainImagesKHR");
        result = device_dispatch->ReleaseSwapchainImagesKHR(device, pReleaseInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkReleaseSwapchainImagesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordReleaseSwapchainImagesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordReleaseSwapchainImagesKHR(device, pReleaseInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceCooperativeMatrixPropertiesKHR(VkPhysicalDevice physicalDevice,
                                                                               uint32_t* pPropertyCount,
                                                                               VkCooperativeMatrixPropertiesKHR* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceCooperativeMatrixPropertiesKHR(physicalDevice, pPropertyCount, pProperties,
                                                                                       error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceCooperativeMatrixPropertiesKHR(physicalDevice, pPropertyCount, pProperties,
                                                                             record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR");
        result = instance_dispatch->GetPhysicalDeviceCooperativeMatrixPropertiesKHR(physicalDevice, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceCooperativeMatrixPropertiesKHR(physicalDevice, pPropertyCount, pProperties,
                                                                              record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdSetLineStippleKHR(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor,
                                                uint16_t lineStipplePattern) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetLineStippleKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetLineStippleKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetLineStippleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetLineStippleKHR(commandBuffer, lineStippleFactor, lineStipplePattern, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetLineStippleKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetLineStippleKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetLineStippleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetLineStippleKHR(commandBuffer, lineStippleFactor, lineStipplePattern, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetLineStippleKHR");
        device_dispatch->CmdSetLineStippleKHR(commandBuffer, lineStippleFactor, lineStipplePattern);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetLineStippleKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetLineStippleKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetLineStippleKHR(commandBuffer, lineStippleFactor, lineStipplePattern, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceCalibrateableTimeDomainsKHR(VkPhysicalDevice physicalDevice,
                                                                            uint32_t* pTimeDomainCount,
                                                                            VkTimeDomainKHR* pTimeDomains) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceCalibrateableTimeDomainsKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceCalibrateableTimeDomainsKHR");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceCalibrateableTimeDomainsKHR(physicalDevice, pTimeDomainCount, pTimeDomains,
                                                                                    error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceCalibrateableTimeDomainsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceCalibrateableTimeDomainsKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceCalibrateableTimeDomainsKHR(physicalDevice, pTimeDomainCount, pTimeDomains,
                                                                          record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceCalibrateableTimeDomainsKHR");
        result = instance_dispatch->GetPhysicalDeviceCalibrateableTimeDomainsKHR(physicalDevice, pTimeDomainCount, pTimeDomains);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceCalibrateableTimeDomainsKHR");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceCalibrateableTimeDomainsKHR(physicalDevice, pTimeDomainCount, pTimeDomains,
                                                                           record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetCalibratedTimestampsKHR(VkDevice device, uint32_t timestampCount,
                                                          const VkCalibratedTimestampInfoKHR* pTimestampInfos,
                                                          uint64_t* pTimestamps, uint64_t* pMaxDeviation) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetCalibratedTimestampsKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetCalibratedTimestampsKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetCalibratedTimestampsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetCalibratedTimestampsKHR(device, timestampCount, pTimestampInfos, pTimestamps,
                                                                  pMaxDeviation, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetCalibratedTimestampsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetCalibratedTimestampsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetCalibratedTimestampsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetCalibratedTimestampsKHR(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation,
                                                        record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetCalibratedTimestampsKHR");
        result = device_dispatch->GetCalibratedTimestampsKHR(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetCalibratedTimestampsKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetCalibratedTimestampsKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetCalibratedTimestampsKHR(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation,
                                                         record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdBindDescriptorSets2KHR(VkCommandBuffer commandBuffer,
                                                     const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindDescriptorSets2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBindDescriptorSets2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindDescriptorSets2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindDescriptorSets2KHR(commandBuffer, pBindDescriptorSetsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindDescriptorSets2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBindDescriptorSets2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindDescriptorSets2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindDescriptorSets2KHR(commandBuffer, pBindDescriptorSetsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBindDescriptorSets2KHR");
        device_dispatch->CmdBindDescriptorSets2KHR(commandBuffer, pBindDescriptorSetsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBindDescriptorSets2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindDescriptorSets2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindDescriptorSets2KHR(commandBuffer, pBindDescriptorSetsInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushConstants2KHR(VkCommandBuffer commandBuffer, const VkPushConstantsInfo* pPushConstantsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushConstants2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdPushConstants2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushConstants2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushConstants2KHR(commandBuffer, pPushConstantsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushConstants2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdPushConstants2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushConstants2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushConstants2KHR(commandBuffer, pPushConstantsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdPushConstants2KHR");
        device_dispatch->CmdPushConstants2KHR(commandBuffer, pPushConstantsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdPushConstants2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushConstants2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushConstants2KHR(commandBuffer, pPushConstantsInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSet2KHR(VkCommandBuffer commandBuffer,
                                                    const VkPushDescriptorSetInfo* pPushDescriptorSetInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSet2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdPushDescriptorSet2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSet2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushDescriptorSet2KHR(commandBuffer, pPushDescriptorSetInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSet2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdPushDescriptorSet2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSet2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSet2KHR(commandBuffer, pPushDescriptorSetInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdPushDescriptorSet2KHR");
        device_dispatch->CmdPushDescriptorSet2KHR(commandBuffer, pPushDescriptorSetInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdPushDescriptorSet2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSet2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSet2KHR(commandBuffer, pPushDescriptorSetInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSetWithTemplate2KHR(
    VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplate2KHR,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdPushDescriptorSetWithTemplate2KHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSetWithTemplate2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushDescriptorSetWithTemplate2KHR(commandBuffer, pPushDescriptorSetWithTemplateInfo,
                                                                            error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplate2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdPushDescriptorSetWithTemplate2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSetWithTemplate2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSetWithTemplate2KHR(commandBuffer, pPushDescriptorSetWithTemplateInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdPushDescriptorSetWithTemplate2KHR");
        device_dispatch->CmdPushDescriptorSetWithTemplate2KHR(commandBuffer, pPushDescriptorSetWithTemplateInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdPushDescriptorSetWithTemplate2KHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSetWithTemplate2KHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSetWithTemplate2KHR(commandBuffer, pPushDescriptorSetWithTemplateInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDescriptorBufferOffsets2EXT(
    VkCommandBuffer commandBuffer, const VkSetDescriptorBufferOffsetsInfoEXT* pSetDescriptorBufferOffsetsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDescriptorBufferOffsets2EXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetDescriptorBufferOffsets2EXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDescriptorBufferOffsets2EXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDescriptorBufferOffsets2EXT(commandBuffer, pSetDescriptorBufferOffsetsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDescriptorBufferOffsets2EXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetDescriptorBufferOffsets2EXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDescriptorBufferOffsets2EXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDescriptorBufferOffsets2EXT(commandBuffer, pSetDescriptorBufferOffsetsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetDescriptorBufferOffsets2EXT");
        device_dispatch->CmdSetDescriptorBufferOffsets2EXT(commandBuffer, pSetDescriptorBufferOffsetsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetDescriptorBufferOffsets2EXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDescriptorBufferOffsets2EXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDescriptorBufferOffsets2EXT(commandBuffer, pSetDescriptorBufferOffsetsInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindDescriptorBufferEmbeddedSamplers2EXT(
    VkCommandBuffer commandBuffer, const VkBindDescriptorBufferEmbeddedSamplersInfoEXT* pBindDescriptorBufferEmbeddedSamplersInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindDescriptorBufferEmbeddedSamplers2EXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBindDescriptorBufferEmbeddedSamplers2EXT");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindDescriptorBufferEmbeddedSamplers2EXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindDescriptorBufferEmbeddedSamplers2EXT(
                commandBuffer, pBindDescriptorBufferEmbeddedSamplersInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindDescriptorBufferEmbeddedSamplers2EXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBindDescriptorBufferEmbeddedSamplers2EXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindDescriptorBufferEmbeddedSamplers2EXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindDescriptorBufferEmbeddedSamplers2EXT(commandBuffer, pBindDescriptorBufferEmbeddedSamplersInfo,
                                                                         record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBindDescriptorBufferEmbeddedSamplers2EXT");
        device_dispatch->CmdBindDescriptorBufferEmbeddedSamplers2EXT(commandBuffer, pBindDescriptorBufferEmbeddedSamplersInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBindDescriptorBufferEmbeddedSamplers2EXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindDescriptorBufferEmbeddedSamplers2EXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindDescriptorBufferEmbeddedSamplers2EXT(commandBuffer, pBindDescriptorBufferEmbeddedSamplersInfo,
                                                                          record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyMemoryIndirectKHR(VkCommandBuffer commandBuffer,
                                                    const VkCopyMemoryIndirectInfoKHR* pCopyMemoryIndirectInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyMemoryIndirectKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyMemoryIndirectKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyMemoryIndirectKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyMemoryIndirectKHR(commandBuffer, pCopyMemoryIndirectInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyMemoryIndirectKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyMemoryIndirectKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyMemoryIndirectKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyMemoryIndirectKHR(commandBuffer, pCopyMemoryIndirectInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyMemoryIndirectKHR");
        device_dispatch->CmdCopyMemoryIndirectKHR(commandBuffer, pCopyMemoryIndirectInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyMemoryIndirectKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyMemoryIndirectKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyMemoryIndirectKHR(commandBuffer, pCopyMemoryIndirectInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyMemoryToImageIndirectKHR(
    VkCommandBuffer commandBuffer, const VkCopyMemoryToImageIndirectInfoKHR* pCopyMemoryToImageIndirectInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyMemoryToImageIndirectKHR,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyMemoryToImageIndirectKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyMemoryToImageIndirectKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyMemoryToImageIndirectKHR(commandBuffer, pCopyMemoryToImageIndirectInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyMemoryToImageIndirectKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyMemoryToImageIndirectKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyMemoryToImageIndirectKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyMemoryToImageIndirectKHR(commandBuffer, pCopyMemoryToImageIndirectInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyMemoryToImageIndirectKHR");
        device_dispatch->CmdCopyMemoryToImageIndirectKHR(commandBuffer, pCopyMemoryToImageIndirectInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyMemoryToImageIndirectKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyMemoryToImageIndirectKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyMemoryToImageIndirectKHR(commandBuffer, pCopyMemoryToImageIndirectInfo, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDebugReportCallbackEXT(VkInstance instance,
                                                            const VkDebugReportCallbackCreateInfoEXT* pCreateInfo,
                                                            const VkAllocationCallbacks* pAllocator,
                                                            VkDebugReportCallbackEXT* pCallback) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDebugReportCallbackEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateDebugReportCallbackEXT");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateCreateDebugReportCallbackEXT(instance, pCreateInfo, pAllocator, pCallback, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDebugReportCallbackEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateDebugReportCallbackEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordCreateDebugReportCallbackEXT(instance, pCreateInfo, pAllocator, pCallback, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateDebugReportCallbackEXT");
        result = instance_dispatch->CreateDebugReportCallbackEXT(instance, pCreateInfo, pAllocator, pCallback);
    }
    LayerCreateReportCallback(instance_dispatch->debug_report, false, pCreateInfo, pCallback);
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateDebugReportCallbackEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordCreateDebugReportCallbackEXT(instance, pCreateInfo, pAllocator, pCallback, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyDebugReportCallbackEXT(VkInstance instance, VkDebugReportCallbackEXT callback,
                                                         const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyDebugReportCallbackEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyDebugReportCallbackEXT");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateDestroyDebugReportCallbackEXT(instance, callback, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyDebugReportCallbackEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyDebugReportCallbackEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordDestroyDebugReportCallbackEXT(instance, callback, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyDebugReportCallbackEXT");
        instance_dispatch->DestroyDebugReportCallbackEXT(instance, callback, pAllocator);
    }
    LayerDestroyCallback(instance_dispatch->debug_report, callback);
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyDebugReportCallbackEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordDestroyDebugReportCallbackEXT(instance, callback, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL DebugReportMessageEXT(VkInstance instance, VkDebugReportFlagsEXT flags,
                                                 VkDebugReportObjectTypeEXT objectType, uint64_t object, size_t location,
                                                 int32_t messageCode, const char* pLayerPrefix, const char* pMessage) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDebugReportMessageEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDebugReportMessageEXT");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateDebugReportMessageEXT(instance, flags, objectType, object, location, messageCode,
                                                             pLayerPrefix, pMessage, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDebugReportMessageEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDebugReportMessageEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordDebugReportMessageEXT(instance, flags, objectType, object, location, messageCode, pLayerPrefix,
                                                   pMessage, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDebugReportMessageEXT");
        instance_dispatch->DebugReportMessageEXT(instance, flags, objectType, object, location, messageCode, pLayerPrefix,
                                                 pMessage);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDebugReportMessageEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordDebugReportMessageEXT(instance, flags, objectType, object, location, messageCode, pLayerPrefix,
                                                    pMessage, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL DebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDebugMarkerSetObjectTagEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDebugMarkerSetObjectTagEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDebugMarkerSetObjectTagEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDebugMarkerSetObjectTagEXT(device, pTagInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkDebugMarkerSetObjectTagEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDebugMarkerSetObjectTagEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDebugMarkerSetObjectTagEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDebugMarkerSetObjectTagEXT(device, pTagInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkDebugMarkerSetObjectTagEXT");
        result = device_dispatch->DebugMarkerSetObjectTagEXT(device, pTagInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkDebugMarkerSetObjectTagEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDebugMarkerSetObjectTagEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDebugMarkerSetObjectTagEXT(device, pTagInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL DebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDebugMarkerSetObjectNameEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDebugMarkerSetObjectNameEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDebugMarkerSetObjectNameEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDebugMarkerSetObjectNameEXT(device, pNameInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkDebugMarkerSetObjectNameEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDebugMarkerSetObjectNameEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDebugMarkerSetObjectNameEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDebugMarkerSetObjectNameEXT(device, pNameInfo, record_obj);
        }
    }
    device_dispatch->debug_report->SetMarkerObjectName(pNameInfo);
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkDebugMarkerSetObjectNameEXT");
        result = device_dispatch->DebugMarkerSetObjectNameEXT(device, pNameInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkDebugMarkerSetObjectNameEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDebugMarkerSetObjectNameEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDebugMarkerSetObjectNameEXT(device, pNameInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDebugMarkerBeginEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDebugMarkerBeginEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDebugMarkerBeginEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDebugMarkerBeginEXT(commandBuffer, pMarkerInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDebugMarkerBeginEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDebugMarkerBeginEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDebugMarkerBeginEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDebugMarkerBeginEXT(commandBuffer, pMarkerInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDebugMarkerBeginEXT");
        device_dispatch->CmdDebugMarkerBeginEXT(commandBuffer, pMarkerInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDebugMarkerBeginEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDebugMarkerBeginEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDebugMarkerBeginEXT(commandBuffer, pMarkerInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDebugMarkerEndEXT(VkCommandBuffer commandBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDebugMarkerEndEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDebugMarkerEndEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDebugMarkerEndEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDebugMarkerEndEXT(commandBuffer, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDebugMarkerEndEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDebugMarkerEndEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDebugMarkerEndEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDebugMarkerEndEXT(commandBuffer, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDebugMarkerEndEXT");
        device_dispatch->CmdDebugMarkerEndEXT(commandBuffer);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDebugMarkerEndEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDebugMarkerEndEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDebugMarkerEndEXT(commandBuffer, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDebugMarkerInsertEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDebugMarkerInsertEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDebugMarkerInsertEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDebugMarkerInsertEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDebugMarkerInsertEXT(commandBuffer, pMarkerInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDebugMarkerInsertEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDebugMarkerInsertEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDebugMarkerInsertEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDebugMarkerInsertEXT(commandBuffer, pMarkerInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDebugMarkerInsertEXT");
        device_dispatch->CmdDebugMarkerInsertEXT(commandBuffer, pMarkerInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDebugMarkerInsertEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDebugMarkerInsertEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDebugMarkerInsertEXT(commandBuffer, pMarkerInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, uint32_t firstBinding,
                                                              uint32_t bindingCount, const VkBuffer* pBuffers,
                                                              const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindTransformFeedbackBuffersEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBindTransformFeedbackBuffersEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindTransformFeedbackBuffersEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindTransformFeedbackBuffersEXT(commandBuffer, firstBinding, bindingCount, pBuffers,
                                                                          pOffsets, pSizes, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindTransformFeedbackBuffersEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBindTransformFeedbackBuffersEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindTransformFeedbackBuffersEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindTransformFeedbackBuffersEXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets,
                                                                pSizes, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBindTransformFeedbackBuffersEXT");
        device_dispatch->CmdBindTransformFeedbackBuffersEXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBindTransformFeedbackBuffersEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindTransformFeedbackBuffersEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindTransformFeedbackBuffersEXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets,
                                                                 pSizes, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer,
                                                        uint32_t counterBufferCount, const VkBuffer* pCounterBuffers,
                                                        const VkDeviceSize* pCounterBufferOffsets) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginTransformFeedbackEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBeginTransformFeedbackEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginTransformFeedbackEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount,
                                                                    pCounterBuffers, pCounterBufferOffsets, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginTransformFeedbackEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBeginTransformFeedbackEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginTransformFeedbackEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers,
                                                          pCounterBufferOffsets, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBeginTransformFeedbackEXT");
        device_dispatch->CmdBeginTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers,
                                                      pCounterBufferOffsets);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBeginTransformFeedbackEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginTransformFeedbackEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers,
                                                           pCounterBufferOffsets, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer,
                                                      uint32_t counterBufferCount, const VkBuffer* pCounterBuffers,
                                                      const VkDeviceSize* pCounterBufferOffsets) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndTransformFeedbackEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdEndTransformFeedbackEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndTransformFeedbackEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount,
                                                                  pCounterBuffers, pCounterBufferOffsets, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndTransformFeedbackEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdEndTransformFeedbackEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndTransformFeedbackEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers,
                                                        pCounterBufferOffsets, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdEndTransformFeedbackEXT");
        device_dispatch->CmdEndTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers,
                                                    pCounterBufferOffsets);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdEndTransformFeedbackEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndTransformFeedbackEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers,
                                                         pCounterBufferOffsets, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query,
                                                   VkQueryControlFlags flags, uint32_t index) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginQueryIndexedEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBeginQueryIndexedEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginQueryIndexedEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginQueryIndexedEXT(commandBuffer, queryPool, query, flags, index, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginQueryIndexedEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBeginQueryIndexedEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginQueryIndexedEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginQueryIndexedEXT(commandBuffer, queryPool, query, flags, index, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBeginQueryIndexedEXT");
        device_dispatch->CmdBeginQueryIndexedEXT(commandBuffer, queryPool, query, flags, index);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBeginQueryIndexedEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginQueryIndexedEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginQueryIndexedEXT(commandBuffer, queryPool, query, flags, index, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query,
                                                 uint32_t index) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndQueryIndexedEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdEndQueryIndexedEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndQueryIndexedEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndQueryIndexedEXT(commandBuffer, queryPool, query, index, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndQueryIndexedEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdEndQueryIndexedEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndQueryIndexedEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndQueryIndexedEXT(commandBuffer, queryPool, query, index, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdEndQueryIndexedEXT");
        device_dispatch->CmdEndQueryIndexedEXT(commandBuffer, queryPool, query, index);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdEndQueryIndexedEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndQueryIndexedEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndQueryIndexedEXT(commandBuffer, queryPool, query, index, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndirectByteCountEXT(VkCommandBuffer commandBuffer, uint32_t instanceCount,
                                                       uint32_t firstInstance, VkBuffer counterBuffer,
                                                       VkDeviceSize counterBufferOffset, uint32_t counterOffset,
                                                       uint32_t vertexStride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndirectByteCountEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDrawIndirectByteCountEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndirectByteCountEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndirectByteCountEXT(commandBuffer, instanceCount, firstInstance, counterBuffer,
                                                                   counterBufferOffset, counterOffset, vertexStride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndirectByteCountEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDrawIndirectByteCountEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndirectByteCountEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndirectByteCountEXT(commandBuffer, instanceCount, firstInstance, counterBuffer,
                                                         counterBufferOffset, counterOffset, vertexStride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDrawIndirectByteCountEXT");
        device_dispatch->CmdDrawIndirectByteCountEXT(commandBuffer, instanceCount, firstInstance, counterBuffer,
                                                     counterBufferOffset, counterOffset, vertexStride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDrawIndirectByteCountEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndirectByteCountEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndirectByteCountEXT(commandBuffer, instanceCount, firstInstance, counterBuffer,
                                                          counterBufferOffset, counterOffset, vertexStride, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateCuModuleNVX(VkDevice device, const VkCuModuleCreateInfoNVX* pCreateInfo,
                                                 const VkAllocationCallbacks* pAllocator, VkCuModuleNVX* pModule) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateCuModuleNVX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateCuModuleNVX");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateCuModuleNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateCuModuleNVX(device, pCreateInfo, pAllocator, pModule, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateCuModuleNVX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateCuModuleNVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateCuModuleNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateCuModuleNVX(device, pCreateInfo, pAllocator, pModule, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateCuModuleNVX");
        result = device_dispatch->CreateCuModuleNVX(device, pCreateInfo, pAllocator, pModule);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateCuModuleNVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateCuModuleNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateCuModuleNVX(device, pCreateInfo, pAllocator, pModule, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateCuFunctionNVX(VkDevice device, const VkCuFunctionCreateInfoNVX* pCreateInfo,
                                                   const VkAllocationCallbacks* pAllocator, VkCuFunctionNVX* pFunction) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateCuFunctionNVX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateCuFunctionNVX");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateCuFunctionNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateCuFunctionNVX(device, pCreateInfo, pAllocator, pFunction, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateCuFunctionNVX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateCuFunctionNVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateCuFunctionNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateCuFunctionNVX(device, pCreateInfo, pAllocator, pFunction, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateCuFunctionNVX");
        result = device_dispatch->CreateCuFunctionNVX(device, pCreateInfo, pAllocator, pFunction);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateCuFunctionNVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateCuFunctionNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateCuFunctionNVX(device, pCreateInfo, pAllocator, pFunction, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyCuModuleNVX(VkDevice device, VkCuModuleNVX module, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyCuModuleNVX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyCuModuleNVX");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyCuModuleNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyCuModuleNVX(device, module, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyCuModuleNVX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyCuModuleNVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyCuModuleNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyCuModuleNVX(device, module, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyCuModuleNVX");
        device_dispatch->DestroyCuModuleNVX(device, module, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyCuModuleNVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyCuModuleNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyCuModuleNVX(device, module, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL DestroyCuFunctionNVX(VkDevice device, VkCuFunctionNVX function,
                                                const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyCuFunctionNVX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyCuFunctionNVX");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyCuFunctionNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyCuFunctionNVX(device, function, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyCuFunctionNVX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyCuFunctionNVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyCuFunctionNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyCuFunctionNVX(device, function, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyCuFunctionNVX");
        device_dispatch->DestroyCuFunctionNVX(device, function, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyCuFunctionNVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyCuFunctionNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyCuFunctionNVX(device, function, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCuLaunchKernelNVX(VkCommandBuffer commandBuffer, const VkCuLaunchInfoNVX* pLaunchInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCuLaunchKernelNVX, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCuLaunchKernelNVX");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCuLaunchKernelNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCuLaunchKernelNVX(commandBuffer, pLaunchInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCuLaunchKernelNVX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCuLaunchKernelNVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCuLaunchKernelNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCuLaunchKernelNVX(commandBuffer, pLaunchInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCuLaunchKernelNVX");
        device_dispatch->CmdCuLaunchKernelNVX(commandBuffer, pLaunchInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCuLaunchKernelNVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCuLaunchKernelNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCuLaunchKernelNVX(commandBuffer, pLaunchInfo, record_obj);
        }
    }
}

VKAPI_ATTR uint32_t VKAPI_CALL GetImageViewHandleNVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageViewHandleNVX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetImageViewHandleNVX");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageViewHandleNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageViewHandleNVX(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageViewHandleNVX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetImageViewHandleNVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageViewHandleNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageViewHandleNVX(device, pInfo, record_obj);
        }
    }
    uint32_t result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetImageViewHandleNVX");
        result = device_dispatch->GetImageViewHandleNVX(device, pInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetImageViewHandleNVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageViewHandleNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageViewHandleNVX(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR uint64_t VKAPI_CALL GetImageViewHandle64NVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageViewHandle64NVX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetImageViewHandle64NVX");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageViewHandle64NVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageViewHandle64NVX(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageViewHandle64NVX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetImageViewHandle64NVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageViewHandle64NVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageViewHandle64NVX(device, pInfo, record_obj);
        }
    }
    uint64_t result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetImageViewHandle64NVX");
        result = device_dispatch->GetImageViewHandle64NVX(device, pInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetImageViewHandle64NVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageViewHandle64NVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageViewHandle64NVX(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetImageViewAddressNVX(VkDevice device, VkImageView imageView,
                                                      VkImageViewAddressPropertiesNVX* pProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageViewAddressNVX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetImageViewAddressNVX");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageViewAddressNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageViewAddressNVX(device, imageView, pProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageViewAddressNVX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetImageViewAddressNVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageViewAddressNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageViewAddressNVX(device, imageView, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetImageViewAddressNVX");
        result = device_dispatch->GetImageViewAddressNVX(device, imageView, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetImageViewAddressNVX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageViewAddressNVX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageViewAddressNVX(device, imageView, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                   VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount,
                                                   uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndirectCountAMD, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDrawIndirectCountAMD");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndirectCountAMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                               maxDrawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndirectCountAMD);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDrawIndirectCountAMD");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndirectCountAMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                     stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDrawIndirectCountAMD");
        device_dispatch->CmdDrawIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                 stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDrawIndirectCountAMD");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndirectCountAMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                      stride, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndexedIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                          VkBuffer countBuffer, VkDeviceSize countBufferOffset,
                                                          uint32_t maxDrawCount, uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndexedIndirectCountAMD,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDrawIndexedIndirectCountAMD");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndexedIndirectCountAMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndexedIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                                      maxDrawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndexedIndirectCountAMD);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDrawIndexedIndirectCountAMD");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndexedIndirectCountAMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndexedIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                            maxDrawCount, stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDrawIndexedIndirectCountAMD");
        device_dispatch->CmdDrawIndexedIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                        stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDrawIndexedIndirectCountAMD");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndexedIndirectCountAMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndexedIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                             maxDrawCount, stride, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetShaderInfoAMD(VkDevice device, VkPipeline pipeline, VkShaderStageFlagBits shaderStage,
                                                VkShaderInfoTypeAMD infoType, size_t* pInfoSize, void* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetShaderInfoAMD, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetShaderInfoAMD");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetShaderInfoAMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetShaderInfoAMD(device, pipeline, shaderStage, infoType, pInfoSize, pInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetShaderInfoAMD);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetShaderInfoAMD");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetShaderInfoAMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetShaderInfoAMD(device, pipeline, shaderStage, infoType, pInfoSize, pInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetShaderInfoAMD");
        result = device_dispatch->GetShaderInfoAMD(device, pipeline, shaderStage, infoType, pInfoSize, pInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetShaderInfoAMD");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetShaderInfoAMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetShaderInfoAMD(device, pipeline, shaderStage, infoType, pInfoSize, pInfo, record_obj);
        }
    }
    return result;
}

#ifdef VK_USE_PLATFORM_GGP
VKAPI_ATTR VkResult VKAPI_CALL CreateStreamDescriptorSurfaceGGP(VkInstance instance,
                                                                const VkStreamDescriptorSurfaceCreateInfoGGP* pCreateInfo,
                                                                const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateStreamDescriptorSurfaceGGP, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateStreamDescriptorSurfaceGGP");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateCreateStreamDescriptorSurfaceGGP(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateStreamDescriptorSurfaceGGP);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateStreamDescriptorSurfaceGGP");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordCreateStreamDescriptorSurfaceGGP(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateStreamDescriptorSurfaceGGP");
        result = instance_dispatch->CreateStreamDescriptorSurfaceGGP(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateStreamDescriptorSurfaceGGP");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordCreateStreamDescriptorSurfaceGGP(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_GGP
VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceExternalImageFormatPropertiesNV(
    VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage,
    VkImageCreateFlags flags, VkExternalMemoryHandleTypeFlagsNV externalHandleType,
    VkExternalImageFormatPropertiesNV* pExternalImageFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceExternalImageFormatPropertiesNV,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceExternalImageFormatPropertiesNV");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceExternalImageFormatPropertiesNV(
                physicalDevice, format, type, tiling, usage, flags, externalHandleType, pExternalImageFormatProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceExternalImageFormatPropertiesNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceExternalImageFormatPropertiesNV");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceExternalImageFormatPropertiesNV(
                physicalDevice, format, type, tiling, usage, flags, externalHandleType, pExternalImageFormatProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceExternalImageFormatPropertiesNV");
        result = instance_dispatch->GetPhysicalDeviceExternalImageFormatPropertiesNV(
            physicalDevice, format, type, tiling, usage, flags, externalHandleType, pExternalImageFormatProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceExternalImageFormatPropertiesNV");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceExternalImageFormatPropertiesNV(
                physicalDevice, format, type, tiling, usage, flags, externalHandleType, pExternalImageFormatProperties, record_obj);
        }
    }
    return result;
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL GetMemoryWin32HandleNV(VkDevice device, VkDeviceMemory memory,
                                                      VkExternalMemoryHandleTypeFlagsNV handleType, HANDLE* pHandle) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryWin32HandleNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetMemoryWin32HandleNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryWin32HandleNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryWin32HandleNV(device, memory, handleType, pHandle, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryWin32HandleNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetMemoryWin32HandleNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryWin32HandleNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryWin32HandleNV(device, memory, handleType, pHandle, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetMemoryWin32HandleNV");
        result = device_dispatch->GetMemoryWin32HandleNV(device, memory, handleType, pHandle);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetMemoryWin32HandleNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryWin32HandleNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryWin32HandleNV(device, memory, handleType, pHandle, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_VI_NN
VKAPI_ATTR VkResult VKAPI_CALL CreateViSurfaceNN(VkInstance instance, const VkViSurfaceCreateInfoNN* pCreateInfo,
                                                 const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateViSurfaceNN, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateViSurfaceNN");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateCreateViSurfaceNN(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateViSurfaceNN);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateViSurfaceNN");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordCreateViSurfaceNN(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateViSurfaceNN");
        result = instance_dispatch->CreateViSurfaceNN(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateViSurfaceNN");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordCreateViSurfaceNN(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_VI_NN
VKAPI_ATTR void VKAPI_CALL CmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer,
                                                           const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginConditionalRenderingEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBeginConditionalRenderingEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginConditionalRenderingEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginConditionalRenderingEXT(commandBuffer, pConditionalRenderingBegin, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginConditionalRenderingEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBeginConditionalRenderingEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginConditionalRenderingEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginConditionalRenderingEXT(commandBuffer, pConditionalRenderingBegin, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBeginConditionalRenderingEXT");
        device_dispatch->CmdBeginConditionalRenderingEXT(commandBuffer, pConditionalRenderingBegin);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBeginConditionalRenderingEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginConditionalRenderingEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginConditionalRenderingEXT(commandBuffer, pConditionalRenderingBegin, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndConditionalRenderingEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdEndConditionalRenderingEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndConditionalRenderingEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndConditionalRenderingEXT(commandBuffer, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndConditionalRenderingEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdEndConditionalRenderingEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndConditionalRenderingEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndConditionalRenderingEXT(commandBuffer, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdEndConditionalRenderingEXT");
        device_dispatch->CmdEndConditionalRenderingEXT(commandBuffer);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdEndConditionalRenderingEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndConditionalRenderingEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndConditionalRenderingEXT(commandBuffer, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetViewportWScalingNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount,
                                                    const VkViewportWScalingNV* pViewportWScalings) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetViewportWScalingNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetViewportWScalingNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetViewportWScalingNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetViewportWScalingNV(commandBuffer, firstViewport, viewportCount, pViewportWScalings,
                                                                error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetViewportWScalingNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetViewportWScalingNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetViewportWScalingNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetViewportWScalingNV(commandBuffer, firstViewport, viewportCount, pViewportWScalings, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetViewportWScalingNV");
        device_dispatch->CmdSetViewportWScalingNV(commandBuffer, firstViewport, viewportCount, pViewportWScalings);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetViewportWScalingNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetViewportWScalingNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetViewportWScalingNV(commandBuffer, firstViewport, viewportCount, pViewportWScalings, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL ReleaseDisplayEXT(VkPhysicalDevice physicalDevice, VkDisplayKHR display) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkReleaseDisplayEXT, VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkReleaseDisplayEXT");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateReleaseDisplayEXT(physicalDevice, display, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkReleaseDisplayEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkReleaseDisplayEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordReleaseDisplayEXT(physicalDevice, display, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkReleaseDisplayEXT");
        result = instance_dispatch->ReleaseDisplayEXT(physicalDevice, display);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkReleaseDisplayEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordReleaseDisplayEXT(physicalDevice, display, record_obj);
        }
    }
    return result;
}

#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
VKAPI_ATTR VkResult VKAPI_CALL AcquireXlibDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, VkDisplayKHR display) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAcquireXlibDisplayEXT, VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkAcquireXlibDisplayEXT");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateAcquireXlibDisplayEXT(physicalDevice, dpy, display, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAcquireXlibDisplayEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkAcquireXlibDisplayEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordAcquireXlibDisplayEXT(physicalDevice, dpy, display, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkAcquireXlibDisplayEXT");
        result = instance_dispatch->AcquireXlibDisplayEXT(physicalDevice, dpy, display);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkAcquireXlibDisplayEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordAcquireXlibDisplayEXT(physicalDevice, dpy, display, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetRandROutputDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, RROutput rrOutput,
                                                        VkDisplayKHR* pDisplay) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetRandROutputDisplayEXT,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetRandROutputDisplayEXT");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetRandROutputDisplayEXT(physicalDevice, dpy, rrOutput, pDisplay, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetRandROutputDisplayEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetRandROutputDisplayEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetRandROutputDisplayEXT(physicalDevice, dpy, rrOutput, pDisplay, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetRandROutputDisplayEXT");
        result = instance_dispatch->GetRandROutputDisplayEXT(physicalDevice, dpy, rrOutput, pDisplay);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetRandROutputDisplayEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetRandROutputDisplayEXT(physicalDevice, dpy, rrOutput, pDisplay, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_XLIB_XRANDR_EXT
VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfaceCapabilities2EXT(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface,
                                                                        VkSurfaceCapabilities2EXT* pSurfaceCapabilities) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfaceCapabilities2EXT,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceSurfaceCapabilities2EXT");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfaceCapabilities2EXT(physicalDevice, surface, pSurfaceCapabilities,
                                                                                error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfaceCapabilities2EXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceSurfaceCapabilities2EXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceSurfaceCapabilities2EXT(physicalDevice, surface, pSurfaceCapabilities, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceSurfaceCapabilities2EXT");
        result = instance_dispatch->GetPhysicalDeviceSurfaceCapabilities2EXT(physicalDevice, surface, pSurfaceCapabilities);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceSurfaceCapabilities2EXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceSurfaceCapabilities2EXT(physicalDevice, surface, pSurfaceCapabilities, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL DisplayPowerControlEXT(VkDevice device, VkDisplayKHR display,
                                                      const VkDisplayPowerInfoEXT* pDisplayPowerInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDisplayPowerControlEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDisplayPowerControlEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDisplayPowerControlEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDisplayPowerControlEXT(device, display, pDisplayPowerInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkDisplayPowerControlEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDisplayPowerControlEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDisplayPowerControlEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDisplayPowerControlEXT(device, display, pDisplayPowerInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkDisplayPowerControlEXT");
        result = device_dispatch->DisplayPowerControlEXT(device, display, pDisplayPowerInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkDisplayPowerControlEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDisplayPowerControlEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDisplayPowerControlEXT(device, display, pDisplayPowerInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL RegisterDeviceEventEXT(VkDevice device, const VkDeviceEventInfoEXT* pDeviceEventInfo,
                                                      const VkAllocationCallbacks* pAllocator, VkFence* pFence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkRegisterDeviceEventEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkRegisterDeviceEventEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateRegisterDeviceEventEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateRegisterDeviceEventEXT(device, pDeviceEventInfo, pAllocator, pFence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkRegisterDeviceEventEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkRegisterDeviceEventEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordRegisterDeviceEventEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordRegisterDeviceEventEXT(device, pDeviceEventInfo, pAllocator, pFence, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkRegisterDeviceEventEXT");
        result = device_dispatch->RegisterDeviceEventEXT(device, pDeviceEventInfo, pAllocator, pFence);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkRegisterDeviceEventEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordRegisterDeviceEventEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordRegisterDeviceEventEXT(device, pDeviceEventInfo, pAllocator, pFence, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL RegisterDisplayEventEXT(VkDevice device, VkDisplayKHR display,
                                                       const VkDisplayEventInfoEXT* pDisplayEventInfo,
                                                       const VkAllocationCallbacks* pAllocator, VkFence* pFence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkRegisterDisplayEventEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkRegisterDisplayEventEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateRegisterDisplayEventEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateRegisterDisplayEventEXT(device, display, pDisplayEventInfo, pAllocator, pFence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkRegisterDisplayEventEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkRegisterDisplayEventEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordRegisterDisplayEventEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordRegisterDisplayEventEXT(device, display, pDisplayEventInfo, pAllocator, pFence, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkRegisterDisplayEventEXT");
        result = device_dispatch->RegisterDisplayEventEXT(device, display, pDisplayEventInfo, pAllocator, pFence);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkRegisterDisplayEventEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordRegisterDisplayEventEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordRegisterDisplayEventEXT(device, display, pDisplayEventInfo, pAllocator, pFence, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetSwapchainCounterEXT(VkDevice device, VkSwapchainKHR swapchain,
                                                      VkSurfaceCounterFlagBitsEXT counter, uint64_t* pCounterValue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSwapchainCounterEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetSwapchainCounterEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSwapchainCounterEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSwapchainCounterEXT(device, swapchain, counter, pCounterValue, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSwapchainCounterEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetSwapchainCounterEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSwapchainCounterEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSwapchainCounterEXT(device, swapchain, counter, pCounterValue, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetSwapchainCounterEXT");
        result = device_dispatch->GetSwapchainCounterEXT(device, swapchain, counter, pCounterValue);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetSwapchainCounterEXT");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSwapchainCounterEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetSwapchainCounterEXT(device, swapchain, counter, pCounterValue, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetRefreshCycleDurationGOOGLE(VkDevice device, VkSwapchainKHR swapchain,
                                                             VkRefreshCycleDurationGOOGLE* pDisplayTimingProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetRefreshCycleDurationGOOGLE, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetRefreshCycleDurationGOOGLE");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetRefreshCycleDurationGOOGLE]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetRefreshCycleDurationGOOGLE(device, swapchain, pDisplayTimingProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetRefreshCycleDurationGOOGLE);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetRefreshCycleDurationGOOGLE");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetRefreshCycleDurationGOOGLE]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetRefreshCycleDurationGOOGLE(device, swapchain, pDisplayTimingProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetRefreshCycleDurationGOOGLE");
        result = device_dispatch->GetRefreshCycleDurationGOOGLE(device, swapchain, pDisplayTimingProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetRefreshCycleDurationGOOGLE");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetRefreshCycleDurationGOOGLE]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetRefreshCycleDurationGOOGLE(device, swapchain, pDisplayTimingProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPastPresentationTimingGOOGLE(VkDevice device, VkSwapchainKHR swapchain,
                                                               uint32_t* pPresentationTimingCount,
                                                               VkPastPresentationTimingGOOGLE* pPresentationTimings) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPastPresentationTimingGOOGLE, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPastPresentationTimingGOOGLE");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPastPresentationTimingGOOGLE]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPastPresentationTimingGOOGLE(device, swapchain, pPresentationTimingCount,
                                                                       pPresentationTimings, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPastPresentationTimingGOOGLE);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPastPresentationTimingGOOGLE");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPastPresentationTimingGOOGLE]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPastPresentationTimingGOOGLE(device, swapchain, pPresentationTimingCount, pPresentationTimings,
                                                             record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPastPresentationTimingGOOGLE");
        result =
            device_dispatch->GetPastPresentationTimingGOOGLE(device, swapchain, pPresentationTimingCount, pPresentationTimings);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPastPresentationTimingGOOGLE");

        if (result == VK_ERROR_DEVICE_LOST) {
            for (auto& vo : device_dispatch->object_dispatch) {
                vo->is_device_lost = true;
            }
        }
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPastPresentationTimingGOOGLE]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPastPresentationTimingGOOGLE(device, swapchain, pPresentationTimingCount, pPresentationTimings,
                                                              record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdSetDiscardRectangleEXT(VkCommandBuffer commandBuffer, uint32_t firstDiscardRectangle,
                                                     uint32_t discardRectangleCount, const VkRect2D* pDiscardRectangles) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDiscardRectangleEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetDiscardRectangleEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDiscardRectangleEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDiscardRectangleEXT(commandBuffer, firstDiscardRectangle, discardRectangleCount,
                                                                 pDiscardRectangles, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDiscardRectangleEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetDiscardRectangleEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDiscardRectangleEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDiscardRectangleEXT(commandBuffer, firstDiscardRectangle, discardRectangleCount,
                                                       pDiscardRectangles, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetDiscardRectangleEXT");
        device_dispatch->CmdSetDiscardRectangleEXT(commandBuffer, firstDiscardRectangle, discardRectangleCount, pDiscardRectangles);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetDiscardRectangleEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDiscardRectangleEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDiscardRectangleEXT(commandBuffer, firstDiscardRectangle, discardRectangleCount,
                                                        pDiscardRectangles, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDiscardRectangleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 discardRectangleEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDiscardRectangleEnableEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetDiscardRectangleEnableEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDiscardRectangleEnableEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDiscardRectangleEnableEXT(commandBuffer, discardRectangleEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDiscardRectangleEnableEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetDiscardRectangleEnableEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDiscardRectangleEnableEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDiscardRectangleEnableEXT(commandBuffer, discardRectangleEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetDiscardRectangleEnableEXT");
        device_dispatch->CmdSetDiscardRectangleEnableEXT(commandBuffer, discardRectangleEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetDiscardRectangleEnableEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDiscardRectangleEnableEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDiscardRectangleEnableEXT(commandBuffer, discardRectangleEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDiscardRectangleModeEXT(VkCommandBuffer commandBuffer,
                                                         VkDiscardRectangleModeEXT discardRectangleMode) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDiscardRectangleModeEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetDiscardRectangleModeEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDiscardRectangleModeEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDiscardRectangleModeEXT(commandBuffer, discardRectangleMode, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDiscardRectangleModeEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetDiscardRectangleModeEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDiscardRectangleModeEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDiscardRectangleModeEXT(commandBuffer, discardRectangleMode, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetDiscardRectangleModeEXT");
        device_dispatch->CmdSetDiscardRectangleModeEXT(commandBuffer, discardRectangleMode);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetDiscardRectangleModeEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDiscardRectangleModeEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDiscardRectangleModeEXT(commandBuffer, discardRectangleMode, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL SetHdrMetadataEXT(VkDevice device, uint32_t swapchainCount, const VkSwapchainKHR* pSwapchains,
                                             const VkHdrMetadataEXT* pMetadata) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSetHdrMetadataEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkSetHdrMetadataEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSetHdrMetadataEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSetHdrMetadataEXT(device, swapchainCount, pSwapchains, pMetadata, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkSetHdrMetadataEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkSetHdrMetadataEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSetHdrMetadataEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordSetHdrMetadataEXT(device, swapchainCount, pSwapchains, pMetadata, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkSetHdrMetadataEXT");
        device_dispatch->SetHdrMetadataEXT(device, swapchainCount, pSwapchains, pMetadata);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkSetHdrMetadataEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSetHdrMetadataEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordSetHdrMetadataEXT(device, swapchainCount, pSwapchains, pMetadata, record_obj);
        }
    }
}

#ifdef VK_USE_PLATFORM_IOS_MVK
VKAPI_ATTR VkResult VKAPI_CALL CreateIOSSurfaceMVK(VkInstance instance, const VkIOSSurfaceCreateInfoMVK* pCreateInfo,
                                                   const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateIOSSurfaceMVK, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateIOSSurfaceMVK");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateCreateIOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateIOSSurfaceMVK);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateIOSSurfaceMVK");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordCreateIOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateIOSSurfaceMVK");
        result = instance_dispatch->CreateIOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateIOSSurfaceMVK");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordCreateIOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
VKAPI_ATTR VkResult VKAPI_CALL CreateMacOSSurfaceMVK(VkInstance instance, const VkMacOSSurfaceCreateInfoMVK* pCreateInfo,
                                                     const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateMacOSSurfaceMVK, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateMacOSSurfaceMVK");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateCreateMacOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateMacOSSurfaceMVK);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateMacOSSurfaceMVK");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordCreateMacOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateMacOSSurfaceMVK");
        result = instance_dispatch->CreateMacOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateMacOSSurfaceMVK");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordCreateMacOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_MACOS_MVK
VKAPI_ATTR VkResult VKAPI_CALL SetDebugUtilsObjectNameEXT(VkDevice device, const VkDebugUtilsObjectNameInfoEXT* pNameInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSetDebugUtilsObjectNameEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkSetDebugUtilsObjectNameEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSetDebugUtilsObjectNameEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSetDebugUtilsObjectNameEXT(device, pNameInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkSetDebugUtilsObjectNameEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkSetDebugUtilsObjectNameEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSetDebugUtilsObjectNameEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordSetDebugUtilsObjectNameEXT(device, pNameInfo, record_obj);
        }
    }
    device_dispatch->debug_report->SetUtilsObjectName(pNameInfo);
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkSetDebugUtilsObjectNameEXT");
        result = device_dispatch->SetDebugUtilsObjectNameEXT(device, pNameInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkSetDebugUtilsObjectNameEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSetDebugUtilsObjectNameEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordSetDebugUtilsObjectNameEXT(device, pNameInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL SetDebugUtilsObjectTagEXT(VkDevice device, const VkDebugUtilsObjectTagInfoEXT* pTagInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSetDebugUtilsObjectTagEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkSetDebugUtilsObjectTagEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSetDebugUtilsObjectTagEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSetDebugUtilsObjectTagEXT(device, pTagInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkSetDebugUtilsObjectTagEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkSetDebugUtilsObjectTagEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSetDebugUtilsObjectTagEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordSetDebugUtilsObjectTagEXT(device, pTagInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkSetDebugUtilsObjectTagEXT");
        result = device_dispatch->SetDebugUtilsObjectTagEXT(device, pTagInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkSetDebugUtilsObjectTagEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSetDebugUtilsObjectTagEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordSetDebugUtilsObjectTagEXT(device, pTagInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL QueueBeginDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueBeginDebugUtilsLabelEXT, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate_vkQueueBeginDebugUtilsLabelEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueBeginDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueBeginDebugUtilsLabelEXT(queue, pLabelInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueBeginDebugUtilsLabelEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkQueueBeginDebugUtilsLabelEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueBeginDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueBeginDebugUtilsLabelEXT(queue, pLabelInfo, record_obj);
        }
    }
    device_dispatch->debug_report->BeginQueueDebugUtilsLabel(queue, pLabelInfo);
    {
        VVL_ZoneScopedN("Dispatch_vkQueueBeginDebugUtilsLabelEXT");
        device_dispatch->QueueBeginDebugUtilsLabelEXT(queue, pLabelInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkQueueBeginDebugUtilsLabelEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueBeginDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordQueueBeginDebugUtilsLabelEXT(queue, pLabelInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL QueueEndDebugUtilsLabelEXT(VkQueue queue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueEndDebugUtilsLabelEXT, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate_vkQueueEndDebugUtilsLabelEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueEndDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueEndDebugUtilsLabelEXT(queue, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueEndDebugUtilsLabelEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkQueueEndDebugUtilsLabelEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueEndDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueEndDebugUtilsLabelEXT(queue, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkQueueEndDebugUtilsLabelEXT");
        device_dispatch->QueueEndDebugUtilsLabelEXT(queue);
    }
    device_dispatch->debug_report->EndQueueDebugUtilsLabel(queue);
    {
        VVL_ZoneScopedN("PostCallRecord_vkQueueEndDebugUtilsLabelEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueEndDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordQueueEndDebugUtilsLabelEXT(queue, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL QueueInsertDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueInsertDebugUtilsLabelEXT, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate_vkQueueInsertDebugUtilsLabelEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueInsertDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueInsertDebugUtilsLabelEXT(queue, pLabelInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueInsertDebugUtilsLabelEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkQueueInsertDebugUtilsLabelEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueInsertDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueInsertDebugUtilsLabelEXT(queue, pLabelInfo, record_obj);
        }
    }
    device_dispatch->debug_report->InsertQueueDebugUtilsLabel(queue, pLabelInfo);
    {
        VVL_ZoneScopedN("Dispatch_vkQueueInsertDebugUtilsLabelEXT");
        device_dispatch->QueueInsertDebugUtilsLabelEXT(queue, pLabelInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkQueueInsertDebugUtilsLabelEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueInsertDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordQueueInsertDebugUtilsLabelEXT(queue, pLabelInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginDebugUtilsLabelEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBeginDebugUtilsLabelEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginDebugUtilsLabelEXT(commandBuffer, pLabelInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginDebugUtilsLabelEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBeginDebugUtilsLabelEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginDebugUtilsLabelEXT(commandBuffer, pLabelInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBeginDebugUtilsLabelEXT");
        device_dispatch->CmdBeginDebugUtilsLabelEXT(commandBuffer, pLabelInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBeginDebugUtilsLabelEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginDebugUtilsLabelEXT(commandBuffer, pLabelInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndDebugUtilsLabelEXT(VkCommandBuffer commandBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndDebugUtilsLabelEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdEndDebugUtilsLabelEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndDebugUtilsLabelEXT(commandBuffer, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndDebugUtilsLabelEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdEndDebugUtilsLabelEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndDebugUtilsLabelEXT(commandBuffer, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdEndDebugUtilsLabelEXT");
        device_dispatch->CmdEndDebugUtilsLabelEXT(commandBuffer);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdEndDebugUtilsLabelEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndDebugUtilsLabelEXT(commandBuffer, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdInsertDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdInsertDebugUtilsLabelEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdInsertDebugUtilsLabelEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdInsertDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdInsertDebugUtilsLabelEXT(commandBuffer, pLabelInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdInsertDebugUtilsLabelEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdInsertDebugUtilsLabelEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdInsertDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdInsertDebugUtilsLabelEXT(commandBuffer, pLabelInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdInsertDebugUtilsLabelEXT");
        device_dispatch->CmdInsertDebugUtilsLabelEXT(commandBuffer, pLabelInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdInsertDebugUtilsLabelEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdInsertDebugUtilsLabelEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdInsertDebugUtilsLabelEXT(commandBuffer, pLabelInfo, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDebugUtilsMessengerEXT(VkInstance instance,
                                                            const VkDebugUtilsMessengerCreateInfoEXT* pCreateInfo,
                                                            const VkAllocationCallbacks* pAllocator,
                                                            VkDebugUtilsMessengerEXT* pMessenger) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDebugUtilsMessengerEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateDebugUtilsMessengerEXT");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateCreateDebugUtilsMessengerEXT(instance, pCreateInfo, pAllocator, pMessenger, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDebugUtilsMessengerEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateDebugUtilsMessengerEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordCreateDebugUtilsMessengerEXT(instance, pCreateInfo, pAllocator, pMessenger, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateDebugUtilsMessengerEXT");
        result = instance_dispatch->CreateDebugUtilsMessengerEXT(instance, pCreateInfo, pAllocator, pMessenger);
    }
    LayerCreateMessengerCallback(instance_dispatch->debug_report, false, pCreateInfo, pMessenger);
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateDebugUtilsMessengerEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordCreateDebugUtilsMessengerEXT(instance, pCreateInfo, pAllocator, pMessenger, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyDebugUtilsMessengerEXT(VkInstance instance, VkDebugUtilsMessengerEXT messenger,
                                                         const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyDebugUtilsMessengerEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyDebugUtilsMessengerEXT");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateDestroyDebugUtilsMessengerEXT(instance, messenger, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyDebugUtilsMessengerEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyDebugUtilsMessengerEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordDestroyDebugUtilsMessengerEXT(instance, messenger, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyDebugUtilsMessengerEXT");
        instance_dispatch->DestroyDebugUtilsMessengerEXT(instance, messenger, pAllocator);
    }
    LayerDestroyCallback(instance_dispatch->debug_report, messenger);
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyDebugUtilsMessengerEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordDestroyDebugUtilsMessengerEXT(instance, messenger, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL SubmitDebugUtilsMessageEXT(VkInstance instance, VkDebugUtilsMessageSeverityFlagBitsEXT messageSeverity,
                                                      VkDebugUtilsMessageTypeFlagsEXT messageTypes,
                                                      const VkDebugUtilsMessengerCallbackDataEXT* pCallbackData) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSubmitDebugUtilsMessageEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate_vkSubmitDebugUtilsMessageEXT");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |=
                vo->PreCallValidateSubmitDebugUtilsMessageEXT(instance, messageSeverity, messageTypes, pCallbackData, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkSubmitDebugUtilsMessageEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkSubmitDebugUtilsMessageEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordSubmitDebugUtilsMessageEXT(instance, messageSeverity, messageTypes, pCallbackData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkSubmitDebugUtilsMessageEXT");
        instance_dispatch->SubmitDebugUtilsMessageEXT(instance, messageSeverity, messageTypes, pCallbackData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkSubmitDebugUtilsMessageEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordSubmitDebugUtilsMessageEXT(instance, messageSeverity, messageTypes, pCallbackData, record_obj);
        }
    }
}

#ifdef VK_USE_PLATFORM_ANDROID_KHR
VKAPI_ATTR VkResult VKAPI_CALL GetAndroidHardwareBufferPropertiesANDROID(VkDevice device, const struct AHardwareBuffer* buffer,
                                                                         VkAndroidHardwareBufferPropertiesANDROID* pProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetAndroidHardwareBufferPropertiesANDROID,
                          VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetAndroidHardwareBufferPropertiesANDROID");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetAndroidHardwareBufferPropertiesANDROID]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetAndroidHardwareBufferPropertiesANDROID(device, buffer, pProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetAndroidHardwareBufferPropertiesANDROID);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetAndroidHardwareBufferPropertiesANDROID");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetAndroidHardwareBufferPropertiesANDROID]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetAndroidHardwareBufferPropertiesANDROID(device, buffer, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetAndroidHardwareBufferPropertiesANDROID");
        result = device_dispatch->GetAndroidHardwareBufferPropertiesANDROID(device, buffer, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetAndroidHardwareBufferPropertiesANDROID");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetAndroidHardwareBufferPropertiesANDROID]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetAndroidHardwareBufferPropertiesANDROID(device, buffer, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetMemoryAndroidHardwareBufferANDROID(VkDevice device,
                                                                     const VkMemoryGetAndroidHardwareBufferInfoANDROID* pInfo,
                                                                     struct AHardwareBuffer** pBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryAndroidHardwareBufferANDROID, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetMemoryAndroidHardwareBufferANDROID");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryAndroidHardwareBufferANDROID]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryAndroidHardwareBufferANDROID(device, pInfo, pBuffer, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryAndroidHardwareBufferANDROID);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetMemoryAndroidHardwareBufferANDROID");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryAndroidHardwareBufferANDROID]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryAndroidHardwareBufferANDROID(device, pInfo, pBuffer, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetMemoryAndroidHardwareBufferANDROID");
        result = device_dispatch->GetMemoryAndroidHardwareBufferANDROID(device, pInfo, pBuffer);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetMemoryAndroidHardwareBufferANDROID");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryAndroidHardwareBufferANDROID]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryAndroidHardwareBufferANDROID(device, pInfo, pBuffer, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_ENABLE_BETA_EXTENSIONS
VKAPI_ATTR VkResult VKAPI_CALL CreateExecutionGraphPipelinesAMDX(VkDevice device, VkPipelineCache pipelineCache,
                                                                 uint32_t createInfoCount,
                                                                 const VkExecutionGraphPipelineCreateInfoAMDX* pCreateInfos,
                                                                 const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateExecutionGraphPipelinesAMDX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateExecutionGraphPipelinesAMDX");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateExecutionGraphPipelinesAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateExecutionGraphPipelinesAMDX(device, pipelineCache, createInfoCount, pCreateInfos,
                                                                         pAllocator, pPipelines, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateExecutionGraphPipelinesAMDX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateExecutionGraphPipelinesAMDX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateExecutionGraphPipelinesAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateExecutionGraphPipelinesAMDX(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator,
                                                               pPipelines, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateExecutionGraphPipelinesAMDX");
        result = device_dispatch->CreateExecutionGraphPipelinesAMDX(device, pipelineCache, createInfoCount, pCreateInfos,
                                                                    pAllocator, pPipelines);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateExecutionGraphPipelinesAMDX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateExecutionGraphPipelinesAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateExecutionGraphPipelinesAMDX(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator,
                                                                pPipelines, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetExecutionGraphPipelineScratchSizeAMDX(VkDevice device, VkPipeline executionGraph,
                                                                        VkExecutionGraphPipelineScratchSizeAMDX* pSizeInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetExecutionGraphPipelineScratchSizeAMDX,
                          VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetExecutionGraphPipelineScratchSizeAMDX");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetExecutionGraphPipelineScratchSizeAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetExecutionGraphPipelineScratchSizeAMDX(device, executionGraph, pSizeInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetExecutionGraphPipelineScratchSizeAMDX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetExecutionGraphPipelineScratchSizeAMDX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetExecutionGraphPipelineScratchSizeAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetExecutionGraphPipelineScratchSizeAMDX(device, executionGraph, pSizeInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetExecutionGraphPipelineScratchSizeAMDX");
        result = device_dispatch->GetExecutionGraphPipelineScratchSizeAMDX(device, executionGraph, pSizeInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetExecutionGraphPipelineScratchSizeAMDX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetExecutionGraphPipelineScratchSizeAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetExecutionGraphPipelineScratchSizeAMDX(device, executionGraph, pSizeInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetExecutionGraphPipelineNodeIndexAMDX(VkDevice device, VkPipeline executionGraph,
                                                                      const VkPipelineShaderStageNodeCreateInfoAMDX* pNodeInfo,
                                                                      uint32_t* pNodeIndex) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetExecutionGraphPipelineNodeIndexAMDX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetExecutionGraphPipelineNodeIndexAMDX");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetExecutionGraphPipelineNodeIndexAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateGetExecutionGraphPipelineNodeIndexAMDX(device, executionGraph, pNodeInfo, pNodeIndex, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetExecutionGraphPipelineNodeIndexAMDX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetExecutionGraphPipelineNodeIndexAMDX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetExecutionGraphPipelineNodeIndexAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetExecutionGraphPipelineNodeIndexAMDX(device, executionGraph, pNodeInfo, pNodeIndex, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetExecutionGraphPipelineNodeIndexAMDX");
        result = device_dispatch->GetExecutionGraphPipelineNodeIndexAMDX(device, executionGraph, pNodeInfo, pNodeIndex);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetExecutionGraphPipelineNodeIndexAMDX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetExecutionGraphPipelineNodeIndexAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetExecutionGraphPipelineNodeIndexAMDX(device, executionGraph, pNodeInfo, pNodeIndex, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdInitializeGraphScratchMemoryAMDX(VkCommandBuffer commandBuffer, VkPipeline executionGraph,
                                                               VkDeviceAddress scratch, VkDeviceSize scratchSize) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdInitializeGraphScratchMemoryAMDX,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdInitializeGraphScratchMemoryAMDX");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdInitializeGraphScratchMemoryAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdInitializeGraphScratchMemoryAMDX(commandBuffer, executionGraph, scratch, scratchSize,
                                                                           error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdInitializeGraphScratchMemoryAMDX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdInitializeGraphScratchMemoryAMDX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdInitializeGraphScratchMemoryAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdInitializeGraphScratchMemoryAMDX(commandBuffer, executionGraph, scratch, scratchSize, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdInitializeGraphScratchMemoryAMDX");
        device_dispatch->CmdInitializeGraphScratchMemoryAMDX(commandBuffer, executionGraph, scratch, scratchSize);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdInitializeGraphScratchMemoryAMDX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdInitializeGraphScratchMemoryAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdInitializeGraphScratchMemoryAMDX(commandBuffer, executionGraph, scratch, scratchSize, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDispatchGraphAMDX(VkCommandBuffer commandBuffer, VkDeviceAddress scratch, VkDeviceSize scratchSize,
                                                const VkDispatchGraphCountInfoAMDX* pCountInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDispatchGraphAMDX, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDispatchGraphAMDX");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDispatchGraphAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDispatchGraphAMDX(commandBuffer, scratch, scratchSize, pCountInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDispatchGraphAMDX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDispatchGraphAMDX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDispatchGraphAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDispatchGraphAMDX(commandBuffer, scratch, scratchSize, pCountInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDispatchGraphAMDX");
        device_dispatch->CmdDispatchGraphAMDX(commandBuffer, scratch, scratchSize, pCountInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDispatchGraphAMDX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDispatchGraphAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDispatchGraphAMDX(commandBuffer, scratch, scratchSize, pCountInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDispatchGraphIndirectAMDX(VkCommandBuffer commandBuffer, VkDeviceAddress scratch,
                                                        VkDeviceSize scratchSize, const VkDispatchGraphCountInfoAMDX* pCountInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDispatchGraphIndirectAMDX,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDispatchGraphIndirectAMDX");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDispatchGraphIndirectAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDispatchGraphIndirectAMDX(commandBuffer, scratch, scratchSize, pCountInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDispatchGraphIndirectAMDX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDispatchGraphIndirectAMDX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDispatchGraphIndirectAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDispatchGraphIndirectAMDX(commandBuffer, scratch, scratchSize, pCountInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDispatchGraphIndirectAMDX");
        device_dispatch->CmdDispatchGraphIndirectAMDX(commandBuffer, scratch, scratchSize, pCountInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDispatchGraphIndirectAMDX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDispatchGraphIndirectAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDispatchGraphIndirectAMDX(commandBuffer, scratch, scratchSize, pCountInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDispatchGraphIndirectCountAMDX(VkCommandBuffer commandBuffer, VkDeviceAddress scratch,
                                                             VkDeviceSize scratchSize, VkDeviceAddress countInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDispatchGraphIndirectCountAMDX,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDispatchGraphIndirectCountAMDX");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDispatchGraphIndirectCountAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDispatchGraphIndirectCountAMDX(commandBuffer, scratch, scratchSize, countInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDispatchGraphIndirectCountAMDX);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDispatchGraphIndirectCountAMDX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDispatchGraphIndirectCountAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDispatchGraphIndirectCountAMDX(commandBuffer, scratch, scratchSize, countInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDispatchGraphIndirectCountAMDX");
        device_dispatch->CmdDispatchGraphIndirectCountAMDX(commandBuffer, scratch, scratchSize, countInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDispatchGraphIndirectCountAMDX");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDispatchGraphIndirectCountAMDX]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDispatchGraphIndirectCountAMDX(commandBuffer, scratch, scratchSize, countInfo, record_obj);
        }
    }
}

#endif  // VK_ENABLE_BETA_EXTENSIONS
VKAPI_ATTR void VKAPI_CALL CmdSetSampleLocationsEXT(VkCommandBuffer commandBuffer,
                                                    const VkSampleLocationsInfoEXT* pSampleLocationsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetSampleLocationsEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetSampleLocationsEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetSampleLocationsEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetSampleLocationsEXT(commandBuffer, pSampleLocationsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetSampleLocationsEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetSampleLocationsEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetSampleLocationsEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetSampleLocationsEXT(commandBuffer, pSampleLocationsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetSampleLocationsEXT");
        device_dispatch->CmdSetSampleLocationsEXT(commandBuffer, pSampleLocationsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetSampleLocationsEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetSampleLocationsEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetSampleLocationsEXT(commandBuffer, pSampleLocationsInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceMultisamplePropertiesEXT(VkPhysicalDevice physicalDevice, VkSampleCountFlagBits samples,
                                                                     VkMultisamplePropertiesEXT* pMultisampleProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceMultisamplePropertiesEXT,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceMultisamplePropertiesEXT");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceMultisamplePropertiesEXT(physicalDevice, samples, pMultisampleProperties,
                                                                                 error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceMultisamplePropertiesEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceMultisamplePropertiesEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceMultisamplePropertiesEXT(physicalDevice, samples, pMultisampleProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceMultisamplePropertiesEXT");
        instance_dispatch->GetPhysicalDeviceMultisamplePropertiesEXT(physicalDevice, samples, pMultisampleProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceMultisamplePropertiesEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceMultisamplePropertiesEXT(physicalDevice, samples, pMultisampleProperties,
                                                                        record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetImageDrmFormatModifierPropertiesEXT(VkDevice device, VkImage image,
                                                                      VkImageDrmFormatModifierPropertiesEXT* pProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageDrmFormatModifierPropertiesEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetImageDrmFormatModifierPropertiesEXT");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageDrmFormatModifierPropertiesEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageDrmFormatModifierPropertiesEXT(device, image, pProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageDrmFormatModifierPropertiesEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetImageDrmFormatModifierPropertiesEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageDrmFormatModifierPropertiesEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageDrmFormatModifierPropertiesEXT(device, image, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetImageDrmFormatModifierPropertiesEXT");
        result = device_dispatch->GetImageDrmFormatModifierPropertiesEXT(device, image, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetImageDrmFormatModifierPropertiesEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageDrmFormatModifierPropertiesEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageDrmFormatModifierPropertiesEXT(device, image, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdBindShadingRateImageNV(VkCommandBuffer commandBuffer, VkImageView imageView,
                                                     VkImageLayout imageLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindShadingRateImageNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBindShadingRateImageNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindShadingRateImageNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindShadingRateImageNV(commandBuffer, imageView, imageLayout, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindShadingRateImageNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBindShadingRateImageNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindShadingRateImageNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindShadingRateImageNV(commandBuffer, imageView, imageLayout, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBindShadingRateImageNV");
        device_dispatch->CmdBindShadingRateImageNV(commandBuffer, imageView, imageLayout);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBindShadingRateImageNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindShadingRateImageNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindShadingRateImageNV(commandBuffer, imageView, imageLayout, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetViewportShadingRatePaletteNV(VkCommandBuffer commandBuffer, uint32_t firstViewport,
                                                              uint32_t viewportCount,
                                                              const VkShadingRatePaletteNV* pShadingRatePalettes) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetViewportShadingRatePaletteNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetViewportShadingRatePaletteNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetViewportShadingRatePaletteNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetViewportShadingRatePaletteNV(commandBuffer, firstViewport, viewportCount,
                                                                          pShadingRatePalettes, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetViewportShadingRatePaletteNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetViewportShadingRatePaletteNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetViewportShadingRatePaletteNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetViewportShadingRatePaletteNV(commandBuffer, firstViewport, viewportCount, pShadingRatePalettes,
                                                                record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetViewportShadingRatePaletteNV");
        device_dispatch->CmdSetViewportShadingRatePaletteNV(commandBuffer, firstViewport, viewportCount, pShadingRatePalettes);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetViewportShadingRatePaletteNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetViewportShadingRatePaletteNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetViewportShadingRatePaletteNV(commandBuffer, firstViewport, viewportCount, pShadingRatePalettes,
                                                                 record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetCoarseSampleOrderNV(VkCommandBuffer commandBuffer, VkCoarseSampleOrderTypeNV sampleOrderType,
                                                     uint32_t customSampleOrderCount,
                                                     const VkCoarseSampleOrderCustomNV* pCustomSampleOrders) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetCoarseSampleOrderNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetCoarseSampleOrderNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetCoarseSampleOrderNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetCoarseSampleOrderNV(commandBuffer, sampleOrderType, customSampleOrderCount,
                                                                 pCustomSampleOrders, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetCoarseSampleOrderNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetCoarseSampleOrderNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetCoarseSampleOrderNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetCoarseSampleOrderNV(commandBuffer, sampleOrderType, customSampleOrderCount, pCustomSampleOrders,
                                                       record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetCoarseSampleOrderNV");
        device_dispatch->CmdSetCoarseSampleOrderNV(commandBuffer, sampleOrderType, customSampleOrderCount, pCustomSampleOrders);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetCoarseSampleOrderNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetCoarseSampleOrderNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetCoarseSampleOrderNV(commandBuffer, sampleOrderType, customSampleOrderCount, pCustomSampleOrders,
                                                        record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateAccelerationStructureNV(VkDevice device,
                                                             const VkAccelerationStructureCreateInfoNV* pCreateInfo,
                                                             const VkAllocationCallbacks* pAllocator,
                                                             VkAccelerationStructureNV* pAccelerationStructure) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateAccelerationStructureNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCreateAccelerationStructureNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateAccelerationStructureNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateAccelerationStructureNV(device, pCreateInfo, pAllocator, pAccelerationStructure,
                                                                     error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateAccelerationStructureNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCreateAccelerationStructureNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateAccelerationStructureNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateAccelerationStructureNV(device, pCreateInfo, pAllocator, pAccelerationStructure, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCreateAccelerationStructureNV");
        result = device_dispatch->CreateAccelerationStructureNV(device, pCreateInfo, pAllocator, pAccelerationStructure);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCreateAccelerationStructureNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateAccelerationStructureNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateAccelerationStructureNV(device, pCreateInfo, pAllocator, pAccelerationStructure, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyAccelerationStructureNV(VkDevice device, VkAccelerationStructureNV accelerationStructure,
                                                          const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyAccelerationStructureNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkDestroyAccelerationStructureNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyAccelerationStructureNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyAccelerationStructureNV(device, accelerationStructure, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyAccelerationStructureNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkDestroyAccelerationStructureNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyAccelerationStructureNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyAccelerationStructureNV(device, accelerationStructure, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkDestroyAccelerationStructureNV");
        device_dispatch->DestroyAccelerationStructureNV(device, accelerationStructure, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkDestroyAccelerationStructureNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyAccelerationStructureNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyAccelerationStructureNV(device, accelerationStructure, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetAccelerationStructureMemoryRequirementsNV(
    VkDevice device, const VkAccelerationStructureMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2KHR* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetAccelerationStructureMemoryRequirementsNV,
                          VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetAccelerationStructureMemoryRequirementsNV");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetAccelerationStructureMemoryRequirementsNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetAccelerationStructureMemoryRequirementsNV(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetAccelerationStructureMemoryRequirementsNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetAccelerationStructureMemoryRequirementsNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetAccelerationStructureMemoryRequirementsNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetAccelerationStructureMemoryRequirementsNV(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetAccelerationStructureMemoryRequirementsNV");
        device_dispatch->GetAccelerationStructureMemoryRequirementsNV(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetAccelerationStructureMemoryRequirementsNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetAccelerationStructureMemoryRequirementsNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetAccelerationStructureMemoryRequirementsNV(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL BindAccelerationStructureMemoryNV(VkDevice device, uint32_t bindInfoCount,
                                                                 const VkBindAccelerationStructureMemoryInfoNV* pBindInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindAccelerationStructureMemoryNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkBindAccelerationStructureMemoryNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindAccelerationStructureMemoryNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindAccelerationStructureMemoryNV(device, bindInfoCount, pBindInfos, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindAccelerationStructureMemoryNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkBindAccelerationStructureMemoryNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindAccelerationStructureMemoryNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindAccelerationStructureMemoryNV(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkBindAccelerationStructureMemoryNV");
        result = device_dispatch->BindAccelerationStructureMemoryNV(device, bindInfoCount, pBindInfos);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkBindAccelerationStructureMemoryNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindAccelerationStructureMemoryNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindAccelerationStructureMemoryNV(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdBuildAccelerationStructureNV(VkCommandBuffer commandBuffer,
                                                           const VkAccelerationStructureInfoNV* pInfo, VkBuffer instanceData,
                                                           VkDeviceSize instanceOffset, VkBool32 update,
                                                           VkAccelerationStructureNV dst, VkAccelerationStructureNV src,
                                                           VkBuffer scratch, VkDeviceSize scratchOffset) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBuildAccelerationStructureNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdBuildAccelerationStructureNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBuildAccelerationStructureNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBuildAccelerationStructureNV(commandBuffer, pInfo, instanceData, instanceOffset, update,
                                                                       dst, src, scratch, scratchOffset, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBuildAccelerationStructureNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdBuildAccelerationStructureNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBuildAccelerationStructureNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBuildAccelerationStructureNV(commandBuffer, pInfo, instanceData, instanceOffset, update, dst, src,
                                                             scratch, scratchOffset, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdBuildAccelerationStructureNV");
        device_dispatch->CmdBuildAccelerationStructureNV(commandBuffer, pInfo, instanceData, instanceOffset, update, dst, src,
                                                         scratch, scratchOffset);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdBuildAccelerationStructureNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBuildAccelerationStructureNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBuildAccelerationStructureNV(commandBuffer, pInfo, instanceData, instanceOffset, update, dst, src,
                                                              scratch, scratchOffset, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyAccelerationStructureNV(VkCommandBuffer commandBuffer, VkAccelerationStructureNV dst,
                                                          VkAccelerationStructureNV src, VkCopyAccelerationStructureModeKHR mode) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyAccelerationStructureNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdCopyAccelerationStructureNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyAccelerationStructureNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyAccelerationStructureNV(commandBuffer, dst, src, mode, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyAccelerationStructureNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdCopyAccelerationStructureNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyAccelerationStructureNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyAccelerationStructureNV(commandBuffer, dst, src, mode, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdCopyAccelerationStructureNV");
        device_dispatch->CmdCopyAccelerationStructureNV(commandBuffer, dst, src, mode);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdCopyAccelerationStructureNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyAccelerationStructureNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyAccelerationStructureNV(commandBuffer, dst, src, mode, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdTraceRaysNV(VkCommandBuffer commandBuffer, VkBuffer raygenShaderBindingTableBuffer,
                                          VkDeviceSize raygenShaderBindingOffset, VkBuffer missShaderBindingTableBuffer,
                                          VkDeviceSize missShaderBindingOffset, VkDeviceSize missShaderBindingStride,
                                          VkBuffer hitShaderBindingTableBuffer, VkDeviceSize hitShaderBindingOffset,
                                          VkDeviceSize hitShaderBindingStride, VkBuffer callableShaderBindingTableBuffer,
                                          VkDeviceSize callableShaderBindingOffset, VkDeviceSize callableShaderBindingStride,
                                          uint32_t width, uint32_t height, uint32_t depth) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdTraceRaysNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdTraceRaysNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdTraceRaysNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdTraceRaysNV(
                commandBuffer, raygenShaderBindingTableBuffer, raygenShaderBindingOffset, missShaderBindingTableBuffer,
                missShaderBindingOffset, missShaderBindingStride, hitShaderBindingTableBuffer, hitShaderBindingOffset,
                hitShaderBindingStride, callableShaderBindingTableBuffer, callableShaderBindingOffset, callableShaderBindingStride,
                width, height, depth, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdTraceRaysNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdTraceRaysNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdTraceRaysNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdTraceRaysNV(commandBuffer, raygenShaderBindingTableBuffer, raygenShaderBindingOffset,
                                            missShaderBindingTableBuffer, missShaderBindingOffset, missShaderBindingStride,
                                            hitShaderBindingTableBuffer, hitShaderBindingOffset, hitShaderBindingStride,
                                            callableShaderBindingTableBuffer, callableShaderBindingOffset,
                                            callableShaderBindingStride, width, height, depth, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdTraceRaysNV");
        device_dispatch->CmdTraceRaysNV(commandBuffer, raygenShaderBindingTableBuffer, raygenShaderBindingOffset,
                                        missShaderBindingTableBuffer, missShaderBindingOffset, missShaderBindingStride,
                                        hitShaderBindingTableBuffer, hitShaderBindingOffset, hitShaderBindingStride,
                                        callableShaderBindingTableBuffer, callableShaderBindingOffset, callableShaderBindingStride,
                                        width, height, depth);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdTraceRaysNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdTraceRaysNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdTraceRaysNV(commandBuffer, raygenShaderBindingTableBuffer, raygenShaderBindingOffset,
                                             missShaderBindingTableBuffer, missShaderBindingOffset, missShaderBindingStride,
                                             hitShaderBindingTableBuffer, hitShaderBindingOffset, hitShaderBindingStride,
                                             callableShaderBindingTableBuffer, callableShaderBindingOffset,
                                             callableShaderBindingStride, width, height, depth, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetRayTracingShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup,
                                                                  uint32_t groupCount, size_t dataSize, void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetRayTracingShaderGroupHandlesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetRayTracingShaderGroupHandlesKHR");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetRayTracingShaderGroupHandlesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetRayTracingShaderGroupHandlesKHR(device, pipeline, firstGroup, groupCount, dataSize, pData,
                                                                          error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetRayTracingShaderGroupHandlesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetRayTracingShaderGroupHandlesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetRayTracingShaderGroupHandlesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetRayTracingShaderGroupHandlesKHR(device, pipeline, firstGroup, groupCount, dataSize, pData,
                                                                record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetRayTracingShaderGroupHandlesKHR");
        result = device_dispatch->GetRayTracingShaderGroupHandlesKHR(device, pipeline, firstGroup, groupCount, dataSize, pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetRayTracingShaderGroupHandlesKHR");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetRayTracingShaderGroupHandlesKHR]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetRayTracingShaderGroupHandlesKHR(device, pipeline, firstGroup, groupCount, dataSize, pData,
                                                                 record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetRayTracingShaderGroupHandlesNV(VkDevice device, VkPipeline pipeline, uint32_t firstGroup,
                                                                 uint32_t groupCount, size_t dataSize, void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetRayTracingShaderGroupHandlesNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetRayTracingShaderGroupHandlesNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetRayTracingShaderGroupHandlesNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetRayTracingShaderGroupHandlesNV(device, pipeline, firstGroup, groupCount, dataSize, pData,
                                                                         error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetRayTracingShaderGroupHandlesNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetRayTracingShaderGroupHandlesNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetRayTracingShaderGroupHandlesNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetRayTracingShaderGroupHandlesNV(device, pipeline, firstGroup, groupCount, dataSize, pData,
                                                               record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetRayTracingShaderGroupHandlesNV");
        result = device_dispatch->GetRayTracingShaderGroupHandlesNV(device, pipeline, firstGroup, groupCount, dataSize, pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetRayTracingShaderGroupHandlesNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetRayTracingShaderGroupHandlesNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetRayTracingShaderGroupHandlesNV(device, pipeline, firstGroup, groupCount, dataSize, pData,
                                                                record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetAccelerationStructureHandleNV(VkDevice device, VkAccelerationStructureNV accelerationStructure,
                                                                size_t dataSize, void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetAccelerationStructureHandleNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetAccelerationStructureHandleNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetAccelerationStructureHandleNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetAccelerationStructureHandleNV(device, accelerationStructure, dataSize, pData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetAccelerationStructureHandleNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetAccelerationStructureHandleNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetAccelerationStructureHandleNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetAccelerationStructureHandleNV(device, accelerationStructure, dataSize, pData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetAccelerationStructureHandleNV");
        result = device_dispatch->GetAccelerationStructureHandleNV(device, accelerationStructure, dataSize, pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetAccelerationStructureHandleNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetAccelerationStructureHandleNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetAccelerationStructureHandleNV(device, accelerationStructure, dataSize, pData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdWriteAccelerationStructuresPropertiesNV(VkCommandBuffer commandBuffer,
                                                                      uint32_t accelerationStructureCount,
                                                                      const VkAccelerationStructureNV* pAccelerationStructures,
                                                                      VkQueryType queryType, VkQueryPool queryPool,
                                                                      uint32_t firstQuery) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWriteAccelerationStructuresPropertiesNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdWriteAccelerationStructuresPropertiesNV");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWriteAccelerationStructuresPropertiesNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWriteAccelerationStructuresPropertiesNV(
                commandBuffer, accelerationStructureCount, pAccelerationStructures, queryType, queryPool, firstQuery, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWriteAccelerationStructuresPropertiesNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdWriteAccelerationStructuresPropertiesNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWriteAccelerationStructuresPropertiesNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWriteAccelerationStructuresPropertiesNV(
                commandBuffer, accelerationStructureCount, pAccelerationStructures, queryType, queryPool, firstQuery, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdWriteAccelerationStructuresPropertiesNV");
        device_dispatch->CmdWriteAccelerationStructuresPropertiesNV(commandBuffer, accelerationStructureCount,
                                                                    pAccelerationStructures, queryType, queryPool, firstQuery);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdWriteAccelerationStructuresPropertiesNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWriteAccelerationStructuresPropertiesNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWriteAccelerationStructuresPropertiesNV(
                commandBuffer, accelerationStructureCount, pAccelerationStructures, queryType, queryPool, firstQuery, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CompileDeferredNV(VkDevice device, VkPipeline pipeline, uint32_t shader) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCompileDeferredNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCompileDeferredNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCompileDeferredNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCompileDeferredNV(device, pipeline, shader, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCompileDeferredNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCompileDeferredNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCompileDeferredNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCompileDeferredNV(device, pipeline, shader, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkCompileDeferredNV");
        result = device_dispatch->CompileDeferredNV(device, pipeline, shader);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkCompileDeferredNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCompileDeferredNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCompileDeferredNV(device, pipeline, shader, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetMemoryHostPointerPropertiesEXT(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType,
                                                                 const void* pHostPointer,
                                                                 VkMemoryHostPointerPropertiesEXT* pMemoryHostPointerProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryHostPointerPropertiesEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetMemoryHostPointerPropertiesEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryHostPointerPropertiesEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryHostPointerPropertiesEXT(device, handleType, pHostPointer,
                                                                         pMemoryHostPointerProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryHostPointerPropertiesEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetMemoryHostPointerPropertiesEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryHostPointerPropertiesEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryHostPointerPropertiesEXT(device, handleType, pHostPointer, pMemoryHostPointerProperties,
                                                               record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetMemoryHostPointerPropertiesEXT");
        result = device_dispatch->GetMemoryHostPointerPropertiesEXT(device, handleType, pHostPointer, pMemoryHostPointerProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetMemoryHostPointerPropertiesEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryHostPointerPropertiesEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryHostPointerPropertiesEXT(device, handleType, pHostPointer, pMemoryHostPointerProperties,
                                                                record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdWriteBufferMarkerAMD(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage,
                                                   VkBuffer dstBuffer, VkDeviceSize dstOffset, uint32_t marker) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWriteBufferMarkerAMD, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdWriteBufferMarkerAMD");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWriteBufferMarkerAMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdWriteBufferMarkerAMD(commandBuffer, pipelineStage, dstBuffer, dstOffset, marker, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWriteBufferMarkerAMD);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdWriteBufferMarkerAMD");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWriteBufferMarkerAMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWriteBufferMarkerAMD(commandBuffer, pipelineStage, dstBuffer, dstOffset, marker, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdWriteBufferMarkerAMD");
        device_dispatch->CmdWriteBufferMarkerAMD(commandBuffer, pipelineStage, dstBuffer, dstOffset, marker);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdWriteBufferMarkerAMD");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWriteBufferMarkerAMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWriteBufferMarkerAMD(commandBuffer, pipelineStage, dstBuffer, dstOffset, marker, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdWriteBufferMarker2AMD(VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkBuffer dstBuffer,
                                                    VkDeviceSize dstOffset, uint32_t marker) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWriteBufferMarker2AMD, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdWriteBufferMarker2AMD");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWriteBufferMarker2AMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWriteBufferMarker2AMD(commandBuffer, stage, dstBuffer, dstOffset, marker, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWriteBufferMarker2AMD);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdWriteBufferMarker2AMD");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWriteBufferMarker2AMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWriteBufferMarker2AMD(commandBuffer, stage, dstBuffer, dstOffset, marker, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdWriteBufferMarker2AMD");
        device_dispatch->CmdWriteBufferMarker2AMD(commandBuffer, stage, dstBuffer, dstOffset, marker);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdWriteBufferMarker2AMD");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWriteBufferMarker2AMD]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWriteBufferMarker2AMD(commandBuffer, stage, dstBuffer, dstOffset, marker, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice,
                                                                            uint32_t* pTimeDomainCount,
                                                                            VkTimeDomainKHR* pTimeDomains) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceCalibrateableTimeDomainsEXT,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            skip |= vo->PreCallValidateGetPhysicalDeviceCalibrateableTimeDomainsEXT(physicalDevice, pTimeDomainCount, pTimeDomains,
                                                                                    error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceCalibrateableTimeDomainsEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PreCallRecordGetPhysicalDeviceCalibrateableTimeDomainsEXT(physicalDevice, pTimeDomainCount, pTimeDomains,
                                                                          record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT");
        result = instance_dispatch->GetPhysicalDeviceCalibrateableTimeDomainsEXT(physicalDevice, pTimeDomainCount, pTimeDomains);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT");
        for (auto& vo : instance_dispatch->object_dispatch) {
            if (!vo) {
                continue;
            }
            vo->PostCallRecordGetPhysicalDeviceCalibrateableTimeDomainsEXT(physicalDevice, pTimeDomainCount, pTimeDomains,
                                                                           record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetCalibratedTimestampsEXT(VkDevice device, uint32_t timestampCount,
                                                          const VkCalibratedTimestampInfoKHR* pTimestampInfos,
                                                          uint64_t* pTimestamps, uint64_t* pMaxDeviation) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetCalibratedTimestampsEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetCalibratedTimestampsEXT");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetCalibratedTimestampsEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetCalibratedTimestampsEXT(device, timestampCount, pTimestampInfos, pTimestamps,
                                                                  pMaxDeviation, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetCalibratedTimestampsEXT);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetCalibratedTimestampsEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetCalibratedTimestampsEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetCalibratedTimestampsEXT(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation,
                                                        record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkGetCalibratedTimestampsEXT");
        result = device_dispatch->GetCalibratedTimestampsEXT(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetCalibratedTimestampsEXT");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetCalibratedTimestampsEXT]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetCalibratedTimestampsEXT(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation,
                                                         record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdDrawMeshTasksNV(VkCommandBuffer commandBuffer, uint32_t taskCount, uint32_t firstTask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawMeshTasksNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDrawMeshTasksNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawMeshTasksNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawMeshTasksNV(commandBuffer, taskCount, firstTask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawMeshTasksNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDrawMeshTasksNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawMeshTasksNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawMeshTasksNV(commandBuffer, taskCount, firstTask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDrawMeshTasksNV");
        device_dispatch->CmdDrawMeshTasksNV(commandBuffer, taskCount, firstTask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDrawMeshTasksNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawMeshTasksNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawMeshTasksNV(commandBuffer, taskCount, firstTask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawMeshTasksIndirectNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                      uint32_t drawCount, uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawMeshTasksIndirectNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDrawMeshTasksIndirectNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawMeshTasksIndirectNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawMeshTasksIndirectNV(commandBuffer, buffer, offset, drawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawMeshTasksIndirectNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDrawMeshTasksIndirectNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawMeshTasksIndirectNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawMeshTasksIndirectNV(commandBuffer, buffer, offset, drawCount, stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDrawMeshTasksIndirectNV");
        device_dispatch->CmdDrawMeshTasksIndirectNV(commandBuffer, buffer, offset, drawCount, stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDrawMeshTasksIndirectNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawMeshTasksIndirectNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawMeshTasksIndirectNV(commandBuffer, buffer, offset, drawCount, stride, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawMeshTasksIndirectCountNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                           VkBuffer countBuffer, VkDeviceSize countBufferOffset,
                                                           uint32_t maxDrawCount, uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawMeshTasksIndirectCountNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdDrawMeshTasksIndirectCountNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawMeshTasksIndirectCountNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawMeshTasksIndirectCountNV(commandBuffer, buffer, offset, countBuffer,
                                                                       countBufferOffset, maxDrawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawMeshTasksIndirectCountNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdDrawMeshTasksIndirectCountNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawMeshTasksIndirectCountNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawMeshTasksIndirectCountNV(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                             maxDrawCount, stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdDrawMeshTasksIndirectCountNV");
        device_dispatch->CmdDrawMeshTasksIndirectCountNV(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                         maxDrawCount, stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdDrawMeshTasksIndirectCountNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawMeshTasksIndirectCountNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawMeshTasksIndirectCountNV(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                              maxDrawCount, stride, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetExclusiveScissorEnableNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor,
                                                          uint32_t exclusiveScissorCount,
                                                          const VkBool32* pExclusiveScissorEnables) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetExclusiveScissorEnableNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetExclusiveScissorEnableNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetExclusiveScissorEnableNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetExclusiveScissorEnableNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount,
                                                                      pExclusiveScissorEnables, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetExclusiveScissorEnableNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetExclusiveScissorEnableNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetExclusiveScissorEnableNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetExclusiveScissorEnableNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount,
                                                            pExclusiveScissorEnables, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetExclusiveScissorEnableNV");
        device_dispatch->CmdSetExclusiveScissorEnableNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount,
                                                        pExclusiveScissorEnables);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetExclusiveScissorEnableNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetExclusiveScissorEnableNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetExclusiveScissorEnableNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount,
                                                             pExclusiveScissorEnables, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetExclusiveScissorNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor,
                                                    uint32_t exclusiveScissorCount, const VkRect2D* pExclusiveScissors) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetExclusiveScissorNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetExclusiveScissorNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetExclusiveScissorNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetExclusiveScissorNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount,
                                                                pExclusiveScissors, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetExclusiveScissorNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetExclusiveScissorNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetExclusiveScissorNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetExclusiveScissorNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount,
                                                      pExclusiveScissors, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetExclusiveScissorNV");
        device_dispatch->CmdSetExclusiveScissorNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount, pExclusiveScissors);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetExclusiveScissorNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetExclusiveScissorNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetExclusiveScissorNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount,
                                                       pExclusiveScissors, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetCheckpointNV(VkCommandBuffer commandBuffer, const void* pCheckpointMarker) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetCheckpointNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate_vkCmdSetCheckpointNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetCheckpointNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetCheckpointNV(commandBuffer, pCheckpointMarker, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetCheckpointNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkCmdSetCheckpointNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetCheckpointNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetCheckpointNV(commandBuffer, pCheckpointMarker, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkCmdSetCheckpointNV");
        device_dispatch->CmdSetCheckpointNV(commandBuffer, pCheckpointMarker);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkCmdSetCheckpointNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetCheckpointNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetCheckpointNV(commandBuffer, pCheckpointMarker, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetQueueCheckpointDataNV(VkQueue queue, uint32_t* pCheckpointDataCount,
                                                    VkCheckpointDataNV* pCheckpointData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetQueueCheckpointDataNV, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetQueueCheckpointDataNV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetQueueCheckpointDataNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetQueueCheckpointDataNV(queue, pCheckpointDataCount, pCheckpointData, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetQueueCheckpointDataNV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetQueueCheckpointDataNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetQueueCheckpointDataNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetQueueCheckpointDataNV(queue, pCheckpointDataCount, pCheckpointData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetQueueCheckpointDataNV");
        device_dispatch->GetQueueCheckpointDataNV(queue, pCheckpointDataCount, pCheckpointData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetQueueCheckpointDataNV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetQueueCheckpointDataNV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetQueueCheckpointDataNV(queue, pCheckpointDataCount, pCheckpointData, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetQueueCheckpointData2NV(VkQueue queue, uint32_t* pCheckpointDataCount,
                                                     VkCheckpointData2NV* pCheckpointData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetQueueCheckpointData2NV, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate_vkGetQueueCheckpointData2NV");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetQueueCheckpointData2NV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetQueueCheckpointData2NV(queue, pCheckpointDataCount, pCheckpointData, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetQueueCheckpointData2NV);
    {
        VVL_ZoneScopedN("PreCallRecord_vkGetQueueCheckpointData2NV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetQueueCheckpointData2NV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetQueueCheckpointData2NV(queue, pCheckpointDataCount, pCheckpointData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch_vkGetQueueCheckpointData2NV");
        device_dispatch->GetQueueCheckpointData2NV(queue, pCheckpointDataCount, pCheckpointData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord_vkGetQueueCheckpointData2NV");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetQueueCheckpointData2NV]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetQueueCheckpointData2NV(queue, pCheckpointDataCount, pCheckpointData, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL InitializePerformanceApiINTEL(VkDevice device,
                                                             const VkInitializePerformanceApiInfoINTEL* pInitializeInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkInitializePerformanceApiINTEL, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkInitializePerformanceApiINTEL");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateInitializePerformanceApiINTEL]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateInitializePerformanceApiINTEL(device, pInitializeInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkInitializePerformanceApiINTEL);
    {
        VVL_ZoneScopedN("PreCallRecord_vkInitializePerformanceApiINTEL");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordInitializePerformanceApiINTEL]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PreCallRecordInitializePerformanceApiINTEL(device, pInitializeInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch_vkInitializePerformanceApiINTEL");
        result = device_dispatch->InitializePerformanceApiINTEL(device, pInitializeInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord_vkInitializePerformanceApiINTEL");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordInitializePerformanceApiINTEL]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->WriteLock();
            vo->PostCallRecordInitializePerformanceApiINTEL(device, pInitializeInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL UninitializePerformanceApiINTEL(VkDevice device) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUninitializePerformanceApiINTEL, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate_vkUninitializePerformanceApiINTEL");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUninitializePerformanceApiINTEL]) {
            if (!vo) {
                continue;
            }
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUninitializePerformanceApiINTEL(device, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkUninitializePerformanceApiINTEL);
    {
        VVL_ZoneScopedN("PreCallRecord_vkUninitializePerformanceApiINTEL");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUninitializePerformanceApiINTEL]) {
            if (!vo) {