/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import java.awt.Point;
import javax.vecmath.Tuple3f;
import org.j3d.terrain.TerrainData;
import org.j3d.terrain.roam.QueueManager;
import org.j3d.terrain.roam.TreeNode;
import org.j3d.terrain.roam.VarianceTree;
import org.j3d.terrain.roam.VertexData;
import org.j3d.util.frustum.ViewFrustum;

public abstract class ROAMPatch {
    protected final int PATCH_SIZE;
    protected TreeNode NWTree;
    protected TreeNode SETree;
    private VarianceTree NWVariance;
    private VarianceTree SEVariance;
    private int xOrigin;
    private int yOrigin;
    private int patchX;
    private int patchY;
    protected Point tileOrigin;
    protected TerrainData terrainData;
    protected ViewFrustum viewFrustum;
    private ROAMPatch northNeighbour;
    private ROAMPatch southNeighbour;
    private ROAMPatch eastNeighbour;
    private ROAMPatch westNeighbour;
    protected VertexData vertexData;
    protected float maxY;
    protected float minY;
    protected boolean resetRequested;
    private boolean firstUse;

    protected ROAMPatch(TerrainData terrainData, int n, ViewFrustum viewFrustum, int n2, int n3) {
        this.PATCH_SIZE = n;
        this.terrainData = terrainData;
        this.viewFrustum = viewFrustum;
        this.patchX = n2;
        this.patchY = n3;
        this.firstUse = false;
        this.tileOrigin = new Point();
    }

    void setView(Tuple3f tuple3f, ViewFrustum viewFrustum, QueueManager queueManager) {
        if (this.NWTree == null) {
            return;
        }
        this.viewFrustum = viewFrustum;
        try {
            this.NWTree.updateTree(tuple3f, viewFrustum, this.NWVariance, -1, queueManager);
        }
        catch (RuntimeException runtimeException) {
            System.out.println("NW tree " + this.hashCode());
        }
        try {
            this.SETree.updateTree(tuple3f, viewFrustum, this.SEVariance, -1, queueManager);
        }
        catch (RuntimeException runtimeException) {
            System.out.println("NW tree " + this.hashCode());
        }
    }

    public abstract void updateGeometry();

    public void clear() {
        this.resetRequested = true;
        this.vertexData.reset();
        this.NWTree.freeNode();
        this.SETree.freeNode();
        this.NWTree = null;
        this.SETree = null;
        this.setNorthNeighbour(null);
        this.setSouthNeighbour(null);
        this.setEastNeighbour(null);
        this.setWestNeighbour(null);
    }

    protected void setOrigin(int n, int n2) {
        this.tileOrigin.x = n / this.PATCH_SIZE;
        this.tileOrigin.y = n2 / this.PATCH_SIZE;
        this.xOrigin = n;
        this.yOrigin = n2;
        int n3 = this.yOrigin + this.PATCH_SIZE;
        int n4 = this.xOrigin + this.PATCH_SIZE;
        this.NWVariance = new VarianceTree(this.terrainData, this.PATCH_SIZE, this.xOrigin, this.yOrigin, n4, n3, this.xOrigin, n3);
        this.SEVariance = new VarianceTree(this.terrainData, this.PATCH_SIZE, n4, n3, this.xOrigin, this.yOrigin, n4, this.yOrigin);
        this.NWTree = TreeNode.getTreeNode();
        this.SETree = TreeNode.getTreeNode();
        this.NWTree.newNode(this.xOrigin, this.yOrigin, n4, n3, this.xOrigin, n3, 1, this.terrainData, this.viewFrustum, -1, 1, this.NWVariance, this.patchX, this.patchY);
        this.SETree.newNode(n4, n3, this.xOrigin, this.yOrigin, n4, this.yOrigin, 1, this.terrainData, this.viewFrustum, -1, 1, this.SEVariance, this.patchX, this.patchY);
        this.maxY = Math.max(this.NWVariance.getMaxY(), this.SEVariance.getMaxY());
        this.minY = Math.min(this.NWVariance.getMinY(), this.SEVariance.getMinY());
        this.NWTree.baseNeighbour = this.SETree;
        this.SETree.baseNeighbour = this.NWTree;
    }

    void reset() {
        this.NWTree.reset(this.viewFrustum);
        this.SETree.reset(this.viewFrustum);
        this.NWTree.baseNeighbour = this.SETree;
        this.SETree.baseNeighbour = this.NWTree;
    }

    void setNorthNeighbour(ROAMPatch rOAMPatch) {
        this.northNeighbour = rOAMPatch;
    }

    void setSouthNeighbour(ROAMPatch rOAMPatch) {
        this.southNeighbour = rOAMPatch;
        if (this.southNeighbour != null) {
            this.SETree.rightNeighbour = this.southNeighbour.NWTree;
            this.southNeighbour.NWTree.rightNeighbour = this.SETree;
        }
    }

    void setEastNeighbour(ROAMPatch rOAMPatch) {
        this.eastNeighbour = rOAMPatch;
    }

    void setWestNeighbour(ROAMPatch rOAMPatch) {
        this.westNeighbour = rOAMPatch;
        if (this.westNeighbour != null) {
            this.NWTree.leftNeighbour = this.westNeighbour.SETree;
            this.westNeighbour.SETree.leftNeighbour = this.NWTree;
        }
    }

    void updateEdges(Tuple3f tuple3f, QueueManager queueManager) {
        int n = -1;
        int n2 = -1;
        if (this.southNeighbour != null) {
            while (n != 0 && n2 != 0) {
                n2 = this.SETree.edgeSplit(this.southNeighbour.NWTree, 3, tuple3f, this.viewFrustum, queueManager);
                n = this.southNeighbour.NWTree.edgeSplit(this.SETree, 2, tuple3f, this.viewFrustum, queueManager);
            }
        }
        if (this.northNeighbour != null) {
            n = -1;
            n2 = -1;
            while (n != 0 && n2 != 0) {
                n2 = this.NWTree.edgeSplit(this.northNeighbour.SETree, 2, tuple3f, this.viewFrustum, queueManager);
                n = this.northNeighbour.SETree.edgeSplit(this.NWTree, 3, tuple3f, this.viewFrustum, queueManager);
            }
        }
        if (this.eastNeighbour != null) {
            n = -1;
            n2 = -1;
            while (n != 0 && n2 != 0) {
                n2 = this.SETree.edgeSplit(this.eastNeighbour.NWTree, 2, tuple3f, this.viewFrustum, queueManager);
                n = this.eastNeighbour.NWTree.edgeSplit(this.SETree, 3, tuple3f, this.viewFrustum, queueManager);
            }
        }
        if (this.westNeighbour != null) {
            n = -1;
            n2 = -1;
            while (n != 0 && n2 != 0) {
                n2 = this.NWTree.edgeSplit(this.westNeighbour.SETree, 3, tuple3f, this.viewFrustum, queueManager);
                n = this.westNeighbour.SETree.edgeSplit(this.NWTree, 2, tuple3f, this.viewFrustum, queueManager);
            }
        }
    }

    void makeActive() {
        this.resetRequested = false;
    }

    Point getTileOrigin() {
        return this.tileOrigin;
    }

    int getTriangleCount() {
        return this.vertexData.getVertexCount() / 3;
    }

    protected void createGeometry() {
        this.vertexData.reset();
        if (this.NWTree.visible != 2) {
            this.NWTree.getTriangles(this.vertexData);
        }
        if (this.SETree.visible != 2) {
            this.SETree.getTriangles(this.vertexData);
        }
    }

    public String toString2() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.westNeighbour != null) {
            stringBuffer.append(this.westNeighbour.hashCode());
        } else {
            stringBuffer.append("-1");
        }
        stringBuffer.append(',');
        if (this.southNeighbour != null) {
            stringBuffer.append(this.southNeighbour.hashCode());
        } else {
            stringBuffer.append("-1");
        }
        return stringBuffer.toString();
    }
}

