/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import org.ietf.uri.URIUtils;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.NodeTemplateToInstanceCreator;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.lang.VRMLNodeTemplate;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.proto.ExternalPrototypeDecl;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.renderer.CRProtoCreator;
import org.web3d.vrml.renderer.CRProtoInstance;
import org.web3d.vrml.renderer.EPDInstanceEntry;
import org.web3d.vrml.util.URLChecker;

public abstract class CRExternPrototypeDecl
extends ExternalPrototypeDecl {
    private static final String CHANGE_URL_MSG = "ExternProto's cannot change URL at runtime";
    private static HashSet validVrmlTypes = new HashSet();
    private static HashSet validX3DTypes = new HashSet();
    protected VRMLNodeTemplate proto;
    protected boolean inSetup = true;
    protected String[] vfUrl;
    protected String worldURL;
    protected int loadState;
    protected VRMLNodeFactory nodeFactory;
    protected ArrayList instanceList;
    protected ArrayList wrInstances;
    protected String uriRef = null;
    protected FrameStateManager stateManager;
    protected ErrorReporter errorReporter;

    public CRExternPrototypeDecl(String string, VRMLNodeFactory vRMLNodeFactory, int n, int n2, NodeTemplateToInstanceCreator nodeTemplateToInstanceCreator) {
        super(string, n, n2, nodeTemplateToInstanceCreator);
        this.nodeFactory = vRMLNodeFactory;
        this.instanceList = new ArrayList();
        this.wrInstances = new ArrayList();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public void addInstance(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2) {
        this.instanceList.add(new EPDInstanceEntry(vRMLNodeType, n, vRMLNodeType2));
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
    }

    public VRMLNodeTemplate getProtoDefinition() {
        return this.proto;
    }

    public int getLoadState() {
        return this.loadState;
    }

    public void setLoadState(int n) {
        this.loadState = n;
    }

    public void setWorldUrl(String string) {
        if (string == null) {
            return;
        }
        this.worldURL = string.charAt(string.length() - 1) != '/' ? string + '/' : string;
        if (this.vfUrl != null) {
            URLChecker.checkURLsInPlace(this.worldURL, this.vfUrl, false);
        }
    }

    public String getWorldUrl() {
        return this.worldURL;
    }

    public boolean checkValidContentType(String string) {
        if (this.isVrml97) {
            return validVrmlTypes.contains(string);
        }
        return validX3DTypes.contains(string);
    }

    public void setLoadedURI(String string) {
        String[] stringArray = URIUtils.stripFile(string);
        this.uriRef = stringArray[2];
        int n = stringArray[0].lastIndexOf("/");
        this.worldURL = stringArray[0].substring(0, n);
    }

    public void setUrl(String[] stringArray, int n) {
        if (!this.inSetup) {
            throw new RuntimeException(CHANGE_URL_MSG);
        }
        this.vfUrl = stringArray;
    }

    public String[] getUrl() {
        return this.vfUrl;
    }

    protected void finishSetContent(PrototypeDecl prototypeDecl, CRProtoCreator cRProtoCreator, VRMLExecutionSpace vRMLExecutionSpace) {
        this.proto = prototypeDecl;
        EPDInstanceEntry[] ePDInstanceEntryArray = new EPDInstanceEntry[this.instanceList.size()];
        this.instanceList.toArray(ePDInstanceEntryArray);
        for (int i = 0; i < ePDInstanceEntryArray.length; ++i) {
            CRProtoInstance cRProtoInstance = (CRProtoInstance)ePDInstanceEntryArray[i].instance;
            VRMLNodeType vRMLNodeType = ePDInstanceEntryArray[i].parent;
            cRProtoCreator.fillinInstance(prototypeDecl, cRProtoInstance, vRMLExecutionSpace);
            cRProtoInstance.setupFinished();
            if (vRMLNodeType != null) {
                vRMLNodeType.notifyExternProtoLoaded(ePDInstanceEntryArray[i].idx, cRProtoInstance);
            }
            this.wrInstances.add(new WeakReference<CRProtoInstance>(cRProtoInstance));
        }
        this.instanceList.clear();
    }

    static {
        validVrmlTypes.add("model/vrml");
        validVrmlTypes.add("x-world/x-vrml");
        validX3DTypes.add("model/x3d+vrml");
        validX3DTypes.add("model/x3d+xml");
        validX3DTypes.add("model/x3d+binary");
    }
}

