/* dpssysnames.c -- system name table
 *
 * (c) Copyright 1988-1994 Adobe Systems Incorporated.
 * All rights reserved.
 * 
 * Permission to use, copy, modify, distribute, and sublicense this software
 * and its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notices appear in all copies and that
 * both those copyright notices and this permission notice appear in
 * supporting documentation and that the name of Adobe Systems Incorporated
 * not be used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  No trademark license
 * to use the Adobe trademarks is hereby granted.  If the Adobe trademark
 * "Display PostScript"(tm) is used to describe this software, its
 * functionality or for any other purpose, such use shall be limited to a
 * statement that this software works in conjunction with the Display
 * PostScript system.  Proper trademark attribution to reflect Adobe's
 * ownership of the trademark shall be given whenever any such reference to
 * the Display PostScript system is made.
 * 
 * ADOBE MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE SOFTWARE FOR
 * ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 * ADOBE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON- INFRINGEMENT OF THIRD PARTY RIGHTS.  IN NO EVENT SHALL ADOBE BE LIABLE
 * TO YOU OR ANY OTHER PARTY FOR ANY SPECIAL, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE, STRICT LIABILITY OR ANY OTHER ACTION ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.  ADOBE WILL NOT
 * PROVIDE ANY TRAINING OR OTHER SUPPORT FOR THE SOFTWARE.
 * 
 * Adobe, PostScript, and Display PostScript are trademarks of Adobe Systems
 * Incorporated which may be registered in certain jurisdictions
 * 
 * Author:  Adobe Systems Incorporated
 */

#include "publictypes.h"
#include "DPS/dpsclient.h"
#include "dpsprivate.h"

char **DPSSysNames;
char **DPSSysNamesAux;

static char *sysNames[] = {
    "abs",
    "add",
    "aload",
    "anchorsearch",
    "and",
    "arc",
    "arcn",
    "arct",
    "arcto",
    "array",
    "ashow",
    "astore",
    "awidthshow",
    "begin",
    "bind",
    "bitshift",
    "ceiling",
    "charpath",
    "clear",
    "cleartomark",
    "clip",
    "clippath",
    "closepath",
    "concat",
    "concatmatrix",
    "copy",
    "count",
    "counttomark",
    "currentcmykcolor",
    "currentdash",
    "currentdict",
    "currentfile",
    "currentfont",
    "currentgray",
    "currentgstate",
    "currenthsbcolor",
    "currentlinecap",
    "currentlinejoin",
    "currentlinewidth",
    "currentmatrix",
    "currentpoint",
    "currentrgbcolor",
    "currentshared",
    "curveto",
    "cvi",
    "cvlit",
    "cvn",
    "cvr",
    "cvrs",
    "cvs",
    "cvx",
    "def",
    "defineusername",
    "dict",
    "div",
    "dtransform",
    "dup",
    "end",
    "eoclip",
    "eofill",
    "eoviewclip",
    "eq",
    "exch",
    "exec",
    "exit",
    "file",
    "fill",
    "findfont",
    "flattenpath",
    "floor",
    "flush",
    "flushfile",
    "for",
    "forall",
    "ge",
    "get",
    "getinterval",
    "grestore",
    "gsave",
    "gstate",
    "gt",
    "identmatrix",
    "idiv",
    "idtransform",
    "if",
    "ifelse",
    "image",
    "imagemask",
    "index",
    "ineofill",
    "infill",
    "initviewclip",
    "inueofill",
    "inufill",
    "invertmatrix",
    "itransform",
    "known",
    "le",
    "length",
    "lineto",
    "load",
    "loop",
    "lt",
    "makefont",
    "matrix",
    "maxlength",
    "mod",
    "moveto",
    "mul",
    "ne",
    "neg",
    "newpath",
    "not",
    "null",
    "or",
    "pathbbox",
    "pathforall",
    "pop",
    "print",
    "printobject",
    "put",
    "putinterval",
    "rcurveto",
    "read",
    "readhexstring",
    "readline",
    "readstring",
    "rectclip",
    "rectfill",
    "rectstroke",
    "rectviewclip",
    "repeat",
    "restore",
    "rlineto",
    "rmoveto",
    "roll",
    "rotate",
    "round",
    "save",
    "scale",
    "scalefont",
    "search",
    "selectfont",
    "setbbox",
    "setcachedevice",
    "setcachedevice2",
    "setcharwidth",
    "setcmykcolor",
    "setdash",
    "setfont",
    "setgray",
    "setgstate",
    "sethsbcolor",
    "setlinecap",
    "setlinejoin",
    "setlinewidth",
    "setmatrix",
    "setrgbcolor",
    "setshared",
    "shareddict",
    "show",
    "showpage",
    "stop",
    "stopped",
    "store",
    "string",
    "stringwidth",
    "stroke",
    "strokepath",
    "sub",
    "systemdict",
    "token",
    "transform",
    "translate",
    "truncate",
    "type",
    "uappend",
    "ucache",
    "ueofill",
    "ufill",
    "undef",
    "upath",
    "userdict",
    "ustroke",
    "viewclip",
    "viewclippath",
    "where",
    "widthshow",
    "write",
    "writehexstring",
    "writeobject",
    "writestring",
    "wtranslation",
    "xor",
    "xshow",
    "xyshow",
    "yshow",
    "FontDirectory",
    "SharedFontDirectory",
    "Courier",
    "Courier-Bold",
    "Courier-BoldOblique",
    "Courier-Oblique",
    "Helvetica",
    "Helvetica-Bold",
    "Helvetica-BoldOblique",
    "Helvetica-Oblique",
    "Symbol",
    "Times-Bold",
    "Times-BoldItalic",
    "Times-Italic",
    "Times-Roman",
    "execuserobject",			/* 212 */
    ""
};

static char *sysNamesAux[] = {
    "=",				/* 256 */
    "==",
    "ISOLatin1Encoding",
    "StandardEncoding",
    "[",
    "]",
    "atan",
    "banddevice",
    "bytesavailable",
    "cachestatus",
    "closefile",
    "colorimage",
    "condition",
    "copypage",
    "cos",
    "countdictstack",
    "countexecstack",
    "cshow",
    "currentblackgeneration",
    "currentcacheparams",
    "currentcolorscreen",
    "currentcolortransfer",
    "currentcontext",
    "currentflat",
    "currenthalftone",
    "currenthalftonephase",
    "currentmiterlimit",
    "currentobjectformat",
    "currentpacking",
    "currentscreen",
    "currentstrokeadjust",
    "currenttransfer",
    "currentundercolorremoval",
    "defaultmatrix",
    "definefont",
    "deletefile",
    "detach",
    "deviceinfo",
    "dictstack",
    "echo",
    "erasepage",
    "errordict",
    "execstack",
    "executeonly",
    "exp",
    "false",
    "filenameforall",
    "fileposition",
    "fork",
    "framedevice",
    "grestoreall",
    "handleerror",
    "initclip",
    "initgraphics",
    "initmatrix",
    "instroke",
    "inustroke",
    "join",
    "kshow",
    "ln",
    "lock",
    "log",
    "mark",
    "monitor",
    "noaccess",
    "notify",
    "nulldevice",
    "packedarray",
    "quit",
    "rand",
    "rcheck",
    "readonly",
    "realtime",
    "renamefile",
    "renderbands",
    "resetfile",
    "reversepath",
    "rootfont",
    "rrand",
    "run",
    "scheck",
    "setblackgeneration",
    "setcachelimit",
    "setcacheparams",
    "setcolorscreen",
    "setcolortransfer",
    "setfileposition",
    "setflat",
    "sethalftone",
    "sethalftonephase",
    "setmiterlimit",
    "setobjectformat",
    "setpacking",
    "setscreen",
    "setstrokeadjust",
    "settransfer",
    "setucacheparams",
    "setundercolorremoval",
    "sin",
    "sqrt",
    "srand",
    "stack",
    "status",
    "statusdict",
    "true",
    "ucachestatus",
    "undefinefont",
    "usertime",
    "ustrokepath",
    "version",
    "vmreclaim",
    "vmstatus",
    "wait",
    "wcheck",
    "xcheck",
    "yield",
    "defineuserobject",
    "undefineuserobject",
    "UserObjects",
    "cleardictstack",
    "A",				/* 376 */
    "B",
    "C",
    "D",
    "E",
    "F",
    "G",
    "H",
    "I",
    "J",
    "K",
    "L",
    "M",
    "N",
    "O",
    "P",
    "Q",
    "R",
    "S",
    "T",
    "U",
    "V",
    "W",
    "X",
    "Y",
    "Z",
    "a",
    "b",
    "c",
    "d",
    "e",
    "f",
    "g",
    "h",
    "i",
    "j",
    "k",
    "l",
    "m",
    "n",
    "o",
    "p",
    "q",
    "r",
    "s",
    "t",
    "u",
    "v",
    "w",
    "x",
    "y",
    "z",				/* 427 */
    "setvmthreshold",			/* 428 */
    "<<",				/* 429 */
    ">>",				/* 430 */
    ""
};

void DPSInitSysNames() {
  DPSSysNames = (char **)sysNames;
  DPSSysNamesAux = (char **)sysNamesAux;
  }
