/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.opensolaris.os.dtrace.InterfaceAttributes;

public final class ProgramInfo
implements Serializable {
    static final long serialVersionUID = 663862981171935056L;
    private final InterfaceAttributes minimumProbeAttributes;
    private final InterfaceAttributes minimumStatementAttributes;
    private final int matchingProbeCount;

    public ProgramInfo(InterfaceAttributes minProbeAttr, InterfaceAttributes minStatementAttr, int matchingProbes) {
        this.minimumProbeAttributes = minProbeAttr;
        this.minimumStatementAttributes = minStatementAttr;
        this.matchingProbeCount = matchingProbes;
        this.validate();
    }

    private final void validate() {
        if (this.minimumProbeAttributes == null) {
            throw new NullPointerException("minimumProbeAttributes is null");
        }
        if (this.minimumStatementAttributes == null) {
            throw new NullPointerException("minimumStatementAttributes is null");
        }
        if (this.matchingProbeCount < 0) {
            throw new IllegalArgumentException("matchingProbeCount is negative");
        }
    }

    public InterfaceAttributes getMinimumProbeAttributes() {
        return this.minimumProbeAttributes;
    }

    public InterfaceAttributes getMinimumStatementAttributes() {
        return this.minimumStatementAttributes;
    }

    public int getMatchingProbeCount() {
        return this.matchingProbeCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProgramInfo) {
            ProgramInfo i = (ProgramInfo)o;
            return this.minimumProbeAttributes.equals(i.minimumProbeAttributes) && this.minimumStatementAttributes.equals(i.minimumStatementAttributes) && this.matchingProbeCount == i.matchingProbeCount;
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.minimumProbeAttributes.hashCode();
        hash = 37 * hash + this.minimumStatementAttributes.hashCode();
        hash = 37 * hash + this.matchingProbeCount;
        return hash;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(ProgramInfo.class.getName());
        buf.append("[minimumProbeAttributes = ");
        buf.append(this.minimumProbeAttributes);
        buf.append(", minimumStatementAttributes = ");
        buf.append(this.minimumStatementAttributes);
        buf.append(", matchingProbeCount = ");
        buf.append(this.matchingProbeCount);
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(ProgramInfo.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"minimumProbeAttributes", "minimumStatementAttributes", "matchingProbeCount"}){

                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }
}

